/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.securitygatemanagement.SgManageVisitorGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sgmanagevisitorgrid',
	store: 'sgvisitor.SgManageVisitorStore',
	title: getServiceRequestTranslation('LIST_OF_VISITOR'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sgvisitormangementstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'sgvisitor.SgManageVisitorStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getCommonTranslation('PRINT_DOCUMENTS'),
			itemId:'printDocuments'
		}],
		listeners: { click: function() { this.showMenu(); }}
	}/*{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getServiceRequestTranslation('GENERATE_VISITOR_CARD'),
			itemId:'generateVisitorCard'
		},{
			text:getServiceRequestTranslation('GENERATE_MULTI_DAY_PASS'),
			itemId:'generateMultiDayPass'
		},{
			text:getServiceRequestTranslation('GENERATE_GATE_PASS'),
			itemId:'generateGatePass'
		}],
		listeners: { click: function() { this.showMenu(); }}
	}*/],
	columns: [{
		header:  getServiceRequestTranslation('VISITOR_NO'),
		dataIndex: 'visitorNo',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('BOOKING_ID'),
		dataIndex: 'bookingId',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('SG_VISITOR_CATEGORY'),
		dataIndex: 'visitorCategoryName',
		flex:1,
		sortable:true
		/*renderer:function(value,meta,record){
			return value.value;
		}   */
	},{
		header:  getServiceRequestTranslation('VISITOR_PARENT_NAME'),
		dataIndex: 'visitorName',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('VISITOR_PARENT_CONTACT_NO'),
		dataIndex: 'visitorContactNo',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('MEETING_DATE'),
		dataIndex: 'meetingDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getServiceRequestTranslation('PERSON_TO_MEET'),
		dataIndex: 'personToMeet',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('REASON_TO_MEET'),
		dataIndex: 'reasonToVisit',
		flex:.8,
		sortable:true,
		renderer:function(record){
			if(!isNullOrEmpty(record)){
				return "<a href='#'>"+getPlacementTranslation('VIEW')+"</a>";
			}else{
				return "-";
			}
		}   
	},{
		header:  getServiceRequestTranslation('IN_TIME'),
		dataIndex: 'inTime',
		flex:1,
		sortable:true,
		renderer:function(value, record){
			return timeRender(value);
		}
	},{
		header:  getServiceRequestTranslation('OUT_TIME'),
		dataIndex: 'outTime',
		flex:1,
		sortable:true,
		renderer:function(value, record){
			return timeRender(value);
		}
	},{
		header:  getServiceRequestTranslation('MULTI_DAY_PASS'),
		dataIndex: 'isMultiDayPass',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.tillDate)) {
				return getCommonTranslation("YES");
			} else {
				return getCommonTranslation("NO");
			}
		}
	},{
		header:  getServiceRequestTranslation('MV_VALID_TILL'),
		dataIndex: 'tillDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getServiceRequestTranslation('VISITOR_CARD_NO'),
		dataIndex: 'visitorCardNo',
		flex:1,
		sortable:true
		/*renderer:function(record){
			if(!isNullOrEmpty(record)){
				return "<a href='#'>"+record+"</a>";
			}else{
				return "-";
			}

		}*/
	},{
		header:  getServiceRequestTranslation('GOING_OUT_WITH_STUDENT'),
		dataIndex: 'isGoingOutWithStudent',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value==true)
				{	
					return getCommonTranslation("YES");
				} else {
					return getCommonTranslation("NO");
				}
			}
		}
	},{
		header: getServiceRequestTranslation('BOOKING_DATE'),
		dataIndex: 'bookingDate',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header: getServiceRequestTranslation('ENTRY_BY'),
		dataIndex: 'entryByName',
		flex:1.1,
		sortable:true,
		hidden:true
	}]
});
