/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.servicerequest.StudentRequestTransferInGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studentrequesttransferingrid',
    store: 'servicerequest.studentservicerequest.StudentRequestTransferInStore',
    title: getServiceRequestTranslation('ALL_REQUEST'),
    border: true,
    autoScroll: false,
    refreshStoreData:true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
		itemId : 'dockedItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'servicerequest.studentservicerequest.StudentRequestTransferInStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('TRANSFERRING_OUT_ACADEMY_LOCATION'),
        dataIndex: 'fromAcademyLocationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('REQUEST_ID'),
        dataIndex: 'requestId',
        flex: 1,
        sortable: true,
        renderer : function(value){
			if(value){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
    },{
        header: getCommonTranslation('REQUEST_BY'),
        dataIndex: 'requestBy',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('REQUESTER_NAME'),
        dataIndex: 'requesterName',
        flex: 1,
        sortable: true,
    },{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:1,
		sortable:true
	}, {
        header: getCommonTranslation('REQUEST_TYPE'),
        dataIndex: 'requestType',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('REQUEST_DATE'),
        dataIndex: 'requestDate',
        flex: 1,
        sortable: true,
        renderer:function(value) {
			return dateRender(value);
		}
    }, {
        header: getCommonTranslation('REQUEST_ASSIGNED_TO'),
        dataIndex: 'assigneeName',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('SERVICE_REQUEST_STATUS'),
        dataIndex: 'requestStatus',
        flex: 1,
        sortable: true
    }]
});