/**
 * @author pritam.patil
 * follow Up Details Grid 
 */
Ext.define('Academia.view.servicerequest.common.FollowUpDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.followupdetailsgrid',
    border: true,
//    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getServiceRequestTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        renderer:function(object) {
        	if(!isNullOrEmpty(object))
        		return object.value;
        	else
        		return "";
		},
        sortable: true,
        flex: .2,
        hidden: true
    },{
        header: getServiceRequestTranslation('NAME'),
        dataIndex: 'user',
        renderer:function(object) {
			return object.value;
		},
        sortable: true,
        flex: .2
    },{
        header: getServiceRequestTranslation('PLANNED_FOLLOW_UP_DATE'),
        dataIndex: 'plannedFollowupDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getServiceRequestTranslation('ACTUAL_FOLLOW_UP_DATE'),
        dataIndex: 'actualFollowupDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },  {
        header: getServiceRequestTranslation('NEXT_FOLLOW_UP_DATE'),
        dataIndex: 'nextFollowupDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getServiceRequestTranslation('REMARKS'),
        dataIndex: 'remarks',
        sortable: true,
        flex: .2
    },{
        header: getServiceRequestTranslation('AGENDA_NUMBER'),
        dataIndex: 'agendaNumber',
        renderer:function(object) {
        	if(!isNullOrEmpty(object))
        		return object.itemValue;
        	else
        		return "";
		},
        sortable: true,
        flex: .2
    }],
   
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getServiceRequestTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
        
    },
    buildStore: function() {
        return Ext.create('Academia.store.servicerequest.common.FollowUpDetails');
        
        
    }

});