
Ext.define('Academia.view.servicerequest.documents.ServiceRequestVoluntaryDocumentsGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.servicerequestvoluntarydocuments',
	title:getServiceRequestTranslation('VOLUNTARY_DOCUMENTS'),
	//titleAlign: 'left',
	border:true,
	cls:'centerAlignTitle',
	style: {
		'position': 'relative !important'
	},
	columns:[{
		header:getServiceRequestTranslation('DOCUMENT_NAME'),
		dataIndex:'name',
		renderer:function(value){
				return  '<a href="#">'+value+'</a>';
		},
		flex:1
	}],
	tbar:[{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip : getCommonTranslation('UPLOAD'),
        text:getCommonTranslation('UPLOAD')
    }, {
    	xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip : getCommonTranslation('DELETE'),   
        text:getCommonTranslation('DELETE')
    },{
        xtype: 'button',
        itemId: 'btnDownload',
        tooltip : getServiceRequestTranslation('DOWNLOAD'),
        text : getServiceRequestTranslation('DOWNLOAD'), 
        hidden : true
    }],
	initComponent: function() {
	    var this$ = this;
	    var store = this$.buildStore();
	    Ext.apply(this$, {
	        store: store
	    });
	
	    this$.callParent(arguments);
	},
	buildStore: function() {
	    return Ext.create('Academia.store.servicerequest.common.ServiceRequestVoluntaryDocuments');
	}
});



