Ext.define('Academia.view.servicerequest.feeservicerequest.ReAddmissionFileUploadForm', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.reAddmissionFileUploadForm',
    items:[{
        xtype: 'fieldcontainer',
        cls:'selectReasonClsField2',
        items: [{
            xtype: 'fieldset',
            border:1,
            cls:'selectReasonCls',
            items: [{
                xtype: 'fieldcontainer',
                 items: [{
                    flex:1,
                    cls:'htmlClsLabel',
                    html: getServiceRequestTranslation('IF_YOU_ARE_NOT_REGISTERED_STUDENT_UNIVERSITY')
                }]
            },{
            	xtype: 'textareafield',
            	emptyText: getServiceRequestTranslation('TYPE_MOTIVATION_REASON_HERE'),
            	name: 'registeredStudentRemark',
            	itemId: 'registeredStudentRemark',
            	enforceMaxLength: true,
            	maxLength: 350,
            	width: '100%',
            	cls: 'reasonTextArea',
            	height: 100,
            	maxLengthText: getServiceRequestTranslation('MAX_LENGTH_VALIDATION'),
            	listeners: {
            		afterrender: function(field) {
            			// Create counter element right below textarea
            			field.charCountEl = Ext.DomHelper.append(field.el, {
            				tag: 'div',
            				cls: 'maxCharacterCls',
            				html: getExaminationTranslation('MAX_CHARACTER_LENGTH') + ' - ' + '0 / ' + field.maxLength
            			}, true);

            			// Update count on input
            			field.inputEl.on('keyup', function() {
            				var val = field.getValue() || '';
            				field.charCountEl.setHTML(getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + val.length + ' / ' + field.maxLength);
            			});
            		}
            	}
            },{
                xtype: 'fieldcontainer',
                layout:'hbox',
                items: [{
                    xtype : 'filefield',
                    ui: 'CustomBtnCancel',
                    width:'50%',
                    cls:"readdmissionFile",
                    //fieldLabel : getServiceRequestTranslation('UPLOAD_PROGRAM_CHANGE_MOTIVATION'),
                    buttonText : getCommonTranslation('BROWSE'),
                    itemId : 'registeredStudentUploadFileField',
                    name : 'registeredStudentUploadFileField',
                    validateOnChange : true,
                    labelAlign:'top'
                },{
        			xtype: 'button',
        			itemId: 'resetFileField',
        			cls: 'CustomToolbarBtnReject',
        			iconCls: 'icon-Delete',
        			cls:'iconDelete',
        			disabled:true,
        			margin:'3 0 0 5'
        		}]
            }, { cls: 'htmlClsLabel',
            	itemId:'registeredStudentUploadFileLink',
            	minHeight:20,
            	 style:{
                 	'margin':'0 !important'
                 },
                html: ''
            }]
        }]
    },{
        xtype: 'fieldcontainer',
        cls:'selectReasonClsField2',
        items: [{
            xtype: 'fieldset',
            border:1,
            cls:'selectReasonCls',
            items: [{
                xtype: 'fieldcontainer',
                items: [{
                    flex:1,
                    cls:'htmlClsLabel',
                    html: getServiceRequestTranslation('WHAT_MEASURES_WHAT_ASSISTANCE')+'<span class="required" style="color:red"> *</span>'
                }]
            },{
                xtype: 'textareafield',
                emptyText: getServiceRequestTranslation('TYPE_MOTIVATION_REASON_HERE'),
                name: 'measuresWhatAssistanceRemark',
                itemId: 'measuresWhatAssistanceRemark',
                enforceMaxLength : true,
                maxLength : 350,
                width:'100%',
                height:100,
                cls: 'reasonTextArea',
                allowBlank:false,
                maxLengthText : getServiceRequestTranslation('MAX_LENGTH_VALIDATION'),
                listeners: {
            		afterrender: function(field) {
            			// Create counter element right below textarea
            			field.charCountEl = Ext.DomHelper.append(field.el, {
            				tag: 'div',
            				cls: 'maxCharacterCls',
            				html: getExaminationTranslation('MAX_CHARACTER_LENGTH') + ' - ' + '0 / ' + field.maxLength
            			}, true);

            			// Update count on input
            			field.inputEl.on('keyup', function() {
            				var val = field.getValue() || '';
            				field.charCountEl.setHTML(getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + val.length + ' / ' + field.maxLength);
            			});
            		}
            	}
            },{
                xtype: 'fieldcontainer',
                layout:'hbox',
                items: [{
                    xtype : 'filefield',
                    ui: 'CustomBtnCancel',
                    width:'50%',
                    cls:"readdmissionFile",
                    //fieldLabel : getServiceRequestTranslation('UPLOAD_PROGRAM_CHANGE_MOTIVATION'),
                    buttonText : getCommonTranslation('BROWSE'),
                    itemId : 'improveCourseUploadFileField',
                    name : 'improveCourseUploadFileField',
                    validateOnChange : true,
                    labelAlign:'top'
                    
                },{
        			xtype: 'button',
        			itemId: 'resetFileField',
        			cls: 'CustomToolbarBtnReject',
        			iconCls: 'icon-Delete',
        			cls:'iconDelete',
        			disabled:true,
        			margin:'3 0 0 5'
        		}]
            }, { cls: 'htmlClsLabel',
            	itemId:'improveCourseUploadFileLink',
            	minHeight:20,
            	 style:{
                 	'margin':'0 !important'
                 },
                html: ''
            }]
        }]
    },{
        xtype: 'fieldcontainer',
        cls:'selectReasonClsField2',
        items: [{
            xtype: 'fieldset',
            cls:'selectReasonCls',
            items: [{
                xtype: 'fieldcontainer',
                layout: {
                    type: 'hbox'
                },
                items: [{
                    flex:1,
                    cls:'htmlClsLabel',
                    html: getServiceRequestTranslation('WHY_WOULD_SUCCEED_YOUR_STUDIES_FUTURE')+'<span class="required" style="color:red"> *</span>'
                }]
            },{
                xtype: 'textareafield',
                emptyText: getServiceRequestTranslation('TYPE_MOTIVATION_REASON_HERE'),
                name: 'succeedYourStudiesRemark',
                itemId: 'succeedYourStudiesRemark',
                enforceMaxLength : true,
                maxLength : 350,
                width:'100%',
                cls: 'reasonTextArea',
                allowBlank:false,
                height:100,
                maxLengthText : getServiceRequestTranslation('MAX_LENGTH_VALIDATION'),
                listeners: {
            		afterrender: function(field) {
            			// Create counter element right below textarea
            			field.charCountEl = Ext.DomHelper.append(field.el, {
            				tag: 'div',
            				cls: 'maxCharacterCls',
            				html: getExaminationTranslation('MAX_CHARACTER_LENGTH') + ' - ' + '0 / ' + field.maxLength
            			}, true);

            			// Update count on input
            			field.inputEl.on('keyup', function() {
            				var val = field.getValue() || '';
            				field.charCountEl.setHTML(getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + val.length + ' / ' + field.maxLength);
            			});
            		}
            	}
            },{
                xtype: 'fieldcontainer',
                layout:'hbox',
                items: [{
                    xtype : 'filefield',
                    ui: 'CustomBtnCancel',
                    width:'50%',
                    cls:"readdmissionFile",
                    //fieldLabel : getServiceRequestTranslation('UPLOAD_PROGRAM_CHANGE_MOTIVATION'),
                    buttonText : getCommonTranslation('BROWSE'),
                    itemId : 'studiesFutureUploadFileField',
                    name : 'studiesFutureUploadFileField',
                    validateOnChange : true,
                    labelAlign:'top'
                },{
        			xtype: 'button',
        			itemId: 'resetFileField',
        			cls: 'CustomToolbarBtnReject',
        			iconCls: 'icon-Delete',
        			cls:'iconDelete',
        			disabled:true,
        			margin:'3 0 0 5'
        		}]
            }, { cls: 'htmlClsLabel',
            	itemId:'studiesFutureUploadFileLink',
            	minHeight:20,
            	 style:{
                 	'margin':'0 !important'
                 },
                html: ''
            }]
        }]
    }]
});
