/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.servicerequest.feeservicerequest.SelectReasonReAddmissionForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.selectReasonReAddmissionForm',
    cls:'boxShadowReaddmission',
    items:[{
    	xtype: 'fieldset',
    	border:1,
    	cls:'selectReasonCls',
    	margin:0,
    	items: [{
    		xtype: 'fieldcontainer',
    		width: '100%',
    		layout: {
    			type: 'hbox'
    		},
    		items: [{
    			flex:1,
    			cls:'htmlClsLabel',
    			html: getServiceRequestTranslation('SELECT_CONTRIBUTED_UNDERACHIEVEMENT')
    		},{
    			xtype: 'button',
    			itemId: 'addSectionBtn',
    			iconCls:'icon-addbutton',
    			cls:'addbutton'
    		},{
    			html: getServiceRequestTranslation('ADD_MORE_REASON'),
    			width:120,
    			cls:'htmlClsLabel',
    			margin:'10 0 0 5'
    		},{
    			xtype: 'button',
    			itemId: 'deleteSectionBtn',
    			cls: 'CustomToolbarBtnReject',
    			iconCls: 'icon-Delete',
    			cls:'iconDelete',
    			hidden:true,
    			margin:'3 0 0 5'
    		},{
    			margin:'10 0 0 5',
    			cls:'htmlClsLabel',
    			itemId:'deleteLabel',
    			hidden:true,
    			width:120,
    			html: getServiceRequestTranslation('DELETE_REASON')
    		}]


    	},{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('REASON'),
            name: 'serviceReason',
            itemId: 'serviceReason',
            store: 'servicerequest.feerequest.ReasonServiceRequestStore',
            valueField: 'id',
            displayField: 'itemValue', 
            allowBlank: false,
            labelAlign:'top',
            matchFieldWidth :true,
            width:226,
            editable: false,
            querymode: 'local'
    	},{
    		xtype: 'textareafield',
    		emptyText: getServiceRequestTranslation('TYPE_MOTIVATION_REASON_HERE'),
    		name: 'motivationReason',
    		itemId: 'motivationReason',
    		enforceMaxLength : true,
    		maxLength : 350,
    		width:'100%',
    		height:100,
    		cls: 'reasonTextArea',
    		maxLengthText : getServiceRequestTranslation('MAX_LENGTH_VALIDATION'),
    		listeners: {
    			afterrender: function(field) {
    				// Create counter element right below textarea
    				field.charCountEl = Ext.DomHelper.append(field.el, {
    					tag: 'div',
    					cls: 'maxCharacterCls',
    					html: getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + '0 / ' + field.maxLength
    				}, true);

    				// Update count on input
    				field.inputEl.on('keyup', function() {
    					var val = field.getValue() || '';
    					field.charCountEl.setHTML(getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + val.length + ' / ' + field.maxLength);
    				});
    			}
    		}
    	}]
    }]
});