/**
* @author pritam.patil
* program request Details Panel 
 */
Ext.define('Academia.view.servicerequest.programcoursesectiontransferrequest.ExchangeSemesterRequestDetailsPanel', {
    extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.exchangesemesterrequestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    },{
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true,
        width: 226
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true,
        width: 226
    },{
        xtype: 'requesterdetailspanel',
        itemId: 'requesterDetails',
        style: {
            marginBottom: '0px'
        }
    }, {
        xtype: 'basicdetails',
        itemId: 'programBasicDetails',
        style: {
            marginBottom: '-29px'
        }
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_ACADEMY_LOCATION'),
            name: 'fromAcademyLocation',
            store:Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.FromAcademyLocation'),
            valueField: 'id',
            itemId: 'fromAcademyLocationId',
            displayField: 'value',
            width:226,
            allowBlank: false,
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                }
            }
            
        },
    	{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'academicTermId',
            store: Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademicTermStore'),
            valueField: 'id',
            itemId: 'academicTermCombo',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_PROGRAM'),
            name: 'fromProgram',
          //  store: Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.FromPrograms'),
            store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.PeriodByAcademicTerm'),
            valueField: 'programId',
            itemId: 'fromProgramId',
            width:226,
            displayField: 'programCode',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
        }, {
        	xtype: 'customcombobox',
            name: 'fromBatch',
            itemId: 'fromBatchId',
        //    store: Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
            store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.PeriodByAcademicTerm'),
            displayField : 'batchName',
        	valueField : 'batchId',
            queryMode: 'local',
            allowBlank: false,
            editable: false,
            fieldLabel: getServiceRequestTranslation('FROM_BATCH')
            
        },{
        	xtype: 'customcombobox',
            name: 'fromPeriod',
            itemId : 'fromPeriodId',
            fieldLabel: getServiceRequestTranslation('FROM_PERIOD'),
        //    store : Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.FromPeriodStore'),
            store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.PeriodByAcademicTerm'),
            displayField : 'periodName',
        	valueField : 'periodId',
            allowBlank: false,
            editable: false,
    }]}, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
			xtype: 'customcombobox',
            name: 'toAcademyLocation',
            itemId: 'toAcademyLocationItemId',
            store: Ext.create('Academia.store.organization.academylocations.ActiveAcademyLocationStore'),
            displayField : 'value',
        	valueField : 'id',
            allowBlank: false,	
            editable: false,
            disabled:true,
            width:226,
            fieldLabel: getServiceRequestTranslation('STUDENT_TRANSFER_TO_ACADEMY_LOCATION'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
		},
		{
			xtype: 'customcombobox',
            name: 'toProgram',
            itemId: 'toProgramId',
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore'),
            displayField : 'value',
        	valueField : 'id',
            allowBlank: false,
            disabled:true,
            editable: false,
            width:226,
            fieldLabel: getServiceRequestTranslation('TO_PROGRAM'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
		}]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'toCampus',
			itemId : 'toCampusId',
			fieldLabel: getServiceRequestTranslation('CAMPUS'),
			store : Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.ToCampusStore'),
        	displayField : 'value',
        	valueField : 'id',
        	allowBlank: false,
        	disabled:true,
        	hidden:true,
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
		}, {
			xtype: 'customcombobox',
			name: 'toBatch',
			itemId : 'toBatchId',
			fieldLabel: getServiceRequestTranslation('BATCH'),
//			store : Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.ToBatchStore'),
			store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ExchangeSemBatchPeriodByAcademicTerm'),
        	displayField : 'batchName',
        	valueField : 'batchId',
        	allowBlank: false,
        	disabled:true,
            editable: false,
            hidden:true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
		}]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
			xtype: 'customcombobox',
            name: 'toPeriod',
            itemId: 'toPeriodId',
//            store: Ext.create('Academia.store.program.programDetails.programBatches.ProgramPeriodNameStore'),
            store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ExchangeSemBatchPeriodByAcademicTerm'),
            displayField : 'periodName',
        	valueField : 'periodId',
            allowBlank: false,
            disabled:true,
            editable: false,
            hidden:true,
            fieldLabel: getServiceRequestTranslation('PERIOD'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }     
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
		}, /*{
			xtype: 'customcombobox',
			name: 'toSeatType',
			itemId : 'toSeatTypeId',
			fieldLabel: getServiceRequestTranslation('SEAT_TYPE'),
			store : Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.SeatTypeByBatchIdStore'),
        	displayField : 'value',
        	valueField : 'id',
        	allowBlank: true,
        	disabled:true,
        	hidden:true,
            editable: false,
            
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}'  +
    				'</div>';
    			}
            }
		}*/]
    } , {
        xtype: 'fieldcontainer',
        layout: {
            type: 'vbox'
        },
        width: 680,
        style: {
             marginLeft: '20px'
        },
        items: [{
        	xtype: 'displayfield',
        	width: 680,
        	labelWidth: 680,
        	cls:'hideDisplayText',
        	labelSeparator:' ',
        	fieldLabel: getCommonTranslation('EX_AUTHORIZED_DECLARATION'),
        	itemId: 'authorizeDeclarationDetails',
        	name: 'authorizeDeclarationDetails'
        },{
        	xtype: 'checkboxfield',
        	width: '100%',
        	cls:'acceptCheckBox',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('PT_AUTHORIZED_CHECKBOX'),
        	name: 'authorizeDeclaration',
        	itemId:'authorizeDeclarationId',
        	inputValue : true,
        	afterBoxLabelTpl:' ',
        	uncheckedValue: false 
        },{
        	xtype: 'fieldset',
        	itemId: 'visaRefusal',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("VISA_REFUSAL"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('VISA_REFUSAL_CONTENT'),
        		name: 'visaRefusalCheck',
        		itemId:'visaRefusalCheck',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'fieldset',
        	itemId: 'studiedInUk',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("STUDIED_IN_UK"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('STUDIED_IN_UK_CONTENT'),
        		name: 'studiedInUkCheck',
        		itemId:'studiedInUkCheck',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'fieldset',
        	itemId: 'healthInsuranceId',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("PT_HEALTH_INSURANCE_FC"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('PT_HEALTH_INSURANCE'),
        		name: 'healthInsuranceCheck',
        		itemId:'healthInsuranceCheckId',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'fieldset',
        	itemId: 'scholarshipId',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("PT_SCHOLARSHIP_FC"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('PT_SCHOLARSHIP'),
        		name: 'scholarshipCheck',
        		itemId:'scholarshipCheckId',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'fieldset',
        	itemId: 'medicalIssuesId',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("PT_MEDICAL_ISSUES_FC"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('PT_MEDICAL_ISSUES'),
        		name: 'medicalIssuesCheck',
        		itemId:'medicalIssuesCheckId',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	},
        	{
            	xtype: 'displayfield',
            	width: '100%',
            	labelWidth: '100%',
            	cls:'hideDisplayText',
            	labelSeparator:' ',
            	fieldLabel: getCommonTranslation('STD_EXCHANGE_SEMESTER_STATEMENT'),
            	itemId: 'stdExchangeSemesterStatementId',
            	name: 'stdExchangeSemesterStatement'
            }]
        },{
        	xtype: 'checkboxfield',
        	width: '100%',
        	cls:'acceptCheckBox',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('PT_UP_TO_DATE_CHECKBOX'),
        	name: 'upToDateDetails',
        	itemId:'upToDateDetailsId',
        	inputValue : true,
        	afterBoxLabelTpl:' ',
        	uncheckedValue: false 
        },{
        	xtype: 'checkboxfield',
        	width: '100%',
        	cls:'hideCheckBox',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('STUDENT_DECLARATION'),
        	name: 'studentdeclaration',
        	itemId:'studentDeclarationId',
        	inputValue : true,
        	afterBoxLabelTpl:' ',
        	uncheckedValue: false 
        },{
        	xtype: 'displayfield',
        	width: 680,
        	labelWidth:680,
        	labelSeparator:' ',
        	cls:'hideDisplayText',
        	itemId: 'studentDeclarationDetails',
        	fieldLabel: getCommonTranslation('STUDENT_DECLARATION_CONTENT_EX'),
        	name: 'studentDeclarationDetails'
        }, {
        	xtype: 'checkboxfield',
        	width: '100%',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('FOR_STUDENTS_APPLYING'),
        	name: 'studentApply',
        	cls:'hideCheckBox',
        	itemId:'studentApplyId',
        	inputValue : true,
        	afterBoxLabelTpl:':',
        	uncheckedValue: false 
        },{
        	xtype: 'displayfield',
        	width: 680,
        	cls:'hideDisplayText',
        	labelWidth:680,
        	labelSeparator:' ',
        	itemId: 'forStudentsApplyingDetails',
        	fieldLabel: getCommonTranslation('FOR_STUDENTS_APPLYING_CONTENT_EX'),
        	name: 'forStudentsApplyingDetails'
        },{
        	xtye:'checkboxgroup',
        	itemId:'isConfirmation',
        	allowBlank: false,
        	margin:' 0 0 0 -10',
        	items:[{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		cls:'acceptCheckBox',
        		boxLabel:getCommonTranslation('ACCEPT_STUDENT_DECLARATION'),
        		name: 'confirmation',
        		itemId:'confirmationId',
        		inputValue : true,
        		afterBoxLabelTpl:'.',
        		uncheckedValue: false 
        	}]
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '17px',
            marginTop: '24px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'exchangeSemesterreqUploadSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]
    }]
});
