Ext.define('Academia.view.servicerequest.servicerequestsettings.ComplaintGrid',{
	extend:'Ext.grid.Panel',
	store:'servicerequest.servicerequestsettings.ComplaintGridStore',
	alias:'widget.complaintgrid',
	border:true,
	//height:280,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns:[{
//		header:getServiceRequestTranslation('COMPLAINT_TYPE'),
		header:getServiceRequestTranslation('GRIEVANCE_TYPE'),
		dataIndex:'complaintType',
		sortable:true,
		renderer:function(object) {
			return object.value;
		},
		flex:0.5
	},{
		header:getServiceRequestTranslation('SLA'),
		dataIndex:'sla',
		sortable:true,
		flex:0.5	
	},{
		header:getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
		dataIndex:'defaultAssignee',
		sortable:true,
		renderer:function(object) {
			if(isNullOrEmpty(object)){
				return "";
			} else {
				return object.value;
			}
		},
		flex:0.5
	},{
		header:getServiceRequestTranslation('DEFAULT_APPROVER'),
		dataIndex:'defaultApprover',
		sortable:true,
		renderer:function(object) {
			if(isNullOrEmpty(object)){
				return "";
			} else {
				return object.value;
			}			
		},
		flex:0.5
	}],
	
	dockedItems: [{
		xtype: 'toolbar',
		itemId: 'complaintButtonsToolbar',
		dock:'top',
		items:[{
		        xtype: 'button',
		        itemId: 'btnEdit',
		        tooltip : getCommonTranslation('EDIT'),
		        glyph: ICONGLYPH.EDITGLYPH
		    }, {
		        xtype: 'button',
		        itemId: 'btnView',
		        iconCls: 'view-icon'	,
		        tooltip : getCommonTranslation('VIEW')		       
		}]
	}]
	
});