/**
* @author Raghavendra.Soni
 */
Ext.define('Academia.view.servicerequest.studentservicerequest.LeaveOfAbsenceRequestForm', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.leaveofabsencerequestform',
	frame: false,
	border: false,
	plugins: "formlabelrequired",
	items: [{
		xtype: 'hidden',
		name: 'id'
	},
	{
		xtype: 'hidden',
		name: 'version'
	}, {
		xtype: 'hidden',
		name: 'fromALId'
	}, {
		xtype: 'nestedJsonCombo',
		name: 'assignee',
		itemId: 'assigneeId',
		hidden: true,
        width: 226
	}, {
		xtype: 'nestedJsonCombo',
		name: 'serviceRequestSetting',
		itemId: 'settingId',
		hidden: true,
        width: 226
	}, {
		xtype: 'requesterdetailspanel',
		itemId: 'requesterDetails',
		style: {
			marginBottom: '0px'
		}
	}, {
		xtype: 'basicdetails',
		itemId: 'programBasicDetails',
		style: {
			marginBottom: '-29px'
		}
	}, {
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style: {
			marginLeft: '20px'
		},
		items: [
			{
				xtype: 'customcombobox',
				fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
				name: 'academyLocationId',
				store: Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademyLocationStore'),
				valueField: 'id',
				itemId: 'academyLocationCombo',
				displayField: 'value',
				allowBlank: false,
				editable: false,
				queryMode: 'local'
			},
			{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
				name: 'academicTermId',
				store: Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademicTermStore'),
				valueField: 'id',
				itemId: 'academicTermCombo',
				displayField: 'value',
				allowBlank: false,
				editable: false,
				queryMode: 'local'
			}, {
				xtype: 'customcombobox',
				fieldLabel: getServiceRequestTranslation('PROGRAM'),
				name: 'programId',
				//            store: Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.FromPrograms'),
				store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ActiveProgramByAcademicTerm'),
				//    store: Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer'),
				//    valueField: 'id',
				itemId: 'programCombo',
				//    displayField: 'value',
				valueField: 'programId',
				displayField: 'programCode',
				allowBlank: false,
				editable: false,
				queryMode: 'local'
			}]
	}, {
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style: {
			marginLeft: '20px'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId: 'batchCombo',
			//  store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.BatchByAcademicTerm'),
			displayField: 'batchName',
			valueField: 'batchId',
			queryMode: 'local',
			allowBlank: false,
			editable: false,
			fieldLabel: getCommonTranslation('BATCH')
		}, {
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodCombo',
			fieldLabel: getCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.PeriodByAcademicTerm'),
			displayField: 'periodName',
			valueField: 'periodId',
			allowBlank: false,
			editable: false
		}, {
			xtype: 'customcombobox',
			fieldLabel: getServiceRequestTranslation('SEAT_TYPE'),
			name: 'seatTypeId',
			//          store: Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.ProgramBatchSeatGridStore'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.SeatTypeByAcademicTerm'),
			valueField: 'seatTypeId',
			itemId: 'seatTypeCombo',
			displayField: 'seatTypeName',
			allowBlank: false,
			editable: false,
			queryMode: 'local'
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style: {
			marginLeft: '20px'
		},
		items: [
			{
				xtype: 'datefield',
				fieldLabel: getServiceRequestTranslation('START_DATE'),
				name: 'startDate',
				itemId: 'startDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//minValue: new Date(),
				allowBlank: false,
			},
			{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('START_ACADEMIC_TERM'),
				name: 'startAcademicTermId',
//				store: Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademicTermStore'),
				store: Ext.create('Academia.store.common.AcademicTermStore'),
				valueField: 'id',
				itemId: 'startAcademicTermCombo',
				displayField: 'value',
				allowBlank: true,
				editable: false,
				queryMode: 'local'
			},{
				 xtype: 'nestedJsonCombo',
				 name:'studentReturnStatus',
				 itemId:'returnStatusItemId',
				 fieldLabel: getCommonTranslation('STUDENTS_RETURN_STATUS'),
				 store: Ext.create('Academia.store.common.AcademicTermStore'),
				 valueField: 'id',
				 displayField: 'value',
				 editable: false,
				 disableKeyFilter: false,
				 hidden:true
			 }]

	}, {
		xtype: 'fieldcontainer',
		cls: 'fieldSetDFRCls',
    	width: 680,
		layout: {
			type: 'vbox'
		},
		style: {
			marginLeft: '20px'
		},
		items: [{
			xtype: 'checkboxfield',
			width: '100%',
			cls: 'hideCheckBox',
			labelAlign: 'right',
			boxLabel: getCommonTranslation('LOA_REQUESTER_DECLARATION'),
			name: 'loaRequesterDeclaration',
			itemId: 'loaRequesterDeclarationId',
			inputValue: true,
			afterBoxLabelTpl: ':',
			uncheckedValue: false
		}, {
			xtype: 'displayfield',
			width: 680,
			labelWidth: 680,
			cls: 'hideDisplayText',
			labelSeparator: ' ',
			itemId: 'loaStudentDeclarationFirstId',
			fieldLabel: getCommonTranslation('LOA_REQUESTER_DECLARATION_FIRST'),
			name: 'loaStudentDeclarationFirst'
		}, {
			xtype: 'checkboxfield',
			width: '100%',
			labelAlign: 'right',
			boxLabel: getCommonTranslation('LOA_REQUESTER_DECLARATION_SECOND'),
			name: 'loaRequesterDeclarationSecond',
			itemId: 'loaRequesterDeclarationSecondId',
			inputValue: true,
			uncheckedValue: false,
			cls:'acceptCheckBox',
        	afterBoxLabelTpl:' ',
        	margin: '0 0 30 0'
		}, {
			xtype: 'checkboxfield',
			width: '100%',
			cls: 'hideCheckBox',
			labelAlign: 'right',
			boxLabel: getCommonTranslation('LOA_IMPORTANT_NOTE'),
			name: 'loaImportantNote',
			itemId: 'loaImportantNoteId',
			inputValue: true,
			afterBoxLabelTpl: ':',
			uncheckedValue: false
		}, {
			xtype: 'displayfield',
			width: 680,
			labelWidth: 680,
			cls: 'hideDisplayText',
			labelSeparator: ' ',
			itemId: 'loaImportantNoteContentId',
			fieldLabel: getCommonTranslation('LOA_IMPORTANT_NOTE_CONTENT'),
			name: 'loaImportantNoteContent'
		}, {
			xtype: 'checkboxfield',
			width: '100%',
			labelAlign: 'right',
			cls: 'hideCheckBox',
			boxLabel: getCommonTranslation('LOA_STUDENT_DECLARATION'),
			name: 'loaStudentDeclaration',
			itemId: 'loaStudentDeclarationId',
			afterBoxLabelTpl: ':',
			inputValue: true,
			uncheckedValue: false
		}, {
			xtype: 'displayfield',
			width: 680,
			labelWidth: 680,
			cls: 'hideDisplayText',
			labelSeparator: ' ',
			itemId: 'loaStudentDeclarationContentId',
			fieldLabel: getCommonTranslation('LOA_STUDENT_DECLARATION_CONTENT'),
			name: 'loaStudentDeclarationContent'
		}, {
			xtype: 'checkboxfield',
			width: '100%',
			labelAlign: 'right',
			boxLabel: getCommonTranslation('LOA_STUDENT_CONFIRMATION'),
			name: 'loaStudentconfirmation',
			itemId: 'loaStudentconfirmationId',
			inputValue: true,
			uncheckedValue: false,
			cls:'acceptCheckBox'
		}]
	}, {
		xtype: 'fieldcontainer',
		width: '100%',
		style: {
			marginLeft: '17px',
			marginTop: '24px'
		},
		items: [{
			xtype: 'button',
			text: getServiceRequestTranslation('UPLOAD_DOC'),
			itemId: 'leaveOfAbsenceReqUploadSubmitBtn',
			buttonAlign: 'right',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
			ui: 'CustomBtnSubmit',
			itemId: 'withdrawButtonId',
			scale: CONSTANTS.BUTTONSIZE,
			hidden: true
		}]
	}]
});
