/**
* @author Varsha Gour
 */
Ext.define('Academia.view.servicerequest.studentservicerequest.SchoolLeavingRequestDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.schoolleavingrequestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'hidden',
        name: 'fromALId'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    }, {
        xtype: 'requesterdetailspanel',
        itemId: 'requesterDetails',
        style: {
            marginBottom: '0px'
        }
    }, {
        xtype: 'basicdetails',
        itemId: 'programBasicDetails',
        style: {
            marginBottom: '-29px'
        }
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('PROGRAM_NAME'), 
            name: 'programId',
            store: 'servicerequest.programcoursesectiontransfer.FromPrograms',
            valueField: 'id',
            itemId: 'fromProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
    		xtype: 'datefield',
    		fieldLabel: getServiceRequestTranslation('DATE_OF_TRANSFER'),
    		name: 'dateOfTransfer',
    		//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
    		allowBlank: false,
    		itemId: 'dateOfTransferItemId',
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('NOTICE_TERM'),
            name: 'noticeTermId',
            store: 'servicerequest.studentservicerequest.SchoolLeavingPeriodTermDefByProgramIdStore',
            valueField: 'id',
            itemId: 'noticeTermItemId',
            displayField: 'printName',
           // allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
    		xtype: 'datefield',
    		fieldLabel: getServiceRequestTranslation('TERM_END_DATE'),
    		name: 'termEndDate',
    		//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
    		//allowBlank: false,
    		itemId: 'termEndDateItemId',
    		editable: false,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '17px',
            marginTop: '24px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            itemId: 'schoolLeavingSaveBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'schoolLeavingSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]
    }]
});
