/**
 * @Amit G 
 */
Ext.define('Academia.view.setup.campaignmaster.ManageSchoolCreationPadmForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.manageschoolcreationpadmform',
    plugins: "formlabelrequired",
    method: 'POST',
	standardSubmit: false,
	items:[{
        xtype: 'hidden',
        itemId: 'hidManageSchoolId',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            fieldLabel: getCommonTranslation('SCHOOL_CODE'),
            xtype: 'textfield',
            itemId: 'codeItemId',
            name: 'code',
            labelAlign: 'top',
            maxLength: 255,
            allowBlank: false
        }, {
			xtype: 'customcombobox',
			name: 'schoolCategory',
			itemId: 'dlipAdmMSCategoryItemId',
			store: 'setup.campaignmaster.StoPadmManageSchoolCategoryStore',
			fieldLabel: getCommonTranslation('CATEGORY'),
			valueField: 'id',
			displayField: 'value',
			editable:false,
			typeAhead: true,
			forceSelection: true
		},{
            fieldLabel: getCommonTranslation('NUMBER'),
            xtype: 'textfield',
            itemId: 'txtpAdmMSNumberItemId',
            name: 'number',
            labelAlign: 'top',
            maxLength: 255
        }, {
			xtype: 'customcombobox',
			name: 'examBoardMaster',
			itemId: 'dlipAdmMSExamBoardItemId',
			store: 'common.ExamBoardStore',
			fieldLabel: getPersonModuleTranslation('EXAM_BOARD'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			typeAhead: true,
			forceSelection: true
		}]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
			name: 'educationDepartment',
			itemId: 'educationDepartmentItemId',
			store: 'enquiry.EducationDepartmentStore',
			fieldLabel: getEnquiryTranslation('EDUCATION_DEPARTMENT'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: true,
			typeAhead: true,
			forceSelection: true
        }, {
            fieldLabel: getCommonTranslation('SCHOOL_NAME'),
            xtype: 'textfield',
            itemId: 'itemValueItemId',
            name: 'value',
            labelAlign: 'top',
            maxLength: 255,
            allowBlank: false
        }, {
            fieldLabel: getCommonTranslation('SCHOOL_NAME_AFR'),
            xtype: 'textfield',
            itemId: 'txtMSSchoolNamepAdmItemId',
            name: 'schoolNameAfr',
            labelAlign: 'top',
            maxLength: 255
        },{
			xtype: 'customcombobox',
			name: 'country',
			itemId: 'countryIteamId',
			fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
			store: Ext.create('Academia.store.common.CountryStore'),
			valueField: 'id',
			displayField: 'countryName',
			editable:false,
			forceSelection:true
		}]
    },{

		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items:[{
			xtype: 'textarea',
			name: 'address',
			itemId: 'txtpAdmMSAddressItemId',
			fieldLabel: getCommonTranslation('ADDRESS'),
			maxLength: 255
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('COUNTRY_REGION'),
			itemId : 'countryRegionIteamId',
			store:Ext.create('Academia.store.organization.CountryRegionStore'),
			valueField : 'id',
			displayField : 'countryRegionName',
			name : 'countryRegion',
			editable : false,
			forceSelection :true,
			width: 226,
			disabled:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ADDRESS_CITY'),
			name: 'city',
			editable: false,
			itemId: 'cityIteamId',
			store: Ext.create('Academia.store.organization.CityByCountryRegion'),
			valueField: 'id',
			displayField: 'value',
			forceSelection :true,
			width: 226,
			disabled:true
		}]
	
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{

			xtype: 'textfield',
			name: 'txtPadmMSEmailItem',
			itemId: 'txtPadmMSEmailItemId',
			vtype:'email',
			fieldLabel: getCommonTranslation('EMAIL_ID'),
		}, {
			xtype: 'textfield',
			fieldLabel: getCommonTranslation('URL'), //Email ID
			name: 'url',
			itemId: 'txtpAdmMSURLItemId',
			maxLength: '100',	
		},{
			xtype:'fieldcontainer',
			labelSeparator : '',
			fieldLabel: getCommonTranslation('TELEPHONE'),
			itemId:'telephonepAdmMSNumberItemId',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				itemId: 'dlipAdmMScellCountrycodeId',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				triggerAction: 'all',
				name: 'dlipAdmMScellCountrycode',
				editable: false,
				width: 80,
				emptyText: getCommonTranslation('CODE')
			}, {
				xtype: 'numberfield',
				name: 'numpAdmMScellNo',
				itemId: 'numpAdmMScellNoId',
				minLength: 0,
				maxLength: 11,
				width: 135,
				emptyText: 'Mobile Number',
				hideTrigger: true
			}]
		}, {
			xtype: 'textfield',
			fieldLabel: getCommonTranslation('FAX'), //Email ID
			name: 'fax',
			itemId: 'txtpAdmMSFAXItemId',
			maxLength: '100',	
		}]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'radiogroup',
			itemId:'rbnpAdmCorrespondenceStatusItemId',
			labelAlign:'top',
			fieldLabel: getCommonTranslation('CORRESPONDENCE_STATUS'),
			columns: 2,
			vertical: true,
			items: [
			        { boxLabel: getCommonTranslation('YES'), name: 'correspondenceStatus', inputValue:"true",checked:true},
			        { boxLabel: getCommonTranslation('NO'), name: 'correspondenceStatus', inputValue:"false"}
			        ]
		    }, {
				xtype: 'radiogroup',
				itemId:'rbnpAdmActiveItemId',
				labelAlign:'top',
				fieldLabel: getCommonTranslation('ACTIVE'),
				columns: 2,
				vertical: true,
				items: [
				        { boxLabel: getCommonTranslation('YES'), name: 'active', inputValue:"true",checked:true},
				        { boxLabel: getCommonTranslation('NO'), name: 'active', inputValue:"false"}
				        ]
			    },{
					xtype: 'customcombobox',
					itemId: 'dlipAdmMMarketerItemId',
					name: 'marketer',
					fieldLabel: getCommonTranslation('MARKETER'),
					store: Ext.create('Academia.store.feeandpayment.managebill.User'),
					valueField: 'id',
					displayField: 'nameToBePrinted',
					queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}/{nameToBePrinted}' +
							'</div>';
						}
					}
				
			    },{
					xtype: 'numberfield',
					fieldLabel: getCommonTranslation('WAIVE_APPLICATION_FEES'),
					name: 'waiveApplicationFees',
					itemId: 'waiveApplicationFeespAdmMSItemId',
					minLength: 1,
					maxLength: 3,
					minValue:1,
					maxValue:100
			    }]
    
    },{
    	xtype: 'fieldcontainer',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
			labelAlign: 'top',
			width: 226					
		},
    	items: [{
            fieldLabel: getCommonTranslation('CLASSIFICATION'),
            xtype: 'numberfield',
            itemId: 'txtpAdmMSClassificationItemId',
            name: 'classification',
            labelAlign: 'top',
            maxLength: 100,
			hideTrigger: true
    	},{
    		fieldLabel: getCommonTranslation('QUINTILE'),
            xtype: 'numberfield',
            itemId: 'txtpAdmMSQuintileItemId',
            name: 'quintile',
            labelAlign: 'top',
            maxLength: 100,
			hideTrigger: true
    	}, {
            fieldLabel: getCommonTranslation('EMIS'),
            xtype: 'textfield',
            itemId: 'txtpAdmMSEMISItemId',
            name: 'emis',
            labelAlign: 'top',
            maxLength: 255,
        }, {
            fieldLabel: getCommonTranslation('ALIAS_SCHOOL'),
            xtype: 'textfield',
            itemId: 'txtpAdmMSAliasSchoolItemId',
            name: 'aliasSchool',
            labelAlign: 'top',
            maxLength: 255,
        }]
    },{
    	xtype: 'fieldcontainer',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
			labelAlign: 'top',
			width: 226,
			height:66,
			tdAttrs: { 
				style: 'padding: 5px;',
			}					
		},
    	items: [{
    		xtype: 'radiogroup',
    		itemId:'rbnpAdmTopStatusItemId',
    		labelAlign:'top',
    		fieldLabel: getCommonTranslation('TOP100'),
    		columns: 2,
    		vertical: true,
    		items: [
    			{ boxLabel: getCommonTranslation('YES'), name: 'topHundred', inputValue:"true",checked:true},
    			{ boxLabel: getCommonTranslation('NO'), name: 'topHundred', inputValue:"false"}
    			]
    	}, {
    		xtype: 'radiogroup',
    		itemId:'rbnpAdmWordsOpenItemId',
    		labelAlign:'top',
    		fieldLabel: getCommonTranslation('WORDS_OPEN_WORLDS'),
    		columns: 2,
    		vertical: true,
    		items: [
    			{ boxLabel: getCommonTranslation('YES'), name: 'wordsOpenWorlds', inputValue:"true",checked:true},
    			{ boxLabel: getCommonTranslation('NO'), name: 'wordsOpenWorlds', inputValue:"false"}
    			]
    	}, {
    		xtype: 'radiogroup',
    		itemId:'rbnpAdmVisitSchoolItemId',
    		labelAlign:'top',
    		fieldLabel: getCommonTranslation('VISIT_SCHOOL'),
    		columns: 2,
    		vertical: true,
    		items: [
    			{ boxLabel: getCommonTranslation('YES'), name: 'visitSchool', inputValue:"true",checked:true},
    			{ boxLabel: getCommonTranslation('NO'), name: 'visitSchool', inputValue:"false"}
    			]
    	}, {
    		xtype: 'radiogroup',
    		itemId:'rbnpAdmCareerMatiesItemId',
    		labelAlign:'top',
    		fieldLabel: getCommonTranslation('CAREERMATIES'),
    		columns: 2,
    		vertical: true,
    		items: [
    			{ boxLabel: getCommonTranslation('YES'), name: 'careerMaties', inputValue:"true",checked:true},
    			{ boxLabel: getCommonTranslation('NO'), name: 'careerMaties', inputValue:"false"}
    			]
    	}]
    },{
		xtype:'panel',
		itemId: 'contactDetailHeaderPanelItemId',
		width: '100%',
		style:{'margin-left':'0px'},
		layout : 'vbox',
		items:[{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width: '100%',
			defaults : {
				labelAlign : 'top',
				width:226
			},
			layout : {
				type : 'hbox'
			},
			items: [{
				xtype: 'customcombobox',
				itemId: 'dlipAdmMScontactDetailItemId',
				name: 'contactDetails',
				fieldLabel: getCommonTranslation('CONTACT_DETAIL'),
				labelAlign: 'top',
				store: 'setup.campaignmaster.StoPadmCreateSchoolContactDetailStore',
				valueField: 'id',
				rowIndx:0,
				displayField: 'value',
			    forceSelection:true
			}, {
				xtype:'textfield',
				fieldLabel: getCommonTranslation('NAME'),
				enableKeyEvents : true,
				itemId: 'txtpAdmMSNameItemId',
				labelAlign: 'top',
				disabled:true,
				name: 'name',
				maxLength: 40
			},{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('EMAIL_ID'), //Email ID
				name: 'emailAddress',
				vtype: 'email',
				labelAlign: 'top',
				disabled:true,
				itemId: 'txtpAdmMSemailIdItemId',
				maxLength: '100'
			},{
				xtype:'fieldcontainer',
				labelSeparator : '',
				fieldLabel: getCommonTranslation('TELEPHONE'),
				itemId:'telephonepAdmMSContactNumberItemId',
				layout:'hbox',
				disabled:true,
				labelAlign:'top',
				items:[{
					xtype: 'customcombobox',
					itemId: 'dlipAdmMScellPanelCountrycodeId',
					valueField: 'isdCode',
					displayField: 'isdCode',
					store: 'common.CountryStore',
					triggerAction: 'all',
					name: 'telephoneCountryCode',
					editable: false,
					width: 80,
					emptyText: getCommonTranslation('CODE')
				}, {
					xtype: 'numberfield',
					name: 'telephoneNumber',
					itemId: 'numpAdmMSPanelcellNoId',
					minLength: 0,
					maxLength: 11,
					width: 135,
					emptyText: 'Mobile Number',
					hideTrigger: true
				}]
			},{
				xtype: 'button',
				itemId: 'btnAddpAdmMSContactHeader',
				style:{'margin-top':'28px'},
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD')
			}] 
		}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',

        items: [{
            xtype: 'button',
            itemId: 'btnSaveManageSchoolForm',
            text: getCommonTranslation('SAVE'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'btnResetManageSchoolForm',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});