/**
 * @author prathamesh.sheth
 * 
 * This component is used for to enter search contents or to select search criteria in form
 */
Ext.define('Academia.view.sponsorship.SponsorshipListingPastRecordsSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.pastrecordssearchform',
    autoScroll: true,
    frame: true,    
    items: [{
        xtype: 'form',
        itemId: 'pastrecordsList',
        //   method : 'POST',
        layout: 'hbox',        
        items: [{
            xtype: 'fieldcontainer',
            layout: 'vbox',
            flex:.3,
            defaults: {
                width: 226,
                labelAlign: 'top'
            },            
            items: [{
                xtype: 'customcombobox',
                name: 'cmbAcademyYear',
                itemId: 'academyYear',
                fieldLabel: getCommonTranslation('SELECT_ACADEMY_YEAR'), //Select Academy Year
                //store: 'common.UsersComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                emptyText: getCommonTranslation('SELECT_ACADEMY_YEAR'), //Select Academy Year  
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true                
            },{
                xtype: 'customcombobox',
                name: 'program',
                itemId: 'cmbProgram',
                fieldLabel: getCommonTranslation('SELECT_PROGRAM'), //Select Program
                //store: 'common.UsersComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                emptyText: getCommonTranslation('SELECT_PROGRAM'), //Select Program  
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true
            },{
                xtype: 'customcombobox',
                name: 'batch',
                itemId: 'cmbBatch',
                fieldLabel: getCommonTranslation('SELECT_BATCH'), //Select Batch
                //store: 'common.UsersComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                emptyText: getCommonTranslation('SELECT_BATCH'), //Select Batch  
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true
            },{
                xtype: 'customcombobox',
                name: 'period',
                itemId: 'cmbPeriod',
                fieldLabel: getCommonTranslation('SELECT_PERIOD'), //Select Period
                //store: 'common.UsersComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                emptyText: getCommonTranslation('SELECT_PERIOD'), //Select Period  
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true
            }]
        },{
            xtype: 'fieldcontainer',
            flex:.7,
            layout: 'vbox',            
            items: [{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 226,                	
                    labelAlign: 'top'
                },            
                items: [{
                    xtype: 'customcombobox',
                    name: 'selectStudent',
                    itemId: 'cmbSelectStudent',
                    fieldLabel: getCommonTranslation('SELECT_STUDENT'), //Select Student
                    //store: 'common.UsersComboStore',
                    valueField: 'id',
                    displayField: 'value',
                    editable: false,
                    emptyText: getCommonTranslation('SELECT_STUDENT'), //Select Student  
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true                
                },{
                    xtype: 'textfield',
                    name: 'studentId',                    
                    fieldLabel: getCommonTranslation('STUDENT_ID'), //Student ID
                    itemId: 'studentId'
                },{
                    xtype: 'textfield',
                    name: 'studentName',                    
                    fieldLabel: getCommonTranslation('STUDENT_NAME'), //Student Name
                    itemId: 'studentName'
                }]
            },{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 226,                	
                    labelAlign: 'top'
                },            
                items: [{
                    xtype: 'customcombobox',
                    name: 'selectSponsor',
                    itemId: 'cmbSelectSponsor',
                    fieldLabel: getCommonTranslation('SELECT_SPONSOR'), //Select Sponsor
                    //store: 'common.UsersComboStore',
                    valueField: 'id',
                    displayField: 'value',
                    editable: false,
                    emptyText: getCommonTranslation('SELECT_SPONSOR'), //Select Sponsor  
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true                
                },{
	                xtype: 'textfield',
	                name: 'sponsorId',
	                fieldLabel: getCommonTranslation('SPONSOR_Id'), //Sponsor Id
	                itemId: 'sponsorId'                                        	
                },{
                    xtype: 'textfield',
                    name: 'sponsorName',                    
                    fieldLabel: getCommonTranslation('SPONSOR_NAME'), //Sponsor Name
                    itemId: 'sponsorName'
                }]
             },{
                xtype: 'fieldcontainer',
                width: 'auto',
                
                items: [{
    		                xtype: 'button',
    		                text: getCommonTranslation('SEARCH'),
    		                itemId: 'SponsorshipListSearchBtn',
    		                buttonAlign: 'left',
    		                ui: 'CustomBtnSubmit',
    		                scale: CONSTANTS.BUTTONSIZE
                		}]
            }]}
        ]
     }]  
});