/**
 * @author akshay.kalbhor
 * This screen will be the base screen which will be shown on Add Sponsorship
 */
Ext.define('Academia.view.sponsorship.sponsorshipListing.AddSponsoredStudent', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.addsponsoredstudent',
	autoScroll: true,
	cls:'horizontalScrollingFixed',
	config: {
		studentId: null
	},
	layout:'vbox',
	defaults:{
		width:'100%'
	},
	// bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,			
	items : [{
		//xtype:'panel',
    	//items:[{
			xtype: 'fieldcontainer',
			style :{marginLeft: '10px'},
			defaults: {
                width: 226,
                labelAlign: 'top'
            },
			items: [{
				xtype: 'livesearchcombo',
			    labelAlign: 'top',
			    width: 226,
			    queryParam: 'name',
		    	allowBlank: false,
		    	name: 'studentName',
		    	itemId: 'studentName',
		    	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
		    	displayField: 'value',
	            valueField: 'id',
	            displayTpl : new Ext.XTemplate(
	             		'<tpl for="."between=" ">',
	             		'{[typeof values === "string" ? values : values["value"]]}'+
	             		'</tpl>'
	             		),
		    	 listeners: {
	                 render: function(combo) {
	                     var store = Ext.create('Academia.store.sponsorship.Students');
	                     combo.bindStore(store);
	                 },
	                 select: function(combo) {
	                 	this.up('panel').setStudentId(combo.getValue());
	                 }
	             }
			}]
		},{
			xtype: 'sponsorfeeheadgrid'
			}
		]  	//}]
});