/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bulkUploadDocAndNotesGrid',
    store: 'student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesGridStore',
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'button',
        text: 'Refresh',
        itemId: 'btnRefresh',
        tooltip: 'Refresh',
        glyph: ICONGLYPH.FORMATGLYPH,
        handler: function () {
            var myGridStore = this.ownerCt.ownerCt.getStore();
            myGridStore.reload();
        }
    }/*, {
        xtype: 'button',
        text: getCommonTranslation('IMPORT_UTILITY_FORCE_RUN'),
        itemId: 'btnForce',
        tooltip: 'Force run job',
        glyph: ICONGLYPH.FORMATGLYPH
    }*/],
    columns: [{
        header: getPersonModuleTranslation('ACADEMICS_TOPIC'),
        dataIndex: 'academicTopics',
        flex: 1,
        renderer: function (obj) {
            if (obj.value) {
                return obj.value;
            }
        }
    }, {
        header: getPersonModuleTranslation('ACADEMICS_SUB_TOPIC'),
        dataIndex: 'academicSubTopics',
        flex: 1,
        renderer: function (obj) {
        	if (obj.value) {
                return obj.value;
            }
        }
    }, {
        header: getPersonModuleTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1
    }, {
        header: getPersonModuleTranslation('BATCH'),
        dataIndex: 'batch',
        flex: 1,
        renderer: function (obj) {
        	if (obj.value) {
                return obj.value;
            }
        }
    }, {
        header: getPersonModuleTranslation('PERIOD'),
        dataIndex: 'period',
        flex: 1,
        renderer: function (obj) {
        	if (obj && obj.value) {
                return obj.value;
            }else{
				return "";
			}
        }
    }, {
        header: getPersonModuleTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTerm',
        flex: 1,
        renderer: function (obj) {
        	if (obj && obj.value) {
                return obj.value;
            }else{
				return "";
			}
        }
    }, {
        header: getCommonTranslation('UPLOADED_FILE'),
        dataIndex: 'zipFileName',
        flex: 1,
        renderer: function (value) {
            if (value) {
                return '<a href="#">' + value + '</a>';
            }
        }
    }, {
        header: getCommonTranslation('LOG_STATUS'),
        dataIndex: 'logFileName',
        flex: 1,
        renderer: function (value) {
            if (value) {
                return '<a href="#">' + value + '</a>';
            }
        }
    }, {
        header: getCommonTranslation('UPLOADED_BY'),
        dataIndex: 'uploadedBy',
        flex: 1,
        renderer: function (obj) {
            if (obj.value) {
                return obj.value;
            }
        }
    }, {
        header: getCommonTranslation('UPLOADED_ON'),
        dataIndex: 'uploadedOn',
        flex: 1,
        renderer: function (val) {
            var mergedDate = dateRender(val) + ' ' + timeRender(val);
            return mergedDate;
        }
    }]
});