/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.student.currentEnrollmentReport.StudentStartingReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentstartingreportgrid',
	store: 'student.studentenrollmentreport.StudentStartingReportStore',
	title: getCommonTranslation('STARTING_STUDENTS'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [/*{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'student.report.StdDemographicReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}*/]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
	},{
		header:  getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		sortable: true,
		flex:.1
	},{
		header:  getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		sortable: true,
		flex:.1
	},{
		header:  getCommonTranslation('STARTING_DATE'),
		dataIndex: 'startingDate',
		sortable: true,
		renderer : function(value){
			return dateRender(value);
		},
		flex:.1
	}]
});
