/**
 * @author Amit G
 */
Ext.define('Academia.view.student.disciplinaryActionsReport.StudentDisciplinaryActionsReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentdisciplinaryactionsreportgrid',
	//store: 'student.report.StdDemographicReportGridStore',
	store: 'student.report.StudentDisciplinaryActionReportStore',
	title: getCommonTranslation('STUDENT_DISCIPLINARYACTIONS_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            //store: store,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
	}],*/
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);

		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.report.StudentDisciplinaryActionReportStore');
	},
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	}/*,{
		header:  getCommonTranslation('CATEGORY_OF_INCIDENT'),
		dataIndex: 'categoryOfIncident',
		flex:.1
	}*/,{
		header:  getCommonTranslation('TYPE_OF_INCIDENT'),
		dataIndex: 'incidentTypeName',
		flex:.1
	},{
		header:  getCommonTranslation('DATE_OF_INCIDENT'),
		dataIndex: 'dateOfIncident',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('INCIDENT_DETAILS'),
		dataIndex: 'disciplinaryIncidentDetails',
		flex:.1
	}/*,{
		header:  getCommonTranslation('INCIDENT_RATING'),
		dataIndex: 'incidentRating',
		flex:.1
	}*/,{
		header:  getCommonTranslation('REPORTER_NAME'),
		dataIndex: 'reportedByUserName',
		flex:.1
	},{
		header:  getCommonTranslation('ACTION_TAKEN'),
		dataIndex: 'actionTaken',
		flex:.1
	},{
		header:  getCommonTranslation('DATE_OF_ACTION'),
		dataIndex: 'dateOfAction',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('REMARK'),
		dataIndex: 'disciplinaryRemark',
		flex:.1
	}/*,{
		header:  getCommonTranslation('REPORTED_USER_NAME'),
		dataIndex: 'reportedByUserName',
		flex:.1
	},{
		header:  getCommonTranslation('DISCIPLINARY_REMARK'),
		dataIndex: 'disciplinaryRemark',
		flex:.1,
		//hidden:true,
	}*/,{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:true
	},/*{
		header:  getCommonTranslation('SUBJECT'),
		dataIndex: 'subject',
		flex:.1,
		hidden:true
	},*/{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		hidden:true
	}]
});
