/**
 * @author priyanshi sharma
 * 
 */
Ext.define('Academia.view.student.feeRegistrationFormSetup.FeeRegistrationFormSetupFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.feeregistrationformsetupfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'feeRegSetupAcademy',
            itemId: 'feeRegSetupAcademyItemId',
            fieldLabel: getCommonTranslation('ACADEMY'),
            displayField: 'value',
            valueField: 'id',
            queryParam: 'name',
            store:Ext.create('Academia.store.student.feeRegistrationFormSetup.FeeRegFormSetupAcademyStore'),
            minChars: 3,
            allowBlank:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: 'all',
            forceSelection: true,
            style:{
            	marginTop:'11px !important'
            },
            listConfig: {
                listeners: {
                	beforeshow: function(picker) {
                		//picker.minwidth = picker.up('combobox').getSize().width;
                		var combo = picker.up('combobox');
                		picker.setWidth(combo.getWidth());
                	}
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND')
            }
        },{
            xtype:'panel',
            cls : 'panelNoSpace',
            width: 300,
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items:[{
            	xtype: 'multiselectcombofield',
            	name: 'feeRegSetupLocation',
            	itemId: 'feeRegSetupLocationItemId',
            	fieldLabel: getCommonTranslation('LOCATION'),
            	displayField: 'locationName',
                valueField: 'locationId',
                store:Ext.create('Academia.store.student.feeRegistrationFormSetup.FeeRegFormSetupLocationStore'),
            	cls:'commonAutoHeightMultiselectField multiBrandCampusCls',
            	allowBlank:false,
            	forceSelection: true,
            	disabled:true,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				//picker.minWidth = picker.up('combobox').getSize().width;
            				var combo = picker.up('combobox');
                    		picker.setWidth(combo.getWidth());
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND')
            	}
            }]
    	}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	style: {
    		marginLeft: '-2px'
    	},
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SEARCH'),
    		itemId: 'searchBtnFeeRegSetupItemId',
    		buttonAlign: 'left',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		itemId: 'resetFeeRegSetupfilterItemId',
    		buttonAlign: 'left',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
});