/**
 * @author Amit G
 */
Ext.define('Academia.view.student.incidentsReport.StudentNegativeIncidentsReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentnegativeincidentsreportgrid',
	//store: 'student.report.StudentNegativeIncidentsReportStore',
	title: getCommonTranslation('STUDENT_NEGATIVE_INCIDENT_REPORT'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);

		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.report.StudentNegativeIncidentsReportStore');
	},

	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		itemId: 'studentId',
		renderer:function(value, meta, record){
			//var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
			//var portalId = baseController.getCurrentLoggedPortalId();
			if(!isNullOrEmpty(value)) {	
				return '<a href=#>'+value+'<a>';
			}else if(!isNullOrEmpty(value)) {	
				return value;
			}
			return '';
		}
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('TYPE_OF_INCIDENT'),
		dataIndex: 'incidentTypeName',
		flex:.1
	},{
		header:  getPersonModuleTranslation('DATE_OF_INCIDENT'),
		dataIndex: 'dateOfIncident',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('INCIDENT_DETAILS'),
		dataIndex: 'disciplinaryIncidentDetails',
		flex:.1
	},{
		header:  getCommonTranslation('INCIDENT_RATING'),
		dataIndex: 'incidentRating',
		flex:.1
	},{
		header:  getCommonTranslation('REPORTER_NAME'),
		dataIndex: 'reportedByUserName',
		flex:.1
	},{
		header:  getPersonModuleTranslation('ACTION_TAKEN'),
		dataIndex: 'actionTaken',
		flex:.1
	},{
		header:  getPersonModuleTranslation('DATE_OF_ACTION'),
		dataIndex: 'dateOfAction',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
        header: getPersonModuleTranslation('OUTCOME'),
        dataIndex: 'outcome',
        sortable: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('PENALTY'),
        dataIndex: 'penalty',
        sortable: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('COURSE_VARIENT'),
        dataIndex: 'courseVarient',
        sortable: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('ASSESSMENT_EVENT'),
        dataIndex: 'assessmentEvent',
        sortable: true,
        flex: .1
    },{
		header:  getCommonTranslation('REAMRK'),
		dataIndex: 'disciplinaryRemark',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		hidden:true
	}]
});
