/**
 * @author Prakash Sharma
 */
Ext.define('Academia.view.student.studentFeePayerReport.StudentFeePayerReportFilter', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.studentfeepayerreportfilter',
	autoScroll: true,
	cls:'customSearchPanel',
    plugins:"formlabelrequired",
	items: [{
		xtype:'form',
		cls:'panelNoSpace',
		items:[{
			xtype:'fieldcontainer',
			layout : 'hbox',
			style:{'margin-left':'-4px !important'},
			defaults: {
				labelAlign:'top'
			},
			items:[{
				xtype : 'radiogroup',
				itemId : 'feePayerRadioUnitId',
				width:446,
				layout: 'hbox',
				items : [{
					boxLabel : getProgramandcourseTranslation('ACADEMY_LOCATIONS'),
//					translationKey: 'ACADEMY_LOCATIONS',
					name : 'feePayerRadioUnit',
					inputValue : 'AL',
					checked : true	
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'multiselectcombofield',
				width: 960,
				height:58,
				name: 'multiselectAcademyId',
				itemId: 'multiselectAcademyId',
				allowBlank : false,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				displayField:'value',
				valueField:'id',
				matchFieldWidth:true,
				maxLength:15000,
				autoloadStore: false,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
	        	listeners  :{
	        		render : function(combo){
	        			var store=Ext.create('Academia.store.common.AcademyLocationNameSeparated');
	        			combo.bindStore(store)
	        		}
	        	}
			}]
			},{
				xtype:'fieldset',
				title:getServiceRequestTranslation('MORE_FILTERS'),
				layout:'vbox',
				frame:true,	
				collapsible:true,
				collapsed:true,
				width:'100%',
				defaults: {
					labelAlign: 'top',
				},
				style: {
					marginTop: '40px!important',
				},
				items:[{
					xtype:'fieldcontainer',
					layout: 'hbox',
					defaults: {
						width: 226,
						labelAlign: 'top'
					},
					style:{
//						marginTop:'40px!important'
					},
					items:[{
						xtype: 'customcombobox',
						name:'admissionId',
						itemId: 'admissionId',
						store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
						fieldLabel: getMessagingModuleTranslation('ADMISSION_ID'),
						valueField: 'id',
						displayField: 'valueCode',
						queryParam:'name',
						minChars:3,
						typeAhead:false,
			            //hideTrigger:true,
			            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			            triggerAction: '',
			            forceSelection:true,
						  listConfig: {
							  listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
				                loadingText: getCommonTranslation('SEARCHING'),
				                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				                getInnerTpl: function() {
				                    return '<div class="search-item">' +
				                    '{code} / {value}'  +
				                    '</div>';
				                }
				            }
					},{
						xtype: 'customcombobox',
						name: 'studentId',
						itemId: 'studentId',
						fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
						store: 'feeandpayment.managebill.Student',
						valueField: 'id',
						displayField: 'valueCode',
						queryParam:'studentNameOrCode',
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						enableKeyEvents  : 'true',
						minChars:3,
						typeAhead:false,
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						triggerAction: '',
						hideTrigger:false,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{studentCode} / {studentName}' +
								'</div>';
							}
						}
					}]	
				},{
				    xtype: 'fieldcontainer',
				    layout: 'hbox',
				    defaults: {
				        labelAlign: 'top',
				        width: 226
				    },
				    items: [{
				    	xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('INTAKE_YEAR'),
						name : 'intakeYear',
						itemId : 'intakeYear',
						displayField:'value',
						valueField:'id',
						width:226,
						typeAhead:true,
						forceSelection:true,
						minChars:3,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code}'  +
								'</div>';
							}
						},
						listeners  :{
							render : function(combo){
								var store=Ext.create('Academia.store.common.IntakeYearStore');
								combo.bindStore(store)
							}
						}
					},{
						xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
						name : 'academicTerm',
						itemId : 'academicTerm',
						displayField : 'value',
						valueField : 'id',
						typeAhead : true,
						forceSelection : true,
						hidden : false,
						listeners  :{
							render : function(combo){
								var store=Ext.create('Academia.store.common.AcademicTermStore');
								combo.bindStore(store)
							}
						}
					},{
						xtype: 'customcombobox',
						name: 'programCategory',
						itemId : 'programCategory',
						fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
						store:'program.ProgramCategoryStore',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
					}]
				},{
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [{
		             	xtype: 'customcombobox',
		                 name: 'programGroupId',
		                 itemId:'programGroupId',
		                 fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
		                 store:'Academia.store.common.AssignedProgramGroupStore',
		                 displayField:'value',
		                 valueField:'id',
		                 forceSelection:true,
		                 //allowBlank: false
		             },{
		            	 xtype: 'customcombobox',
			    			//width:460,
			    			name:'program',
			    			store: 'Academia.store.common.ProgramByAcAndLoIdStore',
			    			//store: 'program.ProgramByGroupIdStore',
			    			itemId:'program',
			    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//			    			translationKey: 'PROGRAM_CODE_OR_NAME',
			    			valueField: 'id',
			    			displayField: 'valueCode',
			    			queryParam:'programName',
			    			minChars:3,
			    			allowBlank: true,
			    			typeAhead:false,
			    			matchFieldWidth:true,
			               // hideTrigger:false,
			                //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
//			                enableKeyEvents  : 'true',
			                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//			                triggerAction: '',
			                forceSelection:true,
			    			  listConfig: {
			    				  listeners: {
			    						beforeshow: function(picker) {
			    							picker.minWidth = picker.up('combobox').getSize().width;
			    						}
			    					},
			    	                loadingText: getCommonTranslation('SEARCHING'),
			    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    	                getInnerTpl: function() {
			    	                    return '<div class="search-item">' +
			    	                        '{code} / {value}'+ 
			    	                    '</div>';
			    	                }
			    	            }
			    		
			            },{
		                 xtype: 'customcombobox',
		                 name: 'batch',
		                 itemId: 'batch',
		                 fieldLabel: getPersonModuleTranslation('BATCH'),
		                 queryMode: 'local',
		                 displayField: 'value',
		                 valueField: 'id',
		             	 typeAhead : true,
		             	 disabled:true,
						 forceSelection : true,
		                 listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                         combo.bindStore(store);
		                     }
		                 }
		             }]
		        },{
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [{
		                xtype: 'customcombobox',
		                name: 'section',
		                itemId: 'section',
		                store: 'Academia.store.completion.completionform.SectionByBatch',
		                fieldLabel: getPersonModuleTranslation('SECTION'),
		                //queryMode: 'local',
		                valueField: 'id',
		                displayField: 'value',
		                queryParam:'qry',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		    			disabled:true,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND')
		    	            }
		            },{
		            	 xtype: 'customcombobox',
		                 name: 'feePayerType',
		                 fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_TYPE'),
		                 itemId: 'feePayerTypeId',
		                 valueField: 'value',
		                 displayField: 'name',
		                	 listeners: {
				                    render: function(combo) {
				                        var store = Ext.create('Academia.store.student.report.StudentFeePayerReportFilterDropdownStore');
				                        combo.bindStore(store);
				                    }
				                }
		            },{
						xtype: 'checkboxfield',
						width: 226,
						style: 'margin-top: 25px; margin-left: 10px',
						labelAlign: 'right',
						width: 230,
						boxLabel: getPersonModuleTranslation('STUDENT_WITHOUT_FEE_PAYER'),
						name: 'withoutFeePayer',
						inputValue: true
					}]
		        }]
			},{
				xtype: 'fieldcontainer',
				width: '100%',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'btnSearch',
					buttonAlign: 'left',
					formBind : true,
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE               
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'btnReset',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
	}]

});
