/**
 * @author Prakash Soni
 */
Ext.define('Academia.view.student.studentFeePayerReport.StudentFeesRegistrationReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentfeesregistrationreportgrid',
	store: 'student.report.StudentFeesRegistrationReportGridStore',
	title: getCommonTranslation('STUDENT_FEES_REGISTRATION_DETAILS'),
	border: true,
	selType: 'checkboxmodel',
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId : 'dockedItemId',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.StudentFeesRegistrationReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'startRegistrationBtn',
		tooltip: getCommonTranslation('START_REGISTRATION'),
		text: getCommonTranslation('START_REGISTRATION')
	},{
		xtype: 'button',
		itemId: 'sendMessageBtn',
		tooltip: getCommonTranslation('SEND_MESSAGE'),
		text: getCommonTranslation('SEND_MESSAGE')
	},
	'->',{
		xtype: 'button',
		itemId: 'exportReportItemId',
		disabled:true,
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS')
	}],
	columns: [{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentIds',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('BRAND_CAMPUS'),
		dataIndex : 'academyLocationName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('REGISTRATION_STATUS'),
		dataIndex : 'registrationStatus',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('RETURNING_TO_SCHOOL'),
		dataIndex : 'returningToSchool',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TUITION_FEE_PLAN'),
		dataIndex : 'feePlanRuleDesc',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TRANSFERRING_SCHOOL'),
		dataIndex : 'transfferdAcademyLocation',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SERVICES_SELECTED'),
		dataIndex : 'servicesSelected',
		flex : 1,
		sortable : true
	}]
});
