/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.student.studentResultReport.StudentResultReportFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.studentresultreportfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    modal: true,
    method: 'POST',
    standardSubmit : false,
    plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 462,
    		labelAlign: 'top'
    	},
    	items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            name: 'academyLocationCombo',
            itemId: 'academyLocationCombo',
			style:{marginLeft:'10px'},
            store: 'committee.committee.CommitteeALMappingComboStore',
            displayField: 'value',
            editable:false,
			typeAhead:false,
            forceSelection:true,
            valueField: 'id'
        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'program',
			itemId : 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store : 'feeandpayment.finance.FinanceALProgramList', 
			displayField:'codeValue',
			valueField:'programId',			
			typeAhead : true,           
            hideTrigger:false,  
    	    triggerAction: 'all',
    	    queryParam:'name',
            minChars:3,
            forceSelection:true,
			style:{marginLeft:'10px'},
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId : 'batchId',
			fieldLabel: getCommonTranslation('BATCH'),
			store:'common.CurrentBatchStoreByStudentID',
        	displayField : 'code',
        	valueField : 'id',
        	forceSelection:true,
			typeAhead:true,
			disabled : true
		},{
			xtype: 'customcombobox',//'multiselectcombofield',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : 'common.CurrentPeriodStoreByStudentID',
        	displayField : 'code',
        	valueField : 'id',
			//maxLength:10000,
			forceSelection:true,
			autoloadStore: false,
			editable:false,
			typeAhead:true,
			disabled:true,
			hidden: true
		}]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
        cls:'windowBtnPos',
        items: [ {
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
			style:{marginLeft:'10px'},
            formBind:true
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]
});