/**
 * @author Amit G
 */
Ext.define('Academia.view.student.studentServiceOptInReport.StudentServiceOptInReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentserviceoptinreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'customcombobox',
				name : 'serviceName',
				itemId:'serviceNameId',
				fieldLabel : getCommonTranslation('SERVICE_NAME'),
				store : 'student.report.serviceOptInReport.ServiceOptInReportServiceNameStore',
				valueField : 'id',
				editable : false,
				displayField : 'value'
			},{
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId: 'studentId',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.finance.FinanceBlokedStudFilterStudentByALStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			}]
		},{
			xtype:'fieldset',
			title:getServiceRequestTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top',
				//width:226
			},
			style: {
				marginTop: '40px!important',
				//marginLeft:'-10px !important'
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:226
				},
				items:[{
	            	 xtype: 'customcombobox',
		    			name:'PROGRAM_NAME',
		    			store: 'student.report.serviceOptInReport.ServiceOptInReportProgramStore',
		    			itemId:'programId',
		    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    			valueField: 'id',
		    			displayField: 'valueCode',
		    			queryParam:'qry',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{code} / {value}'+ 
		    	                    '</div>';
		    	                }
		    	            }
		    		
		            },{
		                 xtype: 'customcombobox',
		                 name: 'BATCH_NAME',
		                 itemId: 'batchId',
		                 fieldLabel: getPersonModuleTranslation('BATCH'),
		                 disabled:true,
		                 editable: false,
		                 queryMode: 'local',
		                 displayField: 'value',
		                 valueField: 'id',
		                 listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.student.report.serviceOptInReport.ServiceOptInReportBatchStore');
		                         combo.bindStore(store);
		                     }
		                 }
		             },{
			 				xtype : 'customcombobox',
							name : 'seatType',
							itemId: 'seatTypeId',
							disabled:true,
							fieldLabel : getCommonTranslation('SEAT_TYPE'),
							store : 'student.report.serviceOptInReport.ServiceOptInReportSeatTypeStore',
							valueField : 'id',
							editable : false,
							displayField : 'value'
						}]
			},{

				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:226
				},
				items:[{
	                 xtype: 'customcombobox',
	                 name:'periodId',
	                 itemId:'periodId',
	                 disabled:true,
	                 editable: false,
	                 displayField: 'value',
	                 valueField: 'id',
	                 queryMode: 'local',
	                 fieldLabel: getPersonModuleTranslation('PERIOD'),
	                 name: 'PERIOD_NAME',
	                 listeners: {
	                     render: function(combo) {
	                         var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                         combo.bindStore(store);
	                     }
	                 }
				},{
					xtype: 'customcombobox',
					name: 'SECTION',
					itemId: 'sectionId',
					fieldLabel: getPersonModuleTranslation('SECTION'),
					editable: false,
					 disabled:true,
					valueField: 'sectionId',
					displayField: 'sectionCode',
					queryMode: 'local',
					listeners: {
						render: function(combo) {
							var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
							combo.bindStore(store);
						}
					}

				}]
			
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});