/**
 * @author Kuldeep Yadav
 */

Ext.define('Academia.view.student.studentprofile.AcademicsTopicQuickSearchGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.academicstopicquicksearchgrid',
	title: getPersonModuleTranslation('ACADEMICS_TOPIC'),
	store:'Academia.store.student.studentprofile.AcademicsTopicQuickSearchGridStore',
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getPersonModuleTranslation('ADMISSION_CODE'),
		dataIndex: 'admission',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	},{
		header: getPersonModuleTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if (!isNullOrEmpty(record.data.student)) {
				return record.data.student.code;  
			}else{
				return '';
			}
		}
	},{
		header: getPersonModuleTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	}, {
		header: getPersonModuleTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true/*,
		renderer:function(value,meta,record){
			return value.value;  
		}*/
	}, {
		header: getPersonModuleTranslation('BATCH'),
		dataIndex: 'batch',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	},{
		header: getPersonModuleTranslation('PERIOD'),
		dataIndex: 'period',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value)
				return value.value;
			else 
				return '';  
		}
	},{
		header: getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTerm',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value)
				return value.value;
			else 
				return '';  
		}
	},{
		header: getCommonTranslation('DATE'),
		dataIndex: 'studentDate',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('ACADEMICS_TOPIC'),
		dataIndex: 'academicTopics',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	},{
		header: getCommonTranslation('ACADEMICS_SUB_TOPIC'),
		dataIndex: 'academicSubTopics',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	}, {
		header: getPersonModuleTranslation('DESCRIPTION'),
		dataIndex: 'description',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				return "";
			} else {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return val;
			}
		}
	},{
		header: getCommonTranslation('CREATED_DATE'),
		dataIndex: 'studentCreatedAt',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('CREATED_BY'),
		dataIndex: 'createdBy',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return val.code.toLowerCase() + '/' + val.value;
		}
	},{
		header: getCommonTranslation('UPDATED_DATE'),
		dataIndex: 'studentUpdatedAt',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('UPDATED_BY'),
		dataIndex: 'updatedBy',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return val.code.toLowerCase() + '/' + val.value;
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'Status',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('UPLOADED_DOCUMENTS'),
		dataIndex: 'academicTopicDocuments',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(rec.record.get('documentName'))) {
				var value1=!isNullOrEmpty(rec.record.get('documentName'))?rec.record.get('documentName'):rec.record.data.name;
				var newPath=rec.record.data.path;    
				var val=!isNullOrEmpty(value1)?value1:newPath;
				return "<a href='javascript:void(0)'>"+val;
			}
			else {
				return "";
			}
		}
	},{
		header: getCommonTranslation('UPLOADED_URLS'),
		dataIndex: 'academicTopicUrls',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(rec.record.get('urlName'))) {
				if(rec.record.get('academicTopicUrls').length == 1) {
					value = rec.record.get('academicTopicUrls')[0].name;
					var value1=!isNullOrEmpty(value)?value:rec.record.get('academicTopicUrls')[0].name;
					var newPath=rec.record.get('academicTopicUrls')[0].path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href="+newPath+" target='_blank'>"+val;
				}
				else {
					var value1=!isNullOrEmpty(rec.record.get('urlName'))?rec.record.get('urlName'):rec.record.data.name;
					var newPath=rec.record.data.path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href='javascript:void(0)'>"+val;
				}
			}
			else {
				return "";
			}
		}
	},{
		header: getPersonModuleTranslation('PUBLISH_ON_STUDENT_OR_PARENT_PORTAL'), 
		dataIndex: 'isPublished',
		flex:.3,
		sortable: true,
		renderer: function(value) {
			if(value == true) {
				return "Yes";
			} else{
				return "No";
			}
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.studentprofile.AcademicsTopicQuickSearchGridStore');
	},
});