/**
 * 
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.student.studentprofile.NominateExaminersGrid',{
	alias : 'widget.nominateexaminersgrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getPersonModuleTranslation('NOMINATE_EXAMINERS'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('EXAMINER_TYPE'),
		dataIndex: 'examinerTypeValue',
		sortable: true,
		hidden:false,
		flex: 1
	},{
		header: getCommonTranslation('EXAMINER_NAME'),
		dataIndex: 'examinerName',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.examinerNameCode) && !isNullOrEmpty(record.data.examinerPrintName)) {
				return record.data.examinerNameCode+"/"+record.data.examinerPrintName;
			}                        
		}
	},{
		header: getCommonTranslation('EXAM_TYPE'),
		dataIndex: 'examTypeValue',
		sortable: true,
		hidden:false,
		flex: 1
	},{
		header: getCommonTranslation('EMAIL_ADDRESS'),
		dataIndex: 'emailId',
		sortable: true,
		hidden:true,
		flex: 1
	},{
		header: getCommonTranslation('CONTACT_NUMBER'),
		dataIndex: 'mobileNumber',
		sortable: true,
		hidden:false,
		flex: 1
	},{
		header: getPersonModuleTranslation('DESCRIPTION'),
		dataIndex: 'description',
		sortable: true,
		hidden:false,
		flex: 1
	},{
		header: getPersonModuleTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.auditIdCode) && !isNullOrEmpty(record.data.auditIdName)) {
				return record.data.auditIdCode+"/"+record.data.auditIdName;
			}                      
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.postGraduateManagement.NominateExaminersStore');
	}
});