/**
 * 
 * @author Amit G
 */
Ext.define('Academia.view.student.studentprofile.StudentOnlineDocumentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentonlinedocumentgrid',
	title: getPersonModuleTranslation('LIST_OF_ONLINE_DOCUMENTS'),
	border: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getPersonModuleTranslation('DOCUMENTS_NAME'),
		dataIndex: 'documentName',
		itemId: 'documentNameItem',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('DOCUMENTS_TYPE'),
		dataIndex: 'documentType',
		itemId: 'documentTypeItem',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			var msg = "";
			if (!isNullOrEmpty(record.data.isPreDefined) && record.data.isPreDefined) {
				if (!isNullOrEmpty(value)) {
					if(!isNullOrEmpty(record.data.isElectronic) && record.data.isElectronic){
						msg = '<a href="#">' + columnObjRender(value, "value") + '</a>';
					} else {
						msg = columnObjRender(value, "value");
					}
				}
			} else {
				if (!isNullOrEmpty(record.data.documentName)) {
					if(!isNullOrEmpty(record.data.isElectronic) && record.data.isElectronic){
						msg = '<a href="#">' + record.data.documentName + '</a>';
					} else {
						msg = record.data.documentName;
					}
				}
			}
			return msg;
		}
	}, {
		header: getPersonModuleTranslation('DATE_SUBMISSION'),
		dataIndex: 'submissionDate',
		sortable: true,
		flex: .2,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('RETURNED_DATE'),
		dataIndex: 'returnedDate',
		itemId: 'returnedDateItem',
		sortable: true,
		flex: .2,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('MODE_SUBMISSION'),
		dataIndex: 'modeOfSubmission',
		sortable: true,
		flex: .2,
		renderer: function(value) {
			if (!isNullOrEmpty(value)) {
				value = getPersonModuleTranslation(value);
			} else {
				value = '';
			}
			return value;
		}
	}, {
		header: getPersonModuleTranslation('INSPECTION_DATE'),
		dataIndex: 'inspectionDate',
		itemId: 'inspectionDateItem',
		sortable: true,
		flex: .2,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getAdmissionTranslation('ONLINE_DOCUMENT_STATUS'),
		dataIndex: 'documentStatusCSM',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			if (!isNullOrEmpty(value)) {
				if (value.code == 'PENDING' || value.code == 'PENDING_OPTIONAL') {
					return '<span style="color:red;">' + value.value + '</span>';
				} else { 
					return value.value;
				}
			} else {
				return "";
			}
		}
	}, {
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		sortable: true,
		flex: .2
	}, {
		header: getAdmissionTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('REMARK'),
		dataIndex: 'remark',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			if (!isNullOrEmpty(value)) {
				return '<a href="#">View</a>';
			}
			return '';
		}
	},{
		header: getCommonTranslation('PREVIEW'),
		dataIndex: 'previewDoc',
		itemId: 'onlineDocGridPreviewBtn',
		renderer: function(value, meta, record) {
			if(isImageOrPDFDocument(record.data.path)){
				return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getFeeAndPaymentCommonTranslation('PREVIEW')+'</a>';
			}
			else{
				return "-";
			}
		}
	},{
		header: getCommonTranslation('DATE_TIME_DMS'),
		dataIndex: 'sentToDMSDate',
		sortable: true,
		flex: .2,
		hidden: true,
		renderer: function(date) {
			if (!isNullOrEmpty(date)) {
				return dateRender(date)+" - "+timeRender(date);
			} else {
				return "";
			}
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore(this$.personType);
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function(personType) {
		return Ext.create('Academia.store.student.studentprofile.StudentProfileOnlineDocumentStore');
	}
});