var studentConsolidateSummaryStore = Ext.create('Academia.store.attendance.attendancereport.AttendanceReportGrid');
Ext.define('Academia.view.studentPortal.attendancereport.AttendanceReportGridConsolidatedStudentReport',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.attendancereportgridconsolidatedstudentreport',
	title: getMegaMenuTranslation('SP_COURSE_ATTENDANCE'),
	store : studentConsolidateSummaryStore,
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'attendancemainstructure':1
		}
	},
	dockedItems : [ {
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : studentConsolidateSummaryStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);
    },
   columns: [{
		header : getProgramandcourseTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_SESSIONS'),
		dataIndex : 'totalRecords',
		flex : 1,
		sortable : true,
		renderer : function(value,records) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getProgramandcourseTranslation('TOTAL_PRESENT'),
		dataIndex : 'presentRecords',
		flex : 1,
		sortable : true
	},{
		header : getProgramandcourseTranslation('TOTAL_ABSENT'),
		dataIndex : 'absentRecords',
		flex : 1,
		sortable : true
	},{
		header : getProgramandcourseTranslation('TOTAL_PRESENT_PERCENT'),
		dataIndex : 'presentPercentage',
		flex : 1,
		sortable : true
	},{
		header : getProgramandcourseTranslation('ABSENT_PERCENT'),
		dataIndex : 'absentPercentage',
		flex : 1,
		sortable : true
	}]
});
