/**
 * @author Raghavendra
 */
Ext.define('Academia.view.studentportalangularloginsetup.StudentPortalAngularLoginConfigureMenu', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.studentportalangularloginconfiguremenu',
    plain: true,
    autoScroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    width: '100%',
    defaults: {
        width: '100%'
    },
    items: [{
        xtype: 'grid',
    	itemId: 'moduleMainGrid',
        title: getCommonTranslation('STUDENT_PORTAL_SIDE_MENU_CONFIGURATION'),
        store: Ext.create('Academia.store.setup.loginPageSetup.AngularConfigureMenuListStore'),
        border: true,
        autoScroll: false,
        cls: 'clsAssigneeApproverGrid',
        columns: [
            {
                text: getCommonTranslation("MODULE_NAME"),
                dataIndex: 'moduleName',
                flex: 1,
                sortable: true,
                editor: {
                    xtype: 'textfield',
                    allowBlank: false
                }
            }, {
                text: getCommonTranslation("VISIBILITY"),
                dataIndex: 'isVisiable',
                xtype: 'checkcolumn',
                flex: 1,
                sortable: false
            }, {
                text: getCommonTranslation("SEQUENCE"),
                dataIndex: 'sequence',
                flex: 1
            }
        ],
        plugins: [
            Ext.create('Ext.grid.plugin.CellEditing', {
                clicksToEdit: 1
            })
        ],
        viewConfig: {
            plugins: [
                Ext.create('Ext.grid.plugin.DragDrop', {
                    dragText: getCommonTranslation('SELECT_RECORD_FOR_DRAG_DROP')
                })
            ],
            listeners: {
                drop: function (node, data, dropRec, dropPosition) {
                    var store = this.getStore();
                    store.each(function (record, index) {
                        record.set('sequence', index + 1);
                    });
                },
                beforedrop: function(node, data, overModel, dropPosition, dropHandlers) {
                    if(data.records[0].data.moduleCode == "DASHBOARD" || (data.records[0].data.sequence > 1 && dropPosition == 'before')) {
                    	dropHandlers.cancelDrop();
                    }
                }
            }
        },
        dockedItems: [
            {
                xtype: 'toolbar',
                dock: 'top',
                items: [
                    {
                        text: getCommonTranslation('SAVE'),
                        itemId: 'saveMenuConfigurationBtn'
                    }
                ]
            }
        ]
    }, {
    	xtype: 'grid',
    	itemId: 'subModuleChildGrid',
    	store: Ext.create('Academia.store.setup.loginPageSetup.AngularConfigureSubMenuListStore'),
    	border: true,
    	autoScroll: false,
    	hidden: true,
    	cls: 'clsAssigneeApproverGrid',
    	columns: [{
    		text: getCommonTranslation("MODULE_NAME"),
    		dataIndex: 'moduleName',
    		flex: 1,
    		sortable: true,
    		editor: {
    			xtype: 'textfield',
    			allowBlank: false
    		}
    	}, {
    		text: getCommonTranslation("VISIBILITY"),
    		dataIndex: 'isVisiable',
    		xtype: 'checkcolumn',
    		flex: 1,
    		sortable: false
    	}, {
    		text: getCommonTranslation("SEQUENCE"),
    		dataIndex: 'sequence',
    		flex: 1
    	}],
        plugins: [
            Ext.create('Ext.grid.plugin.CellEditing', {
                clicksToEdit: 1
            })
        ],
        viewConfig: {
            plugins: [
                Ext.create('Ext.grid.plugin.DragDrop', {
                    dragText: getCommonTranslation('SELECT_RECORD_FOR_DRAG_DROP')
                })
            ],
            listeners: {
                drop: function (node, data, dropRec, dropPosition) {
                    var store = this.getStore();
                    store.each(function (record, index) {
                        record.set('sequence', index + 1);
                    });
                }
            }
        },
        dockedItems: [{
        	xtype: 'toolbar',
        	dock: 'top',
        	items: [{
        		text: getCommonTranslation('SAVE'),
        		itemId: 'saveSubMenuConfigurationBtn'
        	}]
        }]
    }]
});
