/**
 * @author Shashi Kumara
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleAcademyLocationGrid', {
	extend : 'Ext.panel.Panel',
	alias: 'widget.businessruleacademylocationgrid',
//	title: getExaminationTranslation('ACADEMY_LOCATION'),
	
	items:[{
		xtype:'label',
		itemId:'degreeClassificationNameLabel',
	},{
		xtype:'grid',
		title:getExaminationTranslation('ACADEMY_LOCATION'),
		store: 'sunsuccess.BusinessRuleAcademyLocationGridStore',
		itemId:'businessruleacademylocationid',
		border: true,
		autoScroll:false,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store: 'sunsuccess.BusinessRuleAcademyLocationGridStore',
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			}]
		}],
	tbar: [{
			xtype: 'button',
			itemId: 'btnLinkAlItemId',
			tooltip: getExaminationTranslation('NEXT'),
	        scale: CONSTANTS.BUTTONSIZE,
			text:'<div style="color: black">'+getExaminationTranslation('NEXT')+'</div>',
		},{
			xtype: 'button',
			itemId: 'btnReset',
			tooltip: getExaminationTranslation('RESET'),
			text:'<div style="color: black">'+getExaminationTranslation('RESET')+'</div>',
		},{			
			xtype: 'customcombobox',
			name: 'academylocationname',
			itemId:'academylocationnameId',
			store: 'sunsuccess.BusinessRuleAcademyLocationGridStore',
			valueField: 'id',
			displayField: 'value',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryParam:'qry',
			queryMode: 'remote',
			width:226,
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: '',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}],
		columns: [{
			header: getExaminationTranslation('ACADEMY_LOCATION'),
			dataIndex: 'value',
			flex:.9,
			sortable:true
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
		}]
		}]
		});
		var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
		clicksToEdit: 1,
		listeners : {
			beforeedit:function( editor, context, e ){ 
			}
		}
});