Ext.define('Academia.view.survey.sendSurvey.AdHocSurveyReportFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.adhocsurveyreportfilter',
    plugins : "formlabelrequired",
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 446,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            itemId: 'activeSurveyListComboAdHocSurveyReportItemId',
            name:'activeSurveyListComboAdHocSurveyReport',
            store: Ext.create('Academia.store.survey.SpecificSurveyListStore'),	    
            valueField:'surveyId',
            displayField:'surveyName',
            editable:false,
            readOnly: false,
			fieldLabel: getCommonTranslation('LIST_OF_ACTIVE_SURVEY'),
			allowBlank: false,
			matchFieldWidth:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners:{
				afterrender: function(combo) {
		            // Ensure that the store is loaded and ready
		            var store = combo.getStore();
		            
		            // Check if the store has not been loaded yet
		            if (store) {
		                store.on('beforeload', function(store) {
		                    store.getProxy().extraParams = {
		                    	isAdhoc: true // Pass additional params before loading
		                    };
		                });
		            }
		        }
			}
        }]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchAdHocSurveyReportBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetAdHocSurveyReportBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});