Ext.define('Academia.view.survey.sendSurvey.SendSurveyAdHocGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sendsurveyadhocgrid',
	title: getAdmissionTranslation('SEARCH_RESULT'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sendsurveystructure':1
		}
	},
	tbar: [],
	columns: [{
		header: getCommonTranslation('SURVEY_ID'),
		dataIndex: 'surveyId',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_NAME'),
		dataIndex: 'surveyName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('PARTICIPANT_ID'),
		dataIndex: 'participantId',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('PARTICIPANT_FIRST_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('PARTICIPANT_LAST_NAME'),
		dataIndex: 'lastName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('EMAIL'),
		dataIndex: 'emailId',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('EMAIL_SENT'),
		dataIndex: 'emailSent',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(!isNullOrEmpty(value) && (value=="true" || value==true)){
				return  getCommonTranslation('YES');
			}else{
				return getCommonTranslation('NO');
			}
		}
	} ,{
		header: getCommonTranslation('NO_OF_QUESTIONS'),
		dataIndex: 'noOfQuestions',
		flex:.3,
		sortable: true
	},{
		header: getCBTranslation('survey_whetherAnonymous'),
		dataIndex: 'isAnonymized',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(!isNullOrEmpty(value) && (value=="true" || value==true)){
				return  getCommonTranslation('YES');
			}else{
				return getCommonTranslation('NO');
			}
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.survey.SendSurveyAdHocGridStore');
	}
});