/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.translation.FindAndReplaceTranslationWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.findandreplacetranslationwin',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('REPLACE'),
	maxHeight:500,
	width: 300,
	height:300,
	//layout: 'vbox',
	resizable: false,
	items: [{
		xtype: 'form',
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'checkboxgroup',
			fieldLabel: getCommonTranslation('REPLACE_IN'),
			allowBlank: false,
			itemId: 'replaceColumnItemId',
			labelAlign: 'top',
			columns: 2,
		    hidden: true,
			items: [
				{
					boxLabel: getCommonTranslation('DEFAULT_VALUE'),
					name: 'defaultValue',
					inputValue: 'defaultValue',
					checked:  false
				},
				{
					boxLabel: getCommonTranslation('CUSTOMER_DEFINE_VALUE'),
					name: 'customerDefineValue',
					inputValue: 'customerDefineValue',
					checked:  true
				}
			]
		},{
			xtype : 'fieldcontainer',
			layout : {
				type : 'vbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width: '100%',
			items : [{
				xtype:'textfield',
				itemId: 'findFieldWinItemId',
				fieldLabel: getCommonTranslation('FIND'),
				allowBlank: false
			},{
				xtype:'textfield',
				itemId: 'replaceWithWinItemId',
				fieldLabel: getCommonTranslation('REPLACE_WITH'),
				allowBlank: false
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width: '100%',
			defaults : {
				xtype : 'checkbox'
			},
			items :[{
				boxLabel: 'Case sensitive',
				itemId: 'caseSensitiveItemId',
				flex: 1
			}, {
				boxLabel: 'Whole word',
				itemId: 'wholeWordItemId',
				flex: 1
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('REPLACE_ALL'),
				itemId: 'replaceAllWinBtnItemId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CLOSE'),
				ui: 'CustomBtnCancel',
				itemId: 'closeWinBtnItemId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});