/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.translation.TranslationFilterForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.translationfilterform',
    plugins : "formlabelrequired",
    autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		itemId:'translationSearchFilter',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [/*{
			xtype: 'multiselectcombofield',
			itemId: 'objectComboItemId',
			fieldLabel: getCommonTranslation('TRANSLATION_OBJECT'),
			store: 'translation.TranslationObjectStore',
			displayField:'objectName',
		    valueField:'objectName',
		    value: 'ADMISSION',
			maxLength:5000,
			allowBlank: false
		},*/
			{
				xtype:'panel',
				width: 465,
				style : {
					marginTop :'-9px !important',
					marginLeft :'-6px !important'
				},
				items:[{
					xtype: 'multiselectcombofield',
					width: 452,
					labelAlign : 'top',
					name: 'objectCombo',
					itemId: 'objectComboItemId',
					allowBlank : false,
					fieldLabel:getCommonTranslation('TRANSLATION_OBJECT'),
					store : 'translation.TranslationObjectStore',
					cls:'multiBrandCampusCls commonAutoHeightMultiselectField',
					displayField : 'objectName',
					valueField : 'objectName',
					matchFieldWidth:true,
					maxLength:15000,
					autoloadStore: false,
					queryMode:'local',
					
					//value: 'ADMISSION',
					//typeAhead:true,
					//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					//hideTrigger:false,
					//forceSelection:true,
					//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							},
							afterrender: function(combo){
								combo.getStore().on("load", function(store, items){
									try{
										if(items.length==0 && Ext.select('.x-boundlist-item') && Ext.select('.x-boundlist-item').elements[0]){
											Ext.select('.x-boundlist-item').elements[0].hidden = true;
										}
										else if(Ext.select('.x-boundlist-item') && Ext.select('.x-boundlist-item').elements[0]){
											Ext.select('.x-boundlist-item').elements[0].hidden = false;
										}
									}
									catch(e){
										
									}
								});
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{objectName}' +
							'</div>';
						}
					}
				}]
			}
			
			/*,{
			xtype: 'combo',
			itemId: 'objectComboItemId',
			fieldLabel: getCommonTranslation('TRANSLATION_OBJECT'),
			allowBlank: false,
			store: 'translation.TranslationObjectStore',
			displayField:'objectName',
		    valueField:'objectName',
		    value: 'ADMISSION'
		}*/,{
			xtype:'textfield',
			itemId: 'queryItemId',
			allowBlank: false,
			fieldLabel: getCommonTranslation('SEARCH_IN_TRANSLATIONS'),
			emptyText: getCommonTranslation('MINIMUM_THREE_CHARCTERS'),
			minLength: 3
		},{
            xtype: 'customcombobox',
            itemId: 'languageComboItemId',
            name:'languageComboItemId',
            store: 'common.ChangeLanguageStore',	    
            valueField:'code',
            displayField:'itemValue',
            editable:false,
            readOnly: true,
			fieldLabel: getCommonTranslation('LANGAUGE'),
            listeners:{
            	render : function(obj){
            		var languageName = localStorage.getItem('userLanguage');
            		if(languageName==null){
            			obj.setValue('default');
            		}else{
            			obj.setValue(languageName);
            		}
            	}
            }
        }]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		style : {
			marginTop :'-40px !important',
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});