/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.transport.reports.NumberOfUserCoveredReportGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.numberofusercoveredreportgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '50%',
	width: '70%',
	title:getTransportTranslation('NO_OF_USERS_SERVICED'),
	items: [{
		xtype: 'grid',
		store : 'transport.vehicle.JourneyAssignmentUserCount',
		frame: false,
		border:true,
		autoScroll: false,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'transport.vehicle.JourneyAssignmentUserCount',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getTransportTranslation('USER'),
			dataIndex : 'serviceRouteUser',
			flex:1,
			renderer: function(value, metaData, record, row, col, store, gridView) {
				if(!isNullOrEmpty(value)) {
					return value.value;
				}
			}
		},{
			header : getTransportTranslation('ATTENDANCE'),
			dataIndex : 'attendance',
			flex:1,
			renderer:function(value){
				if(!isNullOrEmpty(value)) {
					if(value=='PRESENT'){
						return getCommonTranslation('PRESENT');
					}else{
						return getCommonTranslation('ABSENT');  
					}
				}
			}
		}]
	}]
});