/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.tvet.TVETReportNoOfFilesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.tvetreportnooffilesgrid',
    store: 'tvet.TVETReportNoOfFilesStore',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('TVET_FILE_NAME'),
        dataIndex: 'reportId',
        flex: 1,
        renderer: function(value, meta, record) {
            return value.value;
        }
    },{
        header: getCommonTranslation('TVET_FILE_STATUS'),
        dataIndex: 'fileStatus',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				if ('PENDING' == value) {
					return getCommonTranslation("TVET_PENDING")
				} else if ('COMPLETED' == value) {
					return getCommonTranslation("TVET_COMPLETED")
				} else if ('IN_PROGRESS' == value) {
					return getCommonTranslation("TVET_IN_PROGRESS")
				} else if ('EMAIL_SENT' == value) {
					return getCommonTranslation("TVET_EMAIL_SENT")
				} else if ('ERROR' == value) {
					return getCommonTranslation("TVET_ERROR")
				} else if ('GENERATED' == value) {
					return getCommonTranslation("TVET_GENERATED")
				}
				return value;
			}
            return '';
        }
    },{
        header: getCommonTranslation('TVET_FILE_NO_OF_RECORDS'),
        dataIndex: 'noOfRecords',
        flex: 1,
        sortable: true
    }]
});