/** ====================================================================
* jsPDF table plugin
* Copyright (c) 2014 Nelli.Prashanth,https://github.com/Prashanth-Nelli
* Permission is hereby granted, free of charge, to any person obtaining
* a copy of this software and associated documentation files (the
* "Software"), to deal in the Software without restriction, including
* without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to
* permit persons to whom the Software is furnished to do so, subject to
* the following conditions:
*
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
* LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
* OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
* WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* ====================================================================
*/

(function(jsPDFAPI) {

var  rObj = {}
	,hObj = {}
	,data = []
	,dim = []
	,columnCount
	,rowCount
	,width
	,heigth
	,fdata = []
	,sdata = []
	,SplitIndex = []
	,cSplitIndex = []
	,indexHelper = 0
	,heights = []
	,fontSize
	,jg
	,i
	,tabledata = []
	,x
	,y
	,xOffset
	,yOffset
	,iTexts
	,start
	,end
	,ih
	,length
	,lengths
	,row
	,obj
	,value
	,nlines
	,nextStart
	,propObj={}
	,pageStart = 0
	,footerHeight=0
	,footerData=[];

// Inserts Table Head row

jsPDFAPI.insertHeader = function(data) {
	rObj = {}, hObj = {};
	rObj = data[0];
	for (var key in rObj) {
		hObj[key] = key;
	}
	data.unshift(hObj);
};

//Inserts Footer on each page

jsPDFAPI.insertFooter = function(pageCount,marginConfig,dimension) {	
	var pageHeight=this.internal.pageSize.height-footerHeight+30;
	if(footerHeight==0){
		pageHeight=pageHeight-50;
	}
	var leftMargin=dimension[0];
	
	this.text(leftMargin, pageHeight, "Page -:");
	this.text(leftMargin+40, pageHeight, pageCount.toString());	
	
	footerData=marginConfig.footerData;
	for(var footerText=0;footerText<footerData.length;footerText++){
		if(footerData[footerText]!=null){
			pageHeight=pageHeight+10;			
			this.text(leftMargin, pageHeight, footerData[footerText]);						
		}		
	}
};

// intialize the dimension array, column count and row count

jsPDFAPI.initPDF = function(data,marginConfig,firstpage) {
	if(firstpage){
		dim = [marginConfig.xstart,marginConfig.tablestart,this.internal.pageSize.width-marginConfig.xstart-20-marginConfig.marginright, 250,marginConfig.ystart,marginConfig.marginright,marginConfig.xOffset||5,marginConfig.yOffset || 5];
	}else{
		dim = [marginConfig.xstart,marginConfig.ystart,this.internal.pageSize.width-marginConfig.xstart-20-marginConfig.marginright, 250,marginConfig.ystart,marginConfig.marginright,marginConfig.xOffset||5,marginConfig.yOffset || 5];	
	}
	columnCount = this.calColumnCount(data);
	rowCount = data.length;
	//width = dim[2] / columnCount;
	if(columnCount!=0){
		width = dim[2] / columnCount;
	}
	else if(!Ext.isDefined(width)){
		width = 0;
	}
	height = dim[2] / rowCount;
	dim[3] = this.calrdim(data, dim);
};

//draws table on the document 

jsPDFAPI.drawTable = function(table_DATA, marginConfig,pageNo) {
	fdata = [], sdata = [];
	SplitIndex = [], cSplitIndex = [], indexHelper = 0;
	heights = [],pageCount=	Ext.isDefined(pageNo)?pageNo:1;
	//this.setFont("times", "normal");
	fontSize = this.internal.getFontSize();
	if(!marginConfig){
		marginConfig={
			xstart:20,
			ystart:20,
			tablestart:20,
			marginright:20,
			xOffset:5,
			yOffset:10
		}
	}else{
		propObj={
			xstart:20,
			ystart:20,
			tablestart:20,
			marginright:20,
			xOffset:5,
			yOffset:10
		}
		for(var key in propObj){
			if(!marginConfig[key])
			{
			  	marginConfig[key] = propObj[key];
			}
		}
	}
	pageStart = marginConfig.tablestart;
	xOffset=marginConfig.xOffset;
	yOffset=marginConfig.yOffset;
	footerHeight=(marginConfig.footerHeight!=0)?marginConfig.footerHeight:0;
	this.initPDF(table_DATA,marginConfig,true);
	this.insertFooter(pageCount,marginConfig,dim);
	if ((dim[3] + marginConfig.tablestart + footerHeight + 20 ) > (this.internal.pageSize.height)) {
		jg = 0;
		cSplitIndex = SplitIndex;
		cSplitIndex.push(table_DATA.length);
		for (var ig = 0; ig < cSplitIndex.length; ig++) {
			tabledata = [];
			tabledata = table_DATA.slice(jg, cSplitIndex[ig]);
			this.insertHeader(tabledata);
			this.pdf(tabledata, dim, true, false);
			pageStart = marginConfig.ystart;
			this.initPDF(tabledata,marginConfig,false);
			jg = cSplitIndex[ig];
			if ((ig + 1) != cSplitIndex.length) {
				this.addPage();
				pageCount++;
				this.insertFooter(pageCount,marginConfig,dim);
			}
		}
	} else {
		this.insertHeader(table_DATA)
		this.pdf(table_DATA, dim, true, false);
	}
	return nextStart;
};

//calls methods in a sequence manner required to draw table

jsPDFAPI.pdf = function(table, rdim, hControl, bControl) {
	columnCount = this.calColumnCount(table);
	rowCount = table.length;
	rdim[3] = this.calrdim(table, rdim);
	if(columnCount!=0){
		width = rdim[2] / columnCount;
	}
	else if(!Ext.isDefined(width)){
		width = 0;
	}
	height = rdim[2] / rowCount;
	this.drawRows(rowCount, rdim, hControl);
	this.drawColumns(columnCount, rdim);
	nextStart = this.insertData(rowCount, columnCount, rdim, table, bControl);
	return nextStart;
};

//inserts text into the table 

jsPDFAPI.insertData = function(iR, jC, rdim, data, brControl) {
	// xOffset = 10;
	// yOffset = 10;
	y = rdim[1] + yOffset;
	for ( i = 0; i < iR; i++) {
		obj = data[i];
		x = rdim[0] + xOffset;
		for (var key in obj) {
			if (key.charAt(0) !== '$') {
				if (obj[key] !== null && obj[key] != undefined) {
					cell = obj[key].toString();
				} else {
					cell = '-'; 
				}
				cell = cell + '';
				if (((cell.length * fontSize) + xOffset) > (width)) {
					iTexts=cell.length*fontSize;
					if(cell.replace(/[^A-Z]/g, "").length>7){
						iTexts = cell.length*fontSize*1.2;
					}
					else if(cell.replace(/[^A-Z]/g, "").length>5){
						iTexts = cell.length*fontSize*1.5;
					}
					start = 0;
					end = 0;
					ih = 0;
					if ((brControl) && (i === 0)) {
						this.setFont(this.getFont().fontName, "bold");
					}
					for ( j = 0; j < (iTexts/width); j++) {
						var currentFontSize = fontSize;
						if(cell.replace(/[^A-Z]/g, "").length>7){
							var currentFontSize = currentFontSize*1.2;
						}
						else if(cell.replace(/[^A-Z]/g, "").length>5){
							var currentFontSize = currentFontSize*1.5;
						}
						end+=Math.floor(2*width/currentFontSize)-Math.ceil(xOffset/currentFontSize);
						/*if(cell.indexOf('<img')>=0){  //V2D-27686
							if(j==0){
								var regex = /<img.*?src="(.*?)"/;
								var src = regex.exec(cell)[1];
								this.convertImgToBase64URL(src, 'JPEG', x, y+ih, 75, 75 );
							}
						}
						else{
							this.text(x, y + ih, cell.substring(start, end));					
						}*/
						this.text(x, y + ih, cell.substring(start, end));
						var linesToIncreate = cell.substring(start, end).split(/\r\n|\r|\n/).length*fontSize;
						start = end;
						ih += linesToIncreate;
					}
				} else {
					if ((brControl) && (i === 0)) {
						this.setFont("times", "bold");
					}
					this.text(x, y, cell);
				}
				x += rdim[2] / jC;
			}
		}
		this.setFont("times", "normal");
		y += heights[i];
	}
	/*for(ni=0;ni<10000;ni++){ //V2D-27686
		console.log(ni);
	}*/
	return y;
};

/*jsPDFAPI.convertImgToBase64URL = function(url, format, p1, p2, p3, p4){  //V2D-27686
	var img = new Image();
	var me = this;
    img.onload = function(){
        var canvas = document.createElement('CANVAS'),
        ctx = canvas.getContext('2d'), dataURL;
        canvas.height = img.height;
        canvas.width = img.width;
        ctx.drawImage(img, 0, 0);
        me.addImage(canvas.toDataURL(format), format, p1, p2, p3, p4);
        canvas = null;
    };
    img.src = url;
}*/
//calculates no.of based on the data array

jsPDFAPI.calColumnCount = function(data) {
	var obj = data[0];
	var i = 0;
	for (var key in obj) {
		if (key.charAt(0) !== '$') {++i;
		}
	}
	return i;
};

//draws columns based on the caluclated dimensions

jsPDFAPI.drawColumns = function(i, rdim) {
	x = rdim[0];
	y = rdim[1];
	w = rdim[2] / i;
	h = rdim[3];
	for (var j = 0; j < i; j++) {
		this.rect(x, y, w, h);
		x += w;
	}
};

//calculates dimensions based on the data array and returns y position for further editing of document 

jsPDFAPI.calrdim = function(data, rdim) {
	row = 0;
	x = rdim[0];
	y = rdim[1];
	lengths = [];
	for (var i = 0; i < data.length; i++) {
		obj = data[i];
		length = 0;
		for (var key in obj) {
			if (obj[key] !== null && obj[key] != undefined) {
				if (length < obj[key].length) {
					lengths[row] = obj[key].length;
					//-- changing font size temporary for CAPITAL characters
					if(obj[key].replace(/[^A-Z]/g, "").length>5){
						lengths[row] = Math.ceil(obj[key].length*1.5);
					}
					//-- checking for the linebreaks in string
					if(obj[key].split(/\r\n|\r|\n/).length>1){
						lengths[row] = lengths[row] + ((width/fontSize)*(obj[key].split(/\r\n|\r|\n/).length+2));
					}
					length = lengths[row];
				}
			}
		}++row;
	}
	heights = [];
	for (var i = 0; i < lengths.length; i++) {
		if ((lengths[i] * (fontSize)) > (width-rdim[5])) {
			if(lengths[i]>100){
				nlines = Math.ceil(((lengths[i]+60) * (fontSize)) / width);
			}
			else{
				nlines = Math.ceil(((lengths[i]+20) * (fontSize)) / width);
			}
			heights[i] = (nlines) * (fontSize / 2) +rdim[6]+10;
		} else {
			heights[i] = (fontSize + (fontSize / 2))+rdim[6]+10;
		}
	}
	value = 0;
	indexHelper = 0;
	SplitIndex = [];
	for (var i = 0; i < heights.length; i++) {
		value += heights[i];
		indexHelper += heights[i];
		if (indexHelper > (this.internal.pageSize.height - pageStart - footerHeight - 60) && i!=0) {
			SplitIndex.push(i);
			indexHelper = heights[i];
			pageStart = rdim[4]+30;
		}
	}
	return value;
};

//draw rows based on the length of data array

jsPDFAPI.drawRows = function(i, rdim, hrControl) {
	x = rdim[0];
	y = rdim[1];
	w = rdim[2];
	h = rdim[3] / i;
	
	/*if(eval(heights.join('+')) > (this.internal.pageSize.height - 250)){
		//-- reduce last row's height
		var lastRowCurrentHeight = heights[heights.length-1];
		var heightToReduce = eval(heights.join('+')) - (this.internal.pageSize.height - 250);
		heights[heights.length-1] = lastRowCurrentHeight - heightToReduce;
	}*/
	
	for (var j = 0; j < i; j++) {
		if (j === 0 && hrControl) {
			this.setFillColor(245, 229, 172);//colour combination for table header
			this.rect(x, y, w, heights[j], 'F');
		} else {
			this.setDrawColor(0, 0, 0);//colour combination for table borders you
			this.rect(x, y, w, heights[j]);
		}
		y += heights[j];
	}
};

//converts table to json

jsPDFAPI.tableToJson=function(id,grid){
	var table = document.getElementById(id)
		,keys=[]
		,rows=table.rows
		,noOfRows = rows.length
		,noOfCells = table.rows[0].cells.length
		,i=0
		,j=0
		,data =[]
		,obj={}
		;
	
	for(i=0;i<noOfCells;i++){
		keys.push(rows[0].cells[i].textContent);
	}
	
	for(j=0;j<noOfRows;j++){
		obj={};
		nObj={};
		for(i=0;i<noOfCells;i++){
			try{
				//if(keys[i]!=" "){
					if(j>0 && i==0){
						if(!rows[j].classList.contains('x-grid-row-summary')){
							obj[keys[i]]=j;
						}
						else{
							obj[keys[i]]='';
						}
					}
					if(!grid.removeSerialColumn){
						if(Ext.isDefined(keys[i+1])){
							obj[keys[i+1]]=rows[j].cells[i].textContent.replace(/^\s+|\s+$/gm,'').replace('Click to enter','');
							if(rows[j].cells[i].classList.contains("hideGridDataCls")){
								obj[keys[i+1]]= "";
							}
						}
					}else{
						if(Ext.isDefined(keys[i+1])){
							obj[keys[i+1]]=rows[j].cells[i+1].textContent.replace(/^\s+|\s+$/gm,'').replace('Click to enter','');
							if(rows[j].cells[i+1].classList.contains("hideGridDataCls")){
								obj[keys[i+1]]= "";
							}
						}
					}
					
					if(grid.xtype == "studentportalenrollmentdetailgrid" || grid.xtype == "coreerpstudentenrollmentdetailgrid"){
                    	if($("#"+rows[j].cells[i].id+" .yearlyBadgeCls").length && obj[keys[i+1]].length && obj[keys[i+1]][0]=="Y"){
                    		obj[keys[i+1]] = obj[keys[i+1]].substring(1);
                    	}
                    }
					
					/*if(Ext.isDefined(rows[j].cells[i].getAttribute('type')) && rows[j].cells[i].getAttribute('type')=='gridImageCell'){ //V2D-27686
						obj[keys[i]]=rows[j].cells[i].children[0].children[0].outerHTML;
                    }*/
				//}
			}catch(ex){
				obj[keys[i]]='';
			}	
		}
		for(i=0;i<noOfCells;i++){
			if(keys[i]!=" "){
				nObj[keys[i]]=obj[keys[i]];
			}	
		}
		var isObjEmpty = true;
		try{
			Ext.each(Object.values(nObj), function(objVal){
				if(!isNullOrEmpty(objVal)){
					isObjEmpty = false;
				}
			});
		}
		catch(e){}
		if(isObjEmpty && grid.xtype == 'linkacademylocations' && grid.columns.length === 1) {
			isObjEmpty = false;
		}
		if(!isObjEmpty){
			data.push(nObj);
		}
	}
	return data.splice(1);
};

}(jsPDF.API));

