/**
 * @author sachin.bangar This is used for custom messages for paging toolbar
 */
Ext.define('Ext.ux.grid.CustomPagingToolBar', {
	extend : 'Ext.toolbar.Paging',
	alias : 'widget.custompagingtoolbar',
	alternateClassName : [ 'CustomPagingToolBar' ],
	requires : [ 'Ext.toolbar.Paging' ],
	initComponent : function() {
		var this$ = this;
		Ext.applyIf(this$, {
			listeners : {
				beforerender : function(tbar) {
					this$.setConfigToPagingToolbar();
				},
				afterrender : function(tbar) {
					this$.getStoreCount();
				}
			}
		});

		this$.callParent(arguments);
	},
	setConfigToPagingToolbar: function(){
		if (this.store != undefined && this.store != null) {
			var win = this.up('window');
			if(win){
				this.defaultStorePageSize = CONSTANTS.DEFAULT_WINDOW_GRID_PAGESIZE;//5
			}else{
				this.defaultStorePageSize = CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE;//10
			}
			this.store.pageSize = this.defaultStorePageSize;
		}
	},
	/**
	 * hide show icon on load store
	 * 
	 * @params store paging store
	 */
	iconChange : function(store) {
		var this$ = this;
		var count = store.getCount();
		var currentPage = this$.getPageData().currentPage;
		if (count == 0 && currentPage == 1) {
			this$.setVisible(true);
			this$.hideComponent();
			this$.showDisplayMsg();
		} else if ( !isNullOrEmpty(store.totalCount) && currentPage == 1 
				&& (store.totalCount <= this$.defaultStorePageSize) && this$.defaultStorePageSize<=store.pageSize) {
			this$.setVisible(false);
		} else {
			this$.setVisible(true);
			this$.removeNoDataMsg();
			this$.showComponent();
		}
	},

	/**
	 * get Store count and hide/show paging icon
	 */
	getStoreCount : function() {
		if (this.store != undefined && this.store.getCount() == 0) {
			this.hideComponent();
			this.showDisplayMsg();
		}
	},
	/**
	 * show paging icon
	 */
	showComponent : function() {
		Ext.each(this.items.items, function(obj) {
			obj.show();
		});
	},
	/**
	 * hide paging icon
	 */
	hideComponent : function() {
		Ext.each(this.items.items, function(obj) {
			obj.hide();
		});
	},
	/**
	 * show display message
	 */
	showDisplayMsg : function() {
		var displayItem = this.child('#displayItem');
		if (displayItem) {
			this.removeNoDataMsg();
			displayItem.show();
		} else {
			var noDataMsg = this.child('#nodata');
			if (noDataMsg == undefined) {
				this.add({
					xtype : 'label',
					text : getCommonTranslation('NODATADISPLAYMSG'),// 'No data
					// to
					// dislpay',
					itemId : 'nodata'
				});
			}
		}
	},
	/**
	 * removing no data message
	 */
	removeNoDataMsg : function() {
		var noDataMsg = this.child('#nodata');
		if (noDataMsg != undefined || noDataMsg != null) {
			this.remove(this.child('#nodata'));
		}
	},
	/**
	 * on load store
	 * overwrite method
	 */
	onLoad : function(){
        var me = this,
            pageData,
            currPage,
            pageCount,
            afterText,
            count,
            isEmpty,
            item;

        count = me.store.getCount();
        isEmpty = count === 0;
        if (!isEmpty) {
            pageData = me.getPageData();
            currPage = pageData.currentPage;
            pageCount = pageData.pageCount;
            afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
        } else {
        	pageData = me.getPageData();
            currPage = me.getPageData().currentPage;
            pageCount = me.getPageData().currentPage;
			pageData.pageCount = pageCount;
			afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
        }

        Ext.suspendLayouts();
        item = me.child('#afterTextItem');
        if (item) {    
            item.setText(afterText);
        }
        item = me.getInputItem();
        if (item) {
            item.setDisabled(isEmpty).setValue(currPage);
        }
        me.setChildDisabled('#first', currPage === 1 && isEmpty);
        me.setChildDisabled('#prev', currPage === 1 && isEmpty);
        me.setChildDisabled('#next', currPage === pageCount  || isEmpty);
        me.setChildDisabled('#last', currPage === pageCount  || isEmpty);
        me.setChildDisabled('#refresh', false);
        me.updateInfo();
        Ext.resumeLayouts(true);

        if (me.rendered) {
            me.fireEvent('change', me, pageData);
        }
        me.iconChange(me.store);
    }
});