/*
 * @author Akshay.Kalbhor
 *  
 */

/*
 * RTL setting
 * Set F if RTL is not required,
 * Sequence of the below settings is important so do not change.
 */
var rtl = 'F';//localStorage ? (localStorage.getItem('is-rtl') || 'F') : 'F';
/*var file = 'ext/ext-all' + (rtl=='T'?'-rtl':'') + '-debug.js';
document.write('<script type="text/javascript" src="'+file+'"></script>');*/

/*
 * Language Settings
 */
var currentLanguage = 'en';


/** Setting to allow browser level caching**/
Ext.Loader.setConfig({
	 enabled: true,
	 disableCaching: false,
	 paths: {
	  'Ext.calendar': 'app/utilities/calendar'
	 }
});

/*
 * locale setting
 */
function defaultlanguage(languageName){
	var languageFolder = null;
	if(languageName== 'en') {
		languageFolder = 'english';
	} else if(languageName == 'ja') {
		languageFolder = 'japanese';
	} else if(languageName == 'es') {
		languageFolder = 'spanish';
	} else if(languageName == 'ru'){
		languageFolder = 'russian';
	}
	currentLanguage = languageName;
	var extjsFile = 'ext/locale/ext-lang-' + languageName + '.js';
	//document.write('<script type="text/javascript" src="' + extjsFile +'"></script>');
	loadFile(extjsFile);
	helpMessageProvider.language = languageName;
}

/*
 * locale setting
 */
function changelanguage(languageName){
	var languageFolder = null;
	if(languageName== 'en') {
		languageFolder = 'english';
	} else if(languageName == 'ja') {
		languageFolder = 'japanese';
	} else if(languageName == 'es') {
		languageFolder = 'spanish';
	} else if(languageName == 'ru'){
		languageFolder = 'russian';
	}
	
	var extjsFile = 'ext/locale/ext-lang-' + languageName + '.js';
	Ext.Loader.loadScript({url: extjsFile});
	
	
	Ext.ComponentQuery.query('vp2')[0].removeAll();
	Ext.ComponentQuery.query('vp2')[0].destroy();
	
	setTimeout(function(){
		
		Ext.create('Academia.view.Viewport2');
		
		var loginCtrl = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
		
		loginCtrl.initializeAcademyLocationAndOrganization();
	    // this is for dynamic form field 
	    var prams = null;
	    loginCtrl.getDynamicForFormFieldsInfo(prams);
	    
	    loginCtrl.getMessageCount(loginCtrl);
	    
	    helpMessageProvider.language = languageName;
	    
	    var forms = Ext.ComponentQuery.query('customform');
	    Ext.each(forms, function(form){
	  	var tfs = Ext.ComponentQuery.query('field',form);
	  	  Ext.each(tfs, function(tf){
	  		if(tf.translationKey){
	  			if(tf.xtype == 'textfield' || tf.xtype == 'combo')
	  				tf.setFieldLabel(getCommonTranslation(tf.translationKey));
	  			else if(tf.xtype == 'button')
	  				tf.setText(getCommonTranslation(tf.translationKey));
	  		}
	        });
	    });
		
	},500);
}

//load constant files

var constant_file = ["URLConstants", "CommonConstants", "FeaturePrivilegeConstants", "ReportConstant", "MessagingConstants"];

function loadConstantFiles(constant_file){
	var userLanguage="";
	
	if(JSON.parse(localStorage.getItem(window.name+'_userLanguage'))!="default" && localStorage.getItem(window.name+'_userLanguage')!=null ){
		userLanguage=(localStorage.getItem('userLanguage')==null)?(localStorage.getItem(window.name+'_userLanguage')):(localStorage.getItem('userLanguage'));
		userLanguage = JSON.parse(userLanguage)+"_";
	}
	document.write('<script type="text/javascript" src="'+userLanguage+'translations.js"></script>');
	//loadFile('translations.js');
	if(Ext.isArray(constant_file)){
		Ext.each(constant_file, function(jsfiles){
			var filepath = "app/constants/"+jsfiles+".js";
			//loadFile(filepath);
			document.write('<script type="text/javascript" src="'+filepath+'"></script>');
		});
	}
}

defaultlanguage(currentLanguage);

if(environment=="Development"){
	loadConstantFiles(constant_file);
}
else{
	helpMessageProvider.setMessages(_app_messages);
}