/**
 * @author Harsh.Raghuwanshi@serosoft.in
 */
Ext.define('Academia.controller.DMSController.DMSCommonController', {
	extend: 'Academia.controller.base.BaseController',
	models: [
		'feeandpayment.reports.Student'
	],
	stores: [
		'feeandpayment.reports.Student',
		'DMSStore.DMSSiteStore',
		'DMSStore.DMSSiteSearchStore',
		'DMSStore.DMSSiteUserListStore',
		'DMSStore.DMSSiteContentStore',
		'DMSStore.DMSSiteActivitiesStore',
		'DMSStore.DMSTaskStore'
	],
	views: [
		'DMSView.SiteStructure',
		'DMSView.FileStructure',
		'DMSView.TaskStructure',
		'DMSView.DmsSiteGrid',
		'DMSView.DmsFileGrid',
		'DMSView.DmsTaskGrid',
		'DMSView.SiteSearchForm',
		'DMSView.FileSearchForm',
		'DMSView.DmsUpdateWindow',
		'DMSView.EditSiteStructure',
		'DMSView.DmsAddUserWindow',
		'DMSView.DmsFavoriteSiteGrid',
		'DMSView.SiteDashboardSidePanel',
		'DMSView.SiteDashboardCenterPanel',
		'DMSView.DocumentLibrarySidePanel',
		'DMSView.DocumentLibraryCenterPanel',
		'DMSView.SiteDocumentUploadWindow',
		'DMSView.CreateNewFolderWindow',
		'DMSView.DocumentCopyMoveWindow',
		'DMSView.DmsAllSitesGrid',
		'DMSView.SiteDocumentUpdateWindow',
		'DMSView.ViewDocumentPanel',
		'DMSView.SiteDocumentRevertWindow',
		'DMSView.SiteMembersSidePanel',
		'DMSView.SiteMembersCenterPanel',
		'DMSView.WorkflowPanel',
		'DMSView.EditTaskStructure',
		'DMSView.EditWorkflowPanel',
		'DMSView.EditMyWorkflowPanel'
	],
    refs: [{
    	ref: 'sitestructure',
    	selector: 'sitestructure'
    }, {
    	ref: 'dmsupdatewindow',
    	selector: 'dmsupdatewindow'
    },{
    	ref: 'dmssitegrid',
    	selector: 'dmssitegrid'
    },{
    	ref: 'dmsfavoritesitegrid',
    	selector: 'dmsfavoritesitegrid'
    },{
    	ref:'contentPanel',
    	selector:'contentPanel'
    },{
    	ref: 'editsitestructure',
    	selector: 'editsitestructure'
    },{
    	ref: 'sitesearchform',
    	selector: 'sitesearchform'
    },{
    	ref: 'dmsadduserwindow',
    	selector: 'dmsadduserwindow'
    },{
    	ref: 'sitedashboardsidepanel',
    	selector: 'sitedashboardsidepanel'
    },{
    	ref: 'sitedashboardcenterpanel',
    	selector: 'sitedashboardcenterpanel'
    },{
    	ref: 'documentlibrarysidepanel',
    	selector: 'documentlibrarysidepanel'
    },{
    	ref: 'documentlibrarycenterpanel',
    	selector: 'documentlibrarycenterpanel'
    },{
    	ref: 'sitedocumentuploadwindow',
    	selector: 'sitedocumentuploadwindow'
    },{
    	ref: 'createnewfolderwindow',
    	selector: 'createnewfolderwindow'
    },{
    	ref: 'documentcopymovewindow',
    	selector: 'documentcopymovewindow'
    },{
    	ref: 'dmsallsitesgrid',
    	selector: 'dmsallsitesgrid'
    },{
    	ref: 'sitedocumentupdatewindow',
    	selector: 'sitedocumentupdatewindow'
    },{
    	ref: 'viewdocumentpanel',
    	selector: 'viewdocumentpanel'
    },{
    	ref: 'sitedocumentrevertwindow',
    	selector: 'sitedocumentrevertwindow'
    },{
    	ref: 'sitememberssidepanel',
    	selector: 'sitememberssidepanel'
    },{
    	ref: 'sitememberscenterpanel',
    	selector: 'sitememberscenterpanel'
    },{
    	ref: 'workflowpanel',
    	selector: 'workflowpanel'
    },{
    	ref: 'dmstaskgrid',
    	selector: 'dmstaskgrid'
    },{
    	ref: 'edittaskstructure',
    	selector: 'edittaskstructure'
    },{
    	ref: 'editworkflowpanel',
    	selector: 'editworkflowpanel'
    },{
    	ref: 'editmyworkflowpanel',
    	selector: 'editmyworkflowpanel'
    },{
    	ref: 'filestructure',
    	selector: 'filestructure'
    }],
	config: {
		/*POWERBI_MENU1_REPORT1_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('POWERBI_MENU1_REPORT1_PRIVILEGES')*/
	},
	init: function(application) {
        this.control({
        	'sitestructure':{
        		afterrender: function(structure){
        			var me = this;
        			var siteGrid = structure.down('dmssitegrid');
        			var userId = me.getCurrentlyLoggedInUser().id;
        			
        			siteGrid.getStore().getProxy().api.read = SERVERURL.PATH_GET_SITE+'/'+userId;
        			siteGrid.getStore().load();
        			
        			//me.loadIframe();
        		}
        	},
        	'sitestructure dmsfavoritesitegrid':{
        		activate: function(panel, eOpts) {
        			var me = this;
        			panel.getStore().getProxy().api.read = SERVERURL.PATH_GET_FAVORITE_SITE_LIST;
        			panel.getStore().load();
        		}
        	},
        	'sitestructure dmsallsitesgrid':{
        		activate: function(panel, eOpts) {
        			var me = this;
        			panel.getStore().getProxy().api.read = SERVERURL.PATH_GET_ALL_SITE_LIST;
        			panel.getStore().load();
        		},
        		selectionchange: function(grid, record){
					var me = this;
					
					var btnLeaveSite = grid.view.up('grid').down('#btnLeaveSite');
					var btnRequestToJoinSite = grid.view.up('grid').down('#btnRequestToJoinSite');
					var btnJoinSite = grid.view.up('grid').down('#btnJoinSite');
					
					if(grid.getSelection().length){
						var selectedRecord = record[0].data;
						if(!isNullOrEmpty(selectedRecord.siteRole)){
							btnLeaveSite.setDisabled(false);
							btnRequestToJoinSite.setDisabled(true);
							btnJoinSite.setDisabled(true);
						}
						else if(selectedRecord.isPublic){
							btnLeaveSite.setDisabled(true);
							btnRequestToJoinSite.setDisabled(true);
							btnJoinSite.setDisabled(false);
						}
						else{
							btnLeaveSite.setDisabled(true);
							btnRequestToJoinSite.setDisabled(false);
							btnJoinSite.setDisabled(true);
						}
					}
					else{
						btnLeaveSite.setDisabled(true);
						btnRequestToJoinSite.setDisabled(true);
						btnJoinSite.setDisabled(true);
					}
					
				}
        	},
        	'sitesearchform button[itemId=searchBtn]':{
        		click: function(btn){
        			var me = this;
        			
        			btn.up('sitestructure').down('tabpanel').setActiveTab(0);
        			
        			var userId = me.getCurrentlyLoggedInUser().id;
        			var shortName = btn.up('form').down('#student').getValue();
        			
        			me.getDmssitegrid().getStore().getProxy().api.read = SERVERURL.PATH_GET_SITE+'/'+userId;
        			me.getDmssitegrid().getStore().getProxy().extraParams.shortName = shortName;
        			me.getDmssitegrid().getStore().load();
        		}
        	},
        	'sitesearchform button[itemId=resetBtn]':{
        		click: function(btn){
        			var me = this;
        			var shortName = btn.up('form').down('#student').reset();
        			var shortName = btn.up('form').down('#student').clearValue();
        		}
        	},
        	'dmsupdatewindow[itemId=addDmsSiteWindow] textfield[itemId=dmsname]':{
        		blur: function( obj, e, eOpts ){
        			if(obj.up('window').itemId!="dmsEditSiteWindow"){
            			var dmsname = obj.getValue();
            			var dmssiteid = obj.up('window').down('#dmssiteid').getValue();
            			if(isNullOrEmpty(dmssiteid)){
            				obj.up('window').down('#dmssiteid').setValue(dmsname.replace(/ /g,"-").toLocaleLowerCase());
            			}
        			}
        		}
        	},
        	'dmsupdatewindow[itemId=addDmsSiteWindow] button[itemId=dmsSubmitButtonId]':{
        		click: function(btn){
        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			
        			var me = this;
        			var window = btn.up('window');
        			var siteName=window.down("#dmsname").getValue();
        			var siteId=window.down("#dmssiteid").getValue();
        			var description=window.down("#dmsdescription").getValue();
        			var visibility=window.down("#visibility").getValue();
        			
        			var url = SERVERURL.PATH_CREATE_SITE;//+'?siteName='+siteName+'&siteId='+siteId+'&description='+description+'&visibility='+visibility.visibility;
        			Ext.Ajax.request({
        				type : 'rest',
        				url : url,
        				jsonData : {
        					siteName : siteName,
        					siteId : siteId,
        					description: description,
        					visibility: visibility.visibility
        				},
        				headers : {
       	    				'Content-Type' : 'application/json'
       	    			},
        				method : 'POST',
        				success : function(response) {
        					Ext.getBody().unmask();
        					if(response.responseText=="success"){
            					showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
            					btn.up('window').close();
            					var userId = me.getCurrentlyLoggedInUser().id;
                    			me.getDmssitegrid().getStore().getProxy().api.read = SERVERURL.PATH_GET_SITE+'/'+userId;
            					me.getDmssitegrid().getStore().load();
        					}
        				}
        			});
        		}
        	},
        	'dmsupdatewindow[itemId=dmsEditSiteWindow] button[itemId=dmsSubmitButtonId]':{
        		click: function(btn){
        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			
        			var me = this;
        			var window = btn.up('window');
        			var siteName=window.down("#dmsname").getValue();
        			var siteId=window.down("#dmssiteid").getValue();
        			var description=window.down("#dmsdescription").getValue();
        			var visibility=window.down("#visibility").getValue();
        			
        			var url = SERVERURL.PATH_UPDATE_SITE;
        			Ext.Ajax.request({
        				type : 'rest',
        				url : url,
        				jsonData : {
        					siteName : siteName,
        					siteId : siteId,
        					description: description,
        					visibility: visibility.visibility
        				},
        				headers : {
       	    				'Content-Type' : 'application/json'
       	    			},
        				method : 'PUT',
        				success : function(response) {
        					Ext.getBody().unmask();
        					showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
        					btn.up('window').close();
        					var userId = me.getCurrentlyLoggedInUser().id;
        					try{
                    			me.getDmssitegrid().getStore().getProxy().api.read = SERVERURL.PATH_GET_SITE+'/'+userId;
            					me.getDmssitegrid().getStore().load();
        					}
        					catch(e){}
        					me.updateEditSiteStructure(siteId);
        				}
        			});
        		}
        	},
        	'dmsupdatewindow button[itemId=dmsCancelButtonId]':{
        		click: function(btn){
        			var me = this;
        			var window = btn.up('window');
        			window.close();
        		}
        	},
        	'dmssitegrid button[itemId=btnAdd]':{
        		click: function(btn){
        			var me = this;
        			var formWindow = me.getDmsupdatewindow();
        			if (!formWindow) {
        				Ext.widget('dmsupdatewindow',{
        					itemId: 'addDmsSiteWindow'
        				});
        				var formWindow = me.getDmsupdatewindow();
        			}
        			formWindow.show();
        		}
        	},
        	'dmssitegrid button[itemId=btnEdit]':{
        		click: function(btn){
        			var me = this;
        			var contentpanel = me.getContentPanel();
        			var editSiteStructureTab = Ext.widget('editsitestructure');
        			var tabName = getDMSTranslation('EDIT_SITE');
        			var getcontroller=me.getController('menu.CoreERPNavigationController');
        			var getTab=getcontroller.getTab(tabName);
        			if(getTab!=null){
        				contentpanel.remove(getTab, true);
        			}
        			openTab(contentpanel, tabName, editSiteStructureTab);
        			setTimeout(function(){
        				var siteGrid = btn.up('dmssitegrid');
        				var selectedRecord = siteGrid.getSelectionModel().getSelection()[0];
        				
        				var siteName = selectedRecord.get('title');
        				var siteVisibility = selectedRecord.get('visibility');
            			var siteId = selectedRecord.get('shortName');
            			
            			me.updateEditSiteStructure(siteId);
            			
        			},500);
        		}
        	},
        	'dmssitegrid button[itemId=btnDelete]':{
        		click: function(btn){
        			var me = this;
        			var siteGrid = btn.up('grid');
        			var selectedRecord = siteGrid.getSelectionModel().getSelection()[0];
        			showConfirmMessage(getDMSTranslation('DMS_SITE'), getDMSTranslation('DELETE_SITE_MSG'), function(btn, text) {
   	    				if (btn == 'yes') {
   	    					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   	    					Ext.Ajax.request({
   	    						type: 'rest',
   	    						url: SERVERURL.PATH_DELETE_SITE,
   	    						method: 'GET',
   	    						params: {
   	    							site : selectedRecord.get('shortName')
   	    						},
   	    						headers: {
   	    							'Content-Type': 'application/json'
   	    						},
   	    						success: function(form, action) {
   	    							Ext.getBody().unmask();
   	    							showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
   	    							siteGrid.getStore().load();
   	    						}
   	    					});
   	    				}
   	    			});
        		}
        	},
        	'dmsallsitesgrid button[itemId=btnRequestToJoinSite]':{
        		click: function(btn){
        			var me = this;
        			var grid = me.getDmsallsitesgrid();
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];

        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_REQUEST_TO_JOIN_SITE,
        				method: 'POST',
        				jsonData : {
        					siteId : selectedRecord.get('shortName'),
        					inviteeRoleName:"SiteConsumer",
        					invitationType:"MODERATED"
        				},
        				headers : {
        					'Content-Type' : 'application/json'
        				},
        				success: function(form, action) {
        					if(form.responseText=='success'){
        						Ext.getBody().unmask();
        						showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
        						grid.getStore().load();
        					}
        				}
        			});
        		}
        	},
        	'dmsallsitesgrid button[itemId=btnLeaveSite]':{
        		click: function(btn){
        			var me = this;
        			var grid = me.getDmsallsitesgrid();
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];

        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_DELETE_SITE_USER+"?site="+selectedRecord.get('shortName'),
        				method: 'GET',
        				headers : {
        					'Content-Type' : 'application/json'
        				},
        				success: function(form, action) {
        					if(form.responseText=='success'){
        						Ext.getBody().unmask();
        						showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
        						grid.getStore().load();
        					}
        				}
        			});


        		}
        	},
        	'dmsallsitesgrid button[itemId=btnJoinSite]':{
        		click: function(btn){
        			var me = this;
        			var grid = me.getDmsallsitesgrid();
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var isMemberOfGroup="false";
        			var authorityType="USER";
        			var siteName=selectedRecord.get('title');
        			var siteShortName=selectedRecord.get('shortName');
        			var role="SiteConsumer";
        			var id=me.getCurrentlyLoggedInUser().id;

        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_CREATE_SITE_USER,
        				method: 'POST',
        				headers : {
        					'Content-Type' : 'application/json'
        				},
        				jsonData : {
        					siteName : siteName,
        					siteId : siteShortName,
        					role : role,
        					id: id,
        					isMemberOfGroup: isMemberOfGroup,
        					authorityType: authorityType
        				},
        				success: function(form, action) {
        					if(form.responseText=='success'){
        						Ext.getBody().unmask();
        						showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
        						grid.getStore().load();
        					}
        				}
        			});


        		}
        	},
        	/*'dmssitegrid [itemId=addUserBtn]':{
        		click: function(btn){
        			var me = this;
        			var formWindow = me.getDmsadduserwindow();
        			if (!formWindow) {
        				Ext.widget('dmsadduserwindow');
        				var formWindow = me.getDmsadduserwindow();
        			}
        			formWindow.show();
        			
        			var grid = btn.up('dmssitegrid');
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			
        			var siteName = selectedRecord.get('title');
        			var siteId = selectedRecord.get('shortName');
        			
        			formWindow.down('#siteName').setValue(siteName);
        			formWindow.down('#siteId').setValue(siteId);
        		}
        	},*/
        	'dmssitegrid':{
				selectionchange: function(grid, record){
					var me = this;
					var isManager = false;
					if(grid.getSelection().length){
						var selectedRecord = record[0];
						isManager = me.isSiteManager(selectedRecord.data);
					}
					if(isManager){
						//grid.view.up('grid').down('#btnMoreOperations').setDisabled(!grid.getSelection().length);
						grid.view.up('grid').down('#btnDelete').setDisabled(!grid.getSelection().length);
					}
					else{
						//grid.view.up('grid').down('#btnMoreOperations').setDisabled(true);
						grid.view.up('grid').down('#btnDelete').setDisabled(true);
					}
					grid.view.up('grid').down('#btnEdit').setDisabled(!grid.getSelection().length);
				}
        	},
        	'dmsadduserwindow button[itemId=dmsAddUserSubmitButtonId]':{
        		click: function(btn){
        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			
        			var me = this;
        			var window = btn.up('window');
        			
        			var siteName=window.down("#siteName").getValue();
        			var siteId=window.down("#siteId").getValue();
        			var role=window.down("#dmsrole").getValue();
        			var id=window.down("#userItemId").getValue();
        			var isMemberOfGroup="false";
        			var authorityType="USER";
        			
        			var url = SERVERURL.PATH_CREATE_SITE_USER;//+'?siteName='+siteName+'&siteId='+siteId+'&description='+description+'&visibility='+visibility.visibility;
        			Ext.Ajax.request({
        				type : 'rest',
        				url : url,
        				jsonData : {
        					siteName : siteName,
        					siteId : siteId,
        					role : role,
        					id: id,
        					isMemberOfGroup: isMemberOfGroup,
        					authorityType: authorityType
        				},
        				headers : {
       	    				'Content-Type' : 'application/json'
       	    			},
        				method : 'POST',
        				success : function(response) {
        					Ext.getBody().unmask();
        					if(response.responseText=="success"){
            					showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
            					btn.up('window').close();
            					var userId = me.getCurrentlyLoggedInUser().id;
            					try{
                        			me.getDmssitegrid().getStore().getProxy().api.read = SERVERURL.PATH_GET_SITE+'/'+userId;
                					me.getDmssitegrid().getStore().load();
            					}
            					catch(e){}
            					try{
                        			me.getEditsitestructure().down('#userListDataViewItemId').getStore().load();
            					}
            					catch(e){}
            					
            					try{
                        			me.getEditsitestructure().down('#siteMembersUserListDataViewItemId').getStore().load();
            					}
            					catch(e){}
        					}
        				}
        			});
        		}
        	},
        	'dmsadduserwindow button[itemId=dmsAddUserCancelButtonId]':{
        		click: function(btn){
        			btn.up('window').close();
        		}
        	},
        	'editsitestructure button[cls=segmentBtnCls]':{
        		click: function(btn){
        			var me = this;
        			var allSegmentedButton = Ext.ComponentQuery.query('[cls=segmentBtnCls]');
        			Ext.each(allSegmentedButton, function(currentBtn){
        				if(btn==currentBtn){
        					currentBtn.addCls('btnPressed');
        				}
        				else{
        					currentBtn.removeCls('btnPressed');
        				}
        			});
        			if(btn.itemId=="siteDashboardBtnItemId"){
        				me.loadEditTab("siteDashboard");
        			}
        			else if(btn.itemId=="documentLibraryBtnItemId"){
        				me.loadEditTab("documentLibrary");
        			}
        			else if(btn.itemId=="siteMembersBtnItemId"){
        				me.loadEditTab("siteMembers");
        			}
        		}
        	},
        	'editsitestructure [itemId=editSiteAddUserBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			var formWindow = me.getDmsadduserwindow();
        			if (!formWindow) {
        				Ext.widget('dmsadduserwindow');
        				var formWindow = me.getDmsadduserwindow();
        			}
        			formWindow.show();
        			
        			var siteName = me.getEditsitestructure().siteName;
        			var siteId = me.getEditsitestructure().siteId;
        			
        			formWindow.down('#siteName').setValue(siteName);
        			formWindow.down('#siteId').setValue(siteId);
        		}
        	},
        	'textfield[itemId=searchMappedUser]':{
        		keyup: function( obj, e, eOpts ){
        			var me = this;
        			var dataView = obj.up().down('#userListDataViewItemId');
        			var dataViewStore = dataView.getStore();
        			dataViewStore.clearFilter(true);
        			dataViewStore.filterBy(function(record, id){
        				var match = false;
                        Ext.each(dataViewStore.fields, function(field) {
                        	try{
                                if (record.get(field).toUpperCase().indexOf(obj.getValue().toUpperCase())!="-1") {
                                    match = true;
                                    return false; // break the loop
                                }
                        	}
                        	catch(e){
                        		try{
                            		if (record.get(field.name).toUpperCase().indexOf(obj.getValue().toUpperCase())!="-1") {
                                        match = true;
                                        return false; // break the loop
                                    }
                        		}
                        		catch(e){}
                        	}
                        });
                        return match;
        	        });
        		}
        	},
        	'editsitestructure dataview[itemId=userListDataViewItemId]':{
        		itemclick:function( dv, record, item, index, e, eOpts ){
        			var me = this;
        			if(e.target.className=="deleteIcon"){
        				showConfirmMessage(getDMSTranslation('DMS_SITE'), getDMSTranslation('DELETE_SITE_USR_MSG'), function(btn, text) {
       	    				if (btn == 'yes') {
       	    					Ext.Ajax.request({
       	    						type: 'rest',
       	    						url: SERVERURL.PATH_DELETE_SITE_USER,
       	    						method: 'GET',
       	    						params: {
       	    							site : me.getEditsitestructure().siteId,
       	    							userName: record.get('userName')
       	    						},
       	    						headers: {
       	    							'Content-Type': 'application/json'
       	    						},
       	    						success: function(form, action) {
       	    							showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
       	    							dv.getStore().load();
       	    						}
       	    					});
       	    				}
       	    			});
        			}
        		},
        		afterrender: function(dv){
        			var me = this;
        			var currentUser = (me.getCurrentlyLoggedInUser().code=="sysadmin") ? "admin" : (me.getCurrentlyLoggedInUser().code);
        			dv.getStore().on('load',function(record){
        				console.log(record);
        				Ext.each(record.data.items, function(currentItems){
        					if(currentUser==currentItems.get('userName')){
        						me.getEditsitestructure().role = currentItems.get('role');
        					}
        				});
        			});
        		}
        	},
        	'editsitestructure [itemId=editDmsSiteDetailsItemId]':{
        		click: function(btn){
        			var me = this;
        			Ext.Ajax.request({
   						type: 'rest',
   						url: SERVERURL.PATH_GET_SITE_BY_SHORTNAME,
   						method: 'GET',
   						params: {
   							site : me.getEditsitestructure().siteId
   						},
   						headers: {
   							'Content-Type': 'application/json'
   						},
   						success: function(response, action) {
   							var responseText = Ext.decode(response.responseText);
   							
   							
   							var formWindow = me.getDmsupdatewindow();
   		        			if (!formWindow) {
   		        				Ext.widget('dmsupdatewindow',{
   		        					itemId: 'dmsEditSiteWindow',
   		        					title: getDMSTranslation('EDIT_SITE')
   		        				});
   		        				var formWindow = me.getDmsupdatewindow();
   		        			}
   		        			formWindow.show();

   		        			formWindow.down('#dmsname').setValue(responseText.title);
   		        			formWindow.down('#dmssiteid').setValue(responseText.shortName);
   		        			formWindow.down('#dmsdescription').setValue(responseText.description);
   		        			formWindow.down('#visibility').setValue({visibility:responseText.visibility});
   		        			
   		        			formWindow.down('#dmssiteid').setVisible(false);
   		        			formWindow.down('displayfield').setVisible(false);
   						}
   					});
        		}
        	},
        	'editsitestructure [itemId=settingLeaveSiteMenuBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			showConfirmMessage(getDMSTranslation('DMS_SITE'), getDMSTranslation('LEAVE_SITE_MSG'), function(btn, text) {
   	    				if (btn == 'yes') {
   	    					Ext.Ajax.request({
   	    						type: 'rest',
   	    						url: SERVERURL.PATH_DELETE_SITE_USER,
   	    						method: 'GET',
   	    						params: {
   	    							site : me.getEditsitestructure().siteId
   	    						},
   	    						headers: {
   	    							'Content-Type': 'application/json'
   	    						},
   	    						success: function(form, action) {
   	    							showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
   	    							var contentpanel = me.getContentPanel();
   	    							contentpanel.getActiveTab().close();
   	    							try{
   	   	    							me.getDmssitegrid().getStore().load();
   	    							}
   	    							catch(e){}
   	    						}
   	    					});
   	    				}
   	    			});
        		}
        	},
        	'combobox[itemId=siteContentFilterItemId]':{
        		change: function(obj){
        			var me = this;
        			var siteCenterPanel = obj.up('#siteCenterPanel');
        			var siteContentDataView = siteCenterPanel.down('#siteContentDataViewItemId');
        			var siteContentDataViewStore = siteContentDataView.getStore();
        			siteContentDataViewStore.getProxy().extraParams = {
        				site:me.getEditsitestructure().siteId,
        				filterBy: obj.getValue()
        			};
        			siteContentDataViewStore.load();
        		}
        	},
        	'combobox[itemId=siteUserFilterItemId], combobox[itemId=siteActivityFilterItemId], combobox[itemId=siteDateFilterItemId]':{
        		change: function(obj){
        			var me = this;
        			var siteCenterPanel = obj.up('#siteCenterPanel');
        			var siteActivitiesMainPanel = siteCenterPanel.down('#siteActivitiesMainPanelItemId');
        			siteActivitiesMainPanel.body.el.dom.innerHTML = '';
        			Ext.Ajax.request({
   						type: 'rest',
   						url: SERVERURL.PATH_GET_ACTIVITIES_BY_SITEID,
   						method: 'GET',
   						params: {
   							site : me.getEditsitestructure().siteId,
   							userFilter: siteCenterPanel.down('[name=userFilter]').getValue(),
   							activityFilter: siteCenterPanel.down('[name=activityFilter]').getValue(),
   							dateFilter: siteCenterPanel.down('[name=dateFilter]').getValue()
   						},
   						success: function(response, action) {
   							var htmlResponse = response.responseText.trim();
   							htmlResponse = htmlResponse.replace(/<img[^>]*>/g,"");
   							
   							var newTempElement = document.createElement("p");
   							newTempElement.innerHTML = htmlResponse;
   							
   							setTimeout(function(){
   	   							Ext.each($(newTempElement).find('.new-day .relativeDate'), function(currentDiv){
   	   								currentDiv.textContent = getDayDifference(currentDiv.innerText);
   	   							});
   	   							
   	   							Ext.each($(newTempElement).find('.activity .relativeTime'), function(currentDiv){
	   								currentDiv.textContent = getTimeDifference(currentDiv.innerText);
	   							});
   	   							
   	   							Ext.each($(newTempElement).find('.theme-color-1'), function(currentDiv){
   	   								currentDiv.removeAttribute("href");
   	   							});
   	   							
   	   							siteActivitiesMainPanel.body.el.dom.innerHTML = newTempElement.innerHTML;
   	   							
   	   							$('.more').on('click', function(obj){
   	   								if(this.parentElement.children[this.parentElement.children.length-1].classList.contains('hidden')){
   	   									this.parentElement.children[this.parentElement.children.length-1].classList.remove('hidden');
   	   									this.parentElement.children[this.parentElement.children.length-1].classList.add('visible');
   	   								}
   	   								else{
   	   									this.parentElement.children[this.parentElement.children.length-1].classList.remove('visible');
	   									this.parentElement.children[this.parentElement.children.length-1].classList.add('hidden');
   	   								}
   	   							});
   							},100);
   						}
   					});
        		}
        	},
        	'documentlibrarysidepanel [itemId=libraryDocument]':{
        		afterrender: function(pnl){
        			var me = this;
        			var treePanel = pnl.down('treepanel');
        			var node = treePanel.getRootNode();
        			node.removeAll();
        			me.getDocumentLibraryTree('', node);
        			setTimeout(function(){
            			//node.fireEvent('itemclick',node);
            			me.selectTreeNode(treePanel, node);
        			},100);
        		}
        	},
        	'documentcopymovewindow form':{
        		afterrender: function(pnl){
        			var me = this;
        			var treePanel = pnl.down('treepanel');
        			var node = treePanel.getRootNode();
        			node.removeAll();
        			me.getDocumentLibraryWindowTree('', node);
        			setTimeout(function(){
            			me.selectTreeNode(treePanel, node);
        			},100);
        		}
        	},
        	'documentlibrarysidepanel treepanel[itemId=libraryDocumentTreePanel]':{
        		itemclick: function( treepanel, record, item, index, e, eOpts ){
        			var me = this;
        			try{
        				record.removeAll();
        			}
        			catch(e){}
        			me.getDocumentLibraryTree(record.raw.folderPath, record);
        		},
        		beforeitemappend: function( item, node, eOpts ){
        			var me = this;
        			if(node.isLeaf()){
        				return false;
        			}
        		}
        	},
        	'documentcopymovewindow treepanel[itemId=libraryDocumentWindowTreePanel]':{
        		itemclick: function( treepanel, record, item, index, e, eOpts ){
        			var me = this;
        			try{
    					record.removeAll();
    				}
    				catch(e){}
    				me.getDocumentLibraryWindowTree(record.raw.folderPath, record);
        		},
        		beforeitemappend: function( item, node, eOpts ){
        			var me = this;
        			if(node.isLeaf()){
        				return false;
        			}
        		}
        	},
        	'documentlibrarycenterpanel button[itemId=createFolderBtn]':{
        		click: function(btn){
        			var me = this;
        			var formWindow = me.getCreatenewfolderwindow();
        			if (!formWindow) {
        				Ext.widget('createnewfolderwindow');
        				formWindow = me.getCreatenewfolderwindow();
        			}
        			formWindow.show();
        		},
        		afterrender: function(btn){
        			var me = this;
        			var currentUserRole = me.getEditsitestructure().role;
        			if(currentUserRole=="Consumer"){
        				btn.setDisabled(true);
        			}
        			else{
        				btn.setDisabled(false);
        			}
        		}
        	},
        	'documentlibrarycenterpanel button[itemId=uploadDocuemntBtn]':{
        		click: function(btn){
        			var me = this;
        			var formWindow = me.getSitedocumentuploadwindow();
        			if (!formWindow) {
        				Ext.widget('sitedocumentuploadwindow');
        				formWindow = me.getSitedocumentuploadwindow();
        			}
        			formWindow.show();
        		},
        		afterrender: function(btn){
        			var me = this;
        			var currentUserRole = me.getEditsitestructure().role;
        			if(currentUserRole=="Consumer"){
        				btn.setDisabled(true);
        			}
        			else{
        				btn.setDisabled(false);
        			}
        		}
        	},
			'sitedocumentuploadwindow button[itemId=cancelImageBtnWin]': {
				click: function(btn){
					btn.up('window').close();
				}
			},
			'sitedocumentuploadwindow button[itemId=submitImageBtnWin]': {
				click: this.uploadSiteDocuments
			},
			'createnewfolderwindow button[itemId=cancelCreateFolderBtnWin]': {
				click: function(btn){
					btn.up('window').close();
				}
			},
			'createnewfolderwindow button[itemId=submitCreateFolderBtnWin]': {
				click: this.createNewFolder
			},
			'documentlibrarycenterpanel dataview[itemId=documentLibraryDataViewItemId]':{
				itemclick: function(view, record, item, idx, event, opts) {
					var me = this;
					var continueP = true;
					if(record.data.type=="folder" && event.target.className=="fileNameSpan"){
						var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
						var folderPath = record.data.folderPath;
						
						var currenSelectedNodeChildren = treepanel.getSelectionModel().getSelection()[0].childNodes;
						var foundNode;
						Ext.each(currenSelectedNodeChildren, function(currentChild){
							if(currentChild.raw.folderPath==folderPath){
								foundNode=currentChild;
							}
						});
						if(!isNullOrEmpty(foundNode)){
							me.selectTreeNode(treepanel,foundNode);
						}
					}
					else if(record.data.type=="file" && event.target.className=="fileNameSpan" && record.data.isLocked==false){
						var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
						var folderPath = record.data.folderPath;
						
						var filePath = "Documents"+record.data.folderPath.replace(record.data.fileName,"");
						var fileIcon = record.data.img;
						var fileName = record.data.fileName;
						var fileVersion = record.data.version;
						var fileUpdateText = record.data.action+" "+record.data.time+" ago by "+record.data.userName;
						var fileNodeRef = record.data.nodeRef;
						
						var editSiteStructure = me.getEditsitestructure();
						var siteId = editSiteStructure.siteId;
						var westRegion = editSiteStructure.down('[region=west]');
						var centerRegion = editSiteStructure.down('[region=center]');
						westRegion.removeAll();
						centerRegion.removeAll();
						
						westRegion.hide();
						
						centerRegion.add({
							xtype:'viewdocumentpanel',
							config:{
								filePath: filePath,
								fileIcon: fileIcon,
								fileName: fileName,
								fileVersion: fileVersion,
								fileUpdateText: fileUpdateText,
								fileNodeRef: fileNodeRef,
								node: record.data
							}
						});
						
						continueP = false;
					}
					else if(event.target.className=="downloadBtnIconCls"){
						var selectedRedord = record;
						var fileName = record.data.fileName+".zip";
						var node = record.data.nodeRef;
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_SITE_DOC_DOWNLOAD_AS_ZIP,
							method: 'POST',
							jsonData : {
								fileName: fileName,
								node: node
							},
							headers : {
				   				'Content-Type' : 'application/json'
				   			},
							success: function(response, action) {
								var responseText = Ext.decode(response.responseText);
								if(responseText.status=="success"){
									me.downloadURI(responseText.url,fileName);
								}
							}
						});
					}
					else if(event.target.className=="uploadBtnIconCls"){
						var node = record.data.nodeRef;
						var currenVersion = record.data.version;
						var minorVersion = currenVersion.split('.')[0]+'.'+(parseInt(currenVersion.split('.')[1])+1);
						var majorVersion = (parseInt(currenVersion.split('.')[0])+1)+'.0';
	        			var formWindow = me.getSitedocumentupdatewindow();
	        			if (!formWindow) {
	        				Ext.widget('sitedocumentupdatewindow',{
	        					itemId: 'sitedocumentupdatewindow',
	        					node: node,
	        					minorVersion: minorVersion,
	        					majorVersion: majorVersion
	        				});
	        				var formWindow = me.getSitedocumentupdatewindow();
	        			}
	        			formWindow.show();
					}
					else if(event.target.className=="editOfflineBtnIconCls"){
						var selectedRedord = record;
						var fileName = record.data.fileName+".zip";
						var node = record.data.nodeRef;
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_EDIT_OFFLINE_DOCUMENT,
							method: 'POST',
							jsonData : {
								node: node
							},
							headers : {
				   				'Content-Type' : 'application/json'
				   			},
							success: function(response, action) {
								var responseText = Ext.decode(response.responseText);
								if(responseText.success){
									me.downloadURI(responseText.url,fileName);
									var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
									try{
										var selectedNode = treepanel.getSelectionModel().getSelection()[0];
										var workSpace = selectedNode.raw.nodeRef;
									}
   	    							catch(e){
   	    								var selectedNode = '';
   	    								var workSpace = '';
   	    							}
   	    							if(!isNullOrEmpty(selectedNode)){
   	    								me.selectTreeNode(treepanel, selectedNode);
   	    							}
								}
							}
						});
					}
					else if(event.target.className=="cancelEditBtnIconCls"){
						var node = record.data.nodeRef;
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_CANCEL_EDIT_DOCUMENT,
							method: 'POST',
							jsonData : {
								node: node
							},
							headers : {
				   				'Content-Type' : 'application/json'
				   			},
				   			success: function(response, action) {
				   				var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
				   				try{
				   					var selectedNode = treepanel.getSelectionModel().getSelection()[0];
				   					var workSpace = selectedNode.raw.nodeRef;
				   				}
				   				catch(e){
				   					var selectedNode = '';
				   					var workSpace = '';
				   				}
				   				if(!isNullOrEmpty(selectedNode)){
				   					me.selectTreeNode(treepanel, selectedNode);
				   				}
				   			}
						});
					}
					
					setTimeout(function(){
						if(continueP){
							var selectedRedords = Ext.query('.thumb-wrap-document-library input[type=checkbox]:checked');
							var selectedItemsMenu = me.getDocumentlibrarycenterpanel().down('#selectedItemsMenuItemId');
							if(selectedRedords.length){
								selectedItemsMenu.setDisabled(false);
								var isFolderSelected = false;
								Ext.each(selectedRedords, function(currentItem){
									var currentCheckValue = currentItem.value.split("::");
									if(currentCheckValue[0]=="folder"){
										isFolderSelected = true;
									}
								});
								if(!isFolderSelected && selectedRedords.length == 1){
									me.getDocumentlibrarycenterpanel().down('#documentWorkflowMenuItemId').setVisible(true);
								}
								else{
									me.getDocumentlibrarycenterpanel().down('#documentWorkflowMenuItemId').setVisible(false);
								}
								
								var currentUserRole = me.getEditsitestructure().role;
								if(currentUserRole!="Manager"){
									me.getDocumentlibrarycenterpanel().down('#documentMoveMenuItemId').setVisible(false);
									me.getDocumentlibrarycenterpanel().down('#documentDeleteMenuItemId').setVisible(false);
								}
								else{
									me.getDocumentlibrarycenterpanel().down('#documentMoveMenuItemId').setVisible(true);
									me.getDocumentlibrarycenterpanel().down('#documentDeleteMenuItemId').setVisible(true);
								}
							}
							else{
								selectedItemsMenu.setDisabled(true);
							}
						}
					},10);
				}
			},
			'documentlibrarycenterpanel [itemId=documentDownloadMenuItemId]':{
				click: function(btn){
					var me = this;
					var selectedRedords = Ext.query('.thumb-wrap-document-library input[type=checkbox]:checked');
					if(selectedRedords.length){
						if(selectedRedords.length>1){
							var fileName = "Archive.zip";
						}
						else{
							var fileName = selectedRedords[0].value.split("::")[1]+".zip";
						}
						var filesArray = [];
						Ext.each(selectedRedords, function(currentItem){
							var currentCheckValue = currentItem.value.split("::");
							filesArray.push(currentCheckValue[2]);
						});
						var node = filesArray.join();
						
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_SITE_DOC_DOWNLOAD_AS_ZIP,
							method: 'POST',
							jsonData : {
								fileName: fileName,
								node: node
							},
							headers : {
				   				'Content-Type' : 'application/json'
				   			},
							success: function(response, action) {
								var responseText = Ext.decode(response.responseText);
								if(responseText.status=="success"){
									me.downloadURI(responseText.url,fileName);
								}
							}
						});
					}
				}
			},
			'documentlibrarycenterpanel [itemId=documentCopyMenuItemId]':{
				click: function(btn){
        			var me = this;
        			me.copyOrMoveDocuments('copy');
				}
			},
			'documentlibrarycenterpanel [itemId=documentMoveMenuItemId]':{
				click: function(btn){
        			var me = this;
        			me.copyOrMoveDocuments('move');
				}
			},
			'documentlibrarycenterpanel [itemId=documentWorkflowMenuItemId]':{
				click: function(btn){
        			var me = this;
        			me.startWorkFlow(btn);
				}
			},
			'documentlibrarycenterpanel [itemId=documentDeleteMenuItemId]':{
				click: function(btn){
        			var me = this;
        			var selectedRedords = Ext.query('.thumb-wrap-document-library input[type=checkbox]:checked');
        			var filesArray = [];
        			Ext.each(selectedRedords, function(currentItem){
						var currentCheckValue = currentItem.value.split("::");
						filesArray.push(currentCheckValue[2]);
					});
        			var node = filesArray.join();
        			showConfirmMessage(getDMSTranslation('DOCUMENTS'), getDMSTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function(btn, text) {
   	    				if (btn == 'yes') {
   	    					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   	    					Ext.Ajax.request({
   	    						type: 'rest',
   	    						url: SERVERURL.PATH_DELETE_SITE_DOCS,
   	    						method: 'POST',
   	    						jsonData : {
   	    							node : node
   	    						},
   	    						headers : {
   	    			   				'Content-Type' : 'application/json'
   	    			   			},
   	    						success: function(form, action) {
   	    							Ext.getBody().unmask();
   	    							showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
   	    							
   	    							var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
   	    							try{
   	    								var selectedNode = treepanel.getSelectionModel().getSelection()[0];
   	    								var workSpace = selectedNode.raw.nodeRef;
   	    							}
   	    							catch(e){
   	    								var selectedNode = '';
   	    								var workSpace = '';
   	    							}
   	    							if(!isNullOrEmpty(selectedNode)){
   	    								me.selectTreeNode(treepanel, selectedNode);
   	    							}
   	    						}
   	    					});
   	    				}
   	    			});
        		}
			},
			'documentcopymovewindow button[itemId=dmsDocCopySubmitButtonId]':{
				click: function(btn){
					var me = this;
					var copyMoveWin = btn.up('window');
					var url = copyMoveWin.url;
					
					var winTreepanel = copyMoveWin.down('#libraryDocumentWindowTreePanel');
					try{
						var selectedNode = winTreepanel.getSelectionModel().getSelection()[0];
						var workSpace = selectedNode.raw.nodeRef;
					}
					catch(e){
						var selectedNode = '';
						var workSpace = '';
					}
					
					if(!isNullOrEmpty(selectedNode) && !isNullOrEmpty(workSpace)){
						var node = copyMoveWin.down('#fileNodesItemId').getValue();
						var parentNode = workSpace;
						copyMoveWin.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   					Ext.Ajax.request({
	   						type: 'rest',
	   						url: url,
	   						method: 'POST',
	   						jsonData : {
	   							node : node,
	   							parentNode: parentNode
	   						},
	   						headers : {
	   			   				'Content-Type' : 'application/json'
	   			   			},
	   						success: function(form, action) {
	   							copyMoveWin.body.unmask();
	   							showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
	   							copyMoveWin.close();
	   							var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
	   							try{
	   								var selectedNode = treepanel.getSelectionModel().getSelection()[0];
	   								var workSpace = selectedNode.raw.nodeRef;
	   							}
	   							catch(e){
	   								var selectedNode = '';
	   								var workSpace = '';
	   							}
	   							if(!isNullOrEmpty(selectedNode)){
	   								me.selectTreeNode(treepanel, selectedNode);
	   							}
	   						}
	   					});
					}
				}
			},
			'documentcopymovewindow button[itemId=dmsDocCopyCancelButtonId]':{
				click: function(btn){
					btn.up('window').close();
				}
			},
			'sitedocumentupdatewindow button[itemId=cancelImageBtnWin]':{
				click: function(btn){
					btn.up('window').close();
				}
			},
			'sitedocumentupdatewindow':{
				afterrender: function(win){
					var me = this;
					var node = win.node;
					var minorVersion = win.minorVersion;
					var majorVersion = win.majorVersion;
					
					var radioGroupField = win.down('#versionInfo');
					var minorField = radioGroupField.items.items[0];
					var majorField = radioGroupField.items.items[1];
					
					minorField.setBoxLabel(getDMSTranslation('MINOR_CHANGES')+' ('+minorVersion+')');
					majorField.setBoxLabel(getDMSTranslation('MAJOR_CHANGES')+' ('+majorVersion+')');
				}
			},
			'sitedocumentupdatewindow button[itemId=submitImageBtnWin]':{
				click: function(btn){
					var me = this;
					var win = btn.up('sitedocumentupdatewindow');
					
					var node = win.node;
					var minorVersion = win.minorVersion;
					var majorVersion = win.majorVersion;
					
					var currentVersion = win.down('#versionInfo').getValue();
					
					var comment = win.down('#commentTextareaItemId').getValue();
					
					var allFiles = $('[type=file]').prop('files');
					try{
						if(allFiles.length==0){
							allFiles = $('[type=file]')[$('[type=file]').length-1].files;
						}
					}
					catch(e){
						
					}
					var filesArray = [];
					Ext.each(allFiles,function(currentFile){
						var formData = new FormData();
						formData.append("file", currentFile);
						formData.append("siteId", me.getEditsitestructure().siteId);
						formData.append("fileType", currentFile.type);
						formData.append("description", comment);
						formData.append("node", node);
						formData.append("updatenameandmimetype", true);
						if(currentVersion.versionInfo=="minor"){
							formData.append("majorVersion", false);
							formData.append("siteOverwrite", true);
						}
						else{
							formData.append("majorVersion", true);
							formData.append("siteOverwrite", true);
						}

						filesArray.push(formData);
					});
					btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					
					$.ajax({
					    url: SERVERURL.PATH_UPLOAD_SITE_DOCUMENT,
					    method: 'POST',
					    data: filesArray[0],
					    contentType: false,
					    processData: false,
					    dataType: 'text',
					    headers :{
					    	'Authorization':Ext.Ajax.defaultHeaders.Authorization,
					    	'Accept-Type':'application/json'
					    },
					    success: function (response) {
					    	btn.up('window').body.unmask();
				    		btn.up('window').close();

					    	var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
					    	try{
					    		var selectedNode = treepanel.getSelectionModel().getSelection()[0];
					    		var workSpace = selectedNode.raw.nodeRef;
					    	}
					    	catch(e){
					    		var selectedNode = '';
					    		var workSpace = '';
					    	}
					    	if(!isNullOrEmpty(selectedNode)){
					    		me.selectTreeNode(treepanel, selectedNode);
					    	}
					    },
					    error: function (err) {
					    	btn.up('window').body.unmask();
					    }
					});
				}
			},
			'viewdocumentpanel':{
				afterrender: function(viewdocumentpanel){
					var me = this;
					viewdocumentpanel.down('#documentPathItemId').getEl().on('click', function(){
						var documentLibraryBtn = me.getEditsitestructure().down('#documentLibraryBtnItemId');
						documentLibraryBtn.fireHandler();
					});
					me.renderDocumentWorkFlows(viewdocumentpanel);
					me.renderDocumentVersions(viewdocumentpanel);
				}
			},
			'viewdocumentpanel button[itemId=documentDownloadBtnItemId]':{
				click: function(btn){
					var me = this;
					var selectedRedord = btn.up('viewdocumentpanel').config;
					var fileName = selectedRedord.fileName;
					var node = selectedRedord.fileNodeRef;
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_SITE_DOC_DOWNLOAD,
						method: 'POST',
						jsonData : {
							fileName: fileName,
							node: node
						},
						headers : {
			   				'Content-Type' : 'application/json'
			   			},
						success: function(response, action) {
							var responseText = Ext.decode(response.responseText);
							if(responseText.status=="success"){
								me.downloadURI(responseText.url,fileName);
							}
						}
					});
				}
			},
			'viewdocumentpanel dataview[itemId=versionHistoryDataViewItemId]':{
				itemclick: function(view, record, item, idx, event, opts) {
					var me = this;
					var viewdocumentpanel = view.up('viewdocumentpanel');
					if(event.target.className=="downloadVersionBtnIconCls"){
						var selectedRedord = record;
						var fileName = record.data.fileName;
						var node = record.data.nodeRef;
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_SITE_DOC_DOWNLOAD,
							method: 'POST',
							jsonData : {
								fileName: fileName,
								node: node
							},
							headers : {
				   				'Content-Type' : 'application/json'
				   			},
							success: function(response, action) {
								var responseText = Ext.decode(response.responseText);
								if(responseText.status=="success"){
									me.downloadURI(responseText.url,fileName);
								}
							}
						});
					}
					else if(event.target.className=="revertVersionBtnIconCls"){
						var revertToNode = record.data.nodeRef;
						var revertToVersion = record.data.version;
						var currentNode = viewdocumentpanel.config.fileNodeRef
						var currentVersion = viewdocumentpanel.config.fileVersion;;
						var minorVersion = currentVersion.split('.')[0]+'.'+(parseInt(currentVersion.split('.')[1])+1);
						var majorVersion = (parseInt(currentVersion.split('.')[0])+1)+'.0';
	        			var formWindow = me.getSitedocumentrevertwindow();
	        			if (!formWindow) {
	        				Ext.widget('sitedocumentrevertwindow',{
	        					itemId: 'sitedocumentrevertwindow',
	        					currentNode: currentNode,
	        					revertToVersion: revertToVersion,
	        					minorVersion: minorVersion,
	        					majorVersion: majorVersion
	        				});
	        				var formWindow = me.getSitedocumentrevertwindow();
	        			}
	        			formWindow.show();
					}
				}
			},
			'sitedocumentrevertwindow button[itemId=submitRevertBtnWin]':{
				click: function(btn){
					var me = this;
					var viewdocumentpanel = me.getViewdocumentpanel();
					var sitedocumentrevertwindow = btn.up('window');
					Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_SITE_DOCUMENT_REVERT,
        				jsonData : {
        					node : sitedocumentrevertwindow.currentNode,
        					version : sitedocumentrevertwindow.revertToVersion,
        					majorVersion: ((sitedocumentrevertwindow.down('#versionInfo').getValue().versionInfo=="minor") ? false : true),
        					description: sitedocumentrevertwindow.down('#commentTextareaItemId').getValue()
        				},
        				headers : {
       	    				'Content-Type' : 'application/json'
       	    			},
        				method : 'POST',
        				success : function(response) {
        					Ext.getBody().unmask();
        					if(response.responseText=="success"){
            					showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
            					btn.up('window').close();
            					me.renderDocumentVersions(viewdocumentpanel);
        					}
        				}
        			});
				}
			},
			'sitedocumentrevertwindow button[itemId=cancelRevertBtnWin]':{
				click: function(btn){
					btn.up('window').close();
				}
			},
			'sitememberssidepanel':{
				afterrender: function(pnl){
					var me = this;
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_GET_SITE_BY_SHORTNAME,
						method: 'GET',
						params: {
							site : me.getEditsitestructure().siteId
						},
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(response, action) {
							var responseText = Ext.decode(response.responseText);
							
							var isManager = me.isSiteManager(responseText);
							
							if(isManager==true &&  responseText.visibility=="MODERATED"){
								pnl.down('#siteMembersPendingBtn').setVisible(true);
							}
						}
					});
				}
			},
			'sitememberssidepanel button[itemId=siteMembersUserBtn]':{
				click: function(btn){
					var me = this;
					var editSiteStructure = me.getEditsitestructure();
					
					var siteMembersCenterPanel = editSiteStructure.down('sitememberscenterpanel');
					var siteMembersUserListDataViewItemId = siteMembersCenterPanel.down('#siteMembersUserListDataViewItemId');
					var siteMembersUserListDataViewStore = siteMembersUserListDataViewItemId.getStore();
					var siteMembersSearchMappedUser =siteMembersCenterPanel.down('#siteMembersSearchMappedUser');
					
					var siteId = editSiteStructure.siteId;
					
					siteMembersCenterPanel.down('panel').setTitle(getDMSTranslation('SEARCH_SITE_MEMBERS'));
					siteMembersUserListDataViewStore.removeAll();
					siteMembersUserListDataViewStore.clearFilter();
					siteMembersSearchMappedUser.setValue('');
					
					siteMembersUserListDataViewStore.getProxy().api.read = SERVERURL.PATH_GET_SITE_USERS;
					siteMembersUserListDataViewStore.getProxy().extraParams.site=siteId;
					siteMembersUserListDataViewStore.load();
					editSiteStructure.down('#siteMembersBtnItemId').addCls('btnPressed');
				}
			},
			'sitememberssidepanel button[itemId=siteMembersPendingBtn]':{
				click: function(btn){
					var me = this;
					me.getAllPendingRequests();
				}
			},
			'sitememberscenterpanel dataview[itemId=siteMembersUserListDataViewItemId]':{
        		itemclick:function( dv, record, item, index, e, eOpts ){
        			var me = this;
        			if(e.target.className=="deleteIcon"){
        				showConfirmMessage(getDMSTranslation('DMS_SITE'), getDMSTranslation('DELETE_SITE_USR_MSG'), function(btn, text) {
       	    				if (btn == 'yes') {
       	    					Ext.Ajax.request({
       	    						type: 'rest',
       	    						url: SERVERURL.PATH_DELETE_SITE_USER,
       	    						method: 'GET',
       	    						params: {
       	    							site : me.getEditsitestructure().siteId,
       	    							userName: record.get('userName')
       	    						},
       	    						headers: {
       	    							'Content-Type': 'application/json'
       	    						},
       	    						success: function(form, action) {
       	    							showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
       	    							dv.getStore().load();
       	    						}
       	    					});
       	    				}
       	    			});
        			}
        			else if(e.target.className=="siteUserApproveBtn" || e.target.className=="siteUserRejectBtn"){
        				var userActivityId = record.get('userActivityId');
        				var status = (e.target.className=="siteUserApproveBtn" ? "approve" : "reject");
        				var comment = "";
        				Ext.Ajax.request({
        					type: 'rest',
        					url: SERVERURL.PATH_SITE_APPROVE_REJECT_REQUEST,
        					method: 'GET',
        					params: {
        						userActivityId : userActivityId,
        						status: status,
        						comment: comment
        					},
        					headers: {
        						'Content-Type': 'application/json'
        					},
        					success: function(form, action) {
        						showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
        						me.getAllPendingRequests();
        					}
        				});
        			}
        		},
        		afterrender: function(dv){
        			var me = this;
        			var currentUser = (me.getCurrentlyLoggedInUser().code=="sysadmin") ? "admin" : (me.getCurrentlyLoggedInUser().code);
        			dv.getStore().on('load',function(record){
        				console.log(record);
        				Ext.each(record.data.items, function(currentItems){
        					if(currentUser==currentItems.get('userName')){
        						me.getEditsitestructure().role = currentItems.get('role');
        					}
        				});
        			});
        		}
        	},
        	'textfield[itemId=siteMembersSearchMappedUser]':{
        		keyup: function( obj, e, eOpts ){
        			var me = this;
        			var dataView = obj.up().down('#siteMembersUserListDataViewItemId');
        			var dataViewStore = dataView.getStore();
        			dataViewStore.clearFilter(true);
        			dataViewStore.filterBy(function(record, id){
        				var match = false;
                        Ext.each(dataViewStore.fields, function(field) {
                        	try{
                                if (record.get(field).toUpperCase().indexOf(obj.getValue().toUpperCase())!="-1") {
                                    match = true;
                                    return false; // break the loop
                                }
                        	}
                        	catch(e){
                        		try{
                            		if (record.get(field.name).toUpperCase().indexOf(obj.getValue().toUpperCase())!="-1") {
                                        match = true;
                                        return false; // break the loop
                                    }
                        		}
                        		catch(e){}
                        	}
                        });
                        return match;
        	        });
        		}
        	},
        	'workflowpanel combobox[itemId=selectWorkflowItemId]':{
        		change: function(obj, value){
        			var me = this;
        			var workflowpanel = obj.up('workflowpanel');
        			var worflowInnerPanelItemId = workflowpanel.down('#worflowInnerPanelItemId');
        			var workflowDocument = workflowpanel.down('#workflowDocumentItemId');
        			var workflowDocumentStore = workflowDocument.getStore();
        			
        			worflowInnerPanelItemId.setVisible(true);
        			var nodeRecord = workflowpanel.config.node;
        			workflowDocumentStore.removeAll();
        			workflowDocumentStore.add(nodeRecord);
        		},
        		afterrender: function(obj){
        			setTimeout(function(){
        				obj.setValue(obj.getStore().data.items[0]);
        				obj.setReadOnly(true);
        			},300);
        		}
        	},
        	'workflowpanel button[itemId=startWorkflowBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			
        			var workflowpanel = btn.up('workflowpanel');
        			var node = workflowpanel.config.node;
        			
        			var requiredPercentage = workflowpanel.down('#requiredApprovalPercentageItemId').getValue();
        			var reviewers = workflowpanel.down('#reviewersItemId').getValue();
        			var reviewersIds = [];
        			Ext.each(reviewers, function(currentReviewer){
        				reviewersIds.push(currentReviewer.data.id);
        			});
        			var priority = workflowpanel.down('#priorityComboItemId').getValue();
        			var dueDate = workflowpanel.down('#dueDateItemId').getValue();
        			var description = workflowpanel.down('#messageTextareaItemId').getValue();
        			
        			
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_CREATE_MULTIPLE_USERS,
        				method: 'POST',
        				jsonData : {
        					userName: reviewersIds.join(),
        				},
        				headers : {
        	   				'Content-Type' : 'application/json'
        	   			},
        				success: function(response, action) {
        					Ext.Ajax.request({
                				type: 'rest',
                				url: SERVERURL.PATH_CREATE_WORKFLOW,
                				method: 'POST',
                				jsonData : {
                					parentNode: node.parendNodeRef,
                					description: description,
                					workFlowDueDate : dueDate,
                					workFlowPriority: priority,
                					userName: reviewersIds.join(),
                					userToBeRemoved:'',
                					requiredApprovedPercentage: requiredPercentage,
                					node: node.nodeRef,
                					activityId: 'activiti$activitiParallelReview'
                				},
                				headers : {
                	   				'Content-Type' : 'application/json'
                	   			},
                				success: function(response, action) {
                					showSuccessMessage(getDMSTranslation('SUCCESS'), getDMSTranslation('SUCCESS_MSG'));
                					var documentLibraryBtn = me.getEditsitestructure().down('#documentLibraryBtnItemId');
            						documentLibraryBtn.fireHandler();
                				}
                			});
        				}
        			});
        		}
        	},
        	'workflowpanel button[itemId=cancelWorkflowBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			var documentLibraryBtn = me.getEditsitestructure().down('#documentLibraryBtnItemId');
					documentLibraryBtn.fireHandler();
        		}
        	},
        	'dmstaskgrid': {
        		afterrender: function(grid){
        			var me = this;
        			var gridStore = grid.getStore();
        			gridStore.on('load',function(){
        				gridStore.clearFilter(true);
        				gridStore.filter('name', 'wf:activitiReviewTask');
        			});
        			gridStore.load();
        		},
        		selectionchange: function(grid, record){
					var me = this;
					var btnEdit = grid.view.up('grid').down('#btnEdit');
					btnEdit.setDisabled(!record.length);
        		}
        	},
        	'dmstaskgrid button[itemId=btnEdit]':{
        		click: function(btn){
        			var me = this;
        			var contentpanel = me.getContentPanel();
        			var edittaskstructure = Ext.widget('edittaskstructure');
        			var tabName = getDMSTranslation('EDIT_TASK');

        			var getcontroller=this.getController('menu.CoreERPNavigationController');
        			var getTab=getcontroller.getTab(tabName);
        			if(getTab!=null){
        				contentpanel.remove(getTab, true);
        			}
        			openTab(contentpanel, tabName, edittaskstructure);
        		}
        	},
        	'edittaskstructure':{
        		afterrender:  function(structure){
        			var me = this;
        			var dmstaskgrid = me.getDmstaskgrid();
        			var record = dmstaskgrid.getSelectionModel().getSelection()[0].data;
        			var formData = {
            			id: record.id,
            			owner_userName: record.owner_userName,
            			title: record.title,
            			workflowInstance_message: record.workflowInstance_message,
            			owner: record.owner_firstName+" "+record.owner_lastName,
            			propertyLabels_bpm_priority: record.propertyLabels_bpm_priority,
            			workflowInstance_dueDate: record.workflowInstance_dueDate,
            			identifier: record.id.split('$')[1],
            			propertyLabels_bpm_status: record.propertyLabels_bpm_status
        			};
        			
        			structure.down('form').getForm().setValues(formData);
        		}
        	},
        	'viewdocumentpanel dataview[itemId=workflowListItemId]':{
        		itemclick:function( dv, record, item, index, e, eOpts ){
        			var me = this;
        			if(e.target.className=="workflow_description workflowEditable"){
        				var viewdocumentpanel = me.getEditsitestructure().down('viewdocumentpanel');
						
						var filePath = viewdocumentpanel.config.filePath;
						var fileIcon = viewdocumentpanel.config.fileIcon;
						var fileName = viewdocumentpanel.config.fileName;
						var fileVersion = viewdocumentpanel.config.fileVersion;
						var fileUpdateText = viewdocumentpanel.config.fileUpdateText;
						var fileNodeRef = viewdocumentpanel.config.fileNodeRef;
						var node = viewdocumentpanel.config.node;
						
						var editSiteStructure = me.getEditsitestructure();
						var siteId = editSiteStructure.siteId;
						var westRegion = editSiteStructure.down('[region=west]');
						var centerRegion = editSiteStructure.down('[region=center]');
						westRegion.removeAll();
						centerRegion.removeAll();
						
						westRegion.hide();
						
						centerRegion.add({
							xtype:'editworkflowpanel',
							config:{
								filePath: filePath,
								fileIcon: fileIcon,
								fileName: fileName,
								fileVersion: fileVersion,
								fileUpdateText: fileUpdateText,
								fileNodeRef: fileNodeRef,
								recordData: record.data,
								node: node,
								showBtn: ['approveWorkflowBtnItemId','rejectWorkflowBtnItemId','saveAndCloseEditWorkflowBtnItemId']
							}
						});
        			}
        		}
        	},
        	'viewdocumentpanel dataview[itemId=completedWorkflowListItemId]':{
        		itemclick:function( dv, record, item, index, e, eOpts ){
        			var me = this;
        			if(e.target.className=="workflow_description workflowEditable"){
        				var viewdocumentpanel = me.getEditsitestructure().down('viewdocumentpanel');
						
						var filePath = viewdocumentpanel.config.filePath;
						var fileIcon = viewdocumentpanel.config.fileIcon;
						var fileName = viewdocumentpanel.config.fileName;
						var fileVersion = viewdocumentpanel.config.fileVersion;
						var fileUpdateText = viewdocumentpanel.config.fileUpdateText;
						var fileNodeRef = viewdocumentpanel.config.fileNodeRef;
						var node = viewdocumentpanel.config.node;
						
						var editSiteStructure = me.getEditsitestructure();
						var siteId = editSiteStructure.siteId;
						var westRegion = editSiteStructure.down('[region=west]');
						var centerRegion = editSiteStructure.down('[region=center]');
						westRegion.removeAll();
						centerRegion.removeAll();
						
						westRegion.hide();
						
						centerRegion.add({
							xtype:'editworkflowpanel',
							config:{
								filePath: filePath,
								fileIcon: fileIcon,
								fileName: fileName,
								fileVersion: fileVersion,
								fileUpdateText: fileUpdateText,
								fileNodeRef: fileNodeRef,
								recordData: record.data,
								node: node,
								showBtn: []
							}
						});
        			}
        		}
        	},
        	'viewdocumentpanel dataview[itemId=activeWorkflowIHaveStartedListItemId]':{
        		itemclick:function( dv, record, item, index, e, eOpts ){
        			var me = this;
        			if(e.target.className=="workflow_description workflowEditable"){
        				var viewdocumentpanel = me.getEditsitestructure().down('viewdocumentpanel');
						
						var filePath = viewdocumentpanel.config.filePath;
						var fileIcon = viewdocumentpanel.config.fileIcon;
						var fileName = viewdocumentpanel.config.fileName;
						var fileVersion = viewdocumentpanel.config.fileVersion;
						var fileUpdateText = viewdocumentpanel.config.fileUpdateText;
						var fileNodeRef = viewdocumentpanel.config.fileNodeRef;
						var node = viewdocumentpanel.config.node;
						
						var editSiteStructure = me.getEditsitestructure();
						var siteId = editSiteStructure.siteId;
						var westRegion = editSiteStructure.down('[region=west]');
						var centerRegion = editSiteStructure.down('[region=center]');
						westRegion.removeAll();
						centerRegion.removeAll();
						
						westRegion.hide();
						
						centerRegion.add({
							xtype:'editmyworkflowpanel',
							config:{
								filePath: filePath,
								fileIcon: fileIcon,
								fileName: fileName,
								fileVersion: fileVersion,
								fileUpdateText: fileUpdateText,
								fileNodeRef: fileNodeRef,
								recordData: record.data,
								node: node,
								showBtn: []
							}
						});
        			}
        		}
        	},
        	'editworkflowpanel':{
        		afterrender: function(panel){
        			var me = this;
        			var recordData = panel.config.recordData;
        			
        			var editworkflowpanel = panel;
        			var editWorkflowDocument = editworkflowpanel.down('#editWorkflowDocumentItemId');
        			var editWorkflowDocumentStore = editWorkflowDocument.getStore();
        			
        			var nodeRecord = panel.config.node;
        			editWorkflowDocumentStore.removeAll();
        			editWorkflowDocumentStore.add(nodeRecord);
        			
        			var formData = {
        				activityId: recordData.id,
	        			messageDisplayField: recordData.message,
	        			ownerDisplayField: recordData.owner,
	        			priorityDisplayField: ((recordData.priority==1)?"High":((recordData.priority==2)?"Medium":"Low")),
	        			dueDateDisplayField: dateRender(recordData.dueDate),
	        			identifierDisplayField: recordData.id.split('$')[1],
	        			statusField: recordData.status
        			};
        			
        			editworkflowpanel.down('form').getForm().setValues(formData);
        			
        			Ext.each(panel.config.showBtn, function(btnItemId){
        				editworkflowpanel.down('#'+btnItemId).setVisible(true);
        			});
        		}
        	},
        	'editworkflowpanel button[itemId=approveWorkflowBtnItemId], editworkflowpanel button[itemId=rejectWorkflowBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			var form = btn.up('form');
        			if(btn.itemId=="approveWorkflowBtnItemId"){
        				var activityFilter = 'Approve';
        			}
        			else{
        				var activityFilter = 'Reject';
        			}
        			var status = form.down('#statusFieldItemId').getValue();
        			
        			var formData = {
        				"node": form.down('#editWorkflowDocumentItemId').getStore().data.items[0].data.nodeRef,
        				"description": form.down('#commentFieldItemId').getValue(),
        				"activityFilter": activityFilter,
        				"status": (status=='Not Yet Started'?"NOT_YET_STARTED":(status=='In Progress'?"IN_PROGRESS":(status=='On Hold'?"ON_HOLD":(status=='Cancelled'?"CANCELLED":"COMPLETED")))),
        				"activityId":form.down('#activityIdItemId').getValue()
        			}
        			
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_APPROVE_REJECT_WORKFLOW,
        				method: 'POST',
        				jsonData : formData,
        				headers : {
        	   				'Content-Type' : 'application/json'
        	   			},
        				success: function(response, action) {
        					if(response.responseText=="success"){
        						var documentLibraryBtn = me.getEditsitestructure().down('#documentLibraryBtnItemId');
        						documentLibraryBtn.fireHandler();
        					}
        				}
        			});
        		}
        	},
        	'editworkflowpanel button[itemId=taskDoneBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			//--Task Done Functionality Here
        		}
        	},
        	'editworkflowpanel button[itemId=saveAndCloseEditWorkflowBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			//--Save And Close
        		}
        	},
        	'editworkflowpanel button[itemId=cancelEditWorkflowBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			var documentLibraryBtn = me.getEditsitestructure().down('#documentLibraryBtnItemId');
					documentLibraryBtn.fireHandler();
        		}
        	},
        	'editmyworkflowpanel button[itemId=cancelMyEditWorkflowBtnItemId]':{
        		click: function(btn){
        			var me = this;
        			var documentLibraryBtn = me.getEditsitestructure().down('#documentLibraryBtnItemId');
					documentLibraryBtn.fireHandler();
        		}
        	},
        	'editmyworkflowpanel':{
        		afterrender: function(panel){
        			var me = this;
        			var recordData = panel.config.recordData;
        			
        			var editMyWorflowInnerPanel = panel.down('#editMyWorflowInnerPanelItemId');
        			
        			var editmyworkflowpanel = panel;
        			var editMyWorkflowDocument = editmyworkflowpanel.down('#editMyWorkflowDocumentItemId');
        			var editMyWorkflowDocumentStore = editMyWorkflowDocument.getStore();
        			
        			var nodeRecord = panel.config.node;
        			editMyWorkflowDocumentStore.removeAll();
        			editMyWorkflowDocumentStore.add(nodeRecord);
        			
        			var currentTaskGrid = editmyworkflowpanel.down('#myWorkflowCurrentTaskGridItemId');
        			var currentTaskGridStore = currentTaskGrid.getStore();
        			currentTaskGridStore.removeAll();
        			
        			var historyGrid = editmyworkflowpanel.down('#myWorkflowHistoryGridItemId');
        			var historyGridStore = historyGrid.getStore();
        			historyGridStore.removeAll();
					
					Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_GET_WORKFLOW_INFO_BY_ACTIVITY_ID,
        				params : {
        					activityId : recordData.id
    					},
    					headers : {
    		   				'Content-Type' : 'application/json'
    		   			},
    					method : 'GET',
    					success: function(response, action) {
    						//--
    						var res = Ext.decode(response.responseText)
    						var isInProgress = "Workflow is completed";
    						
    						var completedOn = '';
    						var completedBy = '';
    						var outcome = '';
    						var commenter = '';
    						var comment = '';
    						
    						var requirePercentage = 0;
    						var sendEmailNotification = 'No';
    						
    						var currentTasks = [];
    						var history = [];
    						
    						Ext.each(res.data.tasks, function(currentTask){
    							if(currentTask.state=="IN_PROGRESS"){
    								isInProgress = "Workflow is in progress";
    								
    								currentTasks.push({
            							id: currentTask.id,
            							type: currentTask.title,
            							assignedTo: currentTask.owner.firstName+" "+currentTask.owner.lastName,
            							dueDate: dateRender(currentTask.workflowInstance.dueDate),
            							status: currentTask.propertyLabels.bpm_status,
            							actions: ''
            						});
    								
    							} else if(currentTask.state=="COMPLETED"){
    								completedOn = dateRender(currentTask.properties.bpm_completionDate.split('T')[0]);
    								completedBy = currentTask.owner.firstName+" "+currentTask.owner.lastName;
    								outcome = currentTask.outcome;
    								commenter = currentTask.owner.firstName+" "+currentTask.owner.lastName;
    								comment = (isNullOrEmpty(currentTask.properties.bpm_comment)?"(No Comment)":currentTask.properties.bpm_comment);
    								
    								requirePercentage = currentTask.properties.wf_requiredApprovePercent;
    								sendEmailNotification = currentTask.properties.bpm_sendEMailNotifications;
    								
            						history.push({
            							type: currentTask.title,
            							completedBy: currentTask.owner.firstName+" "+currentTask.owner.lastName,
            							dateCompleted: dateRender(currentTask.workflowInstance.startDate),
            							outcome: currentTask.outcome,
            							comment: currentTask.properties.bpm_comment
            						});
    							}
        						
        						
    						});

    						var workflowSummary = [{
    							isInProgress: isInProgress,
    							dueDate: "Due on "+dateRender(res.data.dueDate),
    							priority: ((res.data.priority==1)?"High":((res.data.priority==2)?"Medium":"Low"))+" Priority",
    							completedOn: completedOn,
    							completedBy: completedBy,
    							outcome: outcome,
    							commenter: commenter,
    							comment: comment
    						}];
    						
    						var generalInfo = {
    							title: res.data.title,
    							description: res.data.description,
    							startedBy: res.data.initiator.firstName+" "+res.data.initiator.lastName,
    							due:dateRender(res.data.dueDate),
    							completed: dateRender(res.data.endDate),
    							started: dateRender(res.data.startDate),
    							priority: ((res.data.priority==1)?"High":((res.data.priority==2)?"Medium":"Low")),
    							status: isInProgress,
    							message: res.data.message
    						};
    						
    						var moreInfo = {
    							requiredApprovalPercentage: requirePercentage,
    							sendEmailNotification: ((sendEmailNotification==false || sendEmailNotification=="No")?"No":"Yes")
    						};
    						
    						
    						editMyWorflowInnerPanel.down('#activityIdItemId').setValue(recordData.id);
    						
    						editMyWorflowInnerPanel.down('#myWorkflowSummaryDVItemId').getStore().removeAll();
    						editMyWorflowInnerPanel.down('#myWorkflowSummaryDVItemId').getStore().add(workflowSummary);
    						
    						editMyWorflowInnerPanel.down('#titleItemId').setValue(generalInfo.title);
    						editMyWorflowInnerPanel.down('#descriptionItemId').setValue(generalInfo.description);
    						editMyWorflowInnerPanel.down('#startedByItemId').setValue(generalInfo.startedBy);
    						editMyWorflowInnerPanel.down('#dueItemId').setValue(generalInfo.due);
    						editMyWorflowInnerPanel.down('#completedItemId').setValue(generalInfo.completed);
    						editMyWorflowInnerPanel.down('#startedItemId').setValue(generalInfo.started);
    						editMyWorflowInnerPanel.down('#priorityItemId').setValue(generalInfo.priority);
    						editMyWorflowInnerPanel.down('#statusItemId').setValue(generalInfo.status);
    						editMyWorflowInnerPanel.down('#messageItemId').setValue(generalInfo.message);
    						
    						editMyWorflowInnerPanel.down('#requiredPercentageItemId').setValue(moreInfo.requiredApprovalPercentage);
    						editMyWorflowInnerPanel.down('#sendEmailNotificationItemId').setValue(moreInfo.sendEmailNotification);
    						
    						currentTaskGridStore.add(currentTasks);
    						historyGridStore.add(history);
    					}
        			});
        		}
        	},
        	'filestructure':{
        		afterrender: function(structure){
        			var me = this;
        			var userId = me.getCurrentlyLoggedInUser().id;
        			setTimeout(function(){
            			me.getContentPanel().getActiveTab().close();
        			},10);
        			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        			Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.PATH_GET_LOGIN_TOKEN,
    					params : {
    						userId : userId,
    						isApplicant : false
    					},
    					headers : {
    		   				'Content-Type' : 'application/json'
    		   			},
    					method : 'GET',
    					success : function(response) {
    						//--
    						if(!isNullOrEmpty(response.responseText)){
    							me.loadIframe(response.responseText);
    						}
    					}
    				});
        		}
        	}
		});
	},
	updateEditSiteStructure:function(siteId){
		var me = this;
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_SITE_BY_SHORTNAME,
			method: 'GET',
			params: {
				site : siteId
			},
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(response, action) {
				var responseText = Ext.decode(response.responseText);
				
				var isManager = me.isSiteManager(responseText);
				
				if(isManager){
					me.getEditsitestructure().down('#editSiteAddUserBtnItemId').setVisible(true);
					me.getEditsitestructure().down('#settingCustomizeDashboardMenuBtnItemId').setVisible(true);
					me.getEditsitestructure().down('#editDmsSiteDetailsItemId').setVisible(true);
					me.getEditsitestructure().down('#settingCustomizeSiteMenuBtnItemId').setVisible(true);
					me.getEditsitestructure().down('#settingDeleteSiteMenuBtnItemId').setVisible(true);
				}
				else{
					me.getEditsitestructure().down('#editSiteAddUserBtnItemId').setVisible(false);
					me.getEditsitestructure().down('#settingCustomizeDashboardMenuBtnItemId').setVisible(false);
					me.getEditsitestructure().down('#editDmsSiteDetailsItemId').setVisible(false);
					me.getEditsitestructure().down('#settingCustomizeSiteMenuBtnItemId').setVisible(false);
					me.getEditsitestructure().down('#settingDeleteSiteMenuBtnItemId').setVisible(false);
				}

				var siteName = responseText.title;
				var siteId = responseText.shortName;
				var siteVisibility = responseText.visibility
				
				me.getEditsitestructure().siteName = siteName;
				me.getEditsitestructure().siteId = siteId;
				
				me.getEditsitestructure().down('#siteNameField').setText(siteName);
				me.getEditsitestructure().down('#siteVisibility').setText(getDMSTranslation(siteVisibility));
				me.getEditsitestructure().down('#siteVisibility').el.dom.title = getDMSTranslation(siteVisibility+'_MSG');
				try{
					me.getEditsitestructure().down('#siteContentFilterItemId').setValue('recentlyModifiedByMe');
					me.getEditsitestructure().down('#siteUserFilterItemId').setValue('all');
					me.getEditsitestructure().down('#siteActivityFilterItemId').setValue('');
					me.getEditsitestructure().down('#siteDateFilterItemId').setValue('28');
					
					var userListDataViewStore = me.getEditsitestructure().down('#userListDataViewItemId').getStore();
					userListDataViewStore.getProxy().extraParams.site=siteId;
					userListDataViewStore.load();
					me.getEditsitestructure().down('#siteDashboardBtnItemId').addCls('btnPressed');
				}
				catch(e){}
				
				try{
						me.getEditsitestructure().down('sitememberscenterpanel').down('panel').setTitle(getDMSTranslation('SEARCH_SITE_MEMBERS'));
						var siteMembersUserListDataViewStore = me.getEditsitestructure().down('#siteMembersUserListDataViewItemId').getStore();
						siteMembersUserListDataViewStore.getProxy().extraParams.site=siteId;
						siteMembersUserListDataViewStore.load();
						me.getEditsitestructure().down('#siteMembersBtnItemId').addCls('btnPressed');
				}
				catch(e){}

				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.PATH_GET_FAVORITE_SITE_BY_ID,
					params : {
						site : siteId
					},
					headers : {
		   				'Content-Type' : 'application/json'
		   			},
					method : 'GET',
					success : function(response) {
						var responseText = Ext.decode(response.responseText);
						if(responseText.showRemoveFavourite){
							Ext.query('.starLabel span')[0].classList.add("selected");
						}
						else{
							Ext.query('.starLabel span')[0].classList.remove("selected");
						}
					}
				});
			}
		});
	},
	isSiteManager: function(selectedRecord){
		var me = this;
		var isManager = false;
		Ext.each(selectedRecord.siteManagers, function(currentSiteManager){
			var currentUser = (me.getCurrentlyLoggedInUser().code=="sysadmin") ? "admin" : (me.getCurrentlyLoggedInUser().code);
			if(currentSiteManager.toUpperCase() == currentUser.toUpperCase()){
				isManager = true;
			}
		});
		return isManager;
	},
	loadEditTab: function(selectedtTab){
		var me = this;
		var editSiteStructure = me.getEditsitestructure();
		var siteId = editSiteStructure.siteId;
		var westRegion = editSiteStructure.down('[region=west]');
		var centerRegion = editSiteStructure.down('[region=center]');
		westRegion.removeAll();
		centerRegion.removeAll();
		
		westRegion.show();
		
		if(selectedtTab=="siteDashboard"){
			westRegion.add({xtype:'sitedashboardsidepanel'});
			centerRegion.add({xtype:'sitedashboardcenterpanel'});
		}
		else if(selectedtTab=="documentLibrary"){
			westRegion.add({xtype:'documentlibrarysidepanel'});
			centerRegion.add({xtype:'documentlibrarycenterpanel'});
		}
		else if(selectedtTab=="siteMembers"){
			westRegion.add({xtype:'sitememberssidepanel'});
			centerRegion.add({xtype:'sitememberscenterpanel'});
		}
		editSiteStructure.doLayout();
		me.updateEditSiteStructure(siteId);
	},
	getDocumentLibraryTree: function(folderPath, node){
		var me = this;
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_LIBRARY_DOCUMENTS_LIST,
			method: 'GET',
			params: {
				site : me.getEditsitestructure().siteId,
				folderName: folderPath
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var childrenRecord = [];
				if(isNullOrEmpty(folderPath)){
					folderPath = '';
					var rootNodeRef = jsonResponse.metadata.container;
					var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
					treepanel.getRootNode().raw.nodeRef = rootNodeRef;
				}
				Ext.each(jsonResponse.items, function(currentItems){
					var createdObj = currentItems.node.properties['cm:created'];
					var creatorObj = currentItems.node.properties['cm:creator'];
					var modifiedObj = currentItems.node.properties['cm:modified'];
					var modifierObj = currentItems.node.properties['cm:modifier'];
					var parendNodeRef = '';
					
					try{
						var parendNodeRef = currentItems.parent.nodeRef;
					}
					catch(e){}
					
					var currentUserRole = me.getEditsitestructure().role;
					
					try{
						if(currentItems.node.properties['cm:workingCopyMode'] == "offlineEditing"){
							var lockedByUsername = currentItems.node.properties['cm:workingCopyOwner']["userName"];
							var currentUser = (me.getCurrentlyLoggedInUser().code=="sysadmin") ? "admin" : (me.getCurrentlyLoggedInUser().code);
							if(currentUser==lockedByUsername){
								var lockedByDisplayName = "you";
							}
							else{
								var lockedByDisplayName = currentItems.node.properties['cm:workingCopyOwner']['displayName'];
							}
						}
					}
					catch(e){
						var lockedByUsername = '';
						var lockedByDisplayName = '';
					}
					
					var isLocked = false;
					Ext.each(currentItems.metadataTemplate.banners, function(currentBanner){
						if(currentBanner.template=="{lockBanner}"){
							isLocked = true;
						}
					});
					
					if(createdObj.value == modifiedObj.value){
						var action = "Created";
						var time = createdObj.iso8601;
						var displayTime = createdObj.value;
						var userName = creatorObj.displayName;
					}
					else{
						var action = "Modified";
						var time = modifiedObj.iso8601;
						var displayTime = modifiedObj.value;
						var userName = modifierObj.displayName;
					}
					
					if(isLocked){
						var action = "Editing started";
					}
					
					if(currentItems.actionGroupId=="folder-browse"){
						childrenRecord.push({
							text: currentItems.displayName,
							folderPath: folderPath+'/'+currentItems.fileName,
							leaf: false,
							version: '',
							action: action,
							time: time,
							userName: userName,
							size: '',
							children:[],
							nodeRef: currentItems.nodeRef,
							isLocked: false,
							lockedByUsername: lockedByUsername,
							lockedByDisplayName: lockedByDisplayName,
							role: currentUserRole,
							activeWorkflows: currentItems.activeWorkflows,
							parendNodeRef: parendNodeRef
						});
					}
					else {
						if(Math.round(currentItems.node.size/1024)<1000){
							var fileSize = (Math.round(currentItems.node.size/1024)).toPrecision(3) + " KB";
						}
						else{
							var fileSize = ((Math.round(currentItems.node.size/1024))/1024).toPrecision(3) + " MB";
						}
						childrenRecord.push({
							text: currentItems.displayName,
							folderPath: folderPath+'/'+currentItems.fileName,
							leaf: true,
							version: currentItems.version,
							action: action,
							time: time,
							userName: userName,
							size: fileSize,
							nodeRef: currentItems.nodeRef,
							isLocked: isLocked,
							lockedByUsername: lockedByUsername,
							lockedByDisplayName: lockedByDisplayName,
							role: currentUserRole,
							activeWorkflows: currentItems.activeWorkflows,
							parendNodeRef: parendNodeRef
						});
					}
				});
				if(childrenRecord.length){
					me.getDocumentlibrarycenterpanel().down('#selectedItemsMenuItemId').setDisabled(true);
					node.removeAll();
					node.appendChild(childrenRecord);
					node.expand();
				}
				me.loadNodeDocuments(childrenRecord);
			}
		});
	},
	getDocumentLibraryWindowTree: function(folderPath, node){
		var me = this;
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_LIBRARY_DOCUMENTS_LIST,
			method: 'GET',
			params: {
				site : me.getEditsitestructure().siteId,
				folderName: folderPath
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var childrenRecord = [];
				if(isNullOrEmpty(folderPath)){
					folderPath = '';
					var rootNodeRef = jsonResponse.metadata.container;
					var treepanel = me.getDocumentcopymovewindow().down('#libraryDocumentWindowTreePanel');
					treepanel.getRootNode().raw.nodeRef = rootNodeRef;
				}
				Ext.each(jsonResponse.items, function(currentItems){
					var createdObj = currentItems.node.properties['cm:created'];
					var creatorObj = currentItems.node.properties['cm:creator'];
					var modifiedObj = currentItems.node.properties['cm:modified'];
					var modifierObj = currentItems.node.properties['cm:modifier'];
					if(createdObj.value == modifiedObj.value){
						var action = "Created";
						var time = createdObj.iso8601;
						var userName = creatorObj.displayName;
					}
					else{
						var action = "Modified";
						var time = modifiedObj.iso8601;
						var userName = modifierObj.displayName;
					}
					if(currentItems.actionGroupId=="folder-browse"){
						childrenRecord.push({
							text: currentItems.displayName,
							folderPath: folderPath+'/'+currentItems.fileName,
							leaf: false,
							version: '',
							action: action,
							time: time,
							userName: userName,
							size: '',
							children:[],
							nodeRef: currentItems.nodeRef
						});
					}
				});
				if(childrenRecord.length){
					//me.getDocumentlibrarycenterpanel().down('#selectedItemsMenuItemId').setDisabled(true);
					node.removeAll();
					node.appendChild(childrenRecord);
					node.expand();
				}
			}
		});
	},
	uploadSiteDocuments: function(btn){
		var me = this;
		var siteId = me.getEditsitestructure().siteId;
		var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
		try{
			var currentPath = treepanel.getSelectionModel().getSelection()[0].raw.folderPath;
		}
		catch(e){
			var currentPath = '';
		}
		if(typeof currentPath=="undefined"){
			var currentPath = '';
		}
		
		var allFiles = $('[type=file]').prop('files');
		try{
			if(allFiles.length==0){
				allFiles = $('[type=file]')[$('[type=file]').length-1].files;
			}
		}
		catch(e){
			
		}
		var filesArray = [];
		Ext.each(allFiles,function(currentFile){
			var formData = new FormData();
			formData.append("file", currentFile);
			formData.append("siteId", siteId);
			formData.append("fileType", currentFile.type);
			formData.append("folderName", currentPath);
			formData.append("description", "");
			formData.append("majorVersion", false);
			formData.append("siteOverwrite", false);
			filesArray.push(formData);
		});
		btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		me.uploadCurrentFile(0, filesArray, btn);
	},
	uploadCurrentFile: function(index, filesArray, btn){
		var me = this;
		$.ajax({
		    url: SERVERURL.PATH_UPLOAD_SITE_DOCUMENT,
		    method: 'POST',
		    data: filesArray[index],
		    contentType: false,
		    processData: false,
		    dataType: 'text',
		    headers :{
		    	'Authorization':Ext.Ajax.defaultHeaders.Authorization,
		    	'Accept-Type':'application/json'
		    },
		    success: function (response) {
		    	index = index + 1;
		    	if(index < filesArray.length){
		    		me.uploadCurrentFile(index, filesArray, btn);
		    	}
		    	else{
		    		btn.up('window').body.unmask();
		    		btn.up('window').close();
		    	}

		    	var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
		    	try{
		    		var selectedNode = treepanel.getSelectionModel().getSelection()[0];
		    		var workSpace = selectedNode.raw.nodeRef;
		    	}
		    	catch(e){
		    		var selectedNode = '';
		    		var workSpace = '';
		    	}
		    	if(!isNullOrEmpty(selectedNode)){
		    		me.selectTreeNode(treepanel, selectedNode);
		    	}
		    },
		    error: function (err) {
		    	btn.up('window').body.unmask();
		    }
		});
	},
	selectTreeNode: function(treepanel, node){
		var me = this;
		if(isNullOrEmpty(node)){
			node = treepanel.getRootNode();
		}
		treepanel.getSelectionModel().select(node);
		treepanel.fireEvent('itemclick',treepanel, node);
	},
	loadNodeDocuments: function(children){
		var me = this;
		var currentNodeData = [];
		Ext.each(children, function(currentFile){
			var fileIcon = me.getFileIcon(currentFile);
			currentNodeData.push({
				type: ((currentFile.leaf)?"file":"folder"),
				img: fileIcon,
				fileName: currentFile.text,
				version: currentFile.version,
				action: currentFile.action,
				time: getTimeDifference(currentFile.time),
				displayTime: currentFile.displayTime,
				userName: currentFile.userName,
				size: currentFile.size,
				displayVersion: ((currentFile.leaf)?"":"display:none;"),
				nodeRef: currentFile.nodeRef,
				folderPath: currentFile.folderPath,
				isLocked: currentFile.isLocked,
				lockedByUsername: currentFile.lockedByUsername,
				lockedByDisplayName: currentFile.lockedByDisplayName,
				role: currentFile.role,
				activeWorkflows: currentFile.activeWorkflows,
				parendNodeRef: currentFile.parendNodeRef
			});
		});
		var documentLibraryDataView = me.getEditsitestructure().down('#documentLibraryDataViewItemId');
		var documentLibraryDataViewStore = documentLibraryDataView.getStore();
		documentLibraryDataViewStore.removeAll();
		documentLibraryDataViewStore.add(currentNodeData);
	},
	getFileIcon: function(currentFile){
		var me = this;
		if(!currentFile.leaf){
			return "resources/images/folder-32.png";
		}
		else{
			var fileName = currentFile.text;
			var fileExtension = fileName.split(".")[fileName.split(".").length-1];
			if(!isNullOrEmpty(fileExtension)){
				var audioFiles = ['aif','cda','mid','midi','mp3','mpa','ogg','wav','wma','wpl'];
				var zipFiles = ['7z','arj','deb','pkg','rar','rpm','gz','z','zip'];
				var databaseFiles = ['csv','dat','db','dbf','log','mdb','sav','sql','tar','xml'];
				var imageFiles = ['ai','bmp','gif','ico','jpeg','jpg','png','ps','psd','svg','tif','tiff'];
				var netFiles = ['asp','aspx','cer','cfm','cgi','pl','css','htm','html','js','jsp','part','php','py','rss','xhtml'];
				var presentationFiles = ['key','odp','pps','ppt','pptx'];
				var spreadSheetFiles = ['ods','xlr','xls','xlsx'];
				var videoFiles = ['3g2','3gp','avi','flv','h264','m4v','mkv','mov','mp4','mpg','mpeg','rm','swf','vob','wmv'];
				var docFiles = ['doc','docx','odt']
				var textFiles = ['pdf', 'rtf', 'tex', 'txt', 'wks', 'wps', 'wpd'];
				
				var imageFile = "resources/images/generic-file-32.png";
				if(Ext.Array.contains(audioFiles,fileExtension)){
					var imageFile = "resources/images/mp3-file-32.png";
				}
				else if(Ext.Array.contains(zipFiles,fileExtension)){
					var imageFile = "resources/images/zip-file-32.png";
				}
				else if(Ext.Array.contains(databaseFiles,fileExtension)){
					var imageFile = "resources/images/xml-file-32.png";
				}
				else if(Ext.Array.contains(imageFiles,fileExtension)){
					var imageFile = "resources/images/img-file-32.png";
				}
				else if(Ext.Array.contains(netFiles,fileExtension)){
					var imageFile = "resources/images/pdf-file-32.png";
				}
				else if(Ext.Array.contains(presentationFiles,fileExtension)){
					var imageFile = "resources/images/ppt-file-32.png";
				}
				else if(Ext.Array.contains(spreadSheetFiles,fileExtension)){
					var imageFile = "resources/images/xls-file-32.png";
				}
				else if(Ext.Array.contains(videoFiles,fileExtension)){
					var imageFile = "resources/images/mp4-file-32.png";
				}
				else if(Ext.Array.contains(docFiles,fileExtension)){
					var imageFile = "resources/images/doc-file-32.png";
				}
				else if(Ext.Array.contains(textFiles,fileExtension)){
					var imageFile = "resources/images/pdf-file-32.png";
				}
				return imageFile;
			}
			else{
				return "resources/images/generic-file-32.png";
			}
		}
	},
	createNewFolder: function(btn){
		var me = this;
		var window = btn.up('window');
		var siteId = me.getEditsitestructure().siteId;
		var treepanel = me.getEditsitestructure().down('#libraryDocumentTreePanel');
		try{
			var selectedNode = treepanel.getSelectionModel().getSelection()[0];
			var workSpace = selectedNode.raw.nodeRef;
		}
		catch(e){
			var selectedNode = '';
			var workSpace = '';
		}
		var folderName = window.down('#folderNameItemId');
		var description = window.down('#folderDescriptionItemId');
		var folderTitle = window.down('#folderTitleItemId');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_CREATE_DIRECTORY,
			method: 'POST',
			jsonData : {
				folderName: folderName.getValue(),
				description: description.getValue(),
				siteId : siteId,
				folderTitle: folderTitle.getValue(),
				workSpace: workSpace
			},
			headers : {
   				'Content-Type' : 'application/json'
   			},
			success: function(response, action) {
				if(response.responseText=="success"){
					window.close();
					if(!isNullOrEmpty(selectedNode)){
						//selectedNode.fireEvent('itemclick',selectedNode);
						me.selectTreeNode(treepanel, selectedNode);
					}
				}
			}
		});
	},
	copyOrMoveDocuments: function(action){
		var me = this;
		var selectedRedords = Ext.query('.thumb-wrap-document-library input[type=checkbox]:checked');
		var filesArray = [];
		Ext.each(selectedRedords, function(currentItem){
			var currentCheckValue = currentItem.value.split("::");
			filesArray.push(currentCheckValue[2]);
		});
		var node = filesArray.join();
		if(action=="copy"){
			var title = "Copy "+selectedRedords.length+" items to...";
			var URL = SERVERURL.PATH_DOCUMENT_COPY_TO_URL;
		}
		else{
			var title = "Move "+selectedRedords.length+" items to...";
			var URL = SERVERURL.PATH_DOCUMENT_MOVE_TO_URL;
		}
		
		var formWindow = me.getDocumentcopymovewindow();
		if (!formWindow) {
			Ext.widget('documentcopymovewindow');
			formWindow = me.getDocumentcopymovewindow();
		}
		formWindow.show();
		formWindow.setTitle(title);
		formWindow.down('#fileNodesItemId').setValue(node);
		formWindow.url = URL;
	},
	startWorkFlow: function(btn){
		var me = this;
		var selectedRedords = Ext.query('.thumb-wrap-document-library input[type=checkbox]:checked');
		
		var documentLibraryDataViewStore = btn.up('documentlibrarycenterpanel').down('#documentLibraryDataViewItemId').getStore();
		
		var filesArray = [];
		Ext.each(selectedRedords, function(currentItem){
			try{
				var currentCheckValue = currentItem.value.split("::");
				var currentRecord = documentLibraryDataViewStore.findRecord('nodeRef',currentCheckValue[2]);
				filesArray.push(currentRecord.data);
			}
			catch(e){}
		});
		//var node = filesArray.join();
		
		
		if(filesArray.length){
			var editSiteStructure = me.getEditsitestructure();
			var siteId = editSiteStructure.siteId;
			var westRegion = editSiteStructure.down('[region=west]');
			var centerRegion = editSiteStructure.down('[region=center]');
			westRegion.removeAll();
			centerRegion.removeAll();
			
			westRegion.hide();
			
			centerRegion.add({
				xtype:'workflowpanel',
				config:{
					siteId: siteId,
					node: filesArray[0]
				}
			});
		}
		else{
			//-- error
		}
	},
	downloadURI: function(uri, name) {
		var link = document.createElement("a");
		link.download = name;
		link.href = uri;
		document.body.appendChild(link);
		link.click();
		document.body.removeChild(link);
		delete link;
	},
	renderDocumentWorkFlows: function(viewdocumentpanel){
		var me = this;
		var fileNodeRef = viewdocumentpanel.config.fileNodeRef;
		var currentUser = (me.getCurrentlyLoggedInUser().code=="sysadmin") ? "admin" : (me.getCurrentlyLoggedInUser().code);
		
		//-- workflow I have started (Active)
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_WORKFLOWS_I_HAVE_STARTED,
			method: 'GET',
			params: {
				node : fileNodeRef
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var dvData = [];
				Ext.each(jsonResponse, function(currentRecord){
					dvData.push({
						id: currentRecord.id,
						url: currentRecord.url,
						name: currentRecord.name,
						title: currentRecord.title,
						description: currentRecord.description,
						isActive: currentRecord.isActive,
						startDate: currentRecord.startDate,
						priority: currentRecord.priority,
						message: currentRecord.message,
						endDate: currentRecord.endDate,
						dueDate: currentRecord.dueDate,
						context: currentRecord.context,
						initiator: currentRecord.initiator.userName,
						definitionUrl: currentRecord.definitionUrl,
						isEditable: ((currentUser==currentRecord.initiator.userName)?true:false),
						owner: currentRecord.initiator.firstName+" "+currentRecord.initiator.lastName,
						status: ''
					});
				});
				
				var dv = viewdocumentpanel.down('#activeWorkflowIHaveStartedListItemId');
				var dvStore = dv.getStore();
				dvStore.removeAll();
				dvStore.add(dvData);
			}
		});
		
		//-- workflow I have started (Completed)
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_WORKFLOWS_I_HAVE_STARTED,
			method: 'GET',
			params: {
				node : fileNodeRef,
				state: 'COMPLETED'
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var dvData = [];
				Ext.each(jsonResponse, function(currentRecord){
					dvData.push({
						id: currentRecord.id,
						url: currentRecord.url,
						name: currentRecord.name,
						title: currentRecord.title,
						description: currentRecord.description,
						isActive: currentRecord.isActive,
						startDate: currentRecord.startDate,
						priority: currentRecord.priority,
						message: currentRecord.message,
						endDate: currentRecord.endDate,
						dueDate: currentRecord.dueDate,
						context: currentRecord.context,
						initiator: currentRecord.initiator.userName,
						definitionUrl: currentRecord.definitionUrl,
						isEditable: ((currentUser==currentRecord.initiator.userName)?true:false),
						owner: currentRecord.initiator.firstName+" "+currentRecord.initiator.lastName,
						status: ''
					});
				});
				
				var dv = viewdocumentpanel.down('#completedWorkflowIHaveStartedListItemId');
				var dvStore = dv.getStore();
				dvStore.removeAll();
				dvStore.add(dvData);
			}
		});
		
		//-- Active Workflows
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_WORKFLOW_BY_NODE,
			method: 'GET',
			params: {
				node : fileNodeRef,
				state: 'ACTIVE'
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var dvData = [];
				Ext.each(jsonResponse, function(currentRecord){
					dvData.push({
						id: currentRecord.id,
						url: currentRecord.workflowInstance.url,
						name: currentRecord.workflowInstance.name,
						title: currentRecord.workflowInstance.title,
						description: currentRecord.workflowInstance.description,
						isActive: currentRecord.workflowInstance.isActive,
						startDate: currentRecord.workflowInstance.startDate,
						priority: currentRecord.workflowInstance.priority,
						message: currentRecord.workflowInstance.message,
						endDate: currentRecord.workflowInstance.endDate,
						dueDate: currentRecord.workflowInstance.dueDate,
						context: currentRecord.workflowInstance.context,
						initiator: currentRecord.workflowInstance.initiator.userName,
						definitionUrl: currentRecord.workflowInstance.definitionUrl,
						isEditable: ((currentUser==currentRecord.workflowInstance.initiator.userName)?true:false),
						owner: currentRecord.owner.firstName+" "+currentRecord.owner.lastName,
						status: currentRecord.properties.bpm_status
					});
				});
				
				var dv = viewdocumentpanel.down('#workflowListItemId');
				var dvStore = dv.getStore();
				dvStore.removeAll();
				dvStore.add(dvData);
			}
		});

		//-- Completed Workflows
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_WORKFLOW_BY_NODE,
			method: 'GET',
			params: {
				node : fileNodeRef,
				state: 'COMPLETED'
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var dvData = [];
				Ext.each(jsonResponse, function(currentRecord){
					dvData.push({
						id: currentRecord.id,
						url: currentRecord.workflowInstance.url,
						name: currentRecord.workflowInstance.name,
						title: currentRecord.workflowInstance.title,
						description: currentRecord.workflowInstance.description,
						isActive: currentRecord.workflowInstance.isActive,
						startDate: currentRecord.workflowInstance.startDate,
						priority: currentRecord.workflowInstance.priority,
						message: currentRecord.workflowInstance.message,
						endDate: currentRecord.workflowInstance.endDate,
						dueDate: currentRecord.workflowInstance.dueDate,
						context: currentRecord.workflowInstance.context,
						initiator: currentRecord.workflowInstance.initiator.userName,
						definitionUrl: currentRecord.workflowInstance.definitionUrl,
						isEditable: ((currentUser==currentRecord.workflowInstance.initiator.userName)?true:false),
						owner: currentRecord.owner.firstName+" "+currentRecord.owner.lastName,
						status: currentRecord.properties.bpm_status
					});
				});
				
				var dv = viewdocumentpanel.down('#completedWorkflowListItemId');
				var dvStore = dv.getStore();
				dvStore.removeAll();
				dvStore.add(dvData);
			}
		});
	},
	renderDocumentVersions:function(viewdocumentpanel){
		var me = this;
		var filePath = viewdocumentpanel.config.filePath;
		var fileIcon = viewdocumentpanel.config.fileIcon;
		var fileName = viewdocumentpanel.config.fileName;
		var fileVersion = viewdocumentpanel.config.fileVersion;
		var fileUpdateText = viewdocumentpanel.config.fileUpdateText;
		var fileNodeRef = viewdocumentpanel.config.fileNodeRef;
		var node = viewdocumentpanel.config.node;
		
		var filePathField = viewdocumentpanel.down('#documentPathItemId');
		var fileIconField = viewdocumentpanel.down('#documentIconItemId');
		var fileNameField = viewdocumentpanel.down('#documentNameItemId');
		var fileVersionField = viewdocumentpanel.down('#documentVersionItemId');
		var fileUpdateTextField = viewdocumentpanel.down('#documentUpdateItemId');
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_GET_DOC_VERSIONS,
			method: 'GET',
			params: {
				node : fileNodeRef
			},
			success: function(response, action) {
				var jsonResponse = Ext.decode(response.responseText);
				var dvData = [];
				
				if(jsonResponse.length){
					viewdocumentpanel.config = {
							filePath: viewdocumentpanel.config.filePath,
							fileIcon: viewdocumentpanel.config.fileIcon,
							fileName: jsonResponse[0].name,
							fileVersion: jsonResponse[0].label,
							fileUpdateText: viewdocumentpanel.config.fileUpdateText,
							fileNodeRef: viewdocumentpanel.config.fileNodeRef,
							node: viewdocumentpanel.config.node
					};
				}
				
				var filePath = viewdocumentpanel.config.filePath;
				var fileIcon = viewdocumentpanel.config.fileIcon;
				var fileName = viewdocumentpanel.config.fileName;
				var fileVersion = viewdocumentpanel.config.fileVersion;
				var fileUpdateText = viewdocumentpanel.config.fileUpdateText;
				var fileNodeRef = viewdocumentpanel.config.fileNodeRef;
				var node = viewdocumentpanel.config.node;
				
				filePathField.setText(filePath);
				fileIconField.setSrc(fileIcon);
				fileNameField.setText(fileName);
				fileVersionField.setText(fileVersion);
				fileUpdateTextField.setText(fileUpdateText);
				
				Ext.each(jsonResponse, function(currentRecord){
					dvData.push({
						version: currentRecord.label,	
						fileName: currentRecord.name,
						username: currentRecord.creator.firstName + " " + currentRecord.creator.lastName,
						dateTime: getTimeDifference(currentRecord.createdDateISO),
						comment: (isNullOrEmpty(currentRecord.description)?"(No Comment)":currentRecord.description),
						nodeRef: currentRecord.nodeRef,
						isCurrentVersion: ((fileVersion==currentRecord.label)?true:false)
					});
				});
				
				var dv = viewdocumentpanel.down('#versionHistoryDataViewItemId');
				var dvStore = dv.getStore();
				dvStore.removeAll();
				dvStore.add(dvData);
			}
		});
	},
	loadIframe: function(token){
		var me = this;
		var url = CONST.DMS_URL;
		var loginUrl = url+'?tkn='+btoa(token);
		var iframe = document.createElement('iframe');
		iframe.src = loginUrl;
		iframe.height = 0;
		iframe.width = 0;
		document.body.appendChild(iframe);
		setTimeout(function(){
			window.open(url, '_blank');
			Ext.getBody().unmask();
		},2000);
	},
	getAllPendingRequests: function(){
		var me = this;
		var editSiteStructure = me.getEditsitestructure();

		var siteMembersCenterPanel = editSiteStructure.down('sitememberscenterpanel');
		var siteMembersUserListDataViewItemId = siteMembersCenterPanel.down('#siteMembersUserListDataViewItemId');
		var siteMembersUserListDataViewStore = siteMembersUserListDataViewItemId.getStore();
		var siteMembersSearchMappedUser =siteMembersCenterPanel.down('#siteMembersSearchMappedUser');

		var siteId = editSiteStructure.siteId;

		siteMembersCenterPanel.down('panel').setTitle(getDMSTranslation('MANAGE_PENDING_REQUESTS'));
		siteMembersUserListDataViewStore.removeAll();
		siteMembersUserListDataViewStore.clearFilter();
		siteMembersSearchMappedUser.setValue('');

		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_SITE_GET_PENDING_REQUESTS,
			params : {
				site : siteId
			},
			headers : {
				'Content-Type' : 'application/json'
			},
			method : 'GET',
			success : function(response) {
				var responseText = Ext.decode(response.responseText);
				var pendingUsers = [];
				Ext.each(responseText.data, function(currentRecord){
					pendingUsers.push({
						userActivityId:		currentRecord.id,
						authorityType:		'PENDING_REQUESTS',
						firstName:			currentRecord.workflowInstance.initiator.firstName,
						fullName:			currentRecord.workflowInstance.initiator.firstName + " " + currentRecord.workflowInstance.initiator.lastName,
						lastName:			currentRecord.workflowInstance.initiator.lastName,
						authorityUrl:		'',
						userName:			currentRecord.workflowInstance.initiator.userName,
						isMemberOfGroup:	false,
						role:				currentRecord.workflowInstance.startDate,
						url:				currentRecord.url,
						isEditable:			false
					});
				});
				siteMembersUserListDataViewStore.add(pendingUsers);
				editSiteStructure.down('#siteMembersBtnItemId').addCls('btnPressed');
			}
		});
	}
});
