/**
 * This controller is used for Admission Cycle setup from the admissions module.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.controller.admission.admissionCycle.AdmissionCycleController', {
    extend: 'Academia.controller.base.BaseController',
    
    models: ['Academia.model.admission.admissionCycle.ProgramGroup', 'Academia.model.admission.admissionCycle.ProgramGroupCombination',
             'Academia.model.common.LiveSearchComboModel'],
    stores: ['Academia.store.admission.admissionCycle.ProgramGroups', 'Academia.store.admission.admissionCycle.ProgramGroupCombinations',
             'Academia.store.admission.admissionCycle.SelectionProcesses', 'Academia.store.admission.admissionCycle.QuotaTypePickList',
             'Academia.store.admission.admissionCycle.QuotaSelectionStages', 'Academia.store.admission.admissionCycle.QuotaTypeApplicabilities',
             'Academia.store.admission.admissionCycle.SelectionProcessesPickList', 'Academia.store.admission.admissionCycle.DocumentGridRecords',
             'Academia.store.admission.admissionCycle.AdmissionDocumentGridRecords', 'Academia.store.admission.admissionCycle.SelectionProcessesTree',
             'Academia.store.common.LiveSearchCombos', 'Academia.store.admission.admissionCycle.MandatoryQuotas',
             'admission.admissionCycle.CopyProgramGroupCombinations','Academia.store.admission.selectionProcess.Applicabilities',
             'admission.applications.applicantservice.ApplicantChekLists','common.ProgramsByAcademyIdLocationIdAndUser',
             'common.ProgramsByAcademyIdLocationIdAndUser','Academia.store.admission.admissionCycle.StageSettingFeePlanStore','Academia.store.admission.admissionCycle.StageSettingFeePlanRuleStore',
             'Academia.store.admission.admissionCycle.StageSettingFeePlanStageStore','user.UserAcademyLocationStore','Academia.store.admission.applicationFormSale.ProgramGroupComboStore',
             'program.ProgramByGroupIdStore','Academia.store.common.BatchesByProgramId', 'Academia.store.common.SeatTypesByBatchId','program.ProgramGroupStore',
             'Academia.store.admission.admissionCycle.admissionCycleStatusStore','Academia.store.admission.admissionCycle.OfferLetterIssueProcessStore',
             'Academia.store.admission.admissionCycle.DroolBatchMappingStore','enquiry.CurrentActivityStore','importutility.ImportAdmissionSetupUpdateStore','importutility.ModuleName','Academia.store.enquiry.EligibilityRecommendationForAdmissionSetupStore'],
             
    views: ['Academia.view.admission.admissionCycle.AdmissionCycleStructure', 'Academia.view.admission.admissionCycle.AdmissionCycleSetupStructure',
            'Academia.view.admission.admissionCycle.ProgramGroupsGrid', 'Academia.view.admission.admissionCycle.ProgramGroupConfigWindow',
            'Academia.view.admission.admissionCycle.ProgramGroupCombinationsGrid', 'Academia.view.admission.admissionCycle.ConfigureCombinationPanel',
            'Academia.view.admission.admissionCycle.ConfigureCombinationStructure', 'Academia.view.admission.admissionCycle.SelectionSettingsStructure',
            'Academia.view.admission.admissionCycle.SelectionSettingsForm', 'Academia.view.admission.admissionCycle.QuotaTypeApplicabilityGrid',
            'Academia.view.admission.admissionCycle.StageSettingsStructure', 'Academia.view.admission.admissionCycle.StageSettingsForm',
            'Academia.view.admission.admissionCycle.QuotaSettingGrid', 'Academia.view.admission.admissionCycle.QuotaSettingStructure',
            'Academia.view.admission.admissionCycle.SelectionProcessGridWindow', 'Academia.view.admission.admissionCycle.QuotaTypeApplicabilityStructure',
            'Academia.view.admission.admissionCycle.ApplicationDocumentsGrid', 'Academia.view.admission.admissionCycle.ApplicationSettingStructure',
            'Academia.view.admission.admissionCycle.DocumentsWindow', 'Academia.view.common.CheckListComponent',
            'Academia.view.admission.admissionCycle.AdmissionSettingsForm', 'Academia.view.admission.admissionCycle.AdmissionSettingStructure',
            'Academia.view.admission.admissionCycle.AdmissionDocumentsGrid', 'Academia.view.admission.admissionCycle.AdmissionDocumentsWindow',
            'Academia.view.common.LiveSearchCombo', 'Academia.view.common.AcadLocProgBatchSeattypeComponent', 'Academia.view.admission.admissionCycle.MandatoryQuotaTypeGridWindow',
            'Academia.view.admission.admissionCycle.CopyProgramGroupConfigWindow','common.ApplicationCheckListGrid',
            'Academia.view.admission.admissionCycle.AdmissionCycleSetupFilter','Academia.view.admission.admissionCycle.ApplicationSettingForm',
            'Academia.view.admission.admissionCycle.AdmissionCycleSetupUpdateStructure','Academia.view.admission.admissionCycle.AdmissionCycleSetupUpdateFilter',
            'Academia.view.admission.admissionCycle.AdmissionSetupUpdatesUploadForm','Academia.view.admission.admissionCycle.AdmissionSetupUpdatesDownloadForm',
            'Academia.view.importutility.ImportAdmissionSetupUpdatesGrid','baselayout.contentarea.ContentPanel'
            ],
            requires:['Academia.constants.ServiceRequestConstants'],
    refs: [{
    	ref: 'programGroupsGrid',
    	selector: 'programgroupsgrid'
    }, {
    	ref: 'programGroupConfigWindow',
    	selector: 'programgroupconfigwindow'
    }, {
    	ref: 'copyProgramGroupConfigWindow',
    	selector: 'copyprogramgroupconfigwindow'
    },{
    	ref: 'programGroupCombinationsGrid',
    	selector: 'programgroupcombinationsgrid'
    }, {
    	ref: 'admissionCycleStructure',
    	selector: 'admissioncyclestructure'
    } , {
		ref: 'quotaTypeApplicabilityGrid',
		selector: 'quotatypeapplicabilitygrid'
	} , {
		ref: 'applicationDocumentsGrid',
		selector: 'applicationdocumentsgrid'
	}, {
		ref: 'stageSettingsForm',
		selector: 'stagesettingsform'
	}, {
		ref: 'admissionDocumentsGrid',
		selector: 'admissiondocumentsgrid'
	}, {
		ref: 'selectionSettingsForm',
		selector: 'selectionsettingsform'
	}, {
		ref: 'quotaSettingGrid',
		selector: 'quotasettinggrid'
	}, {
		ref: 'admissionsettingsform',
		selector: 'admissionsettingsform'
	},{
		ref: 'admissioncyclesetupfilter',
		selector: 'admissioncyclesetupfilter'
	},
	{
		ref: 'applicationsettingform',
		selector: 'applicationsettingform'
	},{
		ref: 'admissionsetupupdatesuploadform',
		selector: 'admissionsetupupdatesuploadform'
	},{
		ref: 'admissionsetupupdatesdownloadform',
		selector: 'admissionsetupupdatesdownloadform'
	},{
		ref: 'importadmissionsetupupdatesgrid',
		selector: 'importadmissionsetupupdatesgrid'
	},{
		ref: 'admissioncyclesetupupdate',
		selector: 'admissioncyclesetupupdate'
	},{
		ref : 'importAdmissionSetupUpdatesRadioGroup',
		selector : 'uploadoptionradiogroup[itemId=importAdmissionSetupUpdatesRadioGroupItemId]'
	},{
		ref : 'contentpanel',
		selector : 'contentpanel'
	}], 
    
    config: { 
    	/**
         * @cfg {Integer} programSelectionProcessId (required)
         * The selected programSelectionProcessId from the programGroupCombinations grid
         * of the Admission Cycle Setup part of the admissions module.
         * @accessor
         */
    	ADMISSION_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_SETUP_PRIVILEGES'),
    	ADMISSION_SETUP_UPDATE_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_SETUP_UPDATE_TAB_PRIVILEGES'),
    	programSelectionProcessId: null,
    	programBatchSeatConfigurationId: null,
    	programSelectionProcessMultipleIds:null,
    	multipleApplicationFormSettingId : null
    },
    
    init: function(application) {
    	var this$ = this;
    	this.getStore('Academia.store.admission.admissionCycle.QuotaSelectionStages').on({
    		load: function(store, records, successful) {
    			this$.markMandatoryValidation(store);
    		}
    	}),
    	
        this.control({
        	'programgroupsgrid': {
        		render: function(grid, eOpts) {
        			this.resetPageSetting(grid.getStore());
        			grid.getStore().load({
   					 scope: this,
					    callback: function(records, operation, success) {
					    	if(records)
					    		grid.getSelectionModel().select(0);
					}
				});
        			this.disableMoreActionPivileges(grid,this.getADMISSION_SETUP_PERMISSIONS());
        		},
        		select: function(rowModel, record, index) {
        			this.loadProgramGroupCombinationGrid();
        		}
        	},
        	'programgroupsgrid radiogroup#groupTypeRadio': {
        		change: function( radio, newValue, oldValue, eOpts) {
        			 this.loadProgramGrid(radio, newValue, oldValue, eOpts);
        		}
        	},
        	'programgroupsgrid button': {
        		click: function(button) {
        			if(button.itemId === 'configureGroup') {
        				this.configureProgramGroup(button);
        			}
        		}
        	},
        	'programgroupconfigwindow button#btnSaveProgramGroupConfig': {
        		click: function(button) {
        			this.saveProgramGroupConfiguration(button);
        		}
        	},
        	
        	'programgroupcombinationsgrid button': {
        		click: function(button) {
        			if(button.itemId === 'viewConfigureCombination') {
        				this.configureGroupCombinations(button);
        			}else if(button.itemId === 'copyConfigureCombination') {
        				this.showCopyConfigureCombinationWindow(button);
        			}
        		}
        	},
        	'programgroupcombinationsgrid templatecolumn#selectionProcessColumn': {
        		click: function(grid) {
        			this.showSelectionProcess(grid);
        		}
        	},
        	
        	/* 'programgroupcombinationsgrid splitbutton[itemId=btnExportToExcel] #exportExcelAll': {
 	        	click: function(button) {
 	        		this.exportExcelAll(button.up('programgroupcombinationsgrid'), false, true );
 	        	}
 	        },  */
        	'programgroupcombinationsgrid': {
        		/*cellclick: function( grid, td, cellIndex) {
        			var programGroupGrid = grid.up('grid');
        			var columnName = programGroupGrid.columnManager.columns[cellIndex].dataIndex;
        			if(columnName == 'mandatoryQuotaTypeId') {
        				this.showMandatoryQuotaTypeWindow(grid);
        			}
        		},*/
        		selectionchange: function(column, selected,eOpts ){
    				var me = this;
    				var pgcgrid  = me.getProgramGroupCombinationsGrid();
    				me.disableProgramgroupcombinationsgridButton(column,selected, pgcgrid);
                 },
        		render : function(grid){
        			this.doAccessControlValidation(grid, this.getADMISSION_SETUP_PERMISSIONS());
        			this.disableMoreActionPivileges(grid,this.getADMISSION_SETUP_PERMISSIONS());
        			var buttonsToolBar = grid.query('toolbar')[0];
    		    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    		    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    		    	pdftoolbar.setDisabled(true);
    		    	exceltoolbar.setDisabled(true);
        		}
        	},
        	
        	 'copyprogramgroupconfigwindow customcombobox[itemId=academyLocationCombo]': {
        		 change:function(obj, record){
        			 var data = record;
        			 var windowRef = this.getCopyProgramGroupConfigWindow();
        			 var formRef = windowRef.down('form');
        			 var program = formRef.down("#programIdCombo");
        			 var programGroup = formRef.down("#programGroupCombo");
        			 program.setDisabled(false);
        			 program.reset();
        			 var progStore = program.getStore();
        			 progStore.proxy.extraParams = {
        					 academyLocationId : data,
        					 programGroupId : programGroup.getValue()
					  };
        			 progStore.load();
        		 }
         	},
         	 'copyprogramgroupconfigwindow customcombobox[itemId=programGroupCombo]': {
         		change:function(obj, record){
         			var data = record;
         			var windowRef = this.getCopyProgramGroupConfigWindow();
         			var formRef = windowRef.down('form');
         			var academyLocation = formRef.down("#academyLocationCombo");
         			var program = formRef.down("#programIdCombo");
         			program.reset();
         			var progStore = program.getStore();
        			 progStore.proxy.extraParams = {
        					 academyLocationId : academyLocation.getValue(),
        					 programGroupId : data
					  };
        			 progStore.load();
         		}
         	},
                  	
         	'copyprogramgroupconfigwindow button#searchCombinations':{
				click:function(button){
					var academyLocationIdList = new Array();
					var programIdList = new Array();
					var windowRef = this.getCopyProgramGroupConfigWindow();
         			var formRef = windowRef.down('form');
         			var academyLocation = formRef.down("#academyLocationCombo");
         			var program = formRef.down("#programIdCombo");         			
         			var programGroup = formRef.down("#programGroupCombo");
         			var documentsForm = formRef.down("#documentsForm");
         			var documentsFormStore = documentsForm.getStore();
         			
         			if(academyLocation.getValue()!=null){
         				academyLocationIdList.push(academyLocation.getValue());
         			}
         			if(program.getValue()!=null){
         				programIdList.push(program.getValue());
         			}
         			documentsFormStore.proxy.extraParams = {
       					 academyLocationId : academyLocationIdList,
       					 programGroupId : programGroup.getValue(),
       					 programId : programIdList
					  };
         			documentsFormStore.load();
				}
			},
        	
			'copyprogramgroupconfigwindow button#copyConfigureMultipleCombination':{
				click:function(button){
					this.copyConfigureCombination(button);
				}
			},
			
			'configurecombinationstructure selectionsettingsstructure': {
        		activate: function(panel, eOpts) {
        			var $this = this;
        			var form=panel.down('selectionsettingsform');
        			setTimeout(function(){
        				$this.loadProgramSelectionProcess(form);
					},500);
        		}
        	},
			'configurecombinationstructure quotasettingstructure': {
//        	'quotasettingstructure quotasettinggrid': {
        		activate: function(panel, eOpts) {
        			var grid=panel.down('grid');
        			var combo = grid.down('nestedJsonCombo#quotaTypeCombo');
        			
        			
        			var store=combo.getStore();
        			var url = this.getUrlOfStore(store);
        	    	url = url.concat('?programSelectionProcessId='+this.getProgramSelectionProcessId()); 
        	    	store.getProxy().api.read = url;
        	    	
        			store.load({
    					 scope: this,
    					    callback: function(records, operation, success) {
    					    	if(records)
    					    		combo.setValue(store.getAt(0).data);
    					}
    				});

        		}
        	},
        	
        	'quotasettinggrid nestedJsonCombo#quotaTypeCombo': {
        		change: function(combo, recordId, eOpts ) {
        			//Mehtod from base controller
        			this.loadComponentStore(combo.up('grid'), 'programSelectionProcesQuotaTypeId', recordId);
        		}
        	},
        	
        	'quotasettinggrid button': {
        		click: function(button) {
        			if(button.itemId == 'saveQuotaSettingEditing') {
        				if(this.validateInputs(button)) {
        					this.saveQuotaSettingRecords(button);
        				}
        			}
        		}
        	},
        	
        	'selectionsettingsform button#saveSelectionSetting': {
        		click: function(button) {
        			this.saveSelectionSettings(button);
        		}
        	},
        	'selectionsettingsform radiogroup#whetherSelectionInBatches': {
        		change: function(combo, newValue, oldValue) {
        			var form = combo.up('form');
    				var multipleBatchDropDown = form.down('#numberOfBatchItemId');
        			if(newValue.whetherSelectionInBatches == true){
        				multipleBatchDropDown.setVisible(true);
        			}else{
        				multipleBatchDropDown.setVisible(false);
        			}
        		}
        	},
        	
        	'selectionsettingsform combo[itemId=selectionProcessCombo]': {
        		change: function(combo, newValue, oldValue) {
        			var radioComponent = combo.nextSibling(); 
        			var comboStore = combo.getStore();
        			comboStore.load({
        				callback: function(records, operation, success) {
			    			   for(var i=0; i< comboStore.data.items.length;i++){
			    				   if(comboStore.data.items[i].data.id == combo.value && comboStore.data.items[i].data.code == "GRADETYPE"){
			    					   radioComponent.setValue({'whetherSelectionInBatches' :false});
			    					   radioComponent.items.items[1].disabled=true;
			    				   } 
			    				   else if(comboStore.data.items[i].data.id == combo.value && comboStore.data.items[i].data.code != "GRADETYPE"){
			    					   radioComponent.items.items[1].disabled=false;
			    				   }
			    			   }
							}
   				});
        		}
        	},
        	/* ********** Application setting tab listeners **********/
        	
        	'configurecombinationstructure applicationsettingstructure': {
        		activate: function(panel) {
        			var form = panel.down('applicationsettingform');
        			this.loadApplicationSettings(form);
        			
        			var grid=panel.down('applicationdocumentsgrid');
        			this.loadDocumentsGrid(grid, 'APPLICATION');
        			this.doAccessControlValidation(grid, this.getADMISSION_SETUP_PERMISSIONS());
        			var serviceRequestConstant = Academia.constants.ServiceRequestConstants;
        			var transactionTypeId = serviceRequestConstant.getRequestStatus('APPLICATION_CHECKLIST_CONSTANT');
        			var grid =panel.down('applicationchecklistgrid');
        			var store=grid.getStore();
        			this.resetPageSetting(store);
        			store.getProxy().extraParams={
        				transactionTypeId :transactionTypeId,
    					progBatchConfigId :this.getProgramBatchSeatConfigurationId()
    				};
        			store.load();
        		}
        	},
        	'applicationsettingstructure applicationdocumentsgrid button': {
        		click: function(button) {
        			if(button.itemId === 'btnAdd') {
        				this.onDocumentAdd(button, 'APPLICATION');
        			}else if(button.itemId === 'btnEdit') {
        				this.onDocumentEdit(button, false, 'APPLICATION');
        			}else if(button.itemId === 'btnView') {
        				this.onDocumentView(button, 'APPLICATION');
        			}else if(button.itemId === 'btnDelete') {
        				this.onAdmissionSetupDocumentDelete(button, 'APPLICATION');
        			}
        		}
        	},
        	'applicationdocumentswindow button#btnSaveDocuments': {
        		click: function(button) {
        			this.saveDocument(button, 'APPLICATION');
        		}
        	},
        	
        	/* ********** Admission setting tab listeners **********/
        	'admissionsettingstructure admissiondocumentsgrid button': {
        		click: function(button) {
        			if(button.itemId === 'btnAdd') {
        				this.onDocumentAdd(button, 'ADMISSION');
        			}else if(button.itemId === 'btnEdit') {
        				this.onDocumentEdit(button, false, 'ADMISSION');
        			}else if(button.itemId === 'btnView') {
        				this.onDocumentView(button, 'ADMISSION');
        			}else if(button.itemId === 'btnDelete') {
        				this.onAdmissionSetupDocumentDelete(button, 'ADMISSION');
        			}
        		}
        	},
        	'admissiondocumentswindow button#btnSaveDocuments': {
        		click: function(button) {
        			this.saveDocument(button, 'ADMISSION');
        		}
        	},
        	
			'selectionprocessgridwindow treepanel':{
        		render: function(grid, eOpts) {
        			var selectedRecord = this.getProgramGroupCombinationsGrid().getSelectionModel().getSelection()[0];
        	    	var id = selectedRecord.get('id');
        			var treeStore = grid.getStore();
        			treeStore.getProxy().api.read = SERVERURL.PSP_STAGES_FIND_BY_PROGRAM_SELECTION_PROCESS+'?programSelectionProcess='+id,
        	        treeStore.load();
        		}
    		},
        	/* ***************** ******************/
        	
        	'configurecombinationstructure quotatypeapplicabilitystructure': {
        		activate: function(panel) {
        			var grid = panel.down('gridpanel[xtype=quotatypeapplicabilitygrid]');
        			//Mehtod from base controller
        			this.loadComponentStore(grid, 'programSelectionProcessId', this.getProgramSelectionProcessId());
        		}
        	},
        	
        	'quotatypeapplicabilitygrid button#btnSaveQuotaType': {
        		click: function(button) {
					this.saveQuotaTypeChanges(button);
				}
        	},
        	        	
        	'configurecombinationstructure stagesettingsstructure': {
        		activate: function(panel) {
        			panel.getForm().reset();
        			var combo = panel.down('combo#programSelectionProcessStageCombo');
        			var store=combo.getStore();
        			var url = this.getUrlOfStore(store);
        	    	url = url.concat('?programSelectionProcessId='+this.getProgramSelectionProcessId()); 
        	    	store.getProxy().api.read = url;
        			store.load({
    					 scope: this,
    					    callback: function(records, operation, success) {
    					    	if(records)
    					    		combo.setValue(store.getAt(0).data);
    					}
    				});
        			this.loadDrool(panel);
        		}
        	
        	},
        	
        	'stagesettingsform combo[itemId=programSelectionProcessStageCombo]': {
        		change: function( combo, recordId, eOpts ) {
        		   	if(!isNullOrEmpty(recordId)) {
        		   		this.loadStageData(combo, recordId);
        		   	}
        		}
        	},
        	'stagesettingsform nestedJsonCombo[itemId=admissionFeePlan]': {
        		select:function(obj,rec){
        			var data=obj.getValue();  
        			var formValue=obj.up('form');
        			var admissionFeePlanRule=formValue.down('#admissionFeePlanRule');
        			admissionFeePlanRule.setDisabled(false);
        			admissionFeePlanRule.reset();
        			admissionFeePlanRule.getStore().getProxy().extraParams={
        				feePlanId:data
        			};
        			admissionFeePlanRule.getStore().load();
        			
        			this.checkFeePlanStatus(data);


        		}
        	},
        	'stagesettingsform nestedJsonCombo[itemId=admissionFeePlanRule]': {
        		select:function(obj,rec){
        			var data=obj.getValue();  
        			var formValue=obj.up('form');
        			var admissionStageFeePlan=formValue.down('#admissionStageFeePlan');
        			admissionStageFeePlan.setDisabled(false);
        			admissionStageFeePlan.reset();
        			admissionStageFeePlan.getStore().getProxy().extraParams={
        				feePlanRuleId:data
        			};
        			admissionStageFeePlan.getStore().load();
        			
        			this.checkFeePlanRuleStatus(data);
        		}
        	},
        	'stagesettingsform nestedJsonCombo[itemId=admissionStageFeePlan]': {
        		select:function(obj,rec){
        			var feePlanRuleStageId=obj.getValue();  
        			var formValue=obj.up('form');
        			var admissionAmountToPaid=formValue.down('#admissionAmountToPaid');
        			 Ext.Ajax.request({
              		   type : 'rest',
              		   url : SERVERURL.FIND_STAGESETTING_FEEPLAN_RULESTAGE_AMOUNT,
              		   params : {
              			 feePlanRuleStageId : feePlanRuleStageId,
              		   },
              		   method : 'GET',
              		   success : function(frm, action) {
              			 admissionAmountToPaid.setValue(frm.responseText)
              		   }
              	   });
        		}
        	},
        	
        	/* ***************** ******************/
        	

        	'configurecombinationstructure admissionsettingstructure': {
        		activate: function(panel) {
        			
        			var form = panel.down('admissionsettingsform');
        			this.loadAdmissionSettings(form);
        			
        			var grid = panel.down('admissiondocumentsgrid');
        			this.loadDocumentsGrid(grid, 'ADMISSION');
        			this.doAccessControlValidation(grid, this.getADMISSION_SETUP_PERMISSIONS());
        			
        			var serviceRequestConstant = Academia.constants.ServiceRequestConstants;
        			var transactionTypeId = serviceRequestConstant.getRequestStatus('ADMISSION_CHECKLIST_CONSTANT');
        			var grid =panel.down('applicationchecklistgrid');
        			grid.getStore().load({
        				params:{
        					transactionTypeId :transactionTypeId,
        					progBatchConfigId :this.getProgramBatchSeatConfigurationId()
        				}
        			});
        			var admissionsettingsform = this.getAdmissionsettingsform();
              		var admissionOfferStartDate = admissionsettingsform.down('#admissionOfferStartDate');
              		var admissionOfferEndDate = admissionsettingsform.down('#admissionOfferEndDate');
              		var offerLetterExpiryDate =admissionsettingsform.down('#offerLetterExpiryDate');
              		var offerLetterIssueProcess = admissionsettingsform.down('#offerLetterIssueProcess');
              		var admissionProOfferStartDate = admissionsettingsform.down('#proAdmissionOfferStartDate');
              		var admissionProOfferEndDate = admissionsettingsform.down('#proAdmissionOfferEndDate');
              		var proOfferLetterExpiryDate =admissionsettingsform.down('#proOfferLetterExpiryDate');
              		var proOfferLetterIssueProcess = admissionsettingsform.down('#proOfferLetterIssueProcess');
              		var applicationRejectDateAsOn =admissionsettingsform.down('#applicationRejectDateAsOn');
       				offerLetterIssueProcess.allowBlank=true;
          			admissionOfferStartDate.allowBlank=true;
          			admissionOfferEndDate.allowBlank=true;
          			admissionProOfferStartDate.allowBlank=true;
          			admissionProOfferEndDate.allowBlank=true;
          			proOfferLetterIssueProcess.allowBlank=true;
          			var autoAdmissionApprovalCheckbox = admissionsettingsform.down('#whetherAutoAdmissionApproval');
        	        var checkForEligibilityCheckbox = admissionsettingsform.down('#checkForEligibilityBeforeApproveAdmissionAutomatically');
        	        var eligibilityRecommendation = admissionsettingsform.down('#eligibilityRecommendation');
        	        this.loadDFRForAutoAdmissionApprove(autoAdmissionApprovalCheckbox,checkForEligibilityCheckbox);
        	        this.loadDFRForEligibilityBeforeApproveAdmissionAutomatically(checkForEligibilityCheckbox,eligibilityRecommendation);
        		}
        	},
        	'admissionsettingsform checkboxfield[itemId=whetherAutoAdmissionApproval]': {
        	    change: function(checkbox, newValue, oldValue) {
        	        var admissionsettingsform = this.getAdmissionsettingsform();
        	        var autoAdmissionApprovalCheckbox = admissionsettingsform.down('#whetherAutoAdmissionApproval');
        	        var checkForEligibilityCheckbox = admissionsettingsform.down('#checkForEligibilityBeforeApproveAdmissionAutomatically');
        	        this.loadDFRForAutoAdmissionApprove(autoAdmissionApprovalCheckbox,checkForEligibilityCheckbox);
        	    }
        	},
        	'admissionsettingsform checkboxfield[itemId=checkForEligibilityBeforeApproveAdmissionAutomatically]':{
        		change:function(value,newValue,oldValue){
        			var admissionsettingsform = this.getAdmissionsettingsform();
        			var checkForEligibilityBeforeApproveAdmissionAutomatically = admissionsettingsform.down('#checkForEligibilityBeforeApproveAdmissionAutomatically');
              		var eligibilityRecommendation = admissionsettingsform.down('#eligibilityRecommendation');
              		
              		if(newValue){
              			eligibilityRecommendation.reset();
              			eligibilityRecommendation.setDisabled(false);
              			eligibilityRecommendation.allowBlank=false;
              			this.loadDFRForEligibilityBeforeApproveAdmissionAutomatically(checkForEligibilityBeforeApproveAdmissionAutomatically,eligibilityRecommendation);
              		}
              		else{
              			eligibilityRecommendation.reset();
              			eligibilityRecommendation.setVisible(false);
              			eligibilityRecommendation.allowBlank=true;
              			eligibilityRecommendation.setDisabled(false);
              		}
              		admissionsettingsform.getForm().isValid();
        		}
        	},
        	'admissionsettingsform checkboxfield[itemId=whetherTrialAdmissionAllowed]':{
        		change:function(value,newValue,oldValue){
        			var admissionsettingsform = this.getAdmissionsettingsform();
        			var saveAdmissionSetting = admissionsettingsform.down('#saveAdmissionSetting');
        				if(admissionsettingsform.isValid()){
        					saveAdmissionSetting.setDisabled(false);
        				}
        		}
        	},
        	'admissionsettingsform button': {
        		click: function(button) {
        			var $this = this;
        			if(button.itemId === 'offerLetterBtn') {
        				var contentpanel = $this.getContentpanel();
        				var tabName = getMegaMenuTranslation('STP_DOCUMENT_TEMPLATE_MAPPING');
        				var documenttemplatemappingview=Ext.widget("documenttemplatemappingview");
        				var newTab = $this.getTabReferenceByTabTitle(tabName);
        				var getcontroller=$this.getController('menu.CoreERPNavigationController');
        				var getTab=getcontroller.getTab(tabName);
        				if(getTab!=null){
        					contentpanel.remove(getTab, true);
        				}
        				openTab(contentPanel, tabName, documenttemplatemappingview, CONSTANTS.MENU_COLOR_TWO);
        				contentPanel.setActiveTab(newTab);  
        			}
        		}
        	},
        	'admissionsettingsform checkboxfield[itemId=allowProvisionalAdmission]':{
        		change:function(value,newValue,oldValue){
        			var admissionsettingsform = this.getAdmissionsettingsform();
        			var saveAdmissionSetting = admissionsettingsform.down('#saveAdmissionSetting');
        				if(admissionsettingsform.isValid()){
        					saveAdmissionSetting.setDisabled(false);
        				}
        		}
        	},
   		'admissionsettingsform checkboxfield[itemId=whetherOfferLetterApplicable]':{
    		change:function(value,newValue,oldValue){
          		var admissionsettingsform = this.getAdmissionsettingsform();
          		var whetherOfferLetterApplicable = admissionsettingsform.down('#whetherOfferLetterApplicable');
          		var admissionOfferStartDate = admissionsettingsform.down('#admissionOfferStartDate');
          		var mappingOfferletter = admissionsettingsform.down('#offerLetterBtn');
          		var admissionOfferEndDate = admissionsettingsform.down('#admissionOfferEndDate');
          		var offerLetterIssueProcess = admissionsettingsform.down('#offerLetterIssueProcess');
          		var offerLetterAcceptMaxDays = admissionsettingsform.down('#offerLetterAcceptDaysLimit');
          		var offerLetterExpiryDate = admissionsettingsform.down('#offerLetterExpiryDate');
          		//var offerLetterHoldMaxDays = admissionsettingsform.down('#maxDaysToHoldOfferLetter');
          		var proOfferLetterApplicable = admissionsettingsform.down('#whetherProvisionalOfferApplicable');
          		var admissionProOfferStartDate = admissionsettingsform.down('#proAdmissionOfferStartDate');
          		var admissionProOfferEndDate = admissionsettingsform.down('#proAdmissionOfferEndDate');
          		var proOfferLetterIssueProcess = admissionsettingsform.down('#proOfferLetterIssueProcess');
          		var proOfferLetterAcceptMaxDays = admissionsettingsform.down('#proOfferLetterAcceptDaysLimit');
          		//var proOfferLetterHoldMaxDays = admissionsettingsform.down('#maxDaysToHoldProOfferLetter');
          		var proOfferLetterExpiryDate = admissionsettingsform.down('#proOfferLetterExpiryDate');
          		var additionalConditionApplicable = admissionsettingsform.down('#additionalConditionApplicableItemId');
          		var currentActivityItemId = admissionsettingsform.down('#currentActivityItemId');
          		var saveAdmissionSetting = admissionsettingsform.down('#saveAdmissionSetting');
          		var whetherEnableAutoOfferletterExpiry = admissionsettingsform.down('#whetherEnableAutoOfferletterExpiry');
          		var offerLetterIssuancePotential = admissionsettingsform.down('#offerLetterIssuancePotential');
				
          		if(newValue){
          			
          			admissionOfferStartDate.setVisible(true);
          			mappingOfferletter.setVisible(true);
          			admissionOfferEndDate.setVisible(true);
          			offerLetterIssueProcess.setVisible(true);
          			offerLetterAcceptMaxDays.setVisible(true);
          			whetherEnableAutoOfferletterExpiry.setVisible(true);
          			offerLetterIssuancePotential.setVisible(true);
//          			offerLetterExpiryDate.setVisible(true);
          			this.loadDFRForOfferLetterExpiryDateDFR(offerLetterExpiryDate);
//          			offerLetterHoldMaxDays.setVisible(true);
          			proOfferLetterApplicable.setVisible(true);
          			this.loadDFRForOfferLetterIssuancePetentialDFR(offerLetterIssuancePotential);
          			additionalConditionApplicable.setVisible(true);
          			offerLetterIssueProcess.allowBlank=false;
          			admissionOfferStartDate.allowBlank=false;
          			admissionOfferEndDate.allowBlank=false;
          			
          			if(proOfferLetterApplicable.value){
          				admissionProOfferStartDate.setVisible(true);
          				mappingOfferletter.setVisible(true);
              			admissionProOfferEndDate.setVisible(true);
              			proOfferLetterIssueProcess.setVisible(true);
              			proOfferLetterAcceptMaxDays.setVisible(true);
//              			proOfferLetterExpiryDate.setVisible(true);
//              			additionalConditionApplicable.setVisible(true);
              			this.loadDFRForAdmissionSettingFormDFR(additionalConditionApplicable,proOfferLetterExpiryDate);
              			//proOfferLetterHoldMaxDays.setVisible(true);    
              			
              			admissionProOfferStartDate.allowBlank=false;
              			admissionProOfferEndDate.allowBlank=false;
              			proOfferLetterIssueProcess.allowBlank=false;
          			}
          			else if(!proOfferLetterApplicable.value){
          				admissionProOfferStartDate.setVisible(false);
              			admissionProOfferEndDate.setVisible(false);
              			proOfferLetterIssueProcess.setVisible(false);
              			proOfferLetterAcceptMaxDays.setVisible(false);
              			proOfferLetterExpiryDate.setVisible(false);
              			
              			//proOfferLetterHoldMaxDays.setVisible(false); 	
              			additionalConditionApplicable.setVisible(false);
              			additionalConditionApplicable.setValue({whetherAdditionalConditionApplicable : false});
              			admissionProOfferStartDate.allowBlank=true;
              			admissionProOfferEndDate.allowBlank=true;
              			proOfferLetterIssueProcess.allowBlank=true;
          			}
          		}
          		else{
          			proOfferLetterApplicable.getEl().setStyle('marginTop','0px');
          			
          			admissionOfferStartDate.setVisible(false);
          			mappingOfferletter.setVisible(false);
          			admissionOfferEndDate.setVisible(false);
          			offerLetterIssueProcess.setVisible(false);
          			offerLetterAcceptMaxDays.setVisible(false);
          			offerLetterExpiryDate.setVisible(false);
          			offerLetterIssuancePotential.setVisible(false);
          			whetherEnableAutoOfferletterExpiry.setVisible(false);
//          			offerLetterHoldMaxDays.setVisible(false);
          			proOfferLetterApplicable.setVisible(false);
          			admissionProOfferStartDate.setVisible(false);
          			admissionProOfferEndDate.setVisible(false);
          			proOfferLetterIssueProcess.setVisible(false);
          			proOfferLetterAcceptMaxDays.setVisible(false);
          			//proOfferLetterHoldMaxDays.setVisible(false);
          			proOfferLetterExpiryDate.setVisible(false);
          			additionalConditionApplicable.setVisible(false);
          			additionalConditionApplicable.setValue(false)
          			additionalConditionApplicable.setValue({whetherAdditionalConditionApplicable : false});
          			offerLetterIssueProcess.allowBlank=true;
          			admissionOfferStartDate.allowBlank=true;
          			admissionOfferEndDate.allowBlank=true;
          			admissionProOfferStartDate.allowBlank=true;
          			admissionProOfferEndDate.allowBlank=true;
          			proOfferLetterIssueProcess.allowBlank=true;
          			offerLetterIssuancePotential.reset();
          		}
          		if(admissionsettingsform.isValid()){
					saveAdmissionSetting.setDisabled(false);
				}else{
					saveAdmissionSetting.setDisabled(true);
				}
    		}
    	},
    	'admissionsettingsform checkboxfield[itemId=whetherProvisionalOfferApplicable]':{
    		change:function(value,newValue,oldValue){
    			var admissionsettingsform = this.getAdmissionsettingsform();
    			var admissionProOfferStartDate = admissionsettingsform.down('#proAdmissionOfferStartDate');
          		var admissionProOfferEndDate = admissionsettingsform.down('#proAdmissionOfferEndDate');
          		var proOfferLetterIssueProcess = admissionsettingsform.down('#proOfferLetterIssueProcess');
          		var proOfferLetterAcceptMaxDays = admissionsettingsform.down('#proOfferLetterAcceptDaysLimit');
          		var proOfferLetterExpiryDate = admissionsettingsform.down('#proOfferLetterExpiryDate');
          		var additionalConditionApplicable = admissionsettingsform.down('#additionalConditionApplicableItemId');
          		var currentActivityItemId = admissionsettingsform.down('#currentActivityItemId');
          		//var proOfferLetterHoldMaxDays = admissionsettingsform.down('#maxDaysToHoldProOfferLetter');
          		
          		if(newValue){
          			admissionProOfferStartDate.setVisible(true);
          			admissionProOfferEndDate.setVisible(true);
          			proOfferLetterIssueProcess.setVisible(true);
          			proOfferLetterAcceptMaxDays.setVisible(true);
//          			proOfferLetterExpiryDate.setVisible(true);
//          			additionalConditionApplicable.setVisible(true);
//          			proOfferLetterHoldMaxDays.setVisible(true);
          			this.loadDFRForAdmissionSettingFormDFR(additionalConditionApplicable,proOfferLetterExpiryDate);
          			admissionProOfferStartDate.allowBlank=false;
          			admissionProOfferEndDate.allowBlank=false;
          			proOfferLetterIssueProcess.allowBlank=false;
          		}
          		else{
          			admissionProOfferStartDate.setVisible(false);
          			admissionProOfferEndDate.setVisible(false);
          			proOfferLetterIssueProcess.setVisible(false);
          			proOfferLetterAcceptMaxDays.setVisible(false);
          			proOfferLetterExpiryDate.setVisible(false);
          			additionalConditionApplicable.setVisible(false);
          			additionalConditionApplicable.setValue({whetherAdditionalConditionApplicable : false});
//          			proOfferLetterHoldMaxDays.setVisible(false);
          			
          			admissionProOfferStartDate.allowBlank=true;
          			admissionProOfferEndDate.allowBlank=true;
          			proOfferLetterIssueProcess.allowBlank=true;
          		}
          		//admissionsettingsform.getForm().isValid();
    		}
    	},
        	'admissionsettingsform datefield#admissionProcessStartDate ':{
        		change:function(value,newValue,oldValue){
              		var window = this.getAdmissionsettingsform();
              		var admissionProcessStartDate = window.down('#admissionProcessStartDate');
              		var referenceLetterSubmissionDeadline = window.down('#referenceLetterSubmissionDeadline');
              		referenceLetterSubmissionDeadline.setMinValue(new Date(admissionProcessStartDate.value));
              		if(referenceLetterSubmissionDeadline.value<admissionProcessStartDate.value && referenceLetterSubmissionDeadline.value!=null) {
              			referenceLetterSubmissionDeadline.reset();
              		}
        		}
        	},
        	'admissionsettingsform datefield#lastDateForAdmission ':{
        		change:function(value,newValue,oldValue){
              		var window = this.getAdmissionsettingsform();
              		var lastDateForAdmission = window.down('#lastDateForAdmission');
              		var referenceLetterSubmissionDeadline = window.down('#referenceLetterSubmissionDeadline');
              		referenceLetterSubmissionDeadline.setMaxValue(new Date(lastDateForAdmission.value));
              		if(referenceLetterSubmissionDeadline.value>lastDateForAdmission.value && referenceLetterSubmissionDeadline.value!=null) {
              			referenceLetterSubmissionDeadline.reset();
              		}
              		var applicationRejectDateAsOn = window.down('#applicationRejectDateAsOn');
              		applicationRejectDateAsOn.setMinValue(Ext.Date.add(new Date(lastDateForAdmission.value),Ext.Date.DAY, 1));
              		if(applicationRejectDateAsOn.rawValue == lastDateForAdmission.rawValue && applicationRejectDateAsOn.value!=null) {
              			applicationRejectDateAsOn.reset();
              		}
        		}
        	},
        	'admissionsettingsform datefield#proAdmissionOfferEndDate ':{
        		change:function(value,newValue,oldValue){
              		var window = this.getAdmissionsettingsform();
              		var proOfferLetterExpiryDate = window.down('#proOfferLetterExpiryDate');
              	   var proAdmissionOfferEndDate = window.down('#proAdmissionOfferEndDate');
              		proOfferLetterExpiryDate.setMinValue(new Date(proAdmissionOfferEndDate.value));
        		}
        	},
        	'admissionsettingsform radiogroup#additionalConditionApplicableItemId ':{
        		change:function(value,newValue,oldValue){
              		var window = this.getAdmissionsettingsform();
              		var currentActivityItemId = window.down('#currentActivityItemId');
              		if(newValue.whetherAdditionalConditionApplicable == true){
              			currentActivityItemId.setVisible(true);
              			currentActivityItemId.allowBlank = false;
              			currentActivityItemId.setFieldLabel(getAdmissionTranslation('CURRENT_ACTIVITY')+'<span class="required" style="color:red"> *</span>');
        			}else{
        				currentActivityItemId.setVisible(false);
        				currentActivityItemId.allowBlank = true;
        				currentActivityItemId.setFieldLabel(getAdmissionTranslation('CURRENT_ACTIVITY'));
        			}
              		window.getForm().checkValidity();
              	  // var proAdmissionOfferEndDate = window.down('#proAdmissionOfferEndDate');
              		//proOfferLetterExpiryDate.setMinValue(new Date(proAdmissionOfferEndDate.value));
        		}
        	},
        	'admissionsettingsform datefield#admissionOfferEndDate ':{
        		change:function(value,newValue,oldValue){
              		var window = this.getAdmissionsettingsform();
              		var offerLetterExpiryDate = window.down('#offerLetterExpiryDate');
              		var admissionOfferEndDate = window.down('#admissionOfferEndDate');
              		offerLetterExpiryDate.setMinValue(new Date(admissionOfferEndDate.value));
        		}
        	},
        	
        	'applicationsettingstructure applicationsettingform filefield[itemId=documentId]':{
            	change: function(fileField, value, eOpts){
            		var $this = this;
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	fileField.setRawValue(newValue);
                	if (!isNullOrEmpty(newValue)) {
                	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                	    if ($this.isValidFileExtension(extension)) {
                	        var file = fileField.fileInputEl.dom.files[0];
                	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                	            fileField.reset();
                	            showWarningMessage(getPersonModuleTranslation('APPLICATION_FORM_SETTINGS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                	        }
                	    } else {
                	        fileField.reset();
                	        showWarningMessage(getPersonModuleTranslation('APPLICATION_FORM_SETTINGS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                	    }
                	}
                }
            },
        	
        	'stagesettingsform button[itemId=btnSaveSelectionProcess]': {
        		click: function(button) {
        			this.saveStageSettings(button);
        		}
        	},
        	
        	'applicationsettingstructure checklistcomponent button#btnAddDocumentsToCheckList': {
        		click: function(button) {
        			this.saveCheckListItems(button, 'APPLICATION');
        		}
        	},
        	'admissionsettingstructure checklistcomponent button#btnAddDocumentsToCheckList': {
        		click: function(button) {
        			this.saveCheckListItems(button, 'ADMISSION');
        		}
        	},
        	'admissionsettingstructure admissionsettingsform button#saveAdmissionSetting': {
        		click: function (button) {
					this.saveAdmissionSetting(button);
				}
        	},
        	'applicationsettingstructure applicationsettingform button#saveApplicationSetting': {
        		click: function (button) {
					this.saveApplicationSetting(button);
				}
        	},
        	
        	/**
        	 * Listener of the filter button which filters the result from the program group combinations grid.
        	 */
        	'admissioncyclestructure button#filterButton': {
        		click: function(button) {
        			this.loadProgramGroupCombinationGrid(button);
				}
        	},
        	'admissioncyclestructure button#resetButton': {
        		click: function(button) {
        			
        			button.up('#admissioncyclesetup').down('acadlocprogbatchseattypecomponent').reset();
				}
        	},
        	
        	/**
        	 * listener for the Activate of the stage Setting tab after the "Program Group combination" record is configured,
        	 * 
        	 */
        	'stagesettingsstructure': {
        		activate: function(panel) {
        			this.doStageSettingValidations(panel);
        		}
        	},
            'stagesettingsform checkboxfield[itemId=isFeePlanApplicable]':{
           	 change:function(value,newValue,oldValue){
           		 var window = this.getStageSettingsForm();
           		 var admissionFeePlan = window.down('#admissionFeePlan');
           		 var admissionFeePlanRule = window.down('#admissionFeePlanRule');
           		 var admissionStageFeePlan = window.down('#admissionStageFeePlan');
           		 var admissionAmountToPaid = window.down('#admissionAmountToPaid');
           		 var allowSystemByPass = window.down('#allowSystemByPass');
//           		 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
           		//admissionFeePlan.labelSeparator = '';
           		 if(newValue){
           			admissionFeePlan.allowBlank=false;
//           			admissionFeePlan.setFieldLabel(getAdmissionTranslation('ADMISSION_FEE_PLAN')+allowblankFalse);
           			admissionFeePlan.setVisible(true);
           			admissionFeePlanRule.setVisible(true);
           			admissionFeePlanRule.allowBlank=false;
//           			admissionFeePlanRule.setFieldLabel(getAdmissionTranslation('ADMISSION_FEE_PLAN_RULE')+allowblankFalse);
           			admissionStageFeePlan.setVisible(true);
           			admissionStageFeePlan.allowBlank=false;
//           			admissionStageFeePlan.setFieldLabel(getAdmissionTranslation('ADMISSION_STAGE_FEE_PLAN')+allowblankFalse);
           			admissionAmountToPaid.setVisible(true);
           			admissionAmountToPaid.allowBlank=false;
//           			admissionAmountToPaid.setFieldLabel(getAdmissionTranslation('ADMISSION_AMOUNT_TO_PAID')+allowblankFalse);
           			allowSystemByPass.setVisible(true);
           			var form=this.getSelectionSettingsForm();
           			var programBatchSeatConfiguration = null;
           			
           			if(form.getValues().programBatchSeatConfiguration!=null){
           				programBatchSeatConfiguration = form.getValues().programBatchSeatConfiguration;
           				var programBatchSeatConfigurationArray = programBatchSeatConfiguration.split(',');
               			admissionFeePlan.getStore().getProxy().extraParams={
               				progBatchSeatConfigId:programBatchSeatConfigurationArray[0]
            			};
           			}
           		
           			admissionFeePlan.getStore().load();
           			 //documentField.setFieldLabel(getFeeAndPaymentCommonTranslation('DOCUMENT')+allowblankFalse);
           		 }else{
           			admissionFeePlan.allowBlank=true; 
           			
           			admissionFeePlan.reset();
           			admissionFeePlan.allowBlank=true;
           			admissionFeePlan.setVisible(false);
           			admissionFeePlanRule.reset();
           			admissionFeePlanRule.allowBlank=true;
           			admissionFeePlanRule.setDisabled(true);
           			admissionFeePlanRule.setVisible(false);
           			admissionStageFeePlan.reset();
           			admissionStageFeePlan.allowBlank=true;
           			admissionStageFeePlan.setDisabled(true);
           			admissionStageFeePlan.setVisible(false);
           			admissionAmountToPaid.allowBlank=true;
           			admissionAmountToPaid.reset();
           			admissionAmountToPaid.setVisible(false);
           			allowSystemByPass.setVisible(false);
           			allowSystemByPass.reset();
           			
           		 }
           		window.getForm().isValid();
           	 }
            },
            'applicationdocumentswindow nestedJsonCombo[itemId=documentTypeCombo]': {
            	render: function(combo) {
        			var store = combo.getStore();
        			store.getProxy().extraParams = {
        				isApplicableForStudent: true
        			 };
        			 store.load();
        		}
        	},
        	'admissiondocumentswindow nestedJsonCombo[itemId=documentTypeCombo]': {
            	render: function(combo) {
        			var store = combo.getStore();
        			store.getProxy().extraParams = {
        				isApplicableForStudent: true
        			 };
        			 store.load();
        		}
        	},
        	 'admissioncyclesetupfilter customcombobox[itemId=academyLocationCombo]': {
                 select: function(combo, record) {
             		var appForm = combo.up('form');
             		var programCombo = appForm.down('#program');
             		programCombo.reset();
             		this.disableFilters(combo);
             		var acadLocId = record[0].get('id');
             		var store = programCombo.getStore();
             		store.getProxy().extraParams = {
             			academyLocationId: acadLocId
             		};
             		store.load();
                 }
             },
             'admissioncyclesetupfilter customcombobox[itemId=Program_Group]': {
                 select: function(combo, record) {
             		var appForm = combo.up('form');
             		var acadLocId = appForm.down('#academyLocationCombo').getValue();
             		var programCombo = appForm.down('#program');
             		this.disableFilters(combo);
             		var programGroupId = record[0].get('id');
             		programCombo.reset();
             		var store = programCombo.getStore();
             		store.getProxy().extraParams = {
             			academyLocationId: acadLocId,
             			programGroupId:programGroupId
             		};
             		store.load();
                 }
             },
             'admissioncyclesetupfilter customcombobox[itemId=program]': {
                 select: function(combo, record) {
             		var appForm = combo.up('form');
             		var batchCombo = appForm.down('#batch');
             		var seatTypeCombo = appForm.down('#seatType');
             		var intakeYearItemId = appForm.down('#intakeYearItemId').getValue();
             		seatTypeCombo.reset();
             		seatTypeCombo.setDisabled(true);
             		batchCombo.setDisabled(false);
             		batchCombo.reset();
             		var programId = record[0].get('id');
             		var store = batchCombo.getStore();
             		store.getProxy().extraParams = {
             			id: programId,
             			intakeYearId:intakeYearItemId
             		};
             		store.load();
                 }
             },
             'admissioncyclesetupfilter customcombobox[itemId=batch]': {
                 select: function(combo, record) {
             		var appForm = combo.up('form');
             		var seatTypeCombo = appForm.down('#seatType');
             		seatTypeCombo.setDisabled(false);
             		seatTypeCombo.reset();
             		var batchId = record[0].get('id');
             		var store = seatTypeCombo.getStore();
             		store.getProxy().extraParams = {
             			batchId: batchId
             		};
             		store.load();
                 }
             },
             'admissioncyclesetupfilter button[itemId=quickSearchId]': {
            	 click: function(button) {
            		 var grid =  this.getProgramGroupCombinationsGrid();
            		 grid.getSelectionModel().deselectAll();
            		 this.loadProgramGroupCombinationGrid(grid);
            		 this.setProgramSelectionProcessId(null);  
            		 this.setProgramSelectionProcessMultipleIds(null);
            		 var contentPanel = this.getActiveTabfromContentPanel();
            		 var tabPanel = contentPanel.down('tabpanel');
            		 var items = tabPanel.items.items;
            		 var numberOfTab = items.length;
            		 if (numberOfTab > 1) {
            			 Ext.each(items, function(tab) {
            				 if (tab.xtype == 'configurecombinationstructure') {
            					 tabPanel.remove(tab);
            				 }
            			 });
            		 }
            	 }
             },
             'admissioncyclesetupfilter button[itemId=resetBtn]': {
            	 click: function(button) {
            		 var form = this.getAdmissioncyclesetupfilter();
            		 var endDate = form.down('#END_DATE');
            		 var startDate = form.down('#START_DATE');
            		 var batch = form.down('#batch');
            		 var seatType = form.down('#seatType');
            		 var programCombo = form.down('#program');
            		 var store = programCombo.getStore();
            		 store.getProxy().extraParams = {};
            		 endDate.setMaxValue(null);
            		 endDate.setMinValue(null);
            		 startDate.setMaxValue(null);
            		 startDate.setMinValue(null);
            		 batch.setDisabled(true);
            		 seatType.setDisabled(true);
            		 form.getForm().reset();
            		 programCombo.getStore().load();
                 }
             },
             'admissioncyclestructure':{
            	 afterrender:function(structure){
            		 var $this = this;
            		 structure.body.on('scroll', function(e, target) {
    					 var pcstructure = $this.getProgramGroupCombinationsGrid();
    					 if(pcstructure!=null){
    						 $this.getMultipleGridHeaderFreeze(pcstructure,structure,true); 
    					 }
    				 });
            		 var associatedAcadLocationIds = new Array();
            		 associatedAcadLocationIds.push($this.getCurrentAcademyLocation()); 
            		 var admissionSetupUpdatePermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getADMISSION_SETUP_UPDATE_TAB_PERMISSIONS());
            		 var admissionSetupUpdateTab =structure.down('tabpanel');
            		 Ext.each(admissionSetupUpdatePermissionList,function(privilege) {
            			 if (privilege == 'VIEW') {
            				 var tabName = getAdmissionTranslation('ADMISSION_SETUP_UPDATE');
            				 var contentXtype ='admissioncyclesetupupdate';
            				 var newTab = $this.getTabReferenceByTabTitle(tabName);
            				 if(!newTab){
            					 newTab = admissionSetupUpdateTab.add({
            						 xtype: contentXtype,
            						 title: tabName,
            						 menuColorCls: CONSTANTS.MENU_COLOR_FIVE
            					 });
            				 }
            			 } 
            		 });
            		
            	 }
             },
             'stagesettingsform':{
            	 render: function(form){
     				var $this = this;
     				form.body.on('click', function() {
     	    			$this.hideInvalidIconFromField(form);
     	    	       });
     			}
             },
             'admissionsettingsform':{
            	 render: function(form){
     				var $this = this;
     				form.body.on('click', function() {
     	    			$this.hideInvalidIconFromField(form);
     	    	       });
     			},
     			afterrender:function(form){
     				var $this = this;
     			   	var field = true;
     				var applicationRejectDateAsOn = form.down('#applicationRejectDateAsOn');
     				Ext.Ajax.request({
     		   	   		type: 'rest',
     		   	   		async: false,
     		   	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
     		   	   		params: {
     		   	   			screenName: 'admissionsettingsform',
     		   	   			academyLocationId: this.getCurrentAcademyLocation(),
     		   	   			languageCode:'en'
     		   	   		},
     		   	   		method: 'GET',
     		   	   		success: function(res, action) {
     		   	   			var response = Ext.decode(res.responseText);
     		   	   			if( Object.keys(response).length > 0 ){
     		   	   				var records=response.admissionsettingsform;
     		   	   				for(i in records){
     		   	   			if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='applicationRejectDateAsOn' && records[i].isVisible==false){
     			   				 field = false;
     			   				applicationRejectDateAsOn.setVisible(field);
     			   					}
     		   	   			if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='applicationRejectDateAsOn' && records[i].isMandatory == true){
     		   	   				applicationRejectDateAsOn.allowBlank = false;
     		   	   				applicationRejectDateAsOn.labelSeparator = '';
     		   	   				applicationRejectDateAsOn.setFieldLabel(getAdmissionTranslation('APPLICATION_REJECT_DATE_AS_ON')+':<span class="required" style="color:red"> *</span>');
     								}
     		   	   				}
     		   	   			}
     		   	   			applicationRejectDateAsOn.setVisible(field);
     		   	   		}
     		   	   		
     		   	   	});
     			}
             },
             'applicationsettingform':{
            	 render: function(form){
      				var $this = this;
      				form.body.on('click', function() {
      	    			$this.hideInvalidIconFromField(form);
      	    	       });
      			}
             },
             'admissiondocumentswindow':{
            	 render: function(window){
       				var $this = this;
       				window.body.on('click', function() {
       					var form = window.down('form');
       	    			$this.hideInvalidIconFromField(form);
       	    	       });
       			}
             },
             'admissionsetupupdatesuploadform button[itemId=resetBtn]': {
    	 		    click: function(obj) {
    	 		    	var $this=this;
    	 				var admissionsetupupdatesuploadeform = $this.getAdmissionsetupupdatesuploadform().getForm();
    	 				//admissionsetupupdatesuploadeform.reset();
    	 				$this.getAdmissionsetupupdatesuploadform().down('#uploadFileField').reset();
    	 				$this.getAdmissionsetupupdatesuploadform().down('#uploadFileField').allowBlank=false;
    	 				admissionsetupupdatesuploadeform.isValid();
    	 		    }
    	 	},
             'admissionsetupupdatesdownloadform button[itemId=resetBtn]': {
   	 		    click: function(obj) {
   	 		    	var $this=this;
   	 				var admissionsetupupdatesdownloadform = $this.getAdmissionsetupupdatesdownloadform().getForm();
   	 				admissionsetupupdatesdownloadform.reset();
   	 			    $this.getAdmissionsetupupdatesdownloadform().down('#academyLocationCombo').allowBlank=false;
   	 			    admissionsetupupdatesdownloadform.isValid();
   	 		    }
   	 		},
	   	 	'admissionsetupupdatesdownloadform':{
		 		afterrender: function(form){
	     			var $this = this;
	     	        var downloadTemplateAdmisisonSetupUpdatesForm = $this.getAdmissionsetupupdatesdownloadform();
	     	        var uploadTemplateAdmissionSetupUpdatesForm = $this.getAdmissionsetupupdatesuploadform();
	     	           var grid = $this.getImportadmissionsetupupdatesgrid();
	     	           uploadTemplateAdmissionSetupUpdatesForm.hide();
    	        	   uploadTemplateAdmissionSetupUpdatesForm.down('#moduleName').allowBlank=true;
    	        	   uploadTemplateAdmissionSetupUpdatesForm.down('#uploadFileField').allowBlank=true;
    	        	   downloadTemplateAdmisisonSetupUpdatesForm.down('#academyLocationCombo').allowBlank=false;
    	        	   downloadTemplateAdmisisonSetupUpdatesForm.show();
    	               grid.setVisible(false);
    	               downloadTemplateAdmisisonSetupUpdatesForm.isValid();
    	               downloadTemplateAdmisisonSetupUpdatesForm.getForm().reset();
	 			}
	        },
   	 		'admissionsetupupdatesdownloadform button[itemId=downloadAdmissionSetupUpdateFormItemId]': {
   	 			click:function(obj){
	        			var $this = this;
	        			var form =$this.getAdmissionsetupupdatesdownloadform();
	        			  var valid = form.isValid();      				
	           				if(valid) {
	           					form.down('#downloadAdmissionSetupUpdateFormItemId').setDisabled(false);
	             	            } 
	        			var formValues = form.getFormValues();
	        			if(isNullOrEmpty(formValues.academyLocationCombo)){
	        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ACADEMY_LOCATION'));
	        				} else{
	   	        			var values = this.getAdmissionSetupDownloadLoaderJson(formValues);

	   	        			var csvForm = Ext.create('Ext.form.Panel',{
	   	        	    		items:[{
	   	        	    			xtype : 'textfield',
	   	        	    			maxLength : 20480,
	   	        	    			itemId : 'exportListDTO',
	   	        	    			name : 'exportListDTO',
	   	        	    			vtype : 'spaceAsInput'
	   	        	    		}]
	   	        	    	});
	   	        			
	   	        			csvForm.down('#exportListDTO').setValue(values);
	   	        			csvForm.getForm().submit({
	   		  	        		  target: '_blank',
	   		  	        		  method:'POST',
	   		  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
	   		  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	   		  	        		  url: SERVERURL.DOWNLOAD_TEMPLATE_ADMISSION_SETUP_UPDATE,
	   		  	        		  standardSubmit :true,
	   		  	        		  success : function(form, action){
	 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	    	          },
	 	    	        		  failure: function(form, action) {
	 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	    	          }
	   		  	        	  });
	   	        		}
	        		}
   	 		},
             'admissioncyclesetupupdate radiogroup[itemId=importAdmissionSetupUpdatesRadioGroupItemId]': {
   	 		    change: this.downloadUploadFormChangeImportAdmissionSetupUpdates
   	 		},
	   	 	'admissionsetupupdatesdownloadform customcombobox[itemId=academyLocationCombo]': {
	            select: function(combo, record) {
	        		var appForm = combo.up('form');
	        		var programCombo = appForm.down('#program');
	        		programCombo.reset();
	        		this.disableFilters(combo);
	        		var acadLocId = record[0].get('id');
	        		var store = programCombo.getStore();
	        		store.getProxy().extraParams = {
	        			academyLocationId: acadLocId
	        		};
	        		store.load();
	            }
	        },
	        'admissionsetupupdatesdownloadform customcombobox[itemId=Program_Group]': {
	            select: function(combo, record) {
	        		var appForm = combo.up('form');
	        		var acadLocId = appForm.down('#academyLocationCombo').getValue();
	        		var programCombo = appForm.down('#program');
	        		this.disableFilters(combo);
	        		var programGroupId = record[0].get('id');
	        		programCombo.reset();
	        		var store = programCombo.getStore();
	        		store.getProxy().extraParams = {
	        			academyLocationId: acadLocId,
	        			programGroupId:programGroupId
	        		};
	        		store.load();
	            }
	        },
	        'admissionsetupupdatesdownloadform customcombobox[itemId=program]': {
	            select: function(combo, record) {
	        		var appForm = combo.up('form');
	        		var batchCombo = appForm.down('#batch');
	        		var seatTypeCombo = appForm.down('#seatType');
	        		var intakeYearItemId = appForm.down('#intakeYearItemId').getValue();
	        		seatTypeCombo.reset();
	        		seatTypeCombo.setDisabled(true);
	        		batchCombo.setDisabled(false);
	        		batchCombo.reset();
	        		var programId = record[0].get('id');
	        		var store = batchCombo.getStore();
	        		store.getProxy().extraParams = {
	        			id: programId,
	        			intakeYearId:intakeYearItemId
	        		};
	        		store.load();
	            }
	        },
	        'admissionsetupupdatesdownloadform customcombobox[itemId=batch]': {
	            select: function(combo, record) {
	        		var appForm = combo.up('form');
	        		var seatTypeCombo = appForm.down('#seatType');
	        		seatTypeCombo.setDisabled(false);
	        		seatTypeCombo.reset();
	        		var batchId = record[0].get('id');
	        		var store = seatTypeCombo.getStore();
	        		store.getProxy().extraParams = {
	        			batchId: batchId
	        		};
	        		store.load();
	            }
	        },
	        'admissionsetupupdatesdownloadform button[itemId=resetBtn]': {
	       	 click: function(button) {
	       		 var form = this.getAdmissionsetupupdatesdownloadform();
	       		 var endDate = form.down('#END_DATE');
	       		 var startDate = form.down('#START_DATE');
	       		 var batch = form.down('#batch');
	       		 var seatType = form.down('#seatType');
	       		 var programCombo = form.down('#program');
	       		 var store = programCombo.getStore();
	       		 store.getProxy().extraParams = {};
	       		 endDate.setMaxValue(null);
	       		 endDate.setMinValue(null);
	       		 startDate.setMaxValue(null);
	       		 startDate.setMinValue(null);
	       		 batch.setDisabled(true);
	       		 seatType.setDisabled(true);
	       		 form.getForm().reset();
	       		 programCombo.getStore().load();
	            }
	        },
  	 		'importadmissionsetupupdatesgrid button[itemId=btnRefresh]': {
            	click: function(){
            		var $this=this;
            		var grid = $this.getImportadmissionsetupupdatesgrid();
                	var store = grid.getStore()
                	store.getProxy().extraParams = {
                		moduleName:'IMPORT_BULK_ADMISSION_SETUP_UPDATE'
                	};
                	store.load();
            	}
            },
            'admissionsetupupdatesuploadform': {
  	 		    render: function(obj) {
  	 		        var $this = this;
  	 		        var importWin = $this.getAdmissionsetupupdatesuploadform()
  	 		        var moduleName = importWin.down('#moduleName');
  	 		        moduleName.getStore().load({
  	 		            callback: function(records, operation, success) {
  	 		                for (var i in records) {
  	 		                    if (records[i].data.value == "Bulk Admission Setup Update") {
  	 		                        moduleName.setValue(records[i].data.id);
  	 		                        moduleName.setReadOnly(true)
  	 		                    }
  	 		                }
  	 		            }
  	 		        });
  	 		    }
  	 		},
            'admissionsetupupdatesuploadform button[itemId=uploadAdmissionSetupUpdateFormItemId]': {
  	 		    click: function(obj) {
  	 		        var $this = this;
  	 		        var grdStore;
  	 		        var form = $this.getAdmissionsetupupdatesuploadform();
  	 		        if(form.getForm().isValid()){
  	 		         submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
			        	setTimeout(function() {
   	 		        form.getForm().submit({
   	 		            method: 'POST',
   	 		            url: submitUrl,
   	 		            success: function(form, action) {
   	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
   	 		            },
   	 		            failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
   	 		            }
   	 		        });
			        	},1000);
   	 		        Ext.defer(function() {
   	 		            var grid = $this.getImportadmissionsetupupdatesgrid();
   	 		            var form = $this.getImportAdmissionSetupUpdatesRadioGroup();
   	 		            var isUploadAll = form.items.items[0].getValue().isUploadAll;
   	 		            $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ADMISSION_SETUP_UPDATE');
   	 		        }, 2000, this);	
  	 		        }
  	 		    }
  	 		},
  	 	   'admissionsetupupdatesuploadform uploadoptionradiogroup[itemId=importAdmissionSetupUpdatesRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
  	 			change: function( radioGroup, newValue, oldValue, eOpts){
  	 				var grid =this.getImportadmissionsetupupdatesgrid();
  	 				var form =this.getImportAdmissionSetupUpdatesRadioGroup();
  	 				var isUploadAll = newValue.isUploadAll;
  	 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ADMISSION_SETUP_UPDATE');
  	 			}   
  	 		},
  	 		'importadmissionsetupupdatesgrid': {
  	 		    render: function(obj) {
  	 		        var $this = this;
  	 		        var grid = $this.getImportadmissionsetupupdatesgrid();
  	 		        var form = $this.getImportAdmissionSetupUpdatesRadioGroup();
  	 		        var isUploadAll = form.items.items[0].getValue().isUploadAll;
  	 		        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ADMISSION_SETUP_UPDATE');
  	 		    },
  	 		    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
  	 		        if (e.target.tagName == 'A') {
  	 		            var fileType = null;
  	 		            if (cellIndex == 1) {
  	 		                fileType = 'successFile';
  	 		            } else if (cellIndex == 6) {
  	 		                fileType = 'errorFile';
  	 		            } else if (cellIndex == 7) {
  	 		                fileType = 'logFile';
  	 		            }
  	 		            var documentId = record.get("id");
  	 		            if (!isNullOrEmpty(documentId)) {
  	 		                this.getDownloadFileAdmissionSetup(documentId, fileType);
  	 		            }
  	 		        }
  	 		    }
  	 		},
  	 		'importadmissionsetupupdatesgrid button[itemId=btnForce]': {
  	 		    click: function(obj) {
  	 		        var grid = this.getImportadmissionsetupupdatesgrid();
  	 		        if (grid.getSelectionModel().getCount() > 0) {
  	 		            if (grid.getSelectionModel().getCount() > 1) {
  	 		                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
  	 		            } else {
  	 		                var this$ = this;
  	 		                var id = grid.getSelectionModel().selectionStart.data.id;
  	 		                console.log(id);
  	 		                var urlAppend = "?jobName=" + id;
  	 		                var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
  	 		                Ext.Ajax.request({
  	 		                    url: submitURL,
  	 		                    method: 'GET',
  	 		                    success: function(response) {
  	 		                        if (response.responseText === "JOB_STATUS_NOT_PENDING") {
  	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
  	 		                        } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
  	 		                            //console.log("Manual trigger hit");
  	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
  	 		                        } else if (response.responseText === "SUCCESS") {
  	 		                            //console.log("Manual trigger hit");
  	 		                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
  	 		                            grid.getStore().reload();
  	 		                        }
  	 		                    }
  	 		                });
  	 		            }
  	 		        } else {
  	 		            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
  	 		        }
  	 		    }
  	 		}
        });
    },
    /*
     * 	********************** Program Group Grid Methods ********************* 
     */
    /**
     * Method to load the program grid according to the Group Type radio selection
     * @param {Object} the reference of the radio Button That is selected.
     * @param {Object} the newValue is the currently selected value
     * @param {Object} the oldValue is the previously selected value.
     * @author Akshay.Kalbhor
     */
    loadProgramGrid: function(radio, newValue, oldValue, eOpts) {
    	var grid = radio.up('grid');
    	var store = grid.getStore();
    	var url;
    	if(newValue.wetherConfigured) {
    		url = SERVERURL.ADMISSION_SETUP_PROGRAM_GROUPS_GRID_GET;
    	} else {
    		url = SERVERURL.ADMISSION_SETUP_PROGRAM_GROUPS_GRID_UNCONFIG;	
    	}
    	store.getProxy().api.read = url;
    	
    	grid.down('pagingtoolbar').moveFirst();
    	//Code for clearing the CombinationsGrids data
    	this.getProgramGroupCombinationsGrid().getStore().removeAll();
    },
    
    /**
     * Method to show the program Configuration Window on click of the "Configure Group"
     * button present in the program configuration window.
     * @param {Object} The reference of the button clicked from the grid.
     * @author Akshay.Kalbhor
     */
    configureProgramGroup: function(button) {
    	var grid = button.up('grid');
    	if(grid.getSelectionModel().getCount()>0) {
    		var selectedRecord = grid.getSelectionModel().getSelection()[0];
    		if(!isNullOrEmpty(selectedRecord.data.appFormEndDate))
               	selectedRecord.data.appFormEndDate = new Date(selectedRecord.data.appFormEndDate);
    		if(!isNullOrEmpty(selectedRecord.data.appFormStartDate))
               	selectedRecord.data.appFormStartDate = new Date(selectedRecord.data.appFormStartDate);
    		if(!isNullOrEmpty(selectedRecord.data.appFormSubmitEndDate))
               	selectedRecord.data.appFormSubmitEndDate = new Date(selectedRecord.data.appFormSubmitEndDate);
    		if(!isNullOrEmpty(selectedRecord.data.appFormSubmitStartDate))
               	selectedRecord.data.appFormSubmitStartDate = new Date(selectedRecord.data.appFormSubmitStartDate);
    		selectedRecord.data.onlineSubmissionAllowed = selectedRecord.raw.onlineSubmissionAllowed;
    		var windowRef = this.getProgramGroupConfigWindow();
    		if (!windowRef) {
    			windowRef = this.showWindow('programgroupconfigwindow');
            }
    		var formRef = windowRef.down('form');
    		formRef.loadRecord(selectedRecord);
    		formRef.down('checkboxfield#onlineSalePermitted').setValue(selectedRecord.raw.onlineSalePermitted);
    		formRef.down('checkboxfield#onlineSubmissionAllowed').setValue(selectedRecord.raw.onlineSubmissionAllowed);
    		formRef.down('field#programGroupHiddenField').setValue(Ext.encode(selectedRecord.get('programGroup')));
    	} else {
        	showWarningMessage(getAdmissionTranslation('PROGRAM_GROUPS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * Method to save the program group configuration.
     * @param {Object} The reference of the button clicked from the form.
     * @author Akshay.Kalbhor
     */
    saveProgramGroupConfiguration: function(button) {
    	var form = button.up('form');
    	if(this.validateProgramGroupConfigurationForm(form)){
	    	var formWindow = button.up('window');
	    	var this$ = this;
	    	var formMethod = null;
	    	var formValues = form.getValues();
	    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
	    		formMethod = 'PUT';
	    	} else {
	    		formMethod = 'POST';
	    	}
	    	//TODO: Confirm/Remove the deleted fields after implementation
	    	delete formValues.template;
	    	delete formValues.photo;
	
	    	if(formValues.onlineSalePermitted == undefined) {
	    		formValues.onlineSalePermitted = false;
	    	};
	    	if(formValues.onlineSubmissionAllowed == undefined) {
	    		formValues.onlineSubmissionAllowed = false;
	    	};
	    	
	    	formValues.programGroup = Ext.decode(formValues.programGroup);
	    	this$.applyWindowMask(); 
	    	  
	    	 Ext.Ajax.request({
	             type: 'rest',
	             url: SERVERURL.ADMISSION_SETUP_PROGRAM_GROUPS_ADD_EDIT_DELETE,
	             jsonData: formValues,
	             method: formMethod,
	             success: function() {
	            	 this$.closeFormWindow(formWindow);
	            	 var grid = this$.getProgramGroupsGrid();
	            	 grid.getStore().load();
	            	 Ext.getBody().unmask();
	            	 grid.getSelectionModel().deselectAll(true);
	                 showSuccessMessage(getAdmissionTranslation('PROGRAM_GROUPS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
	             }
	         });
 		
    	}
    },
    validateProgramGroupConfigurationForm: function(form){
    	var appFormSubmitEndDate=form.down('datefield#appFormSubmitEndDate').getValue();
    	var appFormEndDate=form.down('datefield#appFormEndDate').getValue();
    	var appFormSaleStartDate=form.down('datefield#appFormStartDate').getValue();
    	var appFormSubmissionStartDate=form.down('datefield#appFormSubmitStartDate').getValue();
    	if(appFormSubmitEndDate<appFormEndDate){
    		showWarningMessage( getAdmissionTranslation('PROGRAM_GROUP_CONFIG'), getAdmissionTranslation('SUBMISSION_DATE_LESS_THAN_SALE_DATE_ERROR'));
    		return false;
    	}else if(appFormSubmissionStartDate<appFormSaleStartDate)  {
    		showWarningMessage( getAdmissionTranslation('PROGRAM_GROUP_CONFIG'), getAdmissionTranslation('SUBMISSION_START_DATE_LESS_THAN_SALE_START_DATE_ERROR'));
    		return false;
    	}else{
    		return true;
    	}
        	
    },
    
    /*  ********************* ProgramGroupCombinationsGrid methods ****************    */
    /**
     * Method to load the program grid according to the Configured/NotConfigured radio selection
     * @param {Object} the reference of the radio Button That is selected.
     * @param {Object} the newValue is the currently selected value
     * @param {Object} the oldValue is the previously selected value.
     * @author Akshay.Kalbhor
     */
    loadProgramGroupCombinationGrid: function(grid) {
    	var $this = this;
    	var filter = $this.getAdmissioncyclesetupfilter();
    	 var buttonsToolBar = grid.query('toolbar')[0];
	     var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	     var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	var academyLocationId = filter.down('#academyLocationCombo').getValue();
    	var intakeYearId = filter.down('#intakeYearItemId').getValue();
    	var programGroupId = filter.down('#Program_Group').getValue();
    	var programId = filter.down('#program').getValue();
    	var endDate = filter.down('#END_DATE').getValue();
    	var startDate = filter.down('#START_DATE').getValue();
    	var batchId = filter.down('#batch').getValue();
    	var seatTypeId = filter.down('#seatType').getValue();
    	var admissionCycleStatus = filter.down('#admissionCycleStatus').getValue();
    	var notConfiureCombination = filter.down('#notConfiureCombination').getValue();
    	filter.down('#quickSearchId').setDisabled(true);
    	var criteria = this.createGridCriteria(academyLocationId, intakeYearId, programId, batchId, seatTypeId, programGroupId, endDate, startDate, admissionCycleStatus, notConfiureCombination);
    	var store= grid.getStore();

    	if(!isNullOrEmpty(notConfiureCombination) && notConfiureCombination == true) {
    		store.getProxy().api.read = SERVERURL.ADM_SET_PROGRAM_GRP_COMBINATIONS_GRID_UNCONFIG;
    	} else {
    		store.getProxy().api.read = SERVERURL.ADM_SET_PROGRAM_GRP_COMBINATIONS_GRID_CONFIG;
    	}
    	store.getProxy().extraParams=criteria;
    	grid.down('pagingtoolbar').moveFirst();
    	store.load({
    		callback: function(records, operation, success) {
    			filter.down('#quickSearchId').setDisabled(false);
    			if(records.length>0){
    				pdftoolbar.setDisabled(false);
				    exceltoolbar.setDisabled(false);
				} else {
					pdftoolbar.setDisabled(true);
				    exceltoolbar.setDisabled(true);
				}
			}
    	});
    	grid.config.searchFilterForm = $this.getAdmissioncyclesetupfilter();
    },
    
    /**
     * method to create the grid criteria for loading the grid using a criteria object and a post request.
     * @param {Number} academyId is the id of the selected academy.
     * @param {Number} locationId is the id of the selected location.
     * @param {Number} programId is the id of the selected program.
     * @param {Number} batchId is the id of the selected batch.
     * @param {Number} seatTypeId is the id of the selected seatType.
     * @param {Number} programGroupId is the id of the selected programGroup.
     * @param {Boolean} whetherAdmissionOpen is the boolean value if the admission is open or no.
     * @author Akshay.Kalbhor
     * 
     */
    createGridCriteria:function(academyLocationId, intakeYearId, programId, batchId, seatTypeId, programGroupId, endDate, startDate, admissionCycleStatus, notConfiureCombination) {
    	/*
		 * Criteria should be of the form of WSProgSlctnProcessSearchCriteria
		 */
    	var criteria = new Object();
    	criteria.academyLocationId =this.addValueInArray(criteria.academyLocationId,academyLocationId);
    	criteria.intakeYearId =intakeYearId;
    	criteria.programId =this.addValueInArray(criteria.programId,programId);
    	criteria.batchId = this.addValueInArray(criteria.batchId,batchId);
    	criteria.programGroupId =programGroupId;
    	criteria.seatTypeId = this.addValueInArray(criteria.seatTypeId,seatTypeId);
    	criteria.endDate =endDate;
    	criteria.startDate =startDate;
    	criteria.admissionCycleStatus =admissionCycleStatus;
    	criteria.notConfiureCombination =notConfiureCombination;
        return criteria;
	},
	
	addValueInArray:function(array,value){
		if(!isNullOrEmpty(value)) {
			if(!array)
				array=new Array();
			array.push(value);
    	}
		return array;
	},
    
    /**
     * opens the configure combination tab for the record selected in the programGroupCombinations grid.
     * @param {Object} the reference of the clicked Button (view/Configure button of the programGroupCombination grid).
     */
	configureGroupCombinations: function(button) {
		var grid = button.up('grid');
		
		if(grid.getSelectionModel().getCount()>0) {
			var programIdArray = new Array();
			var batchIdArray = new Array();
			var contentPanel = this.getActiveTabfromContentPanel();
			var tabPanel = contentPanel.down('tabpanel');
			var items = tabPanel.items.items;
			var numberOfTab = items.length;
			if (numberOfTab > 1) {
				Ext.each(items, function(tab) {
					if (tab.xtype == 'configurecombinationstructure') {
						tabPanel.remove(tab);
					}
				});
			}
			var tabReference = this.addTab(getAdmissionTranslation('CONFIGURE_ADMISSION_PROCESS'), 'configurecombinationstructure');
			for(var i=0;i<grid.getSelectionModel().getCount();i++){
				var selectedRecord = grid.getSelectionModel().getSelection()[i];
				var id = selectedRecord.get('id');
				this.setProgramSelectionProcessId(id);
				var programId = selectedRecord.get('programBatchSeatConfiguration').programBatchSeatConfigurationId;
				programIdArray.push(programId);
				batchIdArray.push(selectedRecord.data.programBatchSeatConfiguration.batch.id);
				this.setProgramBatchSeatConfigurationId(programId);
				tabReference.getActiveTab().loadRecord(selectedRecord);
				tabReference.getActiveTab().getForm().setValues({'programBatchSeatConfiguration':programIdArray});
				var formRef = tabReference.getActiveTab().down('form');
				/*Code to set the selection mechanism radio values.*/
				var radioComponent = formRef.query('radiogroup#whetherSelectionInBatches')[0];
				radioComponent.setValue({'whetherSelectionInBatches' :selectedRecord.get('whetherSelectionInBatches')});

				/*
				 * code to disable tabs except the first tab.
				 * will be disabled only if we are configuring a new record(id=null).
				 */
				if(isNullOrEmpty(id)) {
					this.toggleTabsVisibility(tabReference, true);
				} else {
					this.toggleTabsVisibility(tabReference, false);	
				}

			}
			
			this.getAdmissionCycleStructure().down('#batchId').setValue(batchIdArray);
			
		} else {
			showWarningMessage(getAdmissionTranslation('CONFIGURE_COMBINATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}},
    
    /**
    * Method for server call for copy configuration.
    * @param {Object} the reference of the button.	
    */
    showCopyConfigureCombinationWindow: function(button) {
    	var grid = button.up('grid');
    	var ProgramBatchSeatConfigIdArray = new Array();
    	
    	if(grid.getSelectionModel().getCount()>0) {
    		var formWindow=this.showWindow('copyprogramgroupconfigwindow');
    		var destinationProgramBatchSeatConfigId = formWindow.down('#destinationProgramBatchSeatConfigId');
    		
    		var criteria = new Object();
        	criteria.academyLocationId=null;
        	criteria.programGroupId=null;
        	criteria.programId=null;
    		var store= formWindow.down('grid').getStore();
    		store.load({
    			params:criteria	
    		});
    		
    		for(var record=0;record<grid.getSelectionModel().getCount();record++){
    			
    		var selectedRecord = grid.getSelectionModel().getSelection()[record];
    		var programBatchSeatConfigurationId = selectedRecord.get('programBatchSeatConfiguration').programBatchSeatConfigurationId;    		
			button.up('admissioncyclesetup').down('admissioncyclesetupfilter');
    		    	
    		ProgramBatchSeatConfigIdArray.push(programBatchSeatConfigurationId);
        	    		
    	} 
    		destinationProgramBatchSeatConfigId.setValue(ProgramBatchSeatConfigIdArray);
    	}else {
    		showWarningMessage(getAdmissionTranslation('CONFIGURE_COMBINATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
   /**
     * Method for showing the popup of the selection process on the click of the selection process cell.
     * @param {Object} the reference of the grid.
     */
    copyConfigureCombination: function(button) {
    	var this$=this;
    	var formWindow = this$.getCopyProgramGroupConfigWindow();
		var grid = formWindow.down('grid');
    	
    	if(grid.getSelectionModel().getCount()>0) {
    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		var selectedRecord = grid.getSelectionModel().getSelection()[0];
    		var programSelectionProcessId = selectedRecord.get('id');
    		var destinationProgramBatchSeatConfigId=formWindow.down('#destinationProgramBatchSeatConfigId').getValue();
    		
	    		var url=SERVERURL.ADM_SETUP_COPY_CONFIGURATION;	
	    		url = url.concat('?sourceProgramSelectionProcessId='+programSelectionProcessId);
	    		url = url.concat('&destinationProgramBatchSeatConfigId='+destinationProgramBatchSeatConfigId);
	    		this.sendSaveAjaxRequest(url,'GET',null, function(opt,success,response){
	    		  	if(success){
	    	           	this$.closeFormWindow(formWindow);
	    	           	var programGroupCombinationsGrid =  this$.getProgramGroupCombinationsGrid();
	    	    		programGroupCombinationsGrid.getSelectionModel().deselectAll();
	    	    		this$.loadProgramGroupCombinationGrid(programGroupCombinationsGrid);
	    	    		Ext.getBody().unmask();
		                showSuccessMessage(getAdmissionTranslation('CONFIGURE_COMBINATION'), getAdmissionTranslation('COPY_CONFIGURE_SUCCESS'));
	    		  	}
	    	  		}); 
    		
    		
    	} else {
	    		showWarningMessage(getAdmissionTranslation('CONFIGURE_COMBINATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method for showing the popup of the selection process on the click of the selection process cell.
     * @param {Object} the reference of the grid.
     */
    showSelectionProcess: function(grid) {
    	/*var radio = grid.up('grid').down('#groupCombinationRadio').getValue();
    	if(radio.wetherGCConfigured === true){
			this.showWindow('selectionprocessgridwindow');
    	}*/
    },
    
    /**
     * Method to show the popup of the mandatory quota type on click of the link of the selection
     * process grid cell of the column MANDATORY QUOTA
     */
    showMandatoryQuotaTypeWindow: function(grid) {
		var selectedRecord = grid.getSelectionModel().getSelection()[0];
		var id = selectedRecord.get('mandatoryQuotaTypeId');
		if(!isNullOrEmpty(id)) {
			var windowReference = this.showWindow('mandatoryquotatypegridwindow');
	    	var mandatoryQuotaTypeGrid = windowReference.down('grid');
	    	var url = mandatoryQuotaTypeGrid.getStore().getProxy().proxyConfig.api.read;
			url = url.concat(id+'/quota');
			mandatoryQuotaTypeGrid.getStore().getProxy().api.read = url;
			mandatoryQuotaTypeGrid.getStore().reload();
		}
    },
    
    /*
     * 	********************** Quota Setting tab -> Quota setting grid Methods ********************* 
     */  
    /**
     * method for validating the modifications done in the Quota Setting Grid.
     * checks if the minimum number of seats in the quota record is not exceeding the maximum permissible
     * number of seats.
     * 
     * returns true if the value is valid (seats are less than max seats)
     * returns false if the value entered is invalid (seats are greater than the total seats)
     * @param {Object} button: reference of the clicked button.
     */
    validateInputs: function(button) {
    	var this$=this;
    	var grid = button.up('grid');
    	var store = grid.getStore();
    	var returnValue = true;
    	
    	var qtCombo = grid.down('combo');
    	//Check if the total of the marks is 100 if the distribution basis is percentage
    	if(qtCombo.valueModels[0].get('distributionBasis') === "PERCENTAGE") {
    		returnValue = this.validateTotal(store);
    		//END- Check if the total of the marks is 100 if the distribution basis is percentage
    	}else{
    		Ext.each(store, function(record) {
    			var items = record.data.items;
    			Ext.each(items, function(item) {
	    			if(!this$.validateMinMax(item)){
	        			returnValue = false;
	        			return false;
	    			}
    			});
        	});
    	}
    	return returnValue;
    },
    
    validateMinMax: function(record){
    	var returnValue = true;
    	if(record.get('minSeat') > record.get('maxSeat')) {
    		showErrorMessage(getAdmissionTranslation('QUOTA_SETTING'), getErrorTranslation('MIN_MAX_ERROR'));
			returnValue = false;
		};
		return returnValue;
    },
    
    /**
     * method to validate the total of the minseats and max seats is of a particular stage across the Quotas should be less
     * or equal to 100 if the distribution basis is Percentage.
     * @param {Object} store is the reference of the grids store whose records have to be iterated.
     * @returns {Boolean} returnValue which is the boolean value: true specifies the values are valid
     * false specifies the values are invalid.
     * @author Akshay.Kalbhor 
     */
    validateTotal: function(store) {
    	var this$=this;
    	var minMap = new Ext.util.HashMap();
    	var maxMap = new Ext.util.HashMap();
    	var returnValue = true;
    	Ext.each(store, function(record) {
    		var items = record.data.items;
    		var stageId = null;
    		var minTotal = null;
    		var maxTotal = null;
    		Ext.each(items, function(item) {
	    		stageId = item.get('programSelectionProcessStage').id;
    			minTotal = minMap.get(stageId);
    			maxTotal = maxMap.get(stageId);
    			if(!this$.validateMinMax(item)){
        			returnValue = false;
        			return false;
    			}
	    		if(isNullOrEmpty(minTotal)) {
	    			minTotal = 0;
	    		}
	    		if(isNullOrEmpty(maxTotal)) {
	    			maxTotal = 0;
	    		}
	    		minTotal = minTotal+ item.get('minSeat');
	    		maxTotal = maxTotal+ item.get('maxSeat');
	    		minMap.add(stageId, minTotal);
	    		maxMap.add(stageId, maxTotal);
    		});
    	});
    	if(returnValue){
        	minMap.each(function(value) {
        		if(minMap.get(value)>100) {
        			showErrorMessage(getAdmissionTranslation('QUOTA_SETTING'), getAdmissionTranslation('QUOTA_TYPE_APPLICABILITY_TOTAL_100_error'));
        			returnValue = false;
        			return false;
        		}
        	});
    	}
    	if(returnValue){
	    	maxMap.each(function(value) {
	    		if(maxMap.get(value)>100) {
	    			showErrorMessage(getAdmissionTranslation('QUOTA_SETTING'), getAdmissionTranslation('QUOTA_TYPE_APPLICABILITY_TOTAL_100_error'));
	    			returnValue = false;
	    			return false;
	    		}
	    	});
    	}
    	return returnValue;
    },
    
    /**
     * method for saving the modifications done in the Quota Setting Grid.
     * @param {Object} button: reference of the clicked button.
     */
    saveQuotaSettingRecords: function(button) {
    	var grid = button.up('grid');
    	var store = grid.getStore();
    	var modifiedRecords = store.getUpdatedRecords();
    	var formValues = new Array();
    	
    	var quotaTypeCombo =grid.down('#quotaTypeCombo');
    	var distributionBasis= quotaTypeCombo.getStore().getById(quotaTypeCombo.getValue()).get('distributionBasis');
    	
    	for(var i = 0; i<modifiedRecords.length; i++) {
    		delete modifiedRecords[i].data.quotaValue;
    		modifiedRecords[i].data.whetherPercentageBasis=(distributionBasis=='PERCENTAGE');
    		formValues.push(modifiedRecords[i].data);	
    	}
    	formValues = Ext.encode(formValues);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
            method: "PUT",
            url: SERVERURL.SAVE_QUOTA_SETTING ,
            jsonData: formValues,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(form, action) {
            	grid.getStore().load();
            	 Ext.getBody().unmask();
            	grid.getSelectionModel().deselectAll(true);
                showSuccessMessage(getAdmissionTranslation('QUOTA_SETTING'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
            }
        });
    },
    
    clone: function (obj) {
        if (null == obj || "object" != typeof obj) return obj;
        var copy = obj.constructor();
        for (var attr in obj) {
            if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
        }
        return copy;
    },
    
    /* ********************** Quota type tab methods *************************/
    /**
     * method saves the changes made in the Quota Type grid.
     * @param {Object} reference of the save button clicked from the grid.
     */
    saveQuotaTypeChanges: function(button) {
		var grid = button.up('grid'),error=false;
		var store = grid.getStore();
    	var updatedRecords =  store.getUpdatedRecords();
    	var formValues = new Array();
    	
    	for(var i = 0; i<updatedRecords.length; i++) {
    	 	var updatedRecords1 =  this.clone(updatedRecords[i].data);
    		if(isNullOrEmpty(updatedRecords1.whetherMandatory)) {
    			updatedRecords1.set('whetherMandatory', false);
    		}
    		
    	 	updatedRecords1.programSelectionProcessId=this.getProgramSelectionProcessId();
    		var wsQuotaType = new Object();
    		wsQuotaType.id = updatedRecords1.quotaTypeId;
    		updatedRecords1.quotaType=wsQuotaType;
    		delete updatedRecords1.quotaTypeId;
    		formValues.push(updatedRecords1);	
    	}
    	if(!error){
	    	formValues = Ext.encode(formValues);
	    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	Ext.Ajax.request({
	            type: 'rest',
	            url: SERVERURL.PSP_QUOTATYPE_UPDATE,
	            jsonData: formValues,
	            method: 'PUT',
	            success: function() {
	           	 grid.getStore().load();
	           	 Ext.getBody().unmask();
	           	 grid.getSelectionModel().deselectAll(true);
	                showSuccessMessage(getAdmissionTranslation('QUOTA_TYPE_APPLICABILITY'), getCommonTranslation('SUCCESS'));
	            }
	        });
    	}
    },
    
    /*
     * 	********************** Stage setting Tab Methods *********************
     */
    /**
     * This method is used to load the stage setting data in the stage setting tab of the comfigure combination tab. 
     * @param {Object} combo which is the reference of the combo box from the stage setting screen
     * @param {Object} records is the selected record from the comboBox.
     */
   /* loadStageData: function(combo, recordId) {
    	var this$ = this;
    	var serverUrl = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
    	serverUrl = serverUrl.concat('/'+recordId);
    	var stageForm =  this$.getStageSettingsForm();
        var approverAuthority = stageForm.down('#approverAuthority');
    	Ext.Ajax.request({
			type: 'rest',
            method: "GET",
            url: serverUrl,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(form, action) {
            	var responseObj = Ext.decode(form.responseText);
            	if(responseObj.selectionProcessStage.whetherApproverRequired){
                    approverAuthority.allowBlank = false;
                    approverAuthority.labelSeparator = '';
                    approverAuthority.setFieldLabel(approverAuthority.fieldLabel+':<span class="required" style="color:red"> *</span>');
                } else {
                    approverAuthority.allowBlank = true;
                    approverAuthority.setFieldLabel(approverAuthority.fieldLabel);
                }
            	this$.setStageData(responseObj);
            }
        });
    },*/
    loadStageData: function(combo, recordId) {
        var this$ = this;
        var serverUrl = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
        serverUrl = serverUrl.concat('/' + recordId);
        var stageForm = this$.getStageSettingsForm();
        var approverAuthority = stageForm.down('#approverAuthority');

        Ext.Ajax.request({
            type: 'rest',
            method: "GET",
            url: serverUrl,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(form, action) {
                var responseObj = Ext.decode(form.responseText);
                var label = approverAuthority.fieldLabel || '';
                
                // Remove existing red asterisk if present
                var cleanedLabel = label.replace(/:<span class="required" style="color:red"> \*<\/span>/, '');

                if (responseObj.selectionProcessStage.whetherApproverRequired) {
                    approverAuthority.allowBlank = false;
                    approverAuthority.labelSeparator = '';
                    
                    // Only add asterisk if not already present
                    if (!label.includes('*')) {
                        approverAuthority.setFieldLabel(cleanedLabel + ':<span class="required" style="color:red"> *</span>');
                    }
                } else {
                    approverAuthority.allowBlank = true;
                    approverAuthority.setFieldLabel(cleanedLabel);
                }

                this$.setStageData(responseObj);
            }
        });
    }
,
    
    setStageData:function(object){

    	if(!isNullOrEmpty(object.startDate))
    		object.startDate = new Date(object.startDate);
    	if(!isNullOrEmpty(object.endDate))
    		object.endDate = new Date(object.endDate);
    	var form =  this.getStageSettingsForm();
    	var basicForm =  form.getForm();
    	var approverAuthority = form.down('#approverAuthority');
    
    	var endDate =form.down('#endDate');
    	endDate.setMinValue(null);
    	var startDate =form.down('#startDate');
    	startDate.setMaxValue(null);
    	if(!isNullOrEmpty(object.approverAuthority)){
    		var temp = object.approverAuthority.id;
	    	delete object['approverAuthority'];
	    	approverAuthority.getStore().load({
	    		callback:function(callback,record,operation){
	    			approverAuthority.setValue(temp);
	    		}
	    	});
    	}
    	if(!isNullOrEmpty(object.feePlanRule)){
    		var feePlanRule=form.down('#admissionFeePlanRule');
    		feePlanRule.setDisabled(false);
    	}
    	if(!isNullOrEmpty(object.feePlanRuleStage)){
    		var feePlanRuleStage=form.down('#admissionStageFeePlan');
    		feePlanRuleStage.getStore().getProxy().extraParams={
				feePlanRuleId:object.feePlanRule.id
			};
    		feePlanRuleStage.getStore().load();
    		feePlanRuleStage.setDisabled(false);
    	}

    	basicForm.setValues(object);
    	var feePlanCombo=form.down('#admissionFeePlan');
		  setTimeout(function(){
					  if( !isNullOrEmpty(feePlanId) ){
							  feePlanCombo.setValue(feePlanId);
					  }
     	},500);

    	var whetherApproverRequired=object.selectionProcessStage.whetherApproverRequired;
    	if (whetherApproverRequired == true) {
    		approverAuthority.allowBlank=false;
        } else if (whetherApproverRequired == false) {
        	approverAuthority.allowBlank=true;
        }
    	approverAuthority.validate();
    },
    /**
     * method to save the selection process Stage setting tab on click of the save button.
     * @param {Object} button: reference of the clicked button.
     */
    saveStageSettings: function(button) {
    	var this$=this;
    	var form = button.up('form');
    	var formValues = form.getValues();
    	if(isNullOrEmpty(formValues.entryRule)){
    		formValues.entryRule =null;
    	}
    	if(isNullOrEmpty(formValues.exitRule)){
    		formValues.exitRule =null;
    	}
    	if(isNullOrEmpty(formValues.entryRuleDescription)){
    		formValues.entryRuleDescription =null;
    	}
    	if(isNullOrEmpty(formValues.exitRuleDescription)){
    		formValues.exitRuleDescription =null;
    	}
    	var processIds = this$.getProgramSelectionProcessMultipleIds();
    	var progSelectionStageIds = new Array();
    	delete formValues.programSelectionProcessStage;
    	
    	if(processIds == null){
    		processIds=new Array();
    		processIds.push(this$.getProgramSelectionProcessId());
    		progSelectionStageIds.push(formValues.id);
    	}
    	
    	formValues.id = formValues.id;
    	formValues.multipleIds = processIds.join();
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	
		Ext.Ajax.request({
			type: 'rest',
            method: "PUT",
            async: false,
            url: SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND,
            jsonData: formValues,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(form, action) {            	 
            	 Ext.getBody().unmask();
            	 var responseObj = Ext.decode(form.responseText);
            	 this$.setStageData(responseObj);
                showSuccessMessage(getAdmissionTranslation('STAGE_SETTING'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
            }
            
        });
    },
   
    /**
     * method to Save the selection setting window on click of the save Button.
     * @param {Object} button: reference of the clicked button.
     */
    saveSelectionSettings: function(button) {	
    var me = this;
	var formReference = button.up('form');
	var formValues = button.up('form').getValues();
	var formMethod = 'POST';
	var progSelectionProcessId = null;
	var a = this.getAdmissionsettingsform();
	var prId = a.getForm().findField('multipleId');
	
	var appSettingForm = this.getApplicationsettingform();
	var applicationSettingVar = appSettingForm.getForm().findField('multipleId');
	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
		formMethod = 'PUT';
		progSelectionProcessId = formValues.id;
	} 
	delete formValues.selectionProcessStageId;
	
	var programBatchSeatConfiguration = formValues.programBatchSeatConfiguration;
	var programBatchSeatConfigurationArray = programBatchSeatConfiguration.split(',');
	var progSelectionProcessIdArray = new Array();
	
	if(progSelectionProcessId!=null){
	progSelectionProcessIdArray = progSelectionProcessId.split(',');
	}
	var messageCount = 1;
	for(var j=0;j<programBatchSeatConfigurationArray.length;j++){
		
	var progBatchSeatConfig = new Object();
	var programSelectionIds = new Array();
	var processIds = new Array();
	var selectionProcessStagesId= new Array();
	
	if(progSelectionProcessId!=null){
		formValues.id = progSelectionProcessIdArray[j];
	}
	progBatchSeatConfig.programBatchSeatConfigurationId = programBatchSeatConfigurationArray[j];
	formValues.programBatchSeatConfiguration = progBatchSeatConfig;
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	
	Ext.Ajax.request({
		type: 'rest',
        method: formMethod,
        url: SERVERURL.PROGRAM_SELECTION_PROCESS_ADD_EDIT_DELETE ,
        jsonData: formValues,
        headers: {
            'Content-Type': 'application/json'
        },
        success: function(response) {
        	
        	 Ext.getBody().unmask();
        	 
        	var weatherSelectionInBatchesRadio = formReference.down('radiogroup#whetherSelectionInBatches');
        	var selectionMode = formReference.down('#selectionMode');
        	selectionMode.setValue(weatherSelectionInBatchesRadio.getValue().whetherSelectionInBatches);
        	
        	/*
        	 * code to reload the grid.
        	 */
        	var programGroupCombinationsGrid = me.getProgramGroupCombinationsGrid();
        	programGroupCombinationsGrid.getStore().reload();
        	programGroupCombinationsGrid.getSelectionModel().deselectAll(true);
        	
        	/*
        	 *  Updating the version field after every save in order to handle consecutive saves without going back to the grid.
        	 *  If the user traverses back to the grid and view/configures any record then that case will be handled by the updated
        	 *  version that will be recieved from the server while it gets updated.
        	 */
        	var data = Ext.JSON.decode(response.responseText);
        	programSelectionIds.push(data.programBatchSeatConfiguration.programBatchSeatConfigurationId);
        	data.programBatchSeatConfiguration=programSelectionIds;
        	processIds.push(parseInt(data.id));
        	data.id = processIds;
        	formReference.getForm().setValues(data);
        	me.setProgramSelectionProcessId(parseInt(data.id));
        	me.setProgramSelectionProcessMultipleIds(processIds);
        	prId.setValue(processIds);
        	selectionProcessStagesId = data.selectionProcessStagesId;
        	applicationSettingVar.setValue(processIds);
        	/*
        	 * code to Enable the rest tabs.
        	 */
        	var tabReference = formReference.up('tabpanel');
        	me.toggleTabsVisibility(tabReference, false);
            me.showMessageToUser(messageCount);
            messageCount++;
        }
    }); }
	},
    
    loadProgramSelectionProcess:function(form,id){
    	if(isNullOrEmpty(id))
    		id=this.getProgramSelectionProcessId();
    	if(!form)
    		form=this.getSelectionSettingsForm();
    	if(!isNullOrEmpty(id)){
        	Ext.Ajax.request({
    			type: 'rest',
                method: 'GET',
                url: SERVERURL.PROGRAM_SELECTION_PROCESS_ADD_EDIT_DELETE +"/" + id,
                success: function(response) {
            		var data = Ext.JSON.decode(response.responseText);
                	data.programBatchSeatConfiguration=data.programBatchSeatConfiguration.programBatchSeatConfigurationId;
                	
                	form.getForm().setValues(data);
                }
        	});
    	}
    },
    /*
     * 	********************** Application and admission setting Tab Methods *********************
     */
    
    /**
     * this method is used to save the Document record from document tab.
     * @param {Object} button The reference of the button.
     * @param {String} The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    saveDocument: function(button, applicableAt) {
    	var this$ = this;
    	var formWindow = button.up('window');
    	var formValues = button.up('form').getValues();
    	var formMethod = null;
    	var applicaitonFormId = new Array();
    	var processIds = new Array();
    	var formReference = button.up('form');
    	var docStatus = this$.validateApplicabilityRuleForDocument(formValues);
    	var multipleSetupConfig =false;
    	if(docStatus == true){
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	var programSelectionArray = new Array();
    	this.getProgramSelectionProcessMultipleIds()
    	if(!isNullOrEmpty(this.getProgramSelectionProcessMultipleIds()) && this.getProgramSelectionProcessMultipleIds().length>1){
    	 programSelectionArray = this.getProgramSelectionProcessMultipleIds();
    	 multipleSetupConfig =true;
    	}
    	else{
    		programSelectionArray.push(this.getProgramSelectionProcessId());
    	}

    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var length=0;
   	    for(var j in programSelectionArray){
     	formValues.programSelectionProcessId = programSelectionArray[j];
     	formValues.applicableAt = applicableAt;
     	formValues.multipleSetupConfig = multipleSetupConfig;

     	Ext.Ajax.request({
    		   type : 'rest',
    		   url : SERVERURL.GET_PROGRAM_SELECTION_PRO_DOC,
    		   params : {
    			programSelectionProcessId:formValues.programSelectionProcessId,
    			id : formValues.id,
    			documentTypeId:formValues.documentType.id
    		   },
    		   method : 'GET',
    		   success : function(form, action) {
    			 var responseObj = Ext.decode(form.responseText);
    			 if(responseObj){
    				showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('CAN_NOT_ADD_DUPLICATE_DOCUMENT_IN_SELECTION_PROCESS'));	
    			 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
    			 }else{
    				Ext.Ajax.request({
    	             type: 'rest',
    	             url: SERVERURL.PSP_APPLICATION_SETTING_ADD_EDIT_DELETE,
    	             jsonData: formValues,
    	             method: formMethod,
    	             success: function(response) {
    	            	 var grid = this$.getApplicationDocumentsGrid();
    	            	if(applicableAt === "APPLICATION") {
    	            		grid = this$.getApplicationDocumentsGrid();
    	           		} else {
    	           			grid = this$.getAdmissionDocumentsGrid();
    	           		}
    	            	 
    	            	var data = Ext.JSON.decode(response.responseText);
    	           	    applicaitonFormId.push(formValues.programSelectionProcessId);
    	            	data.programSelectionProcessId=applicaitonFormId;
    	            	processIds.push(parseInt(data));
    	            	data.id = processIds;
    	            	formReference.getForm().setValues(data);
    	            	this$.setMultipleApplicationFormSettingId(processIds);
    	            	 grid.getStore().load();
    	            	 grid.getSelectionModel().deselectAll(true);
    	            	 Ext.getBody().unmask();
    	            	 this$.closeFormWindow(formWindow);
    					 if(length==programSelectionArray.length-1){
    	            	 if(applicableAt === "APPLICATION") {
    	 		  			showSuccessMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));	
    	 		  		} else {
    	 		  			showSuccessMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
    	 		  		}    
    					} 
    					length++;      	 
    	             },
    	             failure: function(response){
    	            	 Ext.getBody().unmask();
    	            	 this$.closeFormWindow(formWindow);
    	             }
    	         });
    			 }
    		   }
    	   });
     	 }
     }
    },
    
    validateApplicabilityRuleForDocument: function(formValues) {
    	var this$ = this;
    	if(formValues.applicability == "APPLICANTBASED"){
    		var applicabilityRule = formValues.applicabilityRule;
    		try{
    		var parametersData = JSON.parse(applicabilityRule);
    		var parametersSize = Object.keys(parametersData).length;
    		var nationality = parametersData.Nationality;
    		var isCitizen = parametersData.AreYouCitizen;
    		var isSeeker = parametersData.AreYouAsylumSeeker;
    		var isResident = parametersData.AreYouPermanentResident;
    		var disabilities = parametersData.Disabilities;
    		var bursary = parametersData.Bursary;
    		var currentActivity = parametersData.CurrentActivity;
    		var examBoard = parametersData.ExamBoard;
    		var rplApplicant = parametersData.RPLApplicant;
    		var isWheelChairRequired=parametersData.WheelChairRequired
    		var secondaryCitizenshipInAfrica=parametersData.SecondaryCitizenshipInAfrica
    		if(nationality == undefined && isCitizen == undefined && isSeeker == undefined && isResident == undefined && disabilities == undefined 
    				&& bursary == undefined && currentActivity == undefined && examBoard == undefined && rplApplicant == undefined && isWheelChairRequired== undefined && secondaryCitizenshipInAfrica == undefined){
    			showErrorMessage(getAdmissionTranslation('DOCUMENTS'), getCommonTranslation('INVALID_PARAMETERS'));
    			return false;
    			}else if(examBoard != undefined && !examBoard.includes("!")){
    				showErrorMessage(getAdmissionTranslation('DOCUMENTS'), getCommonTranslation('EXAM_BOARD_INVALID_PARAMETERS'));
    				return false;
    			}
    		}
    		catch(e){
    			showErrorMessage(getAdmissionTranslation('DOCUMENTS'), getCommonTranslation('INVALID_APPLICABILITY_RULE'));
    			return false;
    		}
    	}
    	return true;
    },
    /**
     * Common Method to show the AddDocument form which will be called from the Application setting and the Admission Setting tab.
     * @param {Object} button The reference of the button.
     * @param {String} The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    onDocumentAdd: function(button, applicableAt) {
    	var windowAlieas='admissiondocumentswindow';
    	if(applicableAt === "APPLICATION") {
    		windowAlieas='applicationdocumentswindow';
  		}
    	return	this.showWindow(windowAlieas);
    },
    
    /**
     * Common method which is used to Edit the Document in the Document grid which will be called from the Application setting and the Admission Setting tab.
     * @param {Object} button The reference of the button.
     * @param {Boolean} viewOnly weather the screen should be opened in viewOnly/editable mode.
     * @param {String} applicableAt The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    onDocumentEdit: function(button, viewOnly, applicableAt) {
    	var documentGrid = button.up('grid');
    	if(documentGrid.getSelectionModel().getCount()>0){
    		var documentRecord = documentGrid.getSelectionModel().getSelection()[0];
			var documentWindow = this.onDocumentAdd(null, applicableAt);
			
            /*
             * populate data into the window
             */
            formRef = documentWindow.down('form');
            form = documentWindow.down('form').form;
            form.loadRecord(documentRecord);
            if(viewOnly) {
            	this.toggleReadOnlyFormItems(form, true);
            	formRef.down('button[itemId=btnSaveDocuments]').setVisible(false);
            }
	} else {
		if(applicableAt === "APPLICATION") {
			showWarningMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
  		} else {
  			showWarningMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
  		}
	}
    },
    
    
    /**
     * this method is used to view the Document in the Document grid which will be called from the Application setting
     *  and the Admission Setting tab.
     * @param {Object} button The reference of the button.
     * @param {String} applicableAt The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    onDocumentView: function(button, applicableAt) {
   		this.onDocumentEdit(button, true, applicableAt);
    },
    
    
    /**
     * this method is used to delete the Document in the Document grid which will be called from the Application setting
     *  and the Admission Setting tab.
     * @param {Object} button The reference of the button.
     * @param {String} applicableAt The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    onDocumentDelete: function(button, applicableAt) {
    	var grid = button.up('grid');
    	if(grid.getSelectionModel().getCount()>0){
    		var deleteIdArray = new Array();
    		var record = grid.getSelectionModel().getSelection()[0];
    		deleteIdArray.push(record.get("id"));
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	for(var j in deleteIdArray){
                	var url = SERVERURL.PSP_APPLICATION_SETTING_ADD_EDIT_DELETE;
                    var id = deleteIdArray[j] ;
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                        	 if(applicableAt === "APPLICATION") {
              		  			showSuccessMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));	
              		  		} else {
              		  			showSuccessMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
              		  		}
                        }
                    });
                }}
            });
    	} else {
    		if(applicableAt === "APPLICATION") {
    			showWarningMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      		} else {
      			showWarningMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      		}
    	}
    },
    saveApplicationSetting: function(button) {
    	var this$ = this;
    	var form = button.up('form');
    	var uplaodUrl=SERVERURL.FPD_UPLOAD_APPLICATION_FROM_DOCUMENTS_TEMP;
        var documentItemId = form.down('#documentId');
        var documentValue = documentItemId.getValue();
		if (!isNullOrEmpty(documentValue)) {
            form.getForm().submit({
                method: 'POST',
                url: uplaodUrl,
                success: function(form1, action) {
                    var responseData = Ext.decode(action.response.responseText);
                    if(responseData.success) {
                    	 var path = responseData.path;
                         form.getForm().findField('documentIdUploadPath').setValue(path);
                         this$.saveApplicationSettingWithDocument(form);
                    } 
                },
               /* failure: function(d, f, s) {
                    console.log('hello');
                }*/
                        failure: function(form, action) {
			            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                        showWarningMessage(getCommonTranslation('ALERT'), msg);
				        
				    }
            });
        } else {
            this$.saveApplicationSettingWithDocument(form);
        }

	},
	saveApplicationSettingWithDocument: function(form) {
		var this$ = this;
    	var formValues = form.getValues();
    	var formMethod = null;
    	var processSelectionIds;
    	
    	if(formValues.multipleId!=null && formValues.multipleId!=""){
    		processSelectionIds =  formValues.multipleId;
    	}
    	else{
    		processSelectionIds = this.getProgramSelectionProcessId();
    	}
    
    	delete formValues.multipleId;

        var submitUrl = SERVERURL.PATH_SAVE_APPLICATION_SETTING_CONFIGURATION ;
        var path = form.getForm().findField('documentIdUploadPath').getValue();
        var jsonFormatFormData = this$.getJsonApplicationSettingFormData(form, path,processSelectionIds);
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        this$.sendSaveAjaxRequest(submitUrl,formMethod, jsonFormatFormData, function(option, success, response) {
        //    this$.hideWindowMask();
            if (success && form) {
            	  var version= form.down('#versionField');
                  if(!isNullOrEmpty(version.getValue())){
                  	version.setValue(parseInt(version.getValue())+1);
                  }
		  		Ext.getBody().unmask();
		  		showSuccessMessage(getAdmissionTranslation('APPLICATION_SETTING'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));	
              
            }
            else {
		  		Ext.getBody().unmask();
		  		showErrorMessage(getAdmissionTranslation('APPLICATION_SETTING'), getCommonTranslation('FAILURE'));
		  	}
        });
       
	},
    getJsonApplicationSettingFormData: function(form, path,processSelectionIds) {
        var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
         var userId = this.getCurrentlyLoggedInUser().id;
            user = {
                id: userId
            };

            if (!isNullOrEmpty(path)) {
                var fileName = path.substring(path.lastIndexOf('/') + 1, path.length);
                var doc = {
                    path: path,
                    name: fileName,
                    type: 'DOCUMENT',
                    createdBy: user
                };
                formData.documentId = doc;
            } else {
                formData.documentId = null;
            }
            
        formData.multipleProgramSelectionPorcessIds =processSelectionIds;
        delete formData.documentIdUploadPath;
        delete formData.multipleId;
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
   
    
    /* ******** Admission Setting Tab methods **********/
    /**
     * This method is used to save the admission settings. Called from the Admission Setting Tab
     * @param {Object} button The reference of the button.
     */
    saveAdmissionSetting: function(button) {	
    var $this = this;
    var form = button.up('form');
	var formValues = form.getValues();
	var formMethod = null;
	var processConfigId  = null;
	var processSelectionIds;
	var processSelectionIdsArray = new Array();
	var processSelectionIdsAfterSaveArray = new Array();
	
	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
		formMethod = 'PUT';
		processConfigId = formValues.id;
	} else {
		formMethod = 'POST';
	}
	if(!formValues.whetherAutoAdmissionApproval){
		delete formValues.checkForEligibilityBeforeApproveAdmissionAutomatically;
	}
	if(!formValues.whetherTrialAdmissionAllowed){
		delete formValues.trialAdmissionEndDate;
	}
	if(formValues.referenceLetterSubmissionDeadline == "" && formValues.referenceLetterSubmissionDeadline == null && formValues.referenceLetterSubmissionDeadline == undefined){
		delete formValues.referenceLetterSubmissionDeadline;
	}
	
	processSelectionIds = formValues.multipleId;
	
	if(processSelectionIds!=null && processSelectionIds!=""){
		processSelectionIdsArray = processSelectionIds.split(',');
	}
	else{
		processSelectionIds = this.getProgramSelectionProcessId();
		processSelectionIdsArray.push(processSelectionIds);
	}
	var processConfigIdsArray = new Array();
	var configSelectionIds = new Array();
	
	if(processConfigId!=null){
		processConfigIdsArray = processConfigId.split(',');
	}
	delete formValues.multipleId;
	var messageCount = 1;
	for(var j=0;j<processSelectionIdsArray.length;j++){
		
		
		if(processConfigId!=null){
			formValues.id = processConfigIdsArray[j];
		}
		formValues.programSelectionProcessId = processSelectionIdsArray[j];
	//	delete formValues.whetherAdditionalConditionApplicable;
	//	delete formValues.currentActivityName;
		 
		var admissionConfigCurrentActivityJsonArry = [];
		 if(!isNullOrEmpty(formValues.currentActivityName)){
	    		if(typeof formValues.currentActivityName == "object"){
	        		Ext.each(formValues.currentActivityName, function(currentActivityValue){
	                	var currentActivityName = '';
	                	var mainObj = '';
	                    if(!isNullOrEmpty(currentActivityValue)){
	                	mainObj = {
	                			"currentActivity" : {
	                					"id" : currentActivityValue.data.id
	                			}	
	                	}
	                	admissionConfigCurrentActivityJsonArry.push(mainObj);
	                    }
	                });
	    		}
	    		else{
	    			var currentActivityName = '';
	            	var mainObj = '';
	            	mainObj = {
	            			"currentActivity" : {
	            					"id" : formValues.currentActivityName
	            			}		
	            	}
	            	admissionConfigCurrentActivityJsonArry.push(mainObj);
	    		}
	    	}
		formValues.admissionConfigurationCurrentActivity = admissionConfigCurrentActivityJsonArry;
		delete formValues.currentActivityName;
		
		var admissionConfigEligibilityRecommendationJsonArry = [];
		 if(!isNullOrEmpty(formValues.eligibilityRecommendation)){
	    		if(typeof formValues.eligibilityRecommendation == "object"){
	        		Ext.each(formValues.eligibilityRecommendation, function(eligibilityRecommendationValue){
	                	var eligibilityRecommendation = '';
	                	var mainObj = '';
	                    if(!isNullOrEmpty(eligibilityRecommendationValue)){
	                	mainObj = {
	                			"preEligiblityId" : {
	                					"id" : eligibilityRecommendationValue.data.id
	                			}	
	                	}
	                	admissionConfigEligibilityRecommendationJsonArry.push(mainObj);
	                    }
	                });
	    		}
	    		else{
	    			var eligibilityRecommendation = '';
	            	var mainObj = '';
	            	mainObj = {
	            			"preEligiblityId" : {
	            					"id" : formValues.eligibilityRecommendation
	            			}		
	            	}
	            	admissionConfigEligibilityRecommendationJsonArry.push(mainObj);
	    		}
	    	}
		formValues.admissionSetupPreEligiblity = admissionConfigEligibilityRecommendationJsonArry;
		delete formValues.eligibilityRecommendation;
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	this.sendSaveAjaxRequest(SERVERURL.PSP_ADMISSION_SETTING_SAVE, formMethod, Ext.encode(formValues), function(opt,success,response){
	  	if(success){
	  		Ext.getBody().unmask();
	  		//showSuccessMessage(getAdmissionTranslation('ADMISSION_SETTING'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));	
	  		$this.showMessageToUser(messageCount);
	  		 messageCount++;
	  		var responseObj = Ext.decode(response.responseText);
	  		 if (!isNullOrEmpty(responseObj.admissionOfferStartDate))
	  	         responseObj.admissionOfferStartDate= new Date(responseObj.admissionOfferStartDate);
	  	     if (!isNullOrEmpty(responseObj.admissionOfferEndDate))
	  	         responseObj.admissionOfferEndDate= new Date(responseObj.admissionOfferEndDate);
	  		if (!isNullOrEmpty(responseObj.admissionProcessStartDate))
	  	        responseObj.admissionProcessStartDate = new Date(responseObj.admissionProcessStartDate);
	  	    if (!isNullOrEmpty(responseObj.lastDateForAdmission))
	  	        responseObj.lastDateForAdmission = new Date(responseObj.lastDateForAdmission);
	  	    if (!isNullOrEmpty(responseObj.lastDateForConfirmation))
	  	        responseObj.lastDateForConfirmation = new Date(responseObj.lastDateForConfirmation);
	  	    if (!isNullOrEmpty(responseObj.trialAdmissionEndDate))
	  	        responseObj.trialAdmissionEndDate = new Date(responseObj.trialAdmissionEndDate);
	  	    if (!isNullOrEmpty(responseObj.referenceLetterSubmissionDeadline))
	  	        responseObj.referenceLetterSubmissionDeadline = new Date(responseObj.referenceLetterSubmissionDeadline);
	  	    if (!isNullOrEmpty(responseObj.proAdmissionOfferStartDate))
	  	         responseObj.proAdmissionOfferStartDate= new Date(responseObj.proAdmissionOfferStartDate);
	  	    if (!isNullOrEmpty(responseObj.proAdmissionOfferEndDate))
 	         responseObj.proAdmissionOfferEndDate= new Date(responseObj.proAdmissionOfferEndDate);
	  	  if (!isNullOrEmpty(responseObj.applicationRejectDateAsOn))
	  	        responseObj.applicationRejectDateAsOn = new Date(responseObj.applicationRejectDateAsOn);
	  	    if(responseObj.offerLetterIssueProcess == null){
	  	    	responseObj.offerLetterIssueProcess = 'MANUAL';
	  	    }
	  	    if(responseObj.proOfferLetterIssueProcess == null){
	  	    	responseObj.proOfferLetterIssueProcess = 'MANUAL';
	  	    }
	  	
	  	  if (!isNullOrEmpty(responseObj.offerLetterExpiryDate))
	  	         responseObj.offerLetterExpiryDate= new Date(responseObj.offerLetterExpiryDate);
	  	if (!isNullOrEmpty(responseObj.proOfferLetterExpiryDate))
 	         responseObj.proOfferLetterExpiryDate= new Date(responseObj.proOfferLetterExpiryDate);
	  	   configSelectionIds.push(parseInt(responseObj.id));
	  	   responseObj.id = configSelectionIds;
	  	   processSelectionIdsAfterSaveArray.push(responseObj.programSelectionProcessId);
	  	   responseObj.multipleId = processSelectionIdsAfterSaveArray;
	  	   form.getForm().setValues(responseObj);
	  		
	  	 var currentActivityItemIdField = form.down("#currentActivityItemId");
	  		currentActivityItemIdField.reset();
	  		currentActivityItemIdField.clearValue();
			if(responseObj.admissionConfigurationCurrentActivity.length>0){
				currentActivityItemIdField.getStore().load({
 				callback: function(records, operation, success) {
 					if (success) {
 						var admissionConfigCurrentActivityJsonArry= [];
 						if(records.length > 0){
 							responseObj.admissionConfigurationCurrentActivity.forEach(function(currentActivityObj){
 								var result = records.filter(function (obj) {
 									  return obj.data.id === currentActivityObj.currentActivity.id;
 									})[0];
 								admissionConfigCurrentActivityJsonArry.push(result);
 							});
 							currentActivityItemIdField.setValue(admissionConfigCurrentActivityJsonArry);
 						}
 					}
 				}
 	        });
			}	
			
			var eligibilityRecommendationField = form.down("#eligibilityRecommendation");
			eligibilityRecommendationField.reset();
			eligibilityRecommendationField.clearValue();
			if(responseObj.admissionSetupPreEligiblity.length>0){
				eligibilityRecommendationField.getStore().load({
    				callback: function(records, operation, success) {
    					if (success) {
    						var admissionConfigEligibilityRecommendationJsonArry= [];
    						if(records.length > 0){
    							responseObj.admissionSetupPreEligiblity.forEach(function(eligibilityRecommendationObj){
    								var result = records.filter(function (obj) {
    									  return obj.data.id === eligibilityRecommendationObj.preEligiblityId.id;
    									})[0];
    								admissionConfigEligibilityRecommendationJsonArry.push(result);
    							});
    							eligibilityRecommendationField.setValue(admissionConfigEligibilityRecommendationJsonArry);
    						}
    					}
    				}
    	        });
			}
			
	  		
	  	} else {
	  		Ext.getBody().unmask();
	  		showErrorMessage(getAdmissionTranslation('ADMISSION_SETTING'), getCommonTranslation('FAILURE'));
	  	}
  	});}
	},
	/**
	 * This method is used to load the Admission Setting form which is in the Admission SEtting tab.
	 * @param {Object} button The reference of the form.
	 */
	loadAdmissionSettings: function(form) {
		var offerLaterIssueProcessField=form.down("#offerLetterIssueProcess");
 		var proOfferLaterIssueProcessField=form.down("#proOfferLetterIssueProcess");
		var urlfindById = SERVERURL.PSP_FIND_BY_ID;
		urlfindById = urlfindById.concat(this.getProgramSelectionProcessId()); 
		
		this.sendGetAjaxRequest(urlfindById, 'GET', null, function(opt,success,response){
		  	if(success){
		  	  	if(!isNullOrEmpty(response.responseText)) {
		  	  	var responseObj = Ext.decode(response.responseText);
		  		if (!isNullOrEmpty(responseObj.approverAuthority)) {
		  			var temp = responseObj.approverAuthority.id;
		  			delete responseObj['approverAuthority'];
		  			var approverAuthority = form.down('#approverAuthority');
		  			approverAuthority.getStore().load({
		  				callback : function(callback, record, operation) {
		  					approverAuthority.setValue(temp);
		  				}
		  			});
		  		}
		  		//form.getForm().setValues(responseObj);
		  		if (!isNullOrEmpty(responseObj) && !isNullOrEmpty(responseObj.programBatchSeatConfiguration) && !isNullOrEmpty(responseObj.programBatchSeatConfiguration.seatCapacity)){
			  		form.down("#offerLetterIssuancePotential").minValue = responseObj.programBatchSeatConfiguration.seatCapacity;
		  		}
		  	  }
		  
		  	}
	  	});

		var url = SERVERURL.PSP_ADMISSION_SETTING_GET;
		url = url.concat('?programSelectionProcessId='+this.getProgramSelectionProcessId()); 
		this.sendGetAjaxRequest(url, 'GET', null, function(opt,success,response){
		  	if(success){
		  	  	if(!isNullOrEmpty(response.responseText)) {
		  	  		
			  		var responseObj = Ext.decode(response.responseText);
			  		if (!isNullOrEmpty(responseObj.approverAuthority)) {
			  			var temp = responseObj.approverAuthority.id;
			  			delete responseObj['approverAuthority'];
			  			var approverAuthority = form.down('#approverAuthority');
			  			approverAuthority.getStore().load({
			  				callback : function(callback, record, operation) {
			  					approverAuthority.setValue(temp);
			  				}
			  			});
			  		}
			  		form.getForm().setValues(responseObj);
					form.down("#admissionProcessStartDate").setValue(dateRender(responseObj.admissionProcessStartDate));
					form.down("#admissionOfferStartDate").setValue(dateRender(responseObj.admissionOfferStartDate));
					form.down("#admissionOfferEndDate").setValue(dateRender(responseObj.admissionOfferEndDate));
					form.down("#offerLetterExpiryDate").setValue(dateRender(responseObj.offerLetterExpiryDate));
			  		form.down("#lastDateForAdmission").setValue(dateRender(responseObj.lastDateForAdmission));
			  		form.down("#proAdmissionOfferStartDate").setValue(dateRender(responseObj.proAdmissionOfferStartDate));
					form.down("#proAdmissionOfferEndDate").setValue(dateRender(responseObj.proAdmissionOfferEndDate));
					form.down("#trialAdmissionEndDateId").setValue(dateRender(responseObj.trialAdmissionEndDate));
			  		form.down("#proOfferLetterExpiryDate").setValue(dateRender(responseObj.proOfferLetterExpiryDate));
			  		form.down("#applicationRejectDateAsOn").setValue(dateRender(responseObj.applicationRejectDateAsOn));
			  		form.down("#offerLetterIssuancePotential").minValue = responseObj.seatCapacity;
			  		
			  		if(!isNullOrEmpty(responseObj.whetherAdditionalConditionApplicable) && responseObj.whetherAdditionalConditionApplicable==true) {
			  			form.down("#additionalConditionApplicableItemId").setValue({whetherAdditionalConditionApplicable : true});
			  		}
			  		//form.down("#currentActivityItemId").setValue(dateRender(responseObj.currentActivityItemId));
			  		form.getForm().findField("lastDateForConfirmation").setValue(dateRender(responseObj.lastDateForConfirmation));
			  		form.getForm().findField("referenceLetterSubmissionDeadline").setValue(dateRender(responseObj.referenceLetterSubmissionDeadline));
			  		
			  		var currentActivityItemIdField = form.down("#currentActivityItemId");
			  		currentActivityItemIdField.reset();
			  		currentActivityItemIdField.clearValue();
    				if(responseObj.admissionConfigurationCurrentActivity.length>0){
    					currentActivityItemIdField.getStore().load({
            				callback: function(records, operation, success) {
            					if (success) {
            						var admissionConfigCurrentActivityJsonArry= [];
            						if(records.length > 0){
            							responseObj.admissionConfigurationCurrentActivity.forEach(function(currentActivityObj){
            								var result = records.filter(function (obj) {
            									  return obj.data.id === currentActivityObj.currentActivity.id;
            									})[0];
            								admissionConfigCurrentActivityJsonArry.push(result);
            							});
            							currentActivityItemIdField.setValue(admissionConfigCurrentActivityJsonArry);
            						}
            					}
            				}
            	        });
    				}	
			  		
    				var eligibilityRecommendationField = form.down("#eligibilityRecommendation");
    				eligibilityRecommendationField.reset();
    				eligibilityRecommendationField.clearValue();
    				if(responseObj.admissionSetupPreEligiblity.length>0){
    					eligibilityRecommendationField.getStore().load({
            				callback: function(records, operation, success) {
            					if (success) {
            						var admissionConfigEligibilityRecommendationJsonArry= [];
            						if(records.length > 0){
            							responseObj.admissionSetupPreEligiblity.forEach(function(eligibilityRecommendationObj){
            								var result = records.filter(function (obj) {
            									  return obj.data.id === eligibilityRecommendationObj.preEligiblityId.id;
            									})[0];
            								admissionConfigEligibilityRecommendationJsonArry.push(result);
            							});
            								eligibilityRecommendationField.setValue(admissionConfigEligibilityRecommendationJsonArry);
            						}
            					}
            				}
            	        });
    				} else if(eligibilityRecommendationField.hidden == true) {
    					eligibilityRecommendationField.allowBlank = false;
    					eligibilityRecommendationField.setDisabled(true);
    				}
					 offerLaterIssueProcessField.store.load({
						  callback: function(records, operation, success) {
							  var id;
							  for(var i=0; i<records.length; i++){
								  var id = records[i].data.id;
								  var offerLaterIssuePro = responseObj.offerLetterIssueProcess;
								  if(offerLaterIssuePro == null){
									  offerLaterIssuePro = 'MANUAL'; 
								  }
								  if(id == offerLaterIssuePro){
									  offerLaterIssueProcessField.setValue(id); 
								  }
							  }
						  }
					  });
					 proOfferLaterIssueProcessField.store.load({
						  callback: function(records, operation, success) {
							  var id;
							  for(var i=0; i<records.length; i++){
								  var id = records[i].data.id;
								  var proOfferLaterIssuePro = responseObj.proOfferLetterIssueProcess;
								  if(proOfferLaterIssuePro == null){
									  proOfferLaterIssuePro = 'MANUAL'; 
								  }
								  if(id == proOfferLaterIssuePro){
									  proOfferLaterIssueProcessField.setValue(id); 
								  }
							  }
						  }
					  });
		  	  	}
		  	  	else{
		  	  	 offerLaterIssueProcessField.store.load({
					  callback: function(records, operation, success) {
						  var id;
						  for(var i=0; i<records.length; i++){
							  var id = records[i].data.id;							
							  if(id == 'MANUAL'){
								  offerLaterIssueProcessField.setValue(id); 
							  }
						  }
					  }
				  });
				 proOfferLaterIssueProcessField.store.load({
					  callback: function(records, operation, success) {
						  var id;
						  for(var i=0; i<records.length; i++){
							  var id = records[i].data.id;
							  if(id == 'MANUAL'){
								  proOfferLaterIssueProcessField.setValue(id); 
							  }
						  }
					  }
				  });
				 
				    form.down("#eligibilityRecommendation").setVisible(false);
		  			form.down("#eligibilityRecommendation").allowBlank=true;
		  	  	}
		  	}
	  	});
	},
	loadApplicationSettings: function(form) {
		var url = SERVERURL.PATH_GET_APPLICATION_SETTING_CONFIGURATION;
		url = url.concat('?programSelectionProcessId='+this.getProgramSelectionProcessId()); 
		this.sendGetAjaxRequest(url, 'GET', null, function(opt,success,response){
		  	if(success){
		  	  	if(!isNullOrEmpty(response.responseText)) {
			  		var responseObj = Ext.decode(response.responseText);
			  		form.getForm().setValues(responseObj);
			  		
					form.down("#formSaleStartDate").setValue(dateRender(responseObj.formSaleStartDate));
					form.down("#formSaleEndDate").setValue(dateRender(responseObj.formSaleEndDate));
					form.down("#formSubmissionStartDate").setValue(dateRender(responseObj.formSubmissionStartDate));
			  		form.down("#formSubmissionEndDate").setValue(dateRender(responseObj.formSubmissionEndDate));
			  		}
			  		
		  	  	}
		  	
	  	});
	},

    /*
     * 	********************** Common Methods ********************* 
     */  
   
    /**
     * private method for adding a tab in the inner tab structure (AdmissionCycleStructure). 
     * @param {Object} tabTitle the title of the tab which has to be added, it should be the translated value.
     * @param {Object} contentXType The xtype of the item that has to be inserted.
     */
    addTab: function(tabTitle, contentXType) {
        var admissionStructure = this.getAdmissionCycleStructure();
        var admissionTabPanel = admissionStructure.down('tabpanel');
        var innerPanel = admissionTabPanel.items.findBy(function(tab) {
            return tab.title === tabTitle;
        });
        if (!innerPanel) {
            innerPanel = admissionTabPanel.add({
                xtype: contentXType,
                title: tabTitle,
                closable: true
            });
        }
        admissionTabPanel.setActiveTab(innerPanel);
        return innerPanel;
    },
    
    /**
     * method to close the passed formWindow
     * @param {Object} windowAlias: alias of the window that has to be closed.
     * @param {Object} windowReference: reference of the form that has to be closed.
     */
    closeFormWindow: function(windowReference) {
    	if(windowReference != null || windowReference != undefined) {
        	windowReference.close();
        } 
    },
    
    /**
     * method to toggle the tabs if enabled/disabled.
     * @param {Object} tabReference is the reference of the tab in which the tabs should be disabled/enabled
     * @param {Boolean} enableDisableFlag is the boolean flag to be passed, if true then all the
     *  tabs except the first tab will be disabled. If false then all the tabs except the first tab will be enabled.
     */
    toggleTabsVisibility: function(tabReference, enableDisabledFlag) {
    	Ext.each(tabReference.items.items, function(item) {
			if(item.itemId != "selectionSettingsStructure") {
				item.setDisabled(enableDisabledFlag);
			}
		});
    },
    
    /**
     *  common method to save the checklist items on "admission setting" and "application setting" tabs.
     *  @param {Object} button is the reference of the button that is clicked.
     *	@param {String} applicableAt The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    saveCheckListItems: function(button, applicableAt) {
    	var this$ = this;
    	var form = button.up('form');
    	var formValues = form.getValues();
    	var submitData = new Array();
    	Ext.each(formValues.checkListCombo, function(rec){
    		var checkListItem = new Object();
    		checkListItem.programSelectionProcessId = this$.getProgramSelectionProcessId();
    		if(rec instanceof Object) {
				checkListItem.checklistItemId = rec.get('id');
			} else {
				checkListItem.checklistItemId = rec;
			}
    		checkListItem.applicableAt = applicableAt;
    		submitData.push(checkListItem);
    	});
    	/*
    	 * call to the method from the base controller which fires an ajax request and calls the callback function.
    	 */
    	this.sendSaveAjaxRequest(SERVERURL.PSP_APPLICATION_CHECKLIST_SAVE, 'POST', Ext.encode(submitData), function(opt,success,response){
		  	if(success){
		  		if(applicableAt === "APPLICATION") {
		  			showSuccessMessage(getAdmissionTranslation('APPLICATION_SETTING'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));	
		  		} else {
		  			showSuccessMessage(getAdmissionTranslation('ADMISSION_SETTING'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
		  		}
		  		
		  	} else {
		  		if(applicableAt === "APPLICATION") {
		  			showErrorMessage(getAdmissionTranslation('APPLICATION_SETTING'), getCommonTranslation('FAILURE'));
		  		} else {
		  			showErrorMessage(getAdmissionTranslation('ADMISSION_SETTING'), getCommonTranslation('FAILURE'));
		  		}
		  	}
	  	});
    },
    
    /**
     * Method to load the documents grid from the Application setting and the Admission Setting tab.
     * Internally loads the stores of both the grids.
     * @param {Object} the reference of the grid which has to be loaded.
     * @param {String} The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    loadDocumentsGrid: function(grid, applicableAt) {
    	var store = grid.getStore();
    	var url = SERVERURL.PSP_APPLICATION_SETTING_FIND_BY_CRITERIA ;
    	var id = this.getProgramSelectionProcessId();
    	url = url.concat('?applicableAt='+applicableAt);
    	url = url.concat('&programSelectionProcessId='+id);
    	store.getProxy().api.read = url;
    	store.reload();
    },
    
    /**
     * This method is used to load the checklist component with the values that were saved previously.
     * @param {Object} the reference of the grid which has to be loaded.
     * 	@param {String} applicableAt The String value which is the identifier which will be ADMISSION/APPLICATION
     * based on the page/tab from where it is called.
     */
    loadCheckList: function(form, applicableAt) {
    	var url = SERVERURL.PSP_APPLICATION_CHECKLIST_GET;
    	var id = this.getProgramSelectionProcessId();
    	url = url.concat('?applicableAt='+applicableAt);
    	url = url.concat('&programSelectionProcessId='+id);
		this.sendSaveAjaxRequest(url, 'GET', null, function(opt,success,response){
		  	if(success){
		  		var responseObj = Ext.decode(response.responseText);
		  		var checkListItems = new Array();
		  		var combo = form.down('multiselectcombofield');
				Ext.each(responseObj, function(record) {
					checkListItems.push(record.checklistItemId);
				});
				combo.setValue(checkListItems);
		  	}
	  	});
	},
	
	/**
	 * method to perform the enabling disabling of the dates and min max seats components as per the selections in the previous tabs.
	 * Business rules: 1. Seat Limits to be shown only if no mandatory quota is specified in "Quota Type Applicability" grid.
	 * 2. Start & End Dates to be shown only if Selection Mechanism is "Selection in Batches" as set in Selection Settings tab.
	 */
	doStageSettingValidations: function(panel) {
		/*get the reference of the QTA grid
			get the first record
			get the checkbox state, if selected or no
			accordingly hide or show the seatLimits */
		
		var this$=this;
		var stageSettingForm = panel.down('form');
		var seatLimits = stageSettingForm.query('numberfield');
		
		var qtaGrid = this.getQuotaTypeApplicabilityGrid();
		var store = qtaGrid.getStore();
		var record = store.getAt(0);
		
		var distributionBasis='SEATS';
		store.each(function(rec) {
			if(rec.raw.distributionBasis=="PERCENTAGE"){
				distributionBasis="PERCENTAGE";
				return false;
			}
		});
		if(!isNullOrEmpty(record)) {
			if(record.raw.whetherMandatory && distributionBasis=="SEATS") {
				Ext.each(seatLimits, function(field) {
					this$.setVisibleAndNullable(field,false);
				});
			} else {
				Ext.each(seatLimits, function(field) {
					this$.setVisibleAndNullable(field,true);
				});
			}
		}
		/* get The reference of the selectionSettingtab
		   get the reference of the selectionMechanism Radio
		   check the value, if "Selection In Batches" then show start and end dates else hide. */
		var selectionSettingsForm = this.getSelectionSettingsForm(); 
		var selectionMode = selectionSettingsForm.down('#selectionMode');
		var dateFields = stageSettingForm.query('datefield');
		var selectionModeValue=selectionMode.getValue();
		if(isNullOrEmpty(selectionModeValue)){
			var weatherSelectionInBatchesRadio = selectionSettingsForm.down('radiogroup#whetherSelectionInBatches');
			selectionModeValue=weatherSelectionInBatchesRadio.getValue().whetherSelectionInBatches;
		}
		if (selectionModeValue=="false"||selectionModeValue==false) {
			Ext.each(dateFields, function(field) {
				this$.setVisibleAndNullable(field,false);
			});
		} else {
			Ext.each(dateFields, function(field) {
				this$.setVisibleAndNullable(field,true);
			});
		}
	},
	/**
	 * This method make field visible and allowBlank to !visible
	 * field.setVisible(visible);
	 * field.allowBlank=!visible;
	 */
	setVisibleAndNullable:function(field,visible){
		field.setVisible(visible);
		field.setDisabled(!visible);
		field.allowBlank=!visible;
	},
	
	/**
	 * method to add the red * for the records whose quota Type is mandatory.
	 * @param store is the reference of the quota Setting grid Store 
	 * @param records are the records of the store.
	 * @author akshay.kalbhor
	 */
	markMandatoryValidation: function(store) {
		var quotaSettingGrid = this.getQuotaSettingGrid();
		var quotaTypeCombo = quotaSettingGrid.down('combo');
		var quotaSettingStore = store;
		var records = quotaSettingStore.data.items;
		if(quotaTypeCombo.valueModels[0].get('whetherMandatory')) {
			Ext.each(records, function(record) {
				var editedValue = record.get('programSelectionProcessStage').value + '<font color=red>*</font>';
				record.data.programSelectionProcessStage.value = editedValue;
			});
		}
	},
	/**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var pgcgrid  = this.getProgramGroupCombinationsGrid();
   		var viewConfigureButton = pgcgrid.down('#viewConfigureCombination');
   		var copyConfigureCombinationButton =  pgcgrid.down('#copyConfigureCombination');
   		
        	
   		viewConfigureButton.setVisible(false);
   		copyConfigureCombinationButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		 if(privilege === 'VIEWCONFIGURE'){
           		if(!isNullOrEmpty(viewConfigureButton)){
           			viewConfigureButton.setVisible(true);
           		}
           	}else if(privilege === 'COPYCONFIGCOMB'){
           		if(!isNullOrEmpty(copyConfigureCombinationButton)){
           			copyConfigureCombinationButton.setVisible(true);
           		}
           	}
       	});
       },
       checkFeePlanStatus: function(id) {
    	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	   Ext.Ajax.request({
    		   type: 'rest',
    		   method: "GET",
    		   url: SERVERURL.PATH_FIND_FEE_PLANSTATUS+'?feePlanId='+id,
    		  // jsonData: formValues,
    		   headers: {
    			   'Content-Type': 'application/json'
    		   },
    		   success: function(form, action) {
    			   Ext.getBody().unmask();
    			   if(form.responseText=='InActive')
    			   {
    				   showSuccessMessage(getAdmissionTranslation('STAGE_SETTING'), getAdmissionTranslation('GET_FEE_PLANS_STATUS_INACTIVE'));
    			   }else
    			   {
    				   showSuccessMessage(getAdmissionTranslation('STAGE_SETTING'), getAdmissionTranslation('GET_FEE_PLANS_STATUS_ACTIVE'));
    			   }

    		   }
    	   });


       },
       checkFeePlanRuleStatus: function(id) {
    	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	   Ext.Ajax.request({
    		   type: 'rest',
    		   method: "GET",
    		   url: SERVERURL.PATH_FIND_FEE_PLAN_RULE_STATUS+'?feePlanRuleId='+id,
    		  // jsonData: formValues,
    		   headers: {
    			   'Content-Type': 'application/json'
    		   },
    		   success: function(form, action) {
    			   Ext.getBody().unmask();
    			   if(form.responseText=='InActive')
    			   {
    				   showSuccessMessage(getAdmissionTranslation('STAGE_SETTING'), getAdmissionTranslation('GET_FEE_PLANS_RULES_STATUS_INACTIVE'));
    			   }else
    			   {
    				   showSuccessMessage(getAdmissionTranslation('STAGE_SETTING'), getAdmissionTranslation('GET_FEE_PLANS_RULES_STATUS_ACTIVE'));
    			   }

    		   }
    	   });


       },
       disableFilters : function(combo){
    	   var appForm = combo.up('form');
    	   var seatTypeCombo = appForm.down('#seatType'); 
    	   var batchCombo = appForm.down('#batch'); 
    	   var programCombo = appForm.down('#program');
    	   programCombo.reset();
    	   seatTypeCombo.reset();
    	   batchCombo.reset();
    	   seatTypeCombo.setDisabled(true);
    	   batchCombo.setDisabled(true);
    	   
       },
       disableProgramgroupcombinationsgridButton:function(column,selected, grid) {
    	var $this = this;
       	var filter = $this.getAdmissioncyclesetupfilter();
    	var notConfiureCombination = filter.down('#notConfiureCombination').getValue();
       	var viewConfigureCombinationButton = grid.down('#viewConfigureCombination');
    	var copyConfigureCombinationButton = grid.down('#copyConfigureCombination');
    	if(!isNullOrEmpty(notConfiureCombination) && notConfiureCombination == true) {
    		viewConfigureCombinationButton.setDisabled(false);
    		copyConfigureCombinationButton.setDisabled(false);
    	}else{
    		copyConfigureCombinationButton.setDisabled(true);
    		var selectionLength = selected.length;
        	if (selectionLength > 1) {
        		viewConfigureCombinationButton.setDisabled(true);
        	}else{
        		viewConfigureCombinationButton.setDisabled(false);
        	}
    	}
       },
       loadDrool : function(panel) {
    	   var $this = this;
    	   var batchIds = $this.getAdmissionCycleStructure().down('#batchId').getValue();
    	   var droolStore = panel.down('#programSelectionDroolItemId').getStore();
    	   droolStore.getProxy().extraParams = {              
    		   applyFor:'SELECTION_STAGE',
    		   batchIds : batchIds
    	   };
    	   droolStore.load();
       },
        showMessageToUser : function(messageCount) {
    	   if (messageCount == 1) {
    		   showSuccessMessage(getAdmissionTranslation('SELECTION_PROCESS_SETTINGS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
		}
		},
		loadDFRForAdmissionSettingFormDFR: function(additionalConditionApplicableItemId,proOfferLetterExpiryDate){
   	   	var $this = this;
   	   	var field1 = true;
	   	var field2 = true;
	   	var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
	   	
   	   	Ext.Ajax.request({
   	   		type: 'rest',
   	   		async: false,
   	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
   	   		params: {
   	   			screenName: 'admissionsettingsform',
   	   			academyLocationId: this.getCurrentAcademyLocation(),
   	   			languageCode:'en'
   	   		},
   	   		method: 'GET',
   	   		success: function(res, action) {
   	   			var response = Ext.decode(res.responseText);
   	   			if( Object.keys(response).length > 0 ){
   	   				var records=response.admissionsettingsform;
   	   				for(i in records){
   	   					if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='additionalConditionApplicableItemId' && records[i].isVisible==false){
   	   					  field1 = false;
   	   						additionalConditionApplicableItemId.setVisible(field1);
//   	   					additionalConditionApplicableItemId.allowBlank= true;
   	   					}
   	   				if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='proOfferLetterExpiryDate' && records[i].isVisible==false){
   	   				 field2 = false;
   	   				proOfferLetterExpiryDate.setVisible(field2);
//   	   				proOfferLetterExpiryDate.allowBlank= true;
   	   					}
   	   			if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='proOfferLetterExpiryDate' && records[i].isMandatory == true){
	   				  proOfferLetterExpiryDate.allowBlank = false;
	   				proOfferLetterExpiryDate.labelSeparator = '';
	   				proOfferLetterExpiryDate.setFieldLabel( getAdmissionTranslation('PROVISIONAL_OFFER_LETTER_EXPIRY_DATE')+allowblankFalse);
	   					}
   	   				}
   	   			}
   	   			additionalConditionApplicableItemId.setVisible(field1);
   	   			proOfferLetterExpiryDate.setVisible(field2);
   	   		}
   	   		
   	   	});
   	   	
   	 },
     loadDFRForOfferLetterExpiryDateDFR: function(offerLetterExpiryDate){
    	   	var $this = this;
    	 	var field1 = true;
    		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
    	   	Ext.Ajax.request({
    	   		type: 'rest',
    	   		async: false,
    	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    	   		params: {
    	   			screenName: 'admissionsettingsform',
    	   			academyLocationId: this.getCurrentAcademyLocation(),
    	   			languageCode:'en'
    	   		},
    	   		method: 'GET',
    	   		success: function(res, action) {
    	   			var response = Ext.decode(res.responseText);
    	   			if( Object.keys(response).length > 0 ){
    	   				var records=response.admissionsettingsform;
    	   				for(i in records){
    	   				if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='offerLetterExpiryDate' && records[i].isVisible==false){
    	   				  field1 = false;
    	   					offerLetterExpiryDate.setVisible(field1);
 	   					}
    	   				if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='offerLetterExpiryDate' && records[i].isMandatory==true){
      	   					offerLetterExpiryDate.allowBlank = false;
      	   				offerLetterExpiryDate.labelSeparator = '';
      	   			   offerLetterExpiryDate.setFieldLabel( getAdmissionTranslation('OFFER_LETTER_EXPIRY_DATE')+allowblankFalse);
   	   					}
    	   				}
    	   			}
    	   			offerLetterExpiryDate.setVisible(field1);
    	   		}
    	   		
    	   	});
    	   	
    	 },
    	 
    	 loadDFRForOfferLetterIssuancePetentialDFR: function(offerLetterIssuancePotential){
     	   	var $this = this;
     	 	var field1 = true;
     		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
     	   	Ext.Ajax.request({
     	   		type: 'rest',
     	   		async: false,
     	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
     	   		params: {
     	   			screenName: 'admissionsettingsform',
     	   			academyLocationId: this.getCurrentAcademyLocation(),
     	   			languageCode:'en'
     	   		},
     	   		method: 'GET',
     	   		success: function(res, action) {
     	   			var response = Ext.decode(res.responseText);
     	   			if( Object.keys(response).length > 0 ){
     	   				var records=response.admissionsettingsform;
     	   				for(i in records){
     	   				if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='offerLetterIssuancePotential' && records[i].isVisible==false){
     	   				  field1 = false;
     	   				offerLetterIssuancePotential.setVisible(field1);
  	   					}
     	   				if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='offerLetterIssuancePotential' && records[i].isMandatory==true){
     	   				offerLetterIssuancePotential.allowBlank = false;
     	   			offerLetterIssuancePotential.labelSeparator = '';
     	   		offerLetterIssuancePotential.setFieldLabel( getAdmissionTranslation('OFFER_LETTER_ISSUANCE_POTENTIAL')+allowblankFalse);
    	   					}
     	   				}
     	   			}
     	   		offerLetterIssuancePotential.setVisible(field1);
     	   		}
     	   		
     	   	});
     	   	
     	 },
    	
    	 loadDFRForAutoAdmissionApprove: function(autoAdmissionApprovalCheckbox,checkForEligibilityCheckbox) {
    		 var $this = this;
    	   	   	Ext.Ajax.request({
    	   	   		type: 'rest',
    	   	   		async: false,
    	   	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    	   	   		params: {
    	   	   			screenName: 'admissionsettingsform',
    	   	   			academyLocationId: this.getCurrentAcademyLocation(),
    	   	   			languageCode:'en'
    	   	   		},
    	   	   		method: 'GET',
    	   	   		success: function(res, action) {
    	   	   			var response = Ext.decode(res.responseText);
    	   	   			if( Object.keys(response).length > 0 ){
    	   	   				var records=response.admissionsettingsform;
    	   	   				for(i in records){
    	   	   					if(records[i].formFieldInputType=='checkbox' && records[i].formFieldId=='whetherAutoAdmissionApproval' && records[i].isVisible==false){
    	   	   					    autoAdmissionApprovalCheckbox.setVisible(false);
    	   	   					    checkForEligibilityCheckbox.setVisible(false);
    	   	   					}else{
    	   	   					    if (autoAdmissionApprovalCheckbox.checked) {
    	   	   					    	if(records[i].formFieldInputType=='checkbox' && records[i].formFieldId=='checkForEligibilityBeforeApproveAdmissionAutomatically' && records[i].isVisible==true){
    	   	   					    		checkForEligibilityCheckbox.setVisible(true);
    	   	   					    	}
    	   	        	            } else {
    	   	        	            	checkForEligibilityCheckbox.reset();
    	   	        	            	checkForEligibilityCheckbox.setVisible(false);
    	   	        	            }
    	   	   					}
    	   	   				}
    	   	   			}else{
    	   	   				if (autoAdmissionApprovalCheckbox.checked) {
    	   	   					checkForEligibilityCheckbox.setVisible(true);
    	   	   				} else {
    	   	   				    checkForEligibilityCheckbox.reset();
	        	            	checkForEligibilityCheckbox.setVisible(false);
	        	            }
    	   	   			}
    	   	   		}
    	   	   	});
 		},
 		loadDFRForEligibilityBeforeApproveAdmissionAutomatically: function(checkForEligibilityBeforeApproveAdmissionAutomatically,eligibilityRecommendation) {
   		 var $this = this;
   	   	   	Ext.Ajax.request({
   	   	   		type: 'rest',
   	   	   		async: false,
   	   	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
   	   	   		params: {
   	   	   			screenName: 'admissionsettingsform',
   	   	   			academyLocationId: this.getCurrentAcademyLocation(),
   	   	   			languageCode:'en'
   	   	   		},
   	   	   		method: 'GET',
   	   	   		success: function(res, action) {
   	   	   			var response = Ext.decode(res.responseText);
   	   	   			if( Object.keys(response).length > 0 ){
   	   	   				var records=response.admissionsettingsform;
   	   	   				for(i in records){
   	   	   					if(records[i].formFieldInputType=='checkbox' && records[i].formFieldId=='checkForEligibilityBeforeApproveAdmissionAutomatically' && records[i].isVisible==false){
   	   	   				       checkForEligibilityBeforeApproveAdmissionAutomatically.setVisible(false);
   	   	   				       checkForEligibilityBeforeApproveAdmissionAutomatically.reset();
   	   	   		               eligibilityRecommendation.setVisible(false);
   	   	   		               eligibilityRecommendation.allowBlank = true;
   	   	   		               eligibilityRecommendation.reset();
   	   	   					}else{
   	   	   					    if (checkForEligibilityBeforeApproveAdmissionAutomatically.checked) {
   	   	   					    	if(records[i].formFieldInputType=='multiselectcombofield' && records[i].formFieldId=='eligibilityRecommendation' && records[i].isVisible==true){
   	   	   					         eligibilityRecommendation.setVisible(true);
   	   	   					         eligibilityRecommendation.allowBlank = false;
   	   	   					    	}
   	   	   					    	else if(records[i].formFieldInputType=='multiselectcombofield' && records[i].formFieldId=='eligibilityRecommendation' && records[i].isVisible==false){
	   	   					         eligibilityRecommendation.setVisible(false);
	   	   					         eligibilityRecommendation.allowBlank = true;
	   	   					    	}
   	   	        	            }
   	   	   					    else {
   	   	        	                eligibilityRecommendation.reset();
   	   	        	                eligibilityRecommendation.setVisible(false);
   	   	        	                eligibilityRecommendation.allowBlank = true;
   	   	        	            }
   	   	   					}
   	   	   				}
   	   	   			}else{
   	   	   				if (checkForEligibilityBeforeApproveAdmissionAutomatically.checked) {
   	   	   					eligibilityRecommendation.setVisible(true);
   	   	   				} else {
   	   	   			        checkForEligibilityBeforeApproveAdmissionAutomatically.reset();
   	   	   	                eligibilityRecommendation.setVisible(false);
	        	            }
   	   	   			}
   	   	   		}
   	   	   	});
		},
    	 getJsonObject: function(key, value, additionalValue) {
    	        if (value != '' && additionalValue == undefined) {
    	            return {
    	                "paramCode": key,
    	                "paramValues": [value]
    	            };
    	        } else if (value != '' && additionalValue != undefined) {
    	            return {
    	                "paramCode": key,
    	                "paramValues": [value, additionalValue]
    	            };
    	        }
    	    },
    	    
    	 createSearchCriteriaString: function() {
    	        var formValues = new Array();
    	       var filter= this.getAdmissioncyclesetupfilter();
    	        formValues = filter.getValues();        
    	        var searchCriteriaString="";
    	        for (var key in formValues) {
    	        	var value = formValues[key];            
    	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' ){
    	                var keyValueJsonObject = this.getJsonObject( key , value);
    	                if(keyValueJsonObject != undefined && filter.getForm().findField(key) != null){
    	                	searchCriteriaString=searchCriteriaString+filter.getForm().findField(key).fieldLabel+"  : "+filter.getForm().findField(key).getRawValue() + " ,";
    	                }
    	                }
    	        }
    	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    	        return searchCriteriaString;
    	    },
    		getVisibleColumns:function(grid){
    			var visibleColumns=new Array();
    			var columns=new Array();
    			columns=grid.columnManager.columns;
    			var order=0;
    			Ext.each(columns,function (column){
    				if(column!=undefined && order>0){
    				var visibleColumn=new Object();
    				visibleColumn.resultKey=column.dataIndex;
    				visibleColumn.displayCode=column.text;
    				visibleColumn.displayOrder=order;
    				visibleColumns.push(visibleColumn);
    				}
    				order++;
    			});
    			
    			return visibleColumns;
    		},
    		
    	 exportExcelAll: function(grid,isPDFAllExport,isExcelAllExport) {
    		    var $this = this;
    			var filter = this.getAdmissioncyclesetupfilter();
    			var alId=filter.down('#academyLocationCombo').getValue();
    	    	var intakeYearId = filter.down('#intakeYearItemId').getValue();
    	    	var programGroupId = filter.down('#Program_Group').getValue();
    	    	var endDate = filter.down('#END_DATE').getValue();
    	    	var startDate = filter.down('#START_DATE').getValue();
    	    	var admissionCycleStatus = filter.down('#admissionCycleStatus').getValue();
    	    	var notConfiureCombination = filter.down('#notConfiureCombination').getValue();
    	    	var userId = this.getCurrentlyLoggedInUser().code;
    	    	var academyLocationId =this.getCurrentAcademyLocation();
    	    	var searchCriteriaString=this.createSearchCriteriaString(filter);
     	    	var searchResultViewColumns=new Array();
    	    	var programGroupCombinationsGrid =  this.getProgramGroupCombinationsGrid();
		    	var visibleColumns=this.getVisibleColumns(programGroupCombinationsGrid); 
		    	var gridName = programGroupCombinationsGrid.title;
		    	
    	    	var json=new Object();
    	    	json.intakeYearId=intakeYearId;
    	    	json.academyLocationId =this.addValueInArray(json.academyLocationId,alId);
    	    	json.programGroupId=programGroupId;
    	    	json.endDate=endDate;
    	        json.startDate=startDate;
    	    	json.admissionCycleStatus=admissionCycleStatus;
    	    	json.notConfiureCombination=notConfiureCombination;
    	    	json.page=1;
    	    	json.start=0;
    	    	json.limit=-1;
    	    	var exportListDTO= new Object();
    	    	exportListDTO.userId=userId;
    	    	exportListDTO.searchCriteriaString=searchCriteriaString;
    	    	exportListDTO.academyLocationId=academyLocationId;
    	    	exportListDTO.searchResultViewColumns=visibleColumns;
    	    	exportListDTO.reportTitle=gridName;
    	    	json.exportListDTO=exportListDTO;
    	    	
    	          filetype="application/.vnd.ms-excel";
                       var csvForm = Ext.create('Ext.form.Panel',{
    	    		              items:[{
    	    		                  xtype : 'textfield',
    	    		                  maxLength:1000000,
    	    		                  itemId : 'exportDocumentData',
    	    		                  name : 'exportDocumentData'
    	    		              }]
    	    		          }); 
    	    		          csvForm.down('#exportDocumentData').setValue(Ext.encode(json));
    	    		          csvForm.getForm().submit({
    	    			           
    	    		              target: '_blank',
    	    		              method:'POST',
    	    		              params :{access_token : Ext.Ajax.defaultHeaders.access_token},
    	    		            headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	    		              url :SERVERURL.EXPORT_EXCEL_DATA,
    	    	              	 standardSubmit :true,
    	    		            });

		},
		downloadUploadFormChangeImportAdmissionSetupUpdates: function(cb, nv, ov) {
	           var $this = this;
	           var downloadTemplateAdmisisonSetupUpdatesForm = $this.getAdmissionsetupupdatesdownloadform();
	           var uploadTemplateAdmissionSetupUpdatesForm = $this.getAdmissionsetupupdatesuploadform();
	           var grid = $this.getImportadmissionsetupupdatesgrid();
	           if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
	        	   uploadTemplateAdmissionSetupUpdatesForm.hide();
	        	   uploadTemplateAdmissionSetupUpdatesForm.down('#moduleName').allowBlank=true;
	        	   uploadTemplateAdmissionSetupUpdatesForm.down('#uploadFileField').allowBlank=true;
	        	   downloadTemplateAdmisisonSetupUpdatesForm.down('#academyLocationCombo').allowBlank=false;
	        	   downloadTemplateAdmisisonSetupUpdatesForm.show();
	               grid.setVisible(false);
	               downloadTemplateAdmisisonSetupUpdatesForm.isValid();
	               downloadTemplateAdmisisonSetupUpdatesForm.getForm().reset();
	           } else {
	        	   downloadTemplateAdmisisonSetupUpdatesForm.hide();
	        	   //$this.doAccessControlValidationForLoader(uploadTemplateAdmissionSetupUpdatesForm,this.getCORE_ERP_LOADER_PERMISSIONS());
	        	   var uploadoptionradiogroupform  = $this.getImportAdmissionSetupUpdatesRadioGroup();
	        	   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	        		   isUploadAll: false
	        	   });
	        	   downloadTemplateAdmisisonSetupUpdatesForm.down('#academyLocationCombo').allowBlank=true;
	        	   uploadTemplateAdmissionSetupUpdatesForm.down('#moduleName').allowBlank=false;
	        	   uploadTemplateAdmissionSetupUpdatesForm.down('#uploadFileField').allowBlank=false;
	        	   uploadTemplateAdmissionSetupUpdatesForm.show();
	               grid.setVisible(true);
	               uploadTemplateAdmissionSetupUpdatesForm.isValid();
	               uploadTemplateAdmissionSetupUpdatesForm.down('#uploadFileField').reset();
	               //uploadTemplateAdmissionSetupUpdatesForm.getForm().reset();
	               
	           }
	       },
	       getAdmissionSetupDownloadLoaderJson:function(formValues){
           	$this = this;
		    	var obj = new Object();
	            if(!isNullOrEmpty(formValues.academyLocationCombo)) {
	            	obj.academyLocationId = formValues.academyLocationCombo;
	            }
	            if(!isNullOrEmpty(formValues.intakeYear)) {
	            	obj.intakeYearId = formValues.intakeYear;
	            }
	            if(!isNullOrEmpty(formValues.programGroup)) {
	            	obj.programGroupId = formValues.programGroup;
	            }
	            if(!isNullOrEmpty(formValues.PROGRAM)) {
	            	obj.programId = formValues.PROGRAM;
	            }
	            if(!isNullOrEmpty(formValues.BATCH)) {
	            	obj.batchId = formValues.BATCH;
	            }
	            if(!isNullOrEmpty(formValues.SEAT_TYPE)) {
	            	obj.seatTypeId = formValues.SEAT_TYPE;
	            }
	            if(!isNullOrEmpty(formValues.admissionCycleStatus)) {
	            	obj.admissionCycleStatus = formValues.admissionCycleStatus;
	            }
	            if(!isNullOrEmpty(formValues.START_DATE)) {
	            	obj.dateFrom = formValues.START_DATE;
	            }
	            if(!isNullOrEmpty(formValues.END_DATE)) {
	            	obj.dateTo = formValues.END_DATE;
	            }
		    	return Ext.encode(obj);	
		    },
		    getDownloadFileAdmissionSetup: function(documentId, fileType) {
		        if (!isNullOrEmpty(documentId)) {
		            var csvForm = Ext.create('Ext.form.Panel');
		            csvForm.getForm().submit({
		                target: '_blank',
		                method: 'POST',
		                params: {
		                    access_token: Ext.Ajax.defaultHeaders.access_token
		                },
		                headers: {
		                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
		                },
		                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
		                standardSubmit: true
		            });
		        } 
		    },
		    /**
		     * this method is used to delete the Document in the Document grid which will be called from the Application setting
		     *  and the Admission Setting tab.
		     * @param {Object} button The reference of the button.
		     * @param {String} applicableAt The String value which is the identifier which will be ADMISSION/APPLICATION
		     * based on the page/tab from where it is called.
		     */
		    onAdmissionSetupDocumentDelete: function(button, applicableAt) {
		    	var grid = button.up('grid');
		    	if(grid.getSelectionModel().getCount()>0){
		    		var deleteIdArray = new Array();
		    		var record = grid.getSelectionModel().getSelection()[0];
		    		deleteIdArray.push(record.get("id"));
		    		var programSelectionArray = new Array();
			    	this.getProgramSelectionProcessMultipleIds()
		            var selectedlength=0;
		    		if(isNullOrEmpty(this.getProgramSelectionProcessMultipleIds())){
		    			showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		                    if (btn == 'yes') {
		                    	for(var j in deleteIdArray){
		                    	var url = SERVERURL.PSP_APPLICATION_SETTING_ADD_EDIT_DELETE;
		                        var id = deleteIdArray[j] ;
		                        url = url.concat('/'+id);
		                        Ext.Ajax.request({
		                            method: "DELETE",
		                            type: 'DELETE',
		                            url: url,
		                            headers: {
		                                'Content-Type': 'application/json'
		                            },
		                            success: function(form, action) {
		                            	grid.getStore().load();
		                            	grid.getSelectionModel().deselectAll(true);
										if(selectedlength==deleteIdArray.length-1){
		                            	 if(applicableAt === "APPLICATION") {
		                  		  			showSuccessMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));	
		                  		  		} else {
		                  		  			showSuccessMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
		                  		  		}
									  }
									  selectedlength++;
		                            }
		                        });
		                    }}
		                });	
		    		}else{
		    			var programSelectionArray = this.getProgramSelectionProcessMultipleIds();
		    			showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		                    if (btn == 'yes') {
		                    	 for(var k in programSelectionArray){
		                    	var formValues = new Object();
				    	     	formValues.programSelectionProcessId = programSelectionArray[k];
				    	     	formValues.documentType = record.data.documentType;
				    	     	formValues.id = record.get("id");
		                    	var url = SERVERURL.PATH_DELETE_DOC_BY_PROGRAM_SELECTION_PROCESS_ID;
		                        url = url;
		                        Ext.Ajax.request({
		                            method: "DELETE",
		                            type: 'DELETE',
		                            jsonData: formValues,
		                            url: url,
		                            headers: {
		                                'Content-Type': 'application/json'
		                            },
		                            success: function(form, action) {
		                            	grid.getStore().load();
		                            	grid.getSelectionModel().deselectAll(true);
										if(selectedlength==programSelectionArray.length-1){
		                            	 if(applicableAt === "APPLICATION") {
		                  		  			showSuccessMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));	
		                  		  		} else {
		                  		  			showSuccessMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
		                  		  		}
									  }
									  selectedlength++;
		                            }
		                        });
		                    }
		    			 }
		                });	
		    	   	   
		    		}
		    		
		    	} else {
		    		if(applicableAt === "APPLICATION") {
		    			showWarningMessage(getAdmissionTranslation('APPLICATION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		      		} else {
		      			showWarningMessage(getAdmissionTranslation('ADMISSION_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		      		}
		    	}
		    },
}); 
