/**
 * This controller is used for New Applicant Portal Setup
 * @author Prakash Sharma
 * FIXME: [AKR] Extend the BASE CONTROLLER
 */
Ext.define('Academia.controller.admission.applicantPortalSetup.ApplicantPortalSetupController', {
    extend: 'Academia.controller.base.BaseController',
    
    models: ['Academia.model.applicantportalsetup.UploadGuidelinesDocumentModel',
    	'Academia.model.authentication.FormPersonalInfoFieldInfoModel',
    	'Academia.model.applicantportalsetup.UploadGuidelinesDocumentModel'],
    stores: ['user.UserAcademyLocationStore', 'program.ProgramByGroupIdStore',
    		'common.BatchesByProgramId', 'common.SeatTypesByBatchId','Academia.store.applicantPortalSetup.ApplicantPortalSetupGridStore','applicantPortalSetup.stoAdmApplicantPortalSetUpGrid',
    		'applicantPortalSetup.stoAdmAcademyLocationAPSetupMappingList','common.AcademyLocationByName','applicantPortalSetup.stoAdmApplicantPortalSetupMappingGridStore','feeandpayment.ALProgramSearchCombo',
    		'feeandpayment.ALProgramList','feeandpayment.ALProgramBatchList','feeandpayment.ALProgramBatchSearchCombo','feeandpayment.ALProgramBatchSeatTypeList',
    		'applicantPortalSetup.StoAdmApplicantPortalConfigureScreenStore','applicantPortalSetup.StoAdmApplicantPortalCustomColumnSetUpStore',
    		'applicantPortalSetup.StoAdmApplicantPortalDataRequirementSetUpStore','applicantPortalSetup.GuidelinesDocumentListStore','feeandpayment.MappingStatus',
    		'examCenter.AssignSequence.ExamintionRemarkGridStore','applicantPortalSetup.AppPortalApplicationStatusStore','applicantPortalSetup.DashboardGuidelinesDocumentListStore',
    		'applicantPortalSetup.StoAdmApplicantPortalConfigureScreenStore','applicantPortalSetup.DefaultProgramApplicantPortalSetUpStore'],
    views: ['Academia.view.applicantportalsetup.ApplicantPortalSetupView',
            'Academia.view.applicantportalsetup.ApplicantPortalSetupGrid',
            'Academia.view.applicantportalsetup.ApplicantPortalSetupForm',
            'Academia.view.applicantportalsetup.ApplicantPortalSetupFilter','applicantportalsetup.VWAdmAddApplicantSetUpNameWin',
            'applicantportalsetup.VWAdmApplicantPortalSetUpForm','baselayout.contentarea.ContentPanel','applicantportalsetup.VWAdmApplicantPortalSetUpGrid',
            'applicantportalsetup.VWAdmApplicantPortalSetupMappingStructure','applicantportalsetup.VWAdmApplicantPortalSetupMappingResultStructure',
            'applicantportalsetup.VWAdmApplicantPortalSetupMappingResultGrid','applicantportalsetup.VWAdmAddApplicantPortalSetupMappingTab','applicantportalsetup.VMAdmApplicantPortalSetUpProgressTracker',
            'applicantportalsetup.VMAdmApplicantPortalSetupWithProgramBatchSeatStructure','applicantportalsetup.VMAdmAcademyLocationGridForSetupMapping','applicantportalsetup.VWAdmAlProgramGrid',
            'applicantportalsetup.VWAdmAlProgramBatchGrid','applicantportalsetup.VWAdmAlProgramBatchSeatTypeGrid','applicantportalsetup.VWAdmApplicantPortalSetupMappingAlertWin',
            'applicantportalsetup.StcAdmApplicantPortalConfigureScreen','applicantportalsetup.VWAdmApplciantPortalConfigureScreenGrid','applicantportalsetup.VWAdmApplicantSetupHelpTextForm',
            'applicantportalsetup.VWAdmApplicantPortalSetupCustomColumnGrid','applicantportalsetup.VWAdmApplicantPortalSetupDataRequirementGrid',
            'Academia.view.applicantportalsetup.HostelRequirementDataSetup','Academia.view.applicantportalsetup.PaymentAdditionalSetup','applicantportalsetup.VWAdmProgramDetailDataRequirementAPSetup',
            'Academia.view.applicantportalsetup.UploadDocRequirementDataSetup','Academia.view.applicantportalsetup.UploadDocumentList','Academia.view.applicantportalsetup.GuidelineDocumentForm',
            'applicantportalsetup.RenameApplicantSetupNameWin','Academia.view.applicantportalsetup.DataRequirementGridWithForm','applicantportalsetup.DashboardDataRequirementDataSetupPanel',
            'applicantportalsetup.DashboardDataRequirementDataSetup','applicantportalsetup.DashboardUploadDocumentList','applicantportalsetup.DashboardGuidelineDocumentForm','applicantportalsetup.VWAdmOnlinePaymentDataRequirementAPSetup',
            'applicantportalsetup.defaultProgramSetupView','applicantportalsetup.defaultProgramSetupConfigureScreen','applicantportalsetup.defaultProgramSetupConfigureScreenGrid','applicantportalsetup.defaultProgramDetailSetupHelpTextForm'],
            

    refs: [{
   	  ref: 'contentpanel',
	  selector: 'contentpanel'
    },{
        ref: 'applicantportalsetupfilter',
        selector: 'applicantportalsetupfilter'
    },{
        ref: 'applicantportalsetupgrid',
        selector: 'applicantportalsetupgrid'
    },{
        ref: 'vwadmaddapplicantsetupnamewin',
        selector: 'vwadmaddapplicantsetupnamewin'
    },{
        ref: 'vwadmapplicantportalsetupform',
        selector: 'vwadmapplicantportalsetupform'
    },{
        ref: 'vwadmapplicantportalsetupgrid',
        selector: 'vwadmapplicantportalsetupgrid'
    },{
        ref: 'vwadmapplicantportalsetupmappingstructure',
        selector: 'vwadmapplicantportalsetupmappingstructure'
    },{
        ref: 'vwadmapplicantportalsetupmappingresultgrid',
        selector: 'vwadmapplicantportalsetupmappingresultgrid'
    },{
        ref: 'vmadmacademylocationgridforsetupmapping',
        selector: 'vmadmacademylocationgridforsetupmapping'
    },{
        ref: 'vmadmapplicantportalsetupwithprogrambatchseatstructure',
        selector: 'vmadmapplicantportalsetupwithprogrambatchseatstructure'
    },{
        ref: 'vmadmapplicantportalsetupprogresstracker',
        selector: 'vmadmapplicantportalsetupprogresstracker'
    },{
        ref: 'vwadmaddapplicantportalsetupmappingtab',
        selector: 'vwadmaddapplicantportalsetupmappingtab'
    },{
        ref: 'vwadmalprogramgrid',
        selector: 'vwadmalprogramgrid'
    },{
        ref: 'vwadmalprogrambatchgrid',
        selector: 'vwadmalprogrambatchgrid'
    },{
        ref: 'vwadmalprogrambatchseattypegrid',
        selector: 'vwadmalprogrambatchseattypegrid'
    },{
        ref: 'vwadmapplicantportalsetupmappingalertwin',
        selector: 'vwadmapplicantportalsetupmappingalertwin'
    },{
        ref: 'vwadmapplciantportalconfigurescreengrid',
        selector: 'vwadmapplciantportalconfigurescreengrid'
    },{
        ref: 'vwadmapplicantsetuphelptextform',
        selector: 'vwadmapplicantsetuphelptextform'
    },{
		ref : 'vwadmapplicantsetuphelptextForm',
		selector : 'vwadmapplicantsetuphelptextform form'
	},{
		ref : 'stcadmapplicantportalconfigurescreen',
		selector : 'stcadmapplicantportalconfigurescreen'
	},{
		ref : 'vwadmapplicantportalsetupcustomcolumngrid',
		selector : 'vwadmapplicantportalsetupcustomcolumngrid'
	},{
		ref : 'vwadmapplicantportalsetupdatarequirementgrid',
		selector : 'vwadmapplicantportalsetupdatarequirementgrid'
	},{
		ref : 'hostelrequirementdatasetup',
		selector : 'hostelrequirementdatasetup'
	},
	{
		ref : 'paymentadditionalsetup',
		selector : 'paymentadditionalsetup'
	},{
		ref : 'vwadmprogramdetaildatarequirementapsetup',
		selector : 'vwadmprogramdetaildatarequirementapsetup'
	},{
		ref : 'vwadmonlinepaymentdatarequirementapsetup',
		selector : 'vwadmonlinepaymentdatarequirementapsetup'
	},{
		ref : 'renameapplicantsetupnamewin',
		selector : 'renameapplicantsetupnamewin'
	},
	{
		ref : 'uploaddocrequirementdatasetup',
		selector : 'uploaddocrequirementdatasetup'
	},
	{
		ref : 'uploaddocumentlist',
		selector : 'uploaddocumentlist'
	},
	{
		ref : 'guidelinedocumentform',
		selector : 'guidelinedocumentform'
	},{
		ref : 'applicantportalsetupview',
		selector : 'applicantportalsetupview'
	},{
		ref : 'applicantportalsetupform',
		selector : 'applicantportalsetupform'
	},{
		ref : 'dashboarddatarequirementdatasetup',
		selector : 'dashboarddatarequirementdatasetup'
	},{
		ref : 'dashboarduploaddocumentlist',
		selector : 'dashboarduploaddocumentlist'
	},{
		ref : 'dashboarddatarequirementdatasetuppanel',
		selector : 'dashboarddatarequirementdatasetuppanel'
	},{
		ref : 'dashboardguidelinedocumentform',
		selector : 'dashboardguidelinedocumentform'
	},{
		ref : 'defaultprogramsetupconfigurescreengrid',
		selector : 'defaultprogramsetupconfigurescreengrid'
	},{
		ref : 'defaultprogramdetailsetuphelptextform',
		selector : 'defaultprogramdetailsetuphelptextform'
	}
	],
    config: {
    	APPLICANT_PORTAL_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_SETUP_PROFILE_PRIVILEGES'),
    	APPLICANT_PORTAL_SETUP_DASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_SETUP_DASHBOARD_PRIVILEGE')
    },
    init: function(application) {
        this.control({
        				//applicant portal setup Grid listeners
        	
        	'applicantportalsetupfilter customcombobox[itemId=programGroupItemId]':{
				select:function(obj, record){
					var $this = this;
					var filter = $this.getApplicantportalsetupfilter();
					var programGroupId = record[0].data.id;
					var academyLocationId = filter.down("#academyLocationCombo").getValue();
					var batch = filter.down("#batchItemId");
					var seatType = filter.down("#seatTypeId");
					seatType.reset();
					seatType.setDisabled(true);
					batch.setDisabled(true);
					batch.reset();
					
					var program = filter.down("#programItemId");
					program.reset();
					program.getStore().getProxy().extraParams={
						academyLocationIds:academyLocationId,
						programGroupId : programGroupId
					};
					//program.getStore().load();
					var programStore = program.getStore();
					program.setReadOnly(false);
					programStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									program.setValue(records[0].data.id);
									var model = [records[0]];
									program.fireEvent('select', program, model);
									program.setReadOnly(true);
								}	 
							}
						}	   
					});
				}
    		},
    		'applicantportalsetupfilter customcombobox[itemId=programItemId]':{
				select:function(obj, record){
					var $this = this;
					var data = record[0].data.id;
					var filter = $this.getApplicantportalsetupfilter();
					var batch = filter.down("#batchItemId");
					var seatType = filter.down("#seatTypeId");
					seatType.reset();
					seatType.setDisabled(true);
					batch.setDisabled(false);
					batch.reset();
					batch.getStore().getProxy().extraParams={
						id:data,
					};
					//batch.getStore().load();
					var batchStore = batch.getStore();
					batch.setReadOnly(false);
					batchStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									batch.setValue(records[0].data.id);
									var model = [records[0]];
									batch.fireEvent('select', batch, model);
									batch.setReadOnly(true);
								}	 
							}
						}	   
					});
					
				}
    		},
    		'applicantportalsetupfilter customcombobox[itemId=batchItemId]':{
				select:function(obj, record){
					var $this = this;
					var data = record[0].data.id;
					var filter = $this.getApplicantportalsetupfilter();
					var seatType = filter.down("#seatTypeId");
					seatType.reset();
					seatType.setDisabled(false);
					seatType.getStore().getProxy().extraParams={
						batchId:data,
					};
					//seatType.getStore().load();
					var seatTypeStore = seatType.getStore();
					seatType.setReadOnly(false);
					seatTypeStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									seatType.setValue(records[0].data.seatTypeId);
									var model = [records[0]];
									seatType.fireEvent('select', seatType, model);
									seatType.setReadOnly(true);
								}	 
							}
						}	   
					});
					
				}
    		},
    		'applicantportalsetupfilter customcombobox[itemId=academyLocationCombo]':{
				select:function(obj, record){
					var $this = this;
					var data = record[0].data.id;
					this.loadProgramGroupStore(data);
					
					var filter = $this.getApplicantportalsetupfilter();
					var batch = filter.down("#batchItemId");
					var seatType = filter.down("#seatTypeId");
					var program = filter.down("#programItemId");
					seatType.reset();
					seatType.setDisabled(true);
					batch.setDisabled(true);
					batch.reset();
					program.reset();
					this.loadProgramStore(data);
				},				
				/*afterrender:function(obj){
					var academyLocationId = this.getCurrentAcademyLocation();
					obj.getStore().load({
						callback: function(record){
							obj.select(academyLocationId);
						}
					});
					this.loadProgramGroupStore(academyLocationId);
					this.loadProgramStore(academyLocationId);

				}*/
    		},
    		'applicantportalsetupfilter button[itemId=resetBtn]':{
    			click:function(obj, record){
					var $this = this;
					var filter = $this.getApplicantportalsetupfilter();
					var batch = filter.down("#batchItemId");
					var seatType = filter.down("#seatTypeId");
					var academyLocationCombo = filter.down("#academyLocationCombo");
					var endDate = filter.down("#endDate");
					var startDate = filter.down("#startDate");
					endDate.setMaxValue(null);
					endDate.setMinValue(null);
					startDate.setMaxValue(null);
					startDate.setMinValue(null);
					batch.setDisabled(true);
					seatType.setDisabled(true);
					filter.getForm().reset();
					//this.loadProgramStore(); 
					//this.loadProgramGroupStore();
				}
    		},
    		'applicantportalsetupfilter button[itemId=searchBtn]':{
    			click:function(obj, record){
					var $this = this;
					var grid = $this.getApplicantportalsetupgrid();
					var form = $this.getApplicantportalsetupfilter();
					var formValue =  form.getForm().getValues();
					form.down('#searchBtn').setDisabled(true);
					var mapStatus;
	                  if(formValue.mappingstatus=="MAPPED"){
	                  mapStatus = true;
	                  }else if(formValue.mappingstatus=="UNMAPPED"){
	                	  mapStatus = false;
	                  }
			    	grid.getStore().getProxy().extraParams ={
			    		applicantSetupId:formValue.applicantSetupId,
			    		createdById:formValue.createdById,
			    		academyLocationId:formValue.academyLocationId,
			    		programGroupId:formValue.programGroupId,
			    		programId:formValue.programId,
			    		batchId : formValue.batchId,
			    		seatType : formValue.seatType,
			    		startDate : formValue.startDate,
			    		endDate : formValue.endDate,
			    		mappingStatus :mapStatus
			    	};
			    	$this.resetPageSetting(grid.getStore());
			    	grid.getStore().load({
			    			callback: function(records, operation, success) {
			    				form.down('#searchBtn').setDisabled(false);
			    		}
			    	});
				}
    		},
    		'applicantportalsetupgrid': {
                render: function(grid) {
                	this.doAccessControlValidation(grid, this.getAPPLICANT_PORTAL_SETUP_PERMISSIONS());
                	this.disableOtherPivileges(grid, this.getAPPLICANT_PORTAL_SETUP_PERMISSIONS());
                	var btnCopy = grid.down('#btnCopy');
                	var btnApply = grid.down('#btnApply');
                	var btnRename = grid.down('#btnRename');
                	var splitButtonAction =grid.down('#spBtnMoreActions');
                	splitButtonAction.setVisible(true);
                	btnApply.setVisible(true);
                	btnCopy.setVisible(true);
                	btnRename.setVisible(true);
                },
                afterrender:function(grid){
   				 var contentpanel = this.getContentpanel();
				 var structure = grid.up('applicantportalsetupview');
				 this.getGridHeaderFreeze(grid,structure);
			 }
    		},
            'applicantportalsetupgrid button[itemId=btnAdd]': {
         	   click: function(obj) {
         			   var this$ = this;
         			   var window = this$.getVwadmaddapplicantsetupnamewin();
         			   if(!window){
         				   window = Ext.widget('vwadmaddapplicantsetupnamewin');
         				  window.down('#createType').setValue(null);
         			   }
         			   window.show();
					   window.down('#createType').setValue(null);
         	   }
            },
            'applicantportalsetupgrid button[itemId=btnEdit]': {
                click: function(button, e, eOpts, id) {
                    this.editApplicantPortal(id);
                }
            },
            'vwadmaddapplicantsetupnamewin button[itemId=saveBtn]': {
 	            click: function(btn) {
 	            	var setUpNameValue = btn.up('form').down('#setupName').getValue();
 	            	var createType = btn.up('form').down('#createType').getValue();
 	            	if (createType != null && createType == 'copy') {
 	            		this.copyApplicantPortalSetup(setUpNameValue);
					}else{
 	            	this.VWopenAdmApplicantPortalSetUpTab(setUpNameValue);  
					}
 	            	 btn.up('form').up('window').close();
 	            }
 	        },
 	       'applicantportalsetupgrid button[itemId=btnDelete]': {
               click: function(button, e, eOpts, id) {
                   this.unmappApplicantPortalSetup();
               }
           },
 	     
 	       'renameapplicantsetupnamewin  button[itemId=saveBtn]':{
 	    	  click: function(btn, e, eOpts, id) {
	            	var setUpNameValue = btn.up('form').down('#setupName').getValue();
	            	this.RenameApplicantSetupNameWin(setUpNameValue);  
	            	 btn.up('form').up('window').close();
	            }
 	       },
 	        'vwadmapplicantportalsetupgrid': {
 	        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	        		var  $this = this; 
 	        		var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		var $this =this;
 	        		if(columnName == "additionalSetUp"){
 	        			if (e.target.tagName == 'A') {
 	        				var setupForm = grid.up('vwadmapplicantportalsetupform');
 	        				var containpanel = setupForm.down('tabpanel');
 	        				var tabName = record.data.moduleName;
 	        				var tabDetail = containpanel.items.items;
 	        				for(var i in tabDetail){
 	        					if(tabDetail[i].xtype!='fieldcontainer'){
 	        						tabDetail[i].close();
 	        					}
 	        				}
 	        				var configfeestructure = Ext.widget('stcadmapplicantportalconfigurescreen');
 	        				openTab(containpanel, tabName, configfeestructure);
 	        				configfeestructure.down('#moduleTableItemId').setValue(record.data.tableName);
 	        				configfeestructure.down('#moduleItemId').setValue(record.data.applicantPortalModuleId);
 	        				configfeestructure.down('#moduleNameItemId').setValue(record.data.moduleCode);
 	        				var configGrid = configfeestructure.down('vwadmapplciantportalconfigurescreengrid');
 	        				configGrid.getStore().getProxy().extraParams = {
 	        					applicantPortalSetupId:record.data.applicantPortalSetupId,
 	        					screenName:record.data.formAliasName,
 	        					screenMode:'Create, Edit, and View'
 	        						//languageId:languageId
 	        				};
 	        				configGrid.getStore().load();
 	        				if(record.data.formAliasName =='educationform' || record.data.formAliasName =='parentguardianform' ||
 	        						record.data.formAliasName =='competitiveexamform' || record.data.formAliasName == 'addressformwindow' ||
 	        						record.data.formAliasName =='personhostelrequirementform' || record.data.formAliasName =='socioeconomicinformationform'){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='dataRequirementTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        								if (record.data.formAliasName =='personhostelrequirementform' || record.data.formAliasName =='socioeconomicinformationform') {
 	        									if(itemGrid.xtype =='hostelrequirementdatasetup'){
 	        										if (record.data.formAliasName =='socioeconomicinformationform') {
 	        											var form = $this.getHostelrequirementdatasetup();
														var docField = form.down('#hostelRequirementDocumentId');
														docField.hide();
													}
 	 	        									itemGrid.show();
 	 	        								}
 	        									if(itemGrid.xtype =='vwadmapplicantportalsetupdatarequirementgrid'){
 	 	        									itemGrid.hide();
 	 	        								}
											}else if (record.data.formAliasName =='parentguardianform' || record.data.formAliasName =='educationform' 
												|| record.data.formAliasName =='competitiveexamform' || record.data.formAliasName == 'addressformwindow') {
												if(itemGrid.xtype =='datarequirementgridwithform'){
 	 	        									itemGrid.show();
 	 	        								}
												if(itemGrid.xtype =='hostelrequirementdatasetup'){
 	 	        									itemGrid.hide();
 	 	        								}
											}
 	        								else{
												if(itemGrid.xtype =='hostelrequirementdatasetup'){
 	 	        									itemGrid.hide();
 	 	        								}
 	        									if(itemGrid.xtype =='vwadmapplicantportalsetupdatarequirementgrid'){
 	 	        									itemGrid.show();
 	 	        								}
											}
 	        								
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        				}
 	        				
 	        				if(record.data.formAliasName =='DeclarationAndPaymentForm'){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='additionalSetupTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        									if(itemGrid.xtype =='paymentadditionalsetup'){
 	 	        									itemGrid.show();
 	 	        								}
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        				}
 	        				if(record.data.formAliasName =='addapplicationprogramform'){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='programLimitDataRequirementTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        									if(itemGrid.xtype =='vwadmprogramdetaildatarequirementapsetup'){
 	 	        									itemGrid.show();
 	 	        								}
 	        									
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        				}
 	        			if(record.data.formAliasName =='onlinePaymentForm'){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='onlineLimitDataRequirementTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        									if(itemGrid.xtype =='vwadmonlinepaymentdatarequirementapsetup'){
 	 	        									itemGrid.show();
 	 	        								}
 	        									
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        				}
 	        				if(record.data.formAliasName =='extendeddocumentform' || record.data.formAliasName =='feepayerdetailform' || 
 	        						record.data.formAliasName =='personalinformationform' || record.data.formAliasName =='postschoolstudiesform' /*|| record.data.formAliasName =='onlinePaymentForm'*/){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='dataRequirementTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        									if(itemGrid.xtype =='uploaddocrequirementdatasetup'){
 	 	        									itemGrid.show();
 	 	        								}
 	        									if(itemGrid.xtype =='hostelrequirementdatasetup'){
 	 	        									itemGrid.hide();
 	 	        								}
 	        									if(itemGrid.xtype =='vwadmapplicantportalsetupdatarequirementgrid'){
 	 	        									itemGrid.hide();
 	 	        								}
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        				}
 	        
 	        				if (record.data.moduleCode =='STEP14_OTHER_INFORMATION') {
 	        					var activeTab = configfeestructure.down('tabpanel');
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='configureScreenTabItemId' || obj.itemId =='customFieldTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
	        									if(itemGrid.xtype =='vwadmapplciantportalconfigurescreengrid'){
	 	        									itemGrid.hide();
	 	        									obj.tab.hide();
	 	        								}
	        									
	        							});
 	        						}
 	        						
 	        					});
 	        					activeTab.setActiveTab(1);
     							var configGrid = configfeestructure.down('vwadmapplicantportalsetupcustomcolumngrid');
     	        				configGrid.getStore().getProxy().extraParams = {
     	        					setupId:record.data.applicantPortalSetupId,
     	        					moduleId:record.data.applicantPortalModuleId,
     	        					tableName:record.data.tableName
     	        						//languageId:languageId
     	        				};
     	        				configGrid.getStore().load();
							}
 	        				
 	        				if(record.data.moduleCode == 'STEP38_TRANSFER_CREDIT'){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='configureScreenTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        								if(itemGrid.xtype =='vwadmapplciantportalconfigurescreengrid'){
 	        									var configGrid = configfeestructure.down('vwadmapplciantportalconfigurescreengrid');
 	        									configGrid.getStore().getProxy().extraParams = {
 	        										applicantPortalSetupId:record.data.applicantPortalSetupId,
 	        										screenName:record.data.formAliasName,
 	        										screenMode:'Create, Edit, and View'
 	        											//languageId:languageId
 	        									};
 	        								}

 	        							});
 	        							obj.tab.show();
 	        						}
 	        					});
 	        				}
 	        			}
 	        		}
 	        	}
 	        },
            'vwadmapplicantportalsetupgrid #btnSavePrivilege ': {
                click: function() {
                    this.saveApplicantPortalSetUPPrivilege();
                }
            },
            'applicantportalsetupgrid button[itemId=spBtnMoreActions] #btnApply':{
            	click : function(){
            	this.getOpenApplicantPortalMappingStructure();
            	
            	}
            },
            'applicantportalsetupgrid button[itemId=spBtnMoreActions] #btnRename':{
            	click : function(){
            		this.getRenamenApplicantPortalSetup();
            	}
            },
            'vwadmapplicantportalsetupmappingresultgrid button[itemId=btnAdd]':{
            	click:this.VWAdmOpenApplicantSetUpDoMappingTab
            },
            'vmadmacademylocationgridforsetupmapping customcombobox#academylocationsearchcombo' : {
            	select:function(obj, record){
            		this.getVmadmacademylocationgridforsetupmapping().getStore().clearFilter();
            		this.getVmadmacademylocationgridforsetupmapping().getStore().filter({property: 'id',
            			value: record[0].get('id'),
            			exactMatch: true,
            			caseSensitive: true});
            	}
            },
            'vmadmacademylocationgridforsetupmapping button#nextButton':{
            	click:function(btn){
            		this.mapAPAdmAcademyLocationNextEvent(btn);
            	}
            },
            'vwadmapplicantportalsetupmappingresultgrid button[itemId=btnDelete]':{
            	click:this.getDeleteApplicantPortalSetupDoMapping
            },
            'vwadmalprogramgrid customcombobox#programsearchcombo' : {
            	select:function(obj, record){
            		this.getVwadmalprogramgrid().getStore().clearFilter();
            		this.getVwadmalprogramgrid().getStore().filter({property: 'programId',
            			value: record[0].get('id'),
            			exactMatch: true,
            			caseSensitive: true});
            }
            },
            'vmadmapplicantportalsetupwithprogrambatchseatstructure button#resetBtn':{
            	click:function(btn){
            		var tabStructure = this.getVmadmapplicantportalsetupwithprogrambatchseatstructure();
            		var activeGrid = tabStructure.getActiveTab().down('grid');
            		activeGrid.getSelectionModel().deselectAll();
            		activeGrid.getStore().clearFilter();
            		if(activeGrid.down('customcombobox'))
            			activeGrid.down('customcombobox').reset();
            	}
            },
            'vwadmalprogramgrid button#nextButton':{
            	click:function(btn){
            		this.admApplicantPortalSetupALProgramNextEvent(btn);
            	}
            },
            'vwadmalprogrambatchgrid customcombobox#programbatchsearchcombo' : {
            	select:function(obj, record){
            		this.getVwadmalprogrambatchgrid().getStore().clearFilter();
            		this.getVwadmalprogrambatchgrid().getStore().filter({property: 'batchId',
            			value: record[0].get('id'),
            			exactMatch: true,
            			caseSensitive: true});
            	}
            },
            'vwadmalprogrambatchgrid button#nextButton':{
            	click:function(btn){
            		this.admALSetUpProgramBatchNextEvent(btn);
            	}
            },
            'vmadmapplicantportalsetupwithprogrambatchseatstructure button#submitSetupMapping':{
            	click:function(btn){
            		this.submitSetupMappingWithProgramBatchSeatType();
            	}
            },
            'vwadmapplicantportalsetupgrid checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var this$ = this;
            		var grid = this$.getVwadmapplicantportalsetupgrid();
            		var store = grid.getStore();
            		 var models = grid.getStore().getRange();
            		 if(models[rowIndex].data.moduleName !='Program Details'){
            			 if(checked){
                			 for(var i =0; i<store.data.length;i++){
                				 if(rowIndex==i){
                					 models[rowIndex].set('mandatory', true);
                				 }
                			 }	 
                		 }else{
                			 for(var i =0; i<store.data.length;i++){
                				 if(rowIndex==i){
                					 models[rowIndex].set('mandatory', false);
                				 }
                			 }	 
                		} 
            		 }else{
            			 models[rowIndex].set('visibility', true);
            			 models[rowIndex].set('mandatory', true);
            		 }
            		
            	}
            },
            'vwadmapplicantportalsetupmappingalertwin button[itemId=admSetupAlertBtn]':{
            	click : function(btn) {
            		var alertWin = this.getVwadmapplicantportalsetupmappingalertwin();
            		alertWin.close();
            	}
            },
            /*'vwadmapplciantportalconfigurescreengrid button[itemId=btnSave]':{
            	click:function(){
            		this.admSaveApplicantPortalConfigureScreenData();
            	}
            },*/
            'vwadmapplciantportalconfigurescreengrid':{
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var $this=this;
            		var searchResultGrid = $this.getVwadmapplciantportalconfigurescreengrid();
            		//if(searchResultGrid.columnManager.columns !=null){
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
            		var selectedRecord = searchResultGrid.getSelectionModel().getSelection()[0];

            		if(columnName=='helpText' && searchResultGrid.getSelectionModel().getSelection().length>0  /*&& record.data.helpText ==null || record.data.helpText ==""*/){ 
            			if(searchResultGrid.getSelectionModel().getSelection().length==1 &&  (record.data.formFieldId == selectedRecord.data.formFieldId)){

            				if (e.target.tagName == 'A') {
            					var formWindow = $this.getVwadmapplicantsetuphelptextform();
            					if (!formWindow) {
            						Ext.widget('vwadmapplicantsetuphelptextform');
            						formWindow = $this.getVwadmapplicantsetuphelptextform();
            					}
            					formWindow.show();

            					var defaultHelpText = record.data.defaultHelpText;
            					var helpTextForm = $this.getVwadmapplicantsetuphelptextForm().getForm();
            					helpTextForm.findField('defaultHelpText').setValue(defaultHelpText);

            					if(!isNullOrEmpty(record.data.helpText)){
            						helpTextForm.findField('helpText').setValue(record.data.helpText);
            					}
            				}
            			}else{
            				if(searchResultGrid.getSelectionModel().getSelection().length>1 ){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); 
            				}
            				else if(record.data.formFieldId != selectedRecord.data.formFieldId){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_CURRENT_RECORD'));
            				}
            			}
            		}
            		else{

            			if(columnName=='helpText' && (!searchResultGrid.getSelectionModel().getSelection().length>0 || (record.data.formFieldId != selectedRecord.data.formFieldId)) )
            				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 

            		}
            	}
            	
            //}
            },
            'vwadmapplicantsetuphelptextform button[itemId=submitBtn]':{
            	click:function(obj){
            		var $this =this;
            		var form = obj.up('form').getForm();
            		var values = form.getValues();
            		var helpText =values.helpText;
            		var helpTextDefault = values.defaultHelpText
            		var grid = $this.getVwadmapplciantportalconfigurescreengrid();
            		var getRange = grid.getSelectionModel().selected.getRange();
            		getRange[0].set("helpText",helpText);
            		getRange[0].set("defaultHelpText",helpTextDefault);
            		if(getRange[0]!=null)
            		 {
            			showSuccessMessage(getCommonTranslation('HELP_TEXT_SAVE'),getCommonTranslation('SUCCESS')); 
            		}
            		$this.getVwadmapplicantsetuphelptextform().close();
            	}
            },
            'vwadmapplicantsetuphelptextform button[itemId=cancelBtn]':{
            	click:function(obj){
            		this.getVwadmapplicantsetuphelptextform().close();
            	}
            },
            'vwadmapplicantportalsetupcustomcolumngrid':{
            	render : function(grid){
            		var $this = this;
            		var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
            	    var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
            	    var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
            		var moduleTableName = $this.getStcadmapplicantportalconfigurescreen().down('#moduleTableItemId').getValue();
            		grid.getStore().getProxy().extraParams={
            			tableName:moduleTableName,
            			setupId:applicantPortalSetupId,
            			moduleId:moduleId
            		}
            		grid.getStore().load({
	            		callback: function(records, operation, success) {
	    					if (success) {
	    						if(records.length > 0){
	    							grid.down('#btnSave').setDisabled(false);
	    						} else {
	    							grid.down('#btnSave').setDisabled(true);
	    						}
	    					}
	    				}
            		});
            	} 
            },
            'vwadmapplicantportalsetupdatarequirementgrid':{
            	render : function(grid){
            		var $this = this;
            		var min;
            		var max;
            		 var moduleCode = $this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
            		var url;
            		
            		var firstIndex = grid.columns[0];
            		Ext.each(grid.columns, function(column) {
                		if (column.dataIndex == 'minimumEntry') {
                			min = column;
						}else if (column.dataIndex == 'maximumEntry'){
							max = column
						}
                	});
            		var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
            		var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
             	    var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
             	    if (moduleCode == 'STEP8_ENGLISH_LANGUAGE_COMPETENCY') {
             	    	url = SERVERURL.PATH_FIND_COMPETITIVE_EXAM_DATA;
					}else if (moduleCode == 'STEP11_PARENTS_AND_GUARDIANS') {
						url = SERVERURL.PATH_FIND_PARENT_GUARDIAN_DATA_REQUIREMENT;
					}else if (moduleCode == 'STEP5_EDUCATION_BACKGROUND') {
						grid.getStore().getProxy().extraParams={
	             			setupId:applicantPortalSetupId,
	             			moduleId:moduleId
	             		}
	             		grid.getStore().load();
					}else if (moduleCode == 'STEP2_CONTACT_DETAILS') {
						url = SERVERURL.PATH_FIND_RELATED_PERSON_ADDRESS_DATA_REQUIREMENT;
					}
             	   Ext.Ajax.request({
                   	type: 'rest',
                   	url: url+'?setupId='+applicantPortalSetupId+'&moduleId='+moduleId,
                   	method: 'GET',
                   	callback : function(opt, success, response){
                   		var data = Ext.decode(response.responseText);
                   		grid.getStore().loadData(data);
                   		}
                   	});
             	  setTimeout(function() {
             		  if (moduleCode == 'STEP11_PARENTS_AND_GUARDIANS'){
             			  min.setVisible(false);
             			  max.setVisible(false);
             			  firstIndex.setText(getFeeAndPaymentCommonTranslation('PARENTS_DETAILS')); 

             		  }else if (moduleCode == 'STEP8_ENGLISH_LANGUAGE_COMPETENCY') {
             			  min.setVisible(false);
             			  max.setVisible(false);
             		  }
                    }, 100);
             	  
             	 setTimeout(function() {
            		  if (moduleCode == 'STEP2_CONTACT_DETAILS'){
            			  var firstHeaderName = getCommonTranslation('SETUP_CONTACT_DETAILS');
            			  grid.columnManager.columns[0].setText(firstHeaderName);
            			  min.setVisible(false);
            			  max.setVisible(false);

            		  }}, 100);
   			 } 
            },
            'vwadmapplicantportalsetupcustomcolumngrid button[itemId=btnSave]':{
            	click:function(){
            		this.admSaveApplicantPortalCustomColumnSetup();
            	}
            },
            'vwadmapplicantportalsetupdatarequirementgrid button[itemId=btnSave]':{
            	click:function(){
            		this.admSaveApplicantPortalDataReqSetup();
            	}
            },
            'vwadmapplicantportalsetupdatarequirementgrid checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var this$ = this;
            		var grid = this$.getVwadmapplicantportalsetupdatarequirementgrid();
            		var store = grid.getStore();
            		 var models = grid.getStore().getRange();
            			 if(checked){
                			 for(var i =0; i<store.data.length;i++){
                				 if(rowIndex==i){
                					 models[rowIndex].set('mandatory', true);
                				 }
                			 }	 
                		 }else{
                			 for(var i =0; i<store.data.length;i++){
                				 if(rowIndex==i){
                					 models[rowIndex].set('mandatory', false);
                				 }
                			 }	 
                		} 
            	}
            },
            'vwadmapplicantportalsetupcustomcolumngrid checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var this$ = this;
            		var grid = this$.getVwadmapplicantportalsetupcustomcolumngrid();
            		var store = grid.getStore();
            		 var models = grid.getStore().getRange();
            			 if(checked){
                			 for(var i =0; i<store.data.length;i++){
                				 if(rowIndex==i){
                					 models[rowIndex].set('mandatory', true);
                				 }
                			 }	 
                		 }else{
                			 for(var i =0; i<store.data.length;i++){
                				 if(rowIndex==i){
                					 models[rowIndex].set('mandatory', false);
                				 }
                			 }	 
                		} 
            	}
            },
            'hostelrequirementdatasetup button[itemId=SubmitBtn]':{
            	click:function(){
            		this.saveHostelPersonalRequirement();
            	}
            },
            'hostelrequirementdatasetup':{
            	afterrender : function(form){
            		var portalSetUpForm = this.getVwadmapplicantportalsetupform();
            		var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
            		var moduleId = this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
            		var guideline = form.down('#instructionsItemId');
            		var hostlReeqinstructionsOtherLang = form.down('#hostlReeqinstructionsOtherLang');
            		var idField = form.down('#Id');
            		var mainForm = form.down('#hostelRequirementDocumentId');
            		url = SERVERURL.PATH_FIND_HOSTEL_PERSONAL_REQUIREMENT;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: url+'?setupId='+applicantPortalSetupId+'&moduleId='+moduleId,
            			method: 'GET',
            			callback : function(opt, success, response){
            				var data = Ext.decode(response.responseText);
            				guideline.setValue(data.guideline);
            				hostlReeqinstructionsOtherLang.setValue(data.guidelineOtherLang);			
            				idField.setValue(data.id);
            			}
            		});	
            	}
            },
       	 'hostelrequirementdatasetup filefield[itemId=file]': {
             change: function(fileField, value, eOpts) {
              	var $this = this;
              	var form = this.getHostelrequirementdatasetup();
            	var mainForm = form.down('#hostelRequirementDocumentId');
                var photoFileImage = mainForm.down('#removeFile');
                
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    if ($this.isValidFileExtension(extension)) {
                        var file = fileField.fileInputEl.dom.files[0];
                        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('FILE_SIZE_ERROR_MESSAGE')+" "+CONSTANTS.UPLOAD_FILE_SIZE_LIMIT
            	            		+" "+getPersonModuleTranslation('MB'));
                        }else{
                        	var form = this.getHostelrequirementdatasetup();
                        	var mainForm = form.down('#hostelRequirementDocumentId');
                            var photoFileImage = mainForm.down('#removeFile');
                        }
                    } else {
                        fileField.reset();
                        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                    }
                }
            }
         },
         'hostelrequirementdatasetup button[itemId=removeFile]': {
             click: function(fileField, value, eOpts) {
                 var moduleCode = this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
                 var form = this.getHostelrequirementdatasetup();
                 var idField = form.down('#Id');
                 var id = idField.getValue();
                 var mainForm = form.down('#hostelRequirementDocumentId');
                 var photoFileImage = mainForm.down('#file');
                 var fileUploadPath = photoFileImage.getValue();
                 var removeImg = mainForm.down('#removeFile');
                 form.down('#availableDocumentLabelItemId').setVisible(false);
                 removeImg.setVisible(false);
                     mainForm.getForm().submit({
                         method : 'POST',
                         url : SERVERURL.PATH_DATA_REQUIREMENT_UPLOAD_DOCUMENT_IMAGE,
                         async: false,
                         params:{
                             module : moduleCode,
                             entityId:id
                         },
                         success : function(form, action){
                        	 showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('File Removed Successfully'));
                         }
                     });
             }
         },
         'uploaddocrequirementdatasetup button[itemId=SubmitBtn]':{
         	click:function(btn){
         		this.saveUploadDocumentRequirement(btn);
         	}
         }, 
         'uploaddocumentlist button#addGuidelineDocument' : {
 			 click : function() {
 				 this.getDocumentController().showDocumentFormWindow('uploaddocumentlistId','GUIDELINES_DOCUMENT');
 			 }
 		 },
 		 'uploaddocumentlist button#deleteGuidelineDocument' : {
 			 click:function(obj){
 				 this.deleteGuidelineDocument(obj);
 			 }
 		 }, 		 
 		 'guidelinedocumentform button#documentCancelButtonId':{
			  click:function(){
				  this.getDocumentController().closeDocumentFormWindow();
			  }
		  },
		  'guidelinedocumentform button#documentFormSubmitButtonId':{
			  click : function(obj) {
				  this.saveGuidelinesDocument(obj);
			  }
		  },
	 	 'guidelinedocumentform filefield[itemId=uploadFileField]': {
	        	   change: function(fileField, value, eOpts) {
	        		   if (!isNullOrEmpty(value)) {
	        			   var $this = this;
	        			   value = value.replace('C:\\fakepath\\', '');
	            		   var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	            		   fileField.setRawValue(newValue);
	            		   var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
	                       var specialCharsExist=false;
	                            for(i = 0; i < specialChars.length;i++){
	                              if(newValue.indexOf(specialChars[i]) > -1){
	                                  specialCharsExist= true;
	                               }
	                            }
	                           if(specialCharsExist){
	                        	   fileField.reset();
	                               showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
	                           }
	        		       var form = fileField.up().up();
	        		       var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	        		       if ($this.isValidFileExtensionForGuidelinesDocument(extension)) {
	        		    	   var file = fileField.fileInputEl.dom.files[0];
	        		    	   if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
	        		               fileField.reset();
	        		               showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MESSAGE')+" "+CONSTANTS.UPLOAD_FILE_SIZE_LIMIT
	               	            		+" "+getPersonModuleTranslation('MB'));
	        		               return false;
	        		           } 
	        		       } else {
	        		           fileField.reset();
	        		           showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
	        		           return false;
	        		       }
	        		   }
	        	   }
	            },
         'uploaddocrequirementdatasetup':{
         	afterrender : function(form){
         		var saveButton = form.down('#SubmitBtn');
         		var portalSetUpForm = this.getVwadmapplicantportalsetupform();
         		var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
         		var moduleId = this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
         		 var moduleCode = this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
         		var guideline = form.down('#instructionsItemId');
         		var instructionsInOtherLang = form.down('#instructionsInOtherLangItemId');
         		var idField = form.down('#Id');
         		var uploaddocumentlist = form.down('#uploaddocumentlistId');
         		if (moduleCode == 'STEP11_PARENTS_AND_GUARDIANS' || moduleCode == 'STEP5_EDUCATION_BACKGROUND' || 
         				moduleCode == 'STEP8_ENGLISH_LANGUAGE_COMPETENCY' || moduleCode == 'STEP2_CONTACT_DETAILS') {
         			saveButton.setVisible(false);
				}
         		url = SERVERURL.PATH_FIND_UPLOAD_DOCUMENT_REQUIREMENT;
         		Ext.Ajax.request({
         			type: 'rest',
         			url: url+'?setupId='+applicantPortalSetupId+'&moduleId='+moduleId,
         			method: 'GET',
         			callback : function(opt, success, response){
         				 if (!isNullOrEmpty(response.responseText)) {
         				var data = Ext.decode(response.responseText);
         				guideline.setValue(data.guideline);   
         				instructionsInOtherLang.setValue(data.guidelineOtherLang); 
         				idField.setValue(data.id);
         				var store = uploaddocumentlist.getStore();
       					store.getProxy().extraParams = {
           						applicantPortalSetupId: applicantPortalSetupId,
           						applicantPortalModuleId: moduleId
       					};
       					store.load();
         				 }else{
         					var store = uploaddocumentlist.getStore();
         					store.getProxy().extraParams = {
           						applicantPortalSetupId: applicantPortalSetupId,
           						applicantPortalModuleId: moduleId
           					};
         					store.reload(); 
         				 }
         			}
         		});	
         	}
         },
         'uploaddocumentlist':{
 			 cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
 				 if (e.target.tagName == 'A') {
 					 if(!isNullOrEmpty(record.get("id"))){
 						 var documentId = record.get("id");
 					 }else{
 						 var documentId = record.get("documentId");
 					 }

 					 if (!isNullOrEmpty(documentId)) {
 						 this.getDownloadFileForGuidelinesDocument(documentId);
 					 }
 				 }
 			 }  
 		 },
            'paymentadditionalsetup button[itemId=SaveBtn]':{
            	click:function(){
            		this.saveAdditionalSetup();
            	}
            },           
            'paymentadditionalsetup':{
            	afterrender : function(form){
            		var portalSetUpForm = this.getVwadmapplicantportalsetupform();
            		var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
             	    var moduleId = this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
             	    var declarationField = form.down('#declarationsItemId');
     			    var feeApplicableField = form.down('#feeApplicableTypeId'); 
     			    var InsGuideInOtherLang =  form.down('#InsGuideInOtherLang');
     			    var uploaddocumentlist = form.down('#uploaddocumentlistId');
     			    var idField = form.down('#Id');
            		url = SERVERURL.PATH_FIND_ADDITIONAL_SETUP;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: url+'?setupId='+applicantPortalSetupId+'&moduleId='+moduleId,
            			method: 'GET',
            			callback : function(opt, success, response){
            				if (!isNullOrEmpty(response.responseText)) {
            				var data = Ext.decode(response.responseText);
            				declarationField.setValue(data.guideline);
            				InsGuideInOtherLang.setValue(data.guidelineOtherLang);
            				idField.setValue(data.id);
            				 if(data.isOneTimeFee == true){
      	 						feeApplicableField.items.items[0].setValue(true);
      	 						feeApplicableField.items.items[1].setValue(false);
     	                	   }
      	 					else
     	                	   {
      	 						feeApplicableField.items.items[0].setValue(false);
      	 						feeApplicableField.items.items[1].setValue(true);
     	                	    }
     	                	 }   
            			}
            		});	
            		var store = uploaddocumentlist.getStore();
            		store.getProxy().extraParams = {
            			applicantPortalSetupId: applicantPortalSetupId,
            			applicantPortalModuleId: moduleId
            		};
            		store.load();
            	}
            },
            'vwadmprogramdetaildatarequirementapsetup button[itemId=admSaveBtnItemId]':{
            	click:function(){
            		this.admSaveProgramDetailLimitAPSetup();
            	}
            },
            'vwadmprogramdetaildatarequirementapsetup':{
            	afterrender : function(form){
            		var portalSetUpForm = this.getVwadmapplicantportalsetupform();
            		var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
             	    var moduleId = this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
     			    var idField = form.down('#Id');
     			   var maxLimit = form.down('#admProgramLimitItemId');
     			   var guideline = form.down('#instructionsItemId');
     			   var VWAdminstructionsOtherLang =  form.down('#VWAdminstructionsOtherLang');
     			  var allowMultipleAdmissionOffer = form.down('#allowMultipleAdmissionOffer');
     			 var uploaddocumentlist = form.down('#uploaddocumentlistId');
            		url = SERVERURL.PATH_FIND_HOSTEL_PERSONAL_REQUIREMENT;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: url+'?setupId='+applicantPortalSetupId+'&moduleId='+moduleId,
            			method: 'GET',
            			callback : function(opt, success, response){
            				 if (!isNullOrEmpty(response.responseText)) {
            				var data = Ext.decode(response.responseText);
            				idField.setValue(data.id);
            				maxLimit.setValue(data.maximumEntry);
                 				guideline.setValue(data.guideline);
                 				VWAdminstructionsOtherLang.setValue(data.guidelineOtherLang);
            				allowMultipleAdmissionOffer.setValue(data.isMultipleOfferLetters);
                  				var store = uploaddocumentlist.getStore();
                  				store.getProxy().extraParams = {
	              						applicantPortalSetupId: applicantPortalSetupId,
	              						applicantPortalModuleId: moduleId
	              					};
                					store.load(); 
            				 }else{
            					 var store = uploaddocumentlist.getStore();
            					 store.getProxy().extraParams = {
	              						applicantPortalSetupId: applicantPortalSetupId,
	              						applicantPortalModuleId: moduleId
	              					};
             					store.load();  
            				 }
            				
            			}
            		});	
            	}
            },'vwadmonlinepaymentdatarequirementapsetup button[itemId=admSaveBtnItemId]':{
            	click:function(){
            		this.addSaveOnlinePaymentSetup();
            	}
            },
            'vwadmonlinepaymentdatarequirementapsetup':{
            	afterrender : function(form){
            		var portalSetUpForm = this.getVwadmapplicantportalsetupform();
            		var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
             	    var moduleId = this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
     			    var idField = form.down('#Id');
     			   var maxLimit = form.down('#onlinePaymentUrl');
     			   var guideline = form.down('#instructionsItemId');
     			   var VWAdminstructionsOtherLang =  form.down('#VWAdminstructionsOtherLang');
     			  var onlinePaymentUrl = form.down('#onlinePaymentUrl');
     			 var uploaddocumentlist = form.down('#uploaddocumentlistId');
            		url = SERVERURL.PATH_FIND_HOSTEL_PERSONAL_REQUIREMENT;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: url+'?setupId='+applicantPortalSetupId+'&moduleId='+moduleId,
            			method: 'GET',
            			callback : function(opt, success, response){
            				 if (!isNullOrEmpty(response.responseText)) {
            				var data = Ext.decode(response.responseText);
            				idField.setValue(data.id);
            				maxLimit.setValue(data.maximumEntry);
                 				guideline.setValue(data.guideline);
                 				VWAdminstructionsOtherLang.setValue(data.guidelineOtherLang);
                 				onlinePaymentUrl.setValue(data.onlinePaymentUrl);
                  				var store = uploaddocumentlist.getStore();
                  				store.getProxy().extraParams = {
	              						applicantPortalSetupId: applicantPortalSetupId,
	              						applicantPortalModuleId: moduleId
	              					};
                					store.load(); 
            				 }else{
            					 var store = uploaddocumentlist.getStore();
            					 store.getProxy().extraParams = {
	              						applicantPortalSetupId: applicantPortalSetupId,
	              						applicantPortalModuleId: moduleId
	              					};
             					store.load();  
            				 }
            				
            			}
            		});	
            	}
            },
            'applicantportalsetupgrid button[itemId=spBtnMoreActions] #btnCopy': {
                click: function(button, e, eOpts, id) {
                	var this$ = this;
                    var grid =  this$.getApplicantportalsetupgrid();
                    if (grid.getSelectionModel().getCount() >0) {
                    	 var window = this$.getVwadmaddapplicantsetupnamewin();
             			   if(!window){
             				   window = Ext.widget('vwadmaddapplicantsetupnamewin');
             				   window.down('#createType').setValue('copy');
             			   }
             			   window.show();
						   window.down('#createType').setValue('copy');
                    }else{
                    	showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
       			  
                }
            },
            'vwadmaddapplicantsetupnamewin':{
            	render:function(window){
    				var $this = this
    				window.body.on('click', function() {
    					var filter = window.down('form');
    					$this.hideInvalidIconFromField(filter);
    			       });
    			}
            },
            'vwadmapplicantportalsetupform':{
            	afterrender : function(structure){
    				var $this = this;
    				structure.body.on('scroll', function(e, target) {
    					var setUpGrid = $this.getVwadmapplicantportalsetupgrid();
    					if(!isNullOrEmpty(setUpGrid)){
    						$this.getMultipleGridHeaderFreezeWithoutPaggination(setUpGrid,structure,true);
    					}
    				});
    			}
            },
            'applicantportalsetupview': {
            	render: function(structure) {
            		this.disableDashboardTabPivileges(structure,this.getAPPLICANT_PORTAL_SETUP_DASHBOARD_PERMISSIONS());
            	}
            },
            'dashboarduploaddocumentlist button#addGuidelineDocument' : {
            	click : function() {
            		this.getDocumentController().showDocumentFormWindow('dashboarduploaddocumentlistId','DASHBOARD_GUIDELINES_DOCUMENT');
            	}
            },
            'dashboarduploaddocumentlist button#deleteGuidelineDocument' : {
            	click:function(obj){
            		this.deleteDashboardGuidelineDocument(obj);
            	}
            }, 
            'dashboarddatarequirementdatasetup':{
            	afterrender : function(form){
             		
            		var moduleType = form.down('#moduleTypeId');
             		var moduleTypeStore = moduleType.getStore();
             		
             		moduleTypeStore.load({
             			callback: function(records, operation, success) {
             				if (success) {
             					for(var i=0;i<records.length;i++) {
             						if(records[i].data.code=='STEP36_DASHBOARD') {
             							moduleType.setValue(records[i].data.id);
             						}
             					}
             				}
             			}	   
             		});
            	}
             },
             'dashboarddatarequirementdatasetup customcombobox[itemId=moduleTypeId]':{
            	change:function(record) {
            		var $this = this;
            		var form = $this.getDashboarddatarequirementdatasetup();
            		
            		var moduleType = form.down('#moduleTypeId');
            		var moduleTypeId = moduleType.getValue();
            		
            		var saveButton = form.down('#SubmitBtn');
             		var guideline = form.down('#instructionsItemId');
             		var instructionsInOtherLang = form.down('#instructionsInOtherLangItemId');
             		var idField = form.down('#Id');
             		var uploaddocumentlist = form.down('#dashboarduploaddocumentlistId');
             		url = SERVERURL.PATH_FIND_DEFAULT_UPLOAD_DOCUMENT_REQUIREMENT;
             		
             		Ext.Ajax.request({
             			type: 'rest',
             			url: url+'?moduleId='+moduleTypeId,
             			method: 'GET',
             			callback : function(opt, success, response){
             				idField.reset();
             				guideline.reset();
             				instructionsInOtherLang.reset();
             				if (!isNullOrEmpty(response.responseText)) {
	             				var data = Ext.decode(response.responseText);
	             				idField.setValue(data.id);
	             				guideline.setValue(data.guideline);   
	             				instructionsInOtherLang.setValue(data.guidelineOtherLang); 
	             				var store = uploaddocumentlist.getStore();
	           					store.getProxy().extraParams = {
	               						applicantPortalModuleId: moduleTypeId
	           					};
	           					store.load();
             				 }else{
             					var store = uploaddocumentlist.getStore();
             					store.getProxy().extraParams = {
               						applicantPortalModuleId: moduleTypeId
               					};
             					store.load(); 
             				 }
             			}
             		});	
            	} 
             },
             'dashboarddatarequirementdatasetup button[itemId=SubmitBtn]':{
             	click:function(){
             		this.saveDashboardDataRequirement();
             	}
             },
             'dashboarduploaddocumentlist':{
     			 cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
     				 if (e.target.tagName == 'A') {
     					 if(!isNullOrEmpty(record.get("id"))){
     						 var documentId = record.get("id");
     					 }else{
     						 var documentId = record.get("documentId");
     					 }

     					 if (!isNullOrEmpty(documentId)) {
     						 this.getDownloadFileForGuidelinesDocument(documentId);
     					 }
     				 }
     			 }  
     		 },
     		 'dashboardguidelinedocumentform button#documentCancelButtonId':{
     			 click:function(){
     				 this.getDocumentController().closeDocumentFormWindow();
     			 }
     		 },
     		 'dashboardguidelinedocumentform button#documentFormSubmitButtonId':{
     			 click : function(obj) {
     				 this.saveDashboardGuidelinesDocument(obj);
     			 }
     		 },
     		 'dashboardguidelinedocumentform filefield[itemId=uploadFileField]': {
     			 change: function(fileField, value, eOpts) {
     				 if (!isNullOrEmpty(value)) {
     					 var $this = this;
     					 value = value.replace('C:\\fakepath\\', '');
     					 var newValue = value.replace(/ +/g, " ").split(' ').join('_');
     					 fileField.setRawValue(newValue);
     					 var form = fileField.up().up();
     					 var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
     					 if ($this.isValidFileExtensionForGuidelinesDocument(extension)) {
     						 var file = fileField.fileInputEl.dom.files[0];
     						 if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
     							 fileField.reset();
     							showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MESSAGE')+" "+CONSTANTS.UPLOAD_FILE_SIZE_LIMIT
                	            		+" "+getPersonModuleTranslation('MB'));
     							 return false;
     						 } 
     					 } else {
     						 fileField.reset();
     						 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
     						 return false;
     					 }
     				 }
     			 }
     		 },
             'applicantportalsetupgrid button[itemId=viewDefaultProgramSetup]':{
             	click : function(){
             	this.getOpenProgramDefaultSetupStructure();
             	
             	}
             },
             'defaultprogramsetupconfigurescreengrid':{
        		render : function(grid){
        			var $this = this;
        			grid.getStore().getProxy().extraParams={
        				academyLocationId:1,
        				screenName:'Default Program Details Set Up',
        				screenMode:'Create, Edit, and View',
        				languageId :1
        			}
        			grid.getStore().load();
        			
        		},
        		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var $this=this;
            		var searchResultGrid = $this.getDefaultprogramsetupconfigurescreengrid();
            		//if(searchResultGrid.columnManager.columns !=null){
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
            		var selectedRecord = searchResultGrid.getSelectionModel().getSelection()[0];

            		if(columnName=='helpText' && searchResultGrid.getSelectionModel().getSelection().length>0 /* && record.data.helpText ==null || record.data.helpText ==""*/){ 
            			if(searchResultGrid.getSelectionModel().getSelection().length==1 &&  (record.data.formFieldId == selectedRecord.data.formFieldId)){

            				if (e.target.tagName == 'A') {
            					var formWindow = $this.getDefaultprogramdetailsetuphelptextform();
            					if (!formWindow) {
            						Ext.widget('defaultprogramdetailsetuphelptextform');
            						formWindow = $this.getDefaultprogramdetailsetuphelptextform();
            					}
            					formWindow.show();

            					var defaultHelpText = record.data.defaultHelpText;
            					var helpTextForm = $this.getDefaultprogramdetailsetuphelptextform().down('form').getForm();
            					helpTextForm.findField('defaultHelpText').setValue(defaultHelpText);

            					if(!isNullOrEmpty(record.data.helpText)){
            						helpTextForm.findField('helpText').setValue(record.data.helpText);
            					}
            				}
            			}else{
            				if(searchResultGrid.getSelectionModel().getSelection().length>1 ){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); 
            				}
            				else if(record.data.formFieldId != selectedRecord.data.formFieldId){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_CURRENT_RECORD'));
            				}
            			}
            		}
            		else{

            			if(columnName=='helpText' && (!searchResultGrid.getSelectionModel().getSelection().length>0 || (record.data.formFieldId != selectedRecord.data.formFieldId)) )
            				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 

            		}
            	}
            	
            },
            'defaultprogramsetupconfigurescreengrid button[itemId=btnSave]':{
            	click:function(){
            		this.admSaveDefaultProgramConfigureScreenData();
            	}
            },
            'defaultprogramdetailsetuphelptextform button[itemId=cancelBtn]':{
            	click:function(obj){
            		this.getDefaultprogramdetailsetuphelptextform().close();
            	}
            },
            'defaultprogramdetailsetuphelptextform button[itemId=submitBtn]':{
            	click:function(obj){
            		var $this =this;
            		var form = obj.up('form').getForm();
            		var values = form.getValues();
            		var helpText =values.helpText;
            		var helpTextDefault = values.defaultHelpText
            		var grid = $this.getDefaultprogramsetupconfigurescreengrid();
            		var getRange = grid.getSelectionModel().selected.getRange();
            		getRange[0].set("helpText",helpText);
            		getRange[0].set("defaultHelpText",helpTextDefault);
            		$this.getDefaultprogramdetailsetuphelptextform().close();
            	}
            }
        });
    },
    disableOtherPivileges:function(grid, applicantSetupPermission){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, applicantSetupPermission);
    	var btnCopy = grid.down('#btnCopy');
    	var btnApply = grid.down('#btnApply');
    	var btnRename = grid.down('#btnRename');
    	var splitButtonAction =grid.down('#spBtnMoreActions');
    	var viewDefaultProgramSetup =grid.down('#viewDefaultProgramSetup');

    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'COPY') {
    			if(!isNullOrEmpty(btnCopy)){
    				btnCopy.setVisible(true);
    			}        		
    		}else if (privilege === 'APPLY') {
    			if(!isNullOrEmpty(btnApply)){
    				btnApply.setVisible(true);
    			} 
    		}else if (privilege === 'DEFAULT_PROGRAM_DETAILS_SETUP') {
    			if(!isNullOrEmpty(viewDefaultProgramSetup)){
    				viewDefaultProgramSetup.setVisible(true);
    			} 
    		}
    	});
    },
    VWopenAdmApplicantPortalSetUpTab:function(setUpNameValue) {
            var $this = this;
            var myjson ={  
     				"setupName":setUpNameValue
     			};  
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                method: 'post',
                url: SERVERURL.PATH_SAVE_APPLICATION_PORTAL_SETUP,
                jsonData: myjson,
                success : function(response, action) {
                	Ext.getBody().unmask();
                	var id = response.responseText;
                	if(id != "0"){
                		var contentpanel = $this.getContentpanel();
                    	var tabName = getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION');
                    	var getcontroller = $this.getController('menu.CoreERPNavigationController');
                    	var getTab = getcontroller.getTab(tabName);
                    	if (getTab != null) {
                    		contentpanel.remove(getTab, true);
                    	}
                    	var contentXtype = 'vwadmapplicantportalsetupform'; 
                    	var newTab = $this.getTabReferenceByTabTitle(tabName);
                    	if (!newTab) {
                    		newTab = contentpanel.add({
                    			xtype: contentXtype,
                    			closable: true,
                    			title: tabName,
                    			menuColorCls: CONSTANTS.MENU_COLOR_TWO
                    		});
                    	}
                    	contentpanel.setActiveTab(newTab);
                    	var applicantPortalSetupTab = newTab.down('#VWAdmAddApplicantPortalSetupTab');
                    	applicantPortalSetupTab.tab.setText(setUpNameValue);
                    	var setUpIdField = newTab.down('#setUpId');
                    	setUpIdField.setValue(id);

                    	var window = Ext.widget('vwadmaddapplicantsetupnamewin');
      				    window.down('#saveBtn').setDisabled(true);
                         
                    	var vwadmapplicantportalsetupgrid = newTab.down('#VWAdmapplicantPortalSetUpGridItemId');
                    	vwadmapplicantportalsetupgrid.getSelectionModel().deselectAll();
                    	vwadmapplicantportalsetupgrid.getStore().getProxy().extraParams={
    						id:1
    					};
                    	vwadmapplicantportalsetupgrid.getStore().load(); 
                    	var grid = $this.getApplicantportalsetupgrid();
                    	grid.getStore().reload();
                    	
                	}else{
                		showWarningMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getAdmissionTranslation('PLEASE_ENTER_UNIQUE_SETUP_NAME'));
                	}
                	
                }
            });
            
            
    },
    RenameApplicantSetupNameWin:function(setUpNameValue) {
        var $this = this;
    	var setUpGrid = $this.getApplicantportalsetupgrid();
		var record = setUpGrid.getSelectionModel().getSelection()[0];
		var setupid =record.data.id;
        var myjson ={  
 				"setupName":setUpNameValue,
 				"id":setupid,
 			};  
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            method: 'put',
            url: SERVERURL.PATH_UPDATE_APPLICATION_PORTAL_SETUP,
            jsonData: myjson,
            success : function(response, action) {
            	Ext.getBody().unmask();
            	var message = response.responseText;
            	if(message != null && message == 'Success'){
            		showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('APPLICANT_SETUP_NAME_UPDATED_SUCCESSFULLY'));
            		setUpGrid.getStore().reload();
            		setUpGrid.getSelectionModel().deselectAll();
            		}else{
            		showWarningMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getAdmissionTranslation('PLEASE_ENTER_UNIQUE_SETUP_NAME'));
            	}
            	
            }
        });
        
        
},
    saveApplicantPortalSetUPPrivilege: function() {
    	var this$ = this;
        var setUpGrid = this$.getVwadmapplicantportalsetupgrid();
        var portalSetUpForm = this$.getVwadmapplicantportalsetupform();
    	var records = setUpGrid.getStore().data.items;
    	var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
        if(records.length > 0) {        	
    	var applicantPortalModuleSetup = new Array();
    	var visibilityParam=null;
    	var mandatoryParam = null;
    	if(!isNullOrEmpty(records[0].data.applicantPortalSetupId)){
    		 Ext.each(records, function(obj) {
    			 if(obj.data.moduleCode == 'STEP4_PROGRAM_DETAILS' || obj.data.moduleCode == 'STEP10_DECLARATION_N_PAYMENTS' ){
    				  visibilityParam = true;
    				  mandatoryParam = true;
    			 }else{
    				  visibilityParam =  obj.data.visibility;
    				  mandatoryParam = obj.data.mandatory;
    			 }
    			 var applicationStatusArray = [];
    			 if( obj.data.appPortalApplicationStatus != ""){
    				 var appStatusArr = obj.data.appPortalApplicationStatus;
    			 }
	        		for( var p in appStatusArr ){
	        			var applicationStatusObj = {};
	        			var status = {};
	        			if( !isNullOrEmpty(appStatusArr[p].data) ){
	        				status = appStatusArr[p].data.id;
	        				applicationStatusObj.applicationStatus = status; 
	        			} else {
	        				status = appStatusArr[p].applicationStatus;
	        				applicationStatusObj.applicationStatus = status; 
	        			}
	        			applicationStatusObj.applicantPortalModuleSetup = {"id":obj.data.id};
	        			applicationStatusArray.push(applicationStatusObj);
	        		}			
	        		 
     			 applicantPortalModuleSetup.push({
     				"id" : obj.data.id,
     				"applicantPortalModules":this$.getIdValueJson(obj.data.applicantPortalModuleId),
     				"applicantPortalSetup":this$.getIdValueJson(applicantPortalSetupId),
     				"visibility":visibilityParam,
     				"mandatory":mandatoryParam,
     				"sequenceNo":obj.data.sequenceNo,
     				"newModuleName":obj.data.newModuleName,
     				"appPortalApplicationStatus":applicationStatusArray
     			});

         });
    	}else{
    		Ext.each(records, function(obj) {
    			if(obj.data.moduleName == 'Program Details'){
    				visibilityParam = true;
    				mandatoryParam = true;
    			}else{
    				visibilityParam =  obj.data.visibility;
    				mandatoryParam = obj.data.mandatory;
    			}
    			 var applicationStatusArray = [];
    				 
    			 if(obj.data.appPortalApplicationStatus != ""){
    				 var appStatusArr = obj.data.appPortalApplicationStatus;
    			 }
	        		for( var p in appStatusArr ){
	        			var applicationStatusObj = {};
	        			var status = {};
	        			if( !isNullOrEmpty(appStatusArr[p].data) ){
	        				status = appStatusArr[p].data.id;
	        				applicationStatusObj.applicationStatus = status; 
	        			} else {
	        				status = appStatusArr[p].applicationStatus;
	        				applicationStatusObj.applicationStatus = status; 
	        			}
	        			applicationStatusObj.applicantPortalModuleSetup = {"id":obj.data.id};
	        			applicationStatusArray.push(applicationStatusObj);
	        		}			
	        		
    				 
    			applicantPortalModuleSetup.push({
    				"applicantPortalModules":this$.getIdValueJson(obj.data.id),
    				"applicantPortalSetup":this$.getIdValueJson(applicantPortalSetupId),
    				"visibility":visibilityParam,
    				"mandatory":mandatoryParam,
    				"sequenceNo":obj.data.sequenceNo,
    				"newModuleName":obj.data.newModuleName,
    				"appPortalApplicationStatus":applicationStatusArray
    				
    			});

    		});
    	}
       
    	var recordsToUpdate = Ext.encode(applicantPortalModuleSetup);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            method: 'post',
            url: SERVERURL.PATH_SAVE_MODULE_CONFIGURATION,
            jsonData: recordsToUpdate,
            success : function(response, action) {
            	var jsonData = Ext.JSON.decode(response.responseText);
            	var response = response.responseText;
            	Ext.getBody().unmask();
            	showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));
            	var contentpanel = this$.getContentpanel();
            	var tabName = getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION');
            	var getcontroller = this$.getController('menu.CoreERPNavigationController');
            	var getTab = getcontroller.getTab(tabName);
            	if(setUpGrid.getStore().getRange().length>0){
            		setUpGrid.getStore().removeAll();
            	}
            	setUpGrid.getStore().loadData(jsonData);
            }
        });
        }
    },
    editApplicantPortal: function(recordId, isView) {
    	var $this=this;
        var grid =  this.getApplicantportalsetupgrid();
        
        if (grid.getSelectionModel().getCount() >0) {
            var record = grid.getSelectionModel().getSelection()[0];
            if (record.raw!=null && record.raw.id) {
            	var applicantPortalSetupId=record.get("id")
            	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                 Ext.Ajax.request({
                     type: 'rest',
                     method: 'GET',
                     url: SERVERURL.PATH_APPLICANT_PORTAL_MODULE_SETUP_DATA ,
                     params:{
                    	 applicantPortalSetupId:record.get("id")
					   },
					   success : function(response, action) {
						   var jsonData = Ext.JSON.decode(response.responseText);
						   Ext.getBody().unmask();
						   var contentpanel = $this.getContentpanel();
						   var tabName = getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION');
						   var getcontroller = $this.getController('menu.CoreERPNavigationController');
						   var getTab = getcontroller.getTab(tabName);
						   if (getTab != null) {
							   contentpanel.remove(getTab, true);
						   }
						   var contentXtype = 'vwadmapplicantportalsetupform'; 
						   var newTab = $this.getTabReferenceByTabTitle(tabName);
						   if (!newTab) {
							   newTab = contentpanel.add({
								   xtype: contentXtype,
								   closable: true,
								   title: tabName,
								   menuColorCls: CONSTANTS.MENU_COLOR_TWO
							   });
						   }
						   contentpanel.setActiveTab(newTab);
						   var applicantPortalSetupTab = newTab.down('#VWAdmAddApplicantPortalSetupTab');
						   applicantPortalSetupTab.tab.setText(record.data.setupName);
						   var VWAdmapplicantPortalSetUpGrid = newTab.down('#VWAdmapplicantPortalSetUpGridItemId');
						   if(VWAdmapplicantPortalSetUpGrid.getStore().getRange().length>0){
							   VWAdmapplicantPortalSetUpGrid.getStore().removeAll();
						   }
						   VWAdmapplicantPortalSetUpGrid.getStore().loadData(jsonData);
						   var setUpIdField = newTab.down('#setUpId');
						   setUpIdField.setValue(applicantPortalSetupId);

					   }
                 });
            	
            
            } } else if(grid.getSelectionModel().getCount() < 1) {
    	showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
   }
    },
    // ********* Applicant Portal Mapping **************
    getOpenApplicantPortalMappingStructure :function(){
    	var $this = this;
    	var grid = $this.getApplicantportalsetupgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var contentpanel = $this.getContentpanel();
    		var coursetabstructure = Ext.widget('vwadmapplicantportalsetupmappingstructure');
    		var tabName = getCommonTranslation('APPLICANT_SETUP_MAPPING');

    		var getcontroller=$this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentpanel.remove(getTab, true);
    		}
    		openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TWO);
    		var setUpGrid = $this.getApplicantportalsetupgrid();
    		var record = setUpGrid.getSelectionModel().getSelection()[0];
    		var gridMap = $this.getVwadmapplicantportalsetupmappingresultgrid();
    		gridMap.getStore().getProxy().extraParams={
    			applicantSetupId:record.data.id
			};
    		$this.resetPageSetting(gridMap.getStore());
    		gridMap.getStore().load();
    	}else{
    		showWarningMessage(getCommonTranslation('APPLICANT_SETUP_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record   
    	}
    },
    getRenamenApplicantPortalSetup :function(){
    	var $this = this;
    	var grid = $this.getApplicantportalsetupgrid();
    	if (grid.getSelectionModel().getCount() == 1) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		var setupname =record.data.setupName;
    		var formwindow = Ext.widget('renameapplicantsetupnamewin');
    		formwindow.show();
    	    formwindow.down('#setupName').setValue(setupname);
    	}else{
    		showWarningMessage(getCommonTranslation('APPLICANT_SETUP_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record   
    	}
    },
    VWAdmOpenApplicantSetUpDoMappingTab: function(){
    	var contentpanel = this.getContentpanel();
    	var coursetabstructure = Ext.widget('vwadmaddapplicantportalsetupmappingtab');
    	var tabName = getCommonTranslation('APPLICANT_ADD_SETUP_MAPPING');

    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TWO);
    	var academylocationgrid = this.getVmadmacademylocationgridforsetupmapping();
    	var applicantSetupWithprogrambatchseatstructure = this.getVmadmapplicantportalsetupwithprogrambatchseatstructure();
    	academylocationgrid.getStore().clearFilter();
    	academylocationgrid.getStore().load();
    	this.getVmadmapplicantportalsetupprogresstracker().setVisible(true);
    	
    	this.VMAdmResetProgressTracker();
    	var adjustmentprogresstracker = coursetabstructure.down("#vmadmapplicantportalsetupprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
    	progresstracker1.textEl.addCls("inProgressCss-progress-text");
    	progresstracker1.updateText("Step 1 In Progress");
  	  
    	if(this.getApplicantportalsetupgrid()){
    		var records = this.getApplicantportalsetupgrid().getSelectionModel().getSelection()[0];
        	if(records){
        		applicantSetupWithprogrambatchseatstructure.down("#setUpNameItemId").setValue(records.data.setupName);
        		coursetabstructure.down('#VMAdmApplicantSetupMappingName').setValue(records.get('setupName'));
        		coursetabstructure.down('#VMAdmApplicantSetupMappingId').setValue(records.get('id'));
        	}
    	}
    },
    VMAdmResetProgressTracker : function(){
    	var structure = this.getVwadmaddapplicantportalsetupmappingtab();
    	var adjustmentprogresstracker = structure.down("#vmadmapplicantportalsetupprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    	progresstracker3.reset();
    	progresstracker3.updateText('');
    	progresstracker4.reset();
    	progresstracker4.updateText('');
    },
    mapAPAdmAcademyLocationNextEvent:function(btn){
    	var academylocationgrid = this.getVmadmacademylocationgridforsetupmapping();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
    		var setUpAPwithprogrambatchseatstructure = this.getVmadmapplicantportalsetupwithprogrambatchseatstructure();
    		var programcontainer = setUpAPwithprogrambatchseatstructure.down('#programcontainer');
    		programcontainer.setDisabled(false);
    		setUpAPwithprogrambatchseatstructure.setActiveTab(programcontainer);
    		var alProgramGrid = this.getVwadmalprogramgrid();
    		var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
    		alProgramSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join()
    		};
    		//alProgramSearchCombo.getStore().load();
    		var alProgramGridStore = alProgramGrid.getStore();
    		alProgramGridStore.getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join(),
    			page:1,
    			start:0,
    			limit:-1
    		};
    		alProgramGridStore.clearFilter();
    		alProgramGridStore.load();
    		this.setAdmAPProgressTracker(1);
    		if(this.getApplicantportalsetupgrid()){
    			var records = this.getApplicantportalsetupgrid().getSelectionModel().getSelection()[0];
    			if(records){
    				var structure = this.getVwadmaddapplicantportalsetupmappingtab();
    				var setupName = structure.down('#VMAdmApplicantSetupMappingName').getValue();
    				setUpAPwithprogrambatchseatstructure.down("#setUpNameProgramTab").setValue(setupName);              	
    			}
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    setAdmAPProgressTracker : function(progresstracker){
    	  var structure = this.getVwadmaddapplicantportalsetupmappingtab();
    	  var adjustmentprogresstracker = structure.down("#vmadmapplicantportalsetupprogresstracker");

    	  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	  var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	  var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	  var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");

    	if(progresstracker==1){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker1.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker1.textEl.addCls("custom-progress-text");
  		  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
  		  progresstracker2.textEl.addCls("inProgressCss-progress-text");
  		  progresstracker2.updateText("Step 2 In Progress");
  		  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
  	  }
  	  if(progresstracker==2){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker2.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
  		  progresstracker3.textEl.addCls("inProgressCss-progress-text");
  		  progresstracker3.updateText("Step 3 In Progress");
  		  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker2.textEl.addCls("custom-progress-text");
  		  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
  	  }
  	  if(progresstracker==3){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker3.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
  		  progresstracker4.textEl.addCls("inProgressCss-progress-text");
  		  progresstracker4.updateText("Step 4 In Progress");
  		  progresstracker3.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker3.textEl.addCls("custom-progress-text");
  		  progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
  	  }
  	  if(progresstracker==4){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker4.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker4.textEl.addCls("custom-progress-text");
  		  progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
  	  }
      },
       getIdValueJson: function(id, value) {
    			if (id) return {
    				id: id,
    				value: value
    			};
    },
    //*************** delete records from DO MAPPING*******************
    getDeleteApplicantPortalSetupDoMapping:function(){
    	var grid = this.getVwadmapplicantportalsetupmappingresultgrid();
    	var grdStore = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('APPLICANT_SETUP_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method: "DELETE",
    					type: 'rest',
    					url: SERVERURL.PATH_DELETE_APPLICATION_PORTAL_SETUP_EXISTING_MAPPING+'?id='+id,
    					headers: {
    						'Content-Type': 'application/json'
    					},
    					success: function(form, action) {
    						grdStore.reload();
    						showSuccessMessage(getCommonTranslation('APPLICANT_SETUP_MAPPING'), getFeeAndPaymentCommonTranslation('APPY_TO_DELETED_SUCCESSFULLY'));
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('APPLICANT_SETUP_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	} 
    },
    admApplicantPortalSetupALProgramNextEvent: function(btn){
    	var alprogramgrid = this.getVwadmalprogramgrid();
    	var selectionModel = alprogramgrid.getSelectionModel().getSelection();
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programIdsArr.push(obj.get('programId'));
    	});
    	
    	if(programIdsArr.length > 0){
	    	var setUpWithProgramBatchSeatStructure = this.getVmadmapplicantportalsetupwithprogrambatchseatstructure();
	    	var programbatchcontainer = setUpWithProgramBatchSeatStructure.down('#programbatchcontainer');
	    	programbatchcontainer.setDisabled(false);
	    	setUpWithProgramBatchSeatStructure.setActiveTab(programbatchcontainer);
	    	
	    	var alProgramBatchGrid = this.getVwadmalprogrambatchgrid();
	    	
	    	var alProgramBatchSearchCombo = alProgramBatchGrid.down('#programbatchsearchcombo');
	    	alProgramBatchSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join()
	    	};
	    	//alProgramBatchSearchCombo.getStore().load();
	    	
	    	var alProgramBatchGridStore = alProgramBatchGrid.getStore();
	    	alProgramBatchGridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		page:1,
    			start:0,
    			limit:-1
	    	};
	    	alProgramBatchGridStore.clearFilter();
	    	alProgramBatchGridStore.load();
	    	if(this.getApplicantportalsetupgrid()){
	    		var records = this.getApplicantportalsetupgrid().getSelectionModel().getSelection()[0];
	        	if(records){
	        		var structure = this.getVwadmaddapplicantportalsetupmappingtab();
    				var setupName = structure.down('#VMAdmApplicantSetupMappingName').getValue();
    				setUpWithProgramBatchSeatStructure.down("#setUpNameProgramBatchTab").setValue(setupName);    
	        	}
	    	}
	    	this.setAdmAPProgressTracker(2);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    admALSetUpProgramBatchNextEvent:function(btn){
    	var alprogrambatchgrid = this.getVwadmalprogrambatchgrid();
    	var selectionModel = alprogrambatchgrid.getSelectionModel().getSelection();
    	var alprogramgridIdsArr = [];
    	var programIdsArr = [];
    	var batchIdsArr = [];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programIdsArr.push(obj.get('programId'));
    		batchIdsArr.push(obj.get('batchId'));
    	});
    	
    	if(batchIdsArr.length > 0){
	    	var SetUpWithProgramBatchSeatStructure = this.getVmadmapplicantportalsetupwithprogrambatchseatstructure();
	    	var programbatchseattypecontainer = SetUpWithProgramBatchSeatStructure.down('#programbatchseattypecontainer');
	    	programbatchseattypecontainer.setDisabled(false);
	    	SetUpWithProgramBatchSeatStructure.setActiveTab(programbatchseattypecontainer);
	    	
	    	var alprogrambatchseartypegrid = this.getVwadmalprogrambatchseattypegrid();
	
	    	var alProgramBatchSeatTypeGridStore = alprogrambatchseartypegrid.getStore();
	    	/*alProgramBatchSeatTypeGridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		batchIds:batchIdsArr.join()
	    	};
	    	alProgramBatchSeatTypeGridStore.clearFilter();
	    	alProgramBatchSeatTypeGridStore.load();*/
	    	var jData=new Object();
	    	 jData= {
	    			academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programIdsArr.join(),
		    		batchIds:batchIdsArr.join()
   	    		/*limit:100,
   	    		page:1,
   	    		start:0*/
   	    	};
	    	 Ext.Ajax.request({
  			  method: "POST",
  			  type: 'rest',
  			  url: SERVERURL.FIND_BY_PROGRAM_BATCH_SEAT_TYPE_AND_ACADEMY_LOCATION,
  			  params: jData,
  			  success : function(response, action) {
  				alProgramBatchSeatTypeGridStore.clearFilter();
  				alProgramBatchSeatTypeGridStore.loadData(Ext.decode(response.responseText))
//  		    	alProgramBatchSeatTypeGridStore.load();
  		    	

  				  }
  		  });
	    	if(this.getApplicantportalsetupgrid()){
	    		var records = this.getApplicantportalsetupgrid().getSelectionModel().getSelection()[0];
	        	if(records){
	        		var structure = this.getVwadmaddapplicantportalsetupmappingtab();
    				var setupName = structure.down('#VMAdmApplicantSetupMappingName').getValue();
    				SetUpWithProgramBatchSeatStructure.down("#setUpNameProgramBatchSeattypeTab").setValue(setupName);    
	        	}
	    	}
	    	this.setAdmAPProgressTracker(3);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitSetupMappingWithProgramBatchSeatType: function(btn){
    	var tabStructure = this.getVmadmapplicantportalsetupwithprogrambatchseatstructure();
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var addprogramfeemappingtab = this.getVwadmaddapplicantportalsetupmappingtab();
    	var SetupMappingId = addprogramfeemappingtab.down('#VMAdmApplicantSetupMappingId').getValue();
    	var submitJsonArr = [];
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.PATH_SAVE_APPLICANT_PORTAL_APPLY_TO_MAPPING;
    		if(activeGrid.xtype == 'vwadmalprogrambatchgrid'){
	    		selectedRecord.forEach(function(obj){
	    			submitJsonArr.push({
	    				applicantPortalSetup: {id:parseInt(SetupMappingId)},
	    				academyLocation: {id:obj.get('academyLocationId')},
	    				program:{id:obj.get('programId')},
	    				batch:{id:obj.get('batchId')},
	    				whetherBatchLevel:true
	    			});
	    		});
	    		
    		} else if(activeGrid.xtype == 'vwadmalprogrambatchseattypegrid'){
    			selectedRecord.forEach(function(obj){
	    			submitJsonArr.push({
	    				applicantPortalSetup: {id:parseInt(SetupMappingId)},
	    				academyLocation: {id:obj.get('academyLocationId')},
	    				program:{id:obj.get('programId')},
	    				batch:{id:obj.get('batchId')},
	    				seatType:{id:obj.get('programBatchSeatTypeId')},
	    				programBatchSeatConfiguration:{id:obj.get('programBatchSeatTypeId')},
	    				whetherBatchLevel:false
	    			});
	    		});
    		}
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: submitUrl,
    			scope:this,
    			jsonData:submitJsonArr,
    			success : function(response, action) {
    				var contentpanel = this.getContentpanel();
    		    	var tabName = getCommonTranslation('APPLICANT_ADD_SETUP_MAPPING');
    		    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    		    	var getTab=getcontroller.getTab(tabName);
    		    	if(getTab!=null){
    		    		contentpanel.remove(getTab, true);
    		    	}
    		    	var grid = this.getVwadmapplicantportalsetupmappingresultgrid();
    		    	var grdStore = grid.getStore();
    		    	grdStore.load();
    		    	
    		    	var data = response.responseText;
          			if(isNullOrEmpty(data)){
          				showSuccessMessage(getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'), getFeeAndPaymentCommonTranslation('APPLY_TO_CREATED_SUCCESS'));
          			} else {
          				var alertWin = this.getVwadmapplicantportalsetupmappingalertwin();
          				if(!alertWin){
          					alertWin = Ext.widget('vwadmapplicantportalsetupmappingalertwin');
          				}
          				alertWin.down('#admSetupAlertItemId').setValue(data);
          				alertWin.show();
          			}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    		},
    		loadProgramStore:function(alId){
    			var filter = this.getApplicantportalsetupfilter();
    			var program = filter.down("#programItemId");
    			program.reset();
    			program.getStore().getProxy().extraParams={
    				academyLocationIds:alId
    			};
    			//program.getStore().load();
    			var programStore = program.getStore();
    			program.setReadOnly(false);
    			programStore.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						if(records.length == 1){
    							program.setValue(records[0].data.id);
    							var model = [records[0]];
    							program.fireEvent('select', program, model);
    							program.setReadOnly(true);
    						}	 
    					}
    				}	   
    			});
    		},
    		loadProgramGroupStore: function(alId){
    			var filter = this.getApplicantportalsetupfilter();
    			var programGroup = filter.down("#programGroupItemId");
    			programGroup.reset();
    			programGroup.getStore().getProxy().extraParams={
    				academyLocationIds:alId
    			};
    			var programGroupStore = programGroup.getStore();
    			programGroupStore.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						if(records.length == 1){
    							programGroup.setValue(records[0].data.id);
    							var model = [records[0]];
    							seatType.fireEvent('select', programGroup, model);
    							programGroup.setReadOnly(true);
    						}	 
    					}
    				}	   
    			});
    		},
    		 admSaveApplicantPortalConfigureScreenData:function(){
    			 var $this = this;
    			 var grid = $this.getVwadmapplciantportalconfigurescreengrid();
    			 var academyLocationId; 
    			 var languageId;
    			 var screenMode;
    			 var screenName;
    			 var configureArray = [];
    			 var submitUrl;
    			 var selectedRecord = grid.getSelectionModel().getSelection().length;
    			 if(selectedRecord > 0){
    				 var totalCount = grid.getStore().data.length;
    				 var record = grid.getSelectionModel().getSelection();
    				 var isSequenceDefined = true;
    				 var sequenceNullFieldName = '';
    					 for(var i=0;i<record.length;i++){
    						 var isVisible;
    						 var isVisibleField = record[i].data.isVisible;
    						 if(isVisibleField == null || isVisibleField == 'Yes'){
    							 isVisible = true;
    						 }else{
    							 isVisible = false;
    						 }
    						 
    						 var isMendate;
    						 var isMendateField = record[i].data.isMandatory;
    						 if(isMendateField == null || isMendateField == 'Optional'){
    							 isMendate = false;
    						 }else if(isMendateField == true || isMendateField == 'Mandatory'){
    							 isMendate = true;
    						 }else if (isMendateField == false) {
    							 isMendate = false;
							}
    						if (record[i].data.sequenceNo == null || record[i].data.sequenceNo == undefined ||
    								record[i].data.sequenceNo == '') {
    							isSequenceDefined = false;
    							sequenceNullFieldName = record[i].data.fieldDisplayName;
							}

    						 configureArray.push({
    							 "formFieldId": record[i].data.formFieldId,
    							 "formFieldDisplaySettingId": record[i].data.formFieldDisplaySettingId,
    							 "screenName": record[i].data.screenName,
    							 "screenMode": record[i].data.screenMode,
    							 "defaultLabel": record[i].data.defaultLabel,
    							 "fieldDisplayName": record[i].data.fieldDisplayName,
    							 "isFieldLocked": record[i].data.isFieldLocked,
    							 "isMandatory": isMendate,
    							 "isVisible": isVisible,
    							 "languageId":1,
    							 "helpText": record[i].data.helpText,
    							 "defaultHelpText":record[i].data.defaultHelpText,
    							 "defaultValue": record[i].data.defaultValue,
    							 "applicantportalsetupid": record[i].data.applicantportalsetupid,
    							 "newLabel":record[i].data.newLabel,
    							 "whetherForAllAcademyLocation":false,
    							 "sequenceNo":record[i].data.sequenceNo
    						 });
    					 }
    					 
    					 if (isSequenceDefined) {
    						/* if(record[0].data.screenName == 'Personal Details Info'){
    							 $this.getAppSetupDynamicForFormFieldsInfo(null);  
    						 }*/
    						 submitUrl = SERVERURL.CONFIGURE_SCREEN_SAVE;
        					 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        					 Ext.Ajax.request({
        						 type : 'rest',
        						 url : submitUrl,
        						 async: false,
        						 jsonData : configureArray,
        						 method : 'POST',
        						 success : function(form, action) {
        							 Ext.getBody().unmask();
        							 showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),getCommonTranslation('SUCCESS'));
        							 grid.getStore().reload();
        						 }
        					 });
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_ENTER_SEQUENCE')+' For '+sequenceNullFieldName); 
						}
    			  } 
    		  else{
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    		   }
    		 },
    		 admSaveApplicantPortalCustomColumnSetup:function(){
    		    	var this$ = this;
    		        var setUpGrid = this$.getVwadmapplicantportalsetupcustomcolumngrid();
    		        var portalSetUpForm = this$.getVwadmapplicantportalsetupform();
    		    	var records = setUpGrid.getStore().data.items;
    		    	var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
    		    	var moduleId = this$.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
    		        if(records.length > 0) {        	
    		    	var customColumnModuleSetup = new Array();
    		    	var visibilityParam=null;
    		    	var mandatoryParam = null;
    		    		 Ext.each(records, function(obj) {
    		    			 var mandatory;
    		    			 if (obj.data.isVisible == null || obj.data.isVisible == false) {
    		    				 mandatory = false;
							}else{
								mandatory = obj.data.isMandatory;
							}
    		    			 customColumnModuleSetup.push({
    		     				"id" : obj.data.id,
    		     				"applicantPortalModules":this$.getIdValueJson(obj.data.applicantPortalModules.id),
    		     				"applicantPortalSetup":this$.getIdValueJson(parseInt(obj.data.applicantPortalSetup.id)),
    		     				"customFieldConfig":this$.getIdValueJson(obj.data.customFieldConfig.id),
    		     				"isVisible":obj.data.isVisible,
    		     				"isMandatory":mandatory,
    		     				"sequenceNo":obj.data.sequenceNo,
    		     				"whetherCustomField":obj.data.whetherCustomField
    		     			});

    		         });
    		    	var recordsToUpdate = Ext.encode(customColumnModuleSetup);
    		        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		        Ext.Ajax.request({
    		            type: 'rest',
    		            method: 'post',
    		            url: SERVERURL.PATH_CREATE_CUSTOM_FIELD_CONFIG_SETUP,
    		            jsonData: recordsToUpdate,
    		            success : function(response, action) {
    		            	var jsonData = Ext.JSON.decode(response.responseText);
    		            	var response = response.responseText;
    		            	Ext.getBody().unmask();
    		            	showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));
    		            	if(setUpGrid.getStore().getRange().length>0){
    		            		setUpGrid.getStore().removeAll();
    		            	}
    		            	setUpGrid.getStore().loadData(jsonData);
    		            }
    		        });
    		        }
    		    },
    		    admSaveApplicantPortalDataReqSetup:function(){
 		    	var this$ = this;
 		        var setUpGrid = this$.getVwadmapplicantportalsetupdatarequirementgrid();
 		        var portalSetUpForm = this$.getVwadmapplicantportalsetupform();
 		        var guideLineForm = this$.getUploaddocrequirementdatasetup();
 		    	var records = setUpGrid.getStore().data.items;
 		    	var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
 		        if(records.length > 0) {        	
 		    	var customColumnModuleSetup = new Array();
 		    	var visibilityParam=null;
 		    	var mandatoryParam = null;
 		    	var examPassed = null;
 		    	var competitiveExam = null;
 		    	var sequence = 0;
 		    		 Ext.each(records, function(obj) {
 		    			 var mandatory;
 		    			 if (obj.data.isVisible == null || obj.data.isVisible == false) {
 		    				 mandatory = false;
 		    			 }else{
 		    				 mandatory = obj.data.isMandatory;
 		    			 }
 		    			 if (obj.data.examPassed != null) {
 		    				 examPassed = this$.getIdValueJson(obj.data.examPassed.id);
 		    			 }
 		    			 if (obj.data.competitiveExam != null) {
 		    				 competitiveExam = this$.getIdValueJson(obj.data.competitiveExam.id);
 		    			 }
		    			
 		    			 customColumnModuleSetup.push({
 		     				"id" : obj.data.id,
 		     				"applicantPortalModules":this$.getIdValueJson(obj.data.applicantPortalModules.id),
 		     				"applicantPortalSetup":this$.getIdValueJson(obj.data.applicantPortalSetup.id),
 		     				"examPassed":examPassed,
 		     				"competitiveExam":competitiveExam,
 		     				"parentGuardianCode":obj.data.parentGuardianCode,
 		     				"relatedPersonAddressCode":obj.data.relatedPersonAddressCode,
 		     				"maximumEntry":obj.data.maximumEntry,
 		     				"minimumEntry":obj.data.minimumEntry,
 		     				"isVisible":obj.data.isVisible,
 		     				"isMandatory":mandatory,
 		     				"sequence":sequence,
 		     				"guideline":guideLineForm.down('#instructionsItemId').getValue(),
 		     				"guidelineOtherLang":guideLineForm.down('#instructionsInOtherLangItemId').getValue()
 		     			});
 		    			sequence++;
 		         });
 		       
 		    	var recordsToUpdate = Ext.encode(customColumnModuleSetup);
 		        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 		        Ext.Ajax.request({
 		            type: 'rest',
 		            method: 'post',
 		            url: SERVERURL.PATH_CREATE_DATA_REQUIREMENT_SETUP,
 		            jsonData: recordsToUpdate,
 		            success : function(response, action) {
 		            	var jsonData = Ext.JSON.decode(response.responseText);
 		            	var response = response.responseText;
 		            	Ext.getBody().unmask();
 		            	showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));
 		            	if(setUpGrid.getStore().getRange().length>0){
 		            		setUpGrid.getStore().removeAll();
 		            	}
 		            	setUpGrid.getStore().loadData(jsonData);
 		            }
 		        });
 		        }
 		    },
 		   saveHostelPersonalRequirement:function(){
 			   var $this = this;
 			   var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
 			   var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
 			   var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
 			   var moduleCode = $this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
 			   var form = $this.getHostelrequirementdatasetup();
 			   var guidelineField = form.down('#instructionsItemId');
 			   var hostlReeqinstructionsOtherLang =  form.down('#hostlReeqinstructionsOtherLang');
 			   var idField = form.down('#Id');
 			   var mainForm = form.down('#hostelRequirementDocumentId');
 			   var dataRequirement = new Array();
 			   if (isNullOrEmpty(guidelineField.getValue())) {
 				  showWarningMessage(getPersonModuleTranslation('DOCUMENT'), getCommonTranslation('FILL_FORM_FIELD_DETAILS'));
 			   }else{
 				  dataRequirement.push({
 					   "id":idField.getValue(),
 	 				   "applicantPortalModules":$this.getIdValueJson(moduleId),
 	 				   "applicantPortalSetup":$this.getIdValueJson(applicantPortalSetupId),
 	 				   "guideline":guidelineField.getValue(),
 	 				  "guidelineOtherLang":hostlReeqinstructionsOtherLang.getValue(),
 	 				   "isVisible": true
 	 			   });

 	 			   var recordsToUpdate = Ext.encode(dataRequirement[0]);
 	 			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 	 			   Ext.Ajax.request({
 	 				   type: 'rest',
 	 				   method: 'post',
 	 				   url: SERVERURL.PATH_SAVE_HOSTEL_PERSON_REQUIREMENT,
 	 				   jsonData: recordsToUpdate,
 	 				   success : function(response, action) {
 	 					  var data = Ext.decode(response.responseText);
 	 					  idField.setValue(data.id);
 	 					  guidelineField.setValue(data.guideline);
 	 					  Ext.getBody().unmask();
 	 					  showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));

 	 				   }
 	 			   }); 
 			   }
 			   
 		   },
 		   uploadDocument:function(form, moduleCode, id){
 			   var $this = this;
 			   var photoUrl;
 			   var mainForm = form.down('#hostelRequirementDocumentId');
 			   var photoFileImage = mainForm.down('#file');
 			   var fileUploadPath = photoFileImage.getValue();

 			   if(!isNullOrEmpty(fileUploadPath)){

 				   var mainForm = form.down('#hostelRequirementDocumentId');
 				   form.down('#availableDocumentLabelItemId').setVisible(true);
 				   var removeImg = mainForm.down('#removeFile');

 				   if(fileUploadPath.length>10){
 					   var newFileName = fileUploadPath.substring(0,10);
 					   newFileName = newFileName+'...';
 					   form.down('#availableDocumentLabelItemId').setValue('<a href=#><b class="menu-title">'+newFileName+'</b></a>');
 				   }else{
 					   form.down('#availableDocumentLabelItemId').setValue('<a href=#><b class="menu-title">'+fileUploadPath+'</b></a>');
 				   }
 				   removeImg.setVisible(true);

 				   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
 				   mainForm.getForm().submit({
 					   method : 'POST',
 					   url : SERVERURL.PATH_DATA_REQUIREMENT_UPLOAD_DOCUMENT_IMAGE,
 					   async: false,
 					   params:{
 						   module : moduleCode,
 						   entityId:id
 					   },
 					   success : function(form, action){
 						   photoUrl=action.result.path;
 					   }
 				   });
 			   }
 		   },
 	      saveUploadDocumentRequirement:function(btn){
			   var $this = this;
			   var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
			   var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
			   var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
			   var moduleCode = $this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
			   var form = $this.getUploaddocrequirementdatasetup();
			   var guideLineForm = btn.up('form');
			   var guidelineField = guideLineForm.down('#instructionsItemId');
			   var guidelineInOtherLangField = guideLineForm.down('#instructionsInOtherLangItemId');
			   var uploadDocument = form.down('#uploaddocumentlistId');
			   var idField = form.down('#Id');
		
			   var dataRequirement = new Array();
			   if (isNullOrEmpty(guidelineField.getValue())) {
				  showWarningMessage(getPersonModuleTranslation('DOCUMENT'), getCommonTranslation('FILL_FORM_FIELD_DETAILS'));
			   }else{
				  dataRequirement.push({
					   "id":idField.getValue(),
	 				   "applicantPortalModules":$this.getIdValueJson(moduleId),
	 				   "applicantPortalSetup":$this.getIdValueJson(applicantPortalSetupId),
	 				   "guideline":guidelineField.getValue(),
	 				   "guidelineOtherLang":guidelineInOtherLangField.getValue(),
	 				   "isVisible": true
	 			   });

	 			   var recordsToUpdate = Ext.encode(dataRequirement[0]);
	 			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 			   Ext.Ajax.request({
	 				   type: 'rest',
	 				   method: 'post',
	 				   url: SERVERURL.PATH_SAVE_UPLOAD_DOCUMENT_REQUIREMENT,
	 				   jsonData: recordsToUpdate,
	 				   success : function(response, action) {
	 					  var data = Ext.decode(response.responseText);
	 					  idField.setValue(data.id);
	 					  guidelineField.setValue(data.guideline);
	 					  Ext.getBody().unmask();
	 					  showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));

	 				   }
	 			   }); 
			   }
			   
		   },
 		  saveAdditionalSetup:function(){
 			   var $this = this;
 			   var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
 			   var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
 			   var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
 			   var moduleCode = $this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
 			   var form = $this.getPaymentadditionalsetup();
 			   var declarationField = form.down('#declarationsItemId');
 			   var feeApplicableField = form.down('#feeApplicableTypeId'); 		
 			   var idField = form.down('#Id');
 			   
 			   var dataRequirement = new Array();
 			   
 				  dataRequirement.push({
 					   "id":idField.getValue(),
 	 				   "applicantPortalModules":$this.getIdValueJson(moduleId),
 	 				   "applicantPortalSetup":$this.getIdValueJson(applicantPortalSetupId),
 	 				   "guideline":form.getValues().declarations,
 	 				   "isOneTimeFee": form.getValues().feeApplicableType,
 	 				   "guidelineOtherLang":form.getValues().InsGuideInOtherLang,
 	 				   "isVisible": true
 	 			   });

 	 			   var recordsToUpdate = Ext.encode(dataRequirement[0]);
 	 			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 	 			   Ext.Ajax.request({
 	 				   type: 'rest',
 	 				   method: 'post',
 	 				   url: SERVERURL.PATH_SAVE_ADDITIONAL_SETUP,
 	 				   jsonData: recordsToUpdate,
 	 				   success : function(response, action) {
 	 					  var data = Ext.decode(response.responseText);
 	 					  idField.setValue(data.id);
 	 					  declarationField.setValue(data.guideline);
 	 					 if(data.isOneTimeFee == true){
 	 						feeApplicableField.items.items[0].setValue(true);
 	 						feeApplicableField.items.items[1].setValue(false);
	                	   }
 	 					else
	                	   {
 	 						feeApplicableField.items.items[0].setValue(false);
 	 						feeApplicableField.items.items[1].setValue(true);
	                	    }
 	 					  Ext.getBody().unmask();
 	 					  showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));

 	 				   }
 	 			   }); 
 			   
 		   },
 		   admSaveProgramDetailLimitAPSetup:function(){
 			   var $this = this;
 			   var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
 			   var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
 			   var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
 			   var form = $this.getVwadmprogramdetaildatarequirementapsetup();
 			   var programLimitField = form.down('#admProgramLimitItemId');
 			   var programLimitValue = programLimitField.getValue();
 			   var mOfferLetter = form.down('#allowMultipleAdmissionOffer').getValue();
 			   if(!isNullOrEmpty(programLimitValue)){
 				   var idField = form.down('#Id');
 				   var dataRequirement = new Array();
 				   dataRequirement.push({
 					   "id":idField.getValue(),
 					   "applicantPortalModules":$this.getIdValueJson(moduleId),
 					   "applicantPortalSetup":$this.getIdValueJson(applicantPortalSetupId),
 					   "maximumEntry":programLimitValue,
 					   "isVisible": true,
 					   "isMultipleOfferLetters":mOfferLetter,
 					  "guideline":form.down('#instructionsItemId').getValue(),
 					  "guidelineOtherLang":form.down('#VWAdminstructionsOtherLang').getValue()
 				   });

 				   var recordsToUpdate = Ext.encode(dataRequirement[0]);
 				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 				   Ext.Ajax.request({
 					   type: 'rest',
 					   method: 'post',
 					   url: SERVERURL.PATH_SAVE_HOSTEL_PERSON_REQUIREMENT,
 					   jsonData: recordsToUpdate,
 					   success : function(response, action) {
 						   var data = Ext.decode(response.responseText);
 						   idField.setValue(data.id);
 						  programLimitField.setValue(data.maximumEntry);
 						   Ext.getBody().unmask();
 						   showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));

 					   }
 				   });  
 			   }else{
 				  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SET_PROGRAM_LIMIT'));
 			   }
 		   },
 		  addSaveOnlinePaymentSetup:function(){
			   var $this = this;
			   var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
			   var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
			   var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
			   var form = $this.getVwadmonlinepaymentdatarequirementapsetup();
			  /* var programLimitField = form.down('#admProgramLimitItemId');
			   var programLimitValue = programLimitField.getValue();*/
			   var mOfferLetter = form.down('#onlinePaymentUrl').getValue();
			   var vWAdminstructionsOtherLang = form.down('#VWAdminstructionsOtherLang').getValue();
			   var instructionsItemId = form.down('#instructionsItemId').getValue();
			   if(!isNullOrEmpty(mOfferLetter) || !isNullOrEmpty(vWAdminstructionsOtherLang) || !isNullOrEmpty(instructionsItemId)){
				   var idField = form.down('#Id');
				   var dataRequirement = new Array();
				   dataRequirement.push({
					   "id":idField.getValue(),
					   "applicantPortalModules":$this.getIdValueJson(moduleId),
					   "applicantPortalSetup":$this.getIdValueJson(applicantPortalSetupId),
					 //  "maximumEntry":programLimitValue,
					   "isVisible": true,
					   "onlinePaymentUrl":mOfferLetter,
					  "guideline":form.down('#instructionsItemId').getValue(),
					  "guidelineOtherLang":form.down('#VWAdminstructionsOtherLang').getValue()
				   });

				   var recordsToUpdate = Ext.encode(dataRequirement[0]);
				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   Ext.Ajax.request({
					   type: 'rest',
					   method: 'post',
					   url: SERVERURL.PATH_SAVE_HOSTEL_PERSON_REQUIREMENT,
					   jsonData: recordsToUpdate,
					   success : function(response, action) {
						   var data = Ext.decode(response.responseText);
						   idField.setValue(data.id);
						 // programLimitField.setValue(data.maximumEntry);
						   Ext.getBody().unmask();
						   showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));

					   }
				   });  
			   }else{
				  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SET_PROGRAM_LIMIT'));
			   }
		   },
 	      //******* get Doc Controller**********
 	      getDocumentController : function(){
 	        	var this$ = this;
 	        	return this$.getController('Academia.controller.document.DocumentController');
 	        },
 	      isValidFileExtensionForGuidelinesDocument: function(extension) {
 			if (!isNullOrEmpty(extension)) {
 				extension = extension.toLowerCase();
 				if (extension == "gif" || extension == "png" || extension == "jpeg" || extension == "jpg"
 					|| extension == "pdf" || extension == "doc" || extension == "docx" || extension == "txt"
 	   				|| extension == "xls" || extension == "xlsx" || extension == "odt" || extension == "ods"
 	   				|| extension == "ppt" || extension == "pptx") {
 					return true;
 				}
 			}
 			return false;
 		},
 	    // *********** Upload Guidelines document ************
 		saveGuidelinesDocument : function(obj){

 	    	var $this=this;
 	    	var isTransient = true;
 	    	var module = 'applicantportalsetup';
 	    	var entityId ;
 	    	var entityType = 'applicantportalsetup';

 	    	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'GUIDELINES_DOCUMENT', function(success, response, isCallBackTransient){
 	    		var documentList = $this.getUploaddocrequirementdatasetup().down('#uploaddocumentlistId');
 	    		var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
 				var applicantPortalSetupId = portalSetUpForm.down('#setUpId').getValue();
 				var moduleId = $this.getStcadmapplicantportalconfigurescreen().down('#moduleItemId').getValue();
 				var moduleCode = $this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
 				var id = null;
 				var isGrid = false;
 				var dataReqSetupId = null;
 				if (moduleCode == 'STEP4_PROGRAM_DETAILS') {
 					var form = $this.getVwadmprogramdetaildatarequirementapsetup();
 					id = form.down('#Id');
 					dataReqSetupId = id.getValue();
				}else if (moduleCode == 'STEP9_UPLOAD_DOCUMENTS' ||  moduleCode == 'STEP1_PERSTONAL_DETAILS'
					||  moduleCode == 'STEP28_FEE_PAYER_DETAILS' || moduleCode == 'STEP34_POST_SCHOOL_STUDIES') {
 	    		var form = $this.getUploaddocrequirementdatasetup();
					id = form.down('#Id');
					dataReqSetupId = id.getValue();
				}else if (moduleCode =='STEP23_ONLINE_PAYMENTS') {
					var form = $this.getVwadmonlinepaymentdatarequirementapsetup();
						id = form.down('#Id');
						dataReqSetupId = id.getValue();
					}else if (moduleCode == 'STEP11_PARENTS_AND_GUARDIANS' || moduleCode == 'STEP5_EDUCATION_BACKGROUND' 
					|| moduleCode == 'STEP8_ENGLISH_LANGUAGE_COMPETENCY' || moduleCode == 'STEP2_CONTACT_DETAILS') {
					isGrid = true;
				}else if(moduleCode == 'STEP26_1_HOSTEL_PERSONAL_REQUIREMENTS'){
					var form = $this.getHostelrequirementdatasetup();
					id = form.down('#Id');
					dataReqSetupId = id.getValue();
				}else if (moduleCode == 'STEP10_DECLARATION_N_PAYMENTS') {
					var form = $this.getPaymentadditionalsetup();
					id = form.down('#Id');
					dataReqSetupId = id.getValue();
				}
 	    		var values = new Object();
 	    	
 	    			var data = [{
 	    				"createdBy": $this.getIdValueJson(response.createdBy.id),
 	    				"name": response.name,
 	    				"path": response.path,
 	    				"type": response.type
 	    		    	}];
 	    					values.id = dataReqSetupId;
 	    					values.documents = data;
 	    					values.applicantPortalModules = $this.getIdValueJson(moduleId);
 	 					    values.applicantPortalSetup = $this.getIdValueJson(applicantPortalSetupId);
 	 					    values.isVisible = true;
 	 					    values.isGrid = isGrid;

 	    					var submitData = Ext.encode(values);

 	    					Ext.Ajax.request({
 	    						type : 'rest',
 	    						url : SERVERURL.PATH_UPDATE_GUIDELINES_DOCUMENT,
 	    						jsonData : submitData,
 	    						method : 'POST',
 	    						success : function(response, action) {
 	    							$this.hideWindowMask();
 	    							if (!isNullOrEmpty(response.responseText)) {
 	    							var data = Ext.decode(response.responseText);
 	    							id.setValue(data);
 	    							if(dataReqSetupId == null || dataReqSetupId == ""){
 	    								dataReqSetupId = data;
 	    							}
									}
 	    							var URL = SERVERURL.PATH_FIND_ALL_GUIDELINES_DOCUEMNTS +'?dataReqSetupId='+dataReqSetupId;
 	    							if (isGrid) {
 	    								URL = SERVERURL.PATH_FIND_ALL_GUIDELINES_DOCUEMNTS_BY_SETUP_AND_MODULE_ID+'?applicantPortalSetupId='+applicantPortalSetupId+
 	    								'&applicantPortalModuleId='+moduleId;
									}
 	    							Ext.Ajax.request({
 	    	    						type: 'rest',
 	    	    						url: URL,
 	    	    						method: 'GET',
 	    	    						success: function(res, action) {
 	    	    							var data = Ext.decode(res.responseText);
 	    	    							if(!isEmpty(data)){
 	    	    	    							var uploaddocumentlist = $this.getUploaddocumentlist();
 	    	    	    							var store = uploaddocumentlist.getStore();
 	    	    	               					store.getProxy().extraParams = {
	    	    	              						applicantPortalSetupId: applicantPortalSetupId,
	    	    	              						applicantPortalModuleId: moduleId
 	    	    	               					};
 	    	    	               					store.removeAll();
 	    	    	               					store.reload();
 	    	    							}
 	    	    						}
 	    	    					});
 	    							showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
 	    						}
 	    					});    
 	    		$this.getDocumentController().closeDocumentFormWindow();
 	    	}, isTransient);
 	    },
 	   getDownloadFileForGuidelinesDocument : function(documentId){
        	if(!isNullOrEmpty(documentId)){
        		var csvForm = Ext.create('Ext.form.Panel'); 
        		csvForm.getForm().submit({
        			target: '_blank',
        			method:'GET',
        			params :{
        				access_token : Ext.Ajax.defaultHeaders.access_token
        			},
        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
        			standardSubmit :true
        		});
        	}
        },
        deleteGuidelineDocument:function(obj){
       	 var $this=this;
       	var portalSetUpForm = $this.getVwadmapplicantportalsetupform();
		var moduleCode = $this.getStcadmapplicantportalconfigurescreen().down('#moduleNameItemId').getValue();
		 var uploaddocumentlist = null;
		/*if (moduleCode == 'STEP4_PROGRAM_DETAILS') {
				var form = $this.getVwadmprogramdetaildatarequirementapsetup();
				uploaddocumentlist = form.down('#uploaddocumentlistId');
		}else if (moduleCode == 'STEP9_UPLOAD_DOCUMENTS' ||  moduleCode == 'STEP1_PERSTONAL_DETAILS') {
			var form = $this.getUploaddocrequirementdatasetup();
			uploaddocumentlist = form.down('#uploaddocumentlistId');
		}*/
		 var uploaddocumentlist = obj.up('form').down('#uploaddocumentlistId');
       	 	// var uploaddocumentlist = $this.getUploaddocumentlist();
        	 if (uploaddocumentlist.getSelectionModel().getCount() > 0) {
        		 var records = uploaddocumentlist.getSelectionModel().getSelection()[0];
	        		if(!isNullOrEmpty(records.data.guidelinesDocumentId)){
	        			var submitURL = SERVERURL.PATH_GUIDELINES_DOC_DELETE+'?id='+records.data.guidelinesDocumentId;
	        		}
        		 showConfirmMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
        			 if (btn == 'yes'){
        				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        				 Ext.Ajax.request({
        					 method: "DELETE",
        					 type: 'rest',
        					 url : submitURL,
        					 headers: {
        						 'Content-Type': 'application/json'
        					 },
        					 success: function(form, action) {
        						 Ext.getBody().unmask();
        						 showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));	 
        						 uploaddocumentlist.store.reload();
        						 uploaddocumentlist.getSelectionModel().deselectAll(true);
        					 }
        				 });
        			 }
        		 });
        	 } else {
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	 }
         },
         
         copyApplicantPortalSetup : function(setUpNameValue) {
 			  var $this=this;
 			 var myjson ={  
      				"setupName":setUpNameValue
      			};  
 			  var grid =  this.getApplicantportalsetupgrid();
 				 var record = grid.getSelectionModel().getSelection()[0];
 				 if (record.raw!=null && record.raw.id) {
 	            	var applicantPortalSetupId=record.get("id")
 	            	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 	            	 Ext.Ajax.request({
 	                     type: 'rest',
 	                     method: 'GET',
 	                     url: SERVERURL.PATH_COPY_APPLICANT_PORTAL_SETUP,
 	                     params:{
 	                    	 oldSetupId:applicantPortalSetupId,
 	                    	 setupName : setUpNameValue
 						   },
 						   success : function(response, action) {
 							   Ext.getBody().unmask();
 							  var id = response.responseText;
 			                	if(id != "0"){
 			                		Ext.Ajax.request({
 			                           type: 'rest',
 			                           method: 'GET',
 			                           url: SERVERURL.PATH_APPLICANT_PORTAL_MODULE_SETUP_DATA ,
 			                           params:{
 			                          	 applicantPortalSetupId:id
 			      					   },
 			      					   success : function(response, action) {
 			      						   var jsonData = Ext.JSON.decode(response.responseText);
 			      						   Ext.getBody().unmask();
 			      						   var contentpanel = $this.getContentpanel();
 			      						   var tabName = getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION');
 			      						   var getcontroller = $this.getController('menu.CoreERPNavigationController');
 			      						   var getTab = getcontroller.getTab(tabName);
 			      						   if (getTab != null) {
 			      							   contentpanel.remove(getTab, true);
 			      						   }
 			      						   var contentXtype = 'vwadmapplicantportalsetupform'; 
 			      						   var newTab = $this.getTabReferenceByTabTitle(tabName);
 			      						   if (!newTab) {
 			      							   newTab = contentpanel.add({
 			      								   xtype: contentXtype,
 			      								   closable: true,
 			      								   title: tabName,
 			      								   menuColorCls: CONSTANTS.MENU_COLOR_TWO
 			      							   });
 			      						   }
 			      						   contentpanel.setActiveTab(newTab);
 			      						   var applicantPortalSetupTab = newTab.down('#VWAdmAddApplicantPortalSetupTab');
 			      						   applicantPortalSetupTab.tab.setText(setUpNameValue);
 			      						   var VWAdmapplicantPortalSetUpGrid = newTab.down('#VWAdmapplicantPortalSetUpGridItemId');
 			      						   if(VWAdmapplicantPortalSetUpGrid.getStore().getRange().length>0){
 			      							   VWAdmapplicantPortalSetUpGrid.getStore().removeAll();
 			      						   }
 			      						   VWAdmapplicantPortalSetUpGrid.getStore().loadData(jsonData)
 			      						   var setUpIdField = newTab.down('#setUpId');
 			      						   setUpIdField.setValue(id);
 			      					   }
 			                       });
 			                	}else{
 			                		showWarningMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getAdmissionTranslation('PLEASE_ENTER_UNIQUE_SETUP_NAME'));
 			                	}
 							  grid.getStore().reload();
 						   }
 	                 });
 				 }
 			  },
 			  getAppSetupDynamicForFormFieldsInfo : function(PBsTId,formInfo,formAlias){
 				  var this$ = this;
 					 Ext.Ajax.request({
 	 					url: SERVERURL.PATH_FIND_APPLICANTPROFILE_DFR,
 	 					method: 'GET',
 	 					async: false,
 	 					params: {
 	 						programBatchSeatConfigurationId:PBsTId,
 	 						formAliasName:formAlias
 	 					},
 	 					success: function(response) {
 	 						if(!isNullOrEmpty(response.responseText))
 	 						{
 	 							if(!isNullOrEmpty(formInfo.up('applicantprofile'))){
 	 								formInfo.up('applicantprofile').isApplicantPortalSetup = true;
 	 							}
 	 							var json = JSON.parse(response.responseText);
 	 							var fieldInfo = Academia.model.authentication.FormPersonalInfoFieldInfoModel;
 	 							fieldInfo.set("formPersonalInfoFieldsInfo", json);
 	 							this$.formApplicantPersonalInfoFieldItems(formInfo);
 	 						}
 	 					}
 	 				});
 			  },
 			  getDFRForApplicantProfileURL:function(formInfo){
 				  var me = this;
 					  try{
 						  if(Ext.ComponentQuery.query('contentpanel')[0].getActiveTab().xtype=='applicantprofile' && (formInfo.superclass.$className == 'Academia.view.common.IdGeneratorCustomForm' || formInfo.superclass.$className == 'Academia.view.common.DynamicFieldForm')){
 							  var selectionGridStore = Ext.ComponentQuery.query('selectionsnapshotgrid')[0].getStore();
 							  var PBsTId = selectionGridStore.data.items[0].data.programBatchSeatConfigurationId;
 							  var formAlias = formInfo.xtype;
 							  if(formAlias == 'addressfieldsform'){
 								  formAlias = 'addressformwindow';
 							  }
 							  me.getAppSetupDynamicForFormFieldsInfo(PBsTId,formInfo,formAlias);	
 						  }
 					  }
 					  catch(e){

 					  }
 			  },
 			 unmappApplicantPortalSetup:function(){
 				 var me = this;
 				 var grid = this.getApplicantportalsetupgrid();
 				 var grdStore = grid.getStore();
 				 if (grid.getSelectionModel().getCount() > 0) {
 					 var records = grid.getSelectionModel().getSelection();
 					if(!isNullOrEmpty(records[0].get("mappingStatus")) && records[0].get("status") == true){
 						showConfirmMessage(getCommonTranslation('APPLICANT_PORTAL_SETUP'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
 	 						 if (btn == 'yes') {
 	 							 var id = records[0].get("id");
 	 							 Ext.Ajax.request({
 	 								 method: "DELETE",
 	 								 type: 'rest',
 	 								 url: SERVERURL.PATH_DELETE_APPLICATION_PORTAL_SETUP_EXISTING_MAPPING+'?setupId='+id,
 	 								 headers: {
 	 									 'Content-Type': 'application/json'
 	 								 },
 	 								 success: function(form, action) {
 	 									 grid.getSelectionModel().deselectAll();
 					       				  grdStore.load();
 	 									 showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_SETUP'), getCommonTranslation('APPLICANT_PORTAL_SETUP_DELETED'));
 	 								 }
 	 							 });
 	 						 }
 	 					 });
					}else{
						 showWarningMessage(getCommonTranslation('APPLICANT_PORTAL_SETUP'), getCommonTranslation('CAN_NOT_DELETE_INACTIVE_SETUP')); //Please select a record
					}
 					 
 				 } else {
 					 showWarningMessage(getCommonTranslation('APPLICANT_PORTAL_SETUP'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
 				 } 
 			 },
 			disableDashboardTabPivileges: function(structureReference, permissionsMap) {
 	        	var me = this;
 	        	var associatedAcadLocationIds = new Array();
 	        	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
 	        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 	        	var tabName= getCommonTranslation('SEARCH');
	        		var contentXtype ='applicantportalsetupform';
	        		var itemId='applicantportalsetupform';

	        		var	newTab = structureReference.add({
	        			xtype:contentXtype,
	        			itemId:itemId,
	        			closable: false,
	        			title: tabName,
	        		});
 	        	Ext.each(permissionList, function(privilege) {
 	        		if (privilege === 'VIEW') {
 	        			var tabName= getCommonTranslation('DASHBOARD');
 	        			var contentXtype ='dashboarddatarequirementdatasetuppanel';
 	        			var itemId='dashboarddatarequirementdatasetuppanel';

 	        			structureReference.add({
 	        				xtype:contentXtype,
 	    					itemId:itemId,
 	        				closable: false,
 	        				title: tabName,
 	        			});
 	        		}
 	        	});
 	        	structureReference.setActiveTab(newTab);
 	        },
 	       saveDashboardGuidelinesDocument : function(obj){

 	 	    	var $this=this;
 	 	    	var isTransient = true;
 	 	    	var module = 'applicantportalsetup';
 	 	    	var entityId ;
 	 	    	var entityType = 'applicantportalsetup';

 	 	    	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DASHBOARD_GUIDELINES_DOCUMENT', function(success, response, isCallBackTransient){
 	 	    		var documentList = $this.getDashboarddatarequirementdatasetup().down('#dashboarduploaddocumentlistId');
 	 				var isGrid = false;
 					var form = $this.getDashboarddatarequirementdatasetup();
 					var id = form.down('#Id');
 					var dataReqSetupId = id.getValue();
 	 	    		var values = new Object();
 	 	    		var moduleId = form.down('#moduleTypeId').getValue();
 	 	    	
 	 	    			var data = [{
 	 	    				"createdBy": $this.getIdValueJson(response.createdBy.id),
 	 	    				"name": response.name,
 	 	    				"path": response.path,
 	 	    				"type": response.type
 	 	    		    	}];
 	 	    					values.id = dataReqSetupId;
 	 	    					values.documents = data;
 	 	    					values.applicantPortalModules = $this.getIdValueJson(moduleId);
 	 	 					    values.isVisible = true;
 	 	 					    values.isGrid = isGrid;

 	 	    					var submitData = Ext.encode(values);

 	 	    					Ext.Ajax.request({
 	 	    						type : 'rest',
 	 	    						url : SERVERURL.PATH_UPDATE_GUIDELINES_DOCUMENT,
 	 	    						jsonData : submitData,
 	 	    						method : 'POST',
 	 	    						success : function(response, action) {
 	 	    							$this.hideWindowMask();
 	 	    							if (!isNullOrEmpty(response.responseText)) {
 	 	    							var data = Ext.decode(response.responseText);
 	 	    							id.setValue(data);
 	 	    							if(dataReqSetupId == null || dataReqSetupId == ""){
 	 	    								dataReqSetupId = data;
 	 	    							}
 										}
 	 	    							var URL = SERVERURL.PATH_FIND_ALL_GUIDELINES_DOCUEMNTS +'?dataReqSetupId='+dataReqSetupId;
 	 	    							Ext.Ajax.request({
 	 	    	    						type: 'rest',
 	 	    	    						url: URL,
 	 	    	    						method: 'GET',
 	 	    	    						success: function(res, action) {
 	 	    	    							var data = Ext.decode(res.responseText);
 	 	    	    							if(!isEmpty(data)){
 	 	    	    	    							var uploaddocumentlist = $this.getDashboarduploaddocumentlist();
 	 	    	    	    							var store = uploaddocumentlist.getStore();
 	 	    	    	               					store.getProxy().extraParams = {
 		    	    	              						applicantPortalModuleId: moduleId
 	 	    	    	               					};
 	 	    	    	               					store.removeAll();
 	 	    	    	               					store.reload();
 	 	    	    							}
 	 	    	    						}
 	 	    	    					});
 	 	    							showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
 	 	    						}
 	 	    					});    
 	 	    		$this.getDocumentController().closeDocumentFormWindow();
 	 	    	}, isTransient);
 	 	    },
 	 	  deleteDashboardGuidelineDocument:function(obj){
 	       	 var $this=this;
 			 var form=$this.getDashboarddatarequirementdatasetup();
 			 var uploaddocumentlist = form.down('#dashboarduploaddocumentlistId');
 	        	 if (uploaddocumentlist.getSelectionModel().getCount() > 0) {
 	        		 var records = uploaddocumentlist.getSelectionModel().getSelection()[0];
 		        		if(!isNullOrEmpty(records.data.guidelinesDocumentId)){
 		        			var submitURL = SERVERURL.PATH_GUIDELINES_DOC_DELETE+'?id='+records.data.guidelinesDocumentId;
 		        		}
 	        		 showConfirmMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
 	        			 if (btn == 'yes'){
 	        				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 	        				 Ext.Ajax.request({
 	        					 method: "DELETE",
 	        					 type: 'rest',
 	        					 url : submitURL,
 	        					 headers: {
 	        						 'Content-Type': 'application/json'
 	        					 },
 	        					 success: function(form, action) {
 	        						 Ext.getBody().unmask();
 	        						 showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));	 
 	        						 uploaddocumentlist.store.reload();
 	        						 uploaddocumentlist.getSelectionModel().deselectAll(true);
 	        					 }
 	        				 });
 	        			 }
 	        		 });
 	        	 } else {
 	        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 	        	 }
 	         },
 	        saveDashboardDataRequirement:function(){
  			   var $this = this;
  			   var form = $this.getDashboarddatarequirementdatasetup();
  			   var guidelineField = form.down('#instructionsItemId');
  			   var instructionsOtherLang =  form.down('#instructionsInOtherLangItemId');
  			   var idField = form.down('#Id');
  			   var moduleId = form.down('#moduleTypeId').getValue();
  			   var dataRequirement = new Array();
  			   if (isNullOrEmpty(guidelineField.getValue())) {
  				  showWarningMessage(getPersonModuleTranslation('DOCUMENT'), getCommonTranslation('FILL_FORM_FIELD_DETAILS'));
  			   }else{
  				  dataRequirement.push({
  					   "id":idField.getValue(),
  	 				   "applicantPortalModules":$this.getIdValueJson(moduleId),
  	 				   "guideline":guidelineField.getValue(),
  	 				   "guidelineOtherLang":instructionsOtherLang.getValue(),
  	 				   "isVisible": true
  	 			   });

  	 			   var recordsToUpdate = Ext.encode(dataRequirement[0]);
  	 			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  	 			   Ext.Ajax.request({
  	 				   type: 'rest',
  	 				   method: 'post',
  	 				   url: SERVERURL.PATH_SAVE_HOSTEL_PERSON_REQUIREMENT,
  	 				   jsonData: recordsToUpdate,
  	 				   success : function(response, action) {
  	 					  var data = Ext.decode(response.responseText);
  	 					  idField.setValue(data.id);
  	 					  guidelineField.setValue(data.guideline);
  	 					  instructionsOtherLang.setValue(data.guidelineOtherLang);
  	 					  Ext.getBody().unmask();
  	 					  showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'), getCommonTranslation('SUCCESS'));

  	 				   }
  	 			   }); 
  			   }
  			   
  		   },
  		    // ********* Open Program Default Setup **************
  		    getOpenProgramDefaultSetupStructure :function(){
  		    	var $this = this;
  		    	
  		    		var contentpanel = $this.getContentpanel();
  		    		var coursetabstructure = Ext.widget('defaultprogramsetupview');
  		    		var tabName = getCommonTranslation('DEFAULT_PROGRAM_DETAILS_SETUP');

  		    		var getcontroller=$this.getController('menu.CoreERPNavigationController');
  		    		var getTab=getcontroller.getTab(tabName);
  		    		if(getTab!=null){
  		    			contentpanel.remove(getTab, true);
  		    		}
  		    		openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TWO);
  		    },
  		    /// Save methods
  		  admSaveDefaultProgramConfigureScreenData:function(){
  				 var $this = this;
  				 var grid = $this.getDefaultprogramsetupconfigurescreengrid();
  				 var languageId;
  				 var screenMode;
  				 var screenName;
  				 var configureArray = [];
  				 var selectedRecord = grid.getSelectionModel().getSelection().length;
  				 if(selectedRecord > 0){
  					 screenMode = 'Create, Edit, and View';
  					 languageId = 1;
  					 screenName = 'Default Program Details Set Up';
  					 var record = grid.getSelectionModel().getSelection();
  					 var isSequenceDefined = true;
   				     var sequenceNullFieldName = '';
  					 if(record.length > 0) {
  						 for(var i=0;i<record.length;i++){
  							 var rec=record[i];
  								var isVisibleField = rec.data.isVisible;
  								 var isVisible; 
  								 if(isVisibleField == null || isVisibleField == 'Yes'){
  									 isVisible = true;
  								 }else{
  									 isVisible =false;
  								 }
  								 if (rec.data.sequenceNo == null || rec.data.sequenceNo == undefined || rec.data.sequenceNo == '') {
  	    							isSequenceDefined = false;
  	    							sequenceNullFieldName = rec.data.fieldDisplayName;
  								 }
  								 var helpText;
  								 if(!isNullOrEmpty(rec.data.helpText)){
  									 helpText =rec.data.helpText;
  								 }else{
  									 helpText = null;
  								 }
  								 var defaultHelpText;
  								 if(!isNullOrEmpty(rec.data.defaultHelpText)){
  									 defaultHelpText =rec.data.defaultHelpText;
  								 }else{
  									 defaultHelpText = null;
  								 }
  								 configureArray.push({
  								 "formFieldId": rec.data.formFieldId,
  								 "formFieldDisplaySettingId": rec.data.formFieldDisplaySettingId,
  								 "screenName": screenName,
  								 "screenMode": screenMode,
  								 "defaultLabel": rec.data.defaultLabel,
  								 "newLabel": rec.data.newLabel,
  								 "isFieldLocked": rec.data.isFieldLocked,
  								 "isMandatory": rec.data.isMandatory,
  								 "isVisible": isVisible,
  								 "helpText": helpText,
  								 "defaultHelpText":defaultHelpText,
  								 "defaultValue": rec.data.defaultValue,
  								 "languageId": languageId,
  								 "academyLocationId": 1,
  								 "whetherForAllAcademyLocation": false,
  								 "sequenceNo":rec.data.sequenceNo
  							  });
  					     }
  					 }
  					 //if(configureArray.length > 0){
  					 if (isSequenceDefined) {
  						 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  	  					 Ext.Ajax.request({
  	  						 type : 'rest',
  	  						 url : SERVERURL.CONFIGURE_SCREEN_SAVE,
  	  						 jsonData : configureArray,
  	  						 method : 'POST',
  	  						 success : function(form, action) {
  	  							 Ext.getBody().unmask();
  	  							 showSuccessMessage(getCommonTranslation('DYNAMIC_FORM_RENDERING'),getCommonTranslation('SUCCESS'));
  	  							 grid.getStore().reload();
  	  							 grid.getSelectionModel().deselectAll();
  	  						 }
  	  					 });
  					 }else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_ENTER_SEQUENCE')+' For '+sequenceNullFieldName); 
					 }
  				/*}else{
  					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
  				}*/
  			   } 
  			  else{
  					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
  			   }
  			 }
});