/*
 * @author prathamesh.sheth
 * 
 * This class is used for to enable or disable toolbar buttons on main application program search grid according to application and admission status.
 *    
 */
Ext.define('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.AppProgMainGridToolBarButtonConfiguration', {

	
	/*
     * This function is used for to enable or disable buttons toolbar buttons on main application program search grid according to its configuration  
     * 
     */
	enableDisableToolBarButtons:function(applicationId,searchResultGrid,applicationStatus,programStatus,admissionStatus){
		var me=this;
		if(searchResultGrid){
			var editToolBarButton=searchResultGrid.down("button[itemId=searchResultGridBtnEdit]");
			var viewToolBarButton=searchResultGrid.down("button[itemId=searchResultGridBtnView]");
			var buttonEnableDisableObj=me.checkButtonEnableDisable(applicationStatus,programStatus,admissionStatus);
			viewToolBarButton.setDisabled(buttonEnableDisableObj.viewButtonHasDisabled); // In all cases view button is enabled 
			if(buttonEnableDisableObj.editButtonHasDisabled){
				editToolBarButton.setDisabled(true);
			}else{
				editToolBarButton.setDisabled(false);
			}
		}	
	},
	
	/*
     * This function is used for to check applicationStatus,programStatus,admissionStatus and get tool bar button settings  
     * By Default View and Edit Button is enabled 
     * 
     */
	checkButtonEnableDisable:function(applicationStatus,programStatus,admissionStatus){
						
		var buttonEnableDisableObj=new Object();
		
		switch (true) {
		 		
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="APPLIED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="ACTIVE") && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   
        	 
         /* Comment this according to client change          
          * case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="SOLD") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="ACTIVE") && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;  */ 	          	          
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="APPROVED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="REJECTED") && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   	          	          
        	 
        	
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="APPROVED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="WITHDRAWN") && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   	          	          
        	 
        	
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="APPROVED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="OFFER_LETTER_REJECTED") && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   	          	          
        	  
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="REJECTED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="REJECTED")  && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="WITHDRAWN") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="WITHDRAWN")  && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;        	          
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="ADMISSION_CONFIRMED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	         	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="ADMITTED_PROVISIONALLY")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="ADMITTED_ON_TRIAL_BASIS")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
        	 
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="REJECTED")  && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="WITHDRAWN")  && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") && 
        		 (!isNullOrEmpty(programStatus) && programStatus==="OFFER_LETTER_REJECTED")  && 
        		 isNullOrEmpty(admissionStatus)
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;   
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="REJECTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="ADMISSION_REJECTED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="WITHDRAW_AFTER_CONFIRMED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="WITHDRAWN") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="WITHDRAW_AFTER_CONFIRMED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	          	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="REJECTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="REJECTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="ADMISSION_REJECTED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
        	 
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="ADMISSION_REJECTED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="WITHDRAW_AFTER_ADMISSION")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="WITHDRAW_AFTER_TRIAL")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="WITHDRAW_AFTER_PROVISION")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
         case (
        		 (!isNullOrEmpty(applicationStatus) && applicationStatus==="ADMISSION_GRANTED") &&
        		 (!isNullOrEmpty(programStatus) && programStatus==="ADMITTED") && 
        		 (!isNullOrEmpty(admissionStatus) && admissionStatus==="PROVISIONAL_ADMISSION_REJECTED")
        	  ):      
        		  buttonEnableDisableObj.editButtonHasDisabled= true;
        		  buttonEnableDisableObj.viewButtonHasDisabled= false;        	         	 
        	 break;
        	 
        	 
         default:  
        	buttonEnableDisableObj.editButtonHasDisabled= false;
	 	 	buttonEnableDisableObj.viewButtonHasDisabled= false;  	 
         }
		
		return buttonEnableDisableObj;
	},

	    	    
});


