/*
 * @author prathamesh.sheth
 * 
 * This class is used for to enable or disable buttons according to application and admission status.
 *    
 */
Ext.define('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration', {

	extend: 'Ext.app.Controller',
	/*
     * This function is used for to enable or disable buttons on applicant profile according to its configuration  
     * 
     */
	enableDisableButtonPanel:function(applicantProfile,isApplicantCreated){
		var me=this;
		if(applicantProfile){
			var actionButtonPanel=applicantProfile.down('#actionButtonPanel');
			var applicantSummaryPanel=applicantProfile.down('#applicantSummaryPanel');
			
			if(actionButtonPanel && isApplicantCreated){				
				var buttonPanelSettingArray=me.checkApplicantProfileMode(applicantProfile);
				Ext.each(actionButtonPanel.items.items, function(button) {
					for(var buttonCount=0;buttonCount<buttonPanelSettingArray.length;buttonCount++){
						if(button.itemId===buttonPanelSettingArray[buttonCount].buttonItemId){
							button.setDisabled(buttonPanelSettingArray[buttonCount].buttonHasDisabled);
							break;
			           	}
					}		           	 
				}); 
			}
			if(applicantSummaryPanel && isApplicantCreated){
				applicantSummaryPanel.setVisible(true);				
			}else{
				applicantSummaryPanel.setVisible(false);
			}
		}		
	},
	
	
	/*
     * This function is used for to check mode(edit,view or new application) of applicant profile   
     * 
     */
	checkApplicantProfileMode:function(applicantProfile){		
			var me=this;
			var buttonPanelSettingArray=new Object();
			var applicationInfoObject=applicantProfile.getApplicationInfo();
			if(!isEmpty(applicationInfoObject) && (!isNullOrEmpty(applicationInfoObject.applicationStatus) || !isNullOrEmpty(applicationInfoObject.admissionStatus))){
				if(!isEmpty(applicationInfoObject) && applicationInfoObject.isEditMode==true){
					buttonPanelSettingArray=me.getButtonPanelSettingObjectToApplicationStatusType(applicationInfoObject);
				}else if(!isEmpty(applicationInfoObject) && applicationInfoObject.isViewMode==true){
					buttonPanelSettingArray=me.getButtonPanelSettingObjectToApplicationStatusType(applicationInfoObject);
				}else{
					buttonPanelSettingArray=me.getButtonPanelSettingObjectToApplicationStatusType(applicationInfoObject);
				}
			}								
			else{
				buttonPanelSettingArray=me.getButtonPanelSettingObjectToAdmissionType(applicationInfoObject);
			}
			return buttonPanelSettingArray;			
	},
	
	/*
     * This function is used for to check admission type and get button panel settings to that admission type 
     * 
     */
	getButtonPanelSettingObjectToAdmissionType:function(applicationInfoObject){
		var me=this;
		var buttonPanelSettingArray=new Array();
		if(applicationInfoObject.isDirectAdmission===true){
			buttonPanelSettingArray=me.getDirectAdmissionButtonConfiguration();    		
		}else if(applicationInfoObject.isMidTermAdmission===true){
			buttonPanelSettingArray=me.getMidTermAdmissionButtonConfiguration();
		}else if(applicationInfoObject.isNewApplication===true){
			buttonPanelSettingArray=me.getNewApplicationButtonConfiguration();
		}else if(applicationInfoObject.isFormSoldApplication===true){
			buttonPanelSettingArray=me.getFormSoldApplicationButtonConfiguration();
		}
		return buttonPanelSettingArray;
	},
	
	
	/*
     * This function is used for to check application status type and get button panel settings to that application status type  
     * 
     */
	getButtonPanelSettingObjectToApplicationStatusType:function(applicationInfoObject){
		var me=this;				
		var buttonPanelSettingArray=new Array();
		switch (applicationInfoObject.applicationStatus) {
		 		
         case "APPLIED":      
        	 buttonPanelSettingArray=me.getOnlyApplicationRelatedButtonConfiguration();        	 
             break;
             
         case "SOLD":
        	 buttonPanelSettingArray=me.getOnlyApplicationRelatedButtonConfiguration();
             break;
             
         case "SUBMITTED":
        	 buttonPanelSettingArray=me.getOnlyApplicationRelatedButtonConfiguration();
             break;

         case "APPROVED":             
        	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
             break;
             
         case "REJECTED":    //In this case all buttons in applicant profile are disabled         
        	 buttonPanelSettingArray=me.getAllDisabledButtonConfiguration();
             break;
             
         case "WITHDRAWED":  //In this case all buttons in applicant profile are disabled           
        	 buttonPanelSettingArray=me.getAllDisabledButtonConfiguration();
             break;
             
         case "CLOSED":     //In this case all buttons in applicant profile are disabled        
        	 buttonPanelSettingArray=me.getAllDisabledButtonConfiguration();
             break;
             
         case "DIRECT_ADMISSION":             
        	 buttonPanelSettingArray=me.getDirectAdmissionButtonConfiguration();    	
             break;
             
         case "MID_TERM_ADMISSION":           
        	 buttonPanelSettingArray=me.getMidTermAdmissionButtonConfiguration();
             break;
             
         case "DIRECT_SUBMISSION_TOKEN_GENERATED": //In this case same button configuration follow in "Applied" application status
        	 buttonPanelSettingArray=me.getOnlyApplicationRelatedButtonConfiguration();
             break;
             
         case "FORM_SALE_TOKEN_GENERATED": //In this case same button configuration follow in "Applied" application status 
        	 buttonPanelSettingArray=me.getOnlyApplicationRelatedButtonConfiguration();
             break;
             
         case "NOT_SUBMITTED":  //In this case all buttons in applicant profile are disabled           
        	 buttonPanelSettingArray=me.getAllDisabledButtonConfiguration();
             break;
             
         case "ADMISSION_GRANTED":        	
        	 
        	 switch (applicationInfoObject.admissionStatus) {
		 		
             case "ADMISSION_IN_PROGRESS":
             	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "ADMISSION_CONFIRMED":
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "ADMITTED_PROVISIONALLY":        
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
             
             case "ADMITTED_ON_TRIAL_BASIS":  
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "WITHDRAW_AFTER_CONFIRMED":    
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "ADMISSION_REJECTED":            	 
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "WITHDRAW_AFTER_ADMISSION":
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "WITHDRAW_AFTER_TRIAL":          
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "WITHDRAW_AFTER_PROVISION":
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             case "PROVISIONAL_ADMISSION_REJECTED":    
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();
                 break;
                 
             default:              	 
            	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();         	 
             }
        	 break;
        	 
         default:  
        	 buttonPanelSettingArray=me.getAllEnabledButtonConfiguration();         	 
         }		 
		return buttonPanelSettingArray;
	},
	
	
	getAllDisabledButtonConfiguration: function() {
		
		var buttonConfigurationArray = new Array({	                
            buttonItemId: 'approveApplicationBtn',
            buttonHasDisabled: true	                
        }, {
        	buttonItemId: 'rejectApplicationBtn',
            buttonHasDisabled: true
        }, {
        	buttonItemId: 'withdrawApplicationBtn',
            buttonHasDisabled: true
        }, {
        	buttonItemId: 'withdrawAdmissionBtn',
            buttonHasDisabled: true
        },{
        	buttonItemId: 'rejectAdmissionBtn',
            buttonHasDisabled: true
        },{
        	buttonItemId: 'approveAdmissionBtn',
            buttonHasDisabled: true
        }/*,{
        	buttonItemId: 'printBtn',
            buttonHasDisabled: true
        }*/);
    
		return buttonConfigurationArray ;
    
    },
	
    getAllEnabledButtonConfiguration: function() {
		
		var buttonConfigurationArray = new Array({	                
            buttonItemId: 'approveApplicationBtn',
            buttonHasDisabled: false	                
        }, {
        	buttonItemId: 'rejectApplicationBtn',
            buttonHasDisabled: false
        }, {
        	buttonItemId: 'withdrawApplicationBtn',
            buttonHasDisabled: false
        }, {
        	buttonItemId: 'withdrawAdmissionBtn',
            buttonHasDisabled: false
        },{
        	buttonItemId: 'rejectAdmissionBtn',
            buttonHasDisabled: false
        },{
        	buttonItemId: 'approveAdmissionBtn',
            buttonHasDisabled: false
        }/*,{
        	buttonItemId: 'printBtn',
            buttonHasDisabled: false
        }*/);
    
		return buttonConfigurationArray ;
    
    },
	
    // In This Function only 'Approve Application','Reject Application' and 'Withdraw Application' Buttons are enabled 
    getOnlyApplicationRelatedButtonConfiguration: function() {
		
		var buttonConfigurationArray = new Array({	                
            buttonItemId: 'approveApplicationBtn',
            buttonHasDisabled: false	                
        }, {
        	buttonItemId: 'rejectApplicationBtn',
            buttonHasDisabled: false
        }, {
        	buttonItemId: 'withdrawApplicationBtn',
            buttonHasDisabled: false
        }, {
        	buttonItemId: 'withdrawAdmissionBtn',
            buttonHasDisabled: true
        },{
        	buttonItemId: 'rejectAdmissionBtn',
            buttonHasDisabled: true
        },{
        	buttonItemId: 'approveAdmissionBtn',
            buttonHasDisabled: true
        }/*,{
        	buttonItemId: 'printBtn',
            buttonHasDisabled: true
        }*/);
    
		return buttonConfigurationArray ;
    
    },
	
    //In This Function only 'Approve Admission','Reject Admission' and 'Withdraw Admission' Buttons are enabled 
    getOnlyAdmissionRelatedButtonConfiguration: function() {
		
		var buttonConfigurationArray = new Array({	                
            buttonItemId: 'approveApplicationBtn',
            buttonHasDisabled: true	                
        }, {
        	buttonItemId: 'rejectApplicationBtn',
            buttonHasDisabled: true
        }, {
        	buttonItemId: 'withdrawApplicationBtn',
            buttonHasDisabled: true
        }, {
        	buttonItemId: 'withdrawAdmissionBtn',
            buttonHasDisabled: false
        },{
        	buttonItemId: 'rejectAdmissionBtn',
            buttonHasDisabled: false
        },{
        	buttonItemId: 'approveAdmissionBtn',
            buttonHasDisabled: false
        }/*,{
        	buttonItemId: 'printBtn',
            buttonHasDisabled: true
        }*/);
    
		return buttonConfigurationArray ;
    
    },
	
    getDirectAdmissionButtonConfiguration: function() {
    	
        var buttonConfigurationArray = new Array({	                
                buttonItemId: 'approveApplicationBtn',
                buttonHasDisabled: true	                
            }, {
            	buttonItemId: 'rejectApplicationBtn',
                buttonHasDisabled: true
            }, {
            	buttonItemId: 'withdrawApplicationBtn',
                buttonHasDisabled: true
            }, {
            	buttonItemId: 'withdrawAdmissionBtn',
                buttonHasDisabled: false
            },{
            	buttonItemId: 'rejectAdmissionBtn',
                buttonHasDisabled: false
            },{
            	buttonItemId: 'approveAdmissionBtn',
                buttonHasDisabled: false
            }/*,{
            	buttonItemId: 'printBtn',
                buttonHasDisabled: true
            }*/);
        
        return buttonConfigurationArray ;
    },

	 getMidTermAdmissionButtonConfiguration: function() {
		
	    var buttonConfigurationArray = new Array({	                
	            buttonItemId: 'approveApplicationBtn',
	            buttonHasDisabled: true	                
	        }, {
	        	buttonItemId: 'rejectApplicationBtn',
	            buttonHasDisabled: true
	        }, {
	        	buttonItemId: 'withdrawApplicationBtn',
	            buttonHasDisabled: true
	        }, {
	        	buttonItemId: 'withdrawAdmissionBtn',
	            buttonHasDisabled: false
	        },{
	        	buttonItemId: 'rejectAdmissionBtn',
	            buttonHasDisabled: false
	        },{
	        	buttonItemId: 'approveAdmissionBtn',
	            buttonHasDisabled: false
	        }/*,{
	        	buttonItemId: 'printBtn',
	            buttonHasDisabled: true
	        }*/);
	    
	    return buttonConfigurationArray ;
	},
	
	getNewApplicationButtonConfiguration: function() {
		
	    var buttonConfigurationArray = new Array({	                
	            buttonItemId: 'approveApplicationBtn',
	            buttonHasDisabled: false	                
	        }, {
	        	buttonItemId: 'rejectApplicationBtn',
	            buttonHasDisabled: false
	        }, {
	        	buttonItemId: 'withdrawApplicationBtn',
	            buttonHasDisabled: false
	        }, {
	        	buttonItemId: 'withdrawAdmissionBtn',
	            buttonHasDisabled: true
	        },{
	        	buttonItemId: 'rejectAdmissionBtn',
	            buttonHasDisabled: true
	        },{
	        	buttonItemId: 'approveAdmissionBtn',
	            buttonHasDisabled: true
	        }/*,{
	        	buttonItemId: 'printBtn',
	            buttonHasDisabled: true
	        }*/);
	    
	    return buttonConfigurationArray ;
	},
	
	getFormSoldApplicationButtonConfiguration:function() {
		
	    var buttonConfigurationArray = new Array({	                
	            buttonItemId: 'approveApplicationBtn',
	            buttonHasDisabled: false	                
	        }, {
	        	buttonItemId: 'rejectApplicationBtn',
	            buttonHasDisabled: false
	        }, {
	        	buttonItemId: 'withdrawApplicationBtn',
	            buttonHasDisabled: false
	        }, {
	        	buttonItemId: 'withdrawAdmissionBtn',
	            buttonHasDisabled: true
	        },{
	        	buttonItemId: 'rejectAdmissionBtn',
	            buttonHasDisabled: true
	        },{
	        	buttonItemId: 'approveAdmissionBtn',
	            buttonHasDisabled: true
	        }/*,{
	        	buttonItemId: 'printBtn',
	            buttonHasDisabled: true
	        }*/);
	    
	    return buttonConfigurationArray ;
	}
	        
	    	    
});


