/**
 * @author sachin.bangar
 * This controller is used for applicant past history details
 */
Ext.define('Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController', {
    extend: 'Academia.controller.personinfo.common.PersonPastHistoryController',

    alias: "widget.applicantpasthistorycontroller",

    mixins: {
		ApplicationBaseController:'Academia.controller.admission.applications.applicationBase.ApplicationBaseController'
    },
    stores: ['messaging.SendMessageReportContactStore',
             'criteriabuilder.userquicksearch.QuickSearchPrintNameStore',
             'messaging.SendMessageReportRecipientStore',
             'messaging.SendMessageReportEventNameStore',
             'messaging.CommunicationHistoryReportList',
             'messaging.MessageTemplate',
             'Academia.store.messaging.MessageCategoryStore',
             'messaging.MessageSubCategoryStore',
             'Academia.store.messaging.MessageSearchConfigs',
             'messaging.CommunicationHistoryEmailStore','campaignnew.CampaignSchoolStore',
             'messaging.CommunicationHistoryMobileStore','personinfo.common.pasthistory.ApplicantEducationMonthStore',
             'personinfo.common.pasthistory.ApplicantEducationYearStore','common.EducationHistorySubjectStore','common.EducationHistoryGradeStore',
             'common.CSMIndustryStore','personinfo.common.pasthistory.ApplicantPassTypeStore'],
   
    views: ['messaging.report.CommunicationHistoryStructure',
			'messaging.report.CommunicationHistoryList',
			 'personinfo.common.pasthistory.VaccinationGridForApplicantFaculty',],

    refs: [{
        ref: 'onlinepaymentapplicantstructure',
        selector: 'onlinepaymentapplicantstructure'
    },{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personEducationForm',
        selector: 'educationform[itemId=applicantEducationForm]'
    }, {
        ref: 'personWorkExperienceForm',
        selector: 'workexperienceform[itemId=applicantWorkExperienceForm]'
    }, {
        ref: 'personMedicalHistoryForm',
        selector: 'medicalhistoryform[itemId=applicantMedicalHistoryForm]'
    },{
        ref: 'personVaccinationForm',
        selector: 'vaccinationform[itemId=applicantVaccinationForm]'
    },{
        ref: 'personExtraCurricularForm',
        selector: 'extracurricularform[itemId=applicantExtraCurricularForm]'
    },{
        ref: 'personCompetitiveExamForm',
        selector: 'competitiveexamform[itemId=applicantCompetitiveExamForm]'
    }/*,{
    	ref:'onlinePaymentGrid',
    	selector: 'onlinepaymentgrid[itemId=onlinePaymentGrid]'
    }*/,{
    	ref:'receiptgridforapplicant',
    	selector: 'receiptgridforapplicant[itemId=receiptgridforapplicant]'
    },{
    	ref:'onlinepaymentbilllevelapplicant',
    	selector: 'onlinepaymentbilllevelapplicant[itemId=onlinepaymentbilllevelapplicantid]'
    },{
    	ref:'onlinepaymentgrid',
    	selector: 'onlinepaymentgrid[itemId=onlinepaymentgridid]'
    }, {
        ref: 'personMedicalDetailsForm',
        selector: 'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId]'
    },{
        ref: 'paymentsummarywin',
        selector: 'paymentsummarywin [itemId=applicant]'
    }, {
        ref: 'personChurchInformationForm',
        selector: 'churchinformationform[itemId=applicantChurchInfoForm]'
    },{
    	ref:'churchemploymenthistorywindow',
    	selector:'churchemploymenthistorywindow'
    },{
        ref: 'personApplicantDetailsForm',
        selector: 'applicantdetailsform[itemId=applicantDetailsFormItemId]'
    },{
        ref: 'personApplicantDeclarationAndPaymentForm',
        selector: 'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId]'
    },{
		ref : 'simpledocumentform',
		selector : 'simpledocumentform'

	},{
		ref : 'applicantvaccinationinfodocumentgrid',
		selector : 'applicantvaccinationinfodocumentgrid'

	},{
		ref : 'applicantvaccinationinfodocumentlist',
		selector : 'applicantvaccinationinfodocumentlist'

	},{
		ref : 'applicantvaccinationinfodocumentlistgrid',
		selector : 'applicantvaccinationinfodocumentlistgrid'

	},{
		ref : 'vaccinationgridforapplicantfaculty',
		selector : 'vaccinationgridforapplicantfaculty[itemId=applicantVaccinationGrid]'
	},{
		ref : 'communicationhistorystructure',
		selector : 'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId]'
	}, {
    	ref : 'communicationhistorylist',
    	selector : 'communicationhistorylist'
    },{
		ref : 'applicantprofile',
		selector : 'applicantprofile'
    },{
    	ref: 'nonacademicachievementsform',
    	selector: 'nonacademicachievementsform[itemId=applicantnonacademicachievementsform]'
    }, {
    	ref: 'personSocioEconomicInfoForm',
    	selector: 'socioeconomicinformationform[itemId=admApplicantSocioEconomicFormItemId]'
    },{
    	ref : 'sendmessageattacheddocumentwin',
    	selector : 'sendmessageattacheddocumentwin[itemId=applicantsendmessageattacheddocumentwin]'
    }, {
    	ref: 'postSchoolStudiesForm',
    	selector: 'postschoolstudiesform[itemId=applicantPostSchoolStudiesform]'
    }, {
    	ref: 'applicanthealthinformationgrid',
    	selector: 'applicanthealthinformationgrid[itemId=applicantHealthInformationGridItemId]'
    },{
		 ref: 'applicanteducationdetailsgrid',
		 selector: 'applicanteducationdetailsgrid[itemId=applicantEducationDetailsGridItemId]'
	},{
		 ref: 'applicantlanguageinformationgrid',
		 selector: 'applicantlanguageinformationgrid[itemId=applicantLanguagesInformationGridItemId]'
	},{
		 ref: 'educationhistorydetailform',
		 selector: 'educationhistorydetailform[itemId=applicanteducationhistorydetailform]'
	 },{
		 ref: 'applicanteducationhistorydocumentgrid',
		 selector: 'applicanteducationhistorydocumentgrid'
	 },{
		 ref: 'applicanteducationhistoryurlgrid',
		 selector: 'applicanteducationhistoryurlgrid'
	 },{
		 ref: 'applicanteducationhistorydocumentlist',
		 selector: 'applicanteducationhistorydocumentlist'
	 }, {
		 ref: 'applicanteducationhistorydocumentlistgrid',
		 selector: 'applicanteducationhistorydocumentlistgrid'
	 }, {
		 ref: 'applicanteducationhistorydocurllist',
		 selector: 'applicanteducationhistorydocurllist'
	 }, {
		 ref: 'applicanteducationhistorydocurllistgrid',
		 selector: 'applicanteducationhistorydocurllistgrid'
	 },{
        ref: 'documentformwindow',
        selector: 'documentformwindow'
    },{
		ref : 'applicantlanguagedocumentlist',
		selector : 'applicantlanguagedocumentlist'
    },{
		ref : 'applicantlanguagedocumentlistgrid',
		selector : 'applicantlanguagedocumentlistgrid'
    },{
		ref : 'applicantlanguagedocurllist',
		selector : 'applicantlanguagedocurllist'
    },{
		ref : 'applicantlanguagedocurllistgrid',
		selector : 'applicantlanguagedocurllistgrid'
    },{
        ref: 'studentlanguagedetailform',
        selector: 'studentlanguagedetailform[itemId=applicantlanguageformId]'
    },
	 {
		 ref: 'applicantlanguagedocdetailgrid',
		 selector: 'applicantlanguagedocdetailgrid'
	 },
	 {
		 ref: 'applicantlangurlgrid',
		 selector: 'applicantlangurlgrid'
	 },{
	     ref: 'studenthealthinformationform',
	     selector: 'studenthealthinformationform[itemId=applicantHealthInformationFormItemId]'
   },{
       ref: 'documentformwindow',
       selector: 'documentformwindow'
   },{
		 ref: 'applicanthealthinformationdocumentgrid',
		 selector: 'applicanthealthinformationdocumentgrid'
	},{
		 ref: 'applicanthealthinformationurlgrid',
		 selector: 'applicanthealthinformationurlgrid'
	},{
             ref: 'applicanthealthinformationdocumentlist',
             selector: 'applicanthealthinformationdocumentlist'
         }, {
             ref: 'applicanthealthinformationdocumentlistgrid',
             selector: 'applicanthealthinformationdocumentlistgrid'
         }, {
             ref: 'applicanthealthinformationdocurllist',
             selector: 'applicanthealthinformationdocurllist'
         }, {
             ref: 'applicanthealthinformationdocurllistgrid',
             selector: 'applicanthealthinformationdocurllistgrid'
         }],
    config: {
    	APPLICANT_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_EDUCATION_PRIVILEGES'),
    	APPLICANT_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_WORK_EXPERIENCE_PRIVILEGES'),
    	APPLICANT_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_MEDICAL_PRIVILEGES'),
    	APPLICANT_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_VACCINATION_PRIVILEGES'),
    	APPLICANT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	APPLICANT_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_COMPETITIVE_EXAM_PRIVILEGES'),
    	APPLICANT_ONLINE_PAYMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_ONLINE_PAYMENT_PRIVILEGES'),
    	APPLICANT_MEDICAL_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_MEDICAL_DETAIL_PRIVILEGES'),
    	APPLICATION_RECEIPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_RECEIPT_PRIVILEGES'),
    	APPLICANT_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_CHURCH_INFORMATION_PRIVILEGES'),
    	APPLICANT_DETAIL_FORM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_DETAIL_FORM_PRIVILEGES'),
    	APPLICANT_COMMUNICATION_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_COMMUNICATION_HISTORY_PRIVILEGES'),
    	PAYMENT_MODE_APPLICANT_PROFILE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PAYMENT_MODE_APPLICANT_PROFILE_PRIVILEGES'),
    	APPLICANT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES'),
    	APPLICANT_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES'),
    	APPLICANT_POST_SCHOOL_STUDIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_POST_SCHOOL_STUDIES_PRIVILEGES'),
    	APPLICANT_EDUCATION_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_EDUCATION_HISTORY_PRIVILEGES'),
        APPLICANT_LANGUAGE_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_LANGUAGE_INFORMATION_PRIVILEGES'),
        APPLICANT_HEALTH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_HEALTH_INFORMATION_PRIVILEGES'),
        APPLICANT_EDUCATION_HISTORY_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_EDUCATION_HISTORY_DOCUMENT_PRIVILEGES'),
	    APPLICANT_EDUCATION_HISTORY_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_EDUCATION_HISTORY_URL_PRIVILEGES'),
	    APPLICANT_HEALTH_INFORMATON_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_HEALTH_INFORMATON_DOCUMENT_PRIVILEGES'),
	    APPLICANT_HEALTH_INFORMATON_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_HEALTH_INFORMATON_URL_PRIVILEGES'),
	    APPLICANT_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_LANGUAGE_INFORMATION_DOCUMENT_PRIVILEGES'),
	    APPLICANT_LANGUAGE_INFORMATION_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_LANGUAGE_INFORMATION_URL_PRIVILEGES'),
        
    
    },

    init: function(application) {
    	this.isAdd=true;
        this.control({
        	'studenthealthinformationform[itemId=applicantHealthInformationFormItemId]':{
        	                afterrender: function(form) {   
        	                    if(this.isAdd){
        	                        form.up().setTitle(getCommonTranslation('ADD_HEALTH_INFORMATION'));
        	                    }else{
        	                        form.up().setTitle(getCommonTranslation('EDIT_HEALTH_INFORMATION'));
        	                    }
        	    					var medicalConditions = form.down('#medicalConditionsItemId');
        	    					var medicationItemId = form.down('#medicationItemId');
        	    					var allergiesItemId = form.down('#allergiesItemId');
        	    					var learningDifficultiesItemId = form.down('#learningDifficultiesItemId');
        	    					
        	    					if(medicalConditions.isHidden()){
        	    						form.down('#medicalConditionName').setVisible(false);
        	    					}
        	    					if(medicationItemId.isHidden()){
        	    						form.down('#medicationName').setVisible(false);
        	    					}
        	    					if(allergiesItemId.isHidden()){
        	    						form.down('#allergiesName').setVisible(false);
        	    					}
        	    					if(learningDifficultiesItemId.isHidden()){
        	    						form.down('#learningDifficultiesName').setVisible(false);
        	    					}
        	    					
        	                }
        	            },
        	
        	/**
        	 * Vaccination Document Details
        	 */
        	        	 
            'applicantvaccinationinfodocumentgrid': {
                render: function(grid) {},
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	   				 if(columnName == "documentName"){
	   					 if(e.target.tagName=='A'){
	   						 this.getDownloadFile(record.get('documentId'));
	   					 }
	   				 }
	   			}
            },
        	
            
            'applicanthealthinformationgrid[itemId=applicantHealthInformationGridItemId] button[itemId=btnAdd]': {
            	click: function() {
            		var $this = this;
            		this.isAdd=true;
            		var formWindow = this.showPersonCommonWindow('HEALTH_INFORMATION', 'applicantHealthInformationFormItemId');
            		if( formWindow != null ){
	        			  var form = formWindow.down('studenthealthinformationform');
	        		}
            	}
            },
            
            'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] button#submitButtonId' : {
	 			click : function() {
	               this.saveApplicantHealthInformationDetail('#applicantHealthInformationGridItemId', SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_DETAIL_ADD, SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_DETAIL_UPDATE);
	 			}
	 		},
	 		
	 		'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] button[itemId=cancelButtonId]' : {
	 			 click: this.closePersonCommonWindow
 			},
 			
 			'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] button#healthDocument' : {
	 			click : function() {
	 				this.getDocumentController().showDocumentFormWindow('applicant_health_information_Details_hidden_field','DOCUMENT');
	 				setTimeout(function(){
			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
                    		},100);     
	 			}
	 		},
	 		
	 		'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] button#healthDocumentUrl' : {
	 			click : function() {
	 				this.getDocumentController().showDocumentFormWindow('applicant_health_information_Details_hidden_field','DOCUMENT_URL');
 					var formWindow = this.getDocumentformwindow();
 					if (!formWindow) {
 						Ext.widget('documentformwindow');
 						formWindow = this.getDocumentformwindow();
 					}
 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
	 			}
	},
	
	'documentformwindow[itemId=applicant_health_information_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
 		click : function() {
 			this.getDocumentController() 
 			.closeDocumentFormWindow();
 		}
 	},
	
		'documentformwindow[itemId=applicant_health_information_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
 	    	click : function() {
 			var $this = this;
 			var isTransient = true;
 			var module = 'applicantHealthInformation';
 			var entityId;
 			var entityType = 'applicantHealthInformationDocument';

 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
 					function(success,response,isCallBackTransient) {
 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentHealthInformation','serialNo']
 						var documentModel = new Academia.model.personinfo.common.pasthistory.ApplicantHealthInformationDocumentModel();
 						documentModel.set("documentName",response.name);
 						documentModel.set("path",response.path);
 						documentModel.set("type",response.type);
 						documentModel.set("documentName",response.name);
 						documentModel.set("createdBy",$this.getIdValueJson(
 										response.createdBy.id,response.createdBy.value));
 						if(documentModel.data.path.length > 255){
 							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
 						}else{
 							var ApplicantHealthInformationDocGrid = $this.getApplicanthealthinformationdocumentgrid();
	 						var store = ApplicantHealthInformationDocGrid.getStore();
	 						store.add(documentModel);
	 						if (ApplicantHealthInformationDocGrid.isHidden() && store.data.items.length > 0) {
	 							ApplicantHealthInformationDocGrid.setVisible(true);
	 						}
	 						$this.getDocumentController().closeDocumentFormWindow();
	 						   showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'),getCommonTranslation('HEALTH_INFORMATION_DOCUMENT_ADD_SUCCESSFULLY'));
 						}
 					}, isTransient);
 		}
 	},

	 	
	 	 'documentformwindow[itemId=applicant_health_information_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	            var form = Ext.ComponentQuery.query('simpleurlform')[0];
		            form.down('#documentFormSubmitButtonId').setDisabled(true);
		            var formPassport= Ext.ComponentQuery.query('studenthealthinformationform')[0];
//		            var fileModifiedDate = formPassport.down("#fileModifiedDate");

	 				fields : ['id','documentId','documentName','path']
	 						var documentModelUrl = new Academia.model.personinfo.common.pasthistory.ApplicantHealthInformationUrlModel();
	 			            var documentName=form.down('#documentNameField').getValue();
	 			            var UrlName=form.down('#documentUrlField').getValue();

	 			           documentModelUrl.set("documentName",documentName);
	 			           documentModelUrl.set("path",UrlName);
	 						var applicanthealthinformationurlgrid = $this.getApplicanthealthinformationurlgrid();
	 						var store2= applicanthealthinformationurlgrid.getStore();
	 						store2.add(documentModelUrl);
	 						if (applicanthealthinformationurlgrid.isHidden() && store2.data.items.length > 0) {
	 							applicanthealthinformationurlgrid.setVisible(true);
		            				}
//	 						if($this.healthMode=='ADD'){
// 								 fileModifiedDate.setValue(dateRender(new Date()));
//	 						}else{
// 							    fileModifiedDate.setValue(dateRender(new Date()));
//	 						}
	 						$this.getDocumentController().closeDocumentFormWindow();
	 						   showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'),getCommonTranslation('HEALTH_INFORMATION_URL_ADD_SUCCESSFULLY'));
	 					
	 		}
	 	},
	 	'documentformwindow[itemId=applicant_health_information_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
	 		click : function() {
	 			this.getDocumentController()
	 			.closeDocumentFormWindow();
	 		}
	 	},
	 	
	 	'applicanthealthinformationgrid[itemId=applicantHealthInformationGridItemId] button[itemId=btnDelete]': {
                      click: function() {
                       this.deleteApplicantHealthInformationDetail('#applicantHealthInformationGridItemId', SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_DELETE);
                    }
                 },
	 		
 		'applicanthealthinformationdocumentgrid button#btnDelete' : {
			 click : function() {
				 var $this = this;
				 var grid=$this.getApplicanthealthinformationdocumentgrid();
				var form = Ext.ComponentQuery.query('studenthealthinformationform')[0];
				 if (grid.getSelectionModel().getCount() > 0) {
					 Ext.MessageBox
					 .confirm(
							getCommonTranslation('HEALTH_INFORMATION_DOCUMENT'),
							 getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'),
							function(btn, text) {
								 if (btn == 'yes') {
									 var store = grid.getStore();
									 var record = grid.getSelectionModel().getSelection()[0];
									 var id = record.id;
									 if (isNullOrEmpty(id)) {
									 }else{
										 if (record) {
											 store.remove(record);
											 showSuccessMessage(
													getCommonTranslation('HEALTH_INFORMATION_DOCUMENT'),
													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
											 if(store.data.items.length == 0) {
													grid.setVisible(false);
												}
										 }
									 }
								 }
							 });
				 } else {
					 showWarningMessage(
							getCommonTranslation('HEALTH_INFORMATION_DOCUMENT'),
							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
					
				 }
			 }
		 },
 		 
 		 
 		'applicanthealthinformationurlgrid button#btnDelete' : {
 			 click : function() {
 				 var $this = this;
 				 var grid=$this.getApplicanthealthinformationurlgrid();
 				var form = Ext.ComponentQuery.query('studenthealthinformationform')[0];
 				 if (grid.getSelectionModel().getCount() > 0) {
 					 Ext.MessageBox
 					 .confirm(
 							getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),
 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
 							function(btn, text) {
 								 if (btn == 'yes') {
 									 var store = grid.getStore();
 									 var record = grid.getSelectionModel().getSelection()[0];
 									 var id = record.id;
 									 if (isNullOrEmpty(id)) {
 									 }else{
 										 if (record) {
 											 store.remove(record);
 											 showSuccessMessage(
 													getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),
 													 getCommonTranslation('URL_SUCCESS_MSG'));
 											 if(store.data.items.length == 0) {
	 												grid.setVisible(false);
	 					 						}
 										 }
 									 }
 								 }
 							 });
 				 } else {
 					 showWarningMessage(
 							getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),
 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
 				 }
 			 }
 		 },
 		 
 		'applicanthealthinformationgrid' : {
			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				 var $this = this;
				 var documentGrid = $this.getApplicanthealthinformationgrid();
				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
				 if (columnName == "documentName") {
					 if (e.target.tagName == 'A') {
						 var documentId = record
						 .get("ecrptydocumentId");
						 if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					 }

				 }
			 }
		 },
	 		
	 		
	 	   'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] multiselectcombofield#medicalConditionsItemId' : {
	 			                change : function(obj, record) {
	 			                    var $this = this;
	 								var form = $this.getStudenthealthinformationform();
	 			                    var displayVal = obj.getDisplayValue();
	 								var otherField = obj.up().down('#medicalConditionName');
	 								if(!obj.isHidden()){
	 									if(displayVal.indexOf("Other") >= 0){
		 									otherField.setVisible(true);
		 									otherField.setDisabled(false);
		 									otherField.allowBlank = false;
		 									form.getForm().checkValidity();
	        								form.getForm().isValid();
		 				            	}
		 				            	else{
		 				            		otherField.setDisabled(true);
		 				            		otherField.setVisible(false);
		 				            		otherField.allowBlank = true;
		 				            		otherField.setValue('');
		 				            		form.getForm().checkValidity();
	        								form.getForm().isValid();
		 				            	}
	 								}
	 			                }
	 			            },
	 			
	 		      'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] multiselectcombofield#medicationItemId' : {
		            	                change : function(obj, record) {
		            		                    var $this = this;
		            	                     	var form = $this.getStudenthealthinformationform();
		            		                    var displayVal = obj.getDisplayValue();
		            							var otherField = obj.up().down('#medicationName');
		            							if(!obj.isHidden()){
		            		                    if(displayVal.indexOf("Other") >= 0){
		            								otherField.setDisabled(false);
		            								otherField.setVisible(true);
		            								otherField.allowBlank = false;
		            								form.getForm().checkValidity();
		            								form.getForm().isValid();
		            			            	}
		            			            	else{
		            			            		otherField.setDisabled(true);
		            			            		otherField.setVisible(false);
		            			            		otherField.allowBlank = true;
		            			            		otherField.setValue('');
		            			            		form.getForm().checkValidity();
		            								form.getForm().isValid();
		            			            	}
		            							}
		            		                }
	            },
		         'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] multiselectcombofield#allergiesItemId' : {
			            	                change : function(obj, record) {
			            		                    var $this = this;
			            							var form = $this.getStudenthealthinformationform();
			            		                    var displayVal = obj.getDisplayValue();
			            							var otherField = obj.up().down('#allergiesName');
			            							if(!obj.isHidden()){
			            		                    if(displayVal.indexOf("Other") >= 0){
			            								otherField.setDisabled(false);
			            								otherField.setVisible(true);
			            								otherField.allowBlank = false;
			            								form.getForm().checkValidity();
			            								form.getForm().isValid();
			            			            	}
			            			            	else{
			            			            		otherField.setDisabled(true);
			            			            		otherField.setVisible(false);
			            			            		otherField.allowBlank = true;
			            			            		otherField.setValue('');
			            			            		form.getForm().checkValidity();
			            								form.getForm().isValid();
			            			            	}
			            							}
			            		                }
		         },
			      'studenthealthinformationform[itemId=applicantHealthInformationFormItemId] multiselectcombofield#learningDifficultiesItemId' : {
				            	                change : function(obj, record) {
				            		                    var $this = this;
				            	 	   					var form = $this.getStudenthealthinformationform();
				            		                    var displayVal = obj.getDisplayValue();
				            							var otherField = obj.up().down('#learningDifficultiesName');
				            							if(!obj.isHidden()){
				            		                    if(displayVal.indexOf("Other") >= 0){
				            								otherField.setDisabled(false);
				            								otherField.setVisible(true);
				            								otherField.allowBlank = false;
				            								form.getForm().checkValidity();
				            								form.getForm().isValid();
				            			            	}
				            			            	else{
				            			            		otherField.setDisabled(true);
				            			            		otherField.setVisible(false);
				            			            		otherField.allowBlank = true;
				            			            		otherField.setValue('');
				            			            		form.getForm().checkValidity();
				            								form.getForm().isValid();
				            			            	}
				            							}
				            		                }
			      },
			      
			      
//			      
////               Health Information Grid Details
//		             
//		            'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId]': {
//		            	render: function(grid) {
//		            		var $this = this;
//		            		$this.loadGridStore('#studentHealthInformationGridItemId', SERVERURL.PATH_STUDENT_HEALTH_INFORMATION_GRID_DATA);
//		            		var portalId = this.getCurrentLoggedPortalId();
//		            		if (portalId == 7) {
//		            			$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
//		            			var structure = grid.up('personinfostudentportal');
//		            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
//		            		}else if (portalId == 2){
//		            			$this.doAccessControlValidation(grid,$this.getFACULTY_PORTAL_HEALTH_INFORMATION_PERMISSION());
//		            			var studentProfilePanel = grid.up('studentprofile');
//		            			var structure = studentProfilePanel.down('[region=center]');
//		            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
//		            		}else if (portalId == 3){
//		            			$this.doAccessControlValidation(grid,$this.getSTUDENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
//		    					var structure = grid.up('personinfostudentportal');
//		                        $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
//		            		}else{
//		            			$this.doAccessControlValidation(grid,$this.getSTUDENT_HEALTH_INFORMATION_PERMISSIONS());
//		            			var studentProfilePanel = grid.up('studentprofile');
//		            			var structure = studentProfilePanel.down('[region=center]');
//		            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
//		            		}
//		            	},
//		            	afterrender:function(grid){
//		    				var me = this;
//		    				var portalId = this.getCurrentLoggedPortalId();
//		            		if (portalId == 7) {
//		            			me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
//		            		}else if (portalId == 2){
//		            			me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_HEALTH_INFORMATION_PERMISSION());
//		            		}else if (portalId == 3){
//		            			me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
//		            		}else{
//		            			me.addDataGridConfigButton(grid,me.getSTUDENT_HEALTH_INFORMATION_PERMISSIONS());
//		            		}
//		    			},
//		    			selectionchange: function(column, selected,eOpts ){
//		                    var grid = column.view.up('grid');
//		                    if(selected.length > '1'){
//		                            grid.down('#btnAdd').setDisabled(true);
//		                            grid.down('#btnEdit').setDisabled(true);
//		                            grid.down('#btnView').setDisabled(true);
//		                            grid.down('#btnDelete').setDisabled(false);
//		                        }else{
//		                            grid.down('#btnAdd').setDisabled(false);
//		                            grid.down('#btnEdit').setDisabled(false);
//		                            grid.down('#btnView').setDisabled(false);
//		                            grid.down('#btnDelete').setDisabled(false);
//		                        }
//		                    },
//		    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
//							var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//							if(columnName == "healthUploadDocument"){
//								if(e.target.tagName=='A'){
//									if(record.data.applicantHealthDocument.length == 1){
//										var whetherFile = false;
//										var documentId= record.data.applicantHealthDocument["0"].id;
//										if(!isNullOrEmpty(documentId)){
//											Ext.Ajax.request({
//												type: 'rest',
//												url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
//												method: 'GET',
//												callback : function(opt, success, response){
//													if(response.responseText == 'true') {
//														var csvForm = Ext.create('Ext.form.Panel'); 
//														csvForm.getForm().submit({
//															target: '_blank',
//															method:'GET',
//															params :{
//																access_token : Ext.Ajax.defaultHeaders.access_token
//															},
//															headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
//															url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
//															standardSubmit :true
//														});
//													} else {
//														showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
//													}
//												}
//											});
//										}} else if(record.data.applicantHealthDocument.length > 1){
//											var docWindow = this.getStudenthealthinformationdocumentlist();
//											var ID = record.data.id;
//											if (!docWindow) {
//												docWindow = Ext.widget('studenthealthinformationdocumentlist',{
//													itemId:'studenthealthinformationdocumentlist'
//												});
//											}
//											docWindow.show();
//											var studenthealthinformationdocumentlistgrid = docWindow.down('#studenthealthinformationdocumentlistgridItemId');
//											 var store = studenthealthinformationdocumentlistgrid.getStore();
//											  store.getProxy().extraParams = {
//			             						  ID: record.data.id
//			             					  };
//			             					  store.load();
//										}
//								}
//							}
//							if(columnName == "healthUploadUrl"){
//								if(e.target.tagName=='A'){
//									if(record.data.applicantHealthDocumentUrl.length == 1){
//										
//									} else if(record.data.applicantHealthDocumentUrl.length > 1){    	
//											var docWindow = this.getStudenthealthinformationdocumentlist();
//			             					  var ID = record.data.id;
//			             					  	             					  
//			             					 if (!docWindow) {
//												docWindow = Ext.widget('studenthealthinformationdocurllist',{
//													itemId:'studenthealthinformationdocurllist'
//												});
//			             					 }
//											docWindow.show();
//											
//											var studenthealthinformationdocurllistgrid = docWindow.down('#studenthealthinformationdocurllistgridItemId');
//											 var store = studenthealthinformationdocurllistgrid.getStore();
//											  store.getProxy().extraParams = {
//			             						  ID: record.data.id
//			             					  };
//			             					  store.load();
//										}
//								  }
//								}
//						}
//		            
//		            },
            
        	'onlinepaymentbilllevelapplicant':{
        		render: function(grid) {
        			this.disableMoreActionPivileges(grid, this.getAPPLICANT_ONLINE_PAYMENT_PERMISSIONS());
        		},
        		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        			this.onlinePaymentApplicantPortalGridCellClick(grid, td, cellIndex, record, tr, rowIndex, e, eOpts );
        		}
        	},

        	'onlinepaymentgrid':{
        		render: function(grid) {
        			this.disableMoreActionPivileges(grid, this.getAPPLICANT_ONLINE_PAYMENT_PERMISSIONS());
        		},
        		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        			this.onlinePaymentApplicantPortalGridCellClick(grid, td, cellIndex, record, tr, rowIndex, e, eOpts );
        		}
        	},
        	'receiptgridforapplicant[itemId=receiptgridforapplicant]': {
        		render: function(grid) {
        			var this$= this;
        			var applicantProfile = this$.getContentPanelActiveTab();
        			this.receiptPrintBtnPivileges(grid, this.getAPPLICATION_RECEIPT_PERMISSIONS());
        			try {
              		  	applicantProfile.getApplicationId();
            		  } catch(e){
            			applicantProfile = this$.getContentPanel().items.items[0];
            		}
        			if (applicantProfile) {
        				if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        					var userId = applicantProfile.getUserId();
        					var store = grid.getStore();
        					store.getProxy().extraParams={
        						personId : applicantProfile.getApplicationId(),
    							billedUserType : 'APPLICANT',
    							adjustmentType : 'Bill Receivable',
    							whetherDeleted : false,
    							raiseBillType:'P_AND_C_FEE'
         				   };
        					
        					/*var paramss = {
        							personId : applicantProfile.getApplicationId(),
        							billedUserType : 'APPLICANT',
        							adjustmentType : 'Bill Receivable',
        							whetherDeleted : false,
        							raiseBillType:'P_AND_C_FEE'
        					};*/
        					var url = SERVERURL.BASECURRENCYSTOREURL;
        					this.sendGetAjaxRequest(url, 'GET', null, function(opt, success, response) {
        						if(success) {
        							var currencyData = Ext.decode(response.responseText);
        							Academia.utilities.currency.CurrencyManager.currencyMasterData=currencyData;
        							grid.getStore().load();
        						}
        					});
        					
        				}
        			}
        		},
                cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
               	 var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
               	 if (cellDataIndex == "adjustment") {
                   	 this.viewPaymentRecievedHistoryForApplicantProfile('RECEIPT', 'receiptsettlementheadwindow', '#receiptgridforapplicant', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);   
                    }else if(cellDataIndex == "instrument"){
                   	 this.viewPaymentRecievedHistoryForApplicant('RECEIPT', 'paymentheaderinstrumentadjustmentdetailsgridwindow', '#receiptgridforapplicant', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
                    }
             		
                },
                select :function($this, record, index){
                	this.getCheckedReceiptForApplicant($this, record, index, 'select');
                },
                deselect :function($this, record, index){
                	this.getCheckedReceiptForApplicant($this, record, index, 'deselct');
                }
        	},
        	
        	'receiptgridforapplicant[itemId=receiptgridforapplicant] button[itemId=btnPrint]': {
        		click: function(grid) {
        			var $this = this;
        			var gridComp = $this.getActiveTabfromContentPanel().down('receiptgridforapplicant');
        	        if(gridComp.getSelectionModel().getCount()>0){
                     this.exportJRXML('pdf');
                    }else{
                     showWarningMessage(getPersonModuleTranslation('RECEIPT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
                    }
        		}
        	},
        	
        	
        	/**
    		 * Online Bills Payment
    		 */
        	'onlinepaymentbilllevelapplicant[itemId=onlinepaymentbilllevelapplicantid]': {
                render: function(onlinePaymentGrid) {
               	 var this$= this;
               	 var applicantProfile = this$.getContentPanelActiveTab();
                    if (applicantProfile) {
                   	 if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                   		 var userId = applicantProfile.getUserId();
                   		 var paramss = {
                   				 id : applicantProfile.getApplicationId(),
                   				 billedUserType : 'APPLICANT',
                   				 adjustmentType : 'Bill Receivable',
                   				 showAllSettlement : 'Pending',
                   				 limit:-1
                   		 };
                   		onlinePaymentGrid.getStore().load({
                   			 params:paramss,
                   			 callback:function(record,response,operation){
                   				 var onlinePaymentGrid = Ext.ComponentQuery.query('onlinepaymentbilllevelapplicant')[0];
                   				 
                   				 if(onlinePaymentGrid){
/*                    					 var applicantprofilePnl = onlinePaymentGrid.up('applicantprofile').down();
                   					 var topS = applicantprofilePnl.body.getScroll().top;
                   					 onlinePaymentGrid.getSelectionModel().selectAll();
                   					 onlinePaymentGrid.getSelectionModel().setLocked(true);
                   					 applicantprofilePnl.body.setScrollTop(topS);*/
/*    	 								 if (record.length > 0) {
   		 								this$.toggleGridSummaryRow(grid,true);
   	 								 }else{
   		 								this$.toggleGridSummaryRow(grid,false);
   	 								 }
*/                    					 for(var i in record) {
   	 									 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == true){	
   	 										onlinePaymentGrid.getSelectionModel().select(record[i],true);
   	 									 }
   	 								 }
   	 								 for(var i in record) {
   	 									 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == false){	
   	 										onlinePaymentGrid.getSelectionModel().deselect(record[i],true);
   	 									 }
   	 								 }
   	 								 var applicantprofilePnl = onlinePaymentGrid.up('applicantprofile').down();
										 var topS = applicantprofilePnl.body.getScroll().top;
										 applicantprofilePnl.body.setScrollTop(topS);
                   				 }
                   				var XMLHttpRequestObject = false;  
         					   if (window.XMLHttpRequest) {  
         						   XMLHttpRequestObject = new XMLHttpRequest();  
         						   XMLHttpRequestObject.overrideMimeType("text/xml");  
         					   }  
         					   else if (window.ActiveXObject) {  
         						   XMLHttpRequestObject = new  
         						   ActiveXObject("Microsoft.XMLHTTP");  
         					   } 
         					   if(XMLHttpRequestObject) {  
         						   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
         						   XMLHttpRequestObject.onreadystatechange = function() {       
         							   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
         								   var xmlDocument = XMLHttpRequestObject.responseXML;  
         								   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
         								   paymentPostUrl = buildInfo.getElementsByTagName("paymentPostUrl") [0].childNodes[0].nodeValue;
         								   Ext.apply(onlinePaymentGrid,{
         									   paymentPostUrl:null,
         									   setPaymentPostUrl : function(paymentPostUrl){
         										   onlinePaymentGrid.paymentPostUrl = paymentPostUrl;
         									   },
         									   getPaymentPostUrl:function(){
         										   return onlinePaymentGrid.paymentPostUrl;
         									   }
         								   });
         								   onlinePaymentGrid.setPaymentPostUrl(paymentPostUrl);
         							   }  
         						   }  
         						   XMLHttpRequestObject.send(null);  
         					   }
                   			 }
                   		
                   		 });
                   	 }
                   	 
                   	 var applicationStatus = applicantProfile.applicationInfo.applicationStatus;
                   	 var buttonsToolBar = onlinePaymentGrid.query('toolbar')[0];
       				 var menuItemsBtn = buttonsToolBar.query('#btnView')[0];
       				 
       				 if(applicationStatus==='REJECTED' || applicationStatus==='WITHDRAWN'){
       					 menuItemsBtn.setDisabled(true);
       				 }else{
       					 menuItemsBtn.setDisabled(false);
       				 }
                    }
                } 
            },
            'paymentsummarywin[itemId=applicant] button[itemId=okBtn]' : {
            	click : function(obj) {
            		var $this = this;
            		var grid;
            		var portalId = $this.getCurrentLoggedPortalId();
            		if(portalId==6){
            			grid = $this.getOnlinepaymentgrid();
            		}else
            		{
            			grid = $this.getOnlinepaymentapplicantstructure().down('grid');
            		}
            		/* if($this.getOnlinepaymentgrid().activeUI)
   				   {	   
   					   grid = $this.getOnlinepaymentgrid();
   				   }else
   				   {
   					   grid = $this.getOnlinepaymentbilllevelapplicant();

   				   }*/
            		grid.getSelectionModel().deselectAll();
            		var formWindow  = obj.up().up().up();
            		grid.getStore().reload();
            		formWindow.close();
            	}
            },
  		   'paymentsummarywin[itemId=applicant] button[itemId=cancelBtn]' : {
  			   click : function(obj) {
  				   var $this = this;
  				   var formWindow  = obj.up().up().up();
  				   formWindow.hide();
  			   }
  		   },
  			'paymentsummarywin[itemId=applicant] button[itemId=payNow]' : {
   			   click : function(obj) {
   				   var $this = this;
   				   var formWindow  = obj.up().up().up();
   				   var record, grid = $this.getOnlinepaymentgrid();
   				   if(grid != undefined) {
   					   record = grid.getSelectionModel().getSelection()[0].data;
   				   }
   				   if(grid)
   				   var XMLHttpRequestObject = false;  
  					   if (window.XMLHttpRequest) {  
  						   XMLHttpRequestObject = new XMLHttpRequest();  
  						   XMLHttpRequestObject.overrideMimeType("text/xml");  
  					   }  
  					   else if (window.ActiveXObject) {  
  						   XMLHttpRequestObject = new  
  						   ActiveXObject("Microsoft.XMLHTTP");  
  					   } 
  					   var tabName = getExaminationTranslation('EXAMINATION_APPLY_FOR_REVALUATION');
  					   var getcontroller=$this.getController('menu.CoreERPNavigationController');
  					   var getTab=getcontroller.getTab(tabName);
  					   var contentpanel = this.getContentPanel();
  					   if(XMLHttpRequestObject) {  
  						   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
  						   XMLHttpRequestObject.onreadystatechange = function() {       
  							   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
  								   var xmlDocument = XMLHttpRequestObject.responseXML;  
  								   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
  								   gatewayPostUrl = buildInfo.getElementsByTagName("gatewayPostUrl") [0].childNodes[0].nodeValue;
  								   var w ='900',h ='500';
  								// Fixes dual-screen position                         Most browsers      Firefox
  								    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
  								    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

  								    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
  								    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

  								    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
  								    var top = ((height / 2) - (h / 2)) + dualScreenTop;
  								    var url = gatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+$this.getCurrentAcademyLocation(); 
  								    if(!isNullOrEmpty(record)) {
  								    	url = gatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+record.academyLocationId+"&merchantReference="+record.schoolTypeCode; 
  								    }
  								    var newWindow =window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);
  								    // Puts focus on the newWindow
  								    if (window.focus) {
  								        newWindow.focus();
  								    }
  								    
  								  /* window.open(revalPaymentUrl+"?id="+formWindow.getData(),'Online_Payment',
  										    "status=no,height=" + 800 + ",width=" + 800 + ",resizable=yes,left="
  										    + left + ",top=" + top + ",screenX=" + left + ",screenY="
  										    + top + ",toolbar=no,menubar=no,scrollbars=no,location=no,directories=no");*/
               				   Ext.defer(function() {
               					   formWindow.down('#payNow').setVisible(false);
               					   formWindow.down('#cancelBtn').setVisible(false);
               					   formWindow.down('#okBtn').setVisible(true);
               				   }, 150, this);
  							   }  
  						   }  
  						   XMLHttpRequestObject.send(null);  
  					   }
   			   }
   		   },
             
 		  'onlinepaymentbilllevelapplicant[itemId=onlinepaymentbilllevelapplicantid] button[itemId=btnView]': {
         	 click: function() {
         		 var $this = this;
         		 var grid = this.getOnlinepaymentbilllevelapplicant();
         		 var applicantProfile = $this.getContentPanelActiveTab();
         		 var personInfoPanel=applicantProfile.down("#personInfoPanel");
         		 var orgModel = Academia.model.common.OrgSettingDateTimeModel;
         		 var personDetail = applicantProfile.getApplicationDataObject().person;
         		 if(grid.getSelectionModel().getCount()>0){
         			 var records = grid.selModel.getSelection();
         			 var totalAmount=0;
         			 var totalBalanceAmount=0;
         			 for(var i in records){
         				 var balanceAmounts = records[i].get('balanceAmount');
         				 var amounts = records[i].get('balanceAmount');

         				 totalBalanceAmount = totalBalanceAmount + balanceAmounts;
         				 totalAmount = totalAmount + amounts;
         			 }
         			 if(totalBalanceAmount >=0 && totalAmount>=0){ 
         				 var onlineAmount=[];
         				 for(var i in records){
         					 onlineAmount.push({
         						 //"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
         						 "billId":records[i].get('billId'),
//         						 "adjustedAmount":records[i].get('totalBalanceAmount'),
         						 "adjustedAmount":records[i].data.balanceAmount,
//         						 "balanceAmount": records[i].get('tempRemainingAmount')
         						 "balanceAmount": records[i].get(0) 
         					 });
         				 }
         				 var submitData = {
         						 "receiptAmount" : totalAmount,
         						 "onlinePayments" : onlineAmount
         				 };

         				 var amount=totalAmount;
         				 var name=personDetail.printName;
         				 var mobileNo=personDetail.mobileNumber;
         				 var emailId=personDetail.emailId;
         				 var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
         				 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
         				 showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
         					 if (btn == 'yes') {
        						 var XMLHttpRequestObject = false;  
         						   if (window.XMLHttpRequest) {  
         							   XMLHttpRequestObject = new XMLHttpRequest();  
         							   XMLHttpRequestObject.overrideMimeType("text/xml");  
         						   }  
         						   else if (window.ActiveXObject) {  
         							   XMLHttpRequestObject = new  
         							   ActiveXObject("Microsoft.XMLHTTP");  
         						   } 
         						   XMLHttpRequestObject.withCredentials = false;
         						   XMLHttpRequestObject.onreadystatechange = function() {
         							   if (this.readyState == 4 && this.status == 200) {
         								   var id = parseInt(XMLHttpRequestObject.responseText);
         								   if(!isNaN(id)) {
         									   var formWindow = Ext.widget('paymentsummarywin',{
         										   itemId:'applicant'
         									   });
         									   
         									var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
         						            if(!isNullOrEmpty(url)){
         						            	url = url.concat("?id=" + applicantProfile.applicationId);
         						                Ext.Ajax.request({
         						                    type: 'rest',
         						                    url: url,
         						                    method: 'GET',
         						                    success: function(res, action) {
         						                    	var data = Ext.decode(res.responseText);
         						                    	formWindow.down('#name').setValue(data.applicantName);
         						                    	formWindow.down('#email').setValue(data.email);
         						                    	formWindow.down('#mobileNo').setValue(mobileNo);
         						                    	formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
         						                    	formWindow.show();
         						                    	Ext.apply(formWindow,{
         						                    		data:null,
         						                    		setData : function(data){
         						                    			formWindow.data = data;
         						                    		},
         						                    		getData:function(){
         						                    			return formWindow.data;
         						                    		}
         						                    	});
         						                    	formWindow.setData(id);
         						                    	formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
                                                        formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
         						                    }
         						                });
         						            }
         									   
         									   
         									   /*var summaryGrid = formWindow.down('grid');
         									   summaryGrid.getStore().loadRawData([]);
         									   summaryGrid.getStore().loadRawData(innerJsonArr);
         									   var summaryWindMsg = formWindow.down('#summaryWindMsg');
         									   summaryWindMsg.setVisible(true);
         									   summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : '+totalAmmount+" /-</b>");*/
         								   } else {
         									   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
         								   }
         							   }
         						   };
         						  //var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
         						  Ext.Ajax.request({
											type : 'rest',
											url : submitUrl,
											jsonData : submitData,
											method : 'POST',
											success : function(response, action) {
												//onlinePaymentId
												var onlinePaymentId = response.responseText;
												XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
												XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
												XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
											}
         						  });
          						 /*var buildInfo="";
          						 var paymentUrl="";  
          						 var XMLHttpRequestObject = false;  
          						 if (window.XMLHttpRequest) {  
          							 XMLHttpRequestObject = new XMLHttpRequest();  
          							 XMLHttpRequestObject.overrideMimeType("text/xml");  
          						 }  
          						 else if (window.ActiveXObject) {  
          							 XMLHttpRequestObject = new  
          							 ActiveXObject("Microsoft.XMLHTTP");  
          						 }  
          						 if(XMLHttpRequestObject) {  
          							 XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
          							 XMLHttpRequestObject.onreadystatechange = function(){       
          								 if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200){  
          									 var xmlDocument = XMLHttpRequestObject.responseXML;  
          									 buildInfo =xmlDocument.getElementsByTagName("buildInfo") [0];  
          									 paymentUrl = buildInfo.getElementsByTagName("paymentUrl") [0].childNodes[0].nodeValue;
          									 Ext.getBody().mask('wait..', 'x-mask-loading');
          									 Ext.Ajax.request({
          										 type : 'rest',
          										 url : submitUrl,
          										 jsonData : submitData,
          										 method : 'POST',
          										 success : function(response, action) {
          											 //onlinePaymentId
          											 var onlinePaymentId = response.responseText;
          											 window.open(paymentUrl+"?onlinePaymentId="+onlinePaymentId,"Online_Payment","width=1000,height=600");
          											 Ext.getBody().unmask();
          											 
          											 var tabName = getPersonModuleTranslation('ONLINE_PAYMENT');
          		            			    		 var tabDetail = personInfoPanel.items.items;
          		            			        	 for(var i in tabDetail){
          		            			        		 if(tabDetail[i].title==tabName){
          		            			        			 tabDetail[i].close();
          		            			        		 }
          		            			        	 }
          										 }
          									 });
          								 }  
          							 } 
          							 XMLHttpRequestObject.send(null);  
          						 }
          					 */}
         				 })
         			 }else{
         				 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
         			 }
         		 }else{
         			 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
         		 }
         	 } 
          },
        	
        	/**
    		 * Online Bills Payment
    		 */
          'onlinepaymentgrid[itemId=onlinepaymentgridid]': {
              render: function(onlinePaymentGrid) {
             	 var this$= this;
             	 var applicantProfile = this$.getContentPanelActiveTab();
                  if (applicantProfile) {
                	  try {
                		  applicantProfile.getApplicationId();
              		  } catch(e){
              			applicantProfile = this$.getContentPanel().items.items[0];
              		  }
                	  if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                 		 var userId = applicantProfile.getUserId();
                 		 var paramss = {
                 				 id : applicantProfile.getApplicationId(),
                 				 billedUserType : 'APPLICANT',
                 				 adjustmentType : 'Bill Receivable',
                 				 showAllSettlement : 'Pending',
                 				 limit:-1
                 		 };
                 		setTimeout(function(){
                 		 onlinePaymentGrid.getStore().load({
                 			 params:paramss,
                 			 callback:function(record,response,operation){
                 				 var onlinePaymentGrid = Ext.ComponentQuery.query('onlinepaymentgrid')[0];
                 				 
                 				 if(onlinePaymentGrid){
                 					 /*
                 					 var applicantprofilePnl = onlinePaymentGrid.up('applicantprofile').down();
                 					 var topS = applicantprofilePnl.body.getScroll().top;
                 					 onlinePaymentGrid.getSelectionModel().selectAll();
                 					 onlinePaymentGrid.getSelectionModel().setLocked(true);
                 					 applicantprofilePnl.body.setScrollTop(topS);
                 					 */
                 					for(var i in record) {
 	 									 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == true){	
 	 										onlinePaymentGrid.getSelectionModel().select(record[i],true);
 	 									 }
 	 								 }
 	 								for(var i in record) {
 	 									 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == false){	
 	 										onlinePaymentGrid.getSelectionModel().deselect(record[i],true);
 	 									 }
 	 								 }
 	 								try {
 	 									applicantprofilePnl = onlinePaymentGrid.up('applicantprofile').down();
 	 								} catch(e){
 	 									applicantprofilePnl = this$.getContentPanel().items.items[0].down();
 	 								}
  	 								//var applicantprofilePnl = onlinePaymentGrid.up('applicantprofile').down();
 	 								var topS = applicantprofilePnl.body.getScroll().top;
                 					applicantprofilePnl.body.setScrollTop(topS);
                 				 }
                 				var XMLHttpRequestObject = false;  
           					   if (window.XMLHttpRequest) {  
           						   XMLHttpRequestObject = new XMLHttpRequest();  
           						   XMLHttpRequestObject.overrideMimeType("text/xml");  
           					   }  
           					   else if (window.ActiveXObject) {  
           						   XMLHttpRequestObject = new  
           						   ActiveXObject("Microsoft.XMLHTTP");  
           					   } 
           					   if(XMLHttpRequestObject) {  
           						   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
           						   XMLHttpRequestObject.onreadystatechange = function() {       
           							   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
           								   var xmlDocument = XMLHttpRequestObject.responseXML;  
           								   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
           								   paymentPostUrl = buildInfo.getElementsByTagName("paymentPostUrl") [0].childNodes[0].nodeValue;
           								   Ext.apply(onlinePaymentGrid,{
           									   paymentPostUrl:null,
           									   setPaymentPostUrl : function(paymentPostUrl){
           										   onlinePaymentGrid.paymentPostUrl = paymentPostUrl;
           									   },
           									   getPaymentPostUrl:function(){
           										   return onlinePaymentGrid.paymentPostUrl;
           									   }
           								   });
           								   onlinePaymentGrid.setPaymentPostUrl(paymentPostUrl);
           							   }  
           						   }  
           						   XMLHttpRequestObject.send(null);  
           					   }
           					if (record.length > 0) {
           						this$.toggleGridSummaryRow(onlinePaymentGrid,true);
      					  }else{
      						this$.toggleGridSummaryRow(onlinePaymentGrid,false);
      					  }
                 			 }
                 		 
                 		 });
                 		},500);
                 		 
                 	 }
                 	 
                 	 var applicationStatus = applicantProfile.applicationInfo.applicationStatus;
                 	 var buttonsToolBar = onlinePaymentGrid.query('toolbar')[0];
     				 var menuItemsBtn = buttonsToolBar.query('#btnView')[0];
     				 
     				 if(applicationStatus==='REJECTED' || applicationStatus==='WITHDRAWN'){
     					 menuItemsBtn.setDisabled(true);
     				 }else{
     					 menuItemsBtn.setDisabled(false);
     				 }
                  }
              } 
          },
             'onlinepaymentgrid[itemId=onlinepaymentgridid] numberfield[itemId=amountToBeAdjusted]': {
            	 change : function(obj,newValue){
            		 var grid = obj.ownerCt.grid;
            		 var selectedRow = grid.getSelectionModel().getSelection()[0];
            		 var amounttobeadjusted = obj.getValue();
            		
            		 var totaltempbalanceamount = selectedRow.get('totalTempBalanceAmount');
            		 var remainingAmount = totaltempbalanceamount - amounttobeadjusted
            		 selectedRow.set('tempRemainingAmount',remainingAmount);
            		 
            		 if(totaltempbalanceamount < amounttobeadjusted){
            			 obj.reset();
            			// selectedRow.set('totalBalanceAmount',totaltempbalanceamount);
            			 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('SETTLED_AMOUNT_SHOULD_BE_EQUAL_TO_BALANCE_AMOUNT'));//Please select a reco
            		 }
            	 }
             },
             'onlinepaymentgrid[itemId=onlinepaymentgridid] button[itemId=btnView]': {
            	 click: function() {
            		 var $this = this;
            		 var grid = this.getOnlinepaymentgrid();
            		 var applicantProfile = $this.getContentPanelActiveTab();
            		 try {
            			 applicantProfile.getApplicationDataObject();
            		 } catch(e){
            			 applicantProfile = $this.getContentPanel().items.items[0];
            		 }
            		 var applicantID = applicantProfile.getApplicationId();
            		 var personInfoPanel=applicantProfile.down("#personInfoPanel");
            		 var personDetail = applicantProfile.getApplicationDataObject().person;
            		 var orgModel = Academia.model.common.OrgSettingDateTimeModel;
            		// var gridRecord = grid.getStore().data.items[0];
            		 var gridRecord=grid.getSelectionModel().getSelection();
            		 if(gridRecord.length>0 && gridRecord.whetherActive=="false" && portalId=='6'){
						 return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICANT_ONLINE_PAYMENT_DATE_PASSED')); 
            		 }
            		 if(grid.getSelectionModel().getCount()>0){
            			 Ext.Ajax.request({
            				 method: "GET",
            				 type: 'rest',
            				 scope:$this,
            				 url: SERVERURL.ORGINFOLOADREQUEST,
            				 success: function(response, action) {
            					 var data = JSON.parse(response.responseText);
            					 var grid = $this.getOnlinepaymentgrid();
            					 if(data.whetherOnlinePaymentSettings && grid.getSelectionModel().getCount()>1){
            						 return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MULTIPLE_INVOICES_DETECTED_PLEASE_SELECT_ONLY_ONE_INVOICE_TO_PROCEED_WITH_ONLINE_PAYMENT')); 
            					 }
            					 var records = grid.selModel.getSelection();
            					 /*****check implemented for online payment start*******/
            					 var paramss = {
            							 id : applicantID,
            							 billedUserType : 'APPLICANT',
            							 adjustmentType : 'Bill Receivable',
            							 showAllSettlement : 'Pending',
            							 limit:-1,
            							 page: 1
            					 };
            					 var submitUrl = SERVERURL.BILL_ADJUSTMENT_GRID_ONLINEPAYMENT;
            					 Ext.Ajax.request({
            						 type : 'rest',
            						 url : submitUrl,
            						 params : paramss, 
            						 method : 'GET',
            						 success: function(res, action) {
            							 var isTransDone=false;
            							 var response = Ext.decode(res.responseText);

            							 if( Object.keys(response).length > 0 ){
            								 var responseRecords=response.rows;
            								 var recordLength = responseRecords.length;
            								 if(recordLength==0){
            									 isTransDone = true;
            								 }
            								 var grid=$this.getOnlinepaymentgrid();
            								 var gridRecords = grid.selModel.getSelection();
            								 /***for record is not there in the grid****/
            								 var responseBillIdsArray = [];
            								 for( var i = 0; i < responseRecords.length; i++) {
            									 responseBillIdsArray.push(responseRecords[i].billFeePlanRuleStageId);
            								 }
            								 for( var a = 0; a < gridRecords.length; a++) {
            									 for(rec in responseRecords){
            										 if(gridRecords[a].data.billFeePlanRuleStageId == responseRecords[rec].billFeePlanRuleStageId){
            											 if(gridRecords[a].data.totalBalanceAmount != responseRecords[rec].totalBalanceAmount){
            												 if(gridRecords[a].data.tempRemainingAmount >0){
            													 isTransDone = false;
            												 }else{
            													 isTransDone = true;
            													 break;
            												 }
            											 }
            										 }
            									 }
            									 if(responseBillIdsArray.indexOf(gridRecords[a].data.billFeePlanRuleStageId) === -1){
            										 /************* transaction Done **************/
            										 isTransDone = true;
            										 break;
            									 }
            								 }

            								 if(isTransDone==false){
            									 //$this.redirectOnlinePaymentProcessFromHeadLevelGrid(flagIsHostelFee,flagForHostelJSON);
            									 var totalAmount=0;
            									 var totalBalanceAmount=0;
            									 var FeePlanCurrency=records[0].data.currencyId;
            									 var applicantProfile = $this.getContentPanelActiveTab();
            									 try {
            										 applicantProfile.getApplicationDataObject();
            									 } catch(e){
            										 applicantProfile = $this.getContentPanel().items.items[0];
            									 }
            									 var personInfoPanel=applicantProfile.down("#personInfoPanel");
            									 var personDetail = applicantProfile.getApplicationDataObject().person;
            									 var orgModel = Academia.model.common.OrgSettingDateTimeModel;
            									 var code = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(FeePlanCurrency);  
            									 for(var i in records){
            										 var balanceAmounts = records[i].get('tempRemainingAmount');
            										 var amounts = records[i].get('totalBalanceAmount');

            										 totalBalanceAmount = totalBalanceAmount + balanceAmounts;
            										 totalAmount = totalAmount + amounts;
            									 }
            									 if(totalBalanceAmount >=0 && totalAmount>=0){ 
            										 var onlineAmount=[];
            										 for(var i in records){
            											 onlineAmount.push({
            												 "billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
            												 "billId":records[i].get('billHeaderId'),
            												 "adjustedAmount":records[i].get('totalBalanceAmount'),
            												 "balanceAmount": records[i].get('tempRemainingAmount')   
            											 });
            										 }
            										 var submitData = {
            												 "receiptAmount" : totalAmount,
            												 "onlinePayments" : onlineAmount
            										 };

            										 var amount=totalAmount;
            										 var name=personDetail.printName;
            										 var mobileNo=personDetail.mobileNumber;
            										 var emailId=personDetail.emailId;
            										 var message = 'Are you sure, you want to make payment of ' + code + ' ' +totalAmount+' ?';
            										 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
            										 showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
            											 if (btn == 'yes') {
            												 var XMLHttpRequestObject = false;  
            												 if (window.XMLHttpRequest) {  
            													 XMLHttpRequestObject = new XMLHttpRequest();  
            													 XMLHttpRequestObject.overrideMimeType("text/xml");  
            												 }  
            												 else if (window.ActiveXObject) {  
            													 XMLHttpRequestObject = new  
            													 ActiveXObject("Microsoft.XMLHTTP");  
            												 } 
            												 XMLHttpRequestObject.withCredentials = false;
            												 XMLHttpRequestObject.onreadystatechange = function() {
            													 if (this.readyState == 4 && this.status == 200) {
            														 var id = parseInt(XMLHttpRequestObject.responseText);
            														 if(!isNaN(id)) {
            															 var formWindow = Ext.widget('paymentsummarywin',{
            																 itemId:'applicant'
            															 });
            															 var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
            															 if(!isNullOrEmpty(url)){
            																 url = url.concat("?id=" + applicantProfile.applicationId);
            																 Ext.Ajax.request({
            																	 type: 'rest',
            																	 url: url,
            																	 method: 'GET',
            																	 success: function(res, action) {
            																		 var data = Ext.decode(res.responseText);
            																		 formWindow.down('#name').setValue(data.applicantName);
            																		 formWindow.down('#email').setValue(data.email);
            																		 formWindow.down('#mobileNo').setValue(mobileNo);
            																		 //  	formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
            																		 formWindow.down('#amount').setValue(code+' '+totalAmount);
            																		 formWindow.show();
            																		 Ext.apply(formWindow,{
            																			 data:null,
            																			 setData : function(data){
            																				 formWindow.data = data;
            																			 },
            																			 getData:function(){
            																				 return formWindow.data;
            																			 }
            																		 });
            																		 formWindow.setData(id);
            																		 formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
            																		 formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
            																	 }
            																 });
            															 }
            														 } else {
            															 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
            														 }
            													 }
            												 };
            												 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
            												 Ext.Ajax.request({
            													 type : 'rest',
            													 url : submitUrl,
            													 jsonData : submitData,
            													 method : 'POST',
            													 success : function(response, action) {
            														 //onlinePaymentId
            														 var onlinePaymentId = response.responseText;
            														 XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
            														 XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            														 XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
            													 }
            												 });
            												 /*var buildInfo="";
				          						 var paymentUrl="";  
				          						 var XMLHttpRequestObject = false;  
				          						 if (window.XMLHttpRequest) {  
				          							 XMLHttpRequestObject = new XMLHttpRequest();  
				          							 XMLHttpRequestObject.overrideMimeType("text/xml");  
				          						 }  
				          						 else if (window.ActiveXObject) {  
				          							 XMLHttpRequestObject = new  
				          							 ActiveXObject("Microsoft.XMLHTTP");  
				          						 }  
				          						 if(XMLHttpRequestObject) {  
				          							 XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
				          							 XMLHttpRequestObject.onreadystatechange = function(){       
				          								 if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200){  
				          									 var xmlDocument = XMLHttpRequestObject.responseXML;  
				          									 buildInfo =xmlDocument.getElementsByTagName("buildInfo") [0];  
				          									 paymentUrl = buildInfo.getElementsByTagName("paymentUrl") [0].childNodes[0].nodeValue;
				          									 Ext.getBody().mask('wait..', 'x-mask-loading');
				          									 Ext.Ajax.request({
				          										 type : 'rest',
				          										 url : submitUrl,
				          										 jsonData : submitData,
				          										 method : 'POST',
				          										 success : function(response, action) {
				          											 //onlinePaymentId
				          											 var onlinePaymentId = response.responseText;
				          											 window.open(paymentUrl+"?onlinePaymentId="+onlinePaymentId,"Online_Payment","width=1000,height=600");
				          											 Ext.getBody().unmask();

				          											 var tabName = getPersonModuleTranslation('ONLINE_PAYMENT');
				          		            			    		 var tabDetail = personInfoPanel.items.items;
				          		            			        	 for(var i in tabDetail){
				          		            			        		 if(tabDetail[i].title==tabName){
				          		            			        			 tabDetail[i].close();
				          		            			        		 }
				          		            			        	 }
				          										 }
				          									 });
				          								 }  
				          							 } 
				          							 XMLHttpRequestObject.send(null);  
				          						 }
            												  */}
            										 })
            									 }else{
            										 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
            									 }

            								 }else{
            									 showNotificationMessage(getCommonTranslation('PAYMENT_PEOCESS'), getFeeAndPaymentCommonTranslation('PAYMENT_ALREADY_DONE_FOR_INVOICE')); 
            									 whetherGridRefresh =true;
            									 var grid = $this.getOnlinepaymentgrid();
            									 grid.getStore().getProxy().extraParams={
            										 id : applicantID,
            										 billedUserType : 'APPLICANT',
            										 adjustmentType : 'Bill Receivable',
            										 showAllSettlement : 'Pending',
            										 limit:-1
            									 };


            									 grid.getStore().load();
            								 }
            							 }
            						 }

            					 });
            				 }
            			 });
            			 /*****check implemented for online payment end******/
            		 }else{
            			 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
            		 }
            	 } 
             },

        	/**
        	 * Education Details
        	 */
            'educationhistorygrid[itemId=applicantEducationHistoryGrid]': {
                render: function(grid) {
                	this.loadGridStore('#applicantEducationHistoryGrid', SERVERURL.APPLICANT_EDUCATION_HISTORY_GRIDDATA);
                	this.doAccessControlValidation(grid, this.getAPPLICANT_EDUCATION_PERMISSIONS());
                	this.showContainerInViewMode(grid);                	
                },
                afterrender: function(grid) {
                	var me = this;
               	 var portalId = this.getCurrentLoggedPortalId();
              	  if(portalId==6){
              		  me.addDataGridConfigButton(grid,me.getAPPLICANT_EDUCATION_PERMISSIONS());
            		  }
              	  else{
  					me.addDataGridConfigButton(grid,me.getAPPLICANT_EDUCATION_PERMISSIONS());
    					
    					if(portalId==6){
   	 					 me.addDataGridConfigButton(grid,me.getAPPLICANT_EDUCATION_PERMISSIONS());
   	 				  }
              	  }
                }
            },
            'educationhistorygrid[itemId=applicantEducationHistoryGrid] button[itemId=btnAdd]': {
            	click: function() {
            		this.showPersonCommonWindow('EDUCATION', 'applicantEducationForm');
            	}
            },
            'educationhistorygrid[itemId=applicantEducationHistoryGrid] button[itemId=btnEdit]': {
                click: function(){
                	this.editEducationHistoryFormWindow('EDUCATION', 'applicantEducationForm', '#applicantEducationHistoryGrid', false, 'APPLICANT');
                }
            },
            'educationhistorygrid[itemId=applicantEducationHistoryGrid] button[itemId=btnView]': {
                click: function(){
                	this.viewEducationHistoryFormWindow('EDUCATION', 'applicantEducationForm', '#applicantEducationHistoryGrid','APPLICANT');
                }
            },
            'educationhistorygrid[itemId=applicantEducationHistoryGrid] button[itemId=btnDelete]': {
            	click: function(){
                	this.deleteEducationHistoryRecord('#applicantEducationHistoryGrid', SERVERURL.APPLICANT_EDUCATION_HISTORY_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] form[itemId=applicantEducationForm]': {
                afterrender: function() {
                    this.afterEducationFormRender();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=isExistingStudent]': {
                change: function(combo, records, eOpts) {
                    this.showHideStudentEnrollmentField(combo, combo.getValue());
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=gradeMark]': {
                change: function(combo, records, eOpts) {
                	this.showHideGradeMarkFileds(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=subject]': {
                select: function (obj, record) {
                	var subject = record[0].get('id');
                    var subjectCode = record[0].get('code');
                    var flag = true;
                    var subjectMarkPanel = obj.up("#subjectMarkPanel");
                    var rowIndx = obj.rowIndx;

                    if (!isNullOrEmpty(subjectMarkPanel)) {
                        subjectMarkPanel.items.each(function (item, index) {
                            var subjectNameVal = item.down("[name=subject]").getValue();
                            if (subjectCode !== 'Other') {
                                if (subject === subjectNameVal && rowIndx !== index) {
                                    flag = false;
                                    return false;
                                }
                            }
                        });

                        if (flag) {
                            var form = obj.up('form');
                            var fieldContainer = obj.up('fieldcontainer');

                            var marks = fieldContainer.down('#marks');
                            var subMaximumMarks = fieldContainer.down('#subMaximumMarks');
                            var symbolLevel = fieldContainer.down('#symbolLevelId');
                            var percentage = fieldContainer.down('#percentageId');

                            if (!isNullOrEmpty(marks)) {
                                marks.setDisabled(false);
                            }
                            if (!isNullOrEmpty(subMaximumMarks)) {
                                subMaximumMarks.setDisabled(false);
                            }
                            if (!isNullOrEmpty(symbolLevel)) {
                                symbolLevel.setDisabled(false);
                            }
                            if (!isNullOrEmpty(percentage)) {
                                percentage.setDisabled(false);
                            }

                            if (!obj.nextSibling().nextSibling().isHidden()) {
                                var otherSubjectField = obj.nextSibling().nextSibling();
                                otherSubjectField.setDisabled(false);
                                var assessment = otherSubjectField.nextSibling();
                                assessment.setDisabled(true);
                                var marksField = assessment.nextSibling().nextSibling();
                            } else {
                                if (!obj.nextSibling().nextSibling().nextSibling().isHidden()) {
                                    var assessment = obj.nextSibling().nextSibling().nextSibling();
                                    assessment.setDisabled(false);
                                    var otherSubjectField = assessment.nextSibling();
                                    var marksField = otherSubjectField.nextSibling();
                                    otherSubjectField.setDisabled(true);
                                } else {
                                    var assessment = obj.nextSibling().nextSibling().nextSibling();
                                    var otherSubjectField = assessment.nextSibling();
                                    var marksField = otherSubjectField.nextSibling();
                                    otherSubjectField.setDisabled(false);
                                }
                            }

                            if (marksField) {
                                marksField.setDisabled(false);
                                if (!isNullOrEmpty(subMaximumMarks)) {
                                    subMaximumMarks.setDisabled(false);
                                }
                            }

                            var otherSubject = obj.nextSibling();
                            if (subjectCode === 'Other') {
                                otherSubject.setVisible(true);
                                otherSubject.allowBlank = false;
                            } else {
                                otherSubject.reset();
                                otherSubject.setVisible(false);
                                otherSubject.allowBlank = true;
                            }

                            form.getForm().checkValidity();
                            form.getForm().isValid();

                        } else {
                            obj.reset();
                            var form = obj.up('form');
                            var fieldContainer = obj.up('fieldcontainer');

                            var otherSubject = obj.nextSibling();
                            otherSubject.reset();
                            otherSubject.allowBlank = true;
                            otherSubject.setVisible(false);

                            if (!obj.nextSibling().nextSibling().isHidden()) {
                                var nextSiblingField = obj.nextSibling().nextSibling();
                                nextSiblingField.reset();
                                nextSiblingField.setDisabled(true);
                            } else {
                                var nextSiblingField = obj.nextSibling().nextSibling().nextSibling();
                                nextSiblingField.reset();
                                nextSiblingField.setDisabled(true);
                            }

                            var marks = fieldContainer.down('#marks');
                            var subMaximumMarks = fieldContainer.down('#subMaximumMarks');
                            var symbolLevel = fieldContainer.down('#symbolLevelId');
                            var percentage = fieldContainer.down('#percentageId');

                            if (!isNullOrEmpty(marks)) {
                                marks.reset();
                                marks.setDisabled(true);
                            }
                            if (!isNullOrEmpty(subMaximumMarks)) {
                                subMaximumMarks.reset();
                                subMaximumMarks.setDisabled(true);
                            }
                            if (!isNullOrEmpty(symbolLevel)) {
                                symbolLevel.reset();
                                symbolLevel.setDisabled(true);
                            }
                            if (!isNullOrEmpty(percentage)) {
                                percentage.reset();
                                percentage.setDisabled(true);
                            }

                            form.getForm().checkValidity();
                            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUBJECT_ALREADY_SELECTED_MSG'));
                            return false;
                        }
                    }
                },

                afterrender: function (combo) {
                    var window = this.getPersonEducationForm();
                    var educationForm = window.getForm();
                    if (educationForm.findField("examBoard").getValue() === null) {
                        var store = combo.getStore();
                        store.getProxy().extraParams = {
                            id: null,
                            examBoardOther: null
                        };
                    }
                },

                change: function (obj) {
                    var form = obj.up('form');
                    var isVisible = null;
                    if (!isNullOrEmpty(form.down('#isAssessmentLevelVisible'))) {
                        isVisible = form.down('#isAssessmentLevelVisible').getValue();
                    }
                    var assessmentLevel = obj.nextSibling().nextSibling().nextSibling();
                    if (!isNullOrEmpty(isVisible) && isVisible === 'true') {
                        assessmentLevel.setDisabled(false);
                    }
                }
            },
            
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[name=conversionMaster]': {
                select: function(combo, records, eOpts) {
                	var comboId = combo.getValue();
                	var marks = combo.nextSibling();
                	this.findConfiguredMarksByGradeId(comboId, marks);
                	/*if(marks){
                		marks.setValue(false);
                	}*/
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[name=assessmentLevel]': {
                select: function(combo, records, eOpts) {
                	var comboId = combo.getValue();
                	var form = combo.up('educationform');
                	var examboard = form.down('#examBoard');
                	var examBoardId = examboard.getValue();
                	var conversationMaster = combo.nextSibling();
                	conversationMaster.setDisabled(false);
                	var marks = conversationMaster.nextSibling();
                	conversationMaster.reset();
                	if(marks) {
                		marks.reset();
                	}
                	var store = conversationMaster.getStore();
                	store.getProxy().extraParams = {
            			examBoardId:examBoardId,
            			assessmentLevel:comboId
            		};
            		store.load();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm]': {
            	afterrender: function(form) {
            		var $this = this;
            		var examPassedDropDown = form.down('#examPassed');
            		var examPassedStore = examPassedDropDown.getStore();
            		var applicantprofile = this.getApplicantprofile();
            		var currentActivity = applicantprofile.applicationDataObject.person.currentActivity;
            		var currentActivityId = null;
            		if (!isNullOrEmpty(currentActivity)) {
            			currentActivityId = currentActivity.id;
					}
            		examPassedStore.getProxy().extraParams = {
            			currentActivityId:currentActivityId
            		};
            		examPassedStore.load();
            	}
            },
            
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=resultStatusId]': {
                change: function(combo, records, eOpts) {
                	this.shoHideMarksDeatilFields(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] button[itemId=submitButtonId]': {
                click: function(){
                	this.saveEducationHistory('#applicantEducationHistoryGrid', SERVERURL.APPLICANT_EDUCATION_HISTORY_ADD, SERVERURL.APPLICANT_EDUCATION_HISTORY_UPDATE, 'applicant');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] radiogroup#educationRepeatedSubjectId':{
            	change:function(obj,newValue,oldValue){
            		var  $this = this;
            		var form = obj.up('educationform');
            		var uploadDocField = form.down('#uploadFileItemId');
            		var educationDownloadURL = form.down('#educationDownloadURL');
            		var submitButton = form.down('#submitButtonId');
            		var path = educationDownloadURL.getValue();
            		var value = newValue.isRepeatedSubject;
            		var id = form.down('#education_hidden_field').getValue();
            		var DocumentDownloadURLField = form.down('#educationDownloadURL');
            		if (!isNullOrEmpty(id)) {
            			if (!isNullOrEmpty(path)) {
            				uploadDocField.allowBlank=true;
            			}else{
            				uploadDocField.allowBlank=false;
            			}

            		}else{
            			uploadDocField.allowBlank=false;
            		}

            		if (value!= null && value == true) {
            			uploadDocField.setVisible(true);
            			if (!form.isValid()) {
            				submitButton.setDisabled(true);
            			}
            			DocumentDownloadURLField.setVisible(true);
            			DocumentDownloadURLField.setDisabled(false);
            		}else{
            			uploadDocField.setVisible(false);
            			uploadDocField.allowBlank=true;
            			uploadDocField.reset();
            			if (form.isValid()) {
            				submitButton.setDisabled(false);
            			}
            			DocumentDownloadURLField.setVisible(false);
            			DocumentDownloadURLField.setDisabled(true);
            		}
            	} 
              		 
               },
               'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] filefield#uploadFileItemId':{
            	   change:function(obj,newValue,oldValue){
            		   var form = obj.up('educationform');
            		   var submitButton = form.down('#submitButtonId');
            		   if (!form.isValid()) {
							 submitButton.setDisabled(true);
						}else{
							submitButton.setDisabled(false);
						}
            	   }
               },
       
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=examBoard]': {
            	change: function(combo) {
            		var id = combo.getValue();
            		var examBoardOther = null;
            		var value = combo.getRawValue();
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();
            		var form =window.getForm();
            		var examBoardVisable= form.findField('examBoard').isVisible();
            		if(value == 'Others'){
            			examBoardOther = true ;
            		}else{
            			examBoardOther = false ; 
            		}
    		    	if(examBoardVisable){
    		    		var subjectMarkPanel = window.down('#subjectMarkPanel');
            			for(var i=subjectMarkPanel.items.length-1; i>0;i--){
            				subjectMarkPanel.remove(subjectMarkPanel.items.items[i]);
            			}
            			window.doLayout();
            			var subjectField =  form.findField("subject");
            			var store = subjectField.getStore();
            			if (window.items.items != null && window.items.items.length > 0) {
            				Ext.each(window.items.items, function(val) {
            					if(val.itemId =='subjectMarkPanel'){
            					var count = 0;
            						Ext.each(val.items.items, function(valueSubject){
            						if (count >0) {
            							valueSubject.removeAll();
									}else{
            							valueSubject.items.get('subject').reset();
            							valueSubject.items.get('marks').reset();
            							valueSubject.items.get('marks').isValid();
            							if (!isNullOrEmpty(valueSubject.items.get('otherSubject'))) {
            								valueSubject.items.get('otherSubject').reset();
            							}
            							if (!isNullOrEmpty(valueSubject.items.get('assessmentLevel'))) {
            								valueSubject.items.get('assessmentLevel').reset();
            							}
            							if (!isNullOrEmpty(valueSubject.items.get('conversionMaster'))) {
	            							valueSubject.items.get('conversionMaster').reset();
	            							valueSubject.items.get('conversionMaster').clearValue();
										}
									}});
            					}
            				});
            			}
            		store.getProxy().extraParams = {
            			id:id ,
            			examBoardOther:examBoardOther
            		};
            		store.load();
            		if(value == 'Others'){
            			var window = this.getPersonEducationForm();
            			var educationForm = this.getPersonEducationForm().getForm();	
            			var form =window.getForm();
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(false);
            			form.findField("examConductedBy").setVisible(true);
            		}
            		else{
            			var window = this.getPersonEducationForm();
            			var educationForm = this.getPersonEducationForm().getForm();	
            			var form =window.getForm();
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(true);
            			form.findField("examConductedBy").setVisible(false);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}
            	}
    		    	if (!isNullOrEmpty(id)) {
    		    		this.findExamBoradType(id, window, 'APPLICANT');
					}
					var assessmentLevel =  form.findField("assessmentLevel");
    		    	assessmentLevel.reset();
    		    	var academyLocationId = this.getCurrentAcademyLocation();
            		var assessmentLevelStore = assessmentLevel.getStore();
            		assessmentLevelStore.getProxy().extraParams = {
            			examBoardId:id
            		};
            		assessmentLevelStore.load();
            		var conversionMaster =  form.findField("conversionMaster");
            		conversionMaster.reset();
            		var conversionMasterStore = conversionMaster.getStore();
            		conversionMasterStore.getProxy().extraParams = {
            			examBoardId:id
            		};
            		conversionMasterStore.load();
            	},
            	select: function(combo){
            		var value = combo.getRawValue();
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();	
            		var form =window.getForm();
            		if(value == 'Others'){
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(false);
            			form.findField("examConductedBy").setVisible(true);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}
            		var subjectMarkPanel = window.down('#subjectMarkPanel');
            		for(var i=subjectMarkPanel.items.length-1; i>0;i--){
            			subjectMarkPanel.remove(subjectMarkPanel.items.items[i]);
            		}
            		window.doLayout();
            		var subjectField =  form.findField("subject");
            		var store = subjectField.getStore();
            		if (window.items.items != null && window.items.items.length > 0) {
            			Ext.each(window.items.items, function(val) {
            				if(val.itemId =='subjectMarkPanel'){
            					Ext.each(val.items.items, function(valueSubject){
            						valueSubject.items.get('subject').reset();
            						valueSubject.items.get('marks').reset();
            						valueSubject.items.get('marks').isValid();
            						valueSubject.items.get('assessmentLevelItemId').reset();
            						valueSubject.items.get('markGradItemId').reset();
            					});
            				}
            			});
            		}
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] textfield[itemId=examConductedById]': {
            	blur: function(field) {
            		var examBoardOther = null;
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();
            		var form =window.getForm();
            		var examBoardVisable= form.findField('examBoard').isVisible();
            		if(!examBoardVisable){
            			var subjectMarkPanel = window.down('#subjectMarkPanel');
            			for(var i=subjectMarkPanel.items.length-1; i>0;i--){
            				subjectMarkPanel.remove(subjectMarkPanel.items.items[i]);
            			}
            			window.doLayout();
            			var subjectField =  form.findField("subject");
            			var store = subjectField.getStore();
            			if (window.items.items != null && window.items.items.length > 0) {
            				Ext.each(window.items.items, function(val) {
            					if(val.itemId =='subjectMarkPanel'){
            						Ext.each(val.items.items, function(valueSubject){
            							valueSubject.items.get('subject').reset();
            							valueSubject.items.get('marks').reset();
            							valueSubject.items.get('marks').isValid();
//            							valueSubject.items.get('marks').setDisabled(true);
            						});
            					}
            				});
            			}
            		}
            	}
            	
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] textfield[itemId=marks]': {
            	blur: function(textfield, eOpts) { 
       			 var num = textfield.getValue();
       			 if(!isNaN(num)&&!isEmpty(num)){	
	        			 var number=Math.round(num*100)/100;
	        			 textfield.setValue(number); 
       			 }
       		 }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] nestedJsonCombo[itemId=countryItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryRegionComboBox = form.down('#countryRegionItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		  
    		        countryRegionComboBox.setDisabled(false);
    		        countryRegionComboBox.reset();
    		        cityComboBox.setDisabled(true);
    		        cityComboBox.reset();
    		        var countryId = record[0].get("id");
    		        
    		        var countryRegionStore = countryRegionComboBox.getStore();
    		        countryRegionStore.getProxy().extraParams = {
    		            cid: countryId
    		        };
    		        countryRegionStore.load();
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		  
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] nestedJsonCombo[itemId=countryRegionItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryComboBox = form.down('#countryItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		var countryId = null;
    		  		  
    		        cityComboBox.setDisabled(false);
    		        cityComboBox.reset();
    		        var countryRegionId = record[0].get("id");
    		        
    		        var cityStore = cityComboBox.getStore();
    		        cityStore.getProxy().extraParams = {
    		        	id: countryRegionId
    		        };
    		        cityStore.load();
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		 
    		        if(countryComboBox.getValue() != undefined && !isNullOrEmpty(countryComboBox.getValue())) {
    		        	countryId = countryComboBox.getValue();
    		        }
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId,
    		  			countryRegionId:countryRegionId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] nestedJsonCombo[itemId=cityItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryComboBox = form.down('#countryItemId');
    				var countryRegionComboBox = form.down('#countryRegionItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		var countryId = null;
    		  		var countryRegionId = null;
    		  		  
    		        cityComboBox.setDisabled(false);
    		        var cityId = record[0].get("id");
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		  
    		        if(countryComboBox.getValue() != undefined && !isNullOrEmpty(countryComboBox.getValue())) {
    		        	countryId = countryComboBox.getValue();
    		        }
    		        if(countryRegionComboBox.getValue() != undefined && !isNullOrEmpty(countryRegionComboBox.getValue())) {
    		        	countryRegionId = countryRegionComboBox.getValue();
    		        }
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId,
    		  			countryRegionId:countryRegionId,
    		  			cityId:cityId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
        	/**
             *  Work Experience Details
             */
        	'workexperiencegrid[itemId=applicantWorkExperienceGrid]': {
                render: function(grid) {
                    this.loadGridStore('#applicantWorkExperienceGrid', SERVERURL.APPLICANT_WORK_EXPERIENCE_GRIDDATA);
                    this.doAccessControlValidation(grid, this.getAPPLICANT_WORK_EXPERIENCE_PERMISSIONS());
                    this.showContainerInViewMode(grid);                    
                }
            },
        	'workexperiencegrid[itemId=applicantWorkExperienceGrid] button[itemId=btnAdd]': {
        		click: function() {
                    this.showPersonCommonWindow('WORK_EXPERIENCE', 'applicantWorkExperienceForm');
                }
            },
            'workexperiencegrid[itemId=applicantWorkExperienceGrid] button[itemId=btnEdit]': {
                click: function(){
                	this.editWorkExperienceFormWindow('WORK_EXPERIENCE', 'applicantWorkExperienceForm', '#applicantWorkExperienceGrid');
                }
            },
            'workexperiencegrid[itemId=applicantWorkExperienceGrid] button[itemId=btnView]': {
            	click: function(){
                	this.viewWorkExperienceFormWindow('WORK_EXPERIENCE', 'applicantWorkExperienceForm', '#applicantWorkExperienceGrid');
                }
            },
            'workexperiencegrid[itemId=applicantWorkExperienceGrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deleteWorkExperienceRecord('#applicantWorkExperienceGrid', SERVERURL.APPLICANT_WORK_EXPERIENCE_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=applicantWorkExperienceForm] button[itemId=submitButtonId]': {
                click: function(){
                	this.saveWorkExperience('#applicantWorkExperienceGrid', SERVERURL.APPLICANT_WORK_EXPERIENCE_ADD, SERVERURL.APPLICANT_WORK_EXPERIENCE_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=applicantWorkExperienceForm] datefield[itemId=dateOfJoining]': {
            	select: function(field, The, eOpts ){
            		this.calculateExperience(field);
            	}
            },
              
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=applicantWorkExperienceForm] datefield[itemId=exitDate]': {
            	select: function(field, The, eOpts ){
            		this.calculateExperience(field);
            	}
            },  

            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=applicantWorkExperienceForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            
            'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=applicantChurchInfoForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=applicantChurchInfoForm] button[itemId=btnAddEmploymentHistory]': {
        		click: function(obj){
 				   this.addChurchEmploymentHistory(obj);
 			   }
        	},
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=applicantWorkExperienceForm] radiogroup[itemId=currentOrgGroupId]': {
            	change: function(cb, nv, ov){

            		var form = this.getPersonWorkExperienceForm()
            		var datOfExit = form.down('#exitDate');
            		datOfExit.reset(); 
            		if(nv.whetherCurrentOrg){
            			datOfExit.setDisabled(true);
            		} else {
            			datOfExit.setDisabled(false);
            		}
            	}
            },
            /**
             *  Medical History
             */
            'medicalgrid[itemId=applicantMedicalGrid]': {
                render: function(grid) {
                    this.loadGridStore('#applicantMedicalGrid', SERVERURL.APPLICANT_MEDICAL_HISTORY_GRIDDATA);
                    this.doAccessControlValidation(grid, this.getAPPLICANT_MEDICAL_PERMISSIONS());
                    this.showContainerInViewMode(grid);                    
                }
            },
            'medicalgrid[itemId=applicantMedicalGrid] button[itemId=btnAdd]': {
                click: function() {
                	var formWindow = this.showPersonCommonWindow('MEDICAL', 'applicantMedicalHistoryForm');
                    if( formWindow != null ){
            			var form = formWindow.down('#applicantMedicalHistoryForm');
                		var countryCodeFieldItemIDArray = ["#doctorTelephoneCountryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                    	var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#doctorTelephoneNoItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
                }
            },
            'medicalgrid[itemId=applicantMedicalGrid] button[itemId=btnEdit]': {
            	click: function(){
                	var form = this.editMedicalHistoryFormWindow('MEDICAL', 'applicantMedicalHistoryForm', '#applicantMedicalGrid');
                	if( form != null ){
                		var countryCodeFieldItemIDArray = ["#doctorTelephoneCountryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                    	var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#doctorTelephoneNoItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
                }
            },
            'medicalgrid[itemId=applicantMedicalGrid] button[itemId=btnView]': {
                click: function(){
                	this.viewMedicalHistoryFormWindow('MEDICAL', 'applicantMedicalHistoryForm', '#applicantMedicalGrid');
                }
            },
            'medicalgrid[itemId=applicantMedicalGrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deleteMedicalHistoryRecord('#applicantMedicalGrid', SERVERURL.APPLICANT_MEDICAL_HISTORY_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=applicantMedicalHistoryForm] button[itemId=submitButtonId]': {
                click: function(){
                	this.saveMedicalHistory('#applicantMedicalGrid', SERVERURL.APPLICANT_MEDICAL_HISTORY_ADD, SERVERURL.APPLICANT_MEDICAL_HISTORY_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=applicantMedicalHistoryForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=applicantMedicalHistoryForm] customcombobox[itemId=doctorTelephoneCountryCodeItemId]': {
                select: function(rowModel,record) {
                	var form = this.getPersonMedicalHistoryForm();
                	var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                	var mobileField = form.down("#doctorTelephoneNoItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=applicantMedicalHistoryForm] numberfield[itemId=doctorTelephoneNoItemId]': {
                change: function(record) {
                	var form = this.getPersonMedicalHistoryForm();
                	var mobileField = form.down("#doctorTelephoneNoItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            
            /**
             *  Vaccination Details
             */

             
              'vaccinationgridforapplicantfaculty[itemId=applicantVaccinationGrid] button[itemId=btnAdd]': {
              	click: function() {
                  var form =    this.showPersonCommonWindow('VACCINATION', 'applicantVaccinationForm');
                     var studentStatus = form.down('#studentStatusItemId');
                     studentStatus.setVisible(false)
                     studentStatus.setAllowBlank = true;
                      this.processVaccinationInfoDetailsWindow('btnAdd');
                  }
              },
              'vaccinationgridforapplicantfaculty[itemId=applicantVaccinationGrid] button[itemId=btnEdit]': {
                  click: function(){
                   this.editVaccinationInfoFormWindow('VACCINATION', 'applicantVaccinationForm', '#applicantVaccinationGrid');
                   var form =    this.showPersonCommonWindow('VACCINATION', 'applicantVaccinationForm');
                 var studentStatus =  form.down('#studentStatusItemId');
                          studentStatus.setVisible(false);
                          studentStatus.setAllowBlank = true;
                	  this.processVaccinationInfoDetailsWindow('btnEdit');
                  }
              },
              'vaccinationgridforapplicantfaculty[itemId=applicantVaccinationGrid] button[itemId=btnView]': {
                  click: function(){
                	  this.viewVaccinationInfoFormWindow('VACCINATION', 'applicantVaccinationForm', '#applicantVaccinationGrid');
                	  this.processVaccinationInfoDetailsWindow('btnView');
            		  var a = Ext.ComponentQuery.query("personcommonwindow");
            		  if( a != undefined & a.length > 0){
            			  a[0].down("#studentStatusItemId").setVisible(false);
            			  a[0].down("#cancelButtonId").setVisible(false);
            			  a[0].down("#submitButtonId").setVisible(false);
            			  a[0].down("#uploadVaccinationItemId").setVisible(false);
            		  }
            		  var b = this.getApplicantvaccinationinfodocumentgrid();
            		  if(b != undefined){
            			b.down("#btnDelete").setVisible(false); 
            		  }
                  }
              },
              'vaccinationgridforapplicantfaculty[itemId=applicantVaccinationGrid] button[itemId=btnDelete]': {
                  click: function(){
                	  this.deleteVaccinationInfoRecord('#applicantVaccinationGrid', SERVERURL.APPLICANT_VACCINATION_INFO_DELETE);
                  }
              },
              'vaccinationgridforapplicantfaculty[itemId=applicantVaccinationGrid]':{   
            	  render: function(grid) {
                      this.loadGridStore('#applicantVaccinationGrid', SERVERURL.APPLICANT_VACCINATION_INFO_GRIDDATA);
                      this.doAccessControlValidation(grid, this.getAPPLICANT_VACCINATION_PERMISSIONS());
                      this.showContainerInViewMode(grid);   
                  },
	   			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	//				   var documentId = record.data.document.id;
					   if(columnName == "documents"){
	         			   if(e.target.tagName=='A'){
	         				  if(record.data.documents.length == 1){
	   						   var csvForm = Ext.create('Ext.form.Panel'); 
	   						   csvForm.getForm().submit({
	   							   target: '_blank',
	   							   method:'GET',
	   							   params :{
	   								   access_token : Ext.Ajax.defaultHeaders.access_token
	   							   },
	   							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	   							   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + record.data.documents["0"].id,
	   							   standardSubmit :true
	   						   });
	         				  } else if(record.data.documents.length > 1){
	         					  var docWindow = this.getApplicantvaccinationinfodocumentlist();
	         					  var ID = record.data.id;
	         					  if (!docWindow) {
	         						  Ext.widget('applicantvaccinationinfodocumentlist');
	         						  docWindow = Ext.widget('applicantvaccinationinfodocumentlist',{
	         							  itemId:'disciplinaryReportDocument'
	         						  });
	         						  docWindow = this.getApplicantvaccinationinfodocumentlist();
	         					  }
	         					  docWindow.show();
	        					  docWindow.down('form').down('#vaccinationNameItemId').setValue(record.data.name);
	        					  docWindow.down('form').down('#vaccinationDateItemId').setValue(dateRender(record.data.vaccinationDate));
	         					  var grid = docWindow.down('#applicantvaccinationinfodocumentlistgridItemId');
	         					  grid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
	         					  var store = grid.getStore();
	         					  store.getProxy().extraParams = {
	         						  ID: record.data.id
	         					  };
	         					  var proxy = store.getProxy();
	         					  var newApi =  {read: SERVERURL.APPLICANT_VACCINATION_INFO_DOCUMENT_FIND_BY_ID};
	         					  Ext.apply(proxy.api,newApi);
	         					  store.getProxy().url=SERVERURL.APPLICANT_VACCINATION_INFO_DOCUMENT_FIND_BY_ID;
	         					  store.load();
	         				  }
	         			   }
					   }
				   }
			   },
			   'applicantvaccinationinfodocumentlistgrid':{
		 			 
					 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	  				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	  				 if(columnName == "documentName"){
	  					 if(e.target.tagName=='A'){
	  						 this.getDownloadFile(record.get('documentId'));
	  					 }
	  				 }
	  			 }
	  		 },
			'applicantvaccinationinfodocumentgrid button#btnDelete' : {
				click : function() {
					var $this = this;
					var grid = $this
					.getApplicantvaccinationinfodocumentgrid();
					if (grid.getSelectionModel()
							.getCount() > 0) {
						Ext.MessageBox
						.confirm(
								getCommonTranslation('VACCINATION_INFO'),
								getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								function(btn,
										text) {
									if (btn == 'yes') {
										var store = grid.getStore();
										var record = grid.getSelectionModel().getSelection()[0];
										var id = record.get("id");
										if (record) {
	                 							store.remove(record);
	                 						showSuccessMessage(
	                 							getCommonTranslation('VACCINATION_INFO'),
												   getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	                 					}
										
									}
								});
					} else {
						showWarningMessage(
								getCommonTranslation('VACCINATION_INFO'),
								getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
			},
	  		'applicantvaccinationinfodocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						this.documentReportDocumentZip('applicant');
					}
	    	 },
	    	 'applicantvaccinationinfodocumentlistgrid button[itemId=btnDelete]':{
					click:function(obj){
						this.deleteVaccinationDocument('applicant');
					}
	     	 },
	     	'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=applicantVaccinationForm] button[itemId=submitButtonId]': {
          	  click: function(){
          		  this.saveVaccinationInfo('#applicantVaccinationGrid', SERVERURL.APPLICANT_VACCINATION_INFO_ADD, SERVERURL.APPLICANT_VACCINATION_INFO_UPDATE, 'APPLICANT');
          	  }
            },
            'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=applicantVaccinationForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },  
            'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=applicantVaccinationForm] button[itemId=uploadVaccinationItemId]' : {
    			click: function() {
    				this
    				.getDocumentController()
    				.showDocumentFormWindow(
    						'applicant_vaccination_hidden_field',
    						'DOCUMENT');
    			}
        	   },
	     	'documentformwindow[itemId=applicant_vaccination_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
    			click : function() {
    				var $this = this;
    				var isTransient = true;
    				var module = 'vaccinationInfo';
    				var entityId;
    				var entityType = 'vaccinationInfoDocument';
    				console.log('Applicant document save button');
    				$this
    				.getDocumentController()
    				.saveDocumentForm(
    						entityId,
    						module,
    						entityType,
    						'DOCUMENT',
    						function(success,
    								response,
    								isCallBackTransient) {
    							var documentModel = new Academia.model.personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentModel();        							        							
    							documentModel
    							.set(
    									"documentName",
    									response.name);
    							documentModel
    							.set(
    									"path",
    									response.path);
    							documentModel
    							.set(
    									"type",
    									response.type);
    							documentModel
    							.set(
    									"documentName",
    									response.name);
    							documentModel
    							.set(
    									"createdBy",
    									$this
    									.getIdValueJson(
    											response.createdBy.id,
    											response.createdBy.value));
    							var vaccinationInfoDocGrid = $this.getApplicantvaccinationinfodocumentgrid();
    							var store = vaccinationInfoDocGrid
    							.getStore();
    							store
    							.add(documentModel);
    							if (vaccinationInfoDocGrid
    									.isHidden()
    									&& store.data.items.length > 0) {
    								vaccinationInfoDocGrid
    								.setVisible(true);
    							}
    							$this
    							.getDocumentController()
    							.closeDocumentFormWindow();
  							   showSuccessMessage(getCommonTranslation('VACCINATION_INFO'),getCommonTranslation('VACCINATION_INFO_DOCUMENT_ADD_SUCCESSFULLY'));
      					
    						}, isTransient);
    			}
    		},
    		'documentformwindow[itemId=applicant_vaccination_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
    			click : function() {
    				this.getDocumentController()
    				.closeDocumentFormWindow();
    			}
    		},
              
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=applicantVaccinationForm] button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              },
              
              
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=applicantVaccinationForm]':{
            	  afterrender:function(form){
            		 var studentStatus = form.down('#studentStatusItemId');
                      studentStatus.setVisible(false);
                      studentStatus.allowBlank = true;
                      form.getForm().checkValidity();
            	  }
              },
              /**
               *  Extra Curricular Details
               */

              'extracurriculargrid[itemId=applicantExtraCurricularGrid]': {
                  render: function(grid) {
                      this.loadGridStore('#applicantExtraCurricularGrid', SERVERURL.APPLICANT_EXTRA_CURRICULAR_GRIDDATA);
                      this.doAccessControlValidation(grid, this.getAPPLICANT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                      this.showContainerInViewMode(grid);                      
                  }
              },
              'extracurriculargrid[itemId=applicantExtraCurricularGrid] button[itemId=btnAdd]': {
            	  click: function() {
                      this.showPersonCommonWindow('EXTRA_CURRICULAR', 'applicantExtraCurricularForm');
                      this.extraCurricularActivityFormRender();
                  }
              },
              'extracurriculargrid[itemId=applicantExtraCurricularGrid] button[itemId=btnEdit]': {
                  click: function(){
                	  this.editExtraCurricularFormWindow('EXTRA_CURRICULAR', 'applicantExtraCurricularForm', '#applicantExtraCurricularGrid');
                  }
              },
              'extracurriculargrid[itemId=applicantExtraCurricularGrid] button[itemId=btnView]': {
                  click: function(){
                	  this.viewExtraCurricularFormWindow('EXTRA_CURRICULAR', 'applicantExtraCurricularForm', '#applicantExtraCurricularGrid');
                  }
              },
              'extracurriculargrid[itemId=applicantExtraCurricularGrid] button[itemId=btnDelete]': {
                  click: function(){
                	  this.deleteExtraCurricularRecord('#applicantExtraCurricularGrid', SERVERURL.APPLICANT_EXTRA_CURRICULAR_DELETE);
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=applicantExtraCurricularForm] button[itemId=submitButtonId]': {
                  click: function(obj){
                	  var this$ = this;
                	  obj.setDisabled(true);
                	  this$.applyWindowMask(); 
                	  this.saveExtraCurricular('#applicantExtraCurricularGrid', SERVERURL.APPLICANT_EXTRA_CURRICULAR_ADD, SERVERURL.APPLICANT_EXTRA_CURRICULAR_UPDATE);
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=applicantExtraCurricularForm] customcombobox[itemId=eventId]': {
            	  select: function(obj){                	
	                	var form = this.getPersonExtraCurricularForm(); 
	                	var eventId=form.down("#eventId");
	        			var otherEventId=form.down("#otherEventId");
	            		if(obj.getRawValue()==='OTHEREVENT'){              			
	            			otherEventId.setVisible(true);
	            			otherEventId.setDisabled(false);
	            		}else{
	            			form.down("#otherEventId").reset();
	            			otherEventId.setVisible(false);
	            			otherEventId.setDisabled(true);
	            		}  
	            		form.isValid();
	                }
              },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=applicantExtraCurricularForm] button[itemId=cancelButtonId]': {
            	  click: this.closePersonCommonWindow
              },
              /**
               *  Competitive Exam Details
               */

              'competitiveexamgrid[itemId=applicantCompetitiveExamGrid]': {
            	  render: function(grid) {
            		  this.loadGridStore('#applicantCompetitiveExamGrid', SERVERURL.APPLICANT_COMPETITIVE_EXAM_DETAIL_GRID);
            		  this.doAccessControlValidation(grid, this.getAPPLICANT_COMPETITIVE_EXAM_PERMISSIONS());
            		  this.showContainerInViewMode(grid);
            	  },
            	  cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	 		        if (e.target.tagName == 'A') {
    	 		            var filePath = record.get("filePath");
    	 		            if (!isNullOrEmpty(filePath)) {
    	 		                this.downloadCompetitiveGridFile(filePath);
    	 		            }
    	 		        }
    	 		    }
              }, 
              'competitiveexamgrid[itemId=applicantCompetitiveExamGrid] button[itemId=btnAdd]': {
            	  click: function() {
                      this.showPersonCommonWindow('COMPETITIVE_EXAM', 'applicantCompetitiveExamForm');
                  }
              },
              'competitiveexamgrid[itemId=applicantCompetitiveExamGrid] button[itemId=btnEdit]': {
                  click: function(){
                	  this.editCompetitiveExamFormWindow('COMPETITIVE_EXAM', 'applicantCompetitiveExamForm', '#applicantCompetitiveExamGrid');
                  }
              },
              'competitiveexamgrid[itemId=applicantCompetitiveExamGrid] button[itemId=btnView]': {
                  click: function(){
                	  this.viewCompetitiveExamFormWindow('COMPETITIVE_EXAM', 'applicantCompetitiveExamForm', '#applicantCompetitiveExamGrid');
                  }
              },
              'competitiveexamgrid[itemId=applicantCompetitiveExamGrid] button[itemId=btnDelete]': {
                  click: function(){
                	  this.deleteCompetitiveExamRecord('#applicantCompetitiveExamGrid', SERVERURL.APPLICANT_COMPETITIVE_DELETE);
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=applicantCompetitiveExamForm] button[itemId=submitButtonId]': {
                  click: function(){
                	  this.saveCompetitiveExam('#applicantCompetitiveExamGrid', SERVERURL.APPLICANT_COMPETITIVE_CREATE, SERVERURL.APPLICANT_COMPETITIVE_UPDATE, 'applicant');
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=applicantCompetitiveExamForm] button[itemId=cancelButtonId]': {
            	  click: this.closePersonCommonWindow
              },
              'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=applicantCompetitiveExamForm] button[itemId=removeButtonId]': {
              	click: this.removeCompetitiveExamDocument
              },

             
              /**
               *  Medical Details
               */
              'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId]': {
                  render: function(form) {
                      var url = SERVERURL.MD_APPLICANT_MEDICAL_DETAIL_FIND_BY_PERSON_ID + '?personId=';
                      this.onRenderMedicalDetailsForm(url);
                      this.disableMedicalDetailFormPivileges(form, this.getAPPLICANT_MEDICAL_DETAIL_PERMISSIONS());
                  },
                  afterrender:function(form){
            		  this.loadDFRForNumberFieldValidation(form);
            	  }
              },
              'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId] button[itemId=submitButtonId]': {
                  click: function() {
                      var getUrl = SERVERURL.MD_APPLICANT_MEDICAL_DETAIL_FIND_BY_PERSON_ID + '?personId=';
                      this.saveMedicalDetails(SERVERURL.MD_APPLICANT_MEDICAL_DETAIL_UPDATE, getUrl);
                  }
              },
              'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId] filefield[itemId=medicalAidDocumentItemId]': {
                  change: function(fileField, value, eOpts) {
                	  var $this = this;
                      value = value.replace('C:\\fakepath\\', '');
                      var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                      fileField.setRawValue(newValue);
                      var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                      var specialCharsExist=false;
                           for(i = 0; i < specialChars.length;i++){
                             if(newValue.indexOf(specialChars[i]) > -1){
                                 specialCharsExist= true;
                              }
                           }
                          if(specialCharsExist){
                        	  fileField.reset();
                              showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                          }
                          
                      if (!isNullOrEmpty(newValue)) {
                          var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                          if ($this.isValidFileExtension(extension)) {
                              var file = fileField.fileInputEl.dom.files[0];
                              if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                  fileField.reset();
                                  showWarningMessage(getPersonModuleTranslation('MD_MEDICAL_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MESSAGE')+" "+CONSTANTS.UPLOAD_FILE_SIZE_LIMIT
                  	            		+" "+getPersonModuleTranslation('MB'));
                              }
                          } else {
                              fileField.reset();
                              showWarningMessage(getPersonModuleTranslation('MD_MEDICAL_DETAILS'), getPersonModuleTranslation('MD_MEDICAL_AID_DOCUMENT_UPLOAD_VALID_FILE'));
                          }
                      } 
                  }
              },
              'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId] displayfield[itemId=availableDocumentLabelItemId]': {
            	  render: function(component) {
            		  var $this = this;
            		  component.getEl().on('click', function(e) {
            			  if (e.target.tagName == 'B') {
            				  var personalInformationForm = $this.getPersonMedicalDetailsForm();
            				  if (personalInformationForm) {
            					  var documentId = personalInformationForm.down('#documentIdItemId').getValue();
            					  if (!isNullOrEmpty(documentId)) {
            						  $this.getDocumentController().downloadDocumentFile(documentId);
            					  }
            				  }
            			  }
            		  });
            	  }
              },
              'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId] customcombobox[itemId=familyPractionerCountryCodeItemId]': {
            	  select:function(rowModel,record) {
	            	  var personProfile = this.getContentPanelActiveTab();
	                  var medicalDetailsForm = personProfile.down('medicaldetailsform');
	                  if (medicalDetailsForm) {
	                	  var countryCodeField = medicalDetailsForm.down("#familyPractionerCountryCodeItemId");
	                	  var mobileField = medicalDetailsForm.down("#familyPractionerContactNumberItemId");
						  this.setMaximumMinimumDigitsForMobileNoValidation(medicalDetailsForm,countryCodeField,mobileField,record);
	                  }
            	  }
              },
              'medicaldetailsform[itemId=applicantMedicalDetailsFormItemId] numberfield[itemId=familyPractionerContactNumberItemId]': {
            	  change:function(record) {
	            	  var personProfile = this.getContentPanelActiveTab();
	                  var medicalDetailsForm = personProfile.down('medicaldetailsform');
	                  if (medicalDetailsForm) {
	                	  var mobileField = medicalDetailsForm.down("#familyPractionerContactNumberItemId");
	                	  mobileField.isValid();
	                	  medicalDetailsForm.getForm().checkValidity();
	                  }
            	  }
              },

              
              /**
               *  Non Academic Achievements
               */
              'nonacademicachievementsgrid[itemId=applicantnonacademicachievementsgridItemId]': {
          		render: function(grid) {
          			this.loadNonAcademicAchievementsGridStore('#applicantnonacademicachievementsgridItemId', SERVERURL.APPLICANT_NON_ACADEMIC_ACHIEVEMENTS_GRID);
          			//portalId = this.getCurrentLoggedPortalId();
          				this.doAccessControlValidation(grid, this.getAPPLICANT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
          				this.showContainerInViewMode(grid); 
          		}
              },
              
              'nonacademicachievementsgrid[itemId=applicantnonacademicachievementsgridItemId] button[itemId=btnAdd]': {
            	  click: function() {
                      this.showPersonCommonWindow('NON_ACADEMIC_ACHIEVEMENTS','applicantnonacademicachievementsform');
                  }
              },
              'nonacademicachievementsgrid[itemId=applicantnonacademicachievementsgridItemId] button[itemId=btnEdit]': {
                  click: function(){
            		  this.editNonAcademicAchievementsInfoForm('NON_ACADEMIC_ACHIEVEMENTS','applicantnonacademicachievementsform', '#applicantnonacademicachievementsgridItemId');
                  }
              },
              'nonacademicachievementsgrid[itemId=applicantnonacademicachievementsgridItemId] button[itemId=btnView]': {
                  click: function(){
 	          		  this.viewNonAcademicAchievementsInfoForm('NON_ACADEMIC_ACHIEVEMENTS', 'applicantnonacademicachievementsform', '#applicantnonacademicachievementsgridItemId');
 	          		  var form = this.getNonacademicachievementsform();
 	          		  form.isValid();
                  }
              },
              'nonacademicachievementsgrid[itemId=applicantnonacademicachievementsgridItemId] button[itemId=btnDelete]': {
                  click: function(){
                   	this.deleteNonAcademicAchievementsInfoRecord('#applicantnonacademicachievementsgridItemId', SERVERURL.PATH_NON_ACADEMIC_ACHIEVEMENTS_DELETE);
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] form[itemId=applicantnonacademicachievementsform]':{
    	    	   render: function() {
    	            		var this$ = this;
    	            		var form = this$.getNonacademicachievementsform();
    	                	var sportEventStore = form.down('#sportEvent').getStore();
    	                	sportEventStore.getProxy().extraParams={
    	            			type:'SportEvent'
    	            		};
    	                	sportEventStore.load();

    	            		var levelEventStore = form.down('#levelEvent').getStore();
    	            		levelEventStore.getProxy().extraParams={
    	            			type:'LevelEvent'
    	            		};
    	            		levelEventStore.load();
    	            	}
    	    	 },
    	    	 
              'personcommonwindow[itemId=personCommonWindow] nonacademicachievementsform[itemId=applicantnonacademicachievementsform] button[itemId=submitButtonId]': {
                  click: function(){
                  	this.saveNonAcademicAchievementsForm('#applicantnonacademicachievementsgridItemId', SERVERURL.NON_ACADEMIC_ACHIEVEMENTS_SAVE, SERVERURL.NON_ACADEMIC_ACHIEVEMENTS_UPDATE);
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] nonacademicachievementsform[itemId=applicantnonacademicachievementsform] button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              
              },
              
              
              /**
               *  Church information Details
               */
          	'churchinformationgrid[itemId=applicantChurchInformationGrid]': {
                  render: function(grid) {
                     this.loadChurchInfoGridStore('#applicantChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_GRIDDATA);
                      this.doAccessControlValidation(grid, this.getAPPLICANT_CHURCH_INFORMATION_PERMISSIONS());
                      this.showContainerInViewMode(grid); 
                  },
                  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
      				   if (e.target.tagName == 'A') {
      					this.viewEmploymentHistory(grid,record);
      				   }
      			   }
              },
          	'churchinformationgrid[itemId=applicantChurchInformationGrid] button[itemId=btnAdd]': {
          		click: function() {
                      this.showPersonCommonWindow('CHURCH_INFORMATION', 'applicantChurchInfoForm');
                  }
              },
              'churchinformationgrid[itemId=applicantChurchInformationGrid] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editChurchInfoFormWindow('CHURCH_INFORMATION', 'applicantChurchInfoForm', '#applicantChurchInformationGrid');
            	  }
              },
              'churchinformationgrid[itemId=applicantChurchInformationGrid] button[itemId=btnView]': {
            	  click: function(){
            		  this.viewChurchInfoFormWindow('CHURCH_INFORMATION', 'applicantChurchInfoForm', '#applicantChurchInformationGrid');
            	  }
              },
              'churchinformationgrid[itemId=applicantChurchInformationGrid] button[itemId=btnDelete]': {
                  click: function(){
                  	this.deleteChurchInfoRecord('#applicantChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_DELETE);
                  }
              },
              'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=applicantChurchInfoForm] button[itemId=submitButtonId]': {
                  click: function(){
                  	this.saveChurchInfo('#applicantChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_ADD, SERVERURL.CHURCH_INFORMATION_UPDATE);
                  }
              },
              /**
               *  Applicant Details form
               */
              'applicantdetailsform[itemId=applicantDetailsFormItemId]': {
            	  render: function(form) {
            		  this.onRenderApplicantDetailsForm(form);
            		  if(portalId == 6){
            			  var alId = localStorage.getItem('academylocationid');
            			  var ALId = {};
            			  ALId.academyLocationId = alId;
            			  Academia.app.getController("Academia.controller.authentication.AuthenticationController").getDynamicForFormFieldsInfo(ALId);
            		  }
            	  },
            	  afterrender: function(form) {
            		  form.down("#enquiryIdItemId").allowBlank=true;
            		  form.down("#emailId").allowBlank=true;
            		  form.down("#studentIdItemId").allowBlank=true;
            		  var nationality=form.down('#nationalityCombo').getStore();
            	  }
              },
              'applicantdetailsform[itemId=applicantDetailsFormItemId] photouploadform[itemId=applicantPhotoUploadForm] filefield[itemId=photoFileImage]': {
                  change: function(photoFileImage, value, eOpts) {
                  	value = value.replace('C:\\fakepath\\', '');
                  	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                  	photoFileImage.setRawValue(newValue);
                  }
              },
              'applicantdetailsform[itemId=applicantDetailsFormItemId] radiogroup[itemId=applicantTypeId]':{
                  change:function(obj, newValue, oldValue){
                	  this.changeApplicantType(obj,newValue,oldValue);
                  }
              },
              'applicantdetailsform[itemId=applicantDetailsFormItemId] radiogroup[itemId=isUniversityItemId1]':{
                  change:function(obj, newValue, oldValue){
                	  this.isUniversityStudent(obj,newValue,oldValue);
                  }
              },
              'applicantdetailsform[itemId=applicantDetailsFormItemId] button[itemId=submitButtonId]':{
                  click:function(obj){
                	  this.saveApplicantInfo(obj);
                  }
              },
              'applicantdetailsform[itemId=applicantDetailsFormItemId] nestedJsonCombo[itemId=nationalityCombo]':{
                  select:function(obj,record){
                	  this.showHidePassportNationalIdField(obj,record);
                  }
              },
              'applicantdetailsform[itemId=applicantDetailsFormItemId] button[itemId=FetchEnquiryDetailId]':{
                  click:function(obj){
                	  this.fetchEnquiryDetails(obj);
                  }
              },
              /**
               * Declaration & Payment  
               */
              'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId]': {
            	  render : function(obj) {
            		  var $this = this;
            		  var applicantProfile = $this.getContentPanelActiveTab();
            		  try {
            			  applicantProfile.getApplicationId();
            		  } catch(e){
            			  applicantProfile = $this.getContentPanel().items.items[0];
            		  }
            		  var form = $this.getPersonApplicantDeclarationAndPaymentForm();
            		  var applicationFeesPayableField = form.down('#applicationFeesPayable');
            		  Ext.Ajax.request({
				            type: 'rest',
				            url: SERVERURL.PATH_FIND_APPLICANT_AMOUNT+ '?applicationId='+ applicantProfile.getApplicationId(),
				            async:true,
				            method: 'GET',
				            headers: {
				                'Content-Type': 'application/json'
				            },
				            success: function(response) {
				            	if(!isNullOrEmpty(response.responseText)){
				            		applicationFeesPayableField.setValue(response.responseText);
				//            		applicationFeesPayableField.addCls('applicationFeesPayableCls');
				            	}else
				            	{
				 //           		applicationFeesPayableField.addCls('applicationFeesPayableCls');
				            		applicationFeesPayableField.setValue(0);
				            	}
				            }
     				   });
            	  },
            	  beforerender:function(form){
            		  this.disableDeclareAndPaymentFormField(form);
            	  },
            	  afterrender: function(form) {
            		  form.down("#uploadFileField").allowBlank=true;
            		  if(Ext.app.DisabledDeclarationAndPaymentScreen){
            			  form.items.each(function(itm){itm.setDisabled(true)});
            		  }
            		  form.down("#printBtn").setDisabled(false);
            		  var portalId = this.getCurrentLoggedPortalId();
              		  if(portalId==6){
              			  this.doPaymentModeValidation(form, this.getPAYMENT_MODE_APPLICANT_PROFILE_PRIVILEGES());
              		  }
            	  }
              },
              'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId] button[itemId=submitApplicationButtonId]':{
                  click:function(obj){
                	  this.submitApplicationFromPortal(obj);
                  }
              },
              'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId] button[itemId=printBtn]': {
                  click: function() {
                      /*var window = this.getApproveApplicantAdmissionWindow();
                      if (!window) {
                          window = Ext.widget('approverejectwithdrawadmissionwindow', {
                              itemId: 'approveApplicantAdmissionWindow',
                              admissionType: this.APPROVE
                          });
                      }
                      window.show();*/
                  	this.printButtonAction();
                  }
              },
              'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId] checkbox[itemId=checkBoxAgree]':{
                  change:function(obj, newValue, oldValue){
                	  this.enableDisableSubmitBtn(obj, newValue, oldValue);
                  }
              },
              'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId] radiogroup[itemId=payTypeId]':{
                  change:function(obj, newValue, oldValue){
                	  this.changePaymentMode(obj,newValue,oldValue);
                  }
              },
              'declarationandpaymentform[itemId=applicantDeclarationAndPaymentFormItemId] filefield[itemId=uploadFileField]':{
                  change:function(obj, value, eOpts){
                	  var $this = this;
       			   	  value = value.replace('C:\\fakepath\\', '');
       			   	  var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	  this.validatedUploadedFile(obj, newValue, eOpts);
                	  obj.up('form').down('#checkBoxAgree').reset();
                   }
              },
              'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] customcombobox[itemId=recipientName]' : {
 	 			 render : function(combo) { 
 	 				 var $this = this;
 	 				var applicantProfile = $this.getContentPanelActiveTab();
 	 				try {
 	 					var appId = applicantProfile.getApplicationId();
 	 				} catch(e){
 	 					applicantProfile = $this.getContentPanel().items.items[0];
 	 					var appId = applicantProfile.getApplicationId();
 	 				}
 	 				var personId=null;
 	 				
 	 			  var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
		            if(!isNullOrEmpty(url)){
		            	url = url.concat("?id=" + appId);
		                Ext.Ajax.request({
		                    type: 'rest',
		                    url: url,
		                    async: false,
		                    method: 'GET',
		                    success: function(res, action) {
		                    	var data = Ext.decode(res.responseText);
		                    	if(!isEmpty(data)){
		                    		personId = data.personId;
		                    	}
		                    	
		                    }
		                });
		            }
		            
 	 				combo.getStore().getProxy().api.read = SERVERURL.PATH_FIND_RECIEPT_NAMES_FOR_APPLICANT;
 	 				combo.getStore().getProxy().extraParams = {
 	 					  applicantPersonId: personId
					};
 	 				combo.getStore().sorters.clear();
 	 				combo.getStore().load();
 	 				
 	 				var structure = combo.up('communicationhistorystructure');
 	 				
 	 				setTimeout(function(){
 	 				
	 	 				var contactId = structure.down('customcombobox#contactId');
	 	 				contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_APPLICANT_PERSON_CONTACT_DETAIL_BY_APPLICANT_PERSON_ID;
						contactId.getStore().getProxy().extraParams = {
							  	  applicantPersonId: personId,
								  isEmail:true,
						};
						contactId.getStore().load();
						
						var mobileId = structure.down('customcombobox#mobileId');
						mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_APPLICANT_PERSON_CONTACT_DETAIL_BY_APPLICANT_PERSON_ID;
						mobileId.getStore().getProxy().extraParams = {
							  	  applicantPersonId: personId,
								  isEmail:false,
							  };
						mobileId.getStore().load();
					
 	 				},500);
 	 				
 	 			 },
 	 			 select:function(recipientName,record){
 	 				 
 					var selectedObj = recipientName.getValue();
 					var structure = recipientName.up('communicationhistorystructure');
					var contactId = structure.down('customcombobox#contactId');
					
					var parentPersonId;
					var feePayerId;
					var applicantPersonId;
					
					if( record[0].raw.code == "APPLICANT" ){
						applicantPersonId = record[0].raw.id;
					}
					if( record[0].raw.code == "PARENT" ){
						parentPersonId = record[0].raw.id;
					}
					if( record[0].raw.code == "FEE_PAYER" ){
						feePayerId = record[0].raw.id;
					}
					
					//var personId = applicantprofile.personInfo.id;
					contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_APPLICANT_PERSON_CONTACT_DETAIL_BY_APPLICANT_PERSON_ID;
					contactId.getStore().getProxy().extraParams = {
						  applicantPersonId: applicantPersonId,
						  parentPersonId: parentPersonId,
						  feePayerId: feePayerId,
						  isEmail:true,
						  receipentType: record[0].raw.code
					};
					contactId.getStore().load({
						callback : function(records,operation,success) {
							
							 var contactIdComboStore=structure.down("#contactId").getStore();
							 var storeValue = contactIdComboStore.data.items;
							 contactIdValue = storeValue[0].data.emailId;
							 for(var recordInt=1;recordInt<storeValue.length;recordInt++){
								 contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
							 }
							
							//contactId.setValue(emailId);
							var mobileId = structure.down('customcombobox#mobileId');
							mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_APPLICANT_PERSON_CONTACT_DETAIL_BY_APPLICANT_PERSON_ID;
							mobileId.getStore().getProxy().extraParams = {
								  applicantPersonId: applicantPersonId,
								  parentPersonId: parentPersonId,
								  feePayerId: feePayerId,
	 							  isEmail:false,
	 							  receipentType: record[0].raw.code
	 						  };
							mobileId.getStore().load();
						}
					});
 	 			 }
 	 		  },
	 		  'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId]' : {
					render : function(structure) {
						var form = this.getCommunicationhistorystructure();            		
	            		var searchBtn = form.down("#searchButtonId");
	            		searchBtn.setDisabled(true);
					}
				},
				 'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] button[itemId=resetButtonId]': {
		                click: function(){                	
		                	var form = this.getCommunicationhistorystructure();            		
		            		var sendMessage = form.down("#sendmessageId").reset();
		            		var recipient=form.down("#recipientName").reset();
		            		var contactId=form.down("#contactId");
		            		contactId.reset();
		            		
		            		var sentbyName=form.down("#sentby").reset();
		            		var eventNameCode=form.down("#eventName").reset();
		            		var eventDateForm=form.down("#eventDateForm").reset();
		            		var eventDateTill=form.down("#eventDateTill").reset();
		            		var mobileId = form.down("#mobileId").reset();
		            		
		            		var applicantprofile = this.getApplicantprofile();
		 	 				var personId = applicantprofile.personInfo.id;
		            		
		            		var contactId = form.down('customcombobox#contactId');
		 	 				contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_APPLICANT_PERSON_CONTACT_DETAIL_BY_APPLICANT_PERSON_ID;
							contactId.getStore().getProxy().extraParams = {
								  	  applicantPersonId: personId,
									  isEmail:true,
							};
							contactId.getStore().load();
							
							var mobileId = form.down('customcombobox#mobileId');
							mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_APPLICANT_PERSON_CONTACT_DETAIL_BY_APPLICANT_PERSON_ID;
							mobileId.getStore().getProxy().extraParams = {
								  applicantPersonId: personId,
									  isEmail:false,
								  };
							mobileId.getStore().load();
		                }
		            },
				'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] radiogroup[itemId=sendmessageId]': {
	            	change: function(obj,value){                	
	                	var form = this.getCommunicationhistorystructure();                	
	                	var contactField=form.down("#contactId");
	        			var mobileField=form.down("#mobileId");
	            		if(value.sendMessage===2){              			
	                		//var recipient=form.down("#recipientName").reset();
	                		//var contactId=form.down("#contactId").reset();
	                		var sentbyName=form.down("#sentby").reset();
	                		var eventNameCode=form.down("#eventName").reset();
	                		var eventDateForm=form.down("#eventDateForm").reset();
	                		var eventDateTill=form.down("#eventDateTill").reset();
	                		//var mobileNO=form.down("#mobileId").reset();
	            			contactField.setVisible(false);
	            			mobileField.setVisible(true);   
		            	
	            		}else{
	                	//	var recipient=form.down("#recipientName").reset();
	                	//	var contactId=form.down("#contactId").reset();
	                		var sentbyName=form.down("#sentby").reset();
	                		var eventNameCode=form.down("#eventName").reset();
	                		var eventDateForm=form.down("#eventDateForm").reset();
	                		var eventDateTill=form.down("#eventDateTill").reset();
	            			contactField.setVisible(true);
	            			mobileField.setVisible(false);            			
	            		}                	
	                }
	            },
	            'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] button[itemId=searchButtonId]':{
	            	click : function(obj){
	            		var personProfile = this.getContentPanelActiveTab();
	            		var form = personProfile.down('communicationhistorystructure');
	            		var grid = personProfile.down('communicationhistorylist');
	            		if(isNullOrEmpty(form)) {
	            			form = personProfile.down('form');
	            		}
	            		
	            		var sendMessage = form.down("#sendmessageId").getValue();
	            		//console.log(sendMessage);
	            		var recipient=form.down("#recipientName").getValue();
	            		
	            		if( !isNullOrEmpty(recipient) && recipient != undefined ){
	            			
	            			var n = recipient.search("/");
		            	    if( n != -1 ){
		            	        var res = recipient.split("/");
		            	        if( !isNullOrEmpty(res) && res.length > 0 ){
		            	        	recipient = res[res.length-1];
		            	        	/*if( recipient.search(" ") != -1 ){
		            	        		var res2 = recipient.split(" ");
		            	        		if( !isNullOrEmpty(res2) && res2.length > 0 ){
		            	        			recipient = res2[0];
		            	        		}
		            	        	}*/
		            	        }
		            	    } else {
		            	    	/*if( recipient.search(" ") != -1 ){
	            	        		var res3 = recipient.split(" ");
	            	        		if( !isNullOrEmpty(res3) && res3.length > 0 ){
	            	        			recipient = res3[0];
	            	        		}
	            	        	}*/
		            	    }
	            		} else {
	            			//recipient = "rohit test 1 lname,Fatherrrr lnameeee,Motherrrr lnameeee";
	            			var recipientComboStore=form.down("#recipientName").getStore();
            				var recipientStoreValue = recipientComboStore.data.items;
            				var recipientValue = recipientStoreValue[0].data.value;
            				
            				var n = recipientValue.search("/");
		            	    if( n != -1 ){
		            	        var res = recipientValue.split("/");
		            	        if( !isNullOrEmpty(res) && res.length > 0 ){
		            	        	recipientValue = res[res.length-1];
		            	        	/*if( recipient.search(" ") != -1 ){
		            	        		var res2 = recipient.split(" ");
		            	        		if( !isNullOrEmpty(res2) && res2.length > 0 ){
		            	        			recipient = res2[0];
		            	        		}
		            	        	}*/
		            	        }
		            	    } else {
		            	    	/*if( recipient.search(" ") != -1 ){
	            	        		var res3 = recipient.split(" ");
	            	        		if( !isNullOrEmpty(res3) && res3.length > 0 ){
	            	        			recipient = res3[0];
	            	        		}
	            	        	}*/
		            	    }
            				
                    		for(var recordInt = 1; recordInt < recipientStoreValue.length; recordInt++){
                    			recipientValue=recipientValue+","+recipientStoreValue[recordInt].data.value;
                    		}
                    		recipient=recipientValue;
	            		}
	            		
	            		var contactId=null;
	            		var contactIdAlternateValue=null;
	            		var sentbyName=form.down("#sentby").getValue();
	            		var eventNameCode=form.down("#eventName").getValue();
	            		var formValues=form.getForm().getValues();
	            		//var eventDateForm=form.down("#eventDateForm").getValue();
	            		//var eventDateTill=form.down("#eventDateTill").getValue();
	            		var messageId=form.down("#sendmessageId").getValue();
	            		if(messageId.sendMessage==1){
	            			contactId=form.down("#contactId").getValue();
	            			if(contactId==null){
	            				var contactIdComboStore=form.down("#contactId").getStore();
	            				var storeValue = contactIdComboStore.data.items;
	            				contactIdValue = storeValue[0].data.emailId;
	            				contactIdAlternateValue = storeValue[0].data.alternateEmailId;
	            				
	                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
	                    			contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
	                    			contactIdAlternateValue=contactIdAlternateValue+","+storeValue[recordInt].data.alternateEmailId;
	                    		}
	                    		contactId=contactIdValue+","+contactIdAlternateValue;
	                    		}
	            		}else{
	            			contactId=form.down("#mobileId").getValue();
	            			if(contactId==null){
	            				var contactIdComboStore=form.down("#mobileId").getStore();
	            				var storeValue = contactIdComboStore.data.items;
	            				contactIdValue = storeValue[0].data.mobileNumber;
	                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
	                    			contactIdValue=contactIdValue+","+storeValue[recordInt].data.mobileNumber;
	                    		}
	                    		contactId=contactIdValue;
	                    		}
	            		}
	            		//var formValues=form.getForm().getValues(); 
	            		//var store =Ext.create('Academia.store.messaging.CommunicationHistoryReportList');
	            		var store = grid.getStore();
	            		store.getProxy().extraParams = {
	            			deliveryModeId: sendMessage.sendMessage,
	            			recipientName: recipient,
	            			contact:contactId,
	            			sentBy:sentbyName,
	            			eventName:eventNameCode,
	            			fromDate:formValues.eventDateForm,
	            			toDate:formValues.eventDateTill
	            		}
	            		var exportReport=grid.down("#exportMessageSentReportItemId");
	            		store.load({
	            			callback: function(records, options, success) {
	            		        if(records.length>0){
	            		        	exportReport.setDisabled(false);
	            				}else{
	            					exportReport.setDisabled(true);
	            				} 
	            				}
	            		    });
	            	}
	            },
	            'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] communicationhistorylist':{
	            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	            		var messageTemplate = record.get('msgContent');
	            		var $this =this;
	            		if (e.target.tagName == 'A') {
	            		var dataIndex = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

            			if(dataIndex == "attachedDocument"){
            				$this.openAttachedDocumentLink(record);
            			}
            			else{
            				$this.openSendMessageReportLink(record);	
            			}
	            		}
	            	},
	            	render: function(grid){
        				var $this = this;
        				var itemIdPrivilegeNameArray = [{"#exportMessageSentReportItemId" : "EXPORT_REPORTS"}];
        				this.disableRadioGroupAndOtherPivileges(grid, this.getAPPLICANT_COMMUNICATION_HISTORY_PERMISSIONS(),itemIdPrivilegeNameArray);
        				var exportReport=grid.down("#exportMessageSentReportItemId");
        				exportReport.setDisabled(true);
        			}
	            },
	        	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=yearItemId]':{
	        		render : this.loadYearData
	        	},
	        	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] datefield[itemId=yearOfExam]':{
	        		 render: function(obj) {
	        			 this.setYearOfEaxmDateMinvalue(obj);
	        		 },
	        		select: function(obj,value){       
	        		 this.changeAndSetYearMonthData(obj,value);
	        		}
	        	},
	        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=applicantCompetitiveExamForm] combo[itemId=yearItemId]':{
	        		render : this.loadYearDataOfComExam
	        	},
	        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=applicantCompetitiveExamForm] datefield[itemId=yearOfExam]':{
	        		render: function(obj) {
	        			 this.setYearOfEaxmDateMinvalue(obj);
	        		 },
	        		 select: function(obj,value){       
	        		 this.changeAndSetYearMonthDataOfComExam(obj,value);
	        		}
	        	},
	        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=applicantCompetitiveExamForm] nestedJsonCombo[itemId=officerFormativeQualified]':{
	        		render: function(obj) {
	        			var store = obj.getStore();
	        			store.getProxy().extraParams={
	        				type:'Officer Formative Qualified'
	        			};
	        			store.load();
	        		},
	        		select: function(obj, record) {
	        			var $this = this;
	        	    	var getComExamForm = $this.getPersonCompetitiveExamForm();
	        	    	var newValue = record[0].data.value;
	        	    	var completionDate = getComExamForm.down('#completionDate');
	        	    	if(newValue=='Yes' || newValue=='In Progress') {
	        	    		var status = $this.checkCompletionDateDfrSetting(getComExamForm);
	        	    		if(status==false) {
	        	    			completionDate.setVisible(true);
	        	    		}
	        	    	}
	        	    	else {
	        	    		completionDate.setVisible(false);
	        	    		completionDate.allowBlank=true;
	        	    		completionDate.reset();
	        	    	}
	        	    	getComExamForm.getForm().checkValidity();
	        		}
	        	},
	        	'competitiveexamform[itemId=applicantCompetitiveExamForm] filefield[itemId=uploadFileItemId]': {
                change: function(fileField, value, eOpts) {
              	  var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                          var specialCharsExist=false;
                          for(i = 0; i < specialChars.length;i++){
                          if(newValue.indexOf(specialChars[i]) > -1){
                               specialCharsExist= true;
                           }
                           }
                          if(specialCharsExist){
                        	  fileField.reset();
                             showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                          }
                }
                
            },
	        	   /**
	               *  Socio Economic Details
	               */
	              'socioeconomicinformationform[itemId=admApplicantSocioEconomicFormItemId]': {
	            	  afterrender: function(form) {
	            		  var $this = this;
	            		  setTimeout(function(){
	            			  var getForm = form.getForm();
	            			  var parentQualificationFirstStore = getForm.findField('parentQualification1').getStore();
	            			  parentQualificationFirstStore.getProxy().extraParams={
	            				  type:'HighestacademicqualificationGuardian1'
	            			  };
	            			  var parentQualificationSecondStore = getForm.findField('parentQualification2').getStore();
	            			  parentQualificationSecondStore.getProxy().extraParams={
	            				  type:'HighestacademicqualificationGuardian2'
	            			  };
	            			  
	            			  var PrimaryWayofPaymentStore = getForm.findField('payStudy').getStore();
	            			  PrimaryWayofPaymentStore.getProxy().extraParams={
	            				  type:'PrimaryWayofPayment'
	            			  };
	            			  
	            			  var parentQualificationSecondStore = getForm.findField('parentAnnualIncome').getStore();
	            			  parentQualificationSecondStore.getProxy().extraParams={
	            				  type:'ParentsAnnualIncomeCombined'
	            			  };
	            			  var schoolFeePerYearStore = getForm.findField('schoolFeePerYear').getStore();
	            			  schoolFeePerYearStore.getProxy().extraParams={
	            				  type:'PrescribedSchoolFeePerYear'
	            			  };
	            			  var isScholarshipStore = getForm.findField('isScholarship').getStore();
	            			  isScholarshipStore.getProxy().extraParams={
	            				  type:'ReceivedBursary'
	            			  };

	            			  var url = SERVERURL.PATH_ECONOMIC_INFORMATION_FIND_BY_PERSON + '?applicantPersonId=';
	            			  $this.onRenderSocioEconomicForm(url,'applicant');
	            			  $this.disableSocioDetailFormPivileges(form, $this.getAPPLICANT_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS());
	            		  },30);
	            	  }
	              },
	              'socioeconomicinformationform[itemId=admApplicantSocioEconomicFormItemId] button[itemId=submitButtonId]': {
	                  click: function() {
	                	  this.saveSocioEconomicDetails('#admApplicantSocioEconomicFormItemId', SERVERURL.PATH_ECONOMIC_INFORMATION_SAVE, SERVERURL.PATH_ECONOMIC_INFORMATION_UPDATE,'applicant');
	                  }
	              },
	              'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=educationDepartmentId]': {
	            	  select: function(combo, records, eOpts) {
	            		  var window = this.getPersonEducationForm();
	            		  var educationForm = this.getPersonEducationForm().getForm();	
	            		  var form = window.getForm();
	            		  var value = combo.getValue();
	            		  var educationDepartmentIsOther = false;
	            		  var educationDepartmentId =null;
	            		  var campaignSchool = form.findField('campaignSchool');
	            		  var countryId = null;
	        		  	  var countryRegionId = null;
	        		  	  var cityId = null;

	            		  educationDepartmentId = combo.getValue();
	            		  form.findField('instituteName').reset();
	            		  form.findField('campaignSchool').reset();
	            		  form.findField('campaignSchool').setDisabled(false);

	            		  if(campaignSchool.getRawValue()==='Others' || campaignSchool.getRawValue()==='Other'){
	            			  form.findField('instituteName').reset();
	            			  form.findField('instituteName').setDisabled(false);
	            			  educationForm.findField('instituteName').setVisible(true);
	            			  form.isValid();
	            		  }else{
	            			  form.findField('instituteName').reset();
	            			  form.findField('instituteName').setDisabled(true);
	            			  educationForm.findField('instituteName').setVisible(false);
	            			  form.isValid();
	            		  }

	            		  if(combo.getRawValue()==='Others' || combo.getRawValue()==='Other'){
	            			  educationDepartmentIsOther = true;
	            		  }
	            		  if(form.findField('country').getValue()!=undefined && !isNullOrEmpty(form.findField('country').getValue())){
	            			  countryId = form.findField('country').getValue();
	            		  }
	            		  if(form.findField('countryRegion').getValue()!=undefined && !isNullOrEmpty(form.findField('countryRegion').getValue())){
	            			  countryRegionId = form.findField('countryRegion').getValue();
	            		  }
	            		  if(form.findField('city').getValue()!=undefined && !isNullOrEmpty(form.findField('city').getValue())){
	            			  cityId = form.findField('city').getValue();
	            		  }
	            		  campaignSchool.getStore().getProxy().extraParams = {
	            			  educationDepartmentId: educationDepartmentId,
	            			  educationDepartmentIsOther:educationDepartmentIsOther,
	            			  isOthersSchoolReq:true,
	            			  countryId:countryId,
	        		  		  countryRegionId:countryRegionId,
	        		  		  cityId:cityId
	            		  };
	            		  campaignSchool.getStore().load();
	            		  window.getForm().checkValidity();
	            	  }
	              },
	              'personcommonwindow[itemId=personCommonWindow] educationform[itemId=applicantEducationForm] combo[itemId=campaignSchoolId]': {
	            	  select: function(combo, records, eOpts) {
	            		  var window = this.getPersonEducationForm();
	            		  var educationForm = this.getPersonEducationForm().getForm();	
	            		  var form =window.getForm();
	            		  if(combo.getRawValue()==='Others' || combo.getRawValue()==='Other'){
	            			  form.findField('instituteName').reset();
	            			  form.findField('instituteName').setDisabled(false);
	            			  educationForm.findField('instituteName').setVisible(true);
	            			  form.isValid();
	            		  }else{
	            			  form.findField('instituteName').reset();
	            			  form.findField('instituteName').setDisabled(true);
	            			  educationForm.findField('instituteName').setVisible(false);
	            			  form.isValid();
	            		  }
	            	  }
	              },'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] datefield[itemId=eventDateForm]':{
		            	select : function(field, value, eOpts){
		            		this.applicantCheckSelectDate();

		            	}
		            },
		            'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] datefield[itemId=eventDateTill]':{
		            	select : function(field, value, eOpts){
		            		this.applicantCheckSelectDate();

		            	}
		            },
	              'communicationhistorystructure[itemId=applicantcommunicationhistorystructureItemId] button[itemId=exportMessageSentReportItemId]':{
		            	click: function(){
		            		this.exportXlsMsgSentReport();
		            		
		            	}
		            },
		            'sendmessageattacheddocumentwin[itemId=applicantsendmessageattacheddocumentwin] grid[itemId=sendMessageDocumentGridItemId]': {
    	               	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
 	                       var $this = this;
 	                       var grid = $this.getSendmessageattacheddocumentwin().down('#sendMessageDocumentGridItemId');
 	                       var columnName = grid.columnManager.columns[cellIndex].dataIndex;
 	                       if (columnName == "name") {
 	                           if (e.target.tagName == 'A') {
 	                               var documentId = record.get("id");
 	                              var staticDocOfMSR  = record.get("staticDocOfMSR");
 	                               if (!isNullOrEmpty(documentId)) {
 	                               	var isWhetherSysMsgEvent = false;
 	                               	var gridMessageList = $this.getCommunicationhistorylist();
 	                               	if(gridMessageList.getSelectionModel().getCount()>0){
 	                               		var recordList = gridMessageList.getSelectionModel().getSelection();
 	                               		var eventName = recordList[0].get('eventName');
 	                               		if(!isNullOrEmpty(eventName)){
 	                               			isWhetherSysMsgEvent = true;
 	                               		}
 	                               	}
 	                                   $this.downloadAttachedDocumentFile(documentId,isWhetherSysMsgEvent,staticDocOfMSR);
 	                               }
 	                           }
 	                       }
 	                   }
 	               },
	          	'postschoolstudiesgrid[itemId=applicantPostSchoolStudiesGrid]': {
	                  render: function(grid) {
	                     this.loadPostSchoolStudiesGridStore('#applicantPostSchoolStudiesGrid', SERVERURL.PATH_POST_SCHOOLS_STUDIES_SECTION_GRID_DATA);
	                      this.doAccessControlValidation(grid, this.getAPPLICANT_POST_SCHOOL_STUDIES_PERMISSIONS());
	                     // this.showContainerInViewMode(grid); 
	                  },
	                  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	      				   if (e.target.tagName == 'A') {
	      					this.viewEmploymentHistory(grid,record);
	      				   }
	      			   }
	              },
	          	  'postschoolstudiesgrid[itemId=applicantPostSchoolStudiesGrid] button[itemId=btnAdd]': {
	          		click: function() {
	                      this.showPersonCommonWindow('POST_SCHOOL_STUDIES_INFO', 'applicantPostSchoolStudiesform');
	                      var form = this.getPostSchoolStudiesForm();
	                      this.showDFRManagedFields(form);
	                      var applicantProfile = this.getContentPanelActiveTab();
	            			var fieldContainer=form.down('#recommendationContainer');
	            			Ext.Ajax.request({
	            				type: 'rest',
	            				url: SERVERURL.PATH_FINDPAROGRAM_BATCH_SEAT_APPID +'?applicationID='+applicantProfile.getApplicationId(),
	            				method: 'GET',
	            				success: function(res, action) {
	            					var data = Ext.decode(res.responseText);
	            					if(!isEmpty(data)){
	            						for(var i = 0; i<data.length;i++) {
	            						fieldContainer.add({
	            			    			   xtype : 'fieldcontainer',
	            			    			   layout:'hbox',
	            			    			   defaults: {
	            			    				   labelAlign: 'top',
	            			    				   width: 226
	            			    			   },
	            			    			   items : [{
	            							        xtype: 'hidden',
	            							        itemId: 'postSchoolProgram_hidden_field'+[i],
	            							        name: 'programBatchSeatConfigurations',
	            							        value:data[i].id
	            							    },{
	            			    					xtype: 'displayfield',
	            			    					name: 'progamName',
	            			    					value:data[i].value,
	            			    					itemId :'progamNameItemId'+[i]
	            			    				},{
	            			    				   xtype: 'customcombobox',
	            			    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
	            			    				   itemId: 'eligibilityRecommendationItemId'+[i],
	            			    				   valueField: 'id',
	            			    				   displayField: 'value',
	            			    				   allowBlank: false,
	            			    				   name: 'eligibilityRecommendation',
	            			    				   editable: false,
	            			    				   listeners:{
	            			    						 change:function(obj,rec,value){
	            			    							 var nxtSib = obj.nextSibling();
	            			    							 var form = obj.up('postschoolstudiesform');
	            			    							 if(obj.getRawValue() == 'Eligible in Others'){
	            			    								 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
	            			    								 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
		            		    								 nxtSib.setVisible(true);
		            			    							 obj.nextSibling().getStore().load(); 
		            			    							 
		            			    							 nxtSib.nextSibling().setVisible(true);
		            			    							 nxtSib.nextSibling().allowBlank=false;
		            			    							 nxtSib.nextSibling().validate();
		            			    							 nxtSib.nextSibling().getStore().load(); 
	            			    							 }else{
	            			    								 nxtSib.setVisible(false);
		            			    							 nxtSib.clearValue();
		            			    							 nxtSib.allowBlank=true;
		            			    							 nxtSib.nextSibling().setVisible(false);
		            			    							 nxtSib.nextSibling().allowBlank=true;
		            			    							 nxtSib.nextSibling().clearValue();
		            			    							 nxtSib.nextSibling().validate();
		            			    							 var fieldPanel=form.down('#recommendationContainer');
	            			    								 for (var j = 0; j < fieldPanel.items.items.length; j++) {
	            			    									 var eligibilityRecommendation = fieldPanel.items.items[j];
	            			    									if(!eligibilityRecommendation.items.items[3].isHidden()){
	            			    										 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
	            			    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
	            			    										 return false;
	            			    									}else{
	            			    										 form.down('#recommendedFieldLabelItemId').setFieldLabel();
	            			    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel();
	            			    									}
	            			    								 }
	            			    								
	            			    							 }
	            			    						 }
	            			    		  			   }
	            			    				},{
	            			    					xtype : 'multiselectcombofield',
	            			    					name : 'academyLocation',
	            			    					itemId:'academyLocationId'+[i],
	            			    					autoloadStore: false,
	            			    					store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
	            			    					valueField : 'id',
	            			    					displayField : 'value',
	            			    					hidden:true,
	            			    					allowBlank : false,
	            			    					queryParam:'qry',
	            			    					minChars:3,
	            			    					typeAhead:true,
	            			    					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	            			    					cls:'commonAutoHeightMultiselectField',
	            			    					enableKeyEvents  : 'true',
	            			    					hideTrigger:false,
	            			    					forceSelection:true,
	            			    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            			    					listeners: {
	            		    							change:function(obj,rec,value){
	            		    								var aLRecord = rec.toString();
	            		    								obj.nextSibling().reset();
	            		    								var recommendationStore = obj.nextSibling().getStore();
	            		    								recommendationStore.getProxy().extraParams = {
	            		    									academyLocationIds: aLRecord
	            		    					    		};
	            		    								recommendationStore.load();
	            			    						 }
	            		    						},
	            			    					listConfig: {
	            			    						listeners: {
	            			    							beforeshow: function(picker) {
	            			    								picker.minWidth = picker.up('combobox').getSize().width;
	            			    							},
	            			    							afterRender: function(combo){
	            			    								combo.getStore().on("load", function(store, items){
	            			    									if(items.length==0)
	            			    										Ext.select('.x-boundlist-item').elements[0].hidden = true;
	            			    									else
	            			    										Ext.select('.x-boundlist-item').elements[0].hidden = false;
	            			    						        });
	            			    							}
	            			    						},
	            			    						loadingText: getCommonTranslation('SEARCHING'),
	            			    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	            			    						getInnerTpl: function() {
	            			    							return '<div class="search-item">' +
	            			    							'{code}' +
	            			    							'</div>';
	            			    						}
	            			    					}
	            			    				},{
	            			    					xtype: 'customcombobox',
	            			    					store: Ext.create('Academia.store.scholarships.AssociateProgramStore'),
	            			    					itemId: 'recommendedForItemId'+[i],
	            			    					valueField: 'id',
	            			    					hidden:true,
	            			    					displayField: 'value',
	            			    					name: 'recommendedFor',
	            			    					queryParam:'programName',
	            			    					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            			    					enableKeyEvents  : 'true',
	            			    					minChars:3,
	            			    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            			    					typeAhead:false,
	            			    					hideTrigger:false,
	            			    					forceSelection:true
	            			    				}]
	            			    		   });
	            						if(i == 0){
	            							form.down('#recommendedForItemId'+[i]).hideLabel = false;
	            							form.down('#recommendedForItemId'+[i]).labelSeparator = '';
	            							form.down('#academyLocationId'+[i]).hideLabel = false;
	            							form.down('#academyLocationId'+[i]).labelSeparator = '';
	            							form.down('#eligibilityRecommendationItemId'+[i]).hideLabel = false;
	            							form.down('#eligibilityRecommendationItemId'+[i]).labelSeparator = '';
	            						}
	            						var eligibilityRecommendationStore = form.down('#eligibilityRecommendationItemId'+[i]).getStore();
		    	            			eligibilityRecommendationStore.getProxy().extraParams={
		    	            				type:'Eligibility Recommendation'
		    	            			};
	            						}	
	            					}
	            				}
	            			});
	            			form.doLayout();
	                  }
	              },
	              'postschoolstudiesgrid[itemId=applicantPostSchoolStudiesGrid] button[itemId=btnEdit]': {
	            	  click: function(){
	            		  this.editPostSchoolStudiesFormWindow('POST_SCHOOL_STUDIES_INFO', 'applicantPostSchoolStudiesform', '#applicantPostSchoolStudiesGrid');
	            	  }
	              },
	              'postschoolstudiesgrid[itemId=applicantPostSchoolStudiesGrid] button[itemId=btnView]': {
	            	  click: function(){
	            		  this.viewPostSchoolStudiesFormWindow('POST_SCHOOL_STUDIES_INFO', 'applicantPostSchoolStudiesform', '#applicantPostSchoolStudiesGrid');
	            	  }
	              },
	              'postschoolstudiesgrid[itemId=applicantPostSchoolStudiesGrid] button[itemId=btnDelete]': {
	                  click: function(){
	                  	this.deletePostSchoolStudiesInfoRecord('#applicantPostSchoolStudiesGrid', SERVERURL.PATH_DELETE_POST_SCHOOLS_STUDIES_SECTION);
	                  }
	              },
	              'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform]': {
	            	  afterrender: function(form) {
	            		  var $this = this;
	            		  var getForm = form.getForm();
	            		  var institutionStatusStore = getForm.findField('institutionStatus').getStore();
	            		  institutionStatusStore.getProxy().extraParams={
	            			  type:'Institution Status'
	            		  };
	            		  var qualificationStatusStore = getForm.findField('qualificationStatusPostSchool').getStore();
	            		  qualificationStatusStore.getProxy().extraParams={
	            			  type:'Qualification Status'
	            		  };

	            		  var comparableNameStore = getForm.findField('rsaNqfComparableLevel').getStore();
	            		  comparableNameStore.getProxy().extraParams={
	            			  type:'RSA NQF Comparable Level'
	            		  };

	            		  var academicTranscriptStore = getForm.findField('academicTranscriptVerification').getStore();
	            		  academicTranscriptStore.getProxy().extraParams={
	            			  type:'Verification of Academic Script'
	            		  };

	            		  var degreeeCertificationStore = getForm.findField('degreeCertificateVerification').getStore();
	            		  degreeeCertificationStore.getProxy().extraParams={
	            			  type:'Verification of Degree Certificate'
	            		  };

	            		  var transcriptDocField = getForm.findField('transcriptDoc');
	            		  var certificateDocField =getForm.findField('certificateDoc');
	            		  if (!isNullOrEmpty(transcriptDocField) && transcriptDocField.isVisible()) {
	            			  getForm.findField("transriptDownloadURL").setVisible(true);
	            		  }
	            		  if (!isNullOrEmpty(certificateDocField) && certificateDocField.isVisible()) {
	            			  getForm.findField("certificateDownloadURL").setVisible(true);
	            		  }
	            			
	            			var qualificationTypeStore = getForm.findField('qualificationType').getStore();
	            			qualificationTypeStore.getProxy().extraParams={
	            				type:'Qualification Type'
	            			};
	            			
	            			 var completedComboItemIdStore =  getForm.findField('completedCombo').getStore();
	            			 completedComboItemIdStore.getProxy().extraParams={
            						type:'Studies Completed'
  	            			 };
	            	  }
	              },
	              afterrender: function(form) {
	            		  var getForm = form.getForm();
	            		  var transcriptDocField = getForm.findField('transcriptDoc');
	            		  var certificateDocField =getForm.findField('certificateDoc');
	            		  if (!isNullOrEmpty(transcriptDocField) && transcriptDocField.isVisible()) {
	            			  getForm.findField("transriptDownloadURL").setVisible(true);
	            		  }
	            		  if (!isNullOrEmpty(certificateDocField) && certificateDocField.isVisible()) {
	            			  getForm.findField("certificateDownloadURL").setVisible(true);
	            		  }

	              },
	              
	              'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform] button[itemId=submitButtonId]': {
	                  click: function() {
	                	  this.savePostSchoolStudiesDetails('#applicantPostSchoolStudiesGrid', SERVERURL.PATH_SAVE_POST_SCHOOLS_STUDIES_SECTION, SERVERURL.PATH_UPDATE_POST_SCHOOLS_STUDIES_SECTION,'applicant');
	                  }
	              },
	              'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform] filefield[itemId=transcriptItemId]': {
		        	   change: function(fileField, value, eOpts) {
		        		   if (!isNullOrEmpty(value)) {
		        			   var $this = this;
		        			   value = value.replace('C:\\fakepath\\', '');
		            		   var newValue = value.replace(/ +/g, " ").split(' ').join('_');
		            		   fileField.setRawValue(newValue);
		            		   var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
		                       var specialCharsExist=false;
		                            for(i = 0; i < specialChars.length;i++){
		                              if(newValue.indexOf(specialChars[i]) > -1){
		                                  specialCharsExist= true;
		                               }
		                            }
		                           if(specialCharsExist){
		                        	   fileField.reset();
		                               showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
		                           }
		        		       var form = fileField.up();
		        		       var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
		        		       if ($this.isValidFileExtensionForPostSchoolStudy(extension)) {
		        		    	   var file = fileField.fileInputEl.dom.files[0];
		        		    	   if (file.size / 1048576 > CONSTANTS.UPLOAD_POST_SCHOOL_FILE_SIZE_LIMIT) {
		        		               fileField.reset();
		        		               showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_20MB_ERROR_MSG'));
		        		               return false;
		        		           } 
		        		       } else {
		        		           fileField.reset();
		        		           showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_EXT_ERROR_MSG'));
		        		           return false;
		        		       }
		        		   }
		        	   }
		            },
		            'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform] filefield[itemId=certificateItemId]': {
			        	   change: function(fileField, value, eOpts) {
			        		   if (!isNullOrEmpty(value)) {
			        			   var $this = this;
			        			   var postSchoolForm = $this.getPostSchoolStudiesForm();
			        			   value = value.replace('C:\\fakepath\\', '');
			            		   var newValue = value.replace(/ +/g, " ").split(' ').join('_');
			            		   fileField.setRawValue(newValue);
			            		   var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
			                       var specialCharsExist=false;
			                            for(i = 0; i < specialChars.length;i++){
			                              if(newValue.indexOf(specialChars[i]) > -1){
			                                  specialCharsExist= true;
			                               }
			                            }
			                           if(specialCharsExist){
			                        	   fileField.reset();
			                               showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
			                           }
			        		       var form = fileField.up();
			        		       if(postSchoolForm.isValid()){
			        		    	   postSchoolForm.down('#submitButtonId').setDisabled(false);
			        		       }
			        		       var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
			        		       if ($this.isValidFileExtensionForPostSchoolStudy(extension)) {
			        		    	   var file = fileField.fileInputEl.dom.files[0];
			        		    	   if (file.size / 1048576 > CONSTANTS.UPLOAD_POST_SCHOOL_FILE_SIZE_LIMIT) {
			        		               fileField.reset();
			        		               showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_20MB_ERROR_MSG'));
			        		               return false;
			        		           } 
			        		       } else {
			        		           fileField.reset();
			        		           showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_EXT_ERROR_MSG'));
			        		           return false;
			        		       }
			        		   }
			        	   }
			            },
	              'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform] customcombobox[itemId=completedComboItemId]': {
        			  change: function(obj, record) {
        				  var noOfSemesterCompletedItemId = obj.up('form').down('#noOfSemesterCompletedItemId');
        				  var transcriptDocField = obj.up('form').down('#transcriptItemId');
        				  var certificateDocField = obj.up('form').down('#certificateItemId');
        				  var periodTo = obj.up('form').down('#periodTo');
        				  var recordId = obj.up('form').down('#postSchool_hidden_field').getValue();
        				  var programId=null;
        				  transcriptDocLabel = transcriptDocField.getFieldLabel();
    					  transcriptDocLabelArray = transcriptDocLabel.split(':');
    					  certificateDocLabel = certificateDocField.getFieldLabel();
    					  certificateDocLabelArray = certificateDocLabel.split(':');
        				  if(isArray(record)){
        					   programId = record[0].get("id");
        				  }else{
        					   programId = record; 
        				  }
        				  if(obj.getDisplayValue() != 'Yes'){
        					  noOfSemesterCompletedItemId.setVisible(true); 
    						  noOfSemesterCompletedItemId.allowBlank=false;
    						  noOfSemesterCompletedItemId.hideLabel = false;
    						  noOfSemesterCompletedItemId.labelSeparator = '';
    						  noOfSemesterCompletedItemId.validate();
    						  noOfSemesterCompletedItemId.setFieldLabel(getCommonTranslation('NUMBER_OF_SEMESTER_COMPLETED')+ ': <span class="required" style="color:red"> *</span>');
    						  periodTo.setDisabled(true);
    						  periodTo.reset();
    						  noOfSemesterCompletedItemId.reset();
    					  }else{
    						  periodTo.setDisabled(false);
    						  periodTo.reset();
    						  noOfSemesterCompletedItemId.setVisible(false);
        					  noOfSemesterCompletedItemId.allowBlank=true;
        					  noOfSemesterCompletedItemId.reset();
        					  noOfSemesterCompletedItemId.validate();
    					  }
        				  
        				  if (obj.getDisplayValue() == 'Yes' && transcriptDocField.isVisible() && certificateDocField.isVisible()) {
        					  transcriptDocField.setDisabled(false);
        					  certificateDocField.setDisabled(false);
        					  transcriptDocField.allowBlank = false;
        					  certificateDocField.allowBlank = false;
        					  
        					  transcriptDocField.labelSeparator = '';
        					  certificateDocField.labelSeparator = '';
        					  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
        						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
        					  }
        					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
        						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
        					  }
        				  }else if(obj.getDisplayValue() == 'No' && transcriptDocField.isVisible()){
        					  transcriptDocField.setDisabled(false);
        					  certificateDocField.setDisabled(true);
        					  transcriptDocField.allowBlank = false;
        					  certificateDocField.allowBlank = true;
        					  noOfSemesterCompletedItemId.reset();
        					  transcriptDocField.labelSeparator = '';
        					  certificateDocField.labelSeparator = '';
        					  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
        						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
        					  }
        					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
        						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
        					  }
        				  }else if(obj.getDisplayValue() == 'Currently Enrolled' && transcriptDocField.isVisible()){
        					  transcriptDocField.setDisabled(false);
        					  certificateDocField.setDisabled(true);
        					  transcriptDocField.allowBlank = false;
        					  certificateDocField.allowBlank = true;
        					  noOfSemesterCompletedItemId.reset();
        					  transcriptDocField.labelSeparator = '';
        					  certificateDocField.labelSeparator = '';
        					  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
        						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
        					  }
        					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
        						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
        					  }
        				  }else if(obj.getDisplayValue() == 'Yes' && (transcriptDocField.isVisible() || certificateDocField.isVisible())){
        					  if (transcriptDocField.isVisible()) {
        						  transcriptDocField.setDisabled(false);
        						  transcriptDocField.allowBlank = false;
        						  
        						  transcriptDocField.labelSeparator = '';
        						  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
            						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
            					  }
        					  }
        					  if (certificateDocField.isVisible()) {
        						  certificateDocField.setDisabled(false);
        						  certificateDocField.allowBlank = false;
        						  
            					  certificateDocField.labelSeparator = '';
            					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
            						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
            					  }
        					  }
        				  }
        				  if (!isNullOrEmpty(recordId)) {
       					   transcriptDocField.allowBlank = true;
       					   transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ':');
       					   if(obj.getDisplayValue() == 'Yes'){
       						   if(!isNullOrEmpty(obj.up('form').down('#certificateDownloadURL').getValue())){
       							   certificateDocField.allowBlank = true;
       							   transcriptDocField.labelSeparator = '';
                					   certificateDocField.labelSeparator = '';
                					   if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
                						   transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ':');
                					   }
                					   if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
                						   certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
                					   }
       						   }else{
       							   certificateDocField.allowBlank = false;
       							   certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
       						   }
       					   }else{
       						   certificateDocField.allowBlank = true;
       						   transcriptDocField.labelSeparator = '';
            					   certificateDocField.labelSeparator = '';
            					   if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
            						   transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ':');
            					   }
            					   if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
            						   certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
            					   }
       					   }
           				   
       				  }
        			  }
        		  },
        		  'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform] customcombobox[itemId=institutionNameItemId]': {
        			  select: function(obj, record) {
        				  var institutionNameCombo = obj.up('form').down('#institutionNameItemId').getRawValue();
        				  var institutionNameTextFieldItemId = obj.up('form').down('#institutionNameTextFieldItemId');

        				  if(institutionNameCombo.length>4){
        					  var institutionNameCombo = institutionNameCombo.substring(0,4);
        					  institutionNameCombo = institutionNameCombo.toUpperCase();
        					  if(institutionNameCombo === 'OTHE'){
        						  institutionNameTextFieldItemId.setVisible(true);
        						  institutionNameTextFieldItemId.allowBlank=true;
        						  institutionNameTextFieldItemId.reset();
        					  }else{
        						  institutionNameTextFieldItemId.setVisible(false);
        						  institutionNameTextFieldItemId.allowBlank=true;
        						  institutionNameTextFieldItemId.reset();
        					  }
        				  }else{
        					  institutionNameTextFieldItemId.setVisible(false);
        					  institutionNameTextFieldItemId.allowBlank=true;
        					  institutionNameTextFieldItemId.reset();
        				  }
        			  }
        		  },
        		  'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=applicantPostSchoolStudiesform] button[itemId=cancelButtonId]': {
                  	click: this.closePersonCommonWindow
                  }, 
                  
  	            // Applicant Education Details Grid Render
  	            'applicanteducationdetailsgrid[itemId=applicantEducationDetailsGridItemId]': {
  	                render: function(grid) {
  	                	var this$ = this;
  	                	var portalId = this$.getCurrentLoggedPortalId();
  	                	this$.loadGridStore('#applicantEducationDetailsGridItemId', SERVERURL.PATH_APPLICANT_EDUCATION_HISTORY_DETAIL_GRID_DATA);
  	                	this$.doAccessControlValidation(grid, this$.getAPPLICANT_EDUCATION_HISTORY_PERMISSIONS());
  	                	var applicantProfilePanel = grid.up('applicantprofile');
  	             		var structure = applicantProfilePanel.down('[region=center]');
  	             		if(portalId == 1) {
                            var  store = grid.getStore();
                            store.load({
                                  callback:function() {
                                      if(store.getCount()>5) {
                                    	  this$.getGridHeaderFreeze(grid,structure,true);
                                      }            
                                  }
                              });
                        }else {
                        	this$.getGridHeaderFreeze(grid,structure,true);
                        }
  	                	var applicantProfile = this$.getContentPanelActiveTab();
  	                	try{
  	            			applicantProfile.getApplicationId();
  	            		} catch(e){
  	            			applicantProfile = this$.getContentPanel().items.items[0];
  	            		}
  	                },
  	                afterrender:function(grid){
  	   				var me = this;
  	   				setTimeout(function(){
  	   					me.addDataGridConfigButton(grid,me.getAPPLICANT_EDUCATION_HISTORY_PERMISSIONS());
  	   				},1000);
  	   				},
  	                selectionchange: function(column, selected,eOpts ){
  	                    var grid = column.view.up('grid');
  	                    if(selected.length > '1'){
  	                            grid.down('#btnAdd').setDisabled(true);
  	                            grid.down('#btnEdit').setDisabled(true);
  	                            grid.down('#btnView').setDisabled(true);
  	                            grid.down('#btnDelete').setDisabled(false);
  	                        }else{
  	                            grid.down('#btnAdd').setDisabled(false);
  	                            grid.down('#btnEdit').setDisabled(false);
  	                            grid.down('#btnView').setDisabled(false);
  	                            grid.down('#btnDelete').setDisabled(false);
  	                        }
  	                    },
  	    			
  	            	cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
  	    				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
  	    				if(columnName == "graduationDocument"){
  	    					if(e.target.tagName=='A'){
  	    						if(record.data.graduationDocument.length == 1){
  	    							var whetherFile = false;
  	    							var documentId= record.data.graduationDocument["0"].id;
  	    							if(!isNullOrEmpty(documentId)){
  	    								Ext.Ajax.request({
  	    									type: 'rest',
  	    									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
  	    									method: 'GET',
  	    									callback : function(opt, success, response){
  	    										if(response.responseText == 'true') {
  	    											var csvForm = Ext.create('Ext.form.Panel'); 
  	    											csvForm.getForm().submit({
  	    												target: '_blank',
  	    												method:'GET',
  	    												params :{
  	    													access_token : Ext.Ajax.defaultHeaders.access_token
  	    												},
  	    												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  	    												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
  	    												standardSubmit :true
  	    											});
  	    										} else {
  	    											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
  	    										}
  	    									}
  	    								});
  	    							}} else if(record.data.graduationDocument.length > 1){
  	    								var docWindow = this.getApplicanteducationhistorydocumentlist();
  	    								var ID = record.data.id;
  	    								if (!docWindow) {
  	    									docWindow = Ext.widget('applicanteducationhistorydocumentlist',{
  	    										itemId:'applicanteducationhistorydocumentlist'
  	    									});
  	    								}
  	    								docWindow.show();
  	    								var applicanteducationhistorydocumentlistgrid = docWindow.down('#applicanteducationhistorydocumentlistgridItemId');
  	    								 var store = applicanteducationhistorydocumentlistgrid.getStore();
  	    								  store.getProxy().extraParams = {
  	                 						  ID: record.data.id
  	                 					  };
  	                 					  store.load();
  	    							}
  	    					}
  	    				}
  	    				if(columnName == "graduationDocumentUrl"){
  	    					if(e.target.tagName=='A'){
  	    						if(record.data.graduationDocumentUrl.length == 1){
  	    							
  	    						} else if(record.data.graduationDocumentUrl.length > 1){    	
  	    								var docWindow = this.getApplicanteducationhistorydocurllist();
  	                 					  var ID = record.data.id;
  	                 					  	             					  
  	                 					 if (!docWindow) {
  	    									docWindow = Ext.widget('applicanteducationhistorydocurllist',{
  	    										itemId:'applicanteducationhistorydocurllist'
  	    									});
  	                 					 }
  	    								docWindow.show();
  	    								
  	    								var applicanteducationhistorydocurllistgrid = docWindow.down('#applicanteducationhistorydocurllistgridItemId');
  	    								 var store = applicanteducationhistorydocurllistgrid.getStore();
  	    								  store.getProxy().extraParams = {
  	                 						  ID: record.data.id
  	                 					  };
  	                 					  store.load();
  	    							}
  	    					  }
  	    					}
  	    			}
  	            },
                  /*applicant Language Grid render */
        		 	'applicantlanguageinformationgrid[itemId=applicantLanguagesInformationGridItemId]': {
        	            render: function(grid) {
        	            	var this$ = this; 
        	            	var portalId = this$.getCurrentLoggedPortalId();
        	            	this$.loadGridStore('#applicantLanguagesInformationGridItemId', SERVERURL.PATH_APPLICANT_LANGUAGE_DETAIL_GRID_DATA);
        	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_LANGUAGE_INFORMATION_PERMISSIONS());
        	            	var applicantProfilePanel = grid.up('applicantprofile');
        	         		var structure = applicantProfilePanel.down('[region=center]');
        	         		if(portalId == 1) {
                                var  store = grid.getStore();
                                store.load({
                                      callback:function() {
                                          if(store.getCount()>5) {
                                        	  this$.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                          }            
                                      }
                                  });
                            }else {
                            	this$.getGridHeaderFreezeStudentProfile(grid,structure,true);
                            }
        	            	var applicantProfile = this$.getContentPanelActiveTab();
        	            	try{
        	        			applicantProfile.getApplicationId();
        	        		} catch(e){
        	        			applicantProfile = this$.getContentPanel().items.items[0];
        	        		}
        	            },
        	            selectionchange: function(column, selected,eOpts ){
        	                var grid = column.view.up('grid');
        	                if(selected.length > '1'){
        	                        grid.down('#btnAdd').setDisabled(true);
        	                        grid.down('#btnEdit').setDisabled(true);
        	                        grid.down('#btnView').setDisabled(true);
        	                        grid.down('#btnDelete').setDisabled(false);
        	                    }else{
        	                        grid.down('#btnAdd').setDisabled(false);
        	                        grid.down('#btnEdit').setDisabled(false);
        	                        grid.down('#btnView').setDisabled(false);
        	                        grid.down('#btnDelete').setDisabled(false);
        	                    }
        	                },
        				
        	        	afterrender:function(grid){
        				var me = this;
        				setTimeout(function(){
        					me.addDataGridConfigButton(grid,me.getAPPLICANT_LANGUAGE_INFORMATION_PERMISSIONS());
        				},1000);
        	        	},
        	        	cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
        					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
        					if(columnName == "languageDocument"){
        						if(e.target.tagName=='A'){
        							if(record.data.languageDocument.length == 1){
        								var whetherFile = false;
        								var documentId= record.data.languageDocument["0"].id;
        								if(!isNullOrEmpty(documentId)){
        									Ext.Ajax.request({
        										type: 'rest',
        										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
        										method: 'GET',
        										callback : function(opt, success, response){
        											if(response.responseText == 'true') {
        												var csvForm = Ext.create('Ext.form.Panel'); 
        												csvForm.getForm().submit({
        													target: '_blank',
        													method:'GET',
        													params :{
        														access_token : Ext.Ajax.defaultHeaders.access_token
        													},
        													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
        													standardSubmit :true
        												});
        											} else {
        												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
        											}
        										}
        									});
        								}} else if(record.data.languageDocument.length > 1){
        									var docWindow = this.getApplicantlanguagedocumentlist();
        									var ID = record.data.id;
        									if (!docWindow) {
        										docWindow = Ext.widget('applicantlanguagedocumentlist',{
        											itemId:'applicantlanguagedocumentlist'
        										});
        									}
        									docWindow.show();
        									var applanguagedetaildocumentlistgrid = docWindow.down('#applicantlanguagedocumentlistgridItemId');
        									 var store = applanguagedetaildocumentlistgrid.getStore();
        									  store.getProxy().extraParams = {
        	             						  ID: record.data.id
        	             					  };
        	             					  store.load();
        								}
        						}
        					}
        					if(columnName == "languageDocumentUrl"){
        						if(e.target.tagName=='A'){
        							if(record.data.languageDocumentUrl.length == 1){
        								
        							} else if(record.data.languageDocumentUrl.length > 1){    	
        									var docWindow = this.getApplicantlanguagedocurllist();
        	             					  var ID = record.data.id;
        	             					  	             					  
        	             					 if (!docWindow) {
        										docWindow = Ext.widget('applicantlanguagedocurllist',{
        											itemId:'applicantlanguagedocurllist'
        										});
        	             					 }
        									docWindow.show();
        									
        									var applanguagedetaildocumenturllistgrid = docWindow.down('#applicantlanguagedocurllistgridItemId');
        									 var store = applanguagedetaildocumenturllistgrid.getStore();
        									  store.getProxy().extraParams = {
        	             						  ID: record.data.id
        	             					  };
        	             					  store.load();
        								}
        						  }
        						}
        				}
        	        },
  	            
  	          'applicanteducationdetailsgrid[itemId=applicantEducationDetailsGridItemId] button[itemId=btnAdd]': {
	            	click: function() {
	            		var this$ = this;
	            		var formWindow = this$.showPersonCommonWindow('EDUCATION_DETAILS','applicanteducationhistorydetailform');
	            		if (formWindow) {
	                        formWindow.setHeight(320);
	                    }
	            	}
	            },
	            'applicanteducationdetailsgrid[itemId=applicantEducationDetailsGridItemId] button[itemId=btnEdit]': {
	            	click: function(){
	            		this.editApplicantEducationHistoryDetailFormWindow('EDUCATION_DETAILS', 'applicanteducationhistorydetailform', '#applicantEducationDetailsGridItemId');
	            		this.applicantDocEducationHistoryContainerWindow();
	            		this.applicantUrlEducationHistoryContainerWindow();
	            	}
	            },
	            'applicanteducationdetailsgrid[itemId=applicantEducationDetailsGridItemId] button[itemId=btnView]': {
	                  click: function(){
	                	  this.viewApplicantEducationHistoryDetailFormWindow('EDUCATION_DETAILS', 'applicanteducationhistorydetailform', '#applicantEducationDetailsGridItemId');
	                	  this.applicantDocEducationHistoryContainerWindow();
		            	  this.applicantUrlEducationHistoryContainerWindow();
	                  }
	              },
	              'applicanteducationdetailsgrid[itemId=applicantEducationDetailsGridItemId] button[itemId=btnDelete]': {
	                  click: function(){
	                	  this.deleteApplicantEducationHistoryDetailRecord('#applicantEducationDetailsGridItemId', SERVERURL.PATH_APPLICANT_EDUCATION_HISTORY_DETAIL_DELETE);
	                  }
	              },
	            
	            'educationhistorydetailform[itemId=applicanteducationhistorydetailform] button#submitButtonId' : {
		 			click : function() {
		               this.saveApplicantEducationHistoryDetail('#applicantEducationDetailsGridItemId', SERVERURL.PATH_APPLICANT_EDUCATION_HISTORY_DETAIL_ADD, SERVERURL.PATH_APPLICANT_EDUCATION_HISTORY_DETAIL_UPDATE);
		 			}
		 		},
		 		
		 		'educationhistorydetailform[itemId=applicanteducationhistorydetailform] button#cancelButtonId' : {
  	            	click: this.closePersonCommonWindow
	 			},
	 			
	 			'educationhistorydetailform[itemId=applicanteducationhistorydetailform] button#graduationDocument' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('applicant_education_history_Details_hidden_field','DOCUMENT');
		 				setTimeout(function(){
				            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
	 			            form.down('#documentNameField').allowBlank=true;
	 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
	                    		},100);     
		 			}
		 		},
		 		
		 		'educationhistorydetailform[itemId=applicanteducationhistorydetailform] button#graduationDocumentUrl' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('applicant_education_history_Details_hidden_field','DOCUMENT_URL');
	 					var formWindow = this.getDocumentformwindow();
	 					if (!formWindow) {
	 						Ext.widget('documentformwindow');
	 						formWindow = this.getDocumentformwindow();
	 					}
	 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
		 			}
		 		},
		 		
		 		'documentformwindow[itemId=applicant_education_history_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var isTransient = true;
		 			var module = 'applicantEducationHistory';
		 			var entityId;
		 			var entityType = 'applicantEducationHistoryDetailDocumentt';

		 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		 					function(success,response,isCallBackTransient) {
		 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','applicantEducationHistory','serialNo']
		 						var documentModel = new Academia.model.personinfo.common.pasthistory.ApplicantEducationHistoryDocumentModel();
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("path",response.path);
		 						documentModel.set("type",response.type);
		 						documentModel.set("createdBy",$this.getIdValueJson(
		 										response.createdBy.id,response.createdBy.value));
		 						if(documentModel.data.path.length > 255){
		 							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
		 						}else{
		 							var applicantEducationHistoryDocumentGrid = $this.getApplicanteducationhistorydocumentgrid();
			 						var store = applicantEducationHistoryDocumentGrid.getStore();
			 						store.add(documentModel);
			 						
			 						if (applicantEducationHistoryDocumentGrid.isHidden() && store.data.items.length > 0) {
			 							applicantEducationHistoryDocumentGrid.setVisible(true);
			 						}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						   showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DOCUMENT_ADD_SUCCESSFULLY'));
		 						}
		 					}, isTransient);
		 		}
		 	},
		 	'documentformwindow[itemId=applicant_education_history_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},
		 	
		 	'documentformwindow[itemId=applicant_education_history_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	            var form = Ext.ComponentQuery.query('simpleurlform')[0];
		            form.down('#documentFormSubmitButtonId').setDisabled(true);

	 				fields : ['id','documentId','documentName','path']
	 						var documentModelUrl = new Academia.model.personinfo.common.pasthistory.ApplicantEducationHistoryUrlModel();
	 			            var documentName=form.down('#documentNameField').getValue();
	 			            var UrlName=form.down('#documentUrlField').getValue();

	 			           documentModelUrl.set("documentName",documentName);
	 			           documentModelUrl.set("path",UrlName);
	 						var ApplicantEducationHistoryUrlGrid = Ext.ComponentQuery.query('applicanteducationhistoryurlgrid')[0];
	 						var store2= ApplicantEducationHistoryUrlGrid.getStore();
	 						store2.add(documentModelUrl);
	 						if (ApplicantEducationHistoryUrlGrid.isHidden() && store2.data.items.length > 0) {
	 							ApplicantEducationHistoryUrlGrid.setVisible(true);
		            				}
	 						$this.getDocumentController().closeDocumentFormWindow();
	 					showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_URL_ADD_SUCCESSFULLY'));
	 	    	}
	 		},
	 		'documentformwindow[itemId=applicant_education_history_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
	 			click : function() {
	 				this.getDocumentController().closeDocumentFormWindow();
	 			}
	 		},
	 		
	 		'applicanteducationhistorydocumentgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
	 				 var grid=$this.getApplicanteducationhistorydocumentgrid();
	 				var form = Ext.ComponentQuery.query('educationhistorydetailform')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
	 							 getCommonTranslation('EDUCATION_DETAILS_DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
	 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 										 }
	 									 }

	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	          
	 		 'applicanteducationhistoryurlgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
					 var grid = Ext.ComponentQuery.query('applicanteducationhistoryurlgrid')[0];
					 var form = Ext.ComponentQuery.query('educationhistorydetailform')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							getCommonTranslation('EDUCATION_DETAILS_URL'),
	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													getCommonTranslation('EDUCATION_DETAILS_URL'),
	 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 										 }
	 									 }

	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							getCommonTranslation('EDUCATION_DETAILS_URL'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	 		
	 		'applicanteducationhistorydocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this.getApplicanteducationhistorydocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record
							 .get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
  	            
  	          'applicanteducationhistorydocumentlistgrid':{
					render: function(grid) {
						var this$ = this;
		            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_EDUCATION_HISTORY_DOCUMENT_PERMISSION());
		            	grid.down('#downloadDocumentItemId').setVisible(true);
					},
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								var documentId=record.get('documentId');
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
												showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('DOWNLOAD_EDUCATION_HISTORY_DOCUMENT_SUCCESSFULLY'));
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}
							}
						}
					}
				},
				
				'applicanteducationhistorydocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						var $this = this;
						var form = $this.getApplicanteducationhistorydocumentlistgrid();
						var ApplicantEducationHistoryActionGrid=obj.up('grid');
						if (ApplicantEducationHistoryActionGrid.getSelectionModel().getCount() > 0) {
							var records = ApplicantEducationHistoryActionGrid.getSelectionModel().getSelection();
							var dispatchZipName = "Applicant Education Detail Document";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
										getCommonTranslation('EDUCATION_HISTORY_DETAIL_DOCUMENTS_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
										showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('DOWNLOAD_EDUCATION_HISTORY_DOCUMENT_SUCCESSFULLY'));
									}
									
								});
							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
	      	 },
	      	 
	      	'applicanteducationhistorydocgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = grid.up('grid');
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }
					 }
				 }
			 },
	      	 
	      	'applicanteducationhistorydocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this=this;
					var form = $this.getApplicanteducationhistorydocumentlist();  
					var applicantEducationHistoryDetailGrid= $this.getApplicanteducationdetailsgrid();
					var applicanteducationhistoryDetaillistgrid=form.down('#applicanteducationhistorydocumentlistgridItemId');
					if (applicanteducationhistoryDetaillistgrid.getSelectionModel().getCount() > 0) {
						var records = applicanteducationhistoryDetaillistgrid.getSelectionModel().getSelection();
						var ids=[];
						Ext.Array.each(records,function(value){
							ids.push(value.data.id);
						});
							showConfirmMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes'){
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method: "DELETE",
									type: 'rest',
									url : SERVERURL.PATH_APPLICANT_EDUCATION_HISTORY_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DOCUMENT_SUCCESS_DELETE_MSG'));	 
										applicanteducationhistoryDetaillistgrid.store.reload();
										applicantEducationHistoryDetailGrid.store.reload();
										applicanteducationhistoryDetaillistgrid.getSelectionModel().deselectAll(true);
									}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
	      	},
	      	'applicanteducationhistorydocurllistgrid':{
				 render: function(grid) {
					 var this$ = this; 
					 this$.doAccessControlValidation(grid, this$.getAPPLICANT_EDUCATION_HISTORY_URL_PERMISSION());
				 }
			 },
	      	
	      	'applicanteducationhistorydocurllistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this=this;
					var form = $this.getApplicanteducationhistorydocurllist();  
					var applicantEducationHistoryDetailGrid= $this.getApplicanteducationdetailsgrid();
					var applicantEducationHistoryDetaillistgrid=form.down('#applicanteducationhistorydocurllistgridItemId');
					if (applicantEducationHistoryDetaillistgrid.getSelectionModel().getCount() > 0) {
						var records = applicantEducationHistoryDetaillistgrid.getSelectionModel().getSelection();
						var ids=[];
						Ext.Array.each(records,function(value){
							ids.push(value.data.id);
						});
							showConfirmMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes'){
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method: "DELETE",
									type: 'rest',
									url : SERVERURL.PATH_APPLICANT_EDUCATION_HISTORY_URL_DELETE+'?fileDocumentIds='+ids.join(),
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DOCUMENT_SUCCESS_DELETE_MSG'));	 
										applicantEducationHistoryDetaillistgrid.store.reload();
										applicantEducationHistoryDetailGrid.store.reload();
										applicantEducationHistoryDetaillistgrid.getSelectionModel().deselectAll(true);
									}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
       		},
        	        'applicantlanguageinformationgrid[itemId=applicantLanguagesInformationGridItemId] button[itemId=btnAdd]': {
                     	click: function() {
                     		this.studentLanguageMode = 'ADD';
                             this.showPersonCommonWindow('APPLICANT_LANGUAGE','applicantlanguageformId');
                         }},
                         'applicantlanguageinformationgrid[itemId=applicantLanguagesInformationGridItemId] button[itemId=btnEdit]': {
                           	click: function() {
                           		this.isAdd=false;
                         		this.studentLanguageMode='EDIT';
                         		this.editApplicantLanguageWindow('APPLICANT_LANGUAGE', 'applicantlanguageformId', '#applicantLanguagesInformationGridItemId', false);
                         		this.applicantLanguageDocWindow();
                         		this.applicantLanguageUrlContainerWindow();
                               }},
                         'studentlanguagedetailform[itemId=applicantlanguageformId] button#submitButtonId' : {
             	 			click : function() {
             	 				
             	               this.saveApplicantLanguageDetail('#applicantLanguagesInformationGridItemId', SERVERURL.PATH_APPLICANT_LANGUAGE_SAVE, SERVERURL.PATH_APPLICANT_LANGUAGE_UPDATE);
             	 			}
             	 		},
             	 		'studentlanguagedetailform[itemId=applicantlanguageformId] button#cancelButtonId' : {
          	            	click: this.closePersonCommonWindow
        	 			},
             	 		'applicantlanguageinformationgrid[itemId=applicantLanguagesInformationGridItemId] button[itemId=btnView]': {
         	                  click: function(){
         	                	 this.studentLanguageMode = '';
         	                	  this.viewApplicantLanguageDetailFormWindow('APPLICANT_LANGUAGE', 'applicantlanguageformId', '#applicantLanguagesInformationGridItemId');
         	                	  this.applicantLanguageDocWindow();
                          		  this.applicantLanguageUrlContainerWindow();
         	                  }
         	              },
         	              'applicantlanguageinformationgrid[itemId=applicantLanguagesInformationGridItemId] button[itemId=btnDelete]': {
         	                  click: function(){
         	                	  this.deleteApplicantLanguageDetailRecord('#applicantLanguagesInformationGridItemId', SERVERURL.PATH_APPLICANT_LANGUAGE_DELETE);
         	                  }
         	              },
         	             'studentlanguagedetailform[itemId=applicantlanguageformId] nestedJsonCombo#languageExamType' : {
				    			change : function(obj, record) {
				    				var $this = this;
				    				var formLayout = $this.getStudentlanguagedetailform();
									var otherLanguageExamType= formLayout.down('#otherLanguageExamType');
									otherLanguageExamType.reset();
				    				var activity = formLayout.down ('#languageExamType').getDisplayValue();
								     var currentVal = activity;
											if(currentVal=="Other"){
												otherLanguageExamType.setVisible(true);
					    						return false;
					    					}else{
					    						otherLanguageExamType.setVisible(false);
					    					}		
				    		}
				        },
				         'studentlanguagedetailform[itemId=applicantlanguageformId] checkboxfield#isPrimaryLanguage' :{
			                 change:function(val)
			                 {
			                     var form= this.getStudentlanguagedetailform();
			                     var id = form.down("#language_detail_hidden_field");
			                     var isPrimaryFiled=form.down('#isPrimaryLanguage');
			                 	 var contentPanelTab = this.getContentPanelActiveTab();
			        	       	 var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
			        	   		 var gridStore  = personInfoPanel.down('applicantlanguageinformationgrid').getStore();
			    	 				//var gridStore  = this.getApplicantlanguageinformationgrid().getStore();
			                        if(this.studentLanguageMode=='ADD'){
			                            if(gridStore.data.items.length!=null){
			                            gridStore.data.items.forEach(function(itemObj){
			                                  if(!isNullOrEmpty(itemObj.data.isPrimaryLanguage)&&(itemObj.data.isPrimaryLanguage==true)){
			                                        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
			                                        isPrimaryFiled.setValue(false);
			                                  }
			                             });
			                            }
			                        }else if(this.studentLanguageMode=='EDIT'){
			                            if(gridStore.data.items.length!=null){
			                                gridStore.data.items.forEach(function(itemObj){
			                                      if(!isNullOrEmpty(itemObj.data.isPrimaryLanguage)&&(itemObj.data.isPrimaryLanguage==true)&&(itemObj.data.id != Number(id.getValue()))){
			                                            showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
			                                            isPrimaryFiled.setValue(false);
			                                      }
			                                 });
			                                }
			                        }
			                        
			                 }
			             },
             	 		'studentlanguagedetailform[itemId=applicantlanguageformId] button#languageUploadFileItemId': {
                         	click : function() {
             	 				this.getDocumentController().showDocumentFormWindow('applicant_language_detail_hidden_field','DOCUMENT');
             	 				setTimeout(function(){
             			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
              			            form.down('#documentNameField').allowBlank=true;
              			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENT_DETAILS'));
                         		},100); 
             	 			}
                         },
                         
                         'studentlanguagedetailform[itemId=applicantlanguageformId] button#languageURLItemId': {
                         	click : function() {
             	 				this.getDocumentController().showDocumentFormWindow('applicant_language_detail_hidden_field','DOCUMENT_URL');
             	 				var formWindow = this.getDocumentformwindow();
              					if (!formWindow) {
              						Ext.widget('documentformwindow');
              						formWindow = this.getDocumentformwindow();
              					}
              					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
             	 			}
                         },
                         'documentformwindow[itemId=applicant_language_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
             	 	    	click : function() {
             	 			var $this = this;
             	 			var isTransient = true;
             	 			var module = 'studentLanguage';
             	 			var entityId;
             	 			var entityType = 'applicantLanguageDocument';
             	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
             	 					function(success,response,isCallBackTransient) {
             	 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
             	 						var documentModel = new Academia.model.personinfo.common.pasthistory.StudentLanguageDocumentModel();
             	 						documentModel.set("name",response.name);
             	 						documentModel.set("path",response.path);
             	 						documentModel.set("type",response.type);
             	 						documentModel.set("documentName",response.name);
             	 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
             	 						if(documentModel.data.path.length > 255){
             	                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
             	                          }else {
             			 						var applicantLanguageDocGrid = $this.getApplicantlanguagedocdetailgrid();
             			 						var store = applicantLanguageDocGrid.getStore();
             			 						store.add(documentModel);
             			 						if (applicantLanguageDocGrid.isHidden() && store.data.items.length > 0) {
             			 							applicantLanguageDocGrid.setVisible(true);
             			 						}
             			 						$this.getDocumentController().closeDocumentFormWindow();
             			 						showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE'),getCommonTranslation('LANGUAGE_DOCUMENT_ADD_SUCCESSFULLY'));
             	                          }
             	 					}, isTransient);
             		 		}
             		 	},
             			'applicantlanguagedocdetailgrid button#btnDelete' : {
              	 			 click : function() {
              	 				 var $this = this;
              					 var grid = Ext.ComponentQuery.query('applicantlanguagedocdetailgrid')[0];
              	 				 if (grid.getSelectionModel().getCount() > 0) {
              	 					 Ext.MessageBox
              	 					 .confirm(
              	 							getCommonTranslation('LANGUAGE_DOCUMENT'),
              	 							 getCommonTranslation('APPLICANT_LANGUAGE_DELETE_CONFIRM_MESSAGE'),
              	 							function(btn, text) {
              	 								 if (btn == 'yes') {
              	 									 var store = grid.getStore();
              	 									 var record = grid.getSelectionModel().getSelection()[0];
              	 									 var id = record.id;
              	 									 if (isNullOrEmpty(id)) {
              	 									 }else{
              	 										 if (record) {
              	 											 store.remove(record);
              	 											 showSuccessMessage(
              	 											 getCommonTranslation('LANGUAGE_DOCUMENT'),
              												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
              	 											 if(store.data.items.length == 0) {
              	 												grid.setVisible(false);
              	 					 						}
              	 										 }
              	 									 }
              	 								 }
              	 							 });
              	 				 } else {
              	 					 showWarningMessage(
              	 							getCommonTranslation('LANGUAGE_DOCUMENT'),
              	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
              	 				 }
              	 			 }
              	 		 },
              	 		'applicantlangurlgrid button#btnDelete' : {
           	 			 click : function() {
           	 				 var $this = this;
           					 var grid = Ext.ComponentQuery.query('applicantlangurlgrid')[0];
           	 				 if (grid.getSelectionModel().getCount() > 0) {
           	 					 Ext.MessageBox
           	 					 .confirm(
           	 							getCommonTranslation('LANGUAGE_URL'),
           	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
           	 							function(btn, text) {
           	 								 if (btn == 'yes') {
           	 									 var store = grid.getStore();
           	 									 var record = grid.getSelectionModel().getSelection()[0];
           	 									 var id = record.id;
           	 									 if (isNullOrEmpty(id)) {
           	 									 }else{
           	 										 if (record) {
           	 											 store.remove(record);
           	 											 showSuccessMessage(
           	 											 getCommonTranslation('LANGUAGE_URL'),
           												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
           	 											 if(store.data.items.length == 0) {
           	 												grid.setVisible(false);
           	 					 						}
           	 										 }
           	 									 }
           	 								 }
           	 							 });
           	 				 } else {
           	 					 showWarningMessage(
           	 							getCommonTranslation('LANGUAGE_URL'),
           	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
           	 				 }
           	 			 }
           	 		 },
             			'applicantlanguagedocdetailgrid' : {
              				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
              					 var $this = this;
              					 var documentGrid = $this.getApplicantlanguagedocdetailgrid();
              					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
              					 if (columnName == "documentName") {
              						 if (e.target.tagName == 'A') {
              							 var documentId = record.get("ecrptydocumentId");
              							 if (!isNullOrEmpty(documentId)) {
              								 $this.getDocumentController().downloadDocumentFile(documentId);
              							 }
              						 }

              					 }
              				 }
              			 },
             		 	
             		 	'documentformwindow[itemId=applicant_language_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
             		 		click : function() {
             		 			this.getDocumentController()
             		 			.closeDocumentFormWindow();
             		 		}
             		 	},
             		 	'documentformwindow[itemId=applicant_language_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
            	 	    	click : function() {
            	 			var $this = this;
            	 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
            	            form.down('#documentFormSubmitButtonId').setDisabled(true);
            	 				fields : ['id','documentId','documentName','path','createdBy']
            	 						var documentModelUrl = new Academia.model.personinfo.common.pasthistory.StudentLanguageUrlModel();
            				            var form = Ext.ComponentQuery.query('simpleurlform')[0];

            	 			            var documentName=form.down('#documentNameField').getValue();
            	 			            var UrlName=form.down('#documentUrlField').getValue();
            	 			            documentModelUrl.set("documentName",documentName);
            	 			            documentModelUrl.set("path",UrlName);
            	 			            
            	 			           documentModelUrl.set("type",'DOCUMENT');
            	 			           var userId = this.getCurrentlyLoggedInUser()
            	 			           documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
            	 			           
                                	  var applicantLanguageUrlGrid = Ext.ComponentQuery.query('applicantlangurlgrid')[0];
                                	  var store2= applicantLanguageUrlGrid.getStore();
                                	  store2.add(documentModelUrl);
                                	  if (applicantLanguageUrlGrid.isHidden() && store2.data.items.length > 0) {
                                		  applicantLanguageUrlGrid.setVisible(true);
                                	  }
                                	  $this.getDocumentController().closeDocumentFormWindow();
                                	  showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE'),getCommonTranslation('LANGUAGE_URL_ADD_SUCCESSFULLY'));
            	 						
            	 		}
            	 	},
                        
            		 	'documentformwindow[itemId=applicant_language_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
            		 		click : function() {
            		 			this.getDocumentController()
            		 			.closeDocumentFormWindow();
            		 		}
            		 	},
            		 	'applicantlanguagedocumentlistgrid button[itemId=downloadDocumentItemId]':{
							click:function(obj){
								var $this = this;
								var ApplicantLanguageDetailActionGrid=obj.up('grid');
								if (ApplicantLanguageDetailActionGrid.getSelectionModel().getCount() > 0) {
									var records = ApplicantLanguageDetailActionGrid.getSelectionModel().getSelection();
									var dispatchZipName = "Applicant Language Information Document";
									var saveModel=[];  
									for(var i in records){
										if(!isNullOrEmpty(records[i].get('path'))) {
											saveModel.push(records[i].get('path'));
										}
										showConfirmMessage(getCommonTranslation('APPLICANT_LANGUAGE_DOCUMENTS'),
												getCommonTranslation('APPLICANT_LANGUAGE_DETAIL_DOCUMENTS_ALERT'),
												function(btn, text) {
											if (btn == 'yes') {
												var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
												$this.getController('Academia.controller.document.DocumentController')
												.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
											}
										});
									}
								}
								else {
									$this.hideWindowMask();
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
								}
							}
			     	 },
			     	 'applicantlanguagedocumentlistgrid button[itemId=btnDelete]':{
			 				click:function(obj){
			 					var $this=this;
								var applicantLanguagelistgrid=obj.up('grid');
			 					var applicantLanguageGrid= $this.getApplicantlanguageinformationgrid();
			 					if (applicantLanguagelistgrid.getSelectionModel().getCount() > 0) {
			 						var records = applicantLanguagelistgrid.getSelectionModel().getSelection();
			 						var ids=[];
			 						Ext.Array.each(records,function(value){
			 							ids.push(value.data.id);
			 						});
			 							showConfirmMessage(getCommonTranslation('APPLICANT_LANGUAGE'),getCommonTranslation('APPLICANT_LANGUAGE_DELETE_CONFIRM_MESSAGE'),function(btn,text){
			 							if (btn == 'yes'){
			 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			 								Ext.Ajax.request({
			 									method: "DELETE",
			 									type: 'rest',
			 									url : SERVERURL.PATH_APPLICANT_LANGUAGE_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
			 									headers: {
			 										'Content-Type': 'application/json'
			 									},
			 									success: function(form, action) {

			 										Ext.getBody().unmask();
			 										showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
			 										applicantLanguagelistgrid.store.reload();
			 										applicantLanguageGrid.store.reload();
			 										applicantLanguagelistgrid.getSelectionModel().deselectAll(true);
			 									}
			 								});
			 							}
			 						});
			 					} else {
			 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			 					}
			 				}
			       	 },
			       	'applicantlanguagedocumentlistgrid':{
						render: function(grid) {
							var this$ = this;
			            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION());
			            	grid.down('#downloadDocumentItemId').setVisible(true);
						},
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(columnName == "documentName"){
								if(e.target.tagName=='A'){
									var documentId=record.get('ecrptydocumentId');
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
													showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE'),getCommonTranslation('DOWNLOAD_LANGUAGE_DOCUMENT_ADD_SUCCESSFULLY'));
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
								}
							}
						}
					},
					'applicantlanguagedocurllistgrid':{
						 render: function(grid) {
							 var this$ = this; 
							 this$.doAccessControlValidation(grid, this$.getAPPLICANT_LANGUAGE_INFORMATION_URL_PERMISSION());
						 }
					 },
			       	 'applicantlanguagedocurllistgrid button[itemId=btnDelete]':{
			 				click:function(obj){
			 					var $this=this;
			 					var form = $this.getApplicantlanguagedocurllist();  
			 					var applicantlanguageGrid= $this.getApplicantlanguageinformationgrid();
			 					var applicantLanguageUrlListgrid=form.down('#applicantlanguagedocurllistgridItemId');
			 					if (applicantLanguageUrlListgrid.getSelectionModel().getCount() > 0) {
			 						var records = applicantLanguageUrlListgrid.getSelectionModel().getSelection();
			 						var ids=[];
			 						Ext.Array.each(records,function(value){
			 							ids.push(value.data.id);
			 						});
			 							showConfirmMessage(getCommonTranslation('APPLICANT_LANGUAGE_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
			 							if (btn == 'yes'){
			 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			 								Ext.Ajax.request({
			 									method: "DELETE",
			 									type: 'rest',
			 									url : SERVERURL.PATH_APPLICANT_LANGUAGE_DOC_URL_DELETE+'?fileDocumentIds='+ids.join(),
			 									headers: {
			 										'Content-Type': 'application/json'
			 									},
			 									success: function(form, action) {

			 										Ext.getBody().unmask();
			 										showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE_URL'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
			 										applicantLanguageUrlListgrid.store.reload();
			 										applicantlanguageGrid.store.reload();
			 										applicantLanguageUrlListgrid.getSelectionModel().deselectAll(true);
			 									}
			 								});
			 							}
			 						});
			 					} else {
			 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			 					}
			 				}
			       	 },
                  
                  

                  
                  /*applicant Health Information */
        		 	'applicanthealthinformationgrid[itemId=applicantHealthInformationGridItemId]': {
        	            render: function(grid) {
        	            	var this$ = this;  
        	            	var portalId = this$.getCurrentLoggedPortalId();
        	            	this$.loadGridStore('#applicantHealthInformationGridItemId', SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_GRID_DATA);
        	            	var applicantProfilePanel = grid.up('applicantprofile');
        	         		var structure = applicantProfilePanel.down('[region=center]');
        	         		if(portalId == 1) {
                                var  store = grid.getStore();
                                store.load({
                                      callback:function() {
                                          if(store.getCount()>5) {
                                        	  this$.getGridHeaderFreeze(grid,structure,true);
                                          }            
                                      }
                                  });
                            }else {
                            	this$.getGridHeaderFreeze(grid,structure,true);
                            }
        	            	var applicantProfile = this$.getContentPanelActiveTab();
        	            	try{
        	        			applicantProfile.getApplicationId();
        	        		} catch(e){
        	        			applicantProfile = this$.getContentPanel().items.items[0];
        	        		}
        	            },
        	            selectionchange: function(column, selected,eOpts ){
        	                var grid = column.view.up('grid');
        	                if(selected.length > '1'){
        	                        grid.down('#btnAdd').setDisabled(true);
        	                        grid.down('#btnEdit').setDisabled(true);
        	                        grid.down('#btnView').setDisabled(true);
        	                        grid.down('#btnDelete').setDisabled(false);
        	                    }else{
        	                        grid.down('#btnAdd').setDisabled(false);
        	                        grid.down('#btnEdit').setDisabled(false);
        	                        grid.down('#btnView').setDisabled(false);
        	                        grid.down('#btnDelete').setDisabled(false);
        	                    }
        	                },
        				
        	        	afterrender:function(grid){
        				var me = this;
        				setTimeout(function(){
        					me.addDataGridConfigButton(grid,me.getAPPLICANT_HEALTH_INFORMATION_PERMISSIONS());
        				},1000);
        	        	},
        	        	cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
							var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
							if(columnName == "applicantHealthDocument"){
								if(e.target.tagName=='A'){
									if(record.data.applicantHealthDocument.length == 1){
										var whetherFile = false;
										var documentId= record.data.applicantHealthDocument["0"].id;
										if(!isNullOrEmpty(documentId)){
											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
												method: 'GET',
												callback : function(opt, success, response){
													if(response.responseText == 'true') {
														var csvForm = Ext.create('Ext.form.Panel'); 
														csvForm.getForm().submit({
															target: '_blank',
															method:'GET',
															params :{
																access_token : Ext.Ajax.defaultHeaders.access_token
															},
															headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
															url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
															standardSubmit :true
														});
													} else {
														showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
													}
												}
											});
										}} else if(record.data.applicantHealthDocument.length > 1){
											var docWindow = this.getApplicanthealthinformationdocumentlist();
											var ID = record.data.id;
											if (!docWindow) {
												docWindow = Ext.widget('applicanthealthinformationdocumentlist',{
													itemId:'applicanthealthinformationdocumentlist'
												});
											}
											docWindow.show();
											var applicanthealthinformationdocumentlist = docWindow.down('#applicanthealthinformationdocumentlistgridItemId');
											 var store = applicanthealthinformationdocumentlist.getStore();
											  store.getProxy().extraParams = {
			             						  ID: record.data.id
			             					  };
			             					  store.load();
										}
								}
							}
							if(columnName == "applicantHealthDocumentUrl"){
								if(e.target.tagName=='A'){
									if(record.data.applicantHealthDocumentUrl.length == 1){
										
									} else if(record.data.applicantHealthDocumentUrl.length > 1){    	
											var docWindow = this.getApplicanthealthinformationdocurllist();
			             					  var ID = record.data.id;
			             					  	             					  
			             					 if (!docWindow) {
												docWindow = Ext.widget('applicanthealthinformationdocurllist',{
													itemId:'applicanthealthinformationdocurllist'
												});
			             					 }
											docWindow.show();
											
											var applicanthealthinformationdocurllistgrid = docWindow.down('#applicanthealthinformationdocurllistgridItemId');
											 var store = applicanthealthinformationdocurllistgrid.getStore();
											  store.getProxy().extraParams = {
			             						  ID: record.data.id
			             					  };
			             					  store.load();
										}
								  }
								}
						}
        	        },
        	        'applicanthealthinformationgrid[itemId=applicantHealthInformationGridItemId] button[itemId=btnEdit]': {
    	            	click: function(){
    	            		var $this = this;
    	            		$this.isAdd=false;
    	            		this.editApplicantHealthInformationDetailFormWindow('HEALTH_INFORMATION', 'applicantHealthInformationFormItemId', '#applicantHealthInformationGridItemId');
    	            		this.applicantDocHealthInformationContainerWindow();
    	            		this.applicantUrlHealthInformationContainerWindow();
    	            	}
    	            },
    	            'applicanthealthinformationgrid[itemId=applicantHealthInformationGridItemId] button[itemId=btnView]': {
    	            	click: function(){
    	            		var $this = this;
    	            		$this.isAdd=false;
    	            		$this.viewApplicantHealthInformationDetailFormWindow('HEALTH_INFORMATION', 'applicantHealthInformationFormItemId','#applicantHealthInformationGridItemId');
    	            		$this.applicantDocHealthInformationContainerWindow();
    	            		$this.applicantUrlHealthInformationContainerWindow();
    	            	}
    	            },
        	        
        	    	'applicanthealthinformationdocumentlistgrid button[itemId=btnDelete]':{
         				click:function(obj){
         					var $this=this;
         					var form = $this.getApplicanthealthinformationdocumentlist();  
         					var applicanthealthinformationgrid= $this.getApplicanthealthinformationgrid();
         					var applicanthealthinformationdocumentlistgrid=form.down('#applicanthealthinformationdocumentlistgridItemId');
         					if (applicanthealthinformationdocumentlistgrid.getSelectionModel().getCount() > 0) {
         						var records = applicanthealthinformationdocumentlistgrid.getSelectionModel().getSelection();
         						var ids=[];
         						Ext.Array.each(records,function(value){
         							ids.push(value.data.id);
         						});
         							showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'),function(btn,text){
         							if (btn == 'yes'){
         								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         								Ext.Ajax.request({
         									method: "DELETE",
         									type: 'rest',
         									url : SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_DOC_DELETE+'?fileDocumentIds='+ids.join(),
         									headers: {
         										'Content-Type': 'application/json'
         									},
         									success: function(form, action) {

         										Ext.getBody().unmask();
         										showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
         										applicanthealthinformationdocumentlistgrid.store.reload();
         										applicanthealthinformationgrid.store.reload();
         										applicanthealthinformationdocumentlistgrid.getSelectionModel().deselectAll(true);
         									}
         								});
         							}
         						});
         					} else {
         						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
         					}
         				}
        	      	},
        	      	
					'applicanthealthinformationdocumentlistgrid button[itemId=downloadDocumentItemId]':{
						click:function(obj){
							var $this = this;
							var form = $this.getApplicanthealthinformationdocumentlistgrid();
//							var StudentVisaDetailActionGrid=form.down('#studentvisadocumentlistgridItemId');
							var ApplicantHealthDetailActionGrid=obj.up('grid');
							if (ApplicantHealthDetailActionGrid.getSelectionModel().getCount() > 0) {
								var records = ApplicantHealthDetailActionGrid.getSelectionModel().getSelection();
								var dispatchZipName = "Applicant Health Information Document";
								var saveModel=[];  
								for(var i in records){
									if(!isNullOrEmpty(records[i].get('path'))) {
										saveModel.push(records[i].get('path'));
									}
									showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),
											getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS_ALERT'),
											function(btn, text) {
										if (btn == 'yes') {
											var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
											$this.getController('Academia.controller.document.DocumentController')
											.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
										}
									});
								}
							}
							else {
								$this.hideWindowMask();
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
		     	 },
		     	 'applicanthealthinformationdocumentlistgrid':{
						render: function(grid) {
							var this$ = this;
			            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_HEALTH_INFORMATON_DOCUMENT_PERMISSION());
			            	grid.down('#downloadDocumentItemId').setVisible(true);
						},
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(columnName == "documentName"){
								if(e.target.tagName=='A'){
									var documentId=record.get('ecrptydocumentId');
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
													showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('DOWNLOAD_HEALTH_DOCUMENT_SUCCESSFULLY'));
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
								}
							}
						}
					},
					 'applicanthealthinformationdocurllistgrid':{
						 render: function(grid) {
							 var this$ = this; 
							 this$.doAccessControlValidation(grid, this$.getAPPLICANT_HEALTH_INFORMATON_URL_PERMISSION());
						 }
					 },
               	 
        	      	'applicanthealthinformationdocurllistgrid button[itemId=btnDelete]':{
        				click:function(obj){
        					var $this=this;
        					var form = $this.getApplicanthealthinformationdocurllist();  
        					var applicanthealthinformationgrid= $this.getApplicanthealthinformationgrid();
        					var applicanthealthinformationdocurllistgrid=form.down('#applicanthealthinformationdocurllistgridItemId');
        					if (applicanthealthinformationdocurllistgrid.getSelectionModel().getCount() > 0) {
        						var records = applicanthealthinformationdocurllistgrid.getSelectionModel().getSelection();
        						var ids=[];
        						Ext.Array.each(records,function(value){
        							ids.push(value.data.id);
        						});
        							showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
        							if (btn == 'yes'){
        								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        								Ext.Ajax.request({
        									method: "DELETE",
        									type: 'rest',
        									url : SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_URL_DELETE+'?fileDocumentIds='+ids.join(),
        									headers: {
        										'Content-Type': 'application/json'
        									},
        									success: function(form, action) {

        										Ext.getBody().unmask();
        										showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),getCommonTranslation('URL_SUCCESS_MSG'));	 
        										applicanthealthinformationdocurllistgrid.store.reload();
        										applicanthealthinformationgrid.store.reload();
        										applicanthealthinformationdocurllistgrid.getSelectionModel().deselectAll(true);
        									}
        								});
        							}
        						});
        					} else {
        						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        					}
        				}
               		},
					'applicanthealthinformationdocumentgrid' : {
							 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
								 var $this = this;
								 var documentGrid = $this.getApplicanthealthinformationdocumentgrid();
								 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
								 if (columnName == "documentName") {
									 if (e.target.tagName == 'A') {
										 var documentId = record.get('ecrptydocumentId');
										 if (!isNullOrEmpty(documentId)) {
											 Ext.Ajax.request({
												 type: 'rest',
												 url: SERVERURL.CHECK_WHETHER_FILE_FOUND + documentId,
												 method: 'GET',
												 callback: function(opt, success, response) {
													 if (response.responseText == 'true') {
														 var csvForm = Ext.create('Ext.form.Panel');
														 csvForm.getForm().submit({
															 target: '_blank',
															 method: 'GET',
															 params: {
																 access_token: Ext.Ajax.defaultHeaders.access_token
															 },
															 headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
															 url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
															 standardSubmit: true
														 });
														 showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('DOWNLOAD_HEALTH_DOCUMENT_SUCCESSFULLY'));
													 } else {
														 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
													 }
												 }
											 });
										 }
									 }
								 }
							 }
						 },
						 'onlinepaymentgrid[itemId=onlinepaymentgridid] button[itemId=sendPayLinkBtn]': {
							 click: function() {
								 var billIdsArray = [];
								 var grid = this.getOnlinepaymentgrid();
								 var gridRec=grid.getSelectionModel().getSelection();
								 for( var i = 0; i < gridRec.length; i++) {
									 billIdsArray.push(gridRec[i].data.billHeaderId);
								 }
								 var json ={
										 billIds : billIdsArray,
										 applicationUrl : window.location.href,
										 isForApplicant:true
								 };
								 var jsonData = Ext.encode(json);
								 Ext.Ajax.request({
									 method : "POST",
									 type : 'rest',
									 url: SERVERURL.PATH_FIND_PAYMENT_LINK,
									 jsonData:jsonData,
									 headers : {
										 'Content-Type' : 'application/json'
									 },
									 success: function(response) {
										 if(response.responseText=='SUCCESS'){
											 showOkWithSuccessMessage(getFeeAndPaymentCommonTranslation('PAYMENTS'),getFeeAndPaymentCommonTranslation('THE_PAYMENT_LINKS_SENT_ON_EMAIL_SUCCESSFULLY_FOR_SELECTED_RECORD'));
										 }else if(response.responseText=='LIMIT_EXCEED'){
											 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('MORE_THAN_10_BILLS_SELECTIONS_FOR_SINGLE_STUDENT_ARE_RESTRICTED'));
										 }else{
											 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('SOMETHING_WENT_WRONG_IN_SENDING_PAYMENT_LINK'));
										 }
									 }
								 });
							 }
						 }
	              });
    },
    
    
    applicantDocEducationHistoryContainerWindow: function(){
	   	var applicantDocGrid = Ext.ComponentQuery.query('applicanteducationhistorydocumentgrid');
	       
	       var $this = this;
	       var store = applicantDocGrid[0].store;
	       
	       var portalId = this.getCurrentLoggedPortalId();  	
	       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
	       	var personInfoPanel  = this.getApplicanteducationdetailsgrid();
	   		var selectedRec = personInfoPanel.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicantDocEducationHistoryGrid = this.getApplicanteducationhistorydocumentgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicantDocEducationHistoryGrid.isHidden()) {
	   							applicantDocEducationHistoryGrid.setVisible(true);
	   						}
	   					}					
	   				}
	   			});
	       	
	       }else{
	       	var contentPanelTab = this.getContentPanelActiveTab();
	       	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	   		var a  = personInfoPanel.down('applicanteducationdetailsgrid');
	   		var selectedRec = a.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicantDocEducationHistoryGrid = this.getApplicanteducationhistorydocumentgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicantDocEducationHistoryGrid.isHidden()) {
	   							applicantDocEducationHistoryGrid.setVisible(true);
	   						}
	   					}					
	   				}
	   			});
	       }
	   },	
	   
	   applicantUrlEducationHistoryContainerWindow: function(){
	   	var applicantUrlGrid = Ext.ComponentQuery.query('applicanteducationhistoryurlgrid');
	       
	       var $this = this;
	       var store = applicantUrlGrid[0].store;
	       var portalId = this.getCurrentLoggedPortalId();  	
	       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
	       	var personInfoPanel  = this.getApplicanteducationdetailsgrid();
	           var selectedRec = personInfoPanel.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicantUrlEducationHistoryGrid = this.getApplicanteducationhistoryurlgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicantUrlEducationHistoryGrid.isHidden()) {
	   							applicantUrlEducationHistoryGrid.setVisible(true);
	   						}	  											
	   					}
	   				}
	   			});
	       	
	       }else{
	       	var contentPanelTab = this.getContentPanelActiveTab();
	   		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	   		var a  = personInfoPanel.down('applicanteducationdetailsgrid'); 	
	           var selectedRec = a.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicantUrlEducationHistoryGrid = this.getApplicanteducationhistoryurlgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicantUrlEducationHistoryGrid.isHidden()) {
	   							applicantUrlEducationHistoryGrid.setVisible(true);
	   						}	  											
	   					}
	   				}
	   			});
	       }
	   },
	   
	   applicantLanguageDocWindow: function(){
		   	var applicantDocGrid = Ext.ComponentQuery.query('applicantlanguagedocdetailgrid');
		       
		       var $this = this;
		       var store = applicantDocGrid[0].store;
		       
		       var portalId = this.getCurrentLoggedPortalId();  	
		       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
		       	var personInfoPanel  = this.getApplicantlanguageinformationgrid();
		   		var selectedRec = personInfoPanel.getSelectionModel();
		   		if (portalId == 2){
     	            store.getProxy().extraParams = {
     	            	ID: selectedRec.getSelection()[0].data.id
     	    		};
         		} else {
		           	store.getProxy().extraParams = {
		   			  ID: selectedRec.getSelection()[0].data.id
		   			};
         		}
		           	var applicantlanguagedocdetailgrid = this.getApplicantlanguagedocdetailgrid();
		   			store.load({
		   				callback:function() {
		   					if(store.getCount()) {
		   						if (applicantlanguagedocdetailgrid.isHidden()) {
		   							applicantlanguagedocdetailgrid.setVisible(true);
		   						}
		   					}					
		   				}
		   			});
		       	
		       }else{
		       	var contentPanelTab = this.getContentPanelActiveTab();
		       	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		   		var a  = personInfoPanel.down('applicantlanguageinformationgrid');
		   		var selectedRec = a.getSelectionModel();
		           	store.getProxy().extraParams = {
		   			  ID: selectedRec.getSelection()[0].data.id
		   			};
		        	var applicantlanguagedocdetailgrid = this.getApplicantlanguagedocdetailgrid();
		   			store.load({
		   				callback:function() {
		   					if(store.getCount()) {
		   						if (applicantlanguagedocdetailgrid.isHidden()) {
		   							applicantlanguagedocdetailgrid.setVisible(true);
		   						}
		   					}					
		   				}
		   			});
		       }
		   },	
		   
		    applicantLanguageUrlContainerWindow: function(){
		   	var applicantUrlGrid = Ext.ComponentQuery.query('applicantlangurlgrid');
		       
		       var $this = this;
		       var store = applicantUrlGrid[0].store;
		       var portalId = this.getCurrentLoggedPortalId();  	
		       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
		       	var personInfoPanel  = this.getApplicantlanguageinformationgrid();
		           var selectedRec = personInfoPanel.getSelectionModel();
		           if (portalId == 2){
	      	            store.getProxy().extraParams = {
	      	            	ID: selectedRec.getSelection()[0].data.id
	      	    		};
	          		} else {
		           	store.getProxy().extraParams = {
		   			  ID: selectedRec.getSelection()[0].data.id
		   			};
	          		}
		           	var applicantlangurlgrid = this.getApplicantlangurlgrid();
		   			store.load({
		   				callback:function() {
		   					if(store.getCount()) {
		   						if (applicantlangurlgrid.isHidden()) {
		   							applicantlangurlgrid.setVisible(true);
		   						}	  											
		   					}
		   				}
		   			});
		       	
		       }else{
		       	var contentPanelTab = this.getContentPanelActiveTab();
		   		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		   		var a  = personInfoPanel.down('applicantlanguageinformationgrid'); 	
		           var selectedRec = a.getSelectionModel();
		           	store.getProxy().extraParams = {
		   			  ID: selectedRec.getSelection()[0].data.id
		   			};
		           	var applicantlangurlgrid = this.getApplicantlangurlgrid();
		   			store.load({
		   				callback:function() {
		   					if(store.getCount()) {
		   						if (applicantlangurlgrid.isHidden()) {
		   							applicantlangurlgrid.setVisible(true);
		   						}	  											
		   					}
		   				}
		   			});
		       	
		       }
		   },
    
    applicantDocHealthInformationContainerWindow: function(){
	   	var applicantDocGrid = Ext.ComponentQuery.query('applicanthealthinformationdocumentgrid');
	       
	       var $this = this;
	       var store = applicantDocGrid[0].store;
	       
	       var portalId = this.getCurrentLoggedPortalId();  	
	       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
	       	var personInfoPanel  = this.getApplicanthealthinformationgrid();
	   		var selectedRec = personInfoPanel.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicanthealthinformationdocumentgrid = this.getApplicanthealthinformationdocumentgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicanthealthinformationdocumentgrid.isHidden()) {
	   							applicanthealthinformationdocumentgrid.setVisible(true);
	   						}
	   					}					
	   				}
	   			});
	       	
	       }else{
	       	var contentPanelTab = this.getContentPanelActiveTab();
	       	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	   		var a  = personInfoPanel.down('applicanthealthinformationgrid');
	   		var selectedRec = a.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	        	var applicanthealthinformationdocumentgrid = this.getApplicanthealthinformationdocumentgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicanthealthinformationdocumentgrid.isHidden()) {
	   							applicanthealthinformationdocumentgrid.setVisible(true);
	   						}
	   					}					
	   				}
	   			});
	       }
	       
			
	      },	
	   
	    applicantUrlHealthInformationContainerWindow: function(){
	   	var applicantUrlGrid = Ext.ComponentQuery.query('applicanthealthinformationurlgrid');
	       
	       var $this = this;
	       var store = applicantUrlGrid[0].store;
	       var portalId = this.getCurrentLoggedPortalId();  	
	       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
	       	var personInfoPanel  = this.getApplicanthealthinformationgrid();
	           var selectedRec = personInfoPanel.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicanthealthinformationurlgrid = this.getApplicanthealthinformationurlgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicanthealthinformationurlgrid.isHidden()) {
	   							applicanthealthinformationurlgrid.setVisible(true);
	   						}	  											
	   					}
	   				}
	   			});
	       	
	       }else{
	       	var contentPanelTab = this.getContentPanelActiveTab();
	   		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	   		var a  = personInfoPanel.down('applicanthealthinformationgrid'); 	
	           var selectedRec = a.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var applicanthealthinformationurlgrid = this.getApplicanthealthinformationurlgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (applicanthealthinformationurlgrid.isHidden()) {
	   							applicanthealthinformationurlgrid.setVisible(true);
	   						}	  											
	   					}
	   				}
	   			});
	       	
	       }
	   },
    disableMedicalDetailFormPivileges: function(formReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        //associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        var saveBtn = formReference.down('#submitButtonId');
        saveBtn.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'SAVE') {
                if (!isNullOrEmpty(saveBtn)) {
                    saveBtn.setVisible(true);
                }
            }

        });
    },
    disableSocioDetailFormPivileges: function(formReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        //associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        var saveBtn = formReference.down('#submitButtonId');
        saveBtn.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'SAVE') {
                if (!isNullOrEmpty(saveBtn)) {
                    saveBtn.setVisible(true);
                }
            }

        });
    },
    processVaccinationInfoDetailsWindow: function(buttonAction){
    	
    	if( buttonAction == 'btnView' || buttonAction == 'btnEdit' ){
	    	var vaccinationInfodocumentGrid = Ext.ComponentQuery.query('applicantvaccinationinfodocumentgrid');
	        
	        var $this = this;
	        var store = vaccinationInfodocumentGrid[0].store;
	         	
	        var a = Ext.ComponentQuery.query('[itemId=applicantVaccinationGrid]');
	        var currentId = 0;
	        if(a.length > 0){
	        	l = a[0].getSelectionModel().selected;
	        	if(l != undefined){
	        		if( l.items != undefined && l.items.length > 0 ){
	        			if( l.items[0].data != undefined ){
	        				if( l.items[0].data.id != undefined ){
	        					currentId = l.items[0].data.id;
	        				}
	        			}
	        		}
	        	}
	        }
	         	
	        if( currentId != 0 ){
	        	store.getProxy().extraParams = {
				  ID: currentId
				};
	        	//var proxy = store.getProxy();
				//var newApi =  {read: SERVERURL.APPLICANT_VACCINATION_INFO_DOCUMENT_FIND_BY_ID};
				//Ext.apply(proxy.api,newApi);
				store.load();
				var vaccinationInfoDocGrid = $this.getApplicantvaccinationinfodocumentgrid();
				if (vaccinationInfoDocGrid.isHidden() /*&& store.data.items.length > 0*/) {
					vaccinationInfoDocGrid
					.setVisible(true);
				}	  					
	        }
    	  }
    	
  		  if(buttonAction == 'btnView'){
	          var a = Ext.ComponentQuery.query("personcommonwindow");
	  		  if( a != undefined & a.length > 0){
	  			  a[0].down("#cancelButtonId").setVisible(false);
	  			  a[0].down("#submitButtonId").setVisible(false);
	  			  a[0].down("#uploadVaccinationItemId").setVisible(false);
	  		  }
	  		  var b = this.getApplicantvaccinationinfodocumentgrid();
	  		  if(b != undefined){
	  			b.down("#btnDelete").setVisible(false); 
	  		  }
  		  }
    },
    /**
     *  To display container in view only mode
     */
    showContainerInViewMode: function(container) {
    	var me = this;
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e){
        		applicantProfile = me.getContentPanel().items.items[0];
        	}
        	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        		if(applicantProfile.getApplicationInfo()['isViewMode'] 
        		   || !isNullOrEmpty(applicantProfile.getApplicationDataObject()['existingStudentId'])        				   
        		   || ((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
        			   	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
        			   	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION'))	
        		   ){
            		me.mixins.ApplicationBaseController.setContainerInViewMode(container);
            	}        		
        	}
        }    
   },
   
   printButtonAction:function(){
	   var $this = this;
	   user=$this.getCurrentlyLoggedInUser();
	   var code ="ApplicationSummaryReport"; 
	   //var applicantProfile = $this.getContentPanelActiveTab();
	   var applicantProfile = Ext.ComponentQuery.query('applicantprofile')[0];
	   var reportParams =new Object();
	   var title= applicantProfile.applicationDataObject.person.printName+"-"+ new Date().getTime();
	   reportParams.reportTitle=title;
	   reportParams.userId=user.code;
	   reportParams.applicationId=String(applicantProfile.getApplicationId());
	   reportParams.applicantPersionId = applicantProfile.applicationDataObject.person.id;
	   reportParams.academyLocationId = $this.getCurrentAcademyLocation();
	   reportParams.code = code;
	   
	   $$this = Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	   var returnJson = new Object();
	   returnJson = $$this.getAllPermissions();
	  
	   reportParams.isAddress = returnJson.map.isAddress;
	   reportParams.isParentAndGuardian = returnJson.map.isParentAndGuardian;
	   reportParams.isIdentity = returnJson.map.isIdentity;
	   reportParams.isPNC = returnJson.map.isPNC;
	   reportParams.isEducation = returnJson.map.isEducation;
	   reportParams.isCompetitive = returnJson.map.isCompetitive;
	   reportParams.isWorkExp = returnJson.map.isWorkExp;
	   reportParams.isReceiptPayment = returnJson.map.isReceiptPayment;
	   reportParams.isDocument = returnJson.map.isDocument;
	   reportParams.isMedical = returnJson.map.isMedical;
	   reportParams.isVaccination = returnJson.map.isVaccination;
	   reportParams.isExtracurricularActivity = returnJson.map.isExtracurricularActivity;
	   reportParams.isApplicationDetail = returnJson.map.isApplicationDetail;
	   reportParams.isApplicationRef = returnJson.map.isApplicationRef;
	   reportParams.isMidTermAdmission = returnJson.map.isMidTermAdmission;
	   reportParams.isAdmissionDetails = returnJson.map.isAdmissionDetails;
	   reportParams.isSiblingDetails = returnJson.map.isSiblingDetails
	   reportParams.isFeePayerDetail = returnJson.map.isFeePayerDetail;
	   reportParams.isFeePlan = returnJson.map.isFeePlan;
	   reportParams.isServiceOptIn = returnJson.map.isServiceOptIn;
	   reportParams.isCommunityOptIn = returnJson.map.isCommunityOptIn;
	   
	   var exportUrl = SERVERURL.PATH_PRINT_APPLICATION;
	   $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);

   },
   
   /**
     * View payment recieved history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
   viewPaymentRecievedHistoryForApplicant: function(informationType, windowXType, gridItemId, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			receiptHeaderId : record.get('id')
        	};
        	var gridWindow = formWindow.down('grid');
        	var portalId = this.getCurrentLoggedPortalId();
			 setTimeout(function(){
			 var gridColumns=gridWindow.columns;
				 var length = gridColumns.length;
				 if(length != null && length != ""){
					 for(var i = 0; i < length; i++){
						 if(portalId!=1 || personProfile.xtype == "applicantprofile")
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(false);
								 gridColumns[i].destroy();

							 }
						 }else
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(true);
							 }
						 }
					 }
				 } 
			 },300);
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load();
            
        } else {
            showWarningMessage(getPersonModuleTranslation('PAYMENT_RECEIVED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
      * View payment recieved history for Applicant Profile
      *  @param informationType
      *  @param formItemId
      *  @param gridItemId
      *  @param url
      */
    viewPaymentRecievedHistoryForApplicantProfile: function(informationType, windowXType, gridItemId, url) {

         var this$ = this;
         var personProfile = this$.getContentPanelActiveTab();
         var grid = personProfile.down(gridItemId);

         if (grid.getSelectionModel().getCount() > 0) {
         	var record = grid.getSelectionModel().getSelection()[0];
         	var formWindow = Ext.widget(windowXType);
         	formWindow.show();
         	var params = {
         			receiptHeaderId : record.get('id'),
         			screen:'profile'
         	};
         	var gridWindow = formWindow.down('grid');
         	var store = gridWindow.getStore();
             store.getProxy().api.read = url;
             store.getProxy().extraParams = params;
             store.load();
             
         } else {
             showWarningMessage(getPersonModuleTranslation('PAYMENT_RECEIVED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
     },
    
    onlinePaymentApplicantPortalGridCellClick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ){
    	if(cellIndex == 0 && e.getTarget().className == "x-grid-row-checker"){
    		if ((record.data.whetherActive == true && record.data.whetherChecked == true) 
    				||(record.data.whetherActive == false && record.data.whetherChecked == false)) {
    			grid.getSelectionModel().doDeselect(record);
    		}
    		if (record.data.whetherActive == true && record.data.whetherChecked == false) {
    			grid.getSelectionModel().doSelect(record,true);
    		}
    	}else{
    		return false;
    	}
    	if (record.data.whetherActive == false ) {
    		grid.getSelectionModel().allowSelect=false;
    	}
    },
    /** Disable More Action Privileges button */
    disableMoreActionPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        buttonsToolBar = gridReference.query('toolbar')[0];
        var splitbuttons = buttonsToolBar.query('splitbutton')[0];

        var btnViewButton = gridReference.down('#btnView');
        btnViewButton.setVisible(false);
        var sendPayLinkBtn = gridReference.down('#sendPayLinkBtn');
        sendPayLinkBtn.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'MAKE_PAYMENT') {
                if (!isNullOrEmpty(btnViewButton)) {
                	btnViewButton.setVisible(true);
                }
            }else if (privilege === 'SEND_PAYMENT_LINK') {
				if(!isNullOrEmpty(sendPayLinkBtn)){
					sendPayLinkBtn.setVisible(true);
				}        		
			}
        });
    },
    
    exportJRXML: function(fileType) {
    	// code to get selected row
    	var $this = this;
    	var selectedId = [];
    	var grid = $this.getActiveTabfromContentPanel().down('receiptgridforapplicant');
 		if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
    		for(var i in record) {
    			selectedId.push(record[i].get('id'));
    		}
 		}
 		
 		user=$this.getCurrentlyLoggedInUser();
    	
 		var code;
        var exportUrl;
        if(grid.xtype=='receiptgridforapplicant'){
            var record = grid.getSelectionModel().getSelection();
            if(!isNullOrEmpty(record)&&record[0].data.status=='FULLY_PENDING'){
                 code ="MANAGE_RECEIPT_CODE";
                 var exportUrl = SERVERURL.MANAGE_RECEIPT_PDF;
            }else{
                 code ="MANAGE_RECEIPT_SETTLEMENT_CODE";
                 var exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF_OPTIMISED;
            }
            
        }else{
            code ="MANAGE_RECEIPT_STUDENT_CODE";
            exportUrl = SERVERURL.MANAGE_RECEIPT_PDF;
        }
    	// code to identify jasper
        //var code ="MANAGE_RECEIPT_STUDENT_CODE";
        
        var reportParams =new Object();
        reportParams.applicantIds=String(record[0].data.applicationId);
        reportParams.userId=user.code;
        reportParams.ids=String(selectedId); // convert int into string
        var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
        //var exportUrl = SERVERURL.MANAGE_RECEIPT_PDF;
        
        var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
        store.getProxy().extraParams={
        	code:code
        };
        store.load({
        	callback:function(rec,obj,success){
        		if(obj.response.responseText=="true"){
        			$this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
        		}else{
        			showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
        		}
  			}
        });
    },
    
    /** Receipt print button Privileges button */
    receiptPrintBtnPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        //buttonsToolBar = gridReference.query('toolbar')[0];
        //var splitbuttons = buttonsToolBar.query('splitbutton')[0];

        var btnViewButton = gridReference.down('#btnPrint');
        btnViewButton.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'PRINT') {
                if (!isNullOrEmpty(btnViewButton)) {
                	btnViewButton.setVisible(true);
                }
            }
        });
    },
    loadYearData : function(cmb){
    	var records= new Array ();
    	var currentYear = Ext.Date.format(new Date(), 'Y');
    	for(var num = currentYear ;num >=1950; num--){
    		records.push({
                value: num,
                id : num.toString()
            });
    	}
    	var store = cmb.getStore();
    	store.loadData(records);
    },
    changeAndSetYearMonthData:function(obj,value){
    	var getYearValue = Ext.Date.format(new Date(value), 'Y');
    	var getMonthValue = Ext.Date.format(new Date(value), 'm');
    	var $this = this;
    	var getEducationForm = $this.getPersonEducationForm();
    	var getMonthField = getEducationForm.down('#monthItemId');
    	var getYearField = getEducationForm.down('#yearItemId');
    	var getMonthOfExamination = getEducationForm.down('#monthOfExamination');
    	var getYearOfExamination = getEducationForm.down('#yearOfExamination');
    	
    	getMonthField.getStore().load({
			   callback: function(records, operation, success) {
				   for(var i in records){
					   if(records[i].data.id==getMonthValue){
						   getMonthField.setValue(records[i].data.value);
					   }
				   }
			   }	   
		   });
    	
    	getYearField.setValue(getYearValue);
    },
    loadYearDataOfComExam : function(cmb){
    	var records= new Array ();
    	var currentYear = Ext.Date.format(new Date(), 'Y');
    	for(var num = currentYear ;num >=1950; num--){
    		records.push({
                value: num,
                id : num.toString()
            });
    	}
    	var store = cmb.getStore();
    	store.loadData(records);
    },
    changeAndSetYearMonthDataOfComExam:function(obj,value){
    	var getYearValue = Ext.Date.format(new Date(value), 'Y');
    	var getMonthValue = Ext.Date.format(new Date(value), 'm');
    	var $this = this;
    	var getComExamForm = $this.getPersonCompetitiveExamForm();
    	var getMonthField = getComExamForm.down('#monthItemId');
    	var getYearField = getComExamForm.down('#yearItemId');
    	
    	getMonthField.getStore().load({
			   callback: function(records, operation, success) {
				   for(var i in records){
					   if(records[i].data.id==getMonthValue){
						   getMonthField.setValue(records[i].data.value);
					   }
				   }
			   }	   
		   });
    	
    	getYearField.setValue(getYearValue);
    },
    setYearOfEaxmDateMinvalue:function(obj){
    	var getYearValue = Ext.Date.format(new Date(), 'Y-m-d');
    	//var getCurrentLastYearValue = getYearValue+'/12/31/';
    	obj.setMinValue(Ext.Date.format(new Date('1950/01/01'), 'Y-m-d'));
    	obj.setMaxValue(Ext.Date.format(new Date(getYearValue), 'Y-m-d'));
    	
    },
    getCheckedReceiptForApplicant: function(selmodel, record, index, action){
 	   var grid = null;
 	   var $this = this;
 	  // var grid = $this.getReceiptgridforapplicant();
 	  var grid = $this.getActiveTabfromContentPanel().down('receiptgridforapplicant');
 	   if(action == 'select'){
 		   if(selmodel.selected.length >= 1){
 			   grid.down('#btnPrint').setDisabled(false);
 		   }
 	   } else {
 		   if(selmodel.selected.length == 0){
 			   grid.down('#btnPrint').setDisabled(true);
 		   }
 	   }
    },
    doPaymentModeValidation: function(form,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var payTypeId = form.down("#payTypeId");
    	var paymentHeaderId = form.down("#paymentHeaderId");
    	var onlineMode = form.down("#onlineModeId");
    	var offlineMode = form.down("#offlineModeId");
    	var isOnline = false;
    	var isOffline = false;
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'ONLINE_PAYMENT_MODE') {
    			if(!isNullOrEmpty(payTypeId)){
    				isOnline = true;
    			}        		
    		}
    		if (privilege === 'OFFLINE_PAYMENT_MODE') {
    			if(!isNullOrEmpty(payTypeId)){
    				isOffline = true;
    			}        		
    		}
    	});
    	if(isOnline && isOffline){
	    	if(!isNullOrEmpty(payTypeId)){
	    		onlineMode.setValue(true);
	    		payTypeId.setVisible(true);
		    	paymentHeaderId.setVisible(true);
			}
	    }else if((!isOnline && !isOffline) || (isOnline && !isOffline)){
	    	onlineMode.setValue(true);
	    	payTypeId.setVisible(false);
	    	paymentHeaderId.setVisible(false);
	    }else {
	    	offlineMode.setValue(true);
	    	payTypeId.setVisible(false);
	    	paymentHeaderId.setVisible(false);
	    }
    },
    applicantCheckSelectDate:function(){
    	//var form = this.getCommunicationhistorystructure();
		//var grid =  this.getCommunicationhistorylist();
    	 var personProfile = this.getContentPanelActiveTab();
		var form = personProfile.down('communicationhistorystructure');
    	var grid = personProfile.down('communicationhistorylist');
    	if(isNullOrEmpty(form)) {
			form = personProfile.down('form');
		}
		var eventDateForm=form.down("#eventDateForm").getValue();
		var eventDateTill=form.down("#eventDateTill").getValue();
    },
    openSendMessageReportLink: function(record){
		var id = record.get('msgRcpntLogId');
		if(!isNullOrEmpty(id)){
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_FIND_MSG_CONTENT_BY_MSG_RCPNTLOG_ID,													 
				method: 'GET',
				async: false,
				headers: {
					'Content-Type': 'application/json'
				},
				params: {
					id: id
				},
				success: function(response, form, action) {
					responseObject = eval("(" + response.responseText + ")"); //make object of response text
					var msgContent = responseObject.msgContent;

					var win = new Ext.Window({
						title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
						frame: true,
						height : 500,
						minWidth:200,
						autoScroll:true,
						modal:true,
						html: msgContent,
					});
					win.show();

				},
				failure: function(form, action) {
					//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
				}
			});
		}
	},
	openAttachedDocumentLink: function(record){
		var $this = this;
		var id = record.get('msgRcpntLogId');
		if(!isNullOrEmpty(id)){
			var isWhetherSysMsgEvent = false;
			var eventName = record.get('eventName');
			if(!isNullOrEmpty(eventName)){
				isWhetherSysMsgEvent = true;
			}

			var formWindow = $this.getSendmessageattacheddocumentwin();
			if (!formWindow) {
				formWindow = Ext.widget('sendmessageattacheddocumentwin',{
        			itemId:'applicantsendmessageattacheddocumentwin'
        		});
			}
			formWindow.show();
			var documentGrid = formWindow.down('#sendMessageDocumentGridItemId');
			documentGrid.getStore().getProxy().extraParams = {
				id: id,
				whetherSysMsgEvent:isWhetherSysMsgEvent
			};
			documentGrid.getStore().load();
		}
	},
	downloadAttachedDocumentFile : function(documentId,isWhetherSysMsgEvent,staticDocOfMSR){
    	if(!isNullOrEmpty(documentId)){
    		var csvForm = Ext.create('Ext.form.Panel'); 
	    	csvForm.getForm().submit({
		    	target: '_blank',
		    	method:'GET',
		    	params :{
		    		access_token : Ext.Ajax.defaultHeaders.access_token,
		    		id: documentId,
					whetherSysMsgEvent:isWhetherSysMsgEvent,
					staticDocOfMSR:staticDocOfMSR
		    	},
		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    	url: SERVERURL.PATH_DOWNLOAD_MSG_DOCUMENTS,
		    	standardSubmit :true
	    	});
    	}
    },
    exportXlsMsgSentReport : function() {
		var $this = this;
    	var form = $this.getCommunicationhistorystructure();
    	var grid =  this.getCommunicationhistorylist();
    	form=form.down('form');
		var values = form.getValues();
		var dt = new Date();
    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Message Sent Report"+"_"+dateString;
		var code = 'MESSAGE_SENT_EXCEL_EXPORT_REPORT';
		var reportHeader = "Message Sent Report";
	
		
		
		var sendMessage = form.down("#sendmessageId").getValue();
		//console.log(sendMessage);
		var recipient=form.down("#recipientName").getValue();
		var contactId=null;
		var sentbyName=form.down("#sentby").getValue();
		var eventNameCode=form.down("#eventName").getValue();
		var eventDateForm=form.down("#eventDateForm").getValue();
		var eventDateTill=form.down("#eventDateTill").getValue();
		var messageId=form.down("#sendmessageId").getValue();
		//var status=form.down("#statusComboMsgSendReport").getValue();
		if(messageId.sendMessage==1){
			contactId=form.down("#contactId").getValue();
			if(contactId==null){
				var contactIdComboStore=form.down("#contactId").getStore();
				var storeValue = contactIdComboStore.data.items;
				contactIdValue = storeValue[0].data.emailId;
        		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
        			contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
        		}
        		contactId=contactIdValue;
        		}
		}else{
			contactId=form.down("#mobileId").getValue();
			if(contactId==null){
				var contactIdComboStore=form.down("#mobileId").getStore();
				var storeValue = contactIdComboStore.data.items;
				contactIdValue = storeValue[0].data.mobileNumber;
        		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
        			contactIdValue=contactIdValue+","+storeValue[recordInt].data.mobileNumber;
        		}
        		contactId=contactIdValue;
        		}
		}
		
		
		if(recipient!=null){
			if(grid.getSelectionModel()!=null){
				if(grid.getSelectionModel().getStore().data.length>0){
					recipient=	grid.getSelectionModel().getStore().data.items[0].raw.recipientFullName
				}
			}
		}
	
		var reportParams = new Object();
		reportParams.fromDate = eventDateForm;
		reportParams.toDate = eventDateTill;
		reportParams.contactList = contactId;
		reportParams.sentBy = sentbyName;
		reportParams.eventName=eventNameCode;
		reportParams.recipientName=recipient;
		reportParams.deliveryModeId=sendMessage.sendMessage;
		reportParams.headerName = reportHeader;
		reportParams.status = status;
		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.MSG_SENT_EXCEL_REPORT);
    },
    showDFRManagedFields : function(form) {
    	var $this = this;
    	var institutionNameCombo = form.down('#institutionNameItemId');
    	var institutionName = form.down('#institutionNameTextFieldItemId')
    	var result = false;
    	var otherExist = false;
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		params: {
    			screenName: 'postschoolstudiesform',
    			academyLocationId: this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.postschoolstudiesform;
    				for(i in records){
    					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='institutionNameItemId'){
    						if(!isNullOrEmpty(records[i].defaultValue) && records[i].defaultValue.length>4){
    							var defaultValue = records[i].defaultValue.substring(0,4);
    							defaultValue = defaultValue.toUpperCase();
    							if(defaultValue==='OTHE'){
    								result=true;
    							}
    						}else{
    							if(records[i].isVisible==false && isNullOrEmpty(records[i].defaultValue)){
    								result=true;
    							}
    						}
    					}
    				}
    			}
    		}
    	});
    	if(result){
    		var institutionNameComboStore = institutionNameCombo.getStore();
    		institutionNameComboStore.load({
    			callback: function(records, operation, success) {
    				for(var i in records){
    					if(records[i].data.value.length>4){
    						var comboDiffaltValue = records[i].data.value.substring(0,4);
    						comboDiffaltValue = comboDiffaltValue.toUpperCase();
    						if(comboDiffaltValue==='OTHE'){
    							institutionNameCombo.setValue(records[i].data.id);
    							institutionName.setVisible(true);
    							otherExist=true;
    						}
    						if(!otherExist){
    							institutionName.setVisible(false);
    							institutionName.allowBlank=true
    							institutionNameCombo.reset();
    				    		institutionName.reset();
    						}
    					}
    				}
    			}	   
    		});

    	}else{
    		institutionName.setVisible(false);
			institutionName.allowBlank=true
    		institutionNameCombo.reset();
    		institutionName.reset();
    	}
    },
    loadDFRForNumberFieldValidation:function(form){
    	var $this = this;
    	var contactNumber=form.down('#familyPractionerContactNumberItemId');
    	var selectionGridStore = Ext.ComponentQuery.query('selectionsnapshotgrid')[0].getStore();
    	if(!isNullOrEmpty(selectionGridStore.data.items[0])){
    	    var PBsTId = selectionGridStore.data.items[0].data.programBatchSeatConfigurationId;
    	}
    	var formAlias = 'medicaldetailsform';
	    
    	Ext.Ajax.request({
				url: SERVERURL.PATH_FIND_APPLICANTPROFILE_DFR,
				method: 'GET',
				async: false,
				params: {
					programBatchSeatConfigurationId:PBsTId,
					formAliasName:formAlias
				},
				success: function(response) {
					if(!isNullOrEmpty(response.responseText))
					{
						if(!isNullOrEmpty(form.up('applicantprofile'))){
							form.up('applicantprofile').isApplicantPortalSetup = true;
						}
						var json = JSON.parse(response.responseText);
						var fieldInfo = Academia.model.authentication.FormPersonalInfoFieldInfoModel;
						fieldInfo.set("formPersonalInfoFieldsInfo", json);
						this$.formApplicantPersonalInfoFieldItems(form);
						contactNumber.setFieldLabel('');
					}else{
						Ext.Ajax.request({
				    		type: 'rest',
				    		async: false,
				    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
				    		params: {
				    			screenName: formAlias,
				    			academyLocationId: $this.getCurrentAcademyLocation(),
				    			languageCode:'en'
				    		},
				    		method: 'GET',
				    		success: function(res, action) {
				    			var response = Ext.decode(res.responseText);
				    			if( Object.keys(response).length > 0 ){
				    				var records=response.medicaldetailsform;
				    				if(records.length>0){
				    					for(i in records){  
				        					if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='familyPractionerContactNumberItemId' && records[i].isMandatory == true && records[i].isVisible==true){
				        					    contactNumber.setFieldLabel('');
				        					}
				        				}
				    				}
				    			}
				    		}
				    	});
					}
				}
			});
    	
    	
    	
    }
});
