/*
 * @author prathamesh.sheth
 * 
 * This controller is used for Pre Admission Payments,Pre Admission Refunds and Pre Admission Fee Plans tab.
 *    
 */
Ext.define('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController', {

    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    alias: "widget.preadmissionpaymentsrefundsandfeeplanscontroller",

    stores: ['admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentGridStore',
             'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissiontRefundGridStore',
             'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionFeePlanGridStore',
             'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.FeeHeadsCoveredStore',
             'examinationcenters.IsTemplateMappedStore'],

    views: ['admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsGrid',
            'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionRefundsGrid',
            'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionFeePlansGrid',
            'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.FeeHeadsCoveredWindow',
            'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.FeeHeadsCoveredGrid'],
            
    refs : [{
  	     ref: 'noOfConfigureFeeHeads',
         selector: 'searchresultgrid[itemId=noofconfigurefeeheadsId]'
     },{
    	 ref: 'preAdmissionPaymentsGrid',
         selector: 'preadmissionpaymentsgrid' 
     }],
     config: {
    	APPLICANT_PAYMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PAYMENT_PRIVILEGES'),
    	APPLICANT_REFUNDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_REFUNDS_PRIVILEGES'),
     	APPLICANT_FEEPLAN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_FEEPLAN_PRIVILEGES'),
     	APPLICANT_ONLINEPAYMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_ONLINEPAYMENT_PRIVILEGES'),
     	APPLICATION_RECEIPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_RECEIPT_PRIVILEGES'),
     	APPLICATIONS_NSFAS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATIONS_NSFAS_PRIVILEGES')
     },
     
    init: function(application) {
        this.control({
        	'grid[xtype=preadmissionpaymentsgrid]': {
        		render: function(grid) {
        			this.loadGrid(grid, 'applicationId');
        			this.doAccessControlValidation(grid, this.getAPPLICANT_PAYMENT_PERMISSIONS());
        		},
        		select :function($this, record, index){
        			this.getCheckedReceiptForApplicant($this, record, index, 'select');
        		},
        		deselect :function($this, record, index){
        			this.getCheckedReceiptForApplicant($this, record, index, 'deselct');
        		}
        	},
        	'grid[xtype=preadmissionrefundsgrid]': {
        		render: function(grid) {
        			this.loadGrid(grid, 'applicationId');
                }
        	}, 
        	'grid[xtype=preadmissionfeeplansgrid]': {
        		render: function(grid) {
        			this.loadGrid(grid, 'applicantId');
                },
        		cellclick: function( grid, td, cellIndex,record) {
        			var preadmissionfeeplansgrid = grid.up('grid');
        			var columnName = preadmissionfeeplansgrid.columnManager.columns[cellIndex].dataIndex;
        			if(columnName == 'noOfFeeHeads') {
        				this.showFeeHeadsCoveredWindow(record);
        			}
        		}
        	},
        	'grid[xtype=preadmissionpaymentsgrid] button[itemId=btnPrint]':{
 			   click : function(){
 				   var gridType = "applicant";
 				   this.exportJRXMLForPayment('pdf',gridType);
 			   }
 		   }
        });
    },

    loadGrid: function(grid, parameter) {
    	var applicantProfile = this.getContentPanelActiveTab();
        if (applicantProfile) {
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e){
        		applicantProfile = this.getContentPanel().items.items[0];
        	}
        	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        		var store = grid.getStore();
        		var url = store.getProxy().proxyConfig.api.read;
        		var parameterValue= null;
        		
        		switch(parameter) {
        		case 'applicationId':
        			parameterValue = applicantProfile.getApplicationId();
        			break;
        		case 'applicantId':
        			parameterValue = applicantProfile.getApplicationId();
        			break;
        		}
        		url = url.concat('?'+parameter+'='+ parameterValue);
                store.getProxy().api.read = url;
        		store.load();
        	}
        }
    },
    
    showFeeHeadsCoveredWindow: function(record) {
    	//var windowRef = Ext.widget('feeheadscoveredwindow');
    	var windowRef = Ext.widget('nooffeeconfigheadswin');
    	windowRef.show();
    	var params = "FEE_PLAN_RULE_ID";
    	var paramsData = record.data.feePlanRuleId;
    	var RESULT_GRID = this.getNoOfConfigureFeeHeads(); // getter of configurefeeheads
    	this.loadDynamicGridForFee(CONSTANTS.CB.FEE_CONFIGURE_HEAD_LIST_VIEWCODE,
    			CONSTANTS.CB.FEE_CONFIGURE_HEAD_LIST_CONFIGCODE,RESULT_GRID,params,paramsData);

    },
    loadDynamicGridForFee: function(respectiveLinkViewCode, respectiveLinkConfigCode,getResultGrid,params,paramsData,model, records) {
    	var searchResultGrid = getResultGrid; // getDynamic Result Grid
    	var paramCodes = params;
    	var searchData = paramsData;
    	var jsonFormatFormData = this.createJsonFormatForFee(paramCodes,searchData,respectiveLinkConfigCode,records);
    	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode); // CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_VIEWCODE);
    	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);

    },
    createJsonFormatForFee: function(paramCodes,searchData,respectiveLinkConfigCode,records) {
    	var values = new Object();
    	var searchcriteria = new Array();
    	values.configCode = respectiveLinkConfigCode;
    	if(searchData != "" && searchData != null){
    		searchcriteria.push({paramCode:paramCodes, paramValues:[searchData]});
    	}
    	values.searchCriterias = searchcriteria;
    	return values;
    },
    exportJRXMLForPayment: function(fileType,gridType) {
 	   var $this = this;
 	   var selectedId = [];
       var grid = this.getPreAdmissionPaymentsGrid();
       if (grid.getSelectionModel().getCount() > 0) {
    	   var record = grid.getSelectionModel().getSelection();
    	   for(var i in record) {
    		   selectedId.push(record[i].get('receiptHeaderId'));
    	   }
       }

 	   var user=$this.getCurrentlyLoggedInUser();
 	   //var code ="MANAGE_RECEIPT_CODE";
 	   var code ="MANAGE_RECEIPT_SETTLEMENT_CODE";

 	   var reportParams =new Object();
 	   reportParams.userId=user.code;
 	   reportParams.ids=String(selectedId); // convert int into string
 	   var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
 	   //var exportUrl = SERVERURL.MANAGE_RECEIPT_PDF;
 	   var exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF;
 	  if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true") {
      	code="MANAGE_RECEIPT_CODE";
      	reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
      	exportUrl=SERVERURL.MANAGE_RECEIPT_PDF
      }
 	  

 	   var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
 	   store.getProxy().extraParams={
 		   code:code
 	   };
 	   store.load({
 		   callback:function(rec,obj,success){
 			   if(obj.response.responseText=="true"){
 				   $this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl); //'examinationcenters.IsTemplateMappedStore'
 			   }else{
 				   showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
 			   }
 		   }
 	   });
    },
    getCheckedReceiptForApplicant: function(selmodel, record, index, action){
  	   var grid = null;
  	   var $this = this;
  	   var grid = $this.getPreAdmissionPaymentsGrid();
  	   if(action == 'select'){
  		   if(selmodel.selected.length >= 1){
  			   grid.down('#btnPrint').setDisabled(false);
  		   }
  	   } else {
  		   if(selmodel.selected.length == 0){
  			   grid.down('#btnPrint').setDisabled(true);
  		   }
  	   }
     }

});
