/**
 *  @author Amit Gupta
 */
Ext.define('Academia.controller.alumniManagementSystem.AlumniCommunicationHistoryController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['alumni.alumniList.AlumniIDNameStore','alumni.alumniList.AlumniEmailIdStore','alumni.alumniList.AlumniNotificationStore',
    	'alumni.alumniCommunicationHistory.AlumniCommunicationHistoryGridStore'   	
    ],
    views: [
    	'alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryStructure',
    	'alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryFilter',
    	'alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryGrid',
    ],
    models: [],
    config: {},
    refs: [{
        ref: 'alumnicommunicationhistoryfilter',
        selector: 'alumnicommunicationhistoryfilter'
    },{
        ref: 'alumnicommunicationhistorygrid',
        selector: 'alumnicommunicationhistorygrid'
    },{
    	ref: 'alumnicommunicationhistorystructure',
    	selector: 'alumnicommunicationhistorystructure'
    },{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }],
    init: function(application) {
        this.control({
            'alumnicommunicationhistoryfilter button[name=resetBtn]': {
            	click: function(cmp){
                    var me = this;
                    form = me.getAlumnicommunicationhistoryfilter();
                    form.getForm().reset();   
                    form.getForm().clearInvalid(); 
                }
            },
            'alumnicommunicationhistoryfilter button[name=submitBtn]': {
            	click: this.showCommunicationHistoryData
            },
        });
    },
    
    showCommunicationHistoryData: function() {
    	var me = this;
    	var form = me.getAlumnicommunicationhistoryfilter();
    	var grid = me.getAlumnicommunicationhistorygrid(); 
    	var formVal = form.getForm().getValues();    

    	grid.getStore().getProxy().extraParams = {
    		alumniCodeName: formVal.alumniIdName,                   
    		emailId: formVal.alumniEmail,                     
    		notificationType: formVal.notificationType,             
    		startDate: formVal.startDate,  
    		endDate: formVal.endDate, 
    	};
    	grid.down('pagingtoolbar').moveFirst();
    	grid.config.searchFilterForm = me.getAlumnicommunicationhistoryfilter();
    },
  
});
