/**
 * @author seshagiri.k
 * 
 */
Ext.define('Academia.controller.campaign.CampaignController', {
extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

models: ['campaign.CampaignCoverageGridModel', 'campaign.CampaignModel', 
         'organization.LocationAddress', 'common.IdValueDataModel',
         
         'dashboard.AppointmentDashboardReportModel'],
         
stores: ['common.ProgramByAcademyLocationStore','campaign.ContactPersonWithoutAcadmyLoction',
         'campaign.MediaStructureStore','campaign.CampaignCovDynGridStore',
         'common.AcademyLocationNameSeparated','campaign.UserByAcademyLocation',
         'campaign.CampaignsStructureStore', 'common.AcademyStore', 'common.AcademyLocationByAcademyId' , 'common.UsersComboStore',
         'common.ProgramsByAcademyIdLocationId','campaign.CampaignSelectionData',
         'campaign.CampaignAdmissionData','campaign.CampaignApplicationData','campaign.CampaignEnquiryData',
         'campaign.CampaignPerformanceDashBoard','campaign.CampaignCodeOrNameSmartSearch',
         'campaign.CampaignReportTreeStore','campaign.PastCampaignEnquiryData',
         'campaign.PastCampaignApplicationData','campaign.PastCampaignSelectionData',
         'campaign.PastCampaignAdmissionData','campaign.ProgramAssociatedGridStore','common.AcademyLocationNameSeparated',         
         'common.AcademyLocationNameSeparated',
         'common.IntakeYearStore',
         'program.ProgramByGroupIdStore',
         'enquiry.FollowUpUserWithDepartment',
         'enquiry.AcademicBatchStore',
         'enquiry.EnquiryCodeSearchStore',
         'dashboard.AppointmentDashboardReportStore',
         'dashboard.FollowUpDashboardStore',
         'dashboard.AppointmentDashboardPersonToMeetStore','common.AcademyLocationNameSeparated',
         'feeandpayment.ALProgramList','feeandpayment.ALProgramSearchCombo','common.AcademyLocationByName','campaign.StoCampaignMapALProgramList','campaign.pAdmCompaignALMappingStore',
         'campaign.ActiveCampaignDashboardStore','campaign.PastCampaignDashboardStore','enquiry.ProgramBatchSeatTypeStore','enquiry.SeatTypeStore'],

 views: ['baselayout.contentarea.ContentPanel', 
         'campaign.CampaignViewListing','campaign.quicksearch.CampaignsManagementStructure',
         'campaign.quicksearch.CampaignQuickSearch', 'campaign.CampaignsStructure', 
         'campaign.CampaignsForm','campaign.CampaignsCoverageGrid','campaign.CampaignsCoverageForm', 
         'campaign.dashboard.CampaignReportTabPanel','campaign.dashboard.ActiveCampaignStructure',
         'campaign.dashboard.CMPDashboardStructure', 'campaign.CampaignsStructureGrid', 
         'campaign.dashboard.CMPDasboardFilter','campaign.dashboard.PastCampaignStructure',
         'campaign.dashboard.CampaignDashBoardChart','campaign.dashboard.CMPDashboardManagementStructure','campaign.ProgramAssociatedGrid',
         'campaign.dashboard.AppointmentDashboardReportStructure',
         'campaign.dashboard.AppointmentDashboardReportForm',
         'campaign.dashboard.AppointmentDashboardReportFilter',
         'campaign.dashboard.AppointmentDashboardReportGrid',
         'campaign.dashboard.FollowUpDashboardStructure',
         'campaign.dashboard.FollowUpDashboardFilter',
         'campaign.dashboard.FollowUpDashboardForm',
         'campaign.dashboard.FollowUpDashboardGrid','campaign.PAdmAddProgramCampaignMappingTab',
         'campaign.PAdmCampaignMapProgressTracker','campaign.PAdmCampaignProgramMapStructure',
         'campaign.PAdmAcademyLocationGridWithCampaign','campaign.PAdmCampaignAlProgramGrid','campaign.dashboard.ActiveCampaignDashboardGrid','campaign.dashboard.PastCampaignDashboardGrid'],
  config: {
	  /*
	   * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	   */
	  /**
	   * @cfg {Array} CAMPAIGN_PERMISSIONS array (required)
	   * The array of permissions to use for Access control wise enabling and disabling buttons.
	   * @accessor
	   */
	  CAMPAIGN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAMPAIGN_PRIVILEGES'),
	  CAMPAIGN_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAMPAIGN_TAB_PRIVILEGES'),
	  CAMPAIGNSDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAMPAIGNSDASHBOARD_PRIVILEGES'),
	  CAMPAIGNS_ADVANCE_SEARCH_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAMPAIGN_ADVANCE_SEARCH_PRIVILEGES'),
	  APPOINTMENT_DASHBOARD_REPORT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPOINTMENT_DASHBOARD_REPORT_PRIVILEGES'),
	  FOLLOWUPDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FOLLOWUP_DASHBOARD_PRIVILEGES')
  },

      refs: [{
    	  ref: 'campaignsform',
    	  selector: 'campaignsform'
      }, {
    	  ref: 'campaignscoveragegrid',
    	  selector: 'campaignscoveragegrid'
      }, {
    	  ref: 'campaignscoverageForm',
    	  selector: 'campaignscoverageform form'
      }, {
    	  ref: 'campaignscoverageform',
    	  selector: 'campaignscoverageform'
      }, {
    	  ref: 'campaigns',
    	  selector: 'campaigns'
      }, {
    	  ref: 'campaignsmanagement',
    	  selector: 'campaignsmanagement'
      }, {
    	  ref: 'contentPanel',
    	  selector: 'contentPanel'
      }, {
    	  ref: 'campaigndashboard',
    	  selector: 'campaigndashboard'
      }, {
    	  ref: 'campaignsStructureGrid',
    	  selector: 'campaignsStructureGrid'
      }, {
    	  ref: 'campaignQuickSearch',
    	  selector: 'campaignQuickSearch'
      }, {
    	  ref: 'searchResultGrid',
    	  selector: 'searchresultgrid[itemId=campaignsStructureGrid]'
      }, {
    	  ref: 'campaignviewlisting',
    	  selector: 'campaignviewlisting'
      }, {
    	  ref: 'activecampaigngrid',
    	  selector: 'activecampaigndashboardgrid[itemId=activecampaigngrid]'
      }, {
    	  ref: 'pastcampaigngrid',
    	  selector: 'pastcampaigndashboardgrid[itemId=pastcampaigngrid]'
      }, {
    	  ref: 'academycoveredgrid',
    	  selector: 'searchresultgrid[itemId=academycoveredgrid]'
      },{
    	  ref: 'locationcoveredgrid',
    	  selector: 'searchresultgrid[itemId=locationcoveredgrid]'
      },{
    	  ref:'cmpdetailstab',
    	  selector:'cmpdetailstab'
      },{
    	  ref: 'programcoveredgrid',
    	  selector: 'searchresultgrid[itemId=programcoveredgrid]'
      },{
    	  ref: 'enquiryregisteredgrid',
    	  selector: 'searchresultgrid[itemId=enquiryregisteredgrid]'
      },{
    	  ref:'applicationgrid',
    	  selector:'searchresultgrid[itemId=applicationgrid]'
      },{
    	  ref: 'selectstudentgrid',
    	  selector: 'searchresultgrid[itemId=selectstudentgrid]'
      },{
    	  ref:'studentadmitgrid',
    	  selector:'searchresultgrid[itemId=studentadmitgrid]'
      },{
    	  ref:'cmpsummarytab',
    	  selector:'cmpsummarytab'
      },{
    	  ref:'orgCMPDashboardItemId',
    	  selector:'organizationunit[itemId=orgCMPDashboardItemId]'
      },{
    	  ref:'cmpdasboardfilter',
    	  selector:'cmpdasboardfilter'
      },{
    	  ref:'campaignmanagementmessage',
    	  selector:'panel[itemId=campaignmanagementmessage]'
      },{
    	  ref:'programAssociatedGrid',
    	  selector:'programAssociatedGrid'
      },{
    	  ref:'appointmentdashboardreportform',
    	  selector:'appointmentdashboardreportform'
      },{
    	  ref:'appointmentdashboardreportfilter',
    	  selector:'appointmentdashboardreportfilter'
      },{
    	  ref:'appointmentdashboardreportgrid',
    	  selector:'appointmentdashboardreportgrid'
      },{
    	  ref:'followupdashboardgrid',
    	  selector:'followupdashboardgrid'
      },{
    	  ref:'followupdashboardform',
    	  selector:'followupdashboardform'
      },{
      	ref:'followupdashboardfilter',
	  	selector:'followupdashboardfilter'
  	  },{
  		ref:'padmcampaignprogrammapstructure',
	  	selector:'padmcampaignprogrammapstructure'
  	  },{
  		  ref:'padmacademylocationgridwithcampaign',
  		  selector:'padmacademylocationgridwithcampaign'
  	  },{
  		  ref:'padmcampaignmapprogresstracker',
  		  selector:'padmcampaignmapprogresstracker'
  	  },{
  		  ref:'padmaddprogramcampaignmappingtab',
  		  selector:'padmaddprogramcampaignmappingtab'
  	  },{
  		  ref:'padmcampaignalprogramgrid',
  		  selector:'padmcampaignalprogramgrid'
  	  },{
        ref:'followupdashboardstructure',
  	  	selector:'followupdashboardstructure' 
  	  }],
      init: function(application) {
    	  this.control({
    		  'cmpsummarytab panel[itemId=campaignReportView] treepanel[itemId=campaignReportTreePanelItemId]' : {
    			  itemclick : this.getOpenCampaignReportStructure
    		  },
    		  'campaignscoverageform':{
                  render : function(obj){
                      var ALField=this.getCampaignscoverageform().down("#academyLocationId");;
                      this.setDefaultAcademyLocation(ALField);
                      var $this = this
                      obj.body.on('click', function() {
      					var filter = obj.down('form');
      					$this.hideInvalidIconFromField(filter);
      			       });
                  },
                  close :function(obj){
                	 var programStore=Academia.app.getStore('common.ProgramByAcademyLocationStore');
                	 programStore.getProxy().extraParams = { 
    					  academyLocationId:this.getCurrentAcademyLocation(),
    				  };
                	 programStore.load();
                  }
              },
    	//***********************Export for Dashboard Summary Tab Active and Past Campaign	  
    		  'activecampaigndashboardgrid[itemId=activecampaigngrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getActivecampaigngrid();
		               var quickSearchForm=this.getCmpsummarytab().down('#activecmpdasboardfilter'); 
		               var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportActiveCampaignDashboardList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'activecampaigndashboardgrid[itemId=activecampaigngrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getActivecampaigngrid();
	               var quickSearchForm=this.getCmpsummarytab().down('#activecmpdasboardfilter'); 
	               var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportActiveCampaignDashboardList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'activecampaigndashboardgrid[itemId=activecampaigngrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getActivecampaigngrid();
	                 var quickSearchForm=this.getCmpsummarytab().down('#activecmpdasboardfilter'); 
	               var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportActiveCampaignDashboardList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'activecampaigndashboardgrid[itemId=activecampaigngrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getActivecampaigngrid();
	                 var quickSearchForm=this.getCmpsummarytab().down('#activecmpdasboardfilter'); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportActiveCampaignDashboardList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
    		  //
   		  //
  		  'pastcampaigndashboardgrid[itemId=pastcampaigngrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getPastcampaigngrid();
		               var quickSearchForm=this.getCmpsummarytab().down('#pastcmpdasboardfilter'); 
	                   var configCode = CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                 this.exportPastCampaignDashboardList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'pastcampaigndashboardgrid[itemId=pastcampaigngrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getPastcampaigngrid();
	               var quickSearchForm=this.getCmpsummarytab().down('#pastcmpdasboardfilter'); 
	                var configCode = CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportPastCampaignDashboardList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'pastcampaigndashboardgrid[itemId=pastcampaigngrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getPastcampaigngrid();
	                 var quickSearchForm=this.getCmpsummarytab().down('#pastcmpdasboardfilter'); 
		                var configCode = CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportPastCampaignDashboardList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'pastcampaigndashboardgrid[itemId=pastcampaigngrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getPastcampaigngrid();
	                 var quickSearchForm=this.getCmpsummarytab().down('#pastcmpdasboardfilter');
		                var configCode = CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
	                this.exportPastCampaignDashboardList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
  //***********************Export for Dashboard Summary Tab Active and Past Campaign********END**************	
	        
	      //*********************Export For Campaign Dashboard Detail Tab********Start**********all 6 Grid***********
	      //
    		  'searchresultgrid[itemId=applicationgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getApplicationgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
		                   var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_CONFIGCODE;
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=applicationgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getApplicationgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=applicationgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getApplicationgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=applicationgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getApplicationgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
    //***************************************************************************************************  
	    //
  		  'searchresultgrid[itemId=enquiryregisteredgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getEnquiryregisteredgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
	                   var configCode = CONSTANTS.CB.CAMPAIGN_ENQUIRYREGISTRED_LIST_CONFIGCODE;
	                   //console.log('CAMPAIGN_ENQUIRYREGISTRED_LIST_CONFIGCODE');
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=enquiryregisteredgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getEnquiryregisteredgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_ENQUIRYREGISTRED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=enquiryregisteredgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getEnquiryregisteredgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.CAMPAIGN_ENQUIRYREGISTRED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=enquiryregisteredgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getEnquiryregisteredgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.CAMPAIGN_ENQUIRYREGISTRED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	  //***************************************************************************************************************      
    		  'searchresultgrid[itemId=selectstudentgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getSelectstudentgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
		                   var configCode = CONSTANTS.CB.CAMPAIGN_SELECTSTUDENT_LIST_CONFIGCODE;
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=selectstudentgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getSelectstudentgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_SELECTSTUDENT_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=selectstudentgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getSelectstudentgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.CAMPAIGN_SELECTSTUDENT_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=selectstudentgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getSelectstudentgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.CAMPAIGN_SELECTSTUDENT_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
//**************************************************************************************************************************	        
  		  'searchresultgrid[itemId=studentadmitgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getStudentadmitgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
	                   var configCode = CONSTANTS.CB.CAMPAIGN_STUDENTADMITTED_LIST_CONFIGCODE;
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=studentadmitgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getStudentadmitgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_STUDENTADMITTED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=studentadmitgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getStudentadmitgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.CAMPAIGN_STUDENTADMITTED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=studentadmitgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getStudentadmitgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.CAMPAIGN_STUDENTADMITTED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
//*************************************************************************************************************************	        
    		  'searchresultgrid[itemId=academycoveredgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getAcademycoveredgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
		                   var configCode = CONSTANTS.CB.ACADEMY_CAMPAIGNWISE_LIST_CONFIGCODE;
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=academycoveredgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getAcademycoveredgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.ACADEMY_CAMPAIGNWISE_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=academycoveredgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getAcademycoveredgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.ACADEMY_CAMPAIGNWISE_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=academycoveredgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getAcademycoveredgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.ACADEMY_CAMPAIGNWISE_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
  		            }
  		        },
   //*************************************************************************************************************************** 		        
  		  'searchresultgrid[itemId=locationcoveredgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getLocationcoveredgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
		               //console.log('Location Covered');
	                   var configCode = CONSTANTS.CB.CAMPAIGN_LOCATIONCOVERED_LIST_CONFIGCODE;
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=locationcoveredgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getLocationcoveredgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_LOCATIONCOVERED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=locationcoveredgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getLocationcoveredgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.CAMPAIGN_LOCATIONCOVERED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=locationcoveredgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getLocationcoveredgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.CAMPAIGN_LOCATIONCOVERED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
  		            }
  		        },
   //******************************************************************************************************************************
    		  'searchresultgrid[itemId=programcoveredgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	            	   var searchResultGrid=this.getProgramcoveredgrid();
		               var quickSearchForm=this.getCmpdetailstab(); 
		                   var configCode = CONSTANTS.CB.CAMPAIGN_PROGRAMCOVERED_LIST_CONFIGCODE;
	                 this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=programcoveredgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	               var searchResultGrid=this.getProgramcoveredgrid();
	               var quickSearchForm=this.getCmpdetailstab(); 
	                var configCode = CONSTANTS.CB.CAMPAIGN_PROGRAMCOVERED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=programcoveredgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                 var searchResultGrid=this.getProgramcoveredgrid();
	                 var quickSearchForm=this.getCmpdetailstab(); 
		                var configCode = CONSTANTS.CB.CAMPAIGN_PROGRAMCOVERED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
	        'searchresultgrid[itemId=programcoveredgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                 var searchResultGrid=this.getProgramcoveredgrid();
	                 var quickSearchForm=this.getCmpdetailstab();
		                var configCode = CONSTANTS.CB.CAMPAIGN_PROGRAMCOVERED_LIST_CONFIGCODE;
	                this.exportCampaignDashboardDetailTabList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
	            }
	        },
//********************************Export Functionality End For Dashboard Detail Tab ****************************************** 
    		  'campaignsform': {
    			  afterrender: this.formRender
    		  },'campaigns': {
    			render:function(structure){
    				var $this = this
    				structure.body.on('click', function() {
    					var filter = structure.down('campaignsform');
    					$this.hideInvalidIconFromField(filter);
    			       });
    			}
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid]': {
    			  render:function(grid){
    				  var permissionsMap = new Ext.util.HashMap();
    				  this.gridRenderFunction(grid);
    				  permissionsMap = this.getCAMPAIGN_PERMISSIONS();
    				  this.genericCBGridAccessControlValidation(grid,permissionsMap);
    				 // this.searchCmpQuickFilter();
    			  },
            	  cellclick : function(view,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		  var grid = view.ownerCt;
            		  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
            		  if(e.target.tagName=="A"){
            			  if(columnName == "NO_OF_PROGRAMS_ASSOCIATED"){
                			  this.viewAssociatedProgram(grid,record);
                		  }
            		  }
    			  }
    		  },
    		  'campaignsStructureGrid': {
    			  render: this.gridRender
    		  },
    		  /**
    		   * for collapsible search
    		   */
    		/*  'campaignviewlisting':{
    			  activate:function(that,eOpts){
    				  if(that.activeTab.xtype == "campaignsmanagement"){
    					  var $this = this;
            			  setTimeout(function(){
            		           var campaignViewListTab = $this.getCampaignviewlisting();
            				   campaignViewListTab.setBodyStyle('top:23px');
                			   },1);
                		    
    				  }else if(that.activeTab.xtype == "advancedsearchquerybuilder"){
    					  var $this = this;
            			  setTimeout(function(){
            		           var campaignViewListTab = $this.getCampaignviewlisting();
            				   campaignViewListTab.setBodyStyle('top:37px');
                			   },1);
    				  }
    			  }  
    		  },*/
    		  
    		  'campaignviewlisting':{
    			  render:function(obj){
    				  this.disableCampaignStructureTab(obj, this.getCAMPAIGNS_ADVANCE_SEARCH_PERMISSIONS());
    			  }
    		  },
    		  
    		  'campaignsmanagement': {
    			  selectionchange: this.gridSelectionChange,
    			  afterrender : function(structure){
					 //var grid = structure.down('#campaignsStructureGrid');
	   				 //this.getCBGridHeaderFreeze(grid,structure);
				 }
    		  },
    		  'campaignscoverageform button[action=Submit]': {
    			  click: this.updateCampaign
    		  },
    		  'campaignscoveragegrid button[itemId=btnAdd]': {
    			  click:this.pAdmCampaignAddProgramFeeMappingTab 
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] button[itemId=searchResultGridBtnEdit]': {
    			  click: function() {
    				  var grid = this.getSearchResultGrid();
    				  this.editCampaignFormWindow(grid);
    			  }
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] button[itemId=searchResultGridBtnView]': {
    			  click: function() {
    				  var grid = this.getSearchResultGrid();
    				  this.viewCampaignFormWindow(grid);
    			  }
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] button[itemId=searchResultGridBtnDelete]': {
    			  click: function() {
    				  this.deleteRecord();
    			  }
    		  },
    		  'campaignscoveragegrid button[itemId=btnEdit]': {
    			  click: function() {
    				  this.editCampaignCoverageFormWindow();
    				  var campCovrageFrm = this.getCampaignscoverageform();
    				  if(campCovrageFrm){
    					  var programCombo = campCovrageFrm.down('form').down('#programId');
    					  programCombo.isEditMode = true;
    				  }
    			  }
    		  },
    		  'campaignscoveragegrid button[itemId=btnDelete]': {
    			  click: this.deleteCampaignFormWindow
    		  },

    		  'campaignscoverageform button[itemId=campaignCoverageFormAddButtonId]': {
    			  click: function() {
    				  this.addCampaignGrid();
    			  }
    		  },
    		  'campaignscoveragegrid':{
    			  render:function(grid){	
    				  this.doAccessControlValidation(grid, this.getCAMPAIGN_PERMISSIONS());
    			  }
    		  },
    		  'campaignscoverageform button[itemId=campaignCoverageFormClearButtonId]': {
    			  click: function() {
    				  this.getCampaignscoverageform().close();
    			  }
    		  },
    		  'campaignscoverageform customcombobox#academyLocationId': { // getting the academyId, locationId from the form and sending request to server
    			  select: function(obj, record) {
    				  var formWindow=obj.up('form').getForm();
    				  var academyLocationId =  record[0].get("id");
    				  var store = this.getStore('common.ProgramByAcademyLocationStore');
    				  store.getProxy().extraParams = { // appending the parameters to server url
    					  academyLocationId:academyLocationId
    				  };
    				  store.load(); // getting the data and loading combo box
    				  obj.nextSibling().clearValue();
    				  
    				  
    				  var store = formWindow.findField('userId').getStore();
                	  store.getProxy().extraParams = {
	            		  academyLocationId:academyLocationId
					  };
                	  store.load();
    			  }
    		  },
    		  'campaignscoverageform customcombobox#programId': {
    			  expand: function(obj,rec){
    				  if(obj.isEditMode==true){
    					  setTimeout(function(){
    						  Ext.select('.x-boundlist-item').elements[0].hidden = true;
    					  },100);
    				  } else {
    					  setTimeout(function(){
    						  Ext.select('.x-boundlist-item').elements[0].hidden = false;
    					  },100);
    				  }
    			  },
    			  change: function(obj,record){
    				  var this$  = this;
    				  if(obj.isEditMode==true){
    					  var selectionModel = obj.getPicker().getSelectionModel().getSelection();
    					  if(selectionModel.length > 1){
    						  obj.getPicker().getSelectionModel().deselect(selectionModel[1]);
								showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('UNCHECK_CURRENT_PROGRAM_FIRST'));
    					  }
    				  }else{
    					  setTimeout(function(){
    	    					 var campaignscoveragegrid = this$.getCampaignscoveragegrid();
    	    					 var selected = obj.getPicker().getSelectionModel().getSelection();
    	    					 if(selected.length > 0){
    	    						 var campaignStore = campaignscoveragegrid.getStore();
    	    						 campaignStore.each(function(record) {
    	    							 selected.forEach(function(selectedData){
    	    								 if(record.data.programId === selectedData.get('id')){
    	        								obj.getPicker().getSelectionModel().deselect(selectedData);
    	        							 }
    	    							 });
    	    		    			  });
    	    					 }
    	    				  },10);
    				  }
    				 
    			  }
    		  },
    		  'campaigns button[itemId=saveCampaign]': {
    			  click: function() {
    				  this.updateCampaign();
    			  }
    		  },
    		  'campaigns button[itemId=cancelCampaign]': {
    			  click: function() {
    				  this.getCampaignsform().getForm().reset();
    				  this.refreshCampaignCovrageGrid();
    			  }
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] button[itemId=searchResultGridBtnAdd]': {
    			  click: function() {
    				  this.openNewCmpTab();
    			  }
    		  },
    		  'campaignQuickSearch button[itemId=campaignSearchButtonId]': {
    			  click: this.searchCmpQuickFilter
    		  },
    		  'campaignQuickSearch button[itemId=cancelBtn]': {
    			  click: function(){
    				  var this$ = this;
    				  var form = this$.getCampaignQuickSearch();
    				  // this.getCampaignQuickSearch().getForm().reset();
    				  var academyLocationId = form.down('#academyLocationId');
    				  var academyLocationStore =  academyLocationId.getStore();
    				  var academyLocation = this.getCurrentAcademyLocation();
    				  academyLocationStore.load({
    					  callback: function(records, operation, success) {
    						  for(var i in records){
    							  if(records[i].data.id==academyLocation){
    								  academyLocationId.setValue(records[i].data.id);
    							  }
    						  }
    					  }
    				  });
    				  form.getForm().reset();
    				  form.down('#startDate').setMaxValue(null);
    				  form.down('#startDate').setMinValue(null);
    				  form.down('#endDate').setMaxValue(null);
    				  form.down('#endDate').setMinValue(null);
    			  }
    		  },
    		  'campaignQuickSearch customcombobox#academyName': { // getting the academyId from the form and sending request to server
    			  select: function(obj, record) {
    				  var store = this.getStore('common.AcademyLocationByAcademyId');

    				  store.getProxy().extraParams = {
    					  id: record[0].get("id")
    				  };
    				  store.load();
    			  }
    		  },
    		  'campaignQuickSearch': { // getting the academyId, locationId from the form and sending request to server
    			  render: function(obj) {
    				  var academyLocationId = this.getCurrentAcademyLocation() ;
    				  var store = this.getStore('common.ProgramByAcademyLocationStore');
    				  store.getProxy().extraParams = { // appending the parameters to server url
    					  academyLocationId: academyLocationId
    				  };
    				  store.load(); // getting the data and loading combo box
    				  

   				   var academyLocationId = obj.down('#academyLocationId');
   				   var academyLocationStore =  academyLocationId.getStore();
   				   var academyLocation = this.getCurrentAcademyLocation();
   				   /*academyLocationStore.load({
   					   callback: function(records, operation, success) {
   						   for(var i in records){
   							   if(records[i].data.id==academyLocation){
   								   academyLocationId.setValue(records[i].data.id);
   							   }
   						   }
   					   }
   				   });*/
					  academyLocationId.setValue(academyLocation);
    			  }
    		  },
    		  'activecampaigndashboardgrid[itemId=activecampaigngrid]': {
    			  render:function(grid){
    				  //this.gridCampaignRenderFunction(grid);
    				  //this.gridRenderFunction(grid);
    				  this.doAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS()); 
    				  this.disableMoreBtnPivileges(grid, this.getCAMPAIGN_TAB_PERMISSIONS());
    			  },
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var  $this=this;
    				  var searchResultGrid = $this.getActivecampaigngrid();
    				  var resultTitle = grid.ownerCt.title + ' - ' + grid.getHeaderAtIndex(cellIndex).text;
    				  $this.openDetailTabGrids(searchResultGrid,td, cellIndex, record, tr, rowIndex, e, eOpts, resultTitle);
    			  }
    		  },
    		  'pastcampaigndashboardgrid[itemId=pastcampaigngrid]': {
    			  render:function(grid){
    				  //this.gridPastCampaignRenderFunction(grid);
    				  //grid.addButtonToolbar();
   					 this.doAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			  },
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

    				  var  $this=this;
    				  var searchResultGrid = $this.getPastcampaigngrid();
    				  var resultTitle = grid.ownerCt.title + ' - ' + grid.getHeaderAtIndex(cellIndex).text;
    				  $this.openDetailTabGrids(searchResultGrid,td, cellIndex, record, tr, rowIndex, e, eOpts, resultTitle);
    			  }
    		  },  
    		  'cmpsummarytab button[itemId=chartLoadItemId]':{
    			  click:function(){
    				  var searchResultGrid = this.getPastcampaigngrid();
    				  var array=searchResultGrid.getStore().data.items;

    				  var graphArray=[];
    				  //  'ENQUIRY_GENERATED', 'NO_OF_APPLICATIONS', 'STUDENT_SELECTED','STUDENT_ADMITTED'
    				  Ext.each(array,function(value){
    					  var data={
    							  'name':value.data.ENQUIRY_GENERATED,
    							  'id':value.data.NO_OF_APPLICATIONS
    							  //'STUDENT_SELECTED':value.data.STUDENT_SELECTED,
    							  //'STUDENT_ADMITTED':value.data.STUDENT_ADMITTED,

    					  };
    					  graphArray.push(data);
    				  });

    				  var store=this.getStore('campaign.dashboard.CampaignDashboardStore');
    				  store.loadRawData(graphArray);

    			  }
    		  },
              'searchresultgrid[itemId=applicationgrid]':{
            	  render:function(grid){
    				    grid.addButtonToolbar();
     					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			    },
            	  cellclick : function(view,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var grid = view.ownerCt;
            		  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
            		  if(e.target.tagName=="A"){
            			  if(columnName=='CAMPAIGN_CODE'){
                			  this.viewCampaignFormWindow(grid);
                		  }
            			  /**
            			   * this function is to view enquiry
            			   */
            			  if(columnName=='ENQUIRY_CODE'){
            				  this.getTrackEnquiryController().viewEnquiryFormWindow(grid);
            			  }
            		  }
    			  }
              },
              'searchresultgrid[itemId=enquiryregisteredgrid]':{
            	  render:function(grid){
    				    grid.addButtonToolbar();
     					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			    },
            	  cellclick : function(view,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		  var grid = view.ownerCt;
            		  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
            		  if(e.target.tagName=="A"){
            			  if(columnName=='CAMPAIGN_CODE'){
                			  this.viewCampaignFormWindow(grid);
                		  }
            			  /**
            			   * this function is to view enquiry
            			   */
            			  if(columnName=='ENQUIRY_CODE'){
            				  this.getTrackEnquiryController().viewEnquiryFormWindow(grid);
            			  }
            		  }
    			  }
              },
              'searchresultgrid[itemId=academycoveredgrid]':{
            	  render:function(grid){
    				    grid.addButtonToolbar();
     					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			  },
            	  cellclick : function(view,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		  var grid = view.ownerCt;
            		  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
            		  if(e.target.tagName=="A"){
            			  if(columnName=='CAMPAIGN_CODE'){
                			  this.viewCampaignFormWindow(grid);
                		  }
            		  }
    			  }
              },
              'searchresultgrid[itemId=locationcoveredgrid]':{
            	  render:function(grid){
  				    grid.addButtonToolbar();
   					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
  			    },
            	  cellclick : function(view,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		  var grid = view.ownerCt;
            		  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
            		  if(e.target.tagName=="A"){
            			  if(columnName=='CAMPAIGN_CODE'){
                			  this.viewCampaignFormWindow(grid);
                		  }
            		  }
    			  }
              },
              'searchresultgrid[itemId=programcoveredgrid]':{
            	  render:function(grid){
    				    grid.addButtonToolbar();
     					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			    },
            	  cellclick : function(view,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		  var grid = view.ownerCt;
            		  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
            		  if(e.target.tagName=="A"){
            			  if(columnName=='CAMPAIGN_CODE'){
                			  this.viewCampaignFormWindow(grid);
                		  }
            		  }
    			  }
              },
              'searchresultgrid[itemId=selectstudentgrid]':{
            	  render:function(grid){
    				    grid.addButtonToolbar();
     					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			    }
              },  
              'searchresultgrid[itemId=studentadmitgrid]':{
            	  render:function(grid){
    				    grid.addButtonToolbar();
     					this.genericCBGridAccessControlValidation(grid,this.getCAMPAIGN_TAB_PERMISSIONS());
    			    }
              },
              
              //
    		  'searchresultgrid[itemId=campaignsStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
    			  click: function() {
    				  this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
    			  }
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
    			  click: function() {
    				  this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
    			  }
    		  },
    		  'activecampaigndashboardgrid[itemId=activecampaigngrid] button[itemId=exportCampaignReport]':{
    			  click:function(){
    				  this.getCampaignExcelReport();
    			  }
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
    			  click: function() {
    				  this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
    			  }
    		  },
    		  'searchresultgrid[itemId=campaignsStructureGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
    			  click: function() {
    				  this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
    			  }
    		  },
    		  'activecampaignstructure cmpdasboardfilter button[itemId=searchBtn]':{
    			  click:function(obj){
    				  var graphPanel=Ext.ComponentQuery.query('panel#activecampaigncharts')[0];
    				  if(!graphPanel.isHidden()){
    					  graphPanel.setVisible(false);
    				  };
    				  var searchForm = obj.up('activecampaignstructure').down("#activecmpdasboardfilter");
    				  //this.gridCampaignRenderFunction(searchForm);
    				  this.loadActiveCampaignDashboardGrid(true,obj);
    			  }
    		  },
    		  'pastcampaignstructure cmpdasboardfilter button[itemId=searchBtn]':{
    			  click:function(obj){
    				  var graphPanel=Ext.ComponentQuery.query('panel#pastcampaigncharts')[0];
    				  if(!graphPanel.isHidden()){
    					  graphPanel.setVisible(false);
    				  };
    				  var searchForm = obj.up('pastcampaignstructure').down("#pastcmpdasboardfilter");
    				  //this.gridPastCampaignRenderFunction(searchForm);
    				  this.loadActiveCampaignDashboardGrid(false,obj);
    			  }
    		  },
    		  
    		  'cmpdasboardfilter':{ 
    			  afterrender:function(obj,value){
    				  var form = obj.up('form');
    				  var date = new Date();
	                	 var fromdate = new Date(date.setMonth(date.getMonth() - 3));
	                	 /*form.down('#fromdateItemId').setValue(fromdate);
	                	 form.down('#todateItemId').setValue(new Date());*/
    			  }
    		  },
    		  
    		  'cmpdasboardfilter datefield[itemId=fromdateItemId]':{ 
    			  blur:function(field){
    				  var fromDate = field.getValue();
    				  var filter = this.getCmpdasboardfilter();
    				  var AL= this.getOrgCMPDashboardItemId();
    				  var tillDateField = filter.down('#todateItemId');
    				  var minTillDate = new Date(fromDate);
    				  var tillDate = tillDateField.getValue();
    				  if(tillDate <= field.getValue()){
    					  tillDateField.setValue(fromDate);
    				  }
    				  if(AL.getValues().multiselectAcademyLocation[0] == "" || AL.getValues().multiselectAcademyLocation[0] == undefined){
    					  filter.down('#searchBtn').setDisabled(true);
    				  }else{
    					  filter.down('#searchBtn').setDisabled(false);
    				  }
    			  },
    			  select:function(field){
    				  var filter = this.getCmpdasboardfilter();
    				  var AL= this.getOrgCMPDashboardItemId(); 
    				  
    				  if(AL.getValues().multiselectAcademyLocation[0] == "" || AL.getValues().multiselectAcademyLocation[0] == undefined){
    					  filter.down('#searchBtn').setDisabled(true);
    				  }else{
    					  filter.down('#searchBtn').setDisabled(false);
    				  }
    			  }
    		  },
    		  'cmpdasboardfilter datefield[itemId=todateItemId]':{ 
    			  blur: function(field){
     				 var tillDate = field.getValue();
     				 var filter = this.getCmpdasboardfilter();
     				 var AL= this.getOrgCMPDashboardItemId();
     				 var fromDateField = filter.down('#fromdateItemId');
     				 var minFromDate = new Date(tillDate);
     				 var fromDate = fromDateField.getValue();
     				 if(tillDate <=fromDate){
     					 fromDateField.setValue(tillDate);
     				 }
     				 if(AL.getValues().multiselectAcademyLocation[0] == ""){
     					 filter.down('#searchBtn').setDisabled(true);
     				 }else{
     					 filter.down('#searchBtn').setDisabled(false);
     				 }
     				
     				 // fromDateField.setMinValue(minFromDate);
     			 },
     			select:function(field){
  				  var filter = this.getCmpdasboardfilter();
  				  var AL= this.getOrgCMPDashboardItemId(); 
  				  
  				  if(AL.getValues().multiselectAcademyLocation[0] == ""){
  					  filter.down('#searchBtn').setDisabled(true);
  				  }else{
  					  filter.down('#searchBtn').setDisabled(false);
  				  }
  			  }
    		  },
    		  'cmpdasboardfilter button[itemId=resetBtn]':{
    			  click:function(obj){
    				   obj.up('form').getForm().reset();
    			  }
    		  },
    		  'organizationunit[itemId=orgCMPDashboardItemId] radiogroup[itemId=organizationRadioUnitId]': {
    			  change:function(obj,record){
    				  this.organizationUnitChange(obj,record);
    			  },
    			  render:function(obj){
    				  var permission = this.getCAMPAIGNSDASHBOARD_PERMISSIONS();
    				  this.organizationUnitChange(obj,null,permission);
    			  }
    		  },
    		  'organizationunit[itemId=orgCMPDashboardItemId] button[itemId=resetBtn]': {
    			  click:function(obj,record){ 
    				  this.resetOrganizationunitForDashborad(obj);
    			  }
    		  },
    		  'campaignsform textfield[itemId=code]': {
    			  blur : function(response) {
    				  this.checkUniquenessForCampaignCode(response);
					}
    		  },
    		  'appointmentdashboardreportfilter multiselectcombofield#academyLocationId':{
    			  render: function(obj) {
    				  var userId = this.getCurrentlyLoggedInUser().id;
    				  var store = obj.getStore();
    				  store.getProxy().extraParams = {
    					  id: userId
    				  };

    				  store.load({
    					  callback: function(record){
    						  obj.select(obj.getStore().collect(obj.valueField));
    					  }
    				  });
    			  },

    			  change: function(ob, rec) {
    				  var form = this.getAppointmentdashboardreportfilter().getForm();
    				  var academyLocationId = ob.up('form').down('#academyLocationId').getValue();
    				  var alIds = [];
    				  var academyLocationIds;
    				  if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
    					  for (var i in academyLocationId) {
    						  if (Ext.isObject(academyLocationId[0])) {
    							  alIds.push(academyLocationId[i].get("id"));
    						  } else {
    							  alIds.push(academyLocationId[i]);
    						  }
    					  }
    					  academyLocationIds = alIds.join();
    				  } else {
    					  alIds.push(this.getCurrentAcademyLocation());
    					  academyLocationIds = alIds.join();
    				  }
    				  var programId = ob.up('form').down('#programId');
    				  var enquiryId = ob.up('form').down('#enquiryId');
    				  var owner = ob.up('form').down('#enquiryOwner');
    				  var batchId = ob.up('form').down('#batchId');
    				  var seatType = ob.up('form').down('#seatType');
    				  programId.reset();
    				  enquiryId.reset();
    				  owner.reset();
    				  batchId.reset();
    				  seatType.reset();
    				  batchId.setDisabled(true);
    				  seatType.setDisabled(true);
    				  
    				  var programStore = programId.getStore();
    				  programStore.getProxy().extraParams = {
    					  academyLocationIds: academyLocationIds
    				  };
    				  programStore.load();
    				  
    				  var enquiryStore = enquiryId.getStore();
    				  enquiryStore.getProxy().extraParams = {
    					  academyLocationIds: academyLocationIds
    				  };
    				  enquiryStore.load();
    				  
    				  var owner = owner.getStore();
    				  owner.getProxy().extraParams = {
    					  academyLocationIds: academyLocationIds
    				  };
    				  owner.load();
    			  }
    		  },
    		  
    		  'cmpsummarytab': {
      			render:function(structure){
      				var $this = this
      				structure.body.on('click', function() {
      					var filter = structure.down('organizationunit');
      					$this.hideInvalidIconFromField(filter);
      			       });
      			}
      		},
    		  'appointmentdashboardreportfilter customcombobox[itemId=programId]': {
    			  render : function(combo){
    				  var academyLocationId = this.getUserAccessibleAL();
    				  var store = combo.getStore();
    				  store.proxy.extraParams = {
    						  academyLocationIds : academyLocationId.join()
    				  };
    				 // store.load();
    			  },
    			  select: function(obj, record) {
    				  var form = this.getAppointmentdashboardreportfilter(); 
    				  var x=form.down("#batchId").setDisabled(false);
    				  var programId = record[0].get("id");
    				  form.down("#batchId").reset();
    				  form.down("#seatType").reset();
    				  if (programId > 0) {
    					  var store = this.getStore('enquiry.AcademicBatchStore');
    					  store.getProxy().extraParams = {
    						  id: programId
    					  };
    					  store.load();
    				  }
    			  },
    			  change: function(value,newValue) {
    				  if(isNullOrEmpty(newValue)){
    					  var form = this.getAppointmentdashboardreportfilter(); 
    					  form.down("#batchId").setDisabled(true);
    				  }
    			  }
    		  },
    		  'appointmentdashboardreportfilter customcombobox[itemId=batchId]': {
    			  render : function(combo){
    				  var academyLocationId = this.getUserAccessibleAL();
    				  var store = combo.getStore();
    				  store.proxy.extraParams = {
    						  academyLocationIds : academyLocationId.join()
    				  };
    				  //store.load();
    			  },
    			  select: function(obj, record) {
    				  var form = this.getAppointmentdashboardreportfilter(); 
    				  var x=form.down("#seatType").setDisabled(false);
    				  var batchId = record[0].get("id");
    				  form.down("#seatType").reset();
    				  if (batchId > 0) {
    					  var store = this.getStore('enquiry.SeatTypeStore');
    					  store.getProxy().extraParams = {
    						  batchId: batchId
    					  };
    					  store.load();
    				  }
    			  },
    			  change: function(value,newValue) {
    				  if(isNullOrEmpty(newValue)){
    					  var form = this.getAppointmentdashboardreportfilter(); 
    					  form.down("#seatType").setDisabled(true);
    				  }
    			  }
    		  },
    		  'appointmentdashboardreportfilter customcombobox[itemId=enquiryOwner]' : {
    			  render: function(combo) {
    				  var academyLocationId = this.getUserAccessibleAL();
    				  var store = combo.getStore();
    				  store.proxy.extraParams = {
    						  academyLocationIds : academyLocationId.join()
    				  };
    				  store.load();
    			  }
    			  },
    			   'appointmentdashboardreportfilter customcombobox[itemId=enquiryId]' : {
        			  render: function(combo) {
        				  var academyLocationId = this.getUserAccessibleAL();
        				  var store = combo.getStore();
        				  store.proxy.extraParams = {
        						  academyLocationIds : academyLocationId.join()
        				  };
        				 // store.load();
        			  },
    				  change: function(value,newValue) {
                          if(!isNullOrEmpty(newValue)){

                              var alinfomodel = Academia.model.authentication.ALInfoModel;
                              var isSchool = alinfomodel.get('wheatherSchool');


                             var form = this.getAppointmentdashboardreportfilter();
                              var ALValue = form.down("#academyLocationId").getValue();
                              var AlJoin = "";

                              if(!isNullOrEmpty(ALValue)){
                                AlJoin =  ALValue.toString();
                              }else{
                            	  var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
                            	    var locations = [];

                            	    for (var i = 0; i < academyLocationList.length; i++) {
                            	        locations.push(academyLocationList[i].id);
                            	    }
                            	    AlJoin = locations.join(",");
                              }
                             var enquiryField = form.down("#enquiryId");
                             enquiryField.getStore().getProxy().extraParams = {
                                 wheatherSchool:isSchool,
                                 academyLocationIds:AlJoin
                             };
                         }
                     }
    			  
    	  },
    		  'appointmentdashboardreportfilter button[itemId=resetBtn]' : {
    			  click : function(ob, rec){
    				  var $this=this;
    				  var form=$this.getAppointmentdashboardreportfilter().getForm();
    				  ob.up('form').down('#fromdate').setMaxValue(null);
    				  ob.up('form').down('#fromdate').setMinValue(null);
    				  ob.up('form').down('#todate').setMaxValue(null);
    				  ob.up('form').down('#todate').setMinValue(null);
    				  form.reset();
    				  var academyLocationId = ob.up('form').down('#academyLocationId');
    				  var academyLocationStore =  academyLocationId.getStore();
    				  var store = academyLocationId.getStore();
    				  store.getProxy().extraParams = {
    					  id: userId
    				  };
    				  store.load({
    					  callback: function(record){
    						  academyLocationId.select(academyLocationId.getStore().collect(academyLocationId.valueField));
    					  }
    				  });
    				}
    		  },
    		  'appointmentdashboardreportfilter button[itemId=searchBtn]' : {
    			  click: function(){
    				  var formLayout = this.getAppointmentdashboardreportfilter();
    				  this.showInvalidIconOnField(formLayout);
    				  var form = this.getAppointmentdashboardreportfilter().getForm();
    				  var values = form.getValues();

    				  var seatTypeIds = values.seatType;
    				  var academyLocationIds = this.getAcademyLocation();
    				  var enquiryId = values.enquiryId;
    				  var intakeYearId = values.intakeYear;
    				  var personToMeetId = values.enquiryOwner;
    				  var programId = values.programId;
    				  var batchId = values.batch;
    				  var fromDateString = values.fromdate;
    				  var toDateString = values.todate;
    				  var grid = this.getAppointmentdashboardreportgrid();
    				  
    				  if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
    	 	 			     var seatTypeIdsArray=[];
    	 	 			     for(var i in seatTypeIds) {
    	 	 			     	if(typeof seatTypeIds[i] == "object") {
    	 	 			     	seatTypeIdsArray.push(seatTypeIds[i].data.id);
    	 	 			     	} else {
    	 	 			     		seatTypeIdsArray.push(seatTypeIds[i]);
    	 	 			      	}
    	 	 			     }
    	 	 			     var seatTypeIdsString = seatTypeIdsArray.join();
    	 	 			     }
    				  
    				  var store = this.getStore('dashboard.AppointmentDashboardReportStore');
    				  store.getProxy().extraParams = {
    					  academyLocationIds: academyLocationIds,
    					  enquiryId  :enquiryId,
    					  intakeYearId:intakeYearId,
    					  personToMeetId :personToMeetId,
    					  programId :programId,
    					  batchId :batchId,
    					  fromDateString :fromDateString,
    					  toDateString:toDateString,
    					  seatTypeIds : seatTypeIdsString
    				  };
    				  this.resetPageSetting(store);
    				  store.load({
     			    	  callback: function(records, operation, success) {
    						if(records.length>0){
    							var buttonsToolBar = grid.query('toolbar')[0];
    					    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    					    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    					    	pdftoolbar.setDisabled(false);
    					    	exceltoolbar.setDisabled(false);
    						}
    					  }
     			       
    				  });
    				  
    				  /***************Start Code added for show filter data on PDF/Excel Export Report **************/
    			    	
    			    	grid.config.searchFilterForm = this.getAppointmentdashboardreportfilter();
    			    	
    			    	/***************End Code added for show filter data on PDF/Excel Export Report **************/
			  }	                			   
		   },	   
		   'followupdashboardfilter multiselectcombofield#academyLocationId':{
 			  render: function(obj) {
 				  var userId = this.getCurrentlyLoggedInUser().id;
 				  var store = obj.getStore();
 				  store.getProxy().extraParams = {
 					  id: userId
 				  };
 				  store.load({
 					  callback: function(record){
 						  obj.select(obj.getStore().collect(obj.valueField));
 					  }
 				  });
 			  },
 			  change: function(ob, rec) {
 				  var form = this.getFollowupdashboardfilter().getForm();
 				  var academyLocationId = ob.up('form').down('#academyLocationId').getValue();
 				  var alIds = [];
 				  var academyLocationIds;
 				  if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
 					  for (var i in academyLocationId) {
 						  if (Ext.isObject(academyLocationId[0])) {
 							  alIds.push(academyLocationId[i].get("id"));
 						  } else {
 							  alIds.push(academyLocationId[i]);
 						  }
 					  }
 					  academyLocationIds = alIds.join();
 				  } else {
 					  alIds.push(this.getCurrentAcademyLocation());
 					  academyLocationIds = alIds.join();
 				  }
 				  var programId = ob.up('form').down('#programId');
 				  var enquiryId = ob.up('form').down('#enquiryId');
 				  var batchId = ob.up('form').down('#batchId');
				  var seatType = ob.up('form').down('#seatType');
				  programId.reset();
 				  enquiryId.reset();
				  batchId.reset();
				  seatType.reset();
				  batchId.setDisabled(true);
				  seatType.setDisabled(true);
 				  var programStore = programId.getStore();
 				  programStore.getProxy().extraParams = {
 					  academyLocationIds: academyLocationIds
 				  };
 				  programStore.load();
 				  
 				  var enquiryStore = enquiryId.getStore();
 				  enquiryStore.getProxy().extraParams = {
 					  academyLocationIds: academyLocationIds
 				  };
 				  enquiryStore.load();
 			  }
 		  },
 		  'followupdashboardfilter customcombobox[itemId=programId]': {
 			  render : function(combo){
 				  var academyLocationId = this.getUserAccessibleAL();
 				  var store = combo.getStore();
 				  store.proxy.extraParams = {
 						  academyLocationIds : academyLocationId.join()
 				  };
 				 // store.load();
 			  },
 			  select: function(obj, record) {
 				  var form = this.getFollowupdashboardfilter(); 
 				  var x=form.down("#batchId").setDisabled(false);
 				  var programId = record[0].get("id");
 				  form.down("#batchId").reset();
 				  form.down("#seatType").reset();
 				  if (programId > 0) {
 					  var store = this.getStore('enquiry.AcademicBatchStore');
 					  store.getProxy().extraParams = {
 						  id: programId
 					  };
 					  store.load();
 				  }
 			  },
 			  change: function(value,newValue) {
 				  if(isNullOrEmpty(newValue)){
 					  var form = this.getFollowupdashboardfilter(); 
 					  form.down("#batchId").setDisabled(true);
 				  }
 			  }
 		  },
 		 'followupdashboardfilter customcombobox[itemId=batchId]': {
			  render : function(combo){
				  var academyLocationId = this.getUserAccessibleAL();
				  var store = combo.getStore();
				  store.proxy.extraParams = {
						  academyLocationIds : academyLocationId.join()
				  };
				  store.load();
			  },
			  select: function(obj, record) {
				  var form = this.getFollowupdashboardfilter(); 
				  var x=form.down("#seatType").setDisabled(false);
				  var batchId = record[0].get("id");
				  form.down("#seatType").reset();
				  if (batchId > 0) {
					  var store = this.getStore('enquiry.SeatTypeStore');
					  store.getProxy().extraParams = {
						  batchId: batchId
					  };
					  store.load();
				  }
			  },
			  change: function(value,newValue) {
				  if(isNullOrEmpty(newValue)){
					  var form = this.getFollowupdashboardfilter(); 
					  form.down("#seatType").setDisabled(true);
				  }
			  }
		  },
 		  'followupdashboardfilter button[itemId=resetBtn]' : {
 			  click : function(ob, rec){
 				  var $this=this;
 				  var form=$this.getFollowupdashboardfilter().getForm();

 				  ob.up('form').down('#fromdate').setMaxValue(null);
 				  ob.up('form').down('#fromdate').setMinValue(null);
 				  ob.up('form').down('#todate').setMaxValue(null);
 				  ob.up('form').down('#todate').setMinValue(null);
 				  form.reset();
 				  var academyLocationId = ob.up('form').down('#academyLocationId');
 				  var academyLocationStore =  academyLocationId.getStore();
 				  var store = academyLocationId.getStore();
 				 store.getProxy().extraParams = {
					  id: userId
				  };
				  store.load({
			     callback: function(record){
				 academyLocationId.select(academyLocationId.getStore().collect(academyLocationId.valueField));
					  }
				  });
 				  var academyLocation = this.getCurrentAcademyLocation();
 				  var programIdField = ob.up('form').down('#programId');
 				  var programIdFieldStore =  programIdField.getStore();
 				  programIdFieldStore.getProxy().extraParams = {
 					  academyLocationIds: academyLocation
 				  };
 				  programIdFieldStore.load();
 				  
 				  var enquiryId = ob.up('form').down('#enquiryId');
 				  var enquiryStore = enquiryId.getStore();
 				  enquiryStore.getProxy().extraParams = {
 					  academyLocationIds: academyLocation
 				  };
 				  enquiryStore.load();
 			  }
 		  },
 		  'followupdashboardfilter button[itemId=searchBtn]' : {
 			    click: function(){
 			      var formLayout = this.getFollowupdashboardfilter();
   				  this.showInvalidIconOnField(formLayout);
 			       var form = this.getFollowupdashboardfilter().getForm();
 			       var values = form.getValues();
                   var $this=this;
 			       var academyLocationIds = this.getAcademyLocationIds();
 			       var enquiryId = values.enquiryId;
 			       if(isNullOrEmpty(enquiryId)){
 			    	   var displayValue =  form.findField('enquiryId').getDisplayValue();
 			    	   if(!isNullOrEmpty(displayValue)){
 			    		   var arr = displayValue.split('/');
 			    		   var enqCode = arr[0].trim();
 			    		   if(!isNullOrEmpty(form.findField('enquiryId').store.findRecord('valueCode',enqCode))){
 			    			   enquiryId = form.findField('enquiryId').store.findRecord('valueCode',enqCode).data.id;
 			    		   }
 			    	   }
 			       }
 			      
 			       var seatTypeIds = values.seatType;
 			       var intakeYearId = values.intakeYear;
 			       var enquiryOwner = values.enquiryOwner;
 			       var programId = values.programId;
 			       var batchId = values.batch;
 			       var fromDateString = values.fromdate;
 			       var toDateString = values.todate;
 			       var followUpUser=values.followUpUser;
 			       var grid = this.getFollowupdashboardgrid();
 			       
 			       if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
 	 			     var seatTypeIdsArray=[];
 	 			     for(var i in seatTypeIds) {
 	 			     	if(typeof seatTypeIds[i] == "object") {
 	 			     	seatTypeIdsArray.push(seatTypeIds[i].data.id);
 	 			     	} else {
 	 			     		seatTypeIdsArray.push(seatTypeIds[i]);
 	 			      	}
 	 			     }
 	 			     var seatTypeIdsString = seatTypeIdsArray.join();
 	 			     }

 			       var store = grid.getStore();
 			       $this.resetPageSetting(store);
 			       store.getProxy().extraParams = {
 			       academyLocationIds: academyLocationIds,
 			       enquiryId  :enquiryId,
 			       intakeYearId:intakeYearId,
 			       program :programId,
 			       batchId :batchId,
 			       fromDate :fromDateString,
 			       toDate:toDateString,
 			       owner:enquiryOwner,
 			       followUpUser:followUpUser,
 			       seatTypeIds : seatTypeIdsString
 			       };
 			       store.load({
 			    	  callback: function(records, operation, success) {
						if(records.length>0){
							var buttonsToolBar = grid.query('toolbar')[0];
					    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
					    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
					    	pdftoolbar.setDisabled(false);
					    	exceltoolbar.setDisabled(false);
						}
					  }
 			       });
 			       
 			      /***************Start Code added for show filter data on PDF/Excel Export Report **************/
 			    	
 			    	grid.config.searchFilterForm = this.getFollowupdashboardfilter();
 			    	
 			    	/***************End Code added for show filter data on PDF/Excel Export Report **************/

 			       }      
 		  },
    		  'appointmentdashboardreportgrid':{
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				  if(columnName=="enqCode"){
    					  if(e.target.tagName=='A'){
    						  var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
    						  trackEnquiryController.openEnquiryFromDashlet(0,0,grid,'Edit');
    						  e.stopEvent();
    						  e.stopPropagation();
    					  }
    				  }
    			  },
    			  render: function(grid){
     				 var buttonsToolBar = grid.query('toolbar')[0];
     				  var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
     				  var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
     				  pdftoolbar.setDisabled(true);
     				  exceltoolbar.setDisabled(true);
     			  }
    		  },
    		  'followupdashboardgrid':{
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				  if(columnName=="enqCode"){
    					  if(e.target.tagName=='A'){
    						  var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
    						  trackEnquiryController.openEnquiryFromDashlet(0,0,grid,'Edit');
    						  e.stopEvent();
    						  e.stopPropagation();
    					  }
    				  }
    			  },
    			  render: function(grid){
    				 var buttonsToolBar = grid.query('toolbar')[0];
    				  var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    				  var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    				  pdftoolbar.setDisabled(true);
    				  exceltoolbar.setDisabled(true);
    			  }
    		  },
    		  'padmacademylocationgridwithcampaign customcombobox#academylocationsearchcombo' : {
    			  select:function(obj, record){
					  var grid = this.getPadmacademylocationgridwithcampaign();
    				  grid.getStore().clearFilter();
    				  grid.getStore().filter({property: 'id',
    					  value: record[0].get('id'),
    					  exactMatch: true,
    					  caseSensitive: true});
						  var totalRecordDisplayField=grid.down('#totalRecordDisplayField');
						  totalRecordDisplayField.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+grid.getStore().getCount())
    			  }
    		  },
    		  'padmcampaignprogrammapstructure button#resetBtn':{
    			  click:function(btn){
    				  var tabStructure = this.getPadmcampaignprogrammapstructure();
    				  var activeGrid = tabStructure.getActiveTab().down('grid');
    				  activeGrid.getSelectionModel().deselectAll();
    				  activeGrid.getStore().clearFilter();
    				  activeGrid.getStore().each(function(record){
    					    record.data.contactPersonValue = '';
    					    record.data.remarkValue = '';
    					});
    				  activeGrid.getStore().commitChanges();
    				  activeGrid.getView().refresh();
    				  if(activeGrid.down('customcombobox')){
    					  activeGrid.down('customcombobox').reset();
    				  }
    			  }
    		  },
	 		  'padmacademylocationgridwithcampaign button#nextButton':{
	 			  click:function(btn){
	 				  this.pAdmCampaignAcademyLocationNextEvent(btn);
	 			  }
	 		  },
	 		  'padmcampaignprogrammapstructure button#submitCampaignMapping':{
	 			  click:function(btn){
	 				  this.submitCampaignMappingWithALProgram();
	 			  }
	 		  },
	 		  'padmcampaignalprogramgrid customcombobox#programsearchcombo' : {
	 			  select:function(obj, record){
	 				  var grid = this.getPadmcampaignalprogramgrid();
					  grid.getStore().clearFilter();
	 				  grid.getStore().filter({property: 'programId',
	 					  value: record[0].get('id'),
	 					  exactMatch: true,
	 					  caseSensitive: true});
						  var totalRecordDisplayField=grid.down('#totalRecordDisplayField');
						  totalRecordDisplayField.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+grid.getStore().getCount())
	 			  }
	 		  },
	 		  'padmcampaignprogrammapstructure':{
	 			  tabchange:function(tabPanel, newCard, oldCard, eOpts){
	 				  var newTabName=newCard;
	 				  if(newTabName.title==getCommonTranslation('ACADEMY_LOCATION')){
	 					  tabPanel.items.items[1].setDisabled(true);
	 				  }else{
	 					  tabPanel.items.items[1].setDisabled(false);
	 				  }
	 			  }
	 		  },
	 		  'followupdashboardstructure': {
      			render:function(structure){
      				var $this = this
      				structure.body.on('click', function() {
      					var filter = structure.down('followupdashboardfilter');
      					$this.hideInvalidIconFromField(filter);
      			       });
      			}
      		},
      		 'appointmentdashboardreportstructure': {
       			render:function(structure){
       				var $this = this
       				structure.body.on('click', function() {
       					var filter = structure.down('appointmentdashboardreportfilter');
       					$this.hideInvalidIconFromField(filter);
       			       });
       			}
       		},
       		'programAssociatedGrid customcombobox#academyLocationId': {
       			select:function(obj, record){
       				var gridWindow = this.getProgramAssociatedGrid();
       				var campaignId = gridWindow.down('#campaignId').getValue();
       				var programId = gridWindow.down('#programId').getValue();
       				var whetherDeleted = gridWindow.down('#whetherDeleted').getValue();
       				var store = gridWindow.down('grid').getStore();
       				store.getProxy().extraParams={
       					campaignId:campaignId,
       					programId:programId,
       					whetherDeleted:whetherDeleted,
       					academyLocationId:record[0].get('id'),
       					sort:null
       				};
       				store.load(); 
       			}
	 		  }
    	  });
      },
      /**
	   * for collapsible search
	   */
    /*  onCampaignManagementPanelRender: function(that, layout, eOpts ) { 
    	  	$this = this;
    	  	var messageWindow = $this.getCampaignmanagementmessage();
    		var campaignQuickSearchtab =$this.getCampaignQuickSearch();
    		var campaignManagementTab=$this.getCampaignsmanagement();
    		messageWindow.el.dom.addEventListener('click', function(){
    	  		$this.expandSearchTab(campaignQuickSearchtab, messageWindow, campaignManagementTab);
    	  	});
        	that.tab.el.dom.querySelector('span.searchIcon').addEventListener('click', function(){
        	if(campaignQuickSearchtab.collapsed == "top"){
        		$this.expandSearchTab(campaignQuickSearchtab, messageWindow, campaignManagementTab);
        	}else if(campaignQuickSearchtab.collapsed == false){
        		$this.collapseSearchTab(campaignQuickSearchtab, messageWindow, campaignManagementTab);
        	}
    	}); 
    	setTimeout(function(){
    		$this.collapseSearchTab(campaignQuickSearchtab, messageWindow, campaignManagementTab);
    		campaignQuickSearchtab.ownerCt.tab.addCls('tabCls');
    	 	}, 1);
      },
      expandSearchTab: function(campaignQuickSearchtab, messageWindow, campaignManagementTab){
    	  campaignQuickSearchtab.expand();
    	  campaignQuickSearchtab.show();
    	  messageWindow.hide(); 
    	  campaignManagementTab.setIconCls('searchIcon');
    	  campaignManagementTab.setBodyStyle('top:-8px;');
      },*/
      getAcademyLocationIds: function(){
     
      	var form =this.getFollowupdashboardfilter().getForm();
      	var values = form.getValues();
      	var aL = values.academyLocation;
      	var mAL = values.multiselectAcademyLocation;

      	var alArray=[];
      	var mALArray=[];

      	if(aL !=undefined && aL.length > 0 && aL!=""){
      		for(var i in aL){
      			if(Ext.isObject(aL[0])){
      				alArray.push(aL[i].get("id"));
      			}else{
      				alArray.push(aL[i]);
      			}
      		}
      		academyLocation= alArray.join();

      	}else if(mAL !=undefined && mAL.length > 0 && mAL!=""){
      		for(var i in mAL){
      			if(Ext.isObject(mAL[0])){
      				mALArray.push(mAL[i].get("id"));
      			}else{
      				mALArray.push(mAL[i]);
      			}
      		}
      		academyLocation= mALArray.join();
      	}else{
      		academyLocation = this.getCurrentAcademyLocation();
      	}
      	return academyLocation;
      },
      getUserAccessibleAL:function(){
   	   var academyLocationId = [];
   	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
   	   for(var i=0; i<academyLocationList.length; i++){
   		   academyLocationId.push(academyLocationList[i].id);
   	   }
   	   return academyLocationId;
      },
     
      getAcademyLocation: function(){
    	     
        	var form =this.getAppointmentdashboardreportfilter().getForm();
        	var values = form.getValues();
        	var aL = values.academyLocation;
        	var mAL = values.multiselectAcademyLocation;

        	var alArray=[];
        	var mALArray=[];

        	if(aL !=undefined && aL.length > 0 && aL!=""){
        		for(var i in aL){
        			if(Ext.isObject(aL[0])){
        				alArray.push(aL[i].get("id"));
        			}else{
        				alArray.push(aL[i]);
        			}
        		}
        		academyLocation= alArray.join();

        	}else if(mAL !=undefined && mAL.length > 0 && mAL!=""){
        		for(var i in mAL){
        			if(Ext.isObject(mAL[0])){
        				mALArray.push(mAL[i].get("id"));
        			}else{
        				mALArray.push(mAL[i]);
        			}
        		}
        		academyLocation= mALArray.join();
        	}else{
        		academyLocation = this.getCurrentAcademyLocation();
        	}
        	return academyLocation;
        },
      /**
		 * it is used to check unique Campaign Code
		 */
      
      
      checkUniquenessForCampaignCode : function(response) {
			var $this = this;
			var form = $this.getCampaignsform().getForm();
			var code = form.findField('code')
					.getValue();
			var id = form.findField('id').getValue();
			Ext.Ajax
					.request({
						method : "GET",
						type : 'rest',
						url : SERVERURL.CAMPAIGN_CODE_CHECK_UNIQUENESS,
						params : {
							code : code,
							id : id,
						},
						headers : {
							'Content-Type' : 'application/json'
						},
						callback : function(resp,callback, action) {
							var mssg = action.responseText;
							if (mssg == "false") {
//								console.log(mssg);
								showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('CAMPAIGN_CODE_EXISTS'));
								form.findField('code').reset();
							}
						}
					});
		},
      
      collapseSearchTab: function(campaignQuickSearchtab, messageWindow, campaignManagementTab){
    	  campaignQuickSearchtab.collapse();
    	  campaignQuickSearchtab.hide();
    		messageWindow.show();
    		setTimeout(function(){
    			campaignManagementTab.setIconCls('downIconCls');
    			campaignManagementTab.setBodyStyle('top:0px;');
        		var h = campaignManagementTab.getHeight();
        		campaignManagementTab.setHeight(h+10);
        		campaignManagementTab.setHeight(h);
    		},1);
      },
      getTrackEnquiryController:function(){
    	return this.getController('enquiry.TrackEnquiryController');
      },
      openDetailTabGrids:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts, viewTitle){
    	  var $this = this;
    	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
    	  var tab =$this.getCampaigndashboard();
    	  
    	  if(e.target.tagName=="A"){
    		 
    		  var gridArray=$this.getCmpdetailstab();
    		  // disabled all the grid
    		  for(var i=0;i<gridArray.items.items.length;i++){
    			  gridArray.items.items[i].setVisible(false);
    		  }
    		  if(columnName=='campaignCode'){
    			  //this.editCampaignFormWindow(grid);
    			  this.viewCampaignFormWindow(grid);
    		  }else{
    		  /**
    		   * This code is for activate "Detail tab" when we click on any link in grid other than campaign code.
    		   */
    		   tab.items.items[1].setVisible(true);
    		   tab.items.items[1].tab.setVisible(true);
    		   tab.setActiveTab(tab.items.items[1]);
    		   
    		   if(columnName=='noOfApplications'){
    			   var grid=$this.getApplicationgrid();
    			   var campaignId=record.data.campaignId;

    			   /**
    			    * @author Rajkumar.patidar 
    			    * check user rights for AL
    			    */
    			   var submitUrl = SERVERURL.CAMPAIGN_NOOFENQGENERATED;
    			   Ext.Ajax.request({type:'rest',url:submitUrl,method:'GET',params:{campaignId:campaignId},
    				   success: function(response, action) {
    					   var enquiryId = response.responseText;
    					   var configCode=CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_CONFIGCODE;
    					   var viewCode=CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_VIEWCODE;
    					   $this.commonGridRenderFunction(grid,enquiryId,configCode,viewCode);
    					   grid.setVisible(true);
    				   }
    			   });
    		   }

    		   if(columnName=='totalEnquiry'){
    			   var grid=$this.getEnquiryregisteredgrid();
    			   var campaignId = record.data.campaignId;

    			   /**
    			    * @author Rajkumar.patidar 
    			    * check user rights for AL
    			    */
    			   var submitUrl = SERVERURL.CAMPAIGN_NOOFENQGENERATED;
    			   Ext.Ajax.request({type:'rest',url:submitUrl,method:'GET',params:{campaignId:campaignId},
    				   success: function(response, action) {
    					   var enquiryId = response.responseText;
    					   var configCode = CONSTANTS.CB.CAMPAIGN_ENQUIRYREGISTRED_LIST_CONFIGCODE;
    					   var viewCode = CONSTANTS.CB.CAMPAIGN_ENQUIRYREGISTRED_LIST_VIEWCODE;
    					   $this.commonGridRenderFunction(grid,enquiryId,configCode,viewCode);
    					   $this.rec=enquiryId;
    					   grid.setVisible(true);
    				   }
    			   });
    		   }
    		  if(columnName=='studentSelected'){
    			  var grid=$this.getSelectstudentgrid();
    			  var campaignId = record.data.campaignId;
    			  var configCode = CONSTANTS.CB.CAMPAIGN_SELECTSTUDENT_LIST_CONFIGCODE;
    			  var viewCode = CONSTANTS.CB.CAMPAIGN_SELECTSTUDENT_LIST_VIEWCODE;
    			  this.commonGridRenderFunction(grid,campaignId,configCode,viewCode);
    			  grid.setVisible(true);
    		  }

    		  if(columnName=='studentAdmitted'){
    			  var grid=$this.getStudentadmitgrid();
    			  var campaignId = record.data.campaignId;
    			  /**
    			   * @author Rajkumar.patidar 
    			   * check user rights for AL
    			   */
    			  var submitUrl = SERVERURL.CAMPAIGN_STUDENT_ENROLLMENT_UR;
    			  Ext.Ajax.request({type:'rest',url:submitUrl,method:'GET',params:{campaignId:campaignId},
    				  success: function(response, action) {
    					  var enquiryId = response.responseText;
    					  var configCode = CONSTANTS.CB.CAMPAIGN_STUDENTADMITTED_LIST_CONFIGCODE;
            			  var viewCode = CONSTANTS.CB.CAMPAIGN_STUDENTADMITTED_LIST_VIEWCODE;
            			  $this.commonGridRenderFunction(grid,enquiryId,configCode,viewCode);
            			  grid.setVisible(true);
    				  }
    			  });
    		  }

    		  if(columnName=='academiesCovered'){
    			  var grid=$this.getAcademycoveredgrid();
    			  var campaignId=record.data.campaignId;
    			  var configCode=CONSTANTS.CB.ACADEMY_CAMPAIGNWISE_LIST_CONFIGCODE;
    			  var viewCode=CONSTANTS.CB.ACADEMY_CAMPAIGNWISE_LIST_VIEWCODE;
    			  this.commonGridRenderFunction(grid,campaignId,configCode,viewCode);
    			  grid.setVisible(true);
    		  }

    		  if(columnName=='locationsCovered'){ // checked
    			  var grid=$this.getLocationcoveredgrid();
    			  var campaignId=record.data.campaignId;
    			  var configCode=CONSTANTS.CB.CAMPAIGN_LOCATIONCOVERED_LIST_CONFIGCODE;
    			  var viewCode=CONSTANTS.CB.CAMPAIGN_LOCATIONCOVERED_LIST_VIEWCODE;
    			  this.commonGridRenderFunction(grid,campaignId,configCode,viewCode);
    			  grid.setVisible(true);
    		  }

    		  if(columnName=='programsCovered'){ // checked
    			  var grid = $this.getProgramcoveredgrid();
    			  var campaignId = record.data.campaignId;
    			  /**
    			   * @author Rajkumar.patidar 
    			   * check user rights for AL
    			   */
    			  var submitUrl = SERVERURL.CAMPAIGN_PROGRAM_COVERED;
    			  Ext.Ajax.request({type:'rest',url:submitUrl,method:'GET',params:{id:campaignId},
    				  success: function(response, action) {
    					  var data = response.responseText;
    					  var record = new Object;
    					  record.programId = data;
    					  record.campaignId = campaignId;
    					  var configCode= CONSTANTS.CB.CAMPAIGN_PROGRAMCOVERED_LIST_CONFIGCODE;
    					  var viewCode = CONSTANTS.CB.CAMPAIGN_PROGRAMCOVERED_LIST_VIEWCODE;
    					  $this.commonGridRenderFunction(grid,record,configCode,viewCode);
    					  grid.setVisible(true);
    				  }
    			  });
    		  }
    		  grid.setTitle(viewTitle);
    		  }
    	  }
    	  var form = $this.getCmpsummarytab();
    	  
    	  var store =this.getStore('campaign.CampaignPerformanceDashBoard');
    	  
    	  if(grid.itemId==='activecampaigngrid'){
    		  form.down("#activecampaigncharts").setVisible(true);
    		  var enquiryView = form.down("#campaignpiechartreportforenquiry");
    		  var storeForEnquiry = enquiryView.getStore(); 
    		  var applicationView = form.down("#campaignpiechartreportforapplication");
    		  var storeForApplication = applicationView.getStore(); 
    		  var selectionView = form.down("#campaignpiechartreportforselection");
    		  var storeForSelection = selectionView.getStore(); 
    		  var admissionView = form.down("#campaignpiechartreportforadmission");
    		  var storeForAdmission = admissionView.getStore(); 
    		  store.load({params:{ id:record.data.campaignId},
    			  callback: function(record, operation, success) {
    				  if (success) {
    					  var enquiryData={"id":1,"name":getCampaignTranslation('NO_OF_ENQUIRER')+'('+record[2].get("data")+')',"data":(record[2].get("data")>0 ? record[2].get("data") : 1),"count":record[2].get("data")};
    					  storeForEnquiry.loadData([enquiryData]);
    					  enquiryView.setSize(record[2].get("pixel"),record[2].get("pixel"));
    					  var applicationData={"id":2,"name":getCampaignTranslation('NO_OF_APPLICATION')+'('+record[1].get("data")+')',"data":(record[1].get("data")>0 ? record[1].get("data") : 1),"count":record[1].get("data")};
    					  storeForApplication.loadData([applicationData]);
    					  applicationView.setSize(record[1].get("pixel"),record[1].get("pixel"));
    					  var selectionData={"id":3,"name":getCampaignTranslation('NO_OF_SELECTION')+'('+record[3].get("data")+')',"data":(record[3].get("data")>0 ? record[3].get("data") : 1),"count":record[3].get("data")};
    					  storeForSelection.loadData([selectionData]);
    					  selectionView.setSize(record[3].get("pixel"),record[3].get("pixel"));
    					  var admissionData={"id":4,"name":getCampaignTranslation('NO_OF_ADMISSION')+'('+record[0].get("data")+')',"data":(record[0].get("data")>0 ? record[0].get("data") : 1),"count":record[0].get("data")};
    					  storeForAdmission.loadData([admissionData]);
    					  admissionView.setSize(record[0].get("pixel"),record[0].get("pixel"));
    				  }
    			  }
    		  });
    	  }else if(grid.itemId==='pastcampaigngrid'){
    		  form.down("#pastcampaigncharts").setVisible(true);
    		  var enquiryView = form.down("#pastcampaignpiechartreportforenquiry");
    		  var storeForEnquiry = enquiryView.getStore(); 
    		  var applicationView = form.down("#pastcampaignpiechartreportforapplication");
    		  var storeForApplication = applicationView.getStore(); 
    		  var selectionView = form.down("#pastcampaignpiechartreportforselection");
    		  var storeForSelection = selectionView.getStore(); 
    		  var admissionView = form.down("#pastcampaignpiechartreportforadmission");
    		  var storeForAdmission = admissionView.getStore(); 
    		  store.load({params:{ id:record.data.campaignId},
    			  callback: function(record, operation, success) {
    				  if (success) {
    					  var enquiryData={"id":1,"name":getCampaignTranslation('NO_OF_ENQUIRER')+'('+record[2].get("data")+')',"data":(record[2].get("data")>0 ? record[2].get("data") : 1),"count":record[2].get("data")};
    					  storeForEnquiry.loadData([enquiryData]);
    					  enquiryView.setSize(record[2].get("pixel"),record[2].get("pixel"));
    					  var applicationData={"id":2,"name":getCampaignTranslation('NO_OF_APPLICATION')+'('+record[1].get("data")+')',"data":(record[1].get("data")>0 ? record[1].get("data") : 1),"count":record[1].get("data")};
    					  storeForApplication.loadData([applicationData]);
    					  applicationView.setSize(record[1].get("pixel"),record[1].get("pixel"));
    					  var selectionData={"id":3,"name":getCampaignTranslation('NO_OF_SELECTION')+'('+record[3].get("data")+')',"data":(record[3].get("data")>0 ? record[3].get("data") : 1),"count":record[3].get("data")};
    					  storeForSelection.loadData([selectionData]);
    					  selectionView.setSize(record[3].get("pixel"),record[3].get("pixel"));
    					  var admissionData={"id":4,"name":getCampaignTranslation('NO_OF_ADMISSION')+'('+record[0].get("data")+')',"data":(record[0].get("data")>0 ? record[0].get("data") : 1),"count":record[0].get("data")};
    					  storeForAdmission.loadData([admissionData]);
    					  admissionView.setSize(record[0].get("pixel"),record[0].get("pixel"));
    				  }
    			  }
    		  });
    	  }
      },
      gridRender: function() {
    	  var store = this.getStore('campaign.CampaignsStructureStore');
    	  store.load();
      },
      formRender: function() {
    	  var store = this.getStore('campaign.MediaStructureStore');
    	  store.load();
      },
      viewCampaignFormWindow: function(grid) {

		  this.editCampaignFormWindow(grid, true);
		  /*
		   * second param true added to only view the deleted records 
		   * if its value is true in the above function
		   */
		  var campform = this.getCampaigns();
		  var form = campform.getForm();

    		  var campGrid = this.getCampaignscoveragegrid();

    		  if (form) {
    			  campform.down('#saveCampaign').setVisible(false);
    			  campform.down('#cancelCampaign').setVisible(false);
    			  //campform.down('#campaignMedias').setVisible(false);
    			  //campform.down('#multiselect').setVisible(true);
                   
    			  campGrid.down('#btnAdd').setVisible(false);
    			  campGrid.down('#btnEdit').setVisible(false);
    			  campGrid.down('#btnDelete').setVisible(false);
    			  
    			  this.toggleReadOnlyFormItems(form,true);
    			
    		  }
      },
      showFormWindow: function() {
    	  var formWindow = this.getCampaignscoverageform();
    	  if (!formWindow) {
    		  Ext.widget('campaignscoverageform');
    		  formWindow = this.getCampaignscoverageform();
    	  }
    	  formWindow.show();
      },
      showCampaignsFormWindow: function() {
    	  var formWindow = this.getCampaignscoverageform();
    	  if (!formWindow) {
    		  Ext.widget('campaignscoverageform');
    		  formWindow = this.getCampaignscoverageform();
    	  }
    	  formWindow.show();
      },
      closeFormWindow: function() {
    	  this.getCampaignscoverageform().close();
      },
      gridSelectionChange: function(model, records) {
    	  if (records[0]) {
    		  this.getCampaignsmanagement().getStore().load(records[0]);
    	  }
      },

      deleteCampaignFormWindow: function() {

    	  var grid = this.getCampaignscoveragegrid();
    	  var store = grid.getStore();

    	  if (grid.getSelectionModel().getCount() > 0) {

    		  var records = grid.getSelectionModel().getSelection()[0];

    		  showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) { //Are you sure you want to delete the selected record?
    			  if (btn == 'yes') {
    				  store.remove(records);
    				  grid.getView().refresh();
					  var totalRecordDisplayField=grid.down('#totalRecordDisplayField');
	    		      totalRecordDisplayField.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+store.getCount());
    				  showSuccessMessage(getCommonTranslation('CAMPAIGN_DELETE_MAPPING'), getCommonTranslation('CAMPAIGN_MAPPING_DELETE_MESSAGE'));
    			  }
    		  });

    	  } else {
    		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
    	  }
      },

      addCampaignGrid: function(f) {
    	  //this.showInvalidIconOnField(this.getCampaignscoverageform().down('form'));
    	  var form = this.getCampaignscoverageform().down('form').getForm();
    	  var values = form.getValues();

    	  var grid = this.getCampaignscoveragegrid();
    	  var store = grid.getStore();

    	  var id = form.findField('id').getValue();

    	  var academyName = form.findField('academyLocation').getRawValue();
    	  var academyId = form.findField('academyLocation').getValue();

    	  var programName = form.findField('programId').getRawValue();
//    	  var programId = form.findField('programId').getValue();
    	  var userName = form.findField('userId').getRawValue();
    	  var userId = form.findField('userId').getValue();
    	  var ObjModel = [];
    	  var programss = form.findField('programId').valueModels;
    	  if(!isNullOrEmpty(programss)) {
    		  for (var i in programss) {
    			  var programName = programss[i].data.value;
    			  var programId =  programss[i].data.id;
    			  var location =  academyName.split('-');
    	    	  var data = {
    	    			  id: id,
    	    			  academy: academyName,
    	    			  location: location[1],
    	    			  program: programName,
    	    			  user: userName,
    	    			  coverageRemarks: values.coverageRemarks,
    	    			  academyId: academyId,
    	    			  programId: programId,
    	    			  userId: userId
    	    	  };
    	    	  ObjModel.push(data);
    		  }
    	  }
    	  var records = grid.getSelectionModel().getSelection();
    	  var rowIndex = store.indexOf(records[0]);
    	  //edit campaign coverage details
    	  if(id != "" || values.isSaved === "0"){
    		  var prevDetail = this.currentCoverageDetails;
    		  if(prevDetail.academyId === academyId && prevDetail.programId === programId){
    			  //store.loadRawData(data, true);
    			  this.editCampaignCoverageGridRecord(records[0], ObjModel);
    			  this.getCampaignscoverageform().close();
    		  }
    		  else{
    			  var tempObj = new Array();
    			  store.each(function(record) {
    				  if(record.data.academyId === academyId){
    					  tempObj.push(record);
    				  }
    			  });
    			  var addToGrid = true;
    			  for(var i=0; i<tempObj.length; i++){
    				  if(tempObj[i].data.programId === programId){
    					  addToGrid = false;
    				  }
    			  }
    			  if(addToGrid === true){
    				  this.editCampaignCoverageGridRecord(records[0], ObjModel);
    				  this.getCampaignscoverageform().close();
    			  }
    			  else{
    				  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
    			  }
    		  }
    	  }
    	  //add new campaign coverage details
    	  else if(store.find('academyId', academyId) == -1 || store.find('programId', programId)==-1) {
    		  if (rowIndex >= 0 && id != "") {
    			  store.remove(records[0]);
    		  }
    		  store.loadRawData(ObjModel, true);
    		  this.getCampaignscoverageform().close();
    	  }else{
    		  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('RECORD_IS_ALREADY_EXIST'));  
    	  }
      },
      /**
       * below function is used to edit existing Campaign Coverage Grid Record
       * */
      editCampaignCoverageGridRecord: function(rec, data){
    	  for(var i in data) {
    		  if(!isNullOrEmpty(data[i].id)) {
    			  rec.set('id', data[i].id);
    		  }
        	  rec.set('academy', data[i].academy);
        	  rec.set('location', data[i].location);
        	  rec.set('program', data[i].program);
        	  rec.set('user', data[i].user);
        	  rec.set('coverageRemarks', data[i].coverageRemarks);
        	  rec.set('academyId', data[i].academyId);
        	  rec.set('programId', data[i].programId);
        	  rec.set('userId', data[i].userId);
    	  }
      },

      refreshCampaignCovrageGrid: function() {

    	  var grid = this.getCampaignscoveragegrid();

    	  if (!grid) {
    		  Ext.widget('campaignscoveragegrid');
    		  grid = this.getCampaignscoveragegrid();
    	  }

    	  grid.getStore().removeAll();

      },

      openNewCmpTab: function() { // to open a new tab
    	  var tabName = getCommonTranslation('CAMPAIGN_TAB_NAME');
    	  var contentpanel = this.getContentPanel();
    	  var campaigngrid = Ext.widget('campaigns');
    	  Ext.Array.each(contentpanel.items.items,function(value){
    		  if(!isNullOrEmpty(value) && !isNullOrEmpty(value.title) &&  value.title === getCommonTranslation('CAMPAIGN_TAB_NAME')){
    			  contentpanel.remove(value, true);
    		  }
    	  });
    	  /**
      	   * This is to remove tab from content panel and open same tab again 
      	   */
      	  var getcontroller=this.getController('menu.CoreERPNavigationController');
      	  var getTab=getcontroller.getTab(tabName);
      	   if(getTab!=null){
      		 contentpanel.remove(getTab, true);
      	   }
    	  openTab(contentpanel, tabName, campaigngrid,CONSTANTS.MENU_COLOR_ONE);
    	  this.refreshCampaignCovrageGrid();
    	  var form = this.getCampaignsform();
    	  // for datasetting manual checked
    	   Ext.Ajax.request({
          	 type: 'rest',
          	 url: SERVERURL.FIND_WHETHER_CONFIGORNOT_DATA_SETTING_OF_CAMPAIGN_CODE,
          	 method: 'GET',
          	 headers : {
          		 'Content-Type' : 'application/json'
          	 },
          	 success: function(response, action) {
                var data = response.responseText;
                if(data == "true"){
              	  form.down('#code').setReadOnly(false);
        	    	  form.down('#code').allowBlank = false;  
        	    	  form.down('#code').emptyText = ' ';
        	    	  form.down('#code').applyEmptyText();
        	    	  form.down('#code').labelSeparator = '';
          			  form.down('#code').setFieldLabel(getCommonTranslation('CAMPAIGN_CODE')+':<span class="required" style="color:red"> *</span>');
                }else{
              	  form.down('#code').setReadOnly(true);
        	    	  form.down('#code').allowBlank = true; 
        	    	  form.down('#code').emptyText = getCommonTranslation('ID_AUTOGENERATE');
        	    	  form.down('#code').applyEmptyText();
                }                        
          	 }
           });
      },
      //	edit function to edit campaign record
      editCampaignFormWindow: function(grid, isShow) {
    	  //@param isShow added to only view the deleted records if its value is true
    	  var this$ = this;
    	  if (grid.getSelectionModel().getCount() > 0) { // checking if record is selected or not
    		  // checking if record is deleted then do not allow to edit
    		  var val=grid.getSelectionModel().getSelection()[0].data; 
    		  if(!val.whether_Deleted || isShow === true){
    			  var records = grid.getSelectionModel().getSelection();
        		  this.openNewCmpTab();
        		  var campform = this.getCampaigns();
        		  campform.down("#cancelCampaign").setVisible(false);
        		  var userCombo = this$.getCampaignsform().down('#contactPerson1');
        		  userCombo.getStore().load();
        		  
        		  Ext.Ajax.request({
        			  type: 'rest',
        			  url: SERVERURL.CAMPAIGN_FIND_BY_ID,
        			  method: 'GET',
        			  params: {
        				  campaignId: (records[0].data.CAMPAIGN_ID != undefined)?records[0].data.CAMPAIGN_ID:records[0].data.campaignId,
        				  programId:records[0].data.PROGRAM_ID,
        				  isDeleted:val.whether_Deleted
        			  },
        			  success: function(res, action) {
        				  var data = Ext.decode(res.responseText);
        				  this$.loadCampaignForm(data);
        				  var userId = data.user.id;
        				  if(userId){
        					  userCombo.setValue(userId); 
        				  }
        				 /* if(userId){

        					  userStore.load({
        						  callback: function(record, operation, success) {
        							  if (success) {
        								  userCombo.setValue(userId);
        							  }
        						  }
        					  });
        				  }*/

        			  }
        		  });
    		  } else {
    			  // message for record already deleted
    			  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'),getCommonTranslation('DELETED_MSSG'));
    		  }
    	  } else {
    		  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	  }
      },
      loadCampaignForm: function(records) {

    	  var $this = this;
    	  var form = this.getCampaignsform();
    	  var f = form.getForm();
    	  f.setValues(records);
    	  form.down("#fromDate").setValue(dateRender(records.fromDate));
    	  form.down("#toDate").setValue(dateRender(records.toDate));
    	  var cc = records.campaignCoverages; // getting all campaign coverages
    	  var data = [];
    	  for (var i = 0; i < cc.length; i++) {
    		  data.push({
    			  id: cc[i].id,
    			  academy: cc[i].academyName,
    			  location: cc[i].locationName,
    			  program: cc[i].program.value,
    			  user: cc[i].user.value,
    			  coverageRemarks: cc[i].coverageRemarks,
    			  academyId: cc[i].academyLocation.id,
    			  programId: cc[i].program.id,
    			  userId: cc[i].user.id
    		  });
    	  };
    	  this.refreshCampaignCovrageGrid();
    	  this.getCampaignscoveragegrid().getStore().loadRawData(data, true);

    	  var userId=0;
    	  if (records.user != null) {
    		  userId = records.user.id;
    	  };
    	  var contactPersonStore = $this.getStore('common.UsersComboStore');
    	  contactPersonStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  f.findField("contactPerson").setValue(userId);
    			  }
    		  }
    	  });

    	  var cmpMediasData = [];
    	  var cmpMediasName = [];
    	  var cmpMediasId = [];
    	  Ext.each(records.campaignMedias, function(value) {
    		  cmpMediasName.push(value.mediaName);
    		  cmpMediasData.push(value.mediaId);
    		  cmpMediasId.push(value.id);
    	  });
    	  //f.findField("multiselect").setValue(cmpMediasName);
    	  f.findField("campaignMedias").setValue(cmpMediasData);
    	  f.findField("campaignMediaId").setValue(cmpMediasId);
    	  f.findField("code").setReadOnly(true);
    	  f.findField("actualAmount").show();
      },

      // delete function to delete a campaign record from campaign grid view
      deleteRecord: function() {
    	  var grid = this.getSearchResultGrid();

    	  if (grid.getSelectionModel().getCount() > 0) {
    		  
    		  var val=grid.getSelectionModel().getSelection()[0].data; 
    		  if(!val.whether_Deleted){
    			// checking if record is selected or not
    			  showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('CAMPAIGN_DELETE_CONFIRM'), function(btn, text) {
        			  if (btn == 'yes') {
        				  var id = grid.getSelectionModel().getSelection()[0].data.CAMPAIGN_ID; // getting campaign id and appending to url
//        				  var PROGRAM_ID = grid.getSelectionModel().getSelection()[0].data.PROGRAM_ID;
        				  Ext.Ajax.request({
        					  method: "DELETE",
        					  type: 'rest',
        					  url: SERVERURL.CAMPAIGN_DELETE+'?id='+id,
        					  headers: {
        						  'Content-Type': 'application/json'
        					  },
        					  params: {
        						  id: id,
        					  },
        					  success: function(form, action) {
        						  grid.getStore().reload(); // after deleted a record reloading the grid data
        						  showSuccessMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('CAMPAIGN_DELETED_SUCCESS'));
        					  }
        				  });
        			  }
        		  });
    		  } else {
    			  // message for record already deleted
    			  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'),getCommonTranslation('DELETED_MSSG'));
    		  }
    		  
    		  
    	  } else {
    		  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	  }
      },
      editCampaignCoverageFormWindow: function() {
    	  var grid = this.getCampaignscoveragegrid();

    	  if (grid.getSelectionModel().getCount() > 0) { // checking if record is selected or not
    		  this.showFormWindow();
    		  var form = this.getCampaignscoverageForm().getForm();
    		  var records = grid.getSelectionModel().getSelection();
    		  if (records != undefined && records != "" && records != null) {
    			  form.loadRecord(records[0]);

    			  var rec = records[0].data;
    			  this.currentCoverageDetails = rec;
    			  var academyId = rec.academyId;
    			  //var locationId = rec.locationId;
    			  var programId = rec.programId;

    			  var academyStore = this.getStore('common.AcademyLocationNameSeparated');
    			  academyStore.load({
    				  callback: function(record, operation, success) {
    					  if (success) {
    						  form.findField("academyLocation").setValue(academyId);
    					  }
    				  }
    			  });
    			  
    			  var userField = form.findField('userId');
    			  userField.getStore().getProxy().extraParams={
    				  academyLocationId:academyId  
    			  };
    			  userField.getStore().load({
    				  callback: function(record, operation, success) {
    					  if (success) {
    						  userField.setValue(rec.userId);
    					  }
    				  }
    			  });

    			  var programStore = this.getStore('common.ProgramByAcademyLocationStore');
    			  
    			  programStore.getProxy().extraParams = {
    				  academyLocationId: academyId
    			  };

    			  programStore.load({
    				  /* params: {
				  academyLocationId: academyId
			  },*/
    				  callback: function(record, operation, success) {
    					  if (success) {
    						  form.findField("programId").setValue(programId);
    					  }
    				  }
    			  });
    			  form.findField("isSaved").setValue(0);
    			  
    		  }
    	  } else {
    		  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	  }
      },
      //	campaign quick search function
      searchCmpQuickFilter: function(model, records) {
    	  var campaignViewListTab = this.getCampaignviewlisting();
    	 
		 // campaignViewListTab.setBodyStyle('top:23px');
		  
    	  var campaignSearchForm = this.getCampaignQuickSearch();
    	  campaignSearchForm.down('#campaignSearchButtonId').setDisabled(true);
    	  var jsonFormatFormData = this.createJsonFormat(campaignSearchForm, records);

    	  var searchResultGrid = this.getSearchResultGrid();

    	  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.CAMPAIGN_LIST_VIEWCODE);

    	  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,campaignSearchForm.down('#campaignSearchButtonId'));
      },
      createJsonFormat: function(campaignSearchForm, records) {
    	  campaignCodeNameSearch=campaignSearchForm.getForm().findField('CAMPAIGN_ID_NAME');
    	  var txt = campaignCodeNameSearch.getRawValue();
    	  var CAMPAIGN_ID = campaignCodeNameSearch.getValue();
    	  var currentAcademyLocationId = this.getCurrentAcademyLocation();
    	  var academyLocationId = campaignSearchForm.getForm().findField('ACADEMY_LOCATION_ID').getValue();

    	  var academyLocationId = campaignSearchForm.getForm().findField('ACADEMY_LOCATION_ID');

	   	  var programName = campaignSearchForm.getForm().findField('PROGRAM');
    	  var whetherDeletedCheckBox = campaignSearchForm.getForm().findField('whetherDeleted');

    	 var dateFrom = campaignSearchForm.getForm().findField('FROM_DATE');
		 var DateTo = campaignSearchForm.getForm().findField('TO_DATE');
    	 var multiselectAcademyLocation=campaignSearchForm.getForm().findField('ACADEMY_LOCATION_ID');
    	 var acdemyLocationArray=[];

    	  if(!isNullOrEmpty(multiselectAcademyLocation) && !multiselectAcademyLocation.isHidden()){
    		  Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
    			  if(Ext.isObject(value)){
    				  acdemyLocationArray.push(value.data.id);
    			  }else{
    				  acdemyLocationArray.push(value);	
    			  }
    		  });
    	  }

    	  var values = new Object();
    	  values.configCode = CONSTANTS.CB.CAMPAIGN_LIST_CONFIGCODE;
    	  var searchcriteria = new Array();
    	  if (campaignCodeNameSearch.getRawValue() && campaignCodeNameSearch.getRawValue()!="") {
    		  searchcriteria.push({
    			  paramCode: "CAMPAIGN_ID",
    			  paramValues: [CAMPAIGN_ID]
    		  });
    	  }
    	  if (!isNullOrEmpty(multiselectAcademyLocation) && !isNullOrEmpty(multiselectAcademyLocation.getValue()) && multiselectAcademyLocation.getValue()!="") {
    		  searchcriteria.push({
    			  paramCode: "ACADEMY_LOCATION_ID",
    			  paramValues: [acdemyLocationArray.join()]
    		  });
    	  } else {
    		  searchcriteria.push({
    			  paramCode: "ACADEMY_LOCATION_ID",
    			  paramValues: [currentAcademyLocationId]
    		  });
    	  }

    	  /*if(campaignSearchForm.getForm().findField('startDate').getValue() != "" && campaignSearchForm.getForm().findField('startDate').getValue() != null){
searchcriteria.push({paramCode:"START_DATE", paramValues:[campaignSearchForm.getForm().findField('startDate').getValue()]});
}
if(campaignSearchForm.getForm().findField('endDate').getValue() != "" && campaignSearchForm.getForm().findField('endDate').getValue() != null){
searchcriteria.push({paramCode:"END_DATE", paramValues:[campaignSearchForm.getForm().findField('endDate').getValue()]});
}*/

    	  var startDateFound = false;
    	  var endDateFound = false;

    	  if(campaignSearchForm.getForm().findField('FROM_DATE').getValue()){
    		  startDateFound = true;
    	  }

    	  if(campaignSearchForm.getForm().findField('TO_DATE').getValue()){
    		  endDateFound = true;
    	  }

    	  if( startDateFound && endDateFound ){
    		  searchcriteria.push({paramCode:"CAMPAIGN_DATE_ONE", paramValues:[campaignSearchForm.getForm().findField('FROM_DATE').getValue(),campaignSearchForm.getForm().findField('TO_DATE').getValue()]});
    		  searchcriteria.push({paramCode:"CAMPAIGN_DATE_TWO", paramValues:[campaignSearchForm.getForm().findField('FROM_DATE').getValue(),campaignSearchForm.getForm().findField('TO_DATE').getValue()]});
    	  } else{
    		  if(campaignSearchForm.getForm().findField('FROM_DATE').getValue()){
    			   searchcriteria.push({paramCode:"START_DATE_ONE", paramValues:[campaignSearchForm.getForm().findField('FROM_DATE').getValue()]});
        		  searchcriteria.push({paramCode:"START_DATE_TWO", paramValues:[campaignSearchForm.getForm().findField('FROM_DATE').getValue()]});
    			}
    		  if(campaignSearchForm.getForm().findField('TO_DATE').getValue()){
    			  searchcriteria.push({paramCode:"END_DATE_ONE", paramValues:[campaignSearchForm.getForm().findField('TO_DATE').getValue()]});
        		  searchcriteria.push({paramCode:"END_DATE_TWO", paramValues:[campaignSearchForm.getForm().findField('TO_DATE').getValue()]});    			 
    		  }
    	  }

    	  if (programName.getValue()) {
    		  searchcriteria.push({
    			  paramCode: "PROGRAM_ID",
    			  paramValues: [programName.getValue()]
    		  });
    	  }

    	  if(whetherDeletedCheckBox){
    		  searchcriteria.push({
    			  paramCode:"WHETHER_DELETED",
    			  paramValues:[whetherDeletedCheckBox.getValue()]
    		  });
    	  }
    	  searchcriteria.push({
    		  paramCode:"WHETHER_PROGRAM_DELETED",
    		  paramValues:[whetherDeletedCheckBox.getValue()]
    	  });
    	  values.searchCriterias = searchcriteria;
    	  return values;
      },
      updateCampaign: function(model, records) {
    	  var $this = this;
    	  var form = this.getCampaignsform().getForm();
    	  var values = form.getValues();
    	  var myItems = this.getCampaignscoveragegrid().store.getRange();
    	  if (myItems.length > 0) {
    		  var myJson = [];
    		  for (var i in myItems) {
    			  myJson.push({
    				  "id": myItems[i].get('id'),
    				  'academyLocation': {
    					  "id": myItems[i].get('academyId')
    				  },
    				  'program': {
    					  "id": myItems[i].get('programId')
    				  },
    				  'user': {
    					  "id": myItems[i].get('userId')
    				  },
    				  'coverageRemarks': myItems[i].get('coverageRemarks'),
    				  'whetherDeleted': false
    			  });
    		  }

    		  var media = values.campaignMedias;
           // console.log('media------------------------',media);
    		//  if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
    			  
    			  var medias = [];
    			  for(var i in media){
    				  if(Ext.isObject(media[0])){
							medias.push({
        					  "mediaId": media[i].get("id")
        				  });
    			  }else{
    				  medias.push({
      					  "mediaId": media[i]
      				  });
    				  }
    			  }

    			 /* var medias = [];
    			  for (var i = 0; i < media.length; i++) {
    				  Ext.Array.each(media,function(value){
  						if(Ext.isObject(value)){
  							medias.push({
          					  "mediaId": media[i].data.id
          				  });
  						}else{
  							medias.push({
          					  "mediaId": media[i]
          				  });
  						}
  					  });
    			  }*/

    		 /* } else {

    			  var cmpMediasId = form.findField("campaignMediaId").getValue();

    			  var medias = [];
    			  for (var i = 0; i < media.length; i++) {
    				  Ext.Array.each(media,function(value){
    						if(Ext.isObject(value)){
    							medias.push({
              					  "id": cmpMediasId.split(",")[i],
              					  "mediaId": media[i].data.id,
              					  "whetherDeleted": false
              				  });
    							//courseVariantArray.push(value.data.id);
    						}else{
    							medias.push({
              					  "id": cmpMediasId.split(",")[i],
              					  "mediaId": media[i],
              					  "whetherDeleted": false
              				  });
    						}
    					  });
    				  medias.push({
    					  "id": cmpMediasId.split(",")[i],
    					  "mediaId": media[i],
    					  "whetherDeleted": false
    				  });
    			  }
    		  }*/

    		  var compaingcovrage = new Academia.model.campaign.CampaignModel();
    		  compaingcovrage.set("id", values.id);
    		  compaingcovrage.set("code", values.code);
    		  compaingcovrage.set("campaignName", values.campaignName);
    		  compaingcovrage.set("actualAmount", values.actualAmount);
    		  compaingcovrage.set("budgetAmount", values.budgetAmount);
    		  compaingcovrage.set("fromDate", values.fromDate);
    		  compaingcovrage.set("toDate", values.toDate);
    		  compaingcovrage.set("campaignMedias", medias);
    		  compaingcovrage.set("campaignDesc", values.campaignDesc);
    		  compaingcovrage.set("remarks", values.remarks);
    		  compaingcovrage.set("whetherDeleted", false);
    		  compaingcovrage.set("academyLocation", this.getIdValueJson(this.getCurrentAcademyLocation()));
    		  compaingcovrage.set("customData",values.customData);

    		  var contactPerson = new Academia.model.common.IdValueDataModel();
    		  var userss=new Object();
    		  userss.id=values.contactPerson;
//    		  contactPerson.set("id", values.contactPerson);
    		  compaingcovrage.set("campaignCoverages", myJson);
    		  compaingcovrage.set("user", userss);
    		  var formData = Ext.encode(compaingcovrage.data);
    		  var submitUrl;
    		  if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
    			  submitUrl = SERVERURL.CAMPAIGN_CREATE;
    		  } else {
    			  submitUrl = SERVERURL.CAMPAIGN_UPDATE;
    		  }
    		  var tabName = getCommonTranslation('CAMPAIGN_TAB_NAME');
			  var getcontroller=this.getController('menu.CoreERPNavigationController');
        	  var getTab=getcontroller.getTab(tabName);
    		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		  Ext.Ajax.request({
    			  type: 'rest',
    			  url: submitUrl,
    			  jsonData: formData,
    			  method: 'POST',
    			  success: function(f, action) {
    				  Ext.getBody().unmask();
    				  showSuccessMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('SUCCESS'));
    				 /* if(values.id == null || values.id == ""){
    					  form.reset();
    					  $this.refreshCampaignCovrageGrid();
    					  $this.searchCmpQuickFilter();
    				  }*/
    				  $this.searchCmpQuickFilter();
    				  if(getTab!=null){
    					  contentPanel.remove(getTab, true);
    				  }
    			  }
    		  });
    		//  Ext.getBody().unmask();
    	  } else {
    		  Ext.getBody().unmask();
    		  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('CAMAPAIGN_COVRAGE_MSSG'));
    	  }
      },

      gridRenderFunction: function(grid) {
    	 grid.addButtonToolbar();
    	  var butonstoolbar=grid.down('#functionButtonsToolbar');
    	  butonstoolbar.insert(4,{
 			 xtype: 'button',
 			 text:getCommonTranslation('EXPORTREPORTS'),
 	         itemId:'exportCampaignReport',
  			 tooltip :getCommonTranslation('EXPORTREPORTS')
 	    });
    	  
      },

      gridCampaignRenderFunction:function(quickSearchForm){
    	  var AL= this.getOrgCMPDashboardItemId();
    	  if(AL.getValues().multiselectAcademyLocation!= undefined && AL.getValues().multiselectAcademyLocation[0] != ""){
    		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	  var searchResultGrid = this.getActivecampaigngrid();
    		  var jsonFormatFormData = this.createJsonFormatCampaignDasBord(quickSearchForm);
    		  for (var key in jsonFormatFormData) {
    			  var value = jsonFormatFormData[key]; 
    			  for ( var i in value)
    			  {
    				  if(value[i].paramCode =='CAMPAIGN_IDS')
    				  {
    					  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    					  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.CAMPAIGN_DASHBOARD_REPORT_LISTING_VIEWCODE);
    					  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    				  }else
    				  {
    					  searchResultGrid.getStore().loadData([]);
    					  //searchResultGrid.getStore().reload();
    				  }
    			  }
    		  }
    		  
    		  Ext.getBody().unmask();
    	  }else
    	  {
    		  showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
    	  }
      },

      createJsonFormatCampaignDasBord:function(quickSearchForm, record){		
    	  var getForm=quickSearchForm.getForm();
    	  var formValues=getForm.getValues();
//    	  var date=new Date();
//    	  var currentDate = Ext.Date.format(new Date(date), 'Y-m-d');
    	  var values = new Object();
    	  values.configCode = CONSTANTS.CB.CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
    	  var searchcriteria = new Array();
    	  
    	    var organizationForm=this.getOrgCMPDashboardItemId().getForm();
      		var academyLocation=organizationForm.findField('academyLocation');
      		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
      		var acdemyLocationArray=[];
      		if(!academyLocation.isHidden()){
      			Ext.Array.each(academyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
      		if(!multiselectAcademyLocation.isHidden()){
      			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
      		
      		if (acdemyLocationArray !="") {
      			searchcriteria.push({paramCode:"ACADEMY_LOCATION_IDS", paramValues:[acdemyLocationArray.join()]});
      		}    	  
      		/*searchcriteria.push({paramCode:"TO_DATE", paramValues:[currentDate]});
    	  searchcriteria.push({paramCode:"FROM_DATE", paramValues:[currentDate]});*/
    	  
    	  if(formValues.FROM_DATE!=null && formValues.FROM_DATE!=""){
    		  searchcriteria.push({paramCode:"SEARCH_FROM_DATE", paramValues:[formValues.FROM_DATE]});  
    	  }
    	  if(formValues.TO_DATE!=null && formValues.TO_DATE!=""){
    		  searchcriteria.push({paramCode:"SEARCH_TO_DATE", paramValues:[formValues.TO_DATE]});  
    	  }
    	  if(formValues.CAMPIAGN_ID!=null && formValues.CAMPIAGN_ID!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_CODE", paramValues:[formValues.CAMPIAGN_ID]});  
    	  }
    	  if(formValues.CAMPIAGN_NAME!=null && formValues.CAMPIAGN_NAME!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_NAME", paramValues:[formValues.CAMPIAGN_NAME]});  
    	  }
    	  if(formValues.INTAKE_YEAR!=null && formValues.INTAKE_YEAR!=""){
        	  searchcriteria.push({paramCode:"INTAKE_YEAR_ID", paramValues:[formValues.INTAKE_YEAR]});
    	  }
    	  var campaignIds=this.getActiveAndPastCampaignId(acdemyLocationArray.join(),true);
    	  if(campaignIds!=null && campaignIds!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_IDS", paramValues:[campaignIds]});
    	  }
    	  values.searchCriterias=searchcriteria;
    	  return values;
      },
      
      gridPastCampaignRenderFunction:function(quickSearchForm){
    	  var AL= this.getOrgCMPDashboardItemId();
    	  if(AL.getValues().multiselectAcademyLocation!= undefined && AL.getValues().multiselectAcademyLocation[0] != ""){
    		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		  var jsonFormatFormData = this.createJsonFormatForPandingCampaign(quickSearchForm);
        	  var searchResultGrid = this.getPastcampaigngrid();
    		  for (var key in jsonFormatFormData) {
    			  var value = jsonFormatFormData[key]; 
    			  for ( var i in value)
    			  {
    				  if(value[i].paramCode =='CAMPAIGN_IDS')
    				  {
    					  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    					  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_VIEWCODE);
    					  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    				  }
    			  }
    		  }
    		  Ext.getBody().unmask();
    	  }else
    	  {
    		  showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
    	  }
      },

      createJsonFormatForPandingCampaign:function(quickSearchForm, record){	
    	  var getForm=quickSearchForm.getForm();
    	  var formValues=getForm.getValues();
//    	  var date=new Date();
//    	  var currentDate = Ext.Date.format(new Date(date), 'Y-m-d');
    	  var values = new Object();
    	  values.configCode = CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
    	  var searchcriteria = new Array();
    	  
    	    var organizationForm=this.getOrgCMPDashboardItemId().getForm();
      		var academyLocation=organizationForm.findField('academyLocation');
      		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
      		var acdemyLocationArray=[];
      		if(!academyLocation.isHidden()){
      			Ext.Array.each(academyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
      		if(!multiselectAcademyLocation.isHidden()){
      			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
  	  
      		if (acdemyLocationArray !="") {
      			searchcriteria.push({paramCode:"ACADEMY_LOCATION_IDS", paramValues:[acdemyLocationArray.join()]});
      		}  
//    	  searchcriteria.push({paramCode:"TO_DATE", paramValues:[currentDate]});
    	  
    	  if(formValues.FROM_DATE!=null && formValues.FROM_DATE!=""){
    		  searchcriteria.push({paramCode:"SEARCH_FROM_DATE", paramValues:[formValues.FROM_DATE]});  
    	  }
    	  if(formValues.TO_DATE!=null && formValues.TO_DATE!=""){
    		  searchcriteria.push({paramCode:"SEARCH_TO_DATE", paramValues:[formValues.TO_DATE]});  
    	  }
    	  if(formValues.CAMPIAGN_ID!=null && formValues.CAMPIAGN_ID!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_CODE", paramValues:[formValues.CAMPIAGN_ID]});  
    	  }
    	  if(formValues.CAMPIAGN_NAME!=null && formValues.CAMPIAGN_NAME!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_NAME", paramValues:[formValues.CAMPIAGN_NAME]});  
    	  }
    	  if(formValues.INTAKE_YEAR!=null && formValues.INTAKE_YEAR!=""){
        	  searchcriteria.push({paramCode:"INTAKE_YEAR_ID", paramValues:[formValues.INTAKE_YEAR]});
    	  }
    	  var campaignIds=this.getActiveAndPastCampaignId(acdemyLocationArray.join(),false);
    	  if(campaignIds!=null && campaignIds!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_IDS", paramValues:[campaignIds]});
    	  }
    	  values.searchCriterias=searchcriteria;
    	  return values;
      },
      commonGridRenderFunction:function(grid,records,configCode,viewCode){
    	  var quickSearchForm = this.getCampaigndashboard();
    	  var jsonFormatFormData = this.createCommonJsonFormat(quickSearchForm,records,configCode,grid);
    	  var searchResultGrid = grid;
    	  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	  resultViewUrl = resultViewUrl.concat(viewCode);
    	  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
      },

      createCommonJsonFormat:function(quickSearchForm, record,configCode,grid){		
    	  var values = new Object();
    	  values.configCode = configCode;
    	  var searchcriteria = new Array();
    	  
    	  // changed by utsav, for enquriy grid we need to show all type of enquiry including admission
    	 
    	  /**
    	   * in Active campaigns:- When click on Enquiry-Generated & No.of Application link, this function will call.
    	   * in Past campaigns:- When click on Enquiry-Generated , No. of Application & Student-enrolled  link, this function will call.
    	   * 
    	   */
    	  if((grid.itemId=='applicationgrid')||(grid.itemId=='enquiryregisteredgrid') || (grid.itemId=='studentadmitgrid')){
    		  searchcriteria.push({paramCode:"ENQUIRY_IDS", paramValues:[record]}); 
    		  searchcriteria.push({paramCode:"ENQUIRY_TYPE_NAME", paramValues:["Admission"]});  
    	  }
    	  
    	  /**
    	   * in Active campaigns:-When click on No. of academy & No. of location link , this functioan will call. 
    	   * in Past campaigns:-When click on No. of academy & No. of location link , this functioan will call. 
    	   */
    	  if((grid.itemId=='academycoveredgrid')||(grid.itemId=='locationcoveredgrid')){
    		  searchcriteria.push({paramCode:"CAMPAIGN_ID", paramValues:[record]});  
    	  }
    	  
    	  /**
    	   * in Active campaigns:-When click on Program covered link , this functioan will call. 
    	   * in Past campaigns:-When click on Program covered link, this functioan will call. 
    	   */
    	  
    	  if((grid.itemId=='programcoveredgrid')){
    		  searchcriteria.push({paramCode:"CAMPAIGN_ID", paramValues:[record.campaignId]}); 
    		  searchcriteria.push({paramCode:"PROGRAM_IDS", paramValues:[record.programId]});  
        	  }
        	  
        	  values.searchCriterias=searchcriteria;
        	  return values;
          },
  //***************create json format for Dashboard Detail Tab********************************************        
      createJsonFormatCampaignDasBordDetailTab:function(quickSearchForm,configCode,grid,searchResultGrid){		
    	  var values = new Object();
    	  values.configCode = configCode;
    	  var searchcriteria = new Array();
    	  var data="";
    	  var $this=this;
    	 
    	  if(grid=="active"){
    		  var activecampaigngrid=this.getActivecampaigngrid();
    		  var activerecords = activecampaigngrid.getSelectionModel().getSelection();
    		  data = activerecords[0].data;
    	  }else{
    		  var pastcampaigngrid=this.getPastcampaigngrid();
    		  var pastrecords = pastcampaigngrid.getSelectionModel().getSelection();
    		  data = pastrecords[0].data;
    	  }		  
    	 
    	  if(grid=="active" || grid=="past"){
    	  if((searchResultGrid.itemId == "applicationgrid")||(searchResultGrid.itemId=='enquiryregisteredgrid'))
    	  {
    			   var campaignId=data.CAMPAIGN_ID;
    			   var submitUrl = SERVERURL.CAMPAIGN_NOOFENQGENERATED;
    			   Ext.Ajax.request({type:'rest',url:submitUrl,async:false,method:'GET',params:{campaignId:campaignId},
    				   success: function(response, action) {
    					   var enquiryId = response.responseText;
    					   //var configCode=CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_CONFIGCODE;
    					   //var viewCode=CONSTANTS.CB.CAMPAIGN_DASHBOARDAPPLICATION_LIST_VIEWCODE;
    					  // $this.commonGridRenderFunction(grid,enquiryId,configCode,viewCode);
    					  // grid.setVisible(true);
//    					   console.log('enquiryId...',enquiryId);
    					   searchcriteria.push({paramCode:"ENQUIRY_IDS", paramValues:[enquiryId]}); 
                 		  searchcriteria.push({paramCode:"ENQUIRY_TYPE_NAME", paramValues:['Admission']});
    				   }
    			   });
    		   
    		  /*searchcriteria.push({paramCode:"ENQUIRY_IDS", paramValues:[enquiryId]}); 
    		  searchcriteria.push({paramCode:"ENQUIRY_TYPE_NAME", paramValues:['Admission']});*/
    		  
    		/*  var submitUrl = SERVERURL.ENQUIRY_ID_BY_CAMPAIGN_ID;
    		  Ext.Ajax.request({type:'rest',url:submitUrl,method:'GET',params:{campaignId:campaignId},
    			  success: function(response, action) {
    				  enquiryId = response.responseText;
    				  console.log('enquiryId',enquiryId);*/
    				  /*searchcriteria.push({paramCode:"ENQUIRY_IDS", paramValues:enquiryId});
            		  searchcriteria.push({paramCode:"ENQUIRY_TYPE_NAME", paramValues:['Admission']});*/
    			 // }}); 
    	  }else{
    		  if((searchResultGrid.itemId=='selectstudentgrid')||
    				  (searchResultGrid.itemId=='academycoveredgrid')||(searchResultGrid.itemId=='locationcoveredgrid')||
    				  (searchResultGrid.itemId=='programcoveredgrid'))
    		  {
    			  if(!isNullOrEmpty(data.CAMPAIGN_ID)){
    				  var dataValue = data.CAMPAIGN_ID
    			  }else{
    				  var dataValue = data.campaignId
    			  }
    			  searchcriteria.push({paramCode:"CAMPAIGN_ID", paramValues:[dataValue]});
    		  }
    	  } 
    	  }
    	  if(grid=="past" && searchResultGrid.itemId=='studentadmitgrid'){
    		  searchcriteria.push({paramCode:"CAMPAIGN_ID", paramValues:[data.CAMPAIGN_ID]});
    		  searchcriteria.push({paramCode:"ENQUIRY_TYPE_NAME", paramValues:["Admission"]});
    		  searchcriteria.push({paramCode:"ADMISSION_STATUS", paramValues:['ADMISSION_GRANTED']});
    	  }

    	  values.searchCriterias=searchcriteria;
    	  return values;
      },
  //**********************************************************************************************************    
      
    //***************create json format for Dashboard Summary Tab********************************************      
      createJsonFormatCampaignDasBordSummaryTab:function(quickSearchForm,configCode, record){	
    	  //var getForm=quickSearchForm.getForm();
    	  var formValues=quickSearchForm.getValues();
    	  var date=new Date();
    	  var currentDate = Ext.Date.format(new Date(date), 'Y-m-d');
    	  var values = new Object();
    	 // values.configCode = CONSTANTS.CB.PAST_CAMPAIGN_DASHBOARD_REPORT_LISTING_CONFIGCODE;
    	  values.configCode = configCode;
    	  var searchcriteria = new Array();
    	  
    	    var organizationForm=this.getOrgCMPDashboardItemId().getForm();
      		var academyLocation=organizationForm.findField('academyLocation');
      		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
      		var acdemyLocationArray=[];
      		if(!academyLocation.isHidden()){
      			Ext.Array.each(academyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
      		if(!multiselectAcademyLocation.isHidden()){
      			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
  	  
  	      searchcriteria.push({paramCode:"ACADEMY_LOCATION_IDS", paramValues:[acdemyLocationArray.join()]});
    	  searchcriteria.push({paramCode:"TO_DATE", paramValues:[currentDate]});
    	  
    	  if(formValues.fromdate!=null && formValues.fromdate!=""){
    		  searchcriteria.push({paramCode:"SEARCH_FROM_DATE", paramValues:[formValues.fromdate]});  
    	  }
    	  if(formValues.todate!=null && formValues.todate!=""){
    		  searchcriteria.push({paramCode:"SEARCH_TO_DATE", paramValues:[formValues.todate]});  
    	  }
    	  if(formValues.campaignCode!=null && formValues.campaignCode!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_CODE", paramValues:[formValues.campaignCode]});  
    	  }
    	  if(formValues.campaignName!=null && formValues.campaignName!=""){
    		  searchcriteria.push({paramCode:"CAMPAIGN_NAME", paramValues:[formValues.campaignName]});  
        	  }
        	  values.searchCriterias=searchcriteria;
        	  return values;
          },
   //***************************************************************************************************
      //******************Export to Pdf and Excel for Campaign
   
              exportUserList : function(exportUrl,filetype,whetherAll) {
            	  var quickSearchForm=this.getCampaignQuickSearch(); 
            	  var searchResultGrid = this.getSearchResultGrid();
            	  var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
            	  var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
            	  var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
            	  var visibleColumns=this.getVisibleColumns(searchResultGrid);
            	  var reportTitle=getCommonTranslation("CAMPAIGN_LIST");
                	  if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                		  jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                	  }
                	  searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

         },
         getIdValueJson: function(id, value) {
     		if (id) return {
     			id: id,
     			value: value
     		};
     	},
     	
        createSearchCriteriaString: function(searchForm) {
        	  var me=this;
        	  var formValues = new Array();
        	  formValues = searchForm.getValues();        
        	  var searchCriteriaString="";
        	  for (var key in formValues) {
        		  var value = formValues[key];            
        		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
        			  var keyValueJsonObject = me.getJsonObject( key , value);
        			  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            		  }
            	  }
            	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
            	  return searchCriteriaString;
              },
  //*******************************Export to Excel and Pdf for Campaign Dashboard Summary Tab********************************************
     	 exportCampaignDashboardList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
               var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
               var values = quickSearchForm.getForm().getValues();
               var searchCriteriaString=this.createSearchCriteriaStringDashboard(quickSearchForm);
               var searchForm = quickSearchForm.getForm();
               var jsonFormatFormData=this.createJsonFormatCampaignDasBordSummaryTab(searchForm,configCode);
               //var jsonFormatFormData=this.createJsonFormatCampaignDasBord(searchForm,configCode)
               
               var visibleColumns=this.getVisibleColumns(searchResultGrid);
               var reportTitle=getCommonTranslation("CAMPAIGN_DASHBOARD_LIST");
               if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                             jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                      }
              searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
      },
      createSearchCriteriaStringDashboard: function(searchForm) {
    	  var me=this;
    	  var formValues = new Array();
    	  formValues = searchForm.getValues();        
    	  var searchCriteriaString="";
    	  for (var key in formValues) {
    		  var value = formValues[key];            
    		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
    			  var keyValueJsonObject = me.getJsonObject( key , value);
    			  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
    		  }
    	  }
    	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    	  return searchCriteriaString;
      },
      /*getJsonObject: function(key, value) {
     		if (key) return {
     			key: key,
     			value: value
     		};
     	},*/
     	getJsonObject: function(key, value, additionalValue) {
            if (!isNullOrEmpty(value) && additionalValue == undefined) {
                return {
                    "paramCode": key,
                    "paramValues": [value]
                };
            } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
                return {
                    "paramCode": key,
                    "paramValues": [value, additionalValue]
                };
            }
        },
//*******************************Export to Excel and Pdf for Campaign Dashboard Detail Tab********************************************
     	
     	 exportCampaignDashboardDetailTabList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
     		 var grid;
     		 //console.log('Hi');
     		 if(searchResultGrid.title.indexOf('Active') > -1){
     			 grid="active";
     		 }
     		 else{
     			 grid="past";
     		 }
               var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
               var values = quickSearchForm.getForm().getValues();
               var searchCriteriaString=this.createSearchCriteriaStringDashboardDetail(quickSearchForm);
               var searchForm = quickSearchForm.getForm();
               var jsonFormatFormData=this.createJsonFormatCampaignDasBordDetailTab(searchForm,configCode,grid,searchResultGrid);
               //var jsonFormatFormData=this.createJsonFormatCampaignDasBord(searchForm,configCode)
//               console.log('jsonFormatFormData...',jsonFormatFormData);
               var visibleColumns=this.getVisibleColumns(searchResultGrid);
               var reportTitle=getCommonTranslation("CAMPAIGN_DASHBOARD_LIST");
               if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                             jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                      }
              searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
      },
      createSearchCriteriaStringDashboardDetail: function(searchForm) {
    	  var me=this;
    	  var formValues = new Array();
    	  formValues = searchForm.getValues();        
    	  var searchCriteriaString="";
    	  for (var key in formValues) {
    		  var value = formValues[key];            
    		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
    			  var keyValueJsonObject = me.getJsonObject( key , value);
    			  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
    		  }
    	  }
    	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    	  return searchCriteriaString;
      },
      getOpenCampaignReportStructure : function(treePanel, record, item,index, e, eOpts){
    	  var $this = this;
    	  var campaignstructure = $this.getCmpsummarytab();
    	  var treeTab = campaignstructure.down('#campaignReportTreePanelItemId');
    	  var campaignTabStructure = campaignstructure.down('#campaignReportTabStructure');

    	  var tabDetail = record.data;
    	  var structure = Ext.widget(tabDetail.reportXtype);

    	  if (!isNullOrEmpty(tabDetail.text)
    			  && !isNullOrEmpty(tabDetail.reportXtype)
    			  && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
    		  treeTab.toggleCollapse();

    		  openTab(campaignTabStructure, tabDetail.text,structure);
    		  treePanel.getSelectionModel().deselectAll();
    	  }
      },
      
      disableCampaignStructureTab:function(structure,permissionsMap){
  		var associatedAcadLocationIds = new Array();
  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
  		var advanceSearchPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
  		
  		var campaignAdvanceSearchStructureTab=false;
  		
  		Ext.each(advanceSearchPermissionList, function(privilege) {
  			if (privilege === 'VIEW') {
  				campaignAdvanceSearchStructureTab = true;
  			} else {
  				campaignAdvanceSearchStructureTab = false;
  			}
  		});
  		
  		this.showCampaignTab(campaignAdvanceSearchStructureTab, structure);
  	},
  	
  	showCampaignTab : function(campaignAdvanceSearchStructureTab, structure) {
		var panelItem = new Array();
		var $this = this;
		var newcont=structure.items.items.length;
		var insertPosition=newcont+1;
		var panelItem = new Array();
		var $this = this;
		var insertPosition = structure.items.items.length;
		panelItem.push({
			xtype: 'campaignsmanagement',
			title: getCommonTranslation('SEARCH'),
			tabCls: 'right-tab',
			itemId:'campaignSearchTabId'
		});

		if (campaignAdvanceSearchStructureTab) {
			panelItem.push({
				xtype: 'advancedsearchquerybuilder',
				searchConfigCode: CONSTANTS.CB.CAMPAIGN_LIST_CONFIGCODE,
				searchResultViewCode: CONSTANTS.CB.CAMPAIGN_LIST_VIEWCODE,
				permissionMapKey:'CAMPAIGN_PRIVILEGES',
				gridTitle: getCommonTranslation("CAMPAIGN_LIST"),
				tabCls: 'right-tab'
			});
		}

		structure.insert(insertPosition,panelItem);
		structure.setActiveTab(0);
		
	},
	getActiveAndPastCampaignId :function(academyLocationIds,isActive){
		var campaignIds=new Array();
		Ext.Ajax.request({
			type: 'rest',
			async:false,
			params:{acdemyLocationIds:academyLocationIds,isActiveCampaign:isActive},
			url: SERVERURL.PATH_ACTIVE_PAST_CAMPAIGN_IDS,
			method: 'GET',
			scope:this,
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(response, action) {
				campaignIds=Ext.decode(response.responseText);
			}
		});
		return campaignIds.join();
	},
	exportActiveCampaignDashboardList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
		var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
		var values = quickSearchForm.getForm().getValues();
		var searchCriteriaString=this.createSearchCriteriaStringDashboard(quickSearchForm);
		var searchForm = quickSearchForm.getForm();
		var jsonFormatFormData=this.createJsonFormatCampaignDasBord(quickSearchForm,configCode);
		//var jsonFormatFormData=this.createJsonFormatCampaignDasBord(searchForm,configCode)

		var visibleColumns=this.getVisibleColumns(searchResultGrid);
		var reportTitle= getCampaignTranslation('ACTIVE_CAMPAIGNS');

		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		}
		searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	exportPastCampaignDashboardList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
		var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
		var values = quickSearchForm.getForm().getValues();
		var searchCriteriaString=this.createSearchCriteriaStringDashboard(quickSearchForm);
		var searchForm = quickSearchForm.getForm();
		var jsonFormatFormData=this.createJsonFormatForPandingCampaign(quickSearchForm,configCode);
		//var jsonFormatFormData=this.createJsonFormatCampaignDasBord(searchForm,configCode)

		var visibleColumns=this.getVisibleColumns(searchResultGrid);
		var reportTitle= getCampaignTranslation('PAST_CAMPAIGNS'); // dynamic change title nme

		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		}
		searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	getCampaignExcelReport:function(form){
		var $this=this;
		var searchForm = this.getCmpsummarytab().down('#activecmpdasboardfilter'); 
		var formValue = searchForm.getValues();
		var code = "CampaignExportReport";
		var reportParams =new Object();
		reportParams.intakeYearId = formValue.INTAKE_YEAR;
		reportParams.campaignCode = formValue.CAMPIAGN_ID;
		reportParams.campaignName = formValue.CAMPIAGN_NAME;
		reportParams.startDate = formValue.FROM_DATE;
		reportParams.endDate = formValue.TO_DATE;
		reportParams.academyLocationId =$this.getMultiSelectAcademyLocation();
		reportParams.headerName = getCommonTranslation('CAMPAIGN_PERFORMANCE_REPORT');
		var reportTitle="";
		$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_CAMPAIGN_EXCEL_REPORT);
	},
	getMultiSelectAcademyLocation:function(){
		var organizationForm=this.getOrgCMPDashboardItemId().getForm();
  		var academyLocation=organizationForm.findField('academyLocation');
  		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
  		var acdemyLocationArray=[];
  		if(!academyLocation.isHidden()){
  			Ext.Array.each(academyLocation.getValue(),function(value){
  				if(Ext.isObject(value)){
  					acdemyLocationArray.push(value.data.id);
  				}else{
  					acdemyLocationArray.push(value);	
  				}
  			});
  		}
  		if(!multiselectAcademyLocation.isHidden()){
  			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
  				if(Ext.isObject(value)){
  					acdemyLocationArray.push(value.data.id);
  				}else{
  					acdemyLocationArray.push(value);	
  				}
  			});
  		}
		return acdemyLocationArray.join();
	},
	disableMoreBtnPivileges:function(grid,permissionsMap){
		var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var exportCampaignBtn = grid.down('#exportCampaignReport');
    	exportCampaignBtn.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'EXPORT_REPORTS') {
        		if(!isNullOrEmpty(exportCampaignBtn)){
        			exportCampaignBtn.setVisible(true);
        		}        		
        	}
    	});
	},
	viewAssociatedProgram:function(grid,record){
		var $this=this;
		var gridWindow = $this.getProgramAssociatedGrid();
		var campaignSearchForm = this.getCampaignQuickSearch();
		var programId=campaignSearchForm.getForm().findField('PROGRAM');
		var whetherDeleted=campaignSearchForm.getForm().findField('whetherDeleted');
		  if (!gridWindow) {
			  gridWindow = Ext.widget('programAssociatedGrid');
		  }
		  gridWindow.show();
		  gridWindow.down('#campaignId').setValue(record.data.CAMPAIGN_ID);
		  gridWindow.down('#programId').setValue(programId.getValue());
		  gridWindow.down('#whetherDeleted').setValue(whetherDeleted.getValue());
		  var grid = gridWindow.down('grid');
		  var store = grid.getStore();
		  store.getProxy().extraParams = {
			  campaignId:record.data.CAMPAIGN_ID,
			  programId:programId.getValue(),
			  whetherDeleted:whetherDeleted.getValue()
		  };
		  $this.resetPageSetting(store);
		  store.load({
			  callback:function(){
				  Ext.ComponentQuery.query('programAssociatedGrid')[0].center();
			  }
		  });
	},
	pAdmCampaignAddProgramFeeMappingTab: function(){
		var $this = this;
		var contentpanel = $this.getContentPanel();
		var coursetabstructure = Ext.widget('padmaddprogramcampaignmappingtab');
		var tabName = getCommonTranslation('CAMPAIGN_ADD_MAPPING');

		var getcontroller=$this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_ONE);
		var campaignGrid = $this.getCampaignscoveragegrid();
		campaignGrid.getSelectionModel().deselectAll();
		var academylocationgrid = $this.getPadmacademylocationgridwithcampaign();
		academylocationgrid.getStore().clearFilter();
		academylocationgrid.getStore().load();
		 setTimeout(function(){
			 academylocationgrid.columns[2].doSort();
		  },200);
		$this.getPadmcampaignmapprogresstracker().setVisible(true);

		$this.resetcampaignProgressTracker();
		var adjustmentprogresstracker = coursetabstructure.down("#campaignMapProgressTrackerItemId");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
	},
	resetcampaignProgressTracker : function(){
		var structure = this.getPadmaddprogramcampaignmappingtab();
		var adjustmentprogresstracker = structure.down("#campaignMapProgressTrackerItemId");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
		progresstracker1.reset();
		progresstracker1.updateText('');
		progresstracker2.reset();
		progresstracker2.updateText('');
	},
	pAdmCampaignAcademyLocationNextEvent:function(btn){
		var $this = this;
		var academylocationgrid = $this.getPadmacademylocationgridwithcampaign();
		var selectionModel = academylocationgrid.getSelectionModel().getSelection();
		var flagIsSave = true;
		if(selectionModel.length>0){
			selectionModel.forEach(function(obj){
				 if (isNullOrEmpty(obj.data.contactPersonValue)) {
					 flagIsSave = false;
				 }
			 });
		  }
		var academyLocationIdsArr = [];
		selectionModel.forEach(function(obj){
			academyLocationIdsArr.push(obj.get('id'));
		});
		if(academyLocationIdsArr.length > 0){
		if(flagIsSave){
			var padmcampaignprogrammapstructure = $this.getPadmcampaignprogrammapstructure();
			var programcontainer = padmcampaignprogrammapstructure.down('#programcontainer');
			programcontainer.setDisabled(false);
			padmcampaignprogrammapstructure.setActiveTab(programcontainer);
			var alProgramGrid = $this.getPadmcampaignalprogramgrid();
			var alProgramGridStore = alProgramGrid.getStore();
			alProgramGridStore.removeAll();
			var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
			alProgramSearchCombo.getStore().getProxy().extraParams= {
				academyLocationIds: academyLocationIdsArr.join(),
				page:1,
    			start:0,
    			limit:-1
			};
			//alProgramSearchCombo.getStore().load();
			
			alProgramGridStore.getProxy().extraParams= {
				academyLocationIds: academyLocationIdsArr.join()
			};
			alProgramGridStore.clearFilter();
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			alProgramGridStore.load({
				callback: function(records, operation, success) {
			    Ext.getBody().unmask();
				var models = alProgramGridStore.getRange();
				selectionModel.forEach(function(obj){
					models.filter(function (obj1) {
						if(obj1.data.academyLocationId == obj.data.id){
							if(isArray(obj.data.contactPersonValue)){
								models[obj1.index].set("contactPerson", obj.data.contactPersonValue[0].data.valueCode);
							}else{
								models[obj1.index].set("contactPerson", obj.data.contactPersonValue);
							}
							models[obj1.index].set("coverageRemarks", obj.data.remarkValue);
							models[obj1.index].set("userId", obj.data.userId);
						}
					});
				});
				 }
			});
			$this.setCampaignProgressTracker(1);
		}else{
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_CONTACT_PERSON'));
		}
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	setCampaignProgressTracker : function(progresstracker){
	  	  var structure = this.getPadmaddprogramcampaignmappingtab();
	  	  var adjustmentprogresstracker = structure.down("#campaignMapProgressTrackerItemId");

	  	  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
	  	  var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");

	  	if(progresstracker==1){
			  for(var i = 0; i < 11; i ++ ){
				  progresstracker1.updateProgress((i * 0.1), '');
			  }
			  progresstracker1.textEl.addCls("custom-progress-text");
			  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
			  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
			  progresstracker2.textEl.addCls("inProgressCss-progress-text");
			  progresstracker2.updateText("Step 2 In Progress");
			  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
		  }
		  if(progresstracker==2){
			  for(var i = 0; i < 11; i ++ ){
				  progresstracker2.updateProgress((i * 0.1), '');
			  }
			  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
			  progresstracker3.textEl.addCls("inProgressCss-progress-text");
			  progresstracker3.updateText("Step 3 In Progress");
			  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
			  progresstracker2.textEl.addCls("custom-progress-text");
			  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
		  }
	    },
	    submitCampaignMappingWithALProgram: function(btn){
	    	var tabStructure = this.getPadmcampaignprogrammapstructure();
	    	var activeGrid = tabStructure.getActiveTab().down('grid');
	    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
	    	var grid = this.getCampaignscoveragegrid();
	    	var store = grid.getStore();
	    	var ObjModel = [];
	    	if(selectedRecord.length>0){
	    		 for(var i in selectedRecord) {
	    			var programName = selectedRecord[i].data.programName;
	    			var programId =  selectedRecord[i].data.programId;
	    			var academyName = selectedRecord[i].data.academyLocationName;
	    			var academyId  = selectedRecord[i].data.academyLocationId;
	    			var userId  = selectedRecord[i].data.userId;
	    			var location =  academyName.split('-');
	    			if(grid.getStore().data.length>0){
	    				 var programIds=[];
	    				for(var j=0;j< grid.getStore().data.length;j++){
	    					programIds.push(grid.getStore().getAt(j).get('programId'));
	    				}	
	    				 var status = Ext.Array.contains(programIds,programId);
	    				 if(!status){
	    					 var data = {
	 								academy: academyName,
	 								location: location[1],
	 								program: programName,
	 								user: selectedRecord[i].data.contactPerson,
	 								coverageRemarks: selectedRecord[i].data.coverageRemarks,
	 								academyId: academyId,
	 								programId: programId,
	 								userId: userId
	 						};
	 						ObjModel.push(data); 
	    				 }
	    			}else{
	    				var data = {
		    					academy: academyName,
		    					location: location[1],
		    					program: programName,
		    					user: selectedRecord[i].data.contactPerson,
		    					coverageRemarks: selectedRecord[i].data.coverageRemarks,
		    					academyId: academyId,
		    					programId: programId,
		    					userId: userId
		    			};
	    				ObjModel.push(data);
	    			}
	    		}
	    		var records = grid.getSelectionModel().getSelection();
	    		var rowIndex = store.indexOf(records[0]);
	    		if (rowIndex >= 0) {
	    			store.remove(records[0]);
	    		}
	    		store.loadRawData(ObjModel, true);
	    		store.commitChanges();
	    		grid.getView().refresh();
	    		totalRecordDisplayField=grid.down('#totalRecordDisplayField');
	    		totalRecordDisplayField.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+store.getCount())
	    		showSuccessMessage(getCommonTranslation('CAMPAIGN_ADD_MAPPING'), getCommonTranslation('CAMPAIGN_MAPPING_SUCCESS_MESSAGE'));
	    		var contentpanel = this.getContentPanel();
		    	var tabName = getCommonTranslation('CAMPAIGN_ADD_MAPPING');
		    	var getcontroller=this.getController('menu.CoreERPNavigationController');
		    	var getTab=getcontroller.getTab(tabName);
		    	if(getTab!=null){
		    		contentpanel.remove(getTab, true);
		    	}

	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    loadActiveCampaignDashboardGrid: function(isActive,obj) {
	    	var $this = this;
	    	if(isActive){
	    		 var filter = obj.up('activecampaignstructure').down("#activecmpdasboardfilter");
	    		var grid=$this.getActivecampaigngrid();
	    	}else{
	    		 var filter = obj.up('pastcampaignstructure').down("#pastcmpdasboardfilter");
	    		var grid=$this.getPastcampaigngrid();
	    	}
	    	//var filter = $this.getCmpdasboardfilter();
	    	var getForm = filter.getForm();
	    	var formValues = filter.getValues();
	    	var CAMPIAGN_ID = getForm.findField('CAMPIAGN_ID');
	    	var CAMPIAGN_NAME = getForm.findField('CAMPIAGN_NAME');
	    	var intakeYear = filter.down('#intakeYear');
	    	var fromdateItemId = filter.down('#fromdateItemId');
	    	var todateItemId = filter.down('#todateItemId');
	    	
	    	buttonsToolBar = grid.query('toolbar')[0];
	    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
	    	pdftoolbar.setDisabled(false);
	    	exceltoolbar.setDisabled(false);
	    	var store = grid.getStore();
	    	var organizationForm=this.getOrgCMPDashboardItemId().getForm();
      		var academyLocation=organizationForm.findField('academyLocation');
      		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
      		var acdemyLocationArray=[];
      		if(!academyLocation.isHidden()){
      			Ext.Array.each(academyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
      		if(!multiselectAcademyLocation.isHidden()){
      			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
      				if(Ext.isObject(value)){
      					acdemyLocationArray.push(value.data.id);
      				}else{
      					acdemyLocationArray.push(value);	
      				}
      			});
      		}
      		var academyIds = acdemyLocationArray.join(',');
      		var campaignIds=$this.getActiveAndPastCampaignId(academyIds,isActive);
      		$this.resetPageSetting(store);
	    		store.getProxy().extraParams = {
	    			campaignId: campaignIds,
	    			campaignName: CAMPIAGN_NAME.getValue(),
	    			intakeYearId:intakeYear.getValue(),
	    			campaignCode:CAMPIAGN_ID.getValue(),
	    			fromDate:formValues.FROM_DATE,
	    			toDate:formValues.TO_DATE
	    		};
	    		store.load({
					   callback: function(records, operation, success) {
						   if (records.length == 0) {
							   pdftoolbar.setDisabled(true);
						    	exceltoolbar.setDisabled(true);
		    				} else {
		    					pdftoolbar.setDisabled(false);
		    			    	exceltoolbar.setDisabled(false);
		    				}
					   }
	    		});
	/***************Start Code added for show filter data on PDF/Excel Export Report **************/
	    	
	    	grid.config.searchFilterForm = $this.getCmpdasboardfilter();
	    	
	/***************End Code added for show filter data on PDF/Excel Export Report **************/
	    }
});