/**
 * @author seshagiri.k
 */
Ext.define('Academia.controller.course.coursegroup.CourseGroupController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['course.coursegroup.CourseGroupModel','common.IdValueCodeDataModel'],
	stores: ['course.coursegroup.CourseGroupStructureStore','course.coursegroup.ProgramBYCourseGroup','course.coursegroup.CourseGroupTypeStore',
		'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData','course.coursegroup.AllCourseGroupStore'
		,'course.coursegroup.AssignCoursesInCourseGroupStore','course.CourseGroupAffiliationStore'
		,'importutility.ImportCourseGroupStore','importutility.ImportCourseGroupAssignCourses', 'course.coursegroup.CourseGroupAssociatedWinGridStore'],
		views: ['course.coursegroup.CourseGroupStructureGrid', 'course.coursegroup.CourseGroupForm',
			'baselayout.contentarea.ContentPanel','course.coursegroup.CourseGroupAdvSearch', 'course.coursegroup.CourseGroupQuickSearchForm',
			'course.coursegroup.CourseGroupStructure','course.coursegroup.NoOfCourse','course.coursegroup.NoOfProgram','course.coursegroup.NoOfAssociatedCourse',
			'course.coursegroup.CourseGroupGridViewStructure',
			'course.coursegroup.assigncourses.AssignCoursesStructureGrid', 'course.coursegroup.uploaddownload.CourseGroupUploadDownloadStructure',
			'course.coursegroup.uploaddownload.CourseGroupDownloadForm','course.coursegroup.uploaddownload.CourseGroupUploadForm',
			'importutility.ImportByModule.ImportListCourseGroup',
			'course.coursegroup.CourseGroupAssociatedWin'],
			config:{
				/*
				 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
				 */
				/**
				 * @cfg {Array} COURSEGROUP_PERMISSIONS array (required)
				 * The array of permissions to use for Access control wise enabling and disabling buttons.
				 * @accessor
				 */
				COURSEGROUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSEGROUP_PRIVILEGES')
			},         
			refs: [{
				ref : 'courseGroupGridViewStructure',
				selector : 'courseGroupGridViewStructure' 
			},{
				ref : 'noofcourse',
				selector : 'noofcourse' 
			},{
				ref : 'noofassociatedcourse',
				selector : 'noofassociatedcourse'	
			},{
				ref : 'noofprogram',
				selector : 'noofprogram' 
			},{
				ref : 'coursegroup',
				selector : 'coursegroup' 
			},{
				ref : 'contentpanel',
				selector : 'contentpanel' 
			},{
				ref: 'courseGroupForm',
				selector: 'courseGroupForm'
			}, {
				ref: 'courseGroupStructureGrid',
				selector: 'courseGroupStructureGrid'
			},{
				ref: 'coursegroupadvsearch',
				selector: 'coursegroupadvsearch'
			},{
				ref: 'coursegroupquicksearchform',
				selector: 'coursegroupquicksearchform'
			},{
				ref: 'searchresultgrid',
				selector: 'searchresultgrid[itemId=courseGroupStructureGrid]'
			},{
				ref: 'coursegroup',
				selector: 'coursegroup'
			},{
				ref: 'assignCoursesStructureGrid',
				selector: 'assignCoursesStructureGrid'
			},{
				ref : 'uploadoptionradiogroup',
				selector : 'uploadoptionradiogroup[itemId=courseGroupUploadOptionRadioGroupItemId]'
			},{
				ref: 'coursegroupuploaddownloadstructure',
				selector: 'coursegroupuploaddownloadstructure'
			},{
				ref: 'coursegroupuploadform',
				selector: 'coursegroupuploadform'
			},{
				ref: 'coursegroupdownloadform',
				selector: 'coursegroupdownloadform'
			},{
				ref:'importlistcoursegroup',
				selector:'importlistcoursegroup'
			},{
				ref: 'coursegroupassociatedwin',
				selector: 'coursegroupassociatedwin'
			}],
			init: function(application) {
				this.control({
					'courseGroupGridViewStructure':{
						afterrender:function(structure){
							var grid = structure.down('#courseGroupStructureGrid');
							this.getCBGridHeaderFreeze(grid,structure);
						}
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] button[itemId=searchResultGridBtnAdd]': {
						click : this.showFormWindow
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] button[itemId=searchResultGridBtnEdit]': {
						click: this.editFormWindow
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] button[itemId=searchResultGridBtnView]': {
						click :  this.viewFormWindow
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] button[itemId=searchResultGridBtnDelete]': {
						click : this.deleteRecord
					},
					'courseGroupForm  radiogroup[itemId=radioId]': {
						change:function(cb, nv, ov){ 
							this.whetherRadioFieldsChanges(cb, nv, ov);
						}
					},
					'courseGroupForm textfield, courseGroupForm customcombobox, courseGroupForm numberfield':{
						change: function(fld){
							var courseGroupForm = fld.up('form');
							courseGroupForm.getForm().checkValidity();
						}
					},
					'courseGroupForm numberfield[itemId=maxCourseEnrollment_Id]':{
						change:function(cb, nv, ov){ 
							var form=this.getCourseGroupForm();
							var maxCourse=form.down('#maxCourses_Id');
							var maxCourseValue=maxCourse.getValue();
							var maxOptionalCourse=form.down('#optionalMaxCourses_Id');
							var maxOptionalCourseValue=maxOptionalCourse.getValue();
							var maxEnrollCourses=form.down('#minCourseEnrollment_Id');
							var maxEnrollCoursesValue=maxEnrollCourses.getValue();
							if(maxEnrollCoursesValue<=maxCourseValue){
								form.isValid();
							}
						}
					},
					'courseGroupForm  button[itemId=saveCourseGroupButtonId]': {
						click: this.saveUpdateUser
					},
					'courseGroupForm  button[itemId=btnCancelCourseGroupForm]': {
						click: this.closeFormWindow
					},
					'courseGroupStructureGrid' : {
						render : function(f){
							this.courseGroupGrid();
						}
					},'coursegroupquicksearchform button[itemId=courseGroupQuickSearchFormId]' : {
						click : this.loadGridAndSearchPrograms
					},
					'coursegroupquicksearchform button[itemId=resetBtn]' : {
						click : function(){
							this.getCoursegroupquicksearchform().getForm().reset();
						}
					},
					'coursegroupuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
						change: this.courseGroupDownloadUploadFormChange
					},
					'coursegroupdownloadform button[itemId=groupDownloadResetBtn]':{
						click:function(obj){
							var $this = this;
							var form =obj.up('coursegroupdownloadform').getForm();

							obj.up('coursegroupdownloadform').down('#moduleName').reset();
							obj.up('coursegroupdownloadform').down('#downoladBtnId').setDisabled(true);
						}  
					},
					
				 'courseGroupForm multiselectcombofield[itemId=mutuallyExclusiveCourseGroupId]':{
                  render:function(combo){
                      $this = this;
                      var store = combo.getStore(); 
                      var count = 1;
                      var flag = 1;
                      store.on('load', function(){
                              if(flag == 3)
                              flag = 2;                              
                              if(count == 1 || flag == 2){ 
                              var courseGroupForm=$this.getCourseGroupForm();
                              var currentCourseGroupRecord = courseGroupForm.currentCourseGroupRecord;
                              var check  =  courseGroupForm.currentCourseGroupRecord==undefined;
                              if(check != true){   
                              var currentCourseGroupId = currentCourseGroupRecord.data.ID;
                              if(!isNullOrEmpty(currentCourseGroupRecord) && !isNullOrEmpty(currentCourseGroupRecord)){
                                  var recIdx = store.findExact('id',currentCourseGroupId);
                                  if(recIdx != -1){
                                      store.removeAt(recIdx);
                                      count++;
                                      flag++;
                                      
                                  }
                              }
                              }
                              }
                      });
                      
                     } 
                   },
    		  
					'coursetopicuploadform button[itemId=resetBtn]':{
						click:function(obj){
							var $this = this;
							var form =obj.up('coursetopicuploadform').getForm();
							form.findField('file').reset();
							form.isValid();
						}
					},
					'coursegroupdownloadform customcombobox[itemId=moduleName]': {
						select : function(obj) {
							var $this = this;
							var form =obj.up('coursegroupdownloadform').getForm();
							var form =$this.getCoursegroupdownloadform();
							obj.up('coursegroupdownloadform').down('#downoladBtnId').setDisabled(false);
						}
					},
					//download template
					'coursegroupdownloadform button[itemId=downoladBtnId]':{
						click:function(obj){
							var $this = this;
							var form =$this.getCoursegroupdownloadform();
							var templatecombo = form.down('#moduleName');
							var templateName = templatecombo.rawValue;
							var csvForm = Ext.create('Ext.form.Panel'); 
							csvForm.getForm().submit({
								target: '_blank',
								method:'POST',
								params :{
									access_token : Ext.Ajax.defaultHeaders.access_token,
									templateName : templateName
								},
								headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								url: SERVERURL.DOWNLOAD_TEMPLATE_COURSE_GROUP_ASSIGN_COURSE,
								standardSubmit :true
							});
						}  
					},
					'coursegroupuploadform button[itemId=resetBtn]':{
						click:function(obj){
							var $this = this;
							var form =obj.up('coursegroupuploadform').getForm();
							form.findField('importUtilityMasterId').reset();
							form.findField('file').reset();
							form.isValid();
						}
					},
					// Upload form
					'coursegroupuploadform button[itemId=uploadId]':{
						click:function(obj){
							var $this=this;
							var form =$this.getCoursegroupuploadform();
							var templatecombo = form.down('#moduleName');
							var templateName = templatecombo.rawValue;
							var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
							var moduleName = null;
							if(templateName=="Course Group"){
								moduleName = "Course Group";
							}else if(templateName=="Assign Courses"){
								moduleName = "Assign Courses";
							}
							$this.getHashOfFile(form);
							setTimeout(function() {
								form.getForm().submit({
									method : 'POST',
									url : submitUrl,
									success : function(form, action){
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
									},
									failure: function(form, action) {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
									}
								});
							},1000);
							Ext.defer(function() {
								var grid = $this.getImportlistcoursegroup();
								var isUploadAll = true;
								$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,templateName);
							}, 2000, this);
						}  
					},
					// loader grid
					'importlistcoursegroup':{
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							if (e.target.tagName == 'A') {
								var fileType=null;
								if(cellIndex==1){
									fileType='successFile';
								}else if(cellIndex==6){
									fileType='errorFile';
								}else if(cellIndex==7){
									fileType='logFile';
								}
								var documentId = record.get("id");
								if (!isNullOrEmpty(documentId)) {
									this.getDownloadFile(documentId,fileType);
								}
							}
						}
					},
					'importlistcoursegroup button[itemId=btnForce]':{
						click: function(obj) {
							var grid = this.getImportlistcoursegroup();
							if (grid.getSelectionModel().getCount() > 0) {
								if(grid.getSelectionModel().getCount() > 1){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
								}else{
									var this$ = this;
									var id = grid.getSelectionModel().selectionStart.data.id;
									console.log(id);
									var urlAppend="?jobName="+id;
									var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
									Ext.Ajax.request({
										url: submitURL,
										method: 'GET',
										success: function(response) {
											if(response.responseText==="JOB_STATUS_NOT_PENDING"){
												showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
											}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
												showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
											}else if(response.responseText==="SUCCESS"){
												showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
												grid.getStore().reload();
											}
										}
									});
								}
							} else {
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}  
						}
					},
					'searchresultgrid[itemId=courseGroupStructureGrid]':{

						render:function(grid){
							var permissionsMap = new Ext.util.HashMap();
							this.gridRenderFunction(grid);
							permissionsMap = this.getCOURSEGROUP_PERMISSIONS();
							this.genericCBGridAccessControlValidation(grid,permissionsMap);
						},
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						    var mutuallyExclusiveCourseGroupCount=0;
							if(record.data.MUTUALLY_EXCLUSIVE_COURSE_GROUP!="0"){
							mutuallyExclusiveCourseGroupCount = 1;
							}
							var $this=this;
							var searchResultGrid = $this.getSearchresultgrid();
							var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
							if(columnName=='NO_OF_COURSES_ASSOCIATED' &&  record.data.NO_OF_COURSES_ASSOCIATED > 0){ // checked
								//var store=$this.getStore('course.coursegroup.AssignCoursesStructureStore');


								var formWindow = $this.getNoofcourse();
								if (!formWindow) {
									Ext.widget('noofcourse');
									formWindow = $this.getNoofcourse();
									var store= $this.getNoofassociatedcourse().getStore();
									store.getProxy().extraParams = {
										id: record.data.ID
									};
									$this.resetPageSetting(store);
									store.load();
									$this.getNoofassociatedcourse().getView().refresh();
									$this.getNoofassociatedcourse().getStore().loadData(searchResultGrid);

								}
								formWindow.down('#courseGroup').setValue(record.data.COURSE_GROUP_NAME);
								formWindow.show();

							}

							if(columnName=='NO_OF_PROGRAMS_ASSOCIATED' &&  record.data.NO_OF_PROGRAMS_ASSOCIATED > 0){ // checked
								var store=$this.getStore('course.coursegroup.ProgramBYCourseGroup');
								store.getProxy().extraParams = {
									courseGroupId: record.data.ID
								};
								store.load();

								var formWindow = $this.getNoofprogram();
								if (!formWindow) {
									Ext.widget('noofprogram');
									formWindow = $this.getNoofprogram();
								}
								formWindow.show();
							}
							else if(columnName=='MUTUALLY_EXCLUSIVE_COURSE_GROUP' && mutuallyExclusiveCourseGroupCount > 0){ // checked
								var store=$this.getStore('course.coursegroup.CourseGroupAssociatedWinGridStore');
								store.getProxy().extraParams = {
									courseGroupCourseId: record.data.ID
								};
								store.load();

								var formWindow = $this.getCoursegroupassociatedwin();
								if (!formWindow) {
									Ext.widget('coursegroupassociatedwin');
									formWindow = $this.getCoursegroupassociatedwin();
								}
								formWindow.show();
							}
						}

					},'advancedsearchquerybuilder[itemId=advancedsearchCourseGroup] searchresultgrid[itemId=userAdvSearchResultGrid]': {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var $this=this;
							var searchResultGrid = grid.panel;
							var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
							if(columnName=='NO_OF_COURSES_ASSOCIATED' &&  record.data.NO_OF_COURSES_ASSOCIATED > 0){ // checked
								var store=$this.getStore('course.coursegroup.AssignCoursesStructureStore');
								var courseGroupId = record.data.ID
								store.getProxy().extraParams = {
									id: courseGroupId
								};
								$this.resetPageSetting(store);
								store.load();

								var formWindow = $this.getNoofcourse();
								if (!formWindow) {

									Ext.widget('noofcourse');
									formWindow = $this.getNoofcourse();
									var newStore = $this.getNoofassociatedcourse().getStore();
									newStore.getProxy().extraParams = {
										id: courseGroupId
									};
									newStore.reload();
									$this.getNoofassociatedcourse().getView().refresh();
									$this.getNoofassociatedcourse().getStore().loadData(searchResultGrid);

								}
								formWindow.down('#courseGroup').setValue(record.data.COURSE_GROUP_NAME);
								formWindow.show();

							}

							if(columnName=='NO_OF_PROGRAMS_ASSOCIATED' &&  record.data.NO_OF_PROGRAMS_ASSOCIATED > 0){ // checked
								var store=$this.getStore('course.coursegroup.ProgramBYCourseGroup');
								store.getProxy().extraParams = {
									courseGroupId: record.data.ID
								};
								store.load();

								var formWindow = $this.getNoofprogram();
								if (!formWindow) {
									Ext.widget('noofprogram');
									formWindow = $this.getNoofprogram();
								}
								formWindow.show();
							}
						}
					},
					//
					'searchresultgrid[itemId=courseGroupStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
						click: function() {
							this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
						}
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
						click: function() {
							this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
						}
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
						click: function() {
							this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
						}
					},
					'searchresultgrid[itemId=courseGroupStructureGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
						click: function() {
							this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
						}
					},
					/*'courseGroupForm' : {
						afterrender : function(obj){
							var $this = this;
							setTimeout(function(){
								$this.hideInvalidIconFromField($this.getCourseGroupForm());
							},300);
							this.getCourseGroupDrool();
						}
					},*/
					/*'coursegroupquicksearchform' : {
						render : function(obj){
							var $this = this;
							obj.body.on('click', function() {
								$this.hideInvalidIconFromField($this.getCoursegroupquicksearchform());
							});
						}
					}*/
					
					'coursegroupquicksearchform' : {
						render : function(obj){
							var $this = this;
							var form = this.getCoursegroupquicksearchform();
							var courseGroupTypeStore=form.down('#groupTypeId').getStore();
							courseGroupTypeStore.load();
							
						}
					}
				});
			},
			courseGroupGrid : function (){
				var $this = this;
				var store = $this.getStore('course.coursegroup.CourseGroupStructureStore');
				store.load();
			},
			
			
			showFormWindow: function() {
				var $this = this;
				var contentpanel = $this.getContentpanel();
				var coursegroupstructure = Ext.widget('coursegroup', {
					listeners: {
						afterrender: function(){
							var form = $this.getCourseGroupForm();
							
							var submitURL = SERVERURL.PATH_GET_COURSE_GROUP_VARIABLE_VALUE;
							Ext.Ajax.request({
								url: submitURL,
								method: 'GET',
								success: function(response) {
									if(!isEmpty(response.responseText)){
										form.down('#courseGroupVariableFC').show();
										var courseGroupVariableId=	form.down('#courseGroupVariableId');
										courseGroupVariableId.show();
										courseGroupVariableId.setValue("<span> <font style='padding-top: 2px;display: inline-block;'>Course group code must contain the configured variable code : "+response.responseText+"</font></span>");
									}
								}
							});
						}
					}
				});
				var tabName = getCommonTranslation('COURSE_GROUP_DETAIL');

				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentpanel.remove(getTab, true);
				}
				openTab(contentpanel, tabName, coursegroupstructure,CONSTANTS.MENU_COLOR_THREE);

			},
			closeFormWindow: function() {
				this.getCourseGroupForm().getForm().reset();
			},
			viewFormWindow: function() {
				this.editFormWindow();
				var form = this.getCourseGroupForm();
				var assignCoursesStructureGrid = this.getAssignCoursesStructureGrid();
				if (form) {
					form.down('#saveCourseGroupButtonId').setVisible(false);
					form.down('#resetBtn').setVisible(false);
					form = form.getForm();
					toggleReadOnlyFormItems(form, true);
				}
				if(assignCoursesStructureGrid) {
					var btnAdd = assignCoursesStructureGrid.down('#btnAdd');
					var btnEdit = assignCoursesStructureGrid.down('#btnEdit');
					var btnDelete = assignCoursesStructureGrid.down('#btnDelete');

					if(btnAdd)
						btnAdd.setVisible(false);
					if(btnEdit)
						btnEdit.setVisible(false);
					if(btnDelete)
						btnDelete.setVisible(false);
				}

			},

			editFormWindow: function() {
			
				var $this = this;
				var grid = $this .getSearchresultgrid();
				if (grid.getSelectionModel().getCount() > 0) {
					$this .showFormWindow();
					var records = grid.getSelectionModel().getSelection();
					if (records != undefined && records != "" && records != null) {
						var id = records[0].data.ID;
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.COURSE_GROUP_FIND_BY_ID,
							scope : $this,
							params : {
								id : id
							},
							method : 'GET',
							success : function(response) {
								var courseGroupForm=$this.getCourseGroupForm();
								courseGroupForm.currentCourseGroupRecord=records[0];
								var form = $this.getCourseGroupForm().getForm();
								var data = Ext.decode(response.responseText);
								
								var mutuallyExclusiveCourseGroup = form.findField('mutuallyExclusiveCourseGroup');                			
	                			var mutuallyExclusiveCourseGroupStore = mutuallyExclusiveCourseGroup.getStore();
	                			
	                			if(data.mutuallyExclusiveCourseGroup != null){
	                				
	                				mutuallyExclusiveCourseGroupStore.load({
	                					callback: function(records, operation, success) {
	                						if (success) {
		                						var mutuallyExclusiveCourseGroupArray= [];
		                						if(records.length > 0){
		                							data.mutuallyExclusiveCourseGroup.forEach(function(mutuallyExclusiveCourseGroupObj){
		                								var result = records.filter(function (obj) {
		                									  return obj.data.id === mutuallyExclusiveCourseGroupObj.mutuallyExclusiveCourseGroup.id;
		                									})[0];
		                								mutuallyExclusiveCourseGroupArray.push(result);
		                							});
		                							mutuallyExclusiveCourseGroup.setValue(mutuallyExclusiveCourseGroupArray);
		                						}
		                					}
	                					}
	                				});
	                			}
	                			
	                			if(data.mutuallyExclusiveCourseGroup.length == 0 && data.mutuallyExclusiveCourseGroup!=null){
	                				
	                				mutuallyExclusiveCourseGroupStore.load({
	                					callback: function(records, operation, success) {
	                						if (success) {
		                						var mutuallyExclusiveCourseGroupArray= [];
		                						if(records.length > 0){
		                								var result = records.filter(function (obj) {
		                							    return obj.data.id === data.mutuallyExclusiveCourseGroup.id;
		                								})[0];
		                								mutuallyExclusiveCourseGroupArray.push(result);
		                								mutuallyExclusiveCourseGroup.setValue(mutuallyExclusiveCourseGroupArray);
		                						}
		                					}
	                					}
	                				});
	                			}
						
						
								
								
								var course = new Academia.model.course.coursegroup.CourseGroupModel(data);
								form.loadRecord(course);
								$this.getCoursegroup().items.items[1].setDisabled(false);
								var button =Ext.ComponentQuery.query('button#saveCourseGroupButtonId')[0];
								button.setText('Save');
								var resetButton=courseGroupForm.down('#resetBtn');
								resetButton.setVisible(false);
								/*var resetButton =Ext.ComponentQuery.query('button#resetBtn')[0];
		            					resetButton.setVisible(false);*/
								var whetherGroupRadio =form.findField('whetherGroup');

								if(data.whetherRegularGroup){
									whetherGroupRadio.ownerCt.items.items[0].setValue(true);
									whetherGroupRadio.ownerCt.items.items[1].setValue(false);
									whetherGroupRadio.ownerCt.items.items[2].setValue(false);
								}else if(data.whetherSpecializedGroup){
									whetherGroupRadio.ownerCt.items.items[0].setValue(false);
									whetherGroupRadio.ownerCt.items.items[1].setValue(false);
									whetherGroupRadio.ownerCt.items.items[2].setValue(true);
								}else if(data.whetherAuditGroup){
									whetherGroupRadio.ownerCt.items.items[0].setValue(false);
									whetherGroupRadio.ownerCt.items.items[1].setValue(true);
									whetherGroupRadio.ownerCt.items.items[2].setValue(false);
								}
								if(!isNullOrEmpty(data.courseGroupCriteria)){
									var droolField = courseGroupForm.down('#courseGroupDroolItemId');
									droolStore = droolField.getStore();
									droolStore.getProxy().extraParams = {              
										moduleName:'COURSE_GROUP_RULE' 
									};
									droolStore.load({
										callback : function(records, operation, success) {
											droolField.setValue(data.courseGroupCriteria.id)
										}
									});
								}
								if(!isNullOrEmpty(data.courseGroupAffiliation)){
									var courseGroupAffiliationField = form.findField('courseGroupAffiliation');;
									courseGroupAffiliation = courseGroupAffiliationField.getStore();
									courseGroupAffiliation.load({
										callback : function(records, operation, success) {
											courseGroupAffiliationField.setValue(data.courseGroupAffiliation.id)
										}
									});
								}
								if(!isNullOrEmpty(data.programEndorsement)){
									var programEndorsementField = form.findField('programEndorsement');
									store = programEndorsementField.getStore();
									store.load({
										callback : function(records, operation, success) {
											programEndorsementField.setValue(data.programEndorsement.id)
										}
									});
								}
								
								if(!isNullOrEmpty(data.byPassRules)){
									var byPassRulesField = form.findField('byPassRules');
									/*store = byPassRulesField.getStore();
									store.load({
										callback : function(records, operation, success) {
											byPassRulesField.setValue(data.byPassRules.id)
										}
									});*/
								}
							}
							
							
						
						});
						var courseGroupFormTemp=$this.getCourseGroupForm();
						Ext.Ajax.request({
							url: SERVERURL.PATH_GET_COURSE_GROUP_VARIABLE_VALUE,
							method: 'GET',
							success: function(response) {
								var courseGroupVariableId=	courseGroupFormTemp.down('#courseGroupVariableId');
								if(!isEmpty(response.responseText)){
									courseGroupFormTemp.down('#courseGroupVariableFC').show();
									courseGroupVariableId.show();
									courseGroupVariableId.setValue("<span> <font style='padding-top: 2px;display: inline-block;'>Course group code must contain the configured variable code : "+response.responseText+"</font></span>");
								}else{
									courseGroupVariableId.hide();
								}
							}
						});
					}
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},

			deleteRecord: function() {
				var grid = this .getSearchresultgrid();

				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getCommonTranslation('COURSE_GROUP'), getCommonTranslation('ASSOCIATED_SUBJECT_GROUP_DELETE'), function(btn, text) {
						if (btn == 'yes') {
							var record = grid.getSelectionModel().getSelection()[0];
							var id = record.get("ID");

							Ext.Ajax.request({
								method: "DELETE",
								type: 'rest',
								url: SERVERURL.COURSE_GROUP_DELETE + '?id=' + id ,
								headers : {
									'Content-Type' : 'application/json'
								},
								params: {
									id: id
								},
								success: function(form, action) {
									if(form.responseText=="SUCCESS"){
										showSuccessMessage(getCommonTranslation('COURSE_GROUP'),getCommonTranslation('SUCCESS'));
										grid.getStore().reload();
									}else{
										showWarningMessage(getCommonTranslation('COURSE_GROUP'),
												getProgramandcourseTranslation('COURSE_GROUP_DEPENDENCY_EXIST'));
									}
								}
							});
						}
					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			saveUpdateUser: function(model, records) {
				var $this = this;
				var form = this.getCourseGroupForm().getForm();
				var value = form.getValues();
				var whetherGroup = value.whetherGroup;

	    	    var mutuallyExclusiveCourseGroupIds = [];
	    	     if(!isNullOrEmpty(value.mutuallyExclusiveCourseGroup) && value.mutuallyExclusiveCourseGroup !=undefined ){
	        		if(typeof value.mutuallyExclusiveCourseGroup == "object"){
	            		Ext.each(value.mutuallyExclusiveCourseGroup, function(mutuallyExclusiveCourseGroupId){
	                    	var mutuallyExclusiveCourseGroup = '';
                            var courseGroup  = ''; 
	                        if(!isNullOrEmpty(mutuallyExclusiveCourseGroupId)){
	                    	mainObj = {
	                    			"mutuallyExclusiveCourseGroup" : {
	                    					"id" : mutuallyExclusiveCourseGroupId.data.id
	                    			},
	                    			"courseGroup" : {
	                    					"id": form.findField('id').getValue()
	                    			}		
	                    	}
	                    	mutuallyExclusiveCourseGroupIds.push(mainObj);
	                        }
                    });
                      }
                      
        		else{
        			var mutuallyExclusiveCourseGroup = '';
	                	var courseGroup = '';
	                	var mainObj = '';
	                	mainObj = {
	                			"mutuallyExclusiveCourseGroup" : {
	                					"id" : value.mutuallyExclusiveCourseGroup.id
	                			},
	                			"courseGroup" : {
	                					"id": form.findField('id').getValue()
	                			}		
	                	}
	                	mutuallyExclusiveCourseGroupIds.push(mainObj);
	        		}
	        	}
	    	    

				var courseGroups = new Academia.model.course.coursegroup.CourseGroupModel();

				courseGroups.set("id", value.id);
				courseGroups.set("valueCode", "");
				courseGroups.set("code", value.code);
				courseGroups.set("mutuallyExclusiveCourseGroup", mutuallyExclusiveCourseGroupIds);
				courseGroups.set("groupName", value.groupName);
				courseGroups.set("maxCourses", value.maxCourses);
				courseGroups.set("maxCredits", value.maxCredits);
				courseGroups.set("minCourses", value.minCourses);
				courseGroups.set("minCredits", value.minCredits);
				courseGroups.set("optionalMaxCourses", value.optionalMaxCourses);
				courseGroups.set("optionalMinCourses", value.optionalMinCourses);
				courseGroups.set("customFieldDatas", value.customFieldDatas);
				courseGroups.set("minCourseEnrollment", value.minCourseEnrollment);
				courseGroups.set("maxCourseEnrollment", value.maxCourseEnrollment);
				courseGroups.set("courseGroupCriteria", this.getIdValueJson(value.courseGroupDrool));
				courseGroups.set("courseGroupAffiliation", this.getIdValueJson(value.courseGroupAffiliation));
				courseGroups.set("programEndorsementId", value.programEndorsement);
				courseGroups.set("byPassRules", value.byPassRules);
				courseGroups.set("isThisRecessTerm", value.isThisRecessTerm);
				if(whetherGroup == 1){
					courseGroups.set("whetherRegularGroup", true);
					courseGroups.set("whetherSpecializedGroup", false);
					courseGroups.set("whetherAuditGroup", false);
				}else if(whetherGroup == 2){
					courseGroups.set("whetherRegularGroup", false);
					courseGroups.set("whetherSpecializedGroup", true);
					courseGroups.set("whetherAuditGroup", false);
				}else if(whetherGroup == 3){
					courseGroups.set("whetherRegularGroup", false);
					courseGroups.set("whetherSpecializedGroup", false);
					courseGroups.set("whetherAuditGroup", true);
				}

				var submitUrl;
				if (form.findField('id').getSubmitValue() == null
						|| form.findField('id').getSubmitValue() == "") {

					submitUrl = SERVERURL.COURSE_GROUP_ADD;
				} else {
					courseGroups.set("id", value.id);
					submitUrl = SERVERURL.COURSE_GROUP_UPDATE;
				}
				delete courseGroups.data.courseGroupName;
				delete courseGroups.data.courseName;
				delete courseGroups.data.programAssociated;
				delete courseGroups.data.whetherOptional;
				delete courseGroups.data.courseGroupId;
				var formData = Ext.encode(courseGroups.data);
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');                  
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : formData,
					method : 'POST',
					success : function(form, action) {
						Ext.getBody().unmask();
						var groupId = form.responseText;
						var form = $this.getCourseGroupForm().getForm();
						//$this.getCourseGroupForm().down('#saveCourseGroupButtonId').setDisabled(true);
						form.findField('id').setValue(groupId);
						showSuccessMessage(getCommonTranslation('COURSE_GROUP'), getCommonTranslation('SUCCESS'));
						$this.getStore('course.coursegroup.CourseGroupStructureStore').load();
						$this.getCoursegroup().items.items[1].setDisabled(false);

					}
				});
			},
			// toolbar for buttons
			gridRenderFunction:function(grid){
				grid.addButtonToolbar();
			},

			loadGridAndSearchPrograms : function(model, records) {
				var quickSearchForm = this.getCoursegroupquicksearchform();
				quickSearchForm.down('#courseGroupQuickSearchFormId').setDisabled(true);
				var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
				var searchResultGrid = this.getSearchresultgrid();
				var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
				resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.COURSE_GROUP_LIST_VIEWCODE);
				searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, quickSearchForm.down('#courseGroupQuickSearchFormId'));
			},

			createJsonFormat:function(quickSearchForm, record){			
				var courseGroupCode = quickSearchForm.down('#quick_search_courseGroupCode');
				//var courseGroupName = quickSearchForm.down('#quick_search_courseGroupName');
				var courseGroupType = quickSearchForm.down('#groupTypeId');

				var courseCode = quickSearchForm.down('#courseNameQuickFiltr');

				var values = new Object();
				values.configCode = CONSTANTS.CB.COURSE_GROUP_LIST_CONFIGCODE;
				var searchcriteria = new Array();
				if(courseGroupCode.getValue() != "" && courseGroupCode.getValue() != null){
					searchcriteria.push({paramCode:"COURSE_GROUP_CODE", paramValues:[courseGroupCode.getValue()]});
				}
				if(courseCode.getValue() != "" && courseCode.getValue() != null){
					searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseCode.getValue()]});
				}
				/*if(courseGroupName.getValue() != ""){
        			searchcriteria.push({paramCode:"COURSE_GROUP_NAME", paramValues:[courseGroupName.getValue()]});
        		}*/
				if(!isNullOrEmpty(courseGroupType.getValue())){
					if(courseGroupType.getValue()=="REGULAR_GROUP"){
						searchcriteria.push({paramCode:"WHETHER_REGULAR_GROUP", paramValues:[1]});
					}else if(courseGroupType.getValue()=="AUDIT_GROUP"){
						searchcriteria.push({paramCode:"WHETHER_AUDIT_GROUP", paramValues:[1]});
					}else if(courseGroupType.getValue()=="SPECIALIZATION_GROUP"){
						searchcriteria.push({paramCode:"WHETHER_SPECIALIZATION_GROUP", paramValues:[1]});
					}

				}
				values.searchCriterias=searchcriteria;
				return values;
			},
			whetherRadioFieldsChanges:function(cb, nv, ov){
				var form = this.getCourseGroupForm().getForm();
				if(nv.whetherGroup == 3){
					/*  form.findField('minCourses').setValue(0);
	            form.findField('minCourses').setReadOnly(true);
	            form.findField('maxCourses').setValue(0);
	            form.findField('maxCourses').setReadOnly(true);
	            form.findField('optionalMinCourses').setValue(0);
	            form.findField('optionalMinCourses').setReadOnly(true);
	            form.findField('optionalMaxCourses').setValue(0);
	            form.findField('optionalMaxCourses').setReadOnly(true);
	            form.findField('minCredits').setValue(0);
	            form.findField('minCredits').setReadOnly(true);
	            form.findField('maxCredits').setValue(0);
	            form.findField('maxCredits').setReadOnly(true);
					 */
					form.findField('minCourses').setReadOnly(false);
					form.findField('maxCourses').setReadOnly(false);
					form.findField('optionalMinCourses').setReadOnly(false);
					form.findField('optionalMaxCourses').setReadOnly(false);
					form.findField('minCredits').setReadOnly(false);
					form.findField('maxCredits').setReadOnly(false);	
				}else{
					form.findField('minCourses').setReadOnly(false);
					form.findField('maxCourses').setReadOnly(false);
					form.findField('optionalMinCourses').setReadOnly(false);
					form.findField('optionalMaxCourses').setReadOnly(false);
					form.findField('minCredits').setReadOnly(false);
					form.findField('maxCredits').setReadOnly(false);
				}
			},
			//change radio button download upload
			courseGroupDownloadUploadFormChange : function(cb, nv, ov){
				var $this = this;
				var structure = cb.up('coursegroupuploaddownloadstructure');
				var downloadTemplateForm = structure.down('coursegroupdownloadform');
				var uploadTemplateForm = structure.down('coursegroupuploadform');
				var grid = $this.getImportlistcoursegroup();
				if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
					uploadTemplateForm.hide();
					downloadTemplateForm.show();
					grid.setVisible(false);
				}else{
					downloadTemplateForm.hide();
					uploadTemplateForm.show();
					grid.setVisible(true);
					uploadTemplateForm.down("#uploadFileField").reset();
				}
			},
			/*exportList : function(exportUrl,filetype,whetherAll) {
        		var quickSearchForm=this.getCoursegroupquicksearchform();	
        		var searchResultGrid = this.getSearchresultgrid();
        		var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
        		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
        		var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
        		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
        		jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
        		}
        		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString);
        		}, */
			exportUserList : function(exportUrl,filetype,whetherAll) {
				var quickSearchForm=this.getCoursegroupquicksearchform(); 
				var searchResultGrid = this.getSearchresultgrid();
				var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
				var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
				var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
				var visibleColumns=this.getVisibleColumns(searchResultGrid);
				var reportTitle=getCommonTranslation("COURSE_GROUP_LIST");
				if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
					jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
				}
				searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

			},


			createSearchCriteriaString: function(searchForm) {
				var me=this;
				var formValues = new Array();
				formValues = searchForm.getValues();        
				var searchCriteriaString="";
				for (var key in formValues) {
					var value = formValues[key];            
					if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
						var keyValueJsonObject = me.getJsonObject( key , value);
						searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
					}
				}
				searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
				return searchCriteriaString;
			},
			getJsonObject : function(key, value, additionalValue) {
				if (value != '' && value != null
						&& additionalValue == undefined) {
					return {
						"paramCode" : key,
						"paramValues" : [ value ]
					};
				} else if (value != '' && additionalValue != undefined) {
					return {
						"paramCode" : key,
						"paramValues" : [ value, additionalValue ]
					};
				}
			},
			getDownloadFile : function(documentId,fileType){

				if(!isNullOrEmpty(documentId)){
					var csvForm = Ext.create('Ext.form.Panel'); 
					csvForm.getForm().submit({
						target: '_blank',
						method:'POST',
						params :{
							access_token : Ext.Ajax.defaultHeaders.access_token
						},
						headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
						standardSubmit :true
					});
				}
			},
			getCourseGroupDrool : function() {
				var $this = this;
				var form = $this.getCourseGroupForm();
				var droolStore = form.down('#courseGroupDroolItemId').getStore();
				droolStore.getProxy().extraParams = {              
					moduleName:'COURSE_GROUP_RULE' 
				};
				droolStore.load();
			},
			getIdValueJson : function(id, value, code) {
				if (id)
					return {
					id : id,
					value : value,
					code : code
				};
			},
});