/**
 *  @author Rajkumar.patidar
 *  @author Utsav Chandvaniya
 */
Ext.define('Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentListController', {
    extend: 'Academia.controller.base.BaseController',
    models:[ ],
    stores:['coursetransaction.coursereading.MaterialType','coursetransaction.facultytopicassignment.AssignTopics',
            'coursetransaction.facultytopicassignment.FacultyDetails','coursetransaction.sectionmanagement.CoruseSectionStore'],
    views: [ 'baselayout.contentarea.ContentPanel',
            'coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentListStructure', 
            'coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentSearch',
            'coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentSearchListing',
            'coursetransaction.facultyTopicAssignment.ProdramBatchSearchForFTA',
            'coursetransaction.facultyTopicAssignment.CourseSectionSearchForFTA',
            'coursetransaction.facultyTopicAssignment.AssignTopicWin'],
            
    config:{
        	    
           	 /*
             	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
              		   	 */
              	   	/**
              	        * @cfg {Array} FACULTY_TOPICASSIGNMENT_PERMISSIONS array (required)
              	        * The array of permissions to use for Access control wise enabling and disabling buttons.
              	        * @accessor
              	        */
         //  	FACULTY_TOPICASSIGNMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_TOPICASSIGNMENT_PRIVILEGES')
           	
           },              

    refs: [{
        ref: 'facultytopicassignmentliststructure',
        selector: 'facultytopicassignmentliststructure'
    },{
        ref: 'facultytopicassignmentsearch',
        selector: 'facultytopicassignmentsearch'
    },{
        ref: 'facultytopicassignmentsearchlisting',
        selector: 'facultytopicassignmentsearchlisting'
    },{
        ref: 'facultytopicassignmentlistgrid_PBS',
        selector: 'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS]'
    },{
        ref: 'facultytopicassignmentlistgrid_CBS',
        selector: 'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS]'
    },{    	
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
    	ref:'prodrambatchsearchforfta',
    	selector:'prodrambatchsearchforfta'
    },{
    	ref:'coursesectionsearchforfta',
    	selector:'coursesectionsearchforfta'
    },{
    	ref:'assigntopicwin',
    	selector:'assigntopicwin'
    }],

    init: function() {
        this.control({
        	 'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_PBS();
			               var quickSearchForm=this.getProdrambatchsearchforfta(); 
			               //console.log('getStudentattendance',this.getStudentattendance());
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_PBS_CONFIGCODE;
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
		            }
		        },
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_PBS();
			               var quickSearchForm=this.getProdrambatchsearchforfta(); 

			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_PBS_CONFIGCODE;
			                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);		            
			              }
		        },
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_PBS();
		            	   console.log('getStudentCourseLevelGridId',searchResultGrid);
			               var quickSearchForm=this.getProdrambatchsearchforfta(); 
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_PBS_CONFIGCODE;
			               this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);		           
			             }
		        },
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_PBS();
		            	   console.log('getStudentCourseLevelGridId',searchResultGrid);
			               var quickSearchForm=this.getProdrambatchsearchforfta(); 
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_PBS_CONFIGCODE;
			               this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);		            
			                }
		        },
		        //
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_CBS();
			               var quickSearchForm=this.getCoursesectionsearchforfta(); 
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_CBS_CONFIGCODE;
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
		            }
		        },
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_CBS();
			               var quickSearchForm=this.getCoursesectionsearchforfta(); 
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_CBS_CONFIGCODE;
			                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);		            
			                }
		        },
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_CBS();
		            	   console.log('getStudentCourseLevelGridId',searchResultGrid);
			               var quickSearchForm=this.getCoursesectionsearchforfta(); 
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_CBS_CONFIGCODE;
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode);
		            }
		        },
		        'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	   var searchResultGrid=this.getFacultytopicassignmentlistgrid_CBS();
		            	   console.log('getStudentCourseLevelGridId',searchResultGrid);
			               var quickSearchForm=this.getCoursesectionsearchforfta(); 
			               var configCode=CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_CBS_CONFIGCODE;
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode);
		            }
		        }, 
        	'facultytopicassignmentsearch radiogroup[itemId=facultyTopicRadioId]':{
        		change:function(value,newValue,oldValue){
        			 var $this =  this;
                	 var form = $this.getFacultytopicassignmentsearch();
                	 
        			if(!newValue.sectionType){
        				form.down("#prodrambatchsearchforfta").setVisible(false);
        				form.down("#coursesectionsearchforfta").setVisible(true);
        				form.down("#prodrambatchsearchforfta").getForm().reset();
        				$this.getFacultytopicassignmentlistgrid_PBS().getStore().removeAll();
        				$this.getFacultytopicassignmentlistgrid_CBS().getStore().removeAll();
        			}else{
        				form.down("#prodrambatchsearchforfta").setVisible(true);
        				form.down("#coursesectionsearchforfta").setVisible(false);
        				form.down("#coursesectionsearchforfta").getForm().reset();
        				$this.getFacultytopicassignmentlistgrid_PBS().getStore().removeAll();
        				$this.getFacultytopicassignmentlistgrid_CBS().getStore().removeAll();
        			}
        		}
        	},
            'prodrambatchsearchforfta button[itemId=searchBtn]': {
                click: this.loadGridAndSearchFacultyTopicAssignment
            },
            'coursesectionsearchforfta button[itemId=searchBtn]': {
                click: this.loadGridAndSearchFacultyTopicAssignment
            },
            'prodrambatchsearchforfta button[itemId=resetBtn]': {
                click: function(){
                	this.getProdrambatchsearchforfta().getForm().reset();
                }
            },
            'coursesectionsearchforfta button[itemId=resetBtn]': {
                click: function(){
                	this.getCoursesectionsearchforfta().getForm().reset();
                }
            },
            // this is for dynamic grid view 
            'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS]': {
                render: function(grid) {
                	 var permissionsMap = new Ext.util.HashMap();
                     this.gridRenderFunction(grid);
                    /* permissionsMap = this.getFACULTY_TOPICASSIGNMENT_PERMISSIONS();
                     this.genericCBGridAccessControlValidation(grid,permissionsMap);*/
                },
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                    var columnName=grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    if(columnName==getCourseTxCommonTranslation('TOPIC_ASSIGNED') || columnName=='TOPIC_ASSIGNED'){ // checked
              		   this.getTopicAssigned(grid, rowIndex, record);
              	   }
                 },
            },
            'searchresultgrid[itemId=facultytopicassignmentlistgrid_PBS] button[itemId=searchResultGridBtnAdd]': {
                click : function() {
                	this.openFTAform();
                }
            },'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS]': {
                render: function(grid) {
               	 var permissionsMap = new Ext.util.HashMap();
                    this.gridRenderFunction(grid);
                   /* permissionsMap = this.getFACULTY_TOPICASSIGNMENT_PERMISSIONS();
                    this.genericCBGridAccessControlValidation(grid,permissionsMap);*/
               },
               cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                   var columnName=grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                   if(columnName==getCourseTxCommonTranslation('TOPIC_ASSIGNED') || columnName=='TOPIC_ASSIGNED'){ // checked
             		   this.getTopicAssigned(grid, rowIndex, record);
             	   }
                }
           },
           'advancedsearchquerybuilder[itemId=advancedsearchquerybuilderFTA] searchresultgrid[itemId=userAdvSearchResultGrid]': {
        	   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        		   var columnName=grid.panel.columnManager.columns[cellIndex].dataIndex;
        		   if(columnName==getCourseTxCommonTranslation('TOPIC_ASSIGNED')){ // checked
        			   this.getTopicAssigned(grid, rowIndex, record);
        		   }
        	   }
           },
//           advancedsearchquerybuilderFTA
           
           
           
           
           'searchresultgrid[itemId=facultytopicassignmentlistgrid_CBS] button[itemId=searchResultGridBtnAdd]': {
               click : function() {
               	this.openFTAform();
               }
           },
            'prodrambatchsearchforfta combo#programId' : {
   			 select : function(obj, record) {
   				 this$=this;
   				 var form =this.getProdrambatchsearchforfta();
   				 var programId = record[0].get("id");
   				 if (programId > 0) {
   					 var store = this.getStore('enquiry.AcademicBatchStore');
   					 store.getProxy().extraParams = {
   						 id : programId
   					 };
   					 store.load({

						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==0){
								   }
								   if(records.length==1){
									   form.down("#batchId").setValue(records[0].get('id'));
									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
									   store.getProxy().extraParams = {
										   id: records[0].get('id'),
										   isCurrentPeriod:true
									   };
									   store.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==0){
													   if(wheatherSchool) {
														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

													   } 
												   }
												   if(records.length==1){
													   form.down("#periodId").setValue(records[0].get('id'))
													   var periodId = records[0].get("id");
													   var BatchField=Ext.ComponentQuery.query('combo#batchId')[0];
													   var courseStore = this$.getStore('coursetransaction.facultytopicassignment.CourseComboStore');
													   courseStore.getProxy().extraParams = {
														   periodId : periodId,
														   batchId:BatchField.getValue()
													   };
													   courseStore.load();
   			 
												   }
											   }
										   }
									   });
								   }
							   }
						   }
					   
   					 });
   				 }
   			 }
		 },
   		 'prodrambatchsearchforfta combo#batchId' : {
   			 select : function(obj, record) {
   				    this$=this;
  				    var form =this.getProdrambatchsearchforfta();
   				    var batchId = record[0].get("id");
   				    var periodComboBox = this.getFacultytopicassignmentsearch().down('combo#periodId');
   					var periodStore = periodComboBox.getStore();
   					periodStore.getProxy().extraParams = {
   	                        id: batchId
   	                    };
   					 periodStore.load({

						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==0){
									   if(wheatherSchool) {
										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

									   } 
								   }
								   if(records.length==1){
									   form.down("#periodId").setValue(records[0].get('id'))
									   	var periodId = records[0].get("id");
									    var BatchField=Ext.ComponentQuery.query('combo#batchId')[0];
										var courseStore = this$.getStore('coursetransaction.facultytopicassignment.CourseComboStore');
									   courseStore.getProxy().extraParams = {
											 periodId : periodId,
											 batchId:BatchField.getValue()
									 };
									   courseStore.load();
								   }
							   }
						   }
					   
   					 });
   			 }
   		 },
   		 'prodrambatchsearchforfta combo#periodId' : {
   			 select : function(obj, record) {
   				     var periodId = record[0].get("id");
   				     var BatchField=Ext.ComponentQuery.query('combo#batchId')[0];
					 var courseStore = this.getStore('coursetransaction.facultytopicassignment.CourseComboStore');
					 courseStore.getProxy().extraParams = {
						 periodId : periodId,
						 batchId:BatchField.getValue()
					 };
					 courseStore.load();
   			 }
   		 },'prodrambatchsearchforfta combo#facultyId' : {
   			 select : function(obj, record) {				 
				 var searchBtn = Ext.ComponentQuery.query('#searchBtn')[0];
				 searchBtn.enable();
			 }
		 },
   		'prodrambatchsearchforfta' : {
  			 render : function() {
  				 var alinfomodel = Academia.model.authentication.ALInfoModel;
				 var wheatherSchool = alinfomodel.get('wheatherSchool');
				 var form =this.getProdrambatchsearchforfta();
				 if(wheatherSchool) {
	  				 form.down('#periodId').setVisible(false);
				 }
  				var facultyStore = this.getStore('coursetransaction.facultytopicassignment.FacultyDetails');
					 facultyStore.getProxy().extraParams = {
						 componentId:'',
						 periodId:'',
					     courseId:''
					 };
					 facultyStore.load();
  			 }
  		 },
   		 
   		 'prodrambatchsearchforfta combo#courseId': {
			 select: function(obj, record) {
				
				 var $this=this;
				 var courseId = record[0].get("id");
				 var periodId=obj.previousSibling().items.items[1].getValue();
				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore');
				 var componentField = this.getProdrambatchsearchforfta().down("#componentSectionItemId");
				 $this.getProdrambatchsearchforfta().down("#topicId").setDisabled(false);
				 
				 if(record[0].data.sectionAtComponentLevel){
					 componentField.show();
//					 componentField.allowBlank=false;
    				 if(courseId > 0){//section on the bases of component
    					 componentField.getStore().getProxy().extraParams = {
    						 id : courseId
    					 };
    					 componentField.getStore().load();
    				 }
				 }else{
					 componentField.hide();
					 componentField.reset();
//					 componentField.allowBlank=true;
				 if(courseId > 0 && periodId>0){
					 sectionStore.getProxy().extraParams = {
						 courseId : courseId,
						 periodId : periodId
					 };
					 sectionStore.load();
				   }
				 }
				 var topicStore = $this.getStore('coursetransaction.coursereading.MaterialType');
				 if(courseId > 0){
					 topicStore.getProxy().extraParams = {
						 courseId : courseId
					 };
					 topicStore.load();
				 }
				 
				 var facultyStore = $this.getStore('coursetransaction.facultytopicassignment.FacultyDetails');
				 if(courseId > 0 && periodId >0){
					 facultyStore.getProxy().extraParams = {
						 componentId:'',
						 periodId:periodId,
					     courseId:courseId
					 };
					 facultyStore.load();
				 }
			 }
		 },
		 'prodrambatchsearchforfta combo#componentSectionItemId': {
			 select: function(obj, record) {
				 var $this=this;
				 var form=$this.getProdrambatchsearchforfta().getForm();
				 var formValues=form.getFieldValues();

				 var componentId=record[0].get("id");
				 var courseId = formValues.COURSE_ID;
				 var periodId=formValues.PROGRAM_BATCH_PERIOD_CONFIG_ID;
				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore');
				 if(courseId > 0 && periodId>0&&componentId>0){
					 sectionStore.getProxy().extraParams = {
						 periodId : periodId,
						 componentId:componentId
					 };
					 sectionStore.load();
				 }

				 var facultyStore = $this.getStore('coursetransaction.facultytopicassignment.FacultyDetails');
				 if(courseId > 0 && periodId >0){
					 facultyStore.getProxy().extraParams = {
						 componentId:componentId,
						 periodId:periodId,
						 courseId:courseId
					 };
					 facultyStore.load();
				 }

				 var topicStore = $this.getStore('coursetransaction.coursereading.MaterialType');
				 if(courseId > 0){
					 topicStore.getProxy().extraParams = {
						 componentId:componentId,
						 courseId : courseId
					 };
					 topicStore.load();
				 }

			 }
		 },
		 
		 'coursesectionsearchforfta combo[itemId=allCourseId]': {
			 select: function(obj, record) {
				 var $this=this;
				 var courseId = record[0].get("id");
				 var alinfomodel = Academia.model.authentication.ALInfoModel;
				 var whetherSchool = alinfomodel.get('wheatherSchool');
				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByIDStore');
				 var  componentField = this.getCoursesectionsearchforfta().down("#componentSectionItemId");
				 //$this.getCoursesectionsearchforfta().down("#courseSectionId").setDisabled(true);
				 $this.getCoursesectionsearchforfta().down("#topicId").setDisabled(false);
				 if(record[0].data.sectionAtComponentLevel){
					 $this.getCoursesectionsearchforfta().down("#courseSectionId").setDisabled(true);
					 componentField.show();
					 if(courseId > 0){//section on the bases of component
						 componentField.getStore().getProxy().extraParams = {
							 id : courseId,
							 whetherSchool:whetherSchool
						 };
						 componentField.getStore().load();
					 }
				 }else{
					 componentField.hide();
					 componentField.reset();
					 $this.getCoursesectionsearchforfta().down("#courseSectionId").setDisabled(false); 
					 if(courseId > 0){
						 sectionStore.getProxy().extraParams = {
							 courseId : courseId,
							 whetherSchool:whetherSchool
						 };
						 sectionStore.load();
					 }
				 }

				 var facultyStore = $this.getStore('coursetransaction.facultytopicassignment.FacultyDetails');
				 if(courseId > 0){
					 facultyStore.getProxy().extraParams = {
						 componentId:'',
						 periodId:'',
						 courseId:courseId
					 };
					 facultyStore.load();
				 }
				 
				 var topicStore = $this.getStore('coursetransaction.coursereading.MaterialType');
				 if(courseId > 0){
					 topicStore.getProxy().extraParams = {
						 courseId : courseId
					 };
					 topicStore.load();
				 }
			 }
		 }, 'coursesectionsearchforfta combo#componentSectionItemId': {
			 select: function(obj, record) {
				 var $this=this;
				 $this.getCoursesectionsearchforfta().down("#courseSectionId").setDisabled(false);
				 var alinfomodel = Academia.model.authentication.ALInfoModel;
				 var whetherSchool = alinfomodel.get('wheatherSchool');
				 var form=$this.getCoursesectionsearchforfta().getForm();
				 var formValues=form.getFieldValues();
				 
				 var componentId=record[0].get("id");
				 var courseId = formValues.ALL_COURSE_ID;
				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByIDStore');
				 if(courseId > 0 && componentId>0){
					 sectionStore.getProxy().extraParams = {
						 componentId:componentId,
						 whetherSchool:whetherSchool
					 };
					 sectionStore.load();
				 }
		 

		 var facultyStore = $this.getStore('coursetransaction.facultytopicassignment.FacultyDetails');
		 if(courseId > 0){
			 facultyStore.getProxy().extraParams = {
				 componentId:componentId,
				 periodId:'',
				 courseId:courseId
			 };
			 facultyStore.load();
		 }

		 var topicStore = $this.getStore('coursetransaction.coursereading.MaterialType');
		 if(courseId > 0){
			 topicStore.getProxy().extraParams = {
				 componentId:componentId,
				 courseId : courseId
			 };
			 topicStore.load();
		 }
		 
		 
			 }
			 }
        });
    },
    getTopicAssigned : function(grid, rowIndex, record){
    	
    	  var facultyId = record.data.PERSON_ID;
    	  var courseVariantId = record.data.COURSE_VARIANT_ID;
    	  
          var formWindow = this.getAssigntopicwin();
          if (!formWindow) {
              Ext.widget('assigntopicwin');
              formWindow = this.getAssigntopicwin();
          }
          formWindow.show();
          

          var store = this.getStore('coursetransaction.facultytopicassignment.AssignTopics');
          store.getProxy().extraParams = {
        	  facultyId:facultyId,
        	  courseVariantId:courseVariantId
          };
          store.load();
          
          
    },
    // this is adding dynamic tool bar for grid
    gridRenderFunction: function(grid) {
    	grid.addButtonToolbar();
    },
    loadGridAndSearchFacultyTopicAssignment:function(){
    		 var $this = this;
    		 var  facultyTopicSearchForm = this.getFacultytopicassignmentsearch();
    		 var form = facultyTopicSearchForm.getForm();
    		 var sectionType = form.findField('sectionType').getValue();
    		 
    		 if(sectionType){
    			 var RESULT_GRID = $this.getFacultytopicassignmentlistgrid_PBS();
				 $this.loadCommonGridRecord(CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_PBS_VIEWCODE,
						 CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_PBS_CONFIGCODE,RESULT_GRID);
				 
				 $this.getFacultytopicassignmentliststructure().down("#facultytopicassignmentlistgrid_PBS").setVisible(true);
				 $this.getFacultytopicassignmentliststructure().down("#facultytopicassignmentlistgrid_CBS").setVisible(false);
				 
				 Ext.defer(function() {
					 var grida =Ext.ComponentQuery.query('#facultytopicassignmentlistgrid_PBS')[0]
					 var alinfomodel = Academia.model.authentication.ALInfoModel;
					 var wheatherSchool = alinfomodel.get('wheatherSchool');
					 if(wheatherSchool) {
						 if(grida.columnManager){
							 grida.columnManager.columns[2].hide();
						 }
					 }
				 }, 500, $this);
				 
    		 }else{
    			 
    			 var RESULT_GRID = $this.getFacultytopicassignmentlistgrid_CBS();
				 $this.loadCommonGridRecord(CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_CBS_VIEWCODE,
						 CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_CBS_CONFIGCODE,RESULT_GRID);
				 $this.getFacultytopicassignmentliststructure().down("#facultytopicassignmentlistgrid_PBS").setVisible(false);
				 $this.getFacultytopicassignmentliststructure().down("#facultytopicassignmentlistgrid_CBS").setVisible(true);
    			 }
    },
    
    loadCommonGridRecord : function(respectiveLinkViewCode, respectiveLinkConfigCode,getResultGrid,model,records){
    	
    	var  facultyTopicSearchForm = this.getFacultytopicassignmentsearch();
        var jsonFormatFormData = this.createJsonFormat(facultyTopicSearchForm, respectiveLinkConfigCode,records);
        var searchResultGrid = getResultGrid;
        
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	},
	
    //createJsonFormat: function(facultyTopicSearchForm) {
	createJsonFormat: function(facultyTopicSearchForm,respectiveLinkConfigCode ,record) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        formValues = facultyTopicSearchForm.getValues();
        courseValue = formValues.COURSE_ID;
        if(isNullOrEmpty(courseValue)) {
        	courseValue = formValues.ALL_COURSE_ID;
        }
        // added for if user has ERP Role
        var accCourseIds = [];
		 Ext.Ajax.request({
				type : 'rest',
				url :SERVERURL.FIND_ALL_ACCESSIBLE_COURSES,
				params : {
					academyLocationId : this.getCurrentAcademyLocation()
				},
				method : 'GET',
				async: false,
				success : function(response) {
					var data = Ext.decode(response.responseText);
					for(var i=0; i< data.length ;i++){
						if(!isNullOrEmpty(data[i])){
							accCourseIds.push(data[i]);
						}
						
            	   }
				}
			});
		 var accessibleCourseIds =accCourseIds.join();
		 
		 if(!isNullOrEmpty(courseValue)){
			 Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.GET_PARENT_COURSE_ID,
					params : {
						courseId : courseValue
					},
					method : 'GET',
					async: false,
					success : function(response) {
						if(!isNullOrEmpty(response.responseText)){
						data = Ext.decode(response.responseText);
						courseValue = data.courseId;
						}
					}
				});
		 }

       values.configCode = respectiveLinkConfigCode;//CONSTANTS.CB.COURSE_FACULTY_TOPIC_ASSIGNMENT_LIST_CONFIGCODE;

//         formValues = facultyTopicSearchForm.getValues();
         var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', formValues.PROGRAM_ID);
	     this.pushJsonObjectInArray(PROGRAM_ID,searchcriteria);
	
	     var BATCH_ID = this.getJsonObject('BATCH_ID',formValues.PROGRAM_BATCH_ID);
	     this.pushJsonObjectInArray(BATCH_ID,searchcriteria);
	
	     var PROGRAM_BATCH_PERIOD_CONFIG_ID = this.getJsonObject('PROGRAM_BATCH_PERIOD_CONFIG_ID',formValues.PROGRAM_BATCH_PERIOD_CONFIG_ID);
	     this.pushJsonObjectInArray(PROGRAM_BATCH_PERIOD_CONFIG_ID, searchcriteria);
	
	     var SECTION_ID = this.getJsonObject('SECTION_ID', formValues.ALL_SECTION_ID);
	     this.pushJsonObjectInArray(SECTION_ID, searchcriteria);
	     
	     var COMPONENT_ID = this.getJsonObject('COMPONENT_ID', formValues.COMPONENT_ID);
	     this.pushJsonObjectInArray(COMPONENT_ID, searchcriteria);
	     
	     var ALL_COURSE_ID = this.getJsonObject('COURSE_ID',courseValue);				//('COURSE_ID',formValues.ALL_COURSE_ID);
	     this.pushJsonObjectInArray(ALL_COURSE_ID, searchcriteria);
	     
	     var PARENT_COURSE_ID = this.getJsonObject('PARENT_COURSE_ID',courseValue);				
	     this.pushJsonObjectInArray(PARENT_COURSE_ID, searchcriteria);
	     
	     var ALL_SECTION_ID = this.getJsonObject('SECTION_ID', formValues.ALL_COURSE_COMPONENT_ID);
	     this.pushJsonObjectInArray(ALL_SECTION_ID, searchcriteria);
	     
	     var ALL_COMPONENT_ID = this.getJsonObject('COMPONENT_ID', formValues.ALL_COURSE_SECTION_ID);
	     this.pushJsonObjectInArray(ALL_COMPONENT_ID, searchcriteria);
	
	     var TOPICS;
	     if((formValues.TOPIC_ID !="") && (formValues.TOPIC_ID !=null)){
	    	 TOPICS = formValues.TOPIC_ID; 
	     }else{
	    	 TOPICS = formValues.COURSE_TOPIC_ID;
	     }
	     
	     var TOPIC_ID = this.getJsonObject('TOPIC_ID', TOPICS);
	     this.pushJsonObjectInArray(TOPIC_ID, searchcriteria);
	     
	     var ACCESSIBLE_PARENT_COURSE_ID = this.getJsonObject('ACCESSIBLE_PARENT_COURSE_ID', accessibleCourseIds);
	     this.pushJsonObjectInArray(ACCESSIBLE_PARENT_COURSE_ID,searchcriteria);
	     var ACCESSIBLE_COURSE_ID = this.getJsonObject('ACCESSIBLE_COURSE_ID', accessibleCourseIds);
	     this.pushJsonObjectInArray(ACCESSIBLE_COURSE_ID,searchcriteria);
	     
	     var PERSON_ID;
	     
	     var sectionGridType; 
	     
	     var sectionType = formValues.sectionType;
	     if(sectionType){
	    	 sectionGridType = 'ProgramBatchSection';
	    	 PERSON_ID = this.getJsonObject('PERSON_ID', formValues.FACULTY_ID);
	     }else{
	    	 sectionGridType = 'CourseSection';
	    	 PERSON_ID = this.getJsonObject('PERSON_ID', formValues.COURSE_FACULTY_ID);
	     }
	     
	     this.pushJsonObjectInArray(PERSON_ID, searchcriteria);
	     
	        
 	     var ASSIGN_SECTION_TYPE = this.getJsonObject('ASSIGN_SECTION_TYPE', sectionGridType);
 	     this.pushJsonObjectInArray(ASSIGN_SECTION_TYPE,searchcriteria);
	     
        values.searchCriterias = searchcriteria;
        return values;
    },
    //*********for program batch section
    createJsonFormatForProgramBatchSection: function(facultyTopicSearchForm,respectiveLinkConfigCode ,record) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

       values.configCode = respectiveLinkConfigCode;
       formValues = facultyTopicSearchForm.getValues();

      
	     
	     var PERSON_ID = this.getJsonObject('PERSON_ID', formValues.FACULTY_ID);
	     this.pushJsonObjectInArray(PERSON_ID, searchcriteria);
	     
	   
	        
 	     var ASSIGN_SECTION_TYPE = this.getJsonObject('ASSIGN_SECTION_TYPE', "ProgramBatchSection");
 	     this.pushJsonObjectInArray(ASSIGN_SECTION_TYPE,searchcriteria);
	     
        values.searchCriterias = searchcriteria;
        return values;
    },
    //*****************************************************************
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && value != null && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }

    },
    openFTAform : function(){
    	 
    	  var $this = this;
       
          var CONTENTPANEL = $this.getContentpanel();
          var STRUCTURE = Ext.widget('facultytopicassignmentstructure');
          var TABNAME = getCourseTxCommonTranslation('FACULTY_TOPIC_ASSIGNMENT_DETAIL');

    	openTab(CONTENTPANEL, TABNAME, STRUCTURE,CONSTANTS.MENU_COLOR_THREE);
    },
  /*  gridRenderFunction: function(grid) {
        grid.addDocked({
            xtype: 'toolbar',
            dock: 'top',
            items: [{
                xtype: 'button',
                itemId: 'btnAdd',
                tooltip: getCommonTranslation('ADD'),
                glyph: ICONGLYPH.ADDGLYPH
            }, {
                xtype: 'button',
                itemId: 'btnEdit',
                tooltip: getCommonTranslation('EDIT'),
                glyph: ICONGLYPH.EDITGLYPH
            }, {
                xtype: 'button',
                itemId: 'btnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'view-icon'
            }, {
                xtype: 'button',
                itemId: 'btnDelete',
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                glyph: ICONGLYPH.DELETEGLYPH
            }]
        });
    }*/
    //
    exportUserList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
        var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData;
        if(searchResultGrid.itemId=='facultytopicassignmentlistgrid_PBS'){
        	jsonFormatFormData=this.createJsonFormatForProgramBatchSection(quickSearchForm,configCode);
        }else{
        	jsonFormatFormData=this.createJsonFormat(quickSearchForm,configCode);
        }
          
        var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation("FACULTY_TOPIC_ASSIGNMENT_LIST");
if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
               }
searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

},
createSearchCriteriaString: function(searchForm) {
	 var me=this;
    var formValues = new Array();
    formValues = searchForm.getValues();        
    var searchCriteriaString="";
    for (var key in formValues) {
    	var value = formValues[key];            
        if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
            var keyValueJsonObject = me.getJsonObject( key , value);
            console.log('keyValueJsonObject',keyValueJsonObject);
searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
        }
    }
    searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    return searchCriteriaString;
}
});