/*
 *  @author Amit Gupta
 * 
 */
Ext.define('Academia.controller.coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentController', {
	extend : 'Academia.controller.base.BaseController',
	models : [ 'coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentModel','coursetransaction.manageperiodenrollment.ManageStudentEnrollmentModel'],
	stores : [ 'common.ProgramForRegistrationProcessStore', 'enquiry.studentDetail.CurrentAndFutureBatchForRegistrationStore', 'attendance.SectionsForRegistrationProcess',
			'course.readingmaterial.ProgramPeriodForRegistrationProcessStore',
			'coursetransaction.manageperiodenrollment.ManagePeriodEnrollGridStore',
			'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
			'coursetransaction.manageperiodenrollment.PeriodEnrollStatusStore', 'coursetransaction.manageperiodenrollment.OptionalPeriodStore',
			'coursetransaction.manageperiodenrollment.StudentPortalProgramPeriodEnrollGridStore',
			'coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridStore',
			'coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridTempStore',
			'feeandpayment.FeePaymentTerm','feeandpayment.FeePaymentGroup','feeandpayment.AllPaymentGroup',
			'feeandpayment.PaymentGrpTermStore','feeandpayment.FeePaymentTermBypbscIdandPeriodId',
			'coursetransaction.sectionmanagement.AcademyLocationsByUserStore','coursetransaction.manageperiodenrollment.PeriodEnrollStatusStoreForImport',
			'enquiry.studentDetail.CurrentAndFutureBatchForRegistrationStore','common.BatchesAssociatedWithPeriodByAcadAndProgram',
			'lecturercostingdefinition.ImportPeriodEnrollmentPeriodStore','lecturercostingdefinition.ImportPeriodEnrollmentBatchStore',
			'lecturercostingdefinition.ImportPeriodEnrollmentSectionStore', 'importutility.ModuleName',
			'importutility.importUtilityCourseLevelAttendanceList'],
	views : [ 'coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentStructure',
			'coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentSearch',
			'coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentList',
			'coursetransaction.manageperiodenrollment.EnrollToPeriodEnrollmentWin',
			'coursetransaction.manageperiodenrollment.ManageStudentEnrollmentSearch',
			'coursetransaction.manageperiodenrollment.ManageStudentEnrollmentStructure',
			'coursetransaction.manageperiodenrollment.ManageStudentEnrollmentList',
			'coursetransaction.manageperiodenrollment.OptionalPeriodEnrollmentStructure',
			'coursetransaction.manageperiodenrollment.ChangePaymentTermWindow',
			'coursetransaction.manageperiodenrollment.ChangePaymentTermWindowStudent',
			'coursetransaction.manageperiodenrollment.RejectRequestRecievedPopupWindow',
			'coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentLoaderStructure',
			'coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentMainStructure',
			'coursetransaction.manageperiodenrollment.downloadPeriodEnrollmentform',
			'coursetransaction.manageperiodenrollment.uploadPeriodEnrollmentform',
			'coursetransaction.manageperiodenrollment.ImportUtilityPeriodEnrollment',
			'UploadOptionRadioGroup'
			],
	config : {
		MANAGE_PERIOD_ENROLLMENT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PERIOD_ENROLLMENT_PRIVILEGES'),
		STUDENT_PERIOD_ENROLLMENT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PERIOD_ENROLLMENT_PRIVILEGES')
	},

	refs : [ {
		ref : 'contentPanel',
		selector : 'contentPanel'
	}, {
		ref : 'manageperiodenrollmentstructure',
		selector : 'manageperiodenrollmentstructure'
	}, {
		ref : 'manageperiodenrollmentlist',
		selector : 'manageperiodenrollmentlist'
	}, {
		ref : 'enrolltoperiodenrollmentwin',
		selector : 'enrolltoperiodenrollmentwin'
	}, {
		ref : 'enrolltoPeriodEnrollmentWin',
		selector : 'enrolltoperiodenrollmentwin form'
	}, {
		ref : 'managestudentenrollmentstructure',
		selector : 'managestudentenrollmentstructure'
	}, {
		ref : 'managestudentenrollmentsearch',
		selector : 'managestudentenrollmentsearch'
	}, {
		ref : 'managestudentenrollmentlist',
		selector : 'managestudentenrollmentlist'
	}, {
		ref : 'manageperiodenrollmentsearch',
		selector : 'manageperiodenrollmentsearch'
	},{
		ref: 'optionalperiodenrollmentstructure',
		selector : 'optionalperiodenrollmentstructure'
	},{
		ref: 'changepaymenttermwindow',
		selector : 'changepaymenttermwindow'
	},{
		ref: 'changepaymenttermwindowstudent',
		selector : 'changepaymenttermwindowstudent'
	},{
	    ref : 'managePeriodEnrollmentPopupWinItemId',
		selector:'rejectrequestrecievedpopupwindow[itemId=managePeriodEnrollmentPopupWinItemId]'
	},{
		ref : 'manageperiodenrollmentloaderstructure',
		selector : 'manageperiodenrollmentloaderstructure'
	},
	{
		ref : 'manageperiodenrollmentmainstructure',
		selector : 'manageperiodenrollmentmainstructure'
	},
	{
		ref : 'downloadPeriodEnrollmentform',
		selector : 'downloadPeriodEnrollmentform'
	},{
		ref : 'uploadPeriodEnrollmentform',
		selector : 'uploadPeriodEnrollmentform'
	},{
		ref : 'importutilityperiodenrollment',
		selector : 'importutilityperiodenrollment'
	},{
		ref: 'uploadoptionradiogroup',
		selector: 'uploadoptionradiogroup[itemId=uploadPeriodEnrollmentformItemId]'
	}],

	init : function() {
		this.control({
			'manageperiodenrollmentmainstructure' : {
				beforerender: function(structure){
					 Ext.suspendLayouts();
					 this.disableBulkImportLecturerCostingDefinition(structure, this.getMANAGE_PERIOD_ENROLLMENT_PERMISSIONS());
	   				 Ext.resumeLayouts();
				}
			},
			
			'manageperiodenrollmentstructure' : {
				beforerender : function() {
					this.getManageperiodenrollmentlist().getStore().removeAll();
				},
				afterrender : function(structure) {
					var grid = structure.down('manageperiodenrollmentlist');
					this.getGridHeaderFreeze(grid, structure, true);
					grid.down('#optionalPeriodEnrollment').setVisible(false);
				}
			},
			
			'downloadperiodenrollmentform' :{
				afterrender : function(form) {
					var $this = this;
					var academyLocationField = form.down('#academyLocationId');
					var academicTermField = form.down('#academicTermId');
					var academyLocationId=this.getCurrentAcademyLocation();
					var academyLocationStore = academyLocationField.getStore();
					var academicTermStore = academicTermField.getStore();
					academyLocationStore.load();
					academyLocationField.setValue(academyLocationId);
					academicTermStore.getProxy().extraParams.academyLocationId=academyLocationId;
	   				academicTermStore.load();
				}
			},
			
			'manageperiodenrollmentmainstructure manageperiodenrollmentloaderstructure uploadperiodenrollmentform button[itemId=resetBtn]': {
				click: function(obj) {
					var $this = this;
					var form = obj.up('form');
					form.down('#uploadFileField').reset();
					var uploadoptionradiogroupform = $this.getUploadoptionradiogroup();
					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						isUploadAll: false
					});
					form.isValid();
				},
			},
			
			'manageperiodenrollmentmainstructure manageperiodenrollmentloaderstructure uploadperiodenrollmentform combo[itemId=moduleName]': {
				afterrender: function(obj) {
					var store = obj.getStore();
					store.load({
						callback: function(record, operation, success) {
							if (success) {
								for (var i in record) {
									if (record[i].data.value == 'Bulk Period Enrollment') {
										obj.setReadOnly(true);
										obj.setValue(record[i].get('id'));
									}
								}
							}
						}
					});
				}
			},
			
			
			'manageperiodenrollmentmainstructure  manageperiodenrollmentloaderstructure importutilityperiodenrollment[itemId=importutilityperiodenrollment]': {
				afterrender: this.loadImportPeriodEnrollmentGrid,
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					if (e.target.tagName == 'A') {
						var fileType = null;
						if (cellIndex == 1) {
							fileType = 'successFile';
						} else if (cellIndex == 6) {
							fileType = 'errorFile';
						} else if (cellIndex == 7) {
							fileType = 'logFile';
						}
						var documentId = record.get("id");
						if (!isNullOrEmpty(documentId)) {
							this.getStudentPeriodEnrollmentDownloadFile(documentId, fileType);
						}
					}
				}
			},
			
			'manageperiodenrollmentmainstructure manageperiodenrollmentloaderstructure uploadperiodenrollmentform button[itemId=uploadId]': {
				click: this.getStudentPeriodEnrollmentUploadtemplate
			},
			
			'manageperiodenrollmentmainstructure manageperiodenrollmentloaderstructure importutilityperiodenrollment[itemId=importutilityperiodenrollment] button[itemId=btnForce]': {
				click: function(obj) {
					var grid = this.getImportutilityperiodenrollment();
					if (grid.getSelectionModel().getCount() > 0) {
						if (grid.getSelectionModel().getCount() > 1) {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						} else {
							var this$ = this;
							var id = grid.getSelectionModel().selectionStart.data.id;
							var urlAppend = "?jobName=" + id;
							var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
							Ext.Ajax.request({
								url: submitURL,
								method: 'GET',
								success: function(response) {
									if (response.responseText === "JOB_STATUS_NOT_PENDING") {
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
									} else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
										//console.log("Manual trigger hit");
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
									} else if (response.responseText === "SUCCESS") {
										//console.log("Manual trigger hit");
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
									}
								}
							});
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			
			
			'manageperiodenrollmentmainstructure manageperiodenrollmentloaderstructure uploadperiodenrollmentform uploadoptionradiogroup[itemId=uploadPeriodEnrollmentformItemId] radiogroup[itemId=uploadgroupItemId]': {
				change: function(radioGroup, newValue, oldValue, eOpts) {
					var grid = this.getImportutilityperiodenrollment();
					var form = this.getUploadoptionradiogroup();
					var isUploadAll = newValue.isUploadAll;
					this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_PERIOD_ENROLLMENT');
				}
			},
			
			'optionalperiodenrollmentstructure grid' : {
				cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
					var $this=this;
					var grid = view.ownerCt;
					var columnId=grid.columnManager.columns[cellIndex].columnId;
					var recData=record.data;
					var store=record.store;
					var tempStore=this.getStore('coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridTempStore');
					if(e.target.type=='checkbox'){
						if(cellIndex==0){
							if(!e.target.checked){
								tempStore.remove(record,true);
							}else if(e.target.checked){
								tempStore.loadRawData(record,true);
							}
						}
					}
					if(tempStore.data.items.length){
						grid.down('#optionalPeriodGridEnrollBtn').setDisabled(false);
					}
					else{
						grid.down('#optionalPeriodGridEnrollBtn').setDisabled(true);
					}
				}
			},
			'optionalperiodenrollmentstructure button[itemId=optionalPeriodGridEnrollBtn]':{
				click: function(btn){
					var $this = this;
					var optionalperiodenrollmentstructure = btn.up('optionalperiodenrollmentstructure');
					var form = optionalperiodenrollmentstructure.down('form');
					var formValues = form.getValues();
					
				//	if(formValues.optionalPeriodId!=formValues.currentPeriodId){
						var tempStore=$this.getStore('coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridTempStore');
						
						var optionalFormData = new Academia.model.AbstractDataModel;
						optionalFormData.set("requestDate", new Date());
						optionalFormData.set("optionPeriodId", formValues.optionalPeriodId);
						var students = [];
						var records = tempStore.data.items;
						for (var i = 0; i < records.length; i++) {
							if(!isNullOrEmpty(records[i].data) && isNullOrEmpty(records[i].data.optionalPeriodEnrollmentId)){
								var rec = records[i].data;
								students.push({
									"admissionId" : rec.admissionId,
									"programBatchStudentId" : rec.programBatchStudentId
								});
							}else{
								students=[];
								showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('ENROLLED_RECODS_ONLY'));
								break;
							}
						}
						if(!isNullOrEmpty(students) && students.length > 0){
							optionalFormData.set("students", students);
							$this.postDataToEnroll(optionalFormData, false);
						}
					/*}
					else{
						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('CANNOT_ENROLL_SAME_PERIOD'));
					}*/
				}
			},
			'optionalperiodenrollmentstructure button[itemId=optionalPeriodGridResetBtn]':{
				click: function(btn){
					var store = btn.up('grid').getStore();
					btn.up('grid').down('#optionalEnrollmentGridSearch').setValue('');
					store.clearFilter();
				}
			},
			'optionalperiodenrollmentstructure trigger[itemId=optionalEnrollmentGridSearch]':{
				keyup: function( me, e, eOpts ){
					var store = me.up('grid').getStore();
					store.clearFilter();
					if(!isNullOrEmpty(me.getValue())){
						// filtering grid locally
						store.filter(new Ext.util.Filter({
							filterFn: function (object) {
								var match = false;
								var newObjData = {
										admissionCode: object.data.admissionCode,
										studentId: object.data.studentId,
										studentName: object.data.studentName
								};
								Ext.Object.each(newObjData, function (property, value) {
									match = match || (String(value).toUpperCase().indexOf(me.getValue().toUpperCase()) != -1);
								});
								return match;
							}
						}));
					}
				}
			},
			'manageperiodenrollmentlist button[itemId=optionalPeriodEnrollment]' : {
				click : function() {
					var me = this;
					var grid = me.getManageperiodenrollmentlist();
					var form = me.getManageperiodenrollmentsearch();
					
					var programId = form.down("#programId").getValue();
					var batchId = form.down("#batchId").getValue();
					if(!isNullOrEmpty(programId) && !isNullOrEmpty(batchId)){
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						
						//-- open optional period enrollment tab here
						var contentPanel = this.getContentPanel();
						var tabName = getCommonTranslation('OPTIONAL_PERIOD_ENROLLMENT');
						var structure = Ext.widget('optionalperiodenrollmentstructure');
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						openTab(contentPanel, tabName, structure);
						
						setTimeout(function(){
							Ext.Ajax.request({
								url : SERVERURL.FIND_BY_PROGRAM_BATCH_ID+'?programId='+programId+'&batchId='+batchId,
								headers: {
									'Content-Type': 'application/json'
								},
								method : 'GET',
								success : function(response) {
									Ext.getBody().unmask();
									var response = Ext.decode(response.responseText);
									var optionalFormData = {
											programName: form.down("#programId").getDisplayValue(),
											bathName: form.down("#batchId").getDisplayValue(),
											currentPeriod: '-',
											currentPeriodId: '',
											optionalPeriod: form.down("#periodId").getDisplayValue(),
											optionalPeriodId: form.down("#periodId").getValue()
									};

									if(response.rows.length){
										optionalFormData.currentPeriod = response.rows[0].periodName;
										optionalFormData.currentPeriodId = response.rows[0].periodId;
									}

									var optionalPeriodForm = structure.down('form');
									var optionalPeriodGrid = structure.down('grid');
									optionalPeriodForm.getForm().setValues(optionalFormData);
									optionalPeriodGridStore = optionalPeriodGrid.getStore();

									optionalPeriodGridStore.removeAll();
									optionalPeriodGridStore.loadData(response.rows);
									
									var tempStore=me.getStore('coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridTempStore');
									if(tempStore.data.length >0 ){
										tempStore.removeAll();
									}
								}
							});
						},1000);
					}
				}
			},
			'manageperiodenrollmentlist button[itemId=enrollTo]' : {
				click : function() {
					var grid = this.getManageperiodenrollmentlist();
					if (grid.getSelectionModel().getCount() > 0) {
						this.enrollProgramBatchStudent(grid);
					} else {
						showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'manageperiodenrollmentlist button[itemId=studentEnrollment]' : {
				click : this.openStudentPeriodEnrollTab
			},
			'manageperiodenrollmentlist button[itemId=changePaymentTerm]' : {
				click : this.editPaymentTermDetailsForm
			},
			'changepaymenttermwindow button[itemId=SubmitBtn]' : {
				click : this.savePaymentTerm
			},
			'changepaymenttermwindow button[itemId=CancelBtn]' : {
				click: function(obj) {
					this.getChangepaymenttermwindow().close();
    			}
			},
			'changepaymenttermwindowstudent button[itemId=SubmitBtn]' : {
				click : this.savePaymentTermStudent
			},
			'changepaymenttermwindowstudent button[itemId=CancelBtn]' : {
				click: function(obj) {
					this.getChangepaymenttermwindowstudent().close();
    			}
			},
			'managestudentenrollmentlist button[itemId=periodDeEnroll]' : {
				click : function() {
					var grid = this.getManagestudentenrollmentlist();
					if (grid.getSelectionModel().getCount() > 0) {
						this.deEnrollPeriod(grid);
					} else {
						showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'manageperiodenrollmentlist button[itemId=approve]' : {
				click : function() {
					var grid = this.getManageperiodenrollmentlist();
					var searchForm = this.getManageperiodenrollmentsearch();
					if(searchForm.down("#periodId").valueModels.length){
						var sequence = searchForm.down("#periodId").valueModels[0].data.sequence;
					}
					else{
						var sequence = 0;
					}
					var isOptionalPeriod = !isNullOrEmpty(sequence) && sequence == 1 ? true : false;
					if (grid.getSelectionModel().getCount() > 0) {
						if(isOptionalPeriod){
							this.approveOptionalPeriodEnroll(grid);
						} else{
							this.approvePeriodEnroll(grid);
						}
					} else {
						showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			// resend button
			'manageperiodenrollmentlist button[itemId=resendConfirmationLetter]' : {
				click : function() {
					var grid = this.getManageperiodenrollmentlist();
					var selectedRecord = grid.getSelectionModel().selected.items[0];
					
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_SEND_CONFIRMATION_LETTER_TO_ENROLL_STUDENTS,
						params : {
							admissionId:selectedRecord.data.admissionId,
						},
						method : 'GET',
						success : function(response) {
							grid.getStore().load();
							showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'),getCommonTranslation('SUCCESS'));
						}
					});
					
				}
			},
			'manageperiodenrollmentlist button[itemId=reject]' : {
				click:function(){
           		 var formWindow = this.getManagePeriodEnrollmentPopupWinItemId();
           		 if (!formWindow) {
           			 formWindow = Ext.widget('rejectrequestrecievedpopupwindow',{
			        			itemId:'managePeriodEnrollmentPopupWinItemId'
           			 });
					   }
           		 formWindow.show();
           	 }
			},
			'rejectrequestrecievedpopupwindow[itemId=managePeriodEnrollmentPopupWinItemId] button[itemId=submitBtn]':{
	   			 click:function(){
	   				var grid = this.getManageperiodenrollmentlist();
					var searchForm = this.getManageperiodenrollmentsearch();
					if(searchForm.down("#periodId").valueModels.length){
						var sequence = searchForm.down("#periodId").valueModels[0].data.sequence;
					}
					else{
						var sequence = 0;
					}
					var isOptionalPeriod = !isNullOrEmpty(sequence) && sequence == 1 ? true : false;
					if (grid.getSelectionModel().getCount() > 0) {
						if(isOptionalPeriod){
							//this.approveOptionalPeriodEnroll(grid);
						} else{
							this.rejectProgramBatchStudents(grid);
						}
					} else {
						showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
	   			 }
			},
			'manageperiodenrollmentsearch' : {
				afterrender : this.resetManagePeriodEnrollmentSearch
			},
			'manageperiodenrollmentsearch customcombobox[itemId=academyLocationPeriodEnrollment]':{
				select: this.onAcademyLocationFieldChange
			},
			'manageperiodenrollmentsearch customcombobox#periodWiseAcademicTermId' : {
				change: this.onAcademyTermFieldChange
			},
			'manageperiodenrollmentsearch customcombobox#statusId' : {
				change: this.onPeriodEnrollmentStatusFieldChange
			},
			'manageperiodenrollmentsearch customcombobox#programId' : {
				change: this.onProgramCodeNameFieldChange
			},
			'manageperiodenrollmentsearch customcombobox#batchId' : {
				change: this.onBatchFieldChange
			},
			'manageperiodenrollmentsearch customcombobox#periodId' : {
				change: this.onPeriodFieldChange
			},
			'manageperiodenrollmentsearch button[itemId=searchBtn]' : {
				click : this.loadPeriodEnrollDataGrid
			},
			'downloadperiodenrollmentform customcombobox[itemId=academyLocationId]':{
				select: this.onImportAcademyLocationFieldChange
			},
			'downloadperiodenrollmentform customcombobox#academicTermId' : {
				change: this.onImportAcademyTermFieldChange
			},
			'downloadperiodenrollmentform multiselectcombofield[itemId=programId]' : {
				change: this.onImportProgramCodeNameFieldChange
			},
			'downloadperiodenrollmentform multiselectcombofield[itemId=batchId]' : {
				change: this.onImportBatchCodeNameFieldChange
			},
			
			'downloadperiodenrollmentform multiselectcombofield[itemId=periodId]' : {
				change: this.onImportPeriodCodeNameFieldChange
			},
			
			'downloadperiodenrollmentform button[itemId=resetBtn]' : {
				click: this.resetFormFields
			},
			
			
			'manageperiodenrollmentsearch customcombobox#studentNameSearch' : {
				select: this.onstudentNameSearchFieldChange,
				afterrender: function(field){
					var manageperiodenrollmentsearch = field.up('manageperiodenrollmentsearch');
					field.getStore().on('beforeload', function(){
						var academyLocationField = manageperiodenrollmentsearch.down('#academyLocationPeriodEnrollment');
						var academicTermField = manageperiodenrollmentsearch.down('#periodWiseAcademicTermId');
						field.getStore().getProxy().extraParams.academyLocationId = academyLocationField.getValue();
						field.getStore().getProxy().extraParams.academicTermId = academicTermField.getValue();;
					});
				}
			},
			
			'manageperiodenrollmentsearch button[itemId=resetBtn]' : {
				click : function(obj) {
					var $this = this;

					$this.resetManagePeriodEnrollmentSearch(obj);
									
					var enrolledStudentGrid  = $this.getManageperiodenrollmentlist();
					enrolledStudentGrid.getStore().removeAll(); 
					enrolledStudentGrid.getStore().totalCount=0
					enrolledStudentGrid.getStore().fireEvent('load', enrolledStudentGrid.getStore(), [], {});
					enrolledStudentGrid.getStore().commitChanges();
					enrolledStudentGrid.getView().refresh();
					enrolledStudentGrid.down('#enrollTo').setDisabled(true);
					enrolledStudentGrid.down('#showEnrollmentMessageId').setVisible(false);
					$this.disableOptPeriodEnrollmentListButtonsPivileges(enrolledStudentGrid,this.getMANAGE_PERIOD_ENROLLMENT_PERMISSIONS());
					enrolledStudentGrid.down('#approve').setDisabled(true);
					enrolledStudentGrid.down('#resendConfirmationLetter').setDisabled(true);
					enrolledStudentGrid.down('#optionalPeriodEnrollment').setVisible(false);
					
				}
			},
			'managestudentenrollmentsearch' : {
				beforerender : function() {
					this.getManagestudentenrollmentlist().getStore().removeAll();
				}
			},
			'managestudentenrollmentlist button[itemId=changePaymentTerm]' : {
				click : this.editPaymentTermDetailsFormForStudentEnrollment
			},
			'managestudentenrollmentsearch button[itemId=searchBtn]' : {
				click : function(obj) {
					var grid = this.getManagestudentenrollmentlist();
					var studentNameSearch = obj.up('form').down('#studentNameSearch');
					var studentNameSearchStore = studentNameSearch.getStore();
					var admissionId = studentNameSearchStore.getAt(studentNameSearchStore.findExact(studentNameSearch.displayField,studentNameSearch.getDisplayValue())).get('sequence');
					
					var student = this.getManagestudentenrollmentsearch().down("#studentNameSearch");
					var showStudentEnrollmentMessageId=grid.down('#showStudentEnrollmentMessageId');
					showStudentEnrollmentMessageId.hide();
					var store = grid.getStore();
					store.getProxy().extraParams = {
						studentId : student.value,
						portalId : this.getCurrentLoggedPortalId(),
						admissionId: admissionId

						
					}
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.FIND_PAYMENT_TERM_BY_ADMISSION_ID_AND_PERIOD_ID,
						params : {
							admissionId:admissionId,
							periodId:null,
							batchIds: null
						},
						method : 'GET',
						success : function(response) {
							var data = Ext.decode(response.responseText);
							//paymentTermComboStore.removeAll();
							allPaymentTermsDataForStudentPeriodEnroll = data;
							//paymentTermComboStore.loadData(data);
						}
					});
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.FIND_PAYMENT_GROUP_BY_ADMISSION_ID_AND_PERIOD_ID,
						params : {
							admissionId:admissionId,
							periodId:null,
							batchIds: null
						},
						method : 'GET',
						success : function(response) {
							var data = Ext.decode(response.responseText);
							//paymentTermComboStore.removeAll();
							allPaymentGroupDataForStudentPeriodEnroll = data;
							//paymentTermComboStore.loadData(data);
						}
					});
					Ext.defer(function(){
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									for(i in records){
										if(records[i].data.status=="Pending" && records[i].data.whetherOptional 
												&& records[i].data.enrollmentLastDate >= new Date()){
											grid.getSelectionModel().select(records[i],true);
										}
										if(records[i].data.status!="Pending" || !records[i].data.whetherOptional){
											grid.getSelectionModel().setDisabled=true;
										}
									}
								}
							}
						});
					},200);
					
					
				}
			},
			'managestudentenrollmentsearch button[itemId=resetBtn]' : {
				click : function(obj) {
					var form = this.getManagestudentenrollmentsearch().getForm();
					form.reset();
				}
			},
			
			'downloadperiodenrollmentform button[itemId=downoladBtnId]': {
		    click: function(obj) {
			var $this = this;
			var filterForm = obj.up('form');
			var form = filterForm.getForm();
			var values = form.getValues();
			var programIds = [];
			var programIdes;
			var academyLocationId = values.academyLocation;
			
			var record = values.programId;
			if (!isNullOrEmpty(record)) {
				if (record.length > 0 && !isNullOrEmpty(record[0])) {
					for (var i in record) {
						if (Ext.isObject(record[0])) {
							programIds.push(record[i].get("id"));
						} else {
							programIds.push(record[i]);
						}
					}
					programIdes = programIds.join();
				}
				else {
					programIdes = record;
				}
			}
			
			var batchIds = [];
			var batchIdes;
			var record = values.batchId;
			if (!isNullOrEmpty(record)) {
				if (record.length > 0 && !isNullOrEmpty(record[0])) {
					for (var i in record) {
						if (Ext.isObject(record[0])) {
							batchIds.push(record[i].get("id"));
						} else {
							batchIds.push(record[i]);
						}
					}
					batchIdes = batchIds.join();
				}
				else {
					batchIdes = record;
				}
			}
			
			
			var periodIds = [];
			var periodIdes;
			
			var record = values.periodId;
			if (!isNullOrEmpty(record)) {
				if (record.length > 0 && !isNullOrEmpty(record[0])) {
					for (var i in record) {
						if (Ext.isObject(record[0])) {
							periodIds.push(record[i].get("id"));
						} else {
							periodIds.push(record[i]);
						}
					}
					periodIdes = periodIds.join();
				}
				else {
					periodIdes = record;
				}
			}
			
			var sectionIds = [];
			var sectionIdes;
			
				var record = values.sectionId;
			if (!isNullOrEmpty(record)) {
				if (record.length > 0 && !isNullOrEmpty(record[0])) {
					for (var i in record) {
						if (Ext.isObject(record[0])) {
							sectionIds.push(record[i].get("id"));
						} else {
							sectionIds.push(record[i]);
						}
					}
					sectionIdes = sectionIds.join();
				}
				else {
					sectionIdes = record;
				}
			}
			
			var enrollmentStatus = [];
			var enrollmentStatusList;
			
			var record = values.statusId;
			if (!isNullOrEmpty(record)) {
				if (record.length > 0 && !isNullOrEmpty(record[0])) {
					for (var i in record) {
						if (Ext.isObject(record[0])) {
							enrollmentStatus.push(record[i].get("id"));
						} else {
							enrollmentStatus.push(record[i]);
						}
					}
					enrollmentStatusList = enrollmentStatus.join();
				}
				else {
					enrollmentStatusList = record;
				}
			}

			var csvForm = Ext.create('Ext.form.Panel');
			csvForm.getForm().submit({
				target: '_blank',
				method: 'POST',
				params: {
					access_token: Ext.Ajax.defaultHeaders.access_token,
					academyLocationId: academyLocationId,
					academicTermId: values.academicTerm,
					programIds: programIdes,
					batchIds: batchIdes,
					periodIds: periodIdes,
					sectionIds : sectionIdes,
					periodEnrollmentStatus: enrollmentStatusList
				},
				headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
				url: SERVERURL.IMPORT_UTILITY_DOWNLOAD_STUDENT_PERIOD_ENROLLMENT,
				standardSubmit: true
			});
		}
	},
			'enrolltoperiodenrollmentwin button[itemId=CancelBtn]' : {
				click : function() {
					this.getEnrolltoperiodenrollmentwin().close();
				}
			},
			'enrolltoperiodenrollmentwin button[itemId=SubmitBtn]' : {
				click : function() {
					this.enrollOptionalPeriod();
				}
			},
			'managestudentenrollmentlist button[itemId=save]' : {
				click : function() {
					var grid = this.getManagestudentenrollmentlist();
					var records = grid.getSelectionModel().getSelection();
					if (records.length > 0) {
						if (records.length == 1){
 						   //if(records[0].data.whetherOptional) {
							var todayDate = Ext.Date.format(new Date(), 'Y-m-d');
							var enrollmentLastDateflag = false;
							if(records[0].data.registrationProcessReq == true){
								enrollmentLastDateflag = true;
							} else if(records[0].data.enrollmentLastDate >= todayDate){
								enrollmentLastDateflag = true;
							}
							   if(enrollmentLastDateflag){
								   if(records[0].data.status=="Pending"){
									   this.enrollProgramBatchStudentWise(grid);
								   }else if(records[0].data.status=="Request Received"){
									   showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ALREADY_REQUEST_RECEIVED'));
								   }else{
									   showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ALREADY_ENROLLED_OR_PASSED'));
								   }
							   }else{
								   showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ENROLLMENT_DATE_PASSED'));
							   }
						   /*}else{
							   showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('MANDATORY_PERIOD'));
						   }*/
					   } else {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'manageperiodenrollmentlist' : {
				render : function(grid) {
					this.doAccessControlValidation(grid,this.getMANAGE_PERIOD_ENROLLMENT_PERMISSIONS());
					this.disableOptPeriodEnrollmentListButtonsPivileges(grid,this.getMANAGE_PERIOD_ENROLLMENT_PERMISSIONS());
				},
				afterrender: function(grid) {
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getMANAGE_PERIOD_ENROLLMENT_PERMISSIONS());
					}, 1500);
				},
				selectionchange: function(column, selected) {
					var $this=this;
					var grid = this.getManageperiodenrollmentlist();
					var changePaymentTermBtn = grid.down('#changePaymentTerm');
					if(selected.length==1){
						if(!isNullOrEmpty(selected[0].data.paymentTerm)){
							changePaymentTermBtn.setDisabled(false);
						}
						else {
							changePaymentTermBtn.setDisabled(true);
						}
					}
					else{
						changePaymentTermBtn.setDisabled(true);
					}
					if(selected.length>0){
						var form = $this.getManageperiodenrollmentsearch();
						var periodId=grid.down('#periodId').getValue();
						var flag=false;
						var isEnroll = false;
						var requestRecieved = true;
						for(var i in selected){
							if(selected[i].data.promotionEnrollmentStatus=="PENDING"){
								flag=true;
								requestRecieved=false;
								break;
							}
						}
						for(var i in selected){
							if(selected[i].data.promotionEnrollmentStatus=="ENROLLED"){
								isEnroll=true;
								//flag = true;
								//requestRecieved=false;
								break;
							}
						}
						for(var i in selected){
							if(selected[i].data.promotionEnrollmentStatus=="REQUEST_RECEIVED"){
								flag=true;
								requestRecieved=false;
								break;
							}
						}
						
						if(grid.statusId != "REQUEST_RECEIVED"){
							$this.loadRegistrationSetupDetail(periodId,grid,flag);
						}
						else{
							if(flag){
								grid.down('#approve').setDisabled(false);
								grid.down('#enrollTo').setDisabled(false);
								//grid.down('#reject').setDisabled(false)
							}else{
								grid.down('#approve').setDisabled(true);
								grid.down('#enrollTo').setDisabled(true);
								grid.down('#reject').setDisabled(true)
							}
						}
						
						
						
						var requestReceiveFlag=false;
						var pendingFlag=false;
						for(var i in selected){
							if(selected[i].data.promotionEnrollmentStatus=="PENDING"){
								pendingFlag=true;
							}else if(selected[i].data.promotionEnrollmentStatus=="REQUEST_RECEIVED"){
								requestReceiveFlag=true;
							}
						}
						if(pendingFlag && requestReceiveFlag){
							showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('THE_STUDENT_WITH_THE_PENDING_AND_REQUEST_RECEIVED_STATUS_CANNOT_BE_SELECTED_TOGETHER'));
							grid.down('#enrollTo').setDisabled(true);
						}
						if(requestRecieved){
							grid.down('#reject').setDisabled(false);
						} else{
							grid.down('#reject').setDisabled(true);
						}
						
						var futurePeriodStudentCount=0;
						for(var i in selected){
							if(isNullOrEmpty(selected[i].data.programBatchStudentId)){
								futurePeriodStudentCount++;
								break;
							}
						}
						if(futurePeriodStudentCount>0)
						{
						grid.down('#enrollTo').setDisabled(false);
						grid.down('#approve').setDisabled(false);
						grid.down('#reject').setDisabled(false);
					    }
					}else{
						grid.down('#enrollTo').setDisabled(true);
						grid.down('#approve').setDisabled(true);
						grid.down('#reject').setDisabled(true);
					}
					
					if(selected.length == 1){
						if(selected[0].data.promotionEnrollmentStatus=="ENROLLED"){
							grid.down('#resendConfirmationLetter').setDisabled(false);
						} else {
							grid.down('#resendConfirmationLetter').setDisabled(true);
						}
					}else{
						grid.down('#resendConfirmationLetter').setDisabled(true);
					}
					if(isEnroll){
						grid.down('#approve').setDisabled(true);
					}
				}
			},
			'managestudentenrollmentlist' : {
				render : function(grid) {
					this.doAccessControlValidation(grid,this.getSTUDENT_PERIOD_ENROLLMENT_PERMISSIONS());
					this.disableOptPeriodEnrollmentListButtonsPivileges(grid,this.getSTUDENT_PERIOD_ENROLLMENT_PERMISSIONS());
				},
				afterrender: function(grid) {
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getSTUDENT_PERIOD_ENROLLMENT_PERMISSIONS());
					}, 1500);
				},
				selectionchange: function(column, selected) {
					var $this=this;
					var grid = this.getManagestudentenrollmentlist();
					var records = grid.getSelectionModel().getSelection();
					if(selected.length==1){
						var periodId=records[0].data.periodId;
						var status=records[0].data.status;
						var programBatchStudentId=records[0].data.programBatchStudentId;
						var paymentTermId=records[0].data.paymentTerm;
						if(!isNullOrEmpty(paymentTermId) && (status=="Enrolled" || status=="Request Received" || status=="In Progress")){
							grid.down('#changePaymentTerm').setDisabled(false);
						}else{
							grid.down('#changePaymentTerm').setDisabled(true);
						}
						if(status=="Enrolled" || status=="Request Received" || status=="In Progress"){
							grid.down('#periodDeEnroll').setDisabled(false);
						}else{
							grid.down('#periodDeEnroll').setDisabled(true);
						}
						/*if(isNullOrEmpty(programBatchStudentId)){
							grid.down('#save').setDisabled(true);
							grid.down('#showStudentEnrollmentMessageId').setValue("The student is not available for enrollment in "+records[0].data.periodName);
							grid.down('#showStudentEnrollmentMessageId').show();
						}else if(status=="Pending" && programBatchStudentId>0){
							grid.down('#save').setDisabled(true);
							grid.down('#showStudentEnrollmentMessageId').hide();
							$this.loadRegistrationSetupDetailForStudent(periodId,grid);
						}else*/ if(status=="Passed"){
							grid.down('#save').setDisabled(true);
							grid.down('#showStudentEnrollmentMessageId').hide();
						}else if(status!='Pending'){
							grid.down('#save').setDisabled(true);
							grid.down('#showStudentEnrollmentMessageId').hide();
						}else{
							grid.down('#save').setDisabled(true);
							$this.loadRegistrationSetupDetailForStudent(periodId,grid);
						}
					}else{
						grid.down('#changePaymentTerm').setDisabled(true);
						grid.down('#save').setDisabled(true);
					}
				}
			},
			
			'manageperiodenrollmentloaderstructure radiogroup[itemId=importDownloadgroupId]':{
				change : function(value,newValue,oldValue){
					this.changeOnDownloadUploadRadioBtn(value,newValue,oldValue);
				}
			}
			
		});
	},
	openPeriodEnrollToWindow : function() {
		var contentPanel = this.getContentPanel();
		var formWindow = this.getEnrolltoperiodenrollmentwin();
		if (!formWindow) {
			Ext.widget('enrolltoperiodenrollmentwin');
			formWindow = this.getEnrolltoperiodenrollmentwin();
		}
		formWindow.show();

		// display value on Window
		var grid = this.getManageperiodenrollmentlist();
		var records = grid.getSelectionModel().getSelection();
		var record = records[0].data;

		var programField = formWindow.down("#program");
		var batchField = formWindow.down("#batch");
		var periodField = formWindow.down("#currentPeriod");
		programField.setValue(record.programName);
		batchField.setValue(record.batchName);
		periodField.setValue(record.periodName);

		var searchForm = this.getManageperiodenrollmentsearch();
		var batchId = searchForm.down("#batchId").value;
		var periodId = searchForm.down("#periodId").value;
		var enrollToPeriodField = formWindow.down("#enrollToPeriod");
		var store = enrollToPeriodField.getStore();
		store.getProxy().extraParams = {
			periodId : periodId,
			batchId : batchId
			//Need to set period Id here
		}
		store.load();
	},
	openStudentPeriodEnrollTab : function() {
		var contentPanel = this.getContentPanel();
		var structure = Ext.widget('managestudentenrollmentstructure');
		var tabName = getCommonTranslation('STUDENT_PERIOD_ENROLLMENT');

		/**
		 * This is to remove tab from content panel and open same tab again
		 */
		var getcontroller = this.getController('menu.CoreERPNavigationController');
		var getTab = getcontroller.getTab(tabName);
		if (getTab != null) {
			contentPanel.remove(getTab, true);
		}
		openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_THREE);
	},
	editPaymentTermDetailsForm:function(){
		var grid = this.getManageperiodenrollmentlist();

		if(grid.getSelectionModel().getCount() > 0 ){
			var $this = this;
			var formWindow = this.getChangepaymenttermwindow();
			if (!formWindow) {
				Ext.widget('changepaymenttermwindow');
				formWindow = this.getChangepaymenttermwindow();
			}
			formWindow.show();
			var record = grid.getSelectionModel().getSelection()[0];
			var currentPaymentTerm  = formWindow.down('#currentPaymentTerm');
			var paymentGroup  =formWindow.down('#paymentGroup');
			var paymentTerm  =formWindow.down('#paymentTerm');
			
			
			paymentGroup.getStore().load({

				 callback:function(rec) {
					 for (var i in rec) {
						 if(rec[i].data.id==record.data.paymentGroup) {
							 paymentGroup.setValue(rec[i].data.id);
								paymentGroup.setReadOnly(true);
						 }
					 }
				 }
			 
			});
			
			paymentTerm.getStore().getProxy().extraParams={
				paymentGroupId:record.data.paymentGroup,
			
		};
			paymentTerm.getStore().load({

				 callback:function(rec) {
					 for (var i in rec) {
						 if(rec[i].data.id==record.data.paymentTerm) {
							 paymentTerm.setValue(rec[i].data.id);
							 currentPaymentTerm.setValue(rec[i].data.name);
						 }
					 }
				 }
			 
			});
		
			

		/*	paymentGroup.getStore().load({
				callback:function(records){
					Ext.each(records ,function(item){
						if(item.data.id==record.data.paymentGroup){
							paymentGroup.setValue(item.data.id);
							paymentGroup.setReadOnly(true);
							
							paymentTerm.getStore().getProxy().extraParams = {
								admissionId:record.data.admissionId,
								periodId:record.data.periodId
							};
							paymentTerm.getStore().load({
								callback:function(records){
									Ext.each(records ,function(item){
										if(item.data.id==record.data.paymentTerm){
											paymentTerm.setValue(item.data.id);
											currentPaymentTerm.setValue(item.data.value);
										}
									})
								}
							});
							
						}
					})
				}
			});*/
		}
		else {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}

	},
	savePaymentTerm:function(){
		var grid = this.getManageperiodenrollmentlist();
		var formWindow = this.getChangepaymenttermwindow();
		var form = formWindow.down('form');
		var formValues = form.getForm().getValues();
		var record = grid.getSelectionModel().getSelection()[0];
		
		var	paymentGroup = 	 formValues.paymentGroup;
		var paymentTerm=formValues.paymentTerm;
		var periodId	=record.data.periodId;
		var admissionId	=record.data.admissionId;
		var programBatchStudentId=	record.data.programBatchStudentId;
		var studentId=	record.data.studentId;
		var oldPaymentTerm	=record.data.paymentTerm;
		
        if (!isNullOrEmpty(record.data.programBatchStudentId)) {
			var programBatchStudentId=	record.data.programBatchStudentId;
			var submitUrlNew = SERVERURL.PATH_UPDATE_AND_CREATE_BILL_ON_CHANGE_PAYMENT_TERM_STUDENT+'?paymentGroup='+paymentGroup+'&paymentTerm='+paymentTerm+'&periodId='+periodId+'&admissionId='+admissionId+'&programBatchStudentId='+programBatchStudentId+'&oldPaymentTerm='+oldPaymentTerm;
		}else{
			var submitUrlNew = SERVERURL.PATH_UPDATE_AND_CREATE_BILL_ON_CHANGE_PAYMENT_TERM_STUDENT+'?paymentGroup='+paymentGroup+'&paymentTerm='+paymentTerm+'&periodId='+periodId+'&admissionId='+admissionId+'&oldPaymentTerm='+oldPaymentTerm;

		}		
		var programBatchStudentIds = programBatchStudentId;
		if(grid.getSelectionModel().getCount() > 0){
		    var pathUrl=SERVERURL.PATH_UPDATE_STUDENT_PAYMENT_TERM+'?programBatchStudentIds='+programBatchStudentIds+'&paymentTermId='+paymentTerm;
			if(isNullOrEmpty(record.data.programBatchStudentId)){
				var studentPeriodEnrollmentIds=record.data.studentPeridoEnrollmentId;;
				pathUrl=SERVERURL.PATH_UPDATE_STUDENT_PERIOD_ENROLLMENT_PAYMENT_TERM+'?studentPeriodEnrollmentIds='+studentPeriodEnrollmentIds+'&paymentTermId='+paymentTerm;
			}
			//if(record.data.whetherOptionalPeriod==false){
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type: 'rest',
					url: submitUrlNew,
					//jsonData: formData,
					method: 'POST',
					success: function(response, form) {
						Ext.Ajax.request({
							type: 'rest',
							url: pathUrl,
							//jsonData: formData,
							method: 'POST',
							success: function(response, form) {
								Ext.getBody().unmask();
								formWindow.close();
								grid.getSelectionModel().deselectAll();
								grid.getStore().load();
								$this.resetPageSetting(grid.getStore());


							}
						});
						Ext.getBody().unmask();
						showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('SUCCESS'));
					}
				});
			//}
		} else {
			showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	editPaymentTermDetailsFormForStudentEnrollment:function(){
		var grid = this.getManagestudentenrollmentlist();

		if(grid.getSelectionModel().getCount() > 0 ){
			var $this = this;
			var formWindow = this.getChangepaymenttermwindowstudent();
			if (!formWindow) {
				Ext.widget('changepaymenttermwindowstudent');
				formWindow = this.getChangepaymenttermwindowstudent();
			}
			formWindow.show();
			var record = grid.getSelectionModel().getSelection()[0];
			var currentPaymentTerm  = formWindow.down('#currentPaymentTerm');
			var paymentGroup  =formWindow.down('#paymentGroup');
			var paymentTerm  =formWindow.down('#paymentTerm');

			paymentGroup.getStore().load({
			    callback: function (records) {
			        Ext.each(records, function (item) {
			            if (item.data.id == record.data.paymentGroup) {
			                paymentGroupID = item.data.id;
			                paymentGroup.setValue(item.data.id);
			                paymentGroup.setReadOnly(true);

			                paymentTerm.getStore().getProxy().extraParams = {
			                    // admissionId:record.data.admissionId,
			                    // periodId:record.data.periodId
			                    paymentGroupId: paymentGroupID
			                };
			                paymentTerm.getStore().load({
			                    callback: function (records) {
			                        Ext.each(records, function (item) {
			                            if (item.data.id == record.data.paymentTerm) {
			                                paymentTerm.setValue(item.data.id);
			                                currentPaymentTerm.setValue(item.data.name);
			                            }
			                        });
			                    }
			                });

			                // Add the following line to break out of the loop after the first iteration
			                return false;
			            }
			        });
			    }
			});

		}
		else {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}

	},
	savePaymentTermStudent:function(){
		var grid = this.getManagestudentenrollmentlist();
		var formWindow = this.getChangepaymenttermwindowstudent();
		var form = formWindow.down('form');
		var formValues = form.getForm().getValues();
		var record = grid.getSelectionModel().getSelection()[0];
		
		var	paymentGroup = 	 formValues.paymentGroup;
		var paymentTerm=formValues.paymentTerm;
		var periodId	=record.data.periodId;
		var admissionId	=record.data.admissionId;
		var oldPaymentTerm	=record.raw.paymentTerm;
		if (!isNullOrEmpty(record.data.programBatchStudentId)) {
			var programBatchStudentId=	record.data.programBatchStudentId;
			var submitUrlNew = SERVERURL.PATH_UPDATE_AND_CREATE_BILL_ON_CHANGE_PAYMENT_TERM_STUDENT+'?paymentGroup='+paymentGroup+'&paymentTerm='+paymentTerm+'&periodId='+periodId+'&admissionId='+admissionId+'&programBatchStudentId='+programBatchStudentId+'&oldPaymentTerm='+oldPaymentTerm;
		}else{
			var submitUrlNew = SERVERURL.PATH_UPDATE_AND_CREATE_BILL_ON_CHANGE_PAYMENT_TERM_STUDENT+'?paymentGroup='+paymentGroup+'&paymentTerm='+paymentTerm+'&periodId='+periodId+'&admissionId='+admissionId+'&oldPaymentTerm='+oldPaymentTerm;

		}
		
		var programBatchStudentIds = programBatchStudentId;
		if(grid.getSelectionModel().getCount() > 0){
			var pathUrl=SERVERURL.PATH_UPDATE_STUDENT_PAYMENT_TERM+'?programBatchStudentIds='+programBatchStudentIds+'&paymentTermId='+paymentTerm;
			if(isNullOrEmpty(record.data.programBatchStudentId)){
				var studentPeriodEnrollmentIds=record.data.studentPeriodEnrollmentId;
				pathUrl=SERVERURL.PATH_UPDATE_STUDENT_PERIOD_ENROLLMENT_PAYMENT_TERM+'?studentPeriodEnrollmentIds='+studentPeriodEnrollmentIds+'&paymentTermId='+paymentTerm;
			}
			//if(record.data.whetherOptionalPeriod==false){
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type: 'rest',
					url: submitUrlNew,
					//jsonData: formData,
					method: 'POST',
					success: function(response, form) {
						Ext.Ajax.request({
							type: 'rest',
							url: pathUrl,
							//jsonData: formData,
							method: 'POST',
							success: function(response, form) {
								Ext.getBody().unmask();
								formWindow.close();
								grid.getSelectionModel().deselectAll();
								grid.getStore().load();
								$this.resetPageSetting(grid.getStore());


							}
						});
						Ext.getBody().unmask();
						showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('SUCCESS'));
					}
				});
			//}
		} else {
			showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	loadPeriodEnrollDataGrid : function() {
		var $this = this;
		var form = $this.getManageperiodenrollmentsearch();
		var programId = form.down("#programId").getValue();
		var batchId = form.down("#batchId").getValue();
		var periodId = form.down("#periodId").getValue();
		var sectionId = form.down("#sectionId").getValue();
		var statusId = form.down("#statusId").getValue();
		var academicTermId = form.down("#periodWiseAcademicTermId").getValue();
		var academyLocationId = form.down('#academyLocationPeriodEnrollment').getValue();
		var studentId = form.down("#studentNameSearch").getValue();
		var grid = this.getManageperiodenrollmentlist();
		grid.statusId = statusId;
		
		if(!isNullOrEmpty(statusId) && statusId == 'IN_PROGRESS'){
			statusId = 'INPROGRESS';
		}
		
		if(form.down("#periodId").valueModels.length){
			var sequence = form.down("#periodId").valueModels[0].data.sequence;
		}
		else{
			var sequence = 0;
		}
		
		var isOptionalPeriod = !isNullOrEmpty(sequence) && sequence == 1 ? true : false;
		var store = grid.getStore();
		store.getProxy().extraParams = {
			academyLocationId: academyLocationId,
			programId: programId,
			batchId: batchId,
			periodId : periodId,
			sectionId : sectionId,
			status : statusId,
			academicTermId: academicTermId,
			isOptionalPeriod:isOptionalPeriod,
			studentId:studentId
		};
		store.loadPage(1);
		
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.FIND_PAYMENT_TERM_BY_ADMISSION_ID_AND_PERIOD_ID,
			params : {
				admissionId:null,
				periodId:periodId,
				batchIds: batchId
			},
			method : 'GET',
			success : function(response) {
				var data = Ext.decode(response.responseText);
				//paymentTermComboStore.removeAll();
				allPaymentTermsData = data;
				//paymentTermComboStore.loadData(data);
			}
		});
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.FIND_PAYMENT_GROUP_BY_ADMISSION_ID_AND_PERIOD_ID,
			params : {
				admissionId:null,
				periodId:periodId,
				batchIds: batchId
			},
			method : 'GET',
			success : function(response) {
				var data = Ext.decode(response.responseText);
				//paymentTermComboStore.removeAll();
				allPaymentGroupData = data;
				//paymentTermComboStore.loadData(data);
			}
		});
		
		grid.down('#periodId').setValue(periodId);
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getMANAGE_PERIOD_ENROLLMENT_PERMISSIONS());
		buttonsToolBar = grid.query('toolbar')[0];
		var optionalPeriodEnrollment = buttonsToolBar.query('#optionalPeriodEnrollment')[0];
		var enrollToBtn=buttonsToolBar.query('#enrollTo')[0];
		if(isOptionalPeriod){
			enrollToBtn.setVisible(false);
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'OPTIONAL_PERIOD_ENROLLMENT') {
					if(!isNullOrEmpty(optionalPeriodEnrollment)){
						optionalPeriodEnrollment.setVisible(true);
					}        		
				}
			});
		} else{
			optionalPeriodEnrollment.setVisible(false);
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'ENROLL') {
					if(!isNullOrEmpty(enrollToBtn)){
						enrollToBtn.setVisible(true);
					}        		
				}
			});
		}
		
		/*if(isOptionalPeriod){
			grid.down('#optionalPeriodEnrollment').setVisible(true);
			//grid.down('#enrollTo').setVisible(false);
		} else{
			grid.down('#optionalPeriodEnrollment').setVisible(false);
			grid.down('#enrollTo').setVisible(true);
		}*/
		if(grid.statusId != "REQUEST_RECEIVED"){
			$this.loadRegistrationSetupDetail(periodId,grid);
		}
		
		if(grid.statusId == "REQUEST_RECEIVED"){
			grid.down('#approve').show(); //V2D-264594
			grid.down('#reject').show();
			//grid.down('#approve').setDisabled(false);
			//grid.down('#reject').setDisabled(false);
		}
		else{
			grid.down('#approve').setDisabled(true);
			grid.down('#reject').setDisabled(true);
		}
	},
	enrollOptionalPeriod : function() {
		var $this = this;
		var form = $this.getEnrolltoPeriodEnrollmentWin();
		var formValues = form.getValues();

		var optionalFormData = new Academia.model.AbstractDataModel;
		optionalFormData.set("requestDate", formValues.enrollmentDate);
		optionalFormData.set("optionPeriodId", formValues.enrollToPeriod);
		var students = [];
		var grid = $this.getManageperiodenrollmentlist();
		var records = grid.getSelectionModel().getSelection();
		for (var i = 0; i < records.length; i++) {
			/*n 
			if(records[i].data.whetherOptionalPeriod){
				students=[];
				showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('CAN_NOT_ENROLL'));
				break;
			}else{
				*/
				if(!isNullOrEmpty(records[i].data) && records[i].data.status=='ENROLLED' && isNullOrEmpty(records[i].data.optionalPeriodEnrollmentId)){
					var rec = records[i].data;
					students.push({
						"admissionId" : rec.admissionId,
						"programBatchStudentId" : rec.programBatchStudentId
					});
				}else{
					students=[];
					showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('ENROLLED_RECODS_ONLY'));
					break;
				}
			/*	
			}*/
		}
		if(!isNullOrEmpty(students) && students.length > 0){
			optionalFormData.set("students", students);
			$this.postDataToEnroll(optionalFormData, true);
		}
	},

	requestOptionalPeriodEnroll : function() {
		var $this = this;
		var grid = $this.getManagestudentenrollmentlist();
		var records = grid.getSelectionModel().getSelection();
		var record = records[0].data;
		var optionalFormData = new Academia.model.AbstractDataModel;
		// optionalFormData.set("requestDate", new Date());
		optionalFormData.set("optionPeriodId", record.periodId);
		var students = [];
		students.push({
			"admissionId" : record.admissionId,
			"programBatchStudentId" : record.programBatchStudentId
		});
		optionalFormData.set("students", students);
		$this.postDataToEnroll(optionalFormData, false);
	},

	postDataToEnroll : function(formData, window) {
		var $this = this;
		var submitData = Ext.encode(formData.data);
		if (window) {
			$this.applyWindowMask();
		} else {
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		}
		var url=SERVERURL.SAVE_OPTIONAL_PERIOD;
		if (!window) {
			url=SERVERURL.PATH_OPTIONAL_PERIOD_SAVE_AND_APPROVE;
		}
		Ext.Ajax.request({
			url : url,
			jsonData : submitData,
			method : 'POST',
			success : function(response) {
				if (window) {
					$this.hideWindowMask();
				} else {
					Ext.getBody().unmask();
				}
				var mssg = response.responseText;
				if (mssg == 'SUCCESS') {
					showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('OPTIONAL_PERIOD_REQUEST_SAVED'));
					if (window) {
						$this.getEnrolltoperiodenrollmentwin().close();
					}
					else if(Ext.isDefined($this.getOptionalperiodenrollmentstructure())){
						if(Ext.isDefined($this.getManageperiodenrollmentlist())){
							$this.getManageperiodenrollmentlist().getStore().load();
						}
						
						var tempStore=$this.getStore('coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridTempStore');
						if(tempStore.data.length >0 ){
							tempStore.removeAll();
						}
						var contentPanel = $this.getContentPanel();
						var tabName = getCommonTranslation('OPTIONAL_PERIOD_ENROLLMENT');
						var structure = Ext.widget('optionalperiodenrollmentstructure');
						var getcontroller=$this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
					}
				}
			}
		});
	},

	approvePeriodEnroll : function(grid) {
		var $this = this;
		showConfirmMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('OPTIONAL_PERIOD_APPROVE_CONFIRM'), function(
				btn, text) {
			if (btn == 'yes') {
				var records = grid.getSelectionModel().getSelection();
				var oPIds = [];
				for ( var i in records) {
					if(!isNullOrEmpty(records[i].data) && records[i].data.promotionEnrollmentStatus=='REQUEST_RECEIVED' && records[i].data.programBatchStudentId > 0){
						var id= records[i].data.programBatchStudentId;
						var paymentTermId=records[i].data.paymentTerm;
						oPIds.push(id);
					}else{
//						grid.down("#approve").setDisabled(true);
						oPIds=[];
						showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('REQUEST_RECEIVED_RECODS_ONLY'));
						break;
					}
				}
				if(!isNullOrEmpty(oPIds) && oPIds.length > 0){
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var programBatchStudentIds = oPIds.join();
					if(paymentTermId == null){
						paymentTermId = "";
					}
						
					Ext.Ajax.request({
						url : SERVERURL.PATH_APPROVE_OR_ENROLL_PROGRAM_BATCH_STUDENT+'?programBatchStudentIds='+programBatchStudentIds+'&paymentTermId='+paymentTermId+'&promotionStatus=ENROLLED',
						headers: {
							'Content-Type': 'application/json'
						},
						method : 'GET',
						success : function(response) {
							Ext.getBody().unmask();
							var mssg = response.responseText;
							if (mssg == 'SUCCESS') {
								showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('APPROVE_SUCCESS'));
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll(true);
								grid.down('#enrollTo').setDisabled(true);
								grid.down('#approve').setDisabled(true);
							}
						}
					});
				}
			}
		});
	},
	
	rejectProgramBatchStudents : function(grid) {
		 var this$ = this;
		 var popupWindow = this$.getManagePeriodEnrollmentPopupWinItemId();
		 var comment = popupWindow.down('#comment').getValue();
		 var records = grid.getSelectionModel().getSelection();
			var pbsIds = [];
			for ( var i in records) {
				if(!isNullOrEmpty(records[i].data) && records[i].data.promotionEnrollmentStatus=='REQUEST_RECEIVED' && records[i].data.programBatchStudentId > 0){
					var id= records[i].data.programBatchStudentId;
					pbsIds.push(id);
				}
			}
			if(!isNullOrEmpty(pbsIds) && pbsIds.length > 0){
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				var programBatchStudentIds = pbsIds.join();
				Ext.Ajax.request({
					url : SERVERURL.PATH_REJECT_PROGRAM_BATCH_STUDENT_REQUEST+'?programBatchStudentIds='+programBatchStudentIds+'&enrollmentStatus=PENDING'
					+'&comment='+comment,
					headers: {
						'Content-Type': 'application/json'
					},
					method : 'GET',
					success : function(response) {
						Ext.getBody().unmask();
						popupWindow.close();
						var mssg = response.responseText;
						if (mssg == 'SUCCESS') {
							showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getCommonTranslation('SUCCESS'));
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll(true);
							grid.down('#enrollTo').setDisabled(true);
							grid.down('#approve').setDisabled(true);
							grid.down('#reject').setDisabled(true);
						}
					},
					failure: function(result, request) {
						Ext.getBody().unmask();
						popupWindow.close();
           			 	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
           		 }
				});
			}
	},
	
	approveOptionalPeriodEnroll : function(grid) {
		var $this = this;
		showConfirmMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('OPTIONAL_PERIOD_APPROVE_CONFIRM'), function(
				btn, text) {
			if (btn == 'yes') {
				var records = grid.getSelectionModel().getSelection();
				var oPIds = [];
				for ( var i in records) {
					if(!isNullOrEmpty(records[i].data) && records[i].data.status=='REQUEST_RECEIVED' && records[i].data.optionalPeriodEnrollmentId > 0){
						var id= records[i].data.optionalPeriodEnrollmentId;
						oPIds.push(id);
					}else{
//						grid.down("#approve").setDisabled(true);
						oPIds=[];
						showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('REQUEST_RECEIVED_RECODS_ONLY'));
						break;
					}
				}
				if(!isNullOrEmpty(oPIds) && oPIds.length > 0){
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var optionalPeriodIds = oPIds.join();
					Ext.Ajax.request({
						url : SERVERURL.APPROVE_OPTIONAL_PERIOD+'?optionalPeriodIds='+optionalPeriodIds,
						headers: {
							'Content-Type': 'application/json'
						},
						method : 'GET',
						success : function(response) {
							Ext.getBody().unmask();
							var mssg = response.responseText;
							if (mssg == 'SUCCESS') {
								showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('APPROVE_SUCCESS'));
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll(true);
								grid.down('#enrollTo').setDisabled(true);
								grid.down('#approve').setDisabled(true);
							}
						}
					});
				}
			}
		});
	},
	
	//Disable  Privileges button 
	disableOptPeriodEnrollmentListButtonsPivileges: function(gridReference,permissionsMap) {

		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		buttonsToolBar = gridReference.query('toolbar')[0];
		buttonsToolBar.setVisible(false);
		var studentEnrollmentBtn=buttonsToolBar.query('#studentEnrollment')[0];
		var enrollToBtn=buttonsToolBar.query('#enrollTo')[0];
		var approveBtn=buttonsToolBar.query('#approve')[0];
		var saveBtn = buttonsToolBar.query('#save')[0];
		var optionalPeriodEnrollment = buttonsToolBar.query('#optionalPeriodEnrollment')[0];
		var changePaymentTerm = buttonsToolBar.query('#changePaymentTerm')[0];
		var resendConfirmationLetter = buttonsToolBar.query('#resendConfirmationLetter')[0];
		var rejectBtn = buttonsToolBar.query('#reject')[0];
//		studentEnrollmentBtn.setVisible(false);
//		enrollToBtn.setVisible(false);
//		approveBtn.setVisible(false);
//		saveBtn.setVisible(false);
		//changePaymentTerm.setVisible(true);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'STUDENT_ENROLLMENT') {
				if(!isNullOrEmpty(studentEnrollmentBtn)){
					studentEnrollmentBtn.setVisible(true);
				}        		
			}
			if (privilege === 'ENROLL') {
				if(!isNullOrEmpty(enrollToBtn)){
					enrollToBtn.setVisible(true);
				}        		
			}
			if (privilege === 'APPROVE') {
				if(!isNullOrEmpty(approveBtn)){
					approveBtn.setVisible(true);
				}        		
			}
			if (privilege === 'SAVE') {
				if(!isNullOrEmpty(saveBtn)){
					saveBtn.setVisible(true);
				}        		
			}
			if (privilege === 'OPTIONAL_PERIOD_ENROLLMENT') {
				if(!isNullOrEmpty(optionalPeriodEnrollment)){
					optionalPeriodEnrollment.setVisible(true);
				}        		
			}
			if (privilege === 'CHANGE_PAYMENT_TERM') {
				if(!isNullOrEmpty(changePaymentTerm)){
					changePaymentTerm.setVisible(true);
				}        		
			}
			if (privilege === 'REJECT') {
				if(!isNullOrEmpty(rejectBtn)){
					rejectBtn.setVisible(true);
				}        		
			}
			if (privilege === 'RESEND_CONFIRMATION_LETTER') {
				if(!isNullOrEmpty(resendConfirmationLetter)){
					resendConfirmationLetter.setVisible(true);
				}        		
			}
		});
		buttonsToolBar.setVisible(true);
	},
	loadRegistrationSetupDetail:function(periodId,grid,btnFlag){
		var $this=this;
		var records = grid.getSelectionModel().getSelection();
		var admissionId=null;
		if(records.length>0){
		admissionId = records[0].data.admissionId;
		}
		/*var academyLocationIds;
		var alIds = [];
		for (var i in records.length) {
            if (Ext.isObject(records[0])) {
                alIds.push(records[i].get(records[0].data.admissionId));
            } else {
                alIds.push(records[i]);
            }
        }
        academyLocationIds = alIds.join();*/
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FIND_COURSE_REGISTRATION_SETUP_DETAIL_BY_PERIOD,
			method: 'GET',
			params:{
				periodId:periodId,
				//admissionId:admissionId,
			},
			success: function(f, action) {
				if (!isNullOrEmpty(f.responseText)) {
					var data = f.responseText;
					var jData=Ext.JSON.decode(data);
					var studentEnrollment=grid.down('#studentEnrollment');
					var enrollTo=grid.down('#enrollTo');
					var approve=grid.down('#approve');
					var rejectBtn=grid.down('#reject');
					var showEnrollmentMessageId=grid.down('#showEnrollmentMessageId');
					var optionalPeriodEnrollment = grid.down('#optionalPeriodEnrollment');
					var form = $this.getManageperiodenrollmentsearch();
					if(form.down("#periodId").valueModels.length){
						var sequence = form.down("#periodId").valueModels[0].data.sequence;
					}
					else{
						var sequence = 0;
					}
					var isOptionalPeriod = !isNullOrEmpty(sequence) && sequence == 1 ? true : false;
					if(jData.whetherAutoApproved && !isOptionalPeriod){
						grid.down('#approve').hide();
					}else{
						grid.down('#approve').show();
					}
					grid.down('#whetherAutoApproved').setValue(jData.whetherAutoApproved);
					if(jData.whetherRegistration){
						showEnrollmentMessageId.setValue("<font color='green'>" +getProgramandcourseTranslation('REGISTRATION_ENDS_ON')+" "
								+ dateTimeRender(jData.endDate)+"</font>");
						showEnrollmentMessageId.show();
						optionalPeriodEnrollment.setDisabled(false);
						
						if(Ext.isDefined(btnFlag)){
							if(btnFlag){
								grid.down('#approve').setDisabled(false);
								grid.down('#enrollTo').setDisabled(false);
								grid.down('#reject').setDisabled(false)
							}else{
								grid.down('#approve').setDisabled(true);
								grid.down('#enrollTo').setDisabled(true);
								grid.down('#reject').setDisabled(true)
							}
						}
						/*if(jData.holdErrorMsg=="COURSE_ENROLLMENT_HOLD"){
    						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
							showEnrollmentMessageId.setValue("<font color='red'>" +showEnrollmentMessageId.getValue()+ " </br>" +getCommonTranslation('HOLD_IS_APPLIED')+"</font>");
							showEnrollmentMessageId.show();
							enrollTo.setDisabled(true);
    					}*/
						
					}else{
						optionalPeriodEnrollment.setDisabled(true);
						enrollTo.setDisabled(true);
						approve.setDisabled(true);
						rejectBtn.setDisabled(true);
						if(jData.currentDate<jData.startDate){
							showEnrollmentMessageId.setValue(getProgramandcourseTranslation('REGISTRATION_START')+" "+getProgramandcourseTranslation('FROM')
									+" "+  dateTimeRender(jData.startDate)+" "+getProgramandcourseTranslation('TO')+" "+dateTimeRender(jData.endDate));
						}else if(jData.currentDate>jData.endDate){
							showEnrollmentMessageId.setValue("<font color='red'>" +getProgramandcourseTranslation('REGISTRATION_END')+" "
									+ dateTimeRender(jData.endDate)+"</font>");
						}
						showEnrollmentMessageId.show();
					}

				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_NOT_AVAILABLE_FOR_ENROLLMENT'));
				}

			},
			failure: function(result, request) {
				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
				return false;
			}
		});
	},
	enrollProgramBatchStudent : function(grid) {
		var $this = this;
		var records = grid.getSelectionModel().getSelection();
		var oPIds = [];
		var modifiedProgramBatchStudentList=[];
		var promotionStatus="ENROLLED";
		for ( var i in records) {
			if(!isNullOrEmpty(records[i].data) && records[i].data.promotionEnrollmentStatus=='PENDING' && records[i].data.programBatchStudentId > 0){
				 var programBatchStudent={
						 "programBatchStudentId":records[i].data.programBatchStudentId,
        				 "promotionStatus":promotionStatus,
        				 "paymentTermId":records[i].data.paymentTerm,
				 }
				 modifiedProgramBatchStudentList.push(programBatchStudent);
			}else{
				oPIds=[];
				showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('THE_STUDENT_WITH_THE_PENDING_AND_REQUEST_RECEIVED_STATUS_CANNOT_BE_SELECTED_TOGETHER'));
				break;
			}
		}
		var whetherAutoApproved=grid.down('#whetherAutoApproved').getValue();
		if(records[i].data.isPaymentTermMandatory && (isNullOrEmpty(records[i].data.paymentTerm) || isNullOrEmpty(records[i].data.paymentGroup))){
		    showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('PAYMENT_GROUP_AND_PAYMENT_TERM_IS_MANDATORY'));
		}else{
		if(!isNullOrEmpty(modifiedProgramBatchStudentList) && modifiedProgramBatchStudentList.length > 0){
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			var submitUrl = SERVERURL.PATH_ENROLL_PROGRAM_BATCH_STUDENT;
			Ext.Ajax.request({
				method: "POST",
				type: 'rest',
				jsonData: modifiedProgramBatchStudentList,
				url: submitUrl,
				headers: {
					'Content-Type': 'application/json'
				},
				success : function(response) {
					Ext.getBody().unmask();
					var mssg = response.responseText;
					if (mssg == 'SUCCESS') {
						showSuccessMessage(getCommonTranslation('STUDENT_REGISTRATION'), getCommonTranslation('PERIOD_REGISTRATION_IS_COMPLETED'));
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll(true);
						grid.down('#enrollTo').setDisabled(true);
						grid.down('#approve').setDisabled(true);
					}
				}
			});
		}
		}

	},
	loadRegistrationSetupDetailForStudent:function(periodId,grid){
		var $this=this;
		var records = grid.getSelectionModel().getSelection();
		var periodName = records[0].data.periodName;
		var admissionId=records[0].data.admissionId;
		var programBatchStudentId = records[0].data.programBatchStudentId;
		var academicTermId = records[0].data.academicTermId;
		var isYearlySetup = records[0].data.isYearlySetup;
		var showStudentEnrollmentMessageId=grid.down('#showStudentEnrollmentMessageId');
		var today = Ext.Date.format(new Date(), 'Y-m-d');
		var periodEndDate = records[0].data.periodEnd;
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FIND_COURSE_REGISTRATION_SETUP_DETAIL_BY_PERIOD,
			method: 'GET',
			params:{
				periodId:periodId,
				admissionId:admissionId,
				academicTermId : academicTermId,
				isYearlySetup : isYearlySetup
			},
			success: function(f, action) {
				if (!isNullOrEmpty(f.responseText)) {
					var data = f.responseText;
					var jData=Ext.JSON.decode(data);
					var enroll=grid.down('#save');
					if(jData.whetherRegistration){
						if(jData.currentDate<jData.startDate && jData.currentDate<jData.startDate){
							showStudentEnrollmentMessageId.setValue("<font color='grey'>"+getProgramandcourseTranslation('REGISTRATION_START')+" "+getProgramandcourseTranslation('FROM')
									+" "+  dateTimeRender(jData.startDate)+" "+getProgramandcourseTranslation('TO')+" "+dateTimeRender(jData.endDate)+"</font>");
							enroll.setDisabled(true);
						}else if(jData.currentDate>jData.endDate && jData.currentDate>jData.endDate){
							showStudentEnrollmentMessageId.setValue("<font color='red'>"+getProgramandcourseTranslation('REGISTRATION_END')+" "
									+ dateTimeRender(jData.endDate)+"</font>");
							enroll.setDisabled(true);
						}else if(jData.currentDate>=jData.startDate && jData.currentDate<=jData.endDate){
							showStudentEnrollmentMessageId.setValue("<font color='green'>"+getProgramandcourseTranslation('REGISTRATION_ENDS_ON_NEW')+" "
									+ dateTimeRender(jData.endDate)+"</font>");
							//if(programBatchStudentId>0){
								enroll.setDisabled(false);
							//}
								if(jData.holdErrorMsg=="COURSE_ENROLLMENT_HOLD"){
            						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
									showStudentEnrollmentMessageId.setValue("<font color='red'>" +showStudentEnrollmentMessageId.getValue()+ "</br> " +getCommonTranslation('HOLD_IS_APPLIED')+"</font>");
									//showStudentEnrollmentMessageId.show();
									enroll.setDisabled(true);
            					}
								if(jData.holdErrorMsg=="FINANCE_HOLD"){
            						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
									showStudentEnrollmentMessageId.setValue("<font color='red'>" +showStudentEnrollmentMessageId.getValue()+ "</br> " +getCommonTranslation('FINANCE_HOLD_IS_APPLIED')+"</font>");
									//showStudentEnrollmentMessageId.show();
									enroll.setDisabled(true);
            					}

						}
						showStudentEnrollmentMessageId.show();
					}else{
						if(jData.currentDate<jData.startDate && jData.currentDate<jData.startDate){
							showStudentEnrollmentMessageId.setValue("<font color='grey'>"+getProgramandcourseTranslation('REGISTRATION_START')+" "+getProgramandcourseTranslation('FROM')
									+" "+  dateTimeRender(jData.startDate)+" "+getProgramandcourseTranslation('TO')+" "+dateTimeRender(jData.endDate));
							enroll.setDisabled(true);
						}else if(jData.currentDate>jData.endDate && jData.currentDate>jData.endDate){
							showStudentEnrollmentMessageId.setValue("<font color='red'>"+getProgramandcourseTranslation('REGISTRATION_END')+" "
									+ dateTimeRender(jData.endDate)+"</font>");
							enroll.setDisabled(true);
						}else if(jData.currentDate>jData.startDate && jData.currentDate<jData.endDate){
							showStudentEnrollmentMessageId.setValue("<font color='green'>"+getProgramandcourseTranslation('REGISTRATION_ENDS_ON_NEW')+" "
									+ dateTimeRender(jData.endDate)+"</font>");
							//if(programBatchStudentId>0){
								enroll.setDisabled(false);
								if(jData.holdErrorMsg=="COURSE_ENROLLMENT_HOLD"){
            						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
									showStudentEnrollmentMessageId.setValue("<font color='red'>" +showStudentEnrollmentMessageId.getValue()+ "</br> " +getCommonTranslation('HOLD_IS_APPLIED')+"</font>");
									showStudentEnrollmentMessageId.show();
            						enrollTo.setDisabled(true);
            					}
								if(jData.holdErrorMsg=="FINANCE_HOLD"){
            						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
									showStudentEnrollmentMessageId.setValue("<font color='red'>" +showStudentEnrollmentMessageId.getValue()+ "</br> " +getCommonTranslation('FINANCE_HOLD_IS_APPLIED')+"</font>");
									//showStudentEnrollmentMessageId.show();
									enroll.setDisabled(true);
            					}
							//}
						}
						showStudentEnrollmentMessageId.show();
					}

				}else{
					showStudentEnrollmentMessageId.setValue("<font color='grey'>"+getProgramandcourseTranslation('THE_REGISTRATION_IS_NOT_REQUIRED_FOR')+" "+periodName+"</font>");
					showStudentEnrollmentMessageId.show();
					
				}
				if(today > periodEndDate){
					grid.down('#save').setDisabled(true);
				}

			},
			failure: function(result, request) {
				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
				return false;
			}
		});
	}
	,enrollProgramBatchStudentWise : function(grid) {
		var $this = this;
		var records = grid.getSelectionModel().getSelection();
		if(!isNullOrEmpty(records[0].data) && records[0].data.status=='Pending' && records[0].data.programBatchStudentId > 0){
			var id= records[0].data.programBatchStudentId;
		}
		var whetherAutoApproved=records[0].data.whetherAutoApproved;
		var promotionStatus="ENROLLED";
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var programBatchStudentIds = id;
		var paymentTermId = null;
		if(!isNullOrEmpty(records[0].data.paymentTerm)){
	        paymentTermId = parseInt(records[0].data.paymentTerm); // Parse as integer
		}
		
		if(paymentTermId ==null){
			paymentTermId ='';
		}
		
		if(!isNullOrEmpty(programBatchStudentIds)){
			if(records[0].data.isPaymentTermRequired && (isNullOrEmpty(records[0].data.paymentTerm) || isNullOrEmpty(records[0].data.paymentGroup))){
			    showWarningMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('PAYMENT_GROUP_AND_PAYMENT_TERM_IS_MANDATORY'));
			    Ext.getBody().unmask();
			}else{
			Ext.Ajax.request({
				url : SERVERURL.PATH_APPROVE_OR_ENROLL_PROGRAM_BATCH_STUDENT+'?programBatchStudentIds='+programBatchStudentIds+'&promotionStatus='+promotionStatus+
				'&paymentTermId='+paymentTermId,
				headers: {
					'Content-Type': 'application/json'
				},
				method : 'GET',
				success : function(response) {
					Ext.getBody().unmask();
					var mssg = response.responseText;
					if (mssg == 'SUCCESS') {
						showSuccessMessage(getCommonTranslation('STUDENT_REGISTRATION'), getCommonTranslation('PERIOD_REGISTRATION_IS_COMPLETED'));
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll(true);
						grid.down('#save').setDisabled(true);
					}
				}
			});
			}
		} else{
			var student = this.getManagestudentenrollmentsearch().down("#studentNameSearch");
			promotionStatus="IN_PROGRESS";
			Ext.Ajax.request({
				url : SERVERURL.PATH_STUDENT_PERIOD_ENROLLMENT_CREATE+'?periodId='+records[0].data.periodId+'&studentId='+student.value+'&status='+promotionStatus+
				'&paymentTermId='+paymentTermId+'&admissionId='+records[0].data.admissionId,
				headers: {
					'Content-Type': 'application/json'
				},
				method : 'POST',
				success : function(response) {
					Ext.getBody().unmask();
					var mssg = response.responseText;
					if (mssg == 'SUCCESS') {
						showSuccessMessage(getCommonTranslation('STUDENT_REGISTRATION'), getCommonTranslation('PERIOD_REGISTRATION_IS_COMPLETED'));
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll(true);
						grid.down('#save').setDisabled(true);
					}
				}
			});
		}
	},
	resetManagePeriodEnrollmentSearch: function(structure){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();
		var aLId = me.getCurrentAcademyLocation();
		
		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');
		var studentNameSearch = form.down('#studentNameSearch');
		
		academyLocationField.reset();
		academicTermField.reset();
		periodEnrollmentStatusField.reset();
		programCodeField.reset();
		batchField.reset();
		periodField.reset();
		sectionField.reset();
		studentNameSearch.reset();
		
		var academyLocationStore = academyLocationField.getStore();
		academyLocationStore.getProxy().extraParams={};
		
		academyLocationStore.load({
			callback: function(records, operation, success) {
				if (success) {
					academyLocationField.setValue(aLId);
					academyLocationField.fireEvent('select', academyLocationField);
				}
			}
		});
	},
	onAcademyLocationFieldChange: function(field){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();
		
		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');

		academicTermField.reset();
		periodEnrollmentStatusField.reset();
		programCodeField.reset();
		batchField.reset();
		periodField.reset();
		sectionField.reset();
		
		var aLId = academyLocationField.getValue();
		
		var academicTermFieldStore = academicTermField.getStore();
		academicTermFieldStore.getProxy().extraParams={
			academyLocationId:aLId
		};
		
		academicTermFieldStore.load({
			callback: function(rec, success) {
				if (success) {
					for(var i in rec){
						if(rec[i].get('sequence')==1){		        					
							academicTermField.setValue(rec[i].get('id'));
						}
					}
				}
			}
		});
	},
	onAcademyTermFieldChange: function(field){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();

		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');
		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var studentNameSearchField = form.down('#studentNameSearch');

		periodEnrollmentStatusField.reset();
		programCodeField.reset();
		batchField.reset();
		periodField.reset();
		sectionField.reset();
		studentNameSearchField.reset();

		var aLId = academyLocationField.getValue();
		//var academicTermFieldValue = academicTermField.getValue();
		var academicTermFieldValue = academicTermField.getValue();
		periodEnrollmentStatusFieldStore = periodEnrollmentStatusField.getStore();
		periodEnrollmentStatusFieldStore.getProxy().extraParams = {
			academyLocationId : aLId
		};
		periodEnrollmentStatusFieldStore.load();

		var programCodeFieldStore = programCodeField.getStore();
		
		if(academicTermFieldValue > 0){
			programCodeFieldStore.getProxy().extraParams = {
				academyLocationId : aLId,
				academicTermId : academicTermFieldValue
			};
			programCodeFieldStore.load();

			batchField.setDisabled(true);
			periodField.setDisabled(true);
			sectionField.setDisabled(true);
			//--- Setting Program, Batch, Period Fields Required
			me.setAllowBlank(programCodeField, false);
			me.setAllowBlank(batchField, false);
			me.setAllowBlank(periodField, false);
		}
		

		
		
		form.getForm().isValid();
		form.getForm().clearInvalid();
	},
	onPeriodEnrollmentStatusFieldChange: function(field){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();

		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');

		var periodEnrollmentStatusFieldValue = periodEnrollmentStatusField.getValue();
		if(periodEnrollmentStatusFieldValue == "REQUEST_RECEIVED"){
			me.setAllowBlank(programCodeField, true);
			me.setAllowBlank(batchField, true);
			me.setAllowBlank(periodField, true);
		}
		else{
			me.setAllowBlank(programCodeField, false);
			me.setAllowBlank(batchField, false);
			me.setAllowBlank(periodField, false);
		}
		
		form.getForm().isValid();
		form.getForm().clearInvalid();
	},
	onProgramCodeNameFieldChange: function(field){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();

        var studentNameSearchField = form.down('#studentNameSearch');
		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var academicTermID = academicTermField.getValue();
		if(academicTermID >0){
			academicTermFieldValue:academicTermID
		}
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');

		batchField.reset();
		periodField.reset();
		sectionField.reset();

		batchField.setDisabled(true);
		periodField.setDisabled(true);
		sectionField.setDisabled(true);
		var isProgramExist = programCodeField.store.findExact('id',programCodeField.getValue());
		if(isProgramExist!= -1){
		var aLId = academyLocationField.getValue();
		var academicTermFieldValue = academicTermField.getValue();
		var programCodeFieldValue = programCodeField.getValue();
		var studentId = studentNameSearchField.getValue();

		if(!isNullOrEmpty(programCodeFieldValue)){
			batchField.setDisabled(false);
			var batchFieldStore = batchField.getStore();
			var periodFieldStore = periodField.getStore();
			var sectionFieldStore = sectionField.getStore();

			batchFieldStore.getProxy().extraParams = {
				academyLocationId : aLId,
				id : programCodeFieldValue,
				academicTermId : academicTermFieldValue,
				isActive : true,
				studentId : studentId
			};

			batchFieldStore.load({
				callback: function(records, operation, success) {
					if (success) {
						var batchId = 0;
						for (var i = 0, j = 0; i < records.length; i++) {
							if (records.length == 1) {
								batchId = records[i].data.id;
								batchField.setValue(records[i].get('id'));
							}
						}
					}
				}
			});
		}
	  }
	},
	onBatchFieldChange: function(field){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();

		var studentNameSearchField = form.down('#studentNameSearch');
		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var academicTermID = academicTermField.getValue();
		if(academicTermID > 0){
			academicTermFieldValue:academicTermID
		}
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');

		periodField.reset();
		sectionField.reset();

		periodField.setDisabled(true);
		sectionField.setDisabled(true);

		var aLId = academyLocationField.getValue();
		var studentId = studentNameSearchField.getValue();
		var academicTermFieldValue = academicTermField.getValue();
		var programCodeFieldValue = programCodeField.getValue();
		var batchFieldValue = batchField.getValue();

		if(!isNullOrEmpty(batchFieldValue)){
			periodField.setDisabled(false);
			var periodFieldStore = periodField.getStore();
			var sectionFieldStore = sectionField.getStore();

			periodFieldStore.getProxy().extraParams = {
				academyLocationId : aLId,
				programId : programCodeFieldValue,
				academicTermId : academicTermFieldValue,
				batchId : batchFieldValue,
				studentId:studentId
			};

			periodFieldStore.load({
				callback: function(record, operation, success) {
					if (success) {
						var periodId = 0;
						for (var i = 0, j = 0; i < record.length; i++) {
							if (record.length == 1) {
								periodId = record[i].data.id;
								periodField.setValue(record[i].get('id'));
							}
						}
					}
				}
			});
		}
	},
	onPeriodFieldChange: function(field){
		var me = this;
		var form = me.getManageperiodenrollmentsearch();
		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var academicTermID = academicTermField.getValue();
		if(academicTermID > 0){
			academicTermFieldValue:academicTermID
		}
		var studentNameSearchField = form.down('#studentNameSearch');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');

		sectionField.reset();

		sectionField.setDisabled(true);

		var aLId = academyLocationField.getValue();
		var studentId = studentNameSearchField.getValue();
		var academicTermFieldValue = academicTermField.getValue();
		var programCodeFieldValue = programCodeField.getValue();
		var batchFieldValue = batchField.getValue();
		var periodFieldValue = periodField.getValue();
		
		if(!isNullOrEmpty(periodFieldValue)){
			sectionField.setDisabled(false);
			
			var sectionFieldStore = sectionField.getStore();
			
			sectionFieldStore.getProxy().extraParams = {
				academyLocationIds : aLId,
				programId : programCodeFieldValue,
				academicTermId : academicTermFieldValue,
				batchId : batchFieldValue,
				periodId : periodFieldValue,
				studentId : studentId
			};

			sectionFieldStore.load({
				callback: function(records, operation, success) {
					if (success) {
						if (records.length == 1) {
							sectionField.setValue(records[0].data.sectionId);
						}
					}
				}
			});
		}
	},
	deEnrollPeriod: function(grid) {
		var selectedRecord = grid.getSelectionModel().selected.items[0];
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_PERIOD_DE_ENROLLMENT,
			params: {
				admissionId: selectedRecord.data.admissionId,
				periodId: selectedRecord.data.periodId,
			},
			method: 'GET',
			success: function(response) {
				if(response.responseText == "PLEASE_DE_ENROLL_THE_MODULE_FOR_THE_SELECTED_PERIOD"){
				grid.getStore().load();
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_DE_ENROLL_THE_MODULE_FOR_THE_SELECTED_PERIOD'))
				}else{
				grid.getStore().load();
				showSuccessMessage(getCommonTranslation('PERIOD_DE_ENROLL_ENROLLMENT'), getCommonTranslation('SUCCESS'));
			   }
			}
		});
	},
	
	onstudentNameSearchFieldChange : function(grid){
		
		var me = this;
		var form = me.getManageperiodenrollmentsearch();

		var academyLocationField = form.down('#academyLocationPeriodEnrollment');
		var academicTermField = form.down('#periodWiseAcademicTermId');
		var academicTermID = academicTermField.getValue();
		if(academicTermID >0){
			academicTermFieldValue:academicTermID
		}
		var studentNameSearchField = form.down('#studentNameSearch');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');

        //periodEnrollmentStatusField.store();
        programCodeField.reset();
		batchField.reset();
		periodField.reset();
		sectionField.reset();

		batchField.setDisabled(true);
		periodField.setDisabled(true);
		sectionField.setDisabled(true);
		
		
		var isStudentNameExist = studentNameSearchField.store.findExact('id',studentNameSearchField.getValue());
		var aLId = academyLocationField.getValue();
		var academicTermFieldValue = academicTermField.getValue();
		var studentNameSearchFieldValue = studentNameSearchField.getValue();

		if(!isNullOrEmpty(studentNameSearchFieldValue)){
			var programCodeFieldStore = programCodeField.getStore(); 

			programCodeFieldStore.getProxy().extraParams = {
				academyLocationId : aLId,
				studentId : studentNameSearchFieldValue,
				academicTermId : academicTermFieldValue,
			};

			programCodeFieldStore.load({
				callback: function(records, operation, success) {
					if (success) {
						var programId = 0;
						for (var i = 0, j = 0; i < records.length; i++) {
							if (records.length == 1) {
								programId = records[i].data.id;
								programCodeField.setValue(records[i].get('id'));
							}
						}
					}
				}
			});
		}
	},	disableBulkImportLecturerCostingDefinition: function(structure,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var periodEnrollment = false;
		Ext.each(permissionList, function(privilege) {
			if (privilege === "IMPORT_PERIOD_ENROLLMENT") {
				periodEnrollment=true;
			}
		});

		var panelItem = new Array();
		var $this = this;
		var newcont = structure.items.items.length;
		var insertPosition = newcont;
		panelItem.push({
			xtype:'tabpanel',
			plain: true,
			style:{overflow:'hidden !important',margin:'0!important'},
			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			frame: false,
			border:false,
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'manageperiodenrollmentstructure',
				title: getCommonTranslation('SEARCH'),
				tabCls: 'right-tab',
				listeners: {
                	activate: function(me, eOpts){
                		var contentPanelMain = $this.getActiveTabfromContentPanel();
                		if(!isNullOrEmpty(contentPanelMain)){
                			contentPanelMain.scrollBy(0,1);
                			contentPanelMain.scrollBy(0,-1);
                		}
                	}
                }
			}]
		});
    	var insertAt = panelItem["0"].items.length;;
		if(periodEnrollment) {
			panelItem["0"].items[insertAt] = {
					xtype: 'manageperiodenrollmentloaderstructure',
					title: getCommonTranslation('IMPORT_PERIOD_ENROLLMENT'),
				};
			insertAt = insertAt+1;
		}
		structure.insert(insertPosition, panelItem);
	},
	
	
	changeOnDownloadUploadRadioBtn : function(value,newValue,oldValue){
		var $this = this;
		var structure =$this.getManageperiodenrollmentloaderstructure();
		var downloadForm = structure.down('#downloadPeriodEnrollmentformId');
		var uploadForm = structure.down('#uploadPeriodEnrollmentformId');
		var uploadGrid = structure.down('#importutilityperiodenrollment');
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(newValue.downloadUploadTemplate == 'forDownloadTemplate'){
			downloadForm.setVisible(true);
			uploadGrid.setVisible(false);
			uploadForm.setVisible(false);

		} else if(newValue.downloadUploadTemplate=='forUploadTemplate'){
			uploadGrid.setVisible(true);
			uploadForm.setVisible(true);
			downloadForm.setVisible(false);
			
		}
	},
	
	onImportAcademyLocationFieldChange: function(field){
		var $this = this;
		var structure =$this.getManageperiodenrollmentloaderstructure();
		var downloadForm = structure.down('#downloadPeriodEnrollmentformId');
		
		var academyLocationField = downloadForm.down('#academyLocationId');
		var academicTermField = downloadForm.down('#academicTermId');
		var periodEnrollmentStatusField = downloadForm.down('#statusId');
		var programCodeField = downloadForm.down('#programId');
		var batchField = downloadForm.down('#batchId');
		var periodField = downloadForm.down('#periodId');
		var sectionField = downloadForm.down('#sectionId');

		academicTermField.reset();
		periodEnrollmentStatusField.reset();
		programCodeField.reset();
		batchField.reset();
		periodField.reset();
		sectionField.reset();
		
		var aLId = academyLocationField.getValue();
		
		var academicTermFieldStore = academicTermField.getStore();
		academicTermFieldStore.getProxy().extraParams={
			academyLocationId:aLId
		};
		
		academicTermFieldStore.load({
			callback: function(rec, success) {
				if (success) {
					for(var i in rec){
						if(rec[i].get('sequence')==1){		        					
							academicTermField.setValue(rec[i].get('id'));
						}
					}
				}
			}
		});
	},
	onImportAcademyTermFieldChange: function(field){
		var $this = this;
		var structure =$this.getManageperiodenrollmentloaderstructure();
		var form = structure.down('#downloadPeriodEnrollmentformId');

		var academyLocationField = form.down('#academyLocationId');
		var academicTermField = form.down('#academicTermId');
		var periodEnrollmentStatusField = form.down('#statusId');
		var programCodeField = form.down('#programId');
		var batchField = form.down('#batchId');
		var periodField = form.down('#periodId');
		var sectionField = form.down('#sectionId');
		var academyLocationField = form.down('#academyLocationId');
		
		programCodeField.setDisabled(false);

		periodEnrollmentStatusField.reset();
		programCodeField.reset();
		batchField.reset();
		periodField.reset();
		sectionField.reset();

		var aLId = academyLocationField.getValue();
		//var academicTermFieldValue = academicTermField.getValue();
		var academicTermFieldValue = academicTermField.getValue();
		periodEnrollmentStatusFieldStore = periodEnrollmentStatusField.getStore();
		periodEnrollmentStatusFieldStore.getProxy().extraParams = {
			academyLocationId : aLId
		};
		periodEnrollmentStatusFieldStore.load();

		var programCodeFieldStore = programCodeField.getStore();
		
		if(academicTermFieldValue > 0){
			programCodeFieldStore.getProxy().extraParams = {
				academyLocationId : aLId,
				academicTermId : academicTermFieldValue
			};
			programCodeFieldStore.load();

			batchField.setDisabled(true);
			periodField.setDisabled(true);
			sectionField.setDisabled(true);
			//--- Setting Program, Batch, Period Fields Required
			$this.setAllowBlank(programCodeField, false);
			$this.setAllowBlank(batchField, false);
			$this.setAllowBlank(periodField, false);
		}
		

		
		
		form.getForm().isValid();
		form.getForm().clearInvalid();
	},
	
	onImportProgramCodeNameFieldChange: function(obj,records){
			if(obj.getValue().length > 0) {
					var progids=[];
				var programIds = null;
				var programId = obj.getValue();

				if (!isNullOrEmpty(programId) && programId.length > 0 && !isNullOrEmpty(programId[0])) {
					for (var i in programId) {
						if (Ext.isObject(programId[0])) {
							progids.push(programId[i].get("id"));
						} else {
							progids.push(programId[i]);
						}
					}
					programIds = progids.join();
				}
				else if(!isNullOrEmpty(programId)){
					programIds = programId;
				 }
				   } else {
 				 var programIds='';
				   }
			var $this = this;
			var structure =$this.getManageperiodenrollmentloaderstructure();
			var form = structure.down('#downloadPeriodEnrollmentformId');
			var academyLocationField = form.down('#academyLocationId');
			var academicTermField = form.down('#academicTermId');
			var aLId = academyLocationField.getValue();
			//var academicTermFieldValue = academicTermField.getValue();
			var academicTermFieldValue = academicTermField.getValue();
				var batch = form.down("#batchId");
				batch.setDisabled(true);
				batch.reset();
				if(programIds !=''){
					batch.setDisabled(false);

					var store = this.getStore('lecturercostingdefinition.ImportPeriodEnrollmentBatchStore');
					store.getProxy().extraParams = {
						programIds: programIds,
						academyLocationId:aLId,
						academicTermId:academicTermFieldValue,
						isActive:true
					};
					store.load();
				}
			},
			
			
			onImportBatchCodeNameFieldChange: function(obj,records){
  				var $this = this;
  				var structure =$this.getManageperiodenrollmentloaderstructure();
  				var form = structure.down('#downloadPeriodEnrollmentformId');
  				var academyLocationField = form.down('#academyLocationId');
  				var academicTermField = form.down('#academicTermId');
  				var programIds = form.down('#programId').getValue();
  				var aLId = academyLocationField.getValue();
  				//var academicTermFieldValue = academicTermField.getValue();
  				var academicTermFieldValue = academicTermField.getValue();
  				
  				
  				
  				var batchIds = null;
				var batchId = obj.getValue();
				var batchIdsArr=[];

				if (!isNullOrEmpty(batchId) && batchId.length > 0 && !isNullOrEmpty(batchId[0])) {
					for (var i in batchId) {
						if (Ext.isObject(batchId[0])) {
							batchIdsArr.push(batchId[i].get("id"));
						} else {
							batchIdsArr.push(batchId[i]);
						}
					}
					batchIds = batchIdsArr.join();
				}
				
				var programIdsArr = [];
				if(!isNullOrEmpty(programIds)) {
					Ext.each(programIds,function(rec){
						if(typeof rec=="number"){
							programIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							programIdsArr.push(rec.data.id);
						}
					});
				}
				
				var programIdsString = programIdsArr.join();
   				 if(batchIds.length > 0){
   					 var periodId = form.down('#periodId');
   					 periodId.clearValue();
   					 periodId.reset();
   					 periodId.setDisabled(false);
   					 var store = periodId.getStore();
   					 store.getProxy().extraParams = {
   						batchIds : batchIds,
   						programIds: programIdsString,
						academyLocationIds:aLId,
						academicTermIds:academicTermFieldValue
   					 };
   					 
   					 store.reload();
   				 }
   			 },
   			 
   			onImportPeriodCodeNameFieldChange: function(obj,records){
  				var $this = this;
  				var structure =$this.getManageperiodenrollmentloaderstructure();
  				var form = structure.down('#downloadPeriodEnrollmentformId');
  				var academyLocationField = form.down('#academyLocationId');
  				var academicTermField = form.down('#academicTermId');
  				var programIds = form.down('#programId').getValue();
  				var batchIds = form.down('#batchId').getValue();
  				var aLId = academyLocationField.getValue();
  				//var academicTermFieldValue = academicTermField.getValue();
  				var academicTermFieldValue = academicTermField.getValue();
  				
  				
  				
  				var periodIds = null;
				var periodId = obj.getValue();
				var periodIdsArr=[];

				if (!isNullOrEmpty(periodId) && periodId.length > 0 && !isNullOrEmpty(periodId[0])) {
					for (var i in periodId) {
						if (Ext.isObject(periodId[0])) {
							periodIdsArr.push(periodId[i].get("id"));
						} else {
							periodIdsArr.push(periodId[i]);
						}
					}
					periodIds = periodIdsArr.join();
				}
				
				var programIdsArr = [];
				if(!isNullOrEmpty(programIds)) {
					Ext.each(programIds,function(rec){
						if(typeof rec=="number"){
							programIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							programIdsArr.push(rec.data.id);
						}
					});
				}
				
				var programIdsString = programIdsArr.join();
				
				var batchIdsArr = [];
				if(!isNullOrEmpty(batchIds)) {
					Ext.each(batchIds,function(rec){
						if(typeof rec=="number"){
							batchIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							batchIdsArr.push(rec.data.id);
						}
					});
				}
				
				var batchIdsString = batchIdsArr.join();
				
   				 if(periodIds.length > 0){
   					 var section = form.down('#sectionId');
   					section.clearValue();
   					section.reset();
   					section.setDisabled(false);
   					 var store = section.getStore();
   					 store.getProxy().extraParams = {
   						batchIds : batchIdsString,
   						programIds: programIdsString,
   						periodIds:periodIds,
						academyLocationIds:aLId,
						academicTermIds:academicTermFieldValue
   					 };
   					 
   					 store.reload();
   				 }
   			 },
   			 
   			resetFormFields:function(btn){
   				var $this = this;
   				var structure =$this.getManageperiodenrollmentloaderstructure();
  				var filter = structure.down('#downloadPeriodEnrollmentformId');
   				var academyLocationField=filter.down('#academyLocationId');
   				var academicTermField=filter.down('#academicTermId');
   				var programField=filter.down('#programId');
   				var batchField=filter.down('#batchId');
   				var periodField=filter.down('#periodId');
   				var sectionField=filter.down('#sectionId');
   				var statusField=filter.down('#statusId');
   				var academyLocationStore = academyLocationField.getStore();
   				var academicTermStore = academicTermField.getStore();
   				var academyLocationId=this.getCurrentAcademyLocation();
   				
   				academyLocationField.clearValue();
   				academicTermField.clearValue();
   				programField.clearValue();
   				batchField.clearValue();
   				periodField.clearValue();
   				sectionField.clearValue();
   				statusField.clearValue();
   				
   				academyLocationField.reset();
   				academicTermField.reset();
   				programField.reset();
   				batchField.reset();
   				periodField.reset();
   				sectionField.reset();
   				statusField.reset();
   				
   				
   				programField.setDisabled(true);
   				batchField.setDisabled(true);
   				periodField.setDisabled(true);
   				sectionField.setDisabled(true);
   				
   				academyLocationField.setValue(academyLocationId);
   				academicTermStore.getProxy().extraParams.academyLocationId=academyLocationId;
   				academicTermStore.load();
   				
   			},
   			
   			/*loadImportPeriodEnrollmentGrid: function() {
				var grid = this.getImportutilityperiodenrollment();
				var form = this.getUploadoptionradiogroup();
				var isUploadAll = form.items.items[0].getValue().isUploadAll;
				this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_PERIOD_ENROLLMENT');
			},*/
			
			getStudentPeriodEnrollmentDownloadFile: function(documentId, fileType) {
				if (!isNullOrEmpty(documentId)) {
				var csvForm = Ext.create('Ext.form.Panel');
				csvForm.getForm().submit({
				target: '_blank',
				method: 'POST',
				params: {
					access_token: Ext.Ajax.defaultHeaders.access_token
				},
				headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
				url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
				standardSubmit: true
			});
		}
	},
   		
	getStudentPeriodEnrollmentUploadtemplate: function(obj) {
		var temForm = obj.up('uploadperiodenrollmentform');
		var tempFormValue = temForm.getForm().findField('importUtilityMasterId').getValue();
		var $this = this;
		var grdStore;
		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		$this.getHashOfFile(temForm);
		setTimeout(function() {
			temForm.getForm().submit({
				method: 'POST',
				url: submitUrl,
				success: function(form, action) {
					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
					temForm.getForm().isValid();
				},
				failure: function(form, action) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CONTENT_MISMATCH'));
				}
			});
		}, 1000);
		Ext.defer(function() {
			$this.loadImportPeriodEnrollmentGrid();
		}, 2000, this);
	},
	
	loadImportPeriodEnrollmentGrid: function() {
		var grid = this.getImportutilityperiodenrollment();
		var form = this.getUploadoptionradiogroup();
		var isUploadAll = form.items.items[0].getValue().isUploadAll;
		this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_PERIOD_ENROLLMENT');
	},

});