/**
 *  @author Amit Gupta
 * 
 */
Ext.app.profileUpdateButtonsDisable = false;
Ext.define('Academia.controller.coursetransaction.studentperiodenrollment.StudentPeriodRegistrationController', {
	extend : 'Academia.controller.base.BaseController',
	mixins: ['Academia.controller.menu.CoreERPNavigationController', 'Academia.controller.personinfo.student.StudentPersonalController'],
	models : [],
	stores : [
		'coursetransaction.manageperiodenrollment.StudentPortalProgramPeriodEnrollGridStore',
		'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
		'coursetransaction.manageperiodenrollment.StudentRegistrationDocumentGridStore',
		'common.ExamPassedStore',
		'common.ExamBoardStore',
		'campaignnew.CampaignSchoolStore',
		'admission.applications.history.StudyModes',
		'admission.applications.history.MediumOfInstructionsStore',
		'personinfo.common.pasthistory.ApplicantEducationMonthStore',
		'personinfo.common.pasthistory.ApplicantEducationYearStore',
		'admission.applications.history.EducationGradAndMarks',
		'admission.applications.history.ResultStatus',
		'common.EducationHistorySubjectStore',
		'common.EducationHistoryGradeStore',
		'enquiry.AcademicBatchStore', 'Academia.store.feeandpayment.FeePaymentTerm',
		'coursetransaction.manageperiodenrollment.PncRegistrationPaymentDetailsGridStore'
	],
	views : [
		'coursetransaction.studentperiodenrollment.StudentPeriodRegistrationStructure',
		'coursetransaction.studentperiodenrollment.StudentPeriodEnrollmentSearch',
		'coursetransaction.studentperiodenrollment.StudentPeriodEnrollmentList',
		'coursetransaction.studentregistration.StudentRegistrationDocumentGrid',
		'coursetransaction.studentregistration.StudentRegistrationDocumentUploadWindow',
		'coursetransaction.studentregistration.PncRegistrationPaymentDetailsGrid',
		'coursetransaction.studentperiodenrollment.StudentPaymentDetialsRegistrationStructure',
		'studentPortal.StudentPortalRegistrationContractWindow',
		'coursetransaction.studentregistration.StcPncStudentRegistration'
	],
	                   
	                   config:{
	                	   STUDENT_PERIOD_REGISTRATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PERIOD_REGISTRATION_PRIVILEGES'),
	                	   PARENT_PORTAL_STUDENT_PERIOD_REGISTRATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_PERIOD_REGISTRATION_PRIVILEGES'),
	                	   STUDENT_REGISTRATION_PAYMENT_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REGISTRATION_PAYMENT_DETAILS_PRIVILEGES')
	                	   
	                   },

	                   refs :[{
	                	   ref : 'contentPanel',
	                	   selector : 'contentPanel'
	                   },{
	                	   ref : 'studentperiodregistrationstructure',
	                	   selector : 'studentperiodregistrationstructure'
	                   },{
	                	   ref : 'studentperiodenrollmentlist',
	                	   selector : 'studentperiodenrollmentlist'
	                   },{
	                	   ref : 'studentperiodenrollmentsearch',
	                	   selector : 'studentperiodenrollmentsearch'
	                   },{
	                	   ref : 'studentregistrationdocumentgrid',
	                	   selector : 'studentregistrationdocumentgrid'
	                   },{
	                	   ref : 'studentregistrationdocumentuploadwindow',
	                	   selector : 'studentregistrationdocumentuploadwindow'
	                   },{
	                	   ref : 'studentperiodregistration',
	                	   selector : 'studentperiodregistration'
	                   },{
	                	   ref: 'pncregistrationpaymentdetailsgrid',
	                	   selector: 'pncregistrationpaymentdetailsgrid'
	                   },{
	                	   ref: 'studentpaymentdetialsregistrationstructure',
	                	   selector: 'studentpaymentdetialsregistrationstructure'
	                   },{
	                	   ref: 'studentportalregistrationcontractwindow',
	                	   selector: 'studentportalregistrationcontractwindow'
	                   }, {
	                	   ref: 'stcpncstudentregistration',
	                	   selector: 'stcpncstudentregistration'
	                   }],

	                   init : function() {
	                	   this.control({
	                		   'studentperiodregistration':{
	                			   afterrender : function(structure){
	                				   //var grid = structure.down('studentperiodenrollmentlist');
	                				   //this.getGridHeaderFreeze(grid,structure,true);
	                			   }
	                		   },
	                		   'studentperiodregistrationstructure':{
	                			   beforerender:function(){
	                				   this.getManageperiodenrollmentlist().getStore().removeAll();
	                				   // this.doAccessControlValidation(this.getManageperiodenrollmentlist(), this.getMANAGE_DISTRIBUTION_LIST_PERMISSIONS());
	                			   },
	                			   afterrender : function(structure){
	                				   var grid = structure.down('studentperiodenrollmentlist');
	                				   this.getGridHeaderFreeze(grid,structure,true);
	                			   }
	                		   },
	                		   'stcpncstudentregistration tabpanel[itemId=stcPncStudentRegistration] tabpanel':{
	                			   afterrender: function(){
	                				   var me = this;
	                				   var studentperiodenrollmentsearch = me.getStudentperiodenrollmentsearch();
	                				   
	                				   studentperiodenrollmentsearch.fireEvent('afterrender', studentperiodenrollmentsearch);
	                				  
	                			   }
	                		   },
	                		   'studentperiodenrollmentlist button[itemId=save]' : {
	                			   click : function() {
	                				   var $this = this;
	                				   var searchForm = this.getStudentperiodenrollmentsearch();
	                				   var searchStore = searchForm.down("#studentProgramId").getStore();
                  					   var registrationProcessReq = searchStore.data.items[0].data.registrationProcessReq;
                  					   var grid = this.getStudentperiodenrollmentlist();
	                				   var records = grid.getSelectionModel().getSelection();
	                				   var whetherOptionalPeriod=false;
	                				   //var courseRegistrationController = Academia.app.getController('Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController');
	                				   var portalId = $this.getCurrentLoggedPortalId();
	                				   if(portalId==7){
	                					   var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	                					   var user = portalInfo.student;
	                				   } else {
	                					   var user=$this.getCurrentlyLoggedInUser();
	                				   }
	                				   if (records.length > 0) {
	                					   var id= records[0].data.programBatchStudentId;
	                					   var whetherAutoApproved=records[0].data.whetherAutoApproved;
	                					   whetherOptionalPeriod=records[0].data.whetherOptional;
	                					   var paymentTermId = '';
	                					   if(!isNullOrEmpty(records[0].data.paymentTerm)){
	                						   paymentTermId = records[0].data.paymentTerm;
	                					   }
	                					   
	                					   var isPaymentTermColumnVisible = false;
	                					   
	                					   Ext.each(grid.columnManager.columns, function(currentColumn){
	                						   if(currentColumn.dataIndex == 'paymentTerm' && currentColumn.hidden == false){
	                							   isPaymentTermColumnVisible = true;
	                						   }
	                					   })
	                					   
	                					   if(paymentTermId && isPaymentTermColumnVisible == true){
	                						   Ext.MessageBox.confirm({
	                							     title:getCommonTranslation("CONFIRMATION_REQUIRED"),
	                							     cls: 'warningMessageBox commonMsgBoxCls',
	                							     msg: "<b>"+records[0].data.paymentTermName+"</b> "+ getCommonTranslation("PAYMENT_TERM_CONFIRM_MSG"),
	                							     buttons: Ext.Msg.YESNO,
	                							     icon: Ext.Msg.WARNING,
	                							     buttonText : {
	                							    	 yes : getCommonTranslation('YES_CONTINUE'),
	                							    	 no : getCommonTranslation("CANCEL")
	                							     },
	                							     callback: function(btn, text){
	                							    	 if (btn == 'yes') {
	                							    		 $this.onPeriodRegistrationGridEnrollBtnClick(grid, whetherAutoApproved, whetherOptionalPeriod, id, records, portalId, user, paymentTermId);
	                							    	 }
	                							     }
	                							});
	                					   }
	                					   else{
	                						   $this.onPeriodRegistrationGridEnrollBtnClick(grid, whetherAutoApproved, whetherOptionalPeriod, id, records, portalId, user, paymentTermId);
	                					   }
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   'studentperiodenrollmentsearch customcombobox#studentProgramId' : {
	                			   select: function(combo, records, eOpts) {
	                				   var me = this;
	                				   var form=me.getStudentperiodenrollmentsearch();

	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var studentProgramField = form.down("#studentProgramId");
	                				   var studentBatchField = form.down("#studentBatchId");

	                				   var studentALStore = studentALField.getStore();
	                				   var studentProgramStore = studentProgramField.getStore();
	                				   var studentBatchStore = studentBatchField.getStore();

	                				   var portalId = me.getCurrentLoggedPortalId();
	                				   var currentALId = me.getCurrentAcademyLocation();
	                				   var academyLoc = studentALField.getValue();
	                				   if(portalId==7){
	                					   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                					   var admissionDetails=portalInfo.admissionDetails;
	                				   } else {
	                					   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                					   var admissionDetails=portalInfo.admissionDetails;
	                				   }
	                				   
		                				 if(portalId==7){
    									   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var user = portalInfo.student;
    								   } else {
    									   var user=me.getCurrentlyLoggedInUser();
		                				 }

	                				   var admissionId = studentProgramStore.findRecord('programId',studentProgramField.getValue()).data.admissionId;
						    			 
	                				   studentBatchStore.getProxy().extraParams.admissionId = admissionId;
	                				   studentBatchStore.getProxy().extraParams.programId = studentProgramField.getValue();

									   studentBatchField.reset();
									   studentBatchField.setDisabled(true);
									   
									   studentBatchStore.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length == 1){
													   studentBatchField.setValue(records[0].data.id);
		                				 }
												   studentBatchField.setDisabled(false);
		                				 }
		                				 }
									   });
									   studentProgramStore.load({
                                           callback: function(records, operation, success) {
                                               if (success) {
                                                   if(records.length > 0){
                                                       if(portalId==3 || portalId==7){
                                                           if(!isNullOrEmpty(Ext.ComponentQuery.query('stcpncstudentregistration')[0])){
                                                               var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
                                                               var getstructureTabs = getstructure.down('tabpanel');
                                                               getstructure.programStoreRecord = records;
                                                               //--------
                                                               var batchIds = null;
                                                               var admissionIds = admissionId;
                                                                  var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
                                                                  
                                                                  if(getstructure && getstructure.programStoreRecord.length && getstructure.down('#stcPncStudentRegistration')){
                                                                      batchIds = Ext.Array.pluck(Ext.Array.pluck(getstructure.programStoreRecord,'data'),'batchId').join();
                                                                  }
                                                                  allPaymentTerms=null;
                                                                  Ext.Ajax.request({
                                                                      type : 'rest',
                                                                      url : SERVERURL.FIND_PAYMENT_TERM_BY_ADMISSION_ID_AND_PERIOD_ID,
                                                                      params : {
                                                                          admissionId:admissionIds,
                                                                          periodId:null,
                                                                          batchIds: batchIds,
                                                                          academyLocationId:academyLoc
                                                                      },
                                                                      method : 'GET',
                                                                      success : function(response) {
                                                                          var data = Ext.decode(response.responseText);
                                                                          //paymentTermComboStore.removeAll();
                                                                          allPaymentTerms = data;
                                                                          //paymentTermComboStore.loadData(data);
                                                                      }
                                                                  });
                                                           }
                                                       }
                                                   }
                                               }
                                           }
                                       });
	                               }
	                		   },
	                		   'studentperiodenrollmentsearch button[itemId=searchBtn]':{
		                			 click :function(obj){ 
		                				 this.loadStudentOptPeriodEnrollGrid();
		                			 }
		                		 },
		                		 'studentperiodenrollmentsearch button[itemId=resetBtn]':{
		                			 click :function(obj){ 
		                				 var me = this;
		                				 var form  = me.getStudentperiodenrollmentsearch();

		                				 form.getForm().reset();
		                				 
		                				 var studentALField = form.down("#studentAcademyLocation");
		                				 var studentProgramField = form.down("#studentProgramId");
		                				 var studentBatchField = form.down("#studentBatchId");
		                				 
		                				 var studentALStore = studentALField.getStore();
		                				 var studentProgramStore = studentProgramField.getStore();
		                				 var studentBatchStore = studentBatchField.getStore();
		                				 
		                				 var portalId = me.getCurrentLoggedPortalId();
		                				 var currentALId = me.getCurrentAcademyLocation();
		                				 
									     if(portalId==7){
		                					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var admissionDetails=portalInfo.admissionDetails;
		                				 } else {
		                					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var admissionDetails=portalInfo.admissionDetails;
		                			 }
									      
									     var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();
		                				 
									     studentALStore.getProxy().extraParams = {
		                					 admissionIds:admissionIds
		                				 };
									     
									     studentBatchField.reset();
										 studentBatchField.setDisabled(true);
									     
									     studentALStore.load({
									    	 callback: function(records, operation, success) {
									    		 if (success) {
									    			 if(records.length > 0){
									    				 studentALField.setValue(currentALId);
									    				 
									    				 if(portalId==7){
									    					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
									    					 var user = portalInfo.student;
									    				 } else {
									    					 var user=me.getCurrentlyLoggedInUser();
									    				 }

									    				 studentProgramStore.getProxy().extraParams = {
									    					 studentId:user.id,
									    					 onlyCurrentRecords: true,
									    					 academyLocationId: currentALId
						                				 };
									    				 
									    				 studentProgramStore.load({
													    	 callback: function(records, operation, success) {
													    		 if (success) {
													    			 var admissionId = studentProgramStore.findRecord('programId',records[0].data.programId).data.admissionId;
													    			 studentBatchStore.getProxy().extraParams.admissionId = admissionId;
													    			 if(records.length > 0){
													    				 if(records.length == 1){
													    					 studentProgramField.setValue(records[0].data.programId);
													    					 studentBatchStore.getProxy().extraParams.programId = records[0].data.programId;
													    					 

															    			 
															    			 studentBatchStore.load({
											                					 callback: function(records, operation, success) {
											                						 if (success) {
											                							 if(records.length == 1){
											                								 studentBatchField.setValue(records[0].data.id);
											                							 }
																    					 studentBatchField.setDisabled(false);
											                						 }
											                					 }
															    			 });
													    				 }
													    			 }
													    		 }
													    	 }
									    				 });
									    			 }		 
									    		 }
									    	 }
									     });
		                				 
		                			 }
		                		 },
		                		 'studentperiodenrollmentsearch':{
		                			 afterrender : function(form){
		                				 
		                				 if(form.isAfterRenderCalled){
		                					 return;
		                				 }
		                				 form.isAfterRenderCalled = true;
		                				 
		                				 var me = this;
		                				 var studentALField = form.down("#studentAcademyLocation");
		                				 var studentProgramField = form.down("#studentProgramId");
		                				 var studentBatchField = form.down("#studentBatchId");
		                				 var contentpanel= Ext.ComponentQuery.query('contentpanel')[0];
		                				 var studentALStore = studentALField.getStore();
		                				 var studentProgramStore = studentProgramField.getStore();
		                				 var studentBatchStore = studentBatchField.getStore();
		                				 var isRenderInit = true; //to manage initial render functionality

		                				 var portalId = me.getCurrentLoggedPortalId();
		                				 var currentALId = me.getCurrentAcademyLocation();

		                				 if(portalId==7){
		                					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var admissionDetails=portalInfo.admissionDetails;
		                				 } else {
		                					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var admissionDetails=portalInfo.admissionDetails;
		                				 }

		                				 var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

		                				 studentALStore.getProxy().extraParams = {
		                					 admissionIds:admissionIds
		                				 };

		                				 studentBatchField.reset();
		                				 studentBatchField.setDisabled(true);

		                				 studentALStore.load({
		                					 callback: function(records, operation, success) {
		                						 if (success) {
		                							 if(records.length > 0){
		                								 studentALField.setValue(currentALId);

		                								 if(portalId==7){
		                									 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                									 var user = portalInfo.student;
		                								 } else {
		                									 var user=me.getCurrentlyLoggedInUser();
		                								 }

		                								 studentProgramStore.getProxy().extraParams = {
		                									 studentId:user.id,
		                									 academyLocationId: currentALId,
		                									 onlyCurrentRecords: true
		                								 };

		                								 studentProgramStore.load({
		                									 callback: function(records, operation, success) {
		                										 if (success) {
		                											 var admissionId = studentProgramStore.findRecord('programId',records[0].data.programId).data.admissionId;
		                											 studentBatchStore.getProxy().extraParams.admissionId = admissionId;
		                											 if(records.length > 0){
		                												 if(records.length == 1){
		                													 studentProgramField.setValue(records[0].data.programId);
		                													 studentBatchStore.getProxy().extraParams.programId = records[0].data.programId;

		                													 studentBatchStore.load({
		                														 callback: function(records, operation, success) {
		                															 if (success) {
		                																 if(records.length == 1){
		                																	 studentBatchField.setValue(records[0].data.id);

		                																	 Ext.Ajax.request({
		                																		 url : SERVERURL.PATH_FIND_ALL_TERM_WISE_PERIOD_REGISTRATION_SETUP_BY_BATCHID+'?batchId='+records[0].data.id,
		                																		 headers: {
		                																			 'Content-Type': 'application/json'
		                																		 },
		                																		 method : 'GET',
		                																		 success : function(response) {
		                																			 Ext.getBody().unmask();
		                																			 var responseJson = Ext.decode(response.responseText);
		                																			 var warningMessage = "";
		                																			 for(var j=0;j<responseJson.length;j++){
		                																				 if(!isNullOrEmpty(responseJson[j].programPeriodName)){
		                																					 var today = new Date().getTime(); 
		                																					 var starDate= responseJson[j].periodStartDate;
		                																					 var endDate= responseJson[j].periodEndDate;
		                																					 if(today >= starDate && endDate >= today){
		                																						 if(warningMessage == ""){
		                																							 warningMessage += ""+responseJson[j].programPeriodName+" "+getCommonTranslation('PERIOD_REGISTRATION_OPEN');
		                																						 } else{
		                																							 warningMessage += ""+responseJson[j].programPeriodName+" "+getCommonTranslation('PERIOD_REGISTRATION_OPEN');
		                																						 }
		                																					 }
		                																				 }
		                																			 }
		                																			 if(warningMessage != ""){
		                																				 showWarningMessage(getCommonTranslation('STUDENT_PERIOD_ENROLLMENT'),warningMessage);
		                																			 }

		                																		 }
		                																	 });

		                																	 if(portalId==3 || portalId==7){
		                																		 if(records.length>0){
		                																			 /* if(!isNullOrEmpty(Ext.ComponentQuery.query('stcpncstudentregistration')[0])){
												                										 var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
												                										 var getstructureTabs = getstructure.down('tabpanel');
												                										 if(records[0].data.registrationProcessReq == true){
												                											 getstructureTabs.setActiveTab(0); 
												                										 }else{
												                											 getstructureTabs.setActiveTab(1);
												                										 }
												                									 }	*/
		                																		 }  
		                																	 }
		                																 }
		                																 studentBatchField.setDisabled(false);
		                															 }
		                														 }
		                													 });



		                												 }

		                												 //----
		                												 var isNextPreviousButtonEnable = false;

		                												 var isProfileUpdateApplicable = false;
		                												 var isDocumentApplicable = false;
		                												 var profileUpdateRecord = [];
		                												 var documentUpdateRecord = [];
		                												 var registrationRulesApplicable = false;
		                												 var registrationRules = {
		                														 additionalModuleApplicable: false,
		                														 coRequisite: false,
		                														 courseGroup: false,
		                														 forceRepeatitionOfModules: false,
		                														 minMaxCredit: false,
		                														 minMaxModules: false,
		                														 mutualyExclusive: false,
		                														 preRequisite: false,
		                														 sectionCapacity: false,
		                														 timeTableClash: false,
		                														 examTimeTableConflict: false,
		                														 yearlyRegistrationsApplicable: false,
		                														 paymentTermMandatory: false,
														 						 maximumModuleGroup: (records.length && records[0].raw) ? records[0].raw.maximumModuleGroup : null,
														 						minimumModuleGroup: (records.length && records[0].raw) ? records[0].raw.minimumModuleGroup : null
		                												 };
		                												 var registrationValidations = {
		                														 mandatoryChecksBypass:false,
		                														 minCoursesCourseGroupChecksBypass:false,
		                														 yearlyMinCreditChecksBypass:false,
		                														 minCreditChecksForCourseGroupBypass:false,
		                														 minCourseGroupChecksBypass:false
		                												 };
		                												 
		                												 Ext.each(records, function(currentRecord){
		                													 if(currentRecord.data.registrationProcessReq == true){
		                														 registrationRulesApplicable = true;
		                														 if(!isNullOrEmpty(currentRecord.raw['registrationSetupId'])){
		                															 registrationRules.registrationSetupId = currentRecord.raw['registrationSetupId'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Additional Course Applicable'])){
		                															 registrationRules.additionalModuleApplicable = currentRecord.raw['Additional Course Applicable'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Co-requisite'])){
		                															 registrationRules.coRequisite = currentRecord.raw['Co-requisite'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Course Group'])){
		                															 registrationRules.courseGroup = currentRecord.raw['Course Group'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Force Repetition of Course'])){
		                															 registrationRules.forceRepeatitionOfModules = currentRecord.raw['Force Repetition of Course'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Minimum & Maximum No. of Credits'])){
		                															 registrationRules.minMaxCredit = currentRecord.raw['Minimum & Maximum No. of Credits'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Minimum & Maximum No. of Course'])){
		                															 registrationRules.minMaxModules = currentRecord.raw['Minimum & Maximum No. of Course'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Mutually Exclusive'])){
		                															 registrationRules.mutualyExclusive = currentRecord.raw['Mutually Exclusive'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Pre-Requisite'])){
		                															 registrationRules.preRequisite = currentRecord.raw['Pre-Requisite'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Section Capacity'])){
		                															 registrationRules.sectionCapacity = currentRecord.raw['Section Capacity'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Time Table Conflict'])){
		                															 registrationRules.timeTableClash = currentRecord.raw['Time Table Conflict'];
		                														 }
		                														 if(!isNullOrEmpty(currentRecord.raw['Yearly Registrations Applicable'])){
		                															 registrationRules.yearlyRegistrationsApplicable = currentRecord.raw['Yearly Registrations Applicable'];
		                														 }
																				 if(!isNullOrEmpty(currentRecord.raw['Payment Term Mandatory'])){
				        															 registrationRules.paymentTermMandatory = currentRecord.raw['Payment Term Mandatory'];
				        														 }
																				 if(!isNullOrEmpty(currentRecord.raw['Exam Timetable Conflict'])){
				        															 registrationRules.examTimeTableConflict = currentRecord.raw['Exam Timetable Conflict'];
				        														 }

																				 if(!isNullOrEmpty(currentRecord.raw['mandatoryChecksBypass'])){
																					 registrationValidations.mandatoryChecksBypass = currentRecord.raw['mandatoryChecksBypass'];
				        														 }
																				 if(!isNullOrEmpty(currentRecord.raw['minCoursesCourseGroupChecksBypass'])){
																					 registrationValidations.minCoursesCourseGroupChecksBypass = currentRecord.raw['minCoursesCourseGroupChecksBypass'];
				        														 }
																				 if(!isNullOrEmpty(currentRecord.raw['yearlyMinCreditChecksBypass'])){
																					 registrationValidations.yearlyMinCreditChecksBypass = currentRecord.raw['yearlyMinCreditChecksBypass'];
				        														 }
																				 if(!isNullOrEmpty(currentRecord.raw['minCreditChecksForCourseGroupBypass'])){
																					 registrationValidations.minCreditChecksForCourseGroupBypass = currentRecord.raw['minCreditChecksForCourseGroupBypass'];
				        														 }
																				 if(!isNullOrEmpty(currentRecord.raw['minCourseGroupChecksBypass'])){
																					 registrationValidations.minCourseGroupChecksBypass = currentRecord.raw['minCourseGroupChecksBypass'];
				        														 }
		                													 }
		                													 if(currentRecord.data.registrationProcessReq == true && currentRecord.data.isProfileUpdateApplicable == true){
		                														 isProfileUpdateApplicable = true;
		                														 profileUpdateRecord.push(currentRecord);
		                													 }

		                													 if(currentRecord.data.isDocumentApplicable  == true){
		                														 isDocumentApplicable = true;
		                														 documentUpdateRecord.push(currentRecord);
		                													 }
		                												 });

		                												 if(isProfileUpdateApplicable == true && isDocumentApplicable == true){
		                													 isNextPreviousButtonEnable = true;
		                												 }


		                												 if(portalId==3 || portalId==7){
		                													 if(!isNullOrEmpty(Ext.ComponentQuery.query('stcpncstudentregistration')[0])){
		                														 var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
		                														 var getstructureTabs = getstructure.down('tabpanel');
	                															 getstructure.programStoreRecord = records;
	                															 getstructure.registrationRulesApplicable = registrationRulesApplicable;
	                															 getstructure.registrationRules = registrationRules;
	                															 getstructure.registrationValidations = registrationValidations;
	                															 //--------
	                															 var batchIds = null;
	                															 var admissionIds = null;
	                																var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
	                																
	                																if(getstructure && getstructure.programStoreRecord.length && getstructure.down('#stcPncStudentRegistration')){
	                													    			batchIds = Ext.Array.pluck(Ext.Array.pluck(getstructure.programStoreRecord,'data'),'batchId').join();
	                																	admissionIds = getstructure.programStoreRecord[0].data.admissionId;
	                																}
	                																
	                																Ext.Ajax.request({
	                																	type : 'rest',
	                																	url : SERVERURL.FIND_PAYMENT_TERM_BY_ADMISSION_ID_AND_PERIOD_ID,
	                																	params : {
	                																		admissionId:admissionIds,
	                																		periodId:null,
	                																		batchIds: batchIds
	                																	},
	                																	method : 'GET',
	                																	success : function(response) {
	                																		var data = Ext.decode(response.responseText);
	                																		//paymentTermComboStore.removeAll();
	                																		allPaymentTerms = data;
	                																		//paymentTermComboStore.loadData(data);
	                																	}
	                																});
	                															 //--------
	                															 
		                														 if(getstructureTabs.getActiveTab().xtype != "studentperiodregistration" && getstructureTabs.getActiveTab().xtype != "studentportalcourseregistrationtab"){
		                															 /*if(records[0].data.registrationProcessReq == true){
												    									 getstructureTabs.setActiveTab(0); 
												    								 }else{
												    									 getstructureTabs.setActiveTab(1);
												    								 }*/

		                															 getstructure.isProfileUpdateApplicable = isProfileUpdateApplicable;
		                															 getstructure.isDocumentApplicable = isDocumentApplicable;

		                															 if(isProfileUpdateApplicable === true) {
		                																 //var me = $this,
		                																 var tabPanel =contentpanel.down('#stcPncStudentRegistration');

		                																 if(tabPanel){
		                																	 var cerpController = me,//.getController('menu.CoreERPNavigationController'),
		                																	 pncProfileUpdateTabTitle = getCommonTranslation('PNC_PROFILE_UPDATE'),
		                																	 pncRegistrationTabTitle = getCommonTranslation('PNC_REGISTRATION_DOCUMENTS'),
		                																	 pncProfileUpdateTab = cerpController.getInnerTab(tabPanel,pncProfileUpdateTabTitle),
		                																	 pncRegistrationTab = cerpController.getInnerTab(tabPanel,pncRegistrationTabTitle),
		                																	 todayDate = new Date(),
		                																	 tabPanelItems = [],
		                																	 tabIndex = 0, 
		                																	 currentTabItemXtype = '',
		                																	 currentTabItemId = '',
		                																	 startDate, endDate, termWiseProfileLink, 
		                																	 sortedProfileLinks, sortedProfileLinksArray, saveButtonItemId;

		                																	 pncProfileUpdateTab.setDisabled(false); //enable tab

		                																	 if(pncProfileUpdateTab.items && pncProfileUpdateTab.items.items.length == 0 ){
		                																		 Ext.Ajax.request({
		                																			 url : SERVERURL.PATH_GET_STUDENT_PROFILE_LINK_DETAILS+'?periodId='+profileUpdateRecord[0].data.periodId,
		                																			 headers: {
		                																				 'Content-Type': 'application/json'
		                																			 },
		                																			 method : 'GET',
		                																			 success : function(response) {
		                																				 Ext.getBody().unmask();
		                																				 var responseJson = Ext.decode(response.responseText);
		                																				 if(responseJson.length>0){
		                																					 startDate = responseJson[0].startDate
		                																					 endDate = responseJson[0].endDate

		                																					 if(todayDate.getTime() < startDate){
		                																						 pncProfileUpdateTab.on('activate', function(){
		                																							 showWarningMessage(getCommonTranslation('ALERT'), 'The profile update is starting from '+ responseJson[0].startDate +' - '+ responseJson[0].endDate);
		                																						 });
		                																					 } else if(todayDate.getTime() > endDate){
		                																						 pncProfileUpdateTab.on('activate', function(){
		                																							 showWarningMessage(getCommonTranslation('ALERT'), 'The profile update end date is passed. Please contact the admin or raise the service request for the same.');
		                																						 });
		                																					 }

		                																					 termWiseProfileLink = responseJson[0].termWiseProfileLink;
		                																					 sortedProfileLinks = responseJson[0].termWiseProfileLink.sort(function (a, b) {
		                																						 return a.sequenceNo - b.sequenceNo;
		                																					 });
		                																					 sortedProfileLinksArray = Ext.Array.pluck(sortedProfileLinks, "linkName");

		                																					 Ext.each(sortedProfileLinksArray, function(currentTabItem){
		                																						 switch (currentTabItem) {
		                																						 case 'Personal':
		                																							 currentTabItemXtype = 'personalinformationform';
		                																							 currentTabItemId = 'studentPersonalInformationForm';
		                																							 saveButtonItemId = 'personalInfoSaveButtonId';
		                																							 break;
		                																						 case 'Address':
		                																							 currentTabItemXtype = 'addressdetails';
		                																							 currentTabItemId = 'studentAddressDetails';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Parents':
		                																							 currentTabItemXtype = 'parentguardiangrid';
		                																							 currentTabItemId = 'studentParentGuardianGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Fee Payer Details':
		                																							 currentTabItemXtype = 'feepayerdetailgrid';
		                																							 currentTabItemId = 'studentFeePayerDetailGridItemId';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Siblings':
		                																							 currentTabItemXtype = 'siblingdetailsgrid';
		                																							 currentTabItemId = 'studentSiblingDetailsGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Education':
		                																							 currentTabItemXtype = 'educationhistorygrid';
		                																							 currentTabItemId = 'studentEducationHistoryGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Competitive Exam':
		                																							 currentTabItemXtype = 'competitiveexamgrid';
		                																							 currentTabItemId = 'studentCompetitiveExamGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Work Experience':
		                																							 currentTabItemXtype = 'workexperiencegrid';
		                																							 currentTabItemId = 'studentWorkExperienceGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Medical Conditions':
		                																							 currentTabItemXtype = 'medicalgrid';
		                																							 currentTabItemId = 'studentMedicalGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Vaccination':
		                																							 currentTabItemXtype = 'vaccinationgrid';
		                																							 currentTabItemId = 'studentVaccinationGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 case 'Extracurricular':
		                																							 currentTabItemXtype = 'extracurriculargrid';
		                																							 currentTabItemId = 'studentExtraCurricularGrid';
		                																							 saveButtonItemId = '';
		                																							 break;
		                																						 }

		                																						 var newTempItem = {
		                																								 xtype: 'panel',
		                																								 currentTabItem: currentTabItem,
		                																								 title: getCommonTranslation("TAB_"+currentTabItem.toUpperCase().replaceAll(" ","_")), //V2D-399739-B
		                																								 tabIndexNumber: tabIndex,
		                																								 isSubmitbutton: true,
		                																								 isNextButton: ((tabIndex + 1) < sortedProfileLinksArray.length),
		                																								 isPreviousButton: ((tabIndex + 1) > 1), 
		                																								 saveButtonItemId: saveButtonItemId,
		                																								 autoScroll: true,
		                																								 items: [{
		                																									 xtype: currentTabItemXtype,
		                																									 itemId: currentTabItemId,
		                																									 resizable: false
		                																								 },{
		                																									 xtype: 'panel',
		                																									 itemId: 'innerTabButtonPanel'
		                																								 }],
		                																								 listeners: {
		                																									 afterrender: function(panel){
		                																										 if(panel.down('addressdetails')){
		                																											 panel.down('addressdetails').getHeader().hide();
		                																										 }
                                                                                                                                
		                																										 var innerTabButtonPanel = panel.down('#innerTabButtonPanel');
		                																										 var buttonJson = {
		                																												 xtype: 'button',
		                																												 buttonAlign: 'left',
		                																												 disabled: Ext.app.profileUpdateButtonsDisable
		                																										 };

		                																										 if(panel.isPreviousButton){
		                																											 buttonJson.text = getAdmissionTranslation('BACK');
		                																											 buttonJson.itemId = 'innerTabBackButton';
		                																											 buttonJson.ui = 'CustomBtnCancel';
		                																											 buttonJson.handler = me.innerTabBackButtonHandler;
		                																											 buttonJson.scope = me;
		                																											 buttonJson.hidden = !(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate);
		                																											 innerTabButtonPanel.add(buttonJson);
		                																										 }

		                																										 if(panel.isNextButton){
		                																											 buttonJson.text = getCommonTranslation('NEXT_SUBMIT_BTN');
		                																											 buttonJson.itemId = 'innerTabNextButton';
		                																											 buttonJson.ui = 'CustomBtnCancel';
		                																											 buttonJson.handler = me.innerTabNextButtonHandler;
		                																											 buttonJson.scope = me;
		                																											 buttonJson.hidden = !(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate);
		                																											 innerTabButtonPanel.add(buttonJson);
		                																											 innerTabButtonPanel.add({
		                	                                                                                                                xtype: "label",
		                	                                                                                                                flex: 1,
		                	                                                                                                                margin: "0 0 0 20",
		                	                                                                                                                style: {
		                	                                                                                                                    "font-weight": "bold",
		                	                                                                                                                    color: "#ff0a0a"
		                	                                                                                                                },
		                	                                                                                                                itemId: "errorMsgShow1",
		                	                                                                                                                hidden: !(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate),
		                	                                                                                                                text: getCommonTranslation("PLEASE_FILL_ALL_MANDATORY_DETAILS_CLICK_NEXT_SUBMIT")
		                	                                                                                                            })
		                																										 }
		                																										 else if(panel.isSubmitbutton){
		                																											 buttonJson.text = getCommonTranslation('NEXT_SUBMIT_BTN');
		                																											 buttonJson.itemId = 'innerTabSubmitButton';
		                																											 buttonJson.ui = 'CustomBtnCancel';
		                																											 buttonJson.handler = me.innerTabSubmitButtonHandler;
		                																											 buttonJson.scope = me;
		                																											 buttonJson.hidden = !(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate);
		                																											 innerTabButtonPanel.add(buttonJson);
		                																											 innerTabButtonPanel.add({
		                                                                                                                                 xtype: "label",
		                                                                                                                                 margin: "0 0 0 20",
		                                                                                                                                 style: {
		                                                                                                                                     "font-weight": "bold",
		                                                                                                                                     color: "#ff0a0a"
		                                                                                                                                 },
		                                                                                                                                 itemId: "errorMsgShow2",
		                                                                                                                                 cls: "registrationNoteCls",
		                                                                                                                                 text: getCommonTranslation("PLEASE_FILL_ALL_MANDATORY_DETAILS_CLICK_NEXT_SUBMIT")
		                                                                                                                             })
		                																										 }

		                																										 if(!isNullOrEmpty(panel.saveButtonItemId)){
		                																											 panel.down('#'+panel.saveButtonItemId).setVisible(false);
		                																											 /*panel.down('#'+panel.saveButtonItemId).on('enable',function(){
																    																	 Ext.app.profileUpdateButtonsDisable = false;
																    																	 //-- changing all buttons state
																    																	 me.changeAllButtonsStates();
																    																 });
																    																 panel.down('#'+panel.saveButtonItemId).on('disable',function(){
																    																	 Ext.app.profileUpdateButtonsDisable = true;
																    																	 //-- changing all buttons state
																    																	 me.changeAllButtonsStates();
																    																 });*/

		                																											 //-- changing all buttons state
		                																											 me.changeAllButtonsStates(null);
		                																										 }
		                																									 },
		                																									 activate: function(tab){
		                																										 //-- changing all buttons state
		                																										 me.changeAllButtonsStates(tab);
		                																									 }
		                																								 }
		                																						 };

		                																						 if(currentTabItemXtype === "parentguardiangrid") {
		                																							 //newTempItem.items.push({ xtype: "parentguardiancardlayoutview" });
		                																							 newTempItem.items.splice(1, 0, { xtype: "parentguardiancardlayoutview" });
		                																							 newTempItem.items.splice(0, 0, {
		                																	                        		xtype: 'panel',
		                																	                        		cls: 'registrationNoteCls',
		                																	                        		itemId: 'registrationParentNoteItemId',
		                																	                        		html: getCommonTranslation('PARENT_NOTE')
		                																	                        	});
		                																							 Ext.each(responseJson[0].termWiseProfileLink, function(curTermWiseProfileLink){
		                																								 if(curTermWiseProfileLink.linkName == "Parents" && curTermWiseProfileLink.registrationSetupParentDetails){
		                																									 newTempItem.registrationSetupParentDetails = curTermWiseProfileLink.registrationSetupParentDetails;
		                																								 }
		                																							 });
		                																						 }
		                																						 
		                																						 if(currentTabItemXtype === "feepayerdetailgrid") {
		                																							 newTempItem.items.splice(0, 0, {
		                																								 xtype: 'panel',
		                																								 cls: 'registrationNoteCls',
		                																								 itemId: 'registrationFeePayerNoteItemId',
		                																								 html: getCommonTranslation('FEEPAYER_NOTE')
		                																							 });
		                																						 }
		                																						 
		                																						 if(currentTabItemXtype === "addressdetails"){
		                																							 newTempItem.items.splice(0, 0, {
		                																								 xtype: 'panel',
		                																								 cls: 'registrationNoteCls',
		                																								 itemId: 'registrationAddressNoteItemId',
		                																								 html: getCommonTranslation('ADDRESS_NOTE')
		                																							 });
		                																							 Ext.each(responseJson[0].termWiseProfileLink, function(curTermWiseProfileLink){
		                																								 if(curTermWiseProfileLink.linkName == "Address" && curTermWiseProfileLink.registrationSetupAddress){
		                																									 newTempItem.registrationSetupAddress = curTermWiseProfileLink.registrationSetupAddress;
		                																								 }
		                																							 });
		                																						 }
		                																						 
		                																						 if(currentTabItemXtype === "personalinformationform"){
		                																							 newTempItem.items.splice(0, 0, {
		                																								 xtype: 'panel',
		                																								 cls: 'registrationNoteCls',
		                																								 itemId: 'registrationPersonalProfileNoteItemId',
		                																								 hidden:!(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate),
		                																								 html: getCommonTranslation('PERSONAL_PROFILE_NOTE')
		                																							 });
		                																							 Ext.Ajax.request({
		                                                                                                                 type: "rest",
		                                                                                                                 async: false,
		                                                                                                                 method: "GET",
		                                                                                                                 url: SERVERURL.PATH_FIND_ALL_ACADEMIC_TERM_ASCEDING_ORDER,
		                                                                                                                 success: function(au, ap) {
		                                                                                                                     var aw = Ext.decode(au.responseText);
		                                                                                                                     var aq = Academia.model.authentication.PortalInfoModel;
		                                                                                                                     var at = aq.get("programBatchDetails");
		                                                                                                                     var av;
		                                                                                                                     aw.forEach(function(ax) {
		                                                                                                                         if (ax.id == at.academicTermId) {
		                                                                                                                             av = ax.value
		                                                                                                                         }
		                                                                                                                     });
		                                                                                                                     var ar = getCommonTranslation("IMPORTANT_NOTE") +':'+ '<br><div style="margin-left: 20px;color: black;">' + getCommonTranslation("PROGRAM") + ": " + at.programName + '</div> <div style="color: black;margin-left: 20px">' + getCommonTranslation("PROGRAM_GROUP") + ": " + at.programGroupName + '</div><div style="color: black;margin-left: 20px">' + getCommonTranslation("ACADEMIC_YEAR") + ": " + av + '</div><div style="margin-left: 20px;">' + getCommonTranslation("INFORMATION_YOU_ARE_NOT_ELIGIBLE_FOR_REGISTRATION") + "</div>";
		                                                                                                                     newTempItem.items.splice(0, 0, {
		                                                                                                                         itemId: "registrationStopMsg",
		                                                                                                                         html: ar,
		                                                                                                                         hidden:(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate),
		                                                                                                                         xtype: "label",
		                                                                                                                         margin: "0 0 0 20",
		                                                                                                                         flex: 1,
		                                                                                                                         style: {
		                                                                                                                             "font-weight": "bold",
		                                                                                                                             color: "#ff0a0a"
		                                                                                                                         }
		                                                                                                                     })
		                                                                                                                 }
		                                                                                                             })
		                																						 }

		                																						 tabPanelItems.push(newTempItem);
		                																						 tabIndex = tabIndex + 1;
		                																					 });

		                																					 pncProfileUpdateTab.add(tabPanelItems);
		                																					 pncProfileUpdateTab.setActiveTab(0);
		                																					 if (!(todayDate.getTime() >= startDate && todayDate.getTime() <= endDate)) {
		                																						 pncProfileUpdateTab.items && pncProfileUpdateTab.items.items[1] && pncProfileUpdateTab.items.items[1].setDisabled(true);
		                																						 pncProfileUpdateTab.items && pncProfileUpdateTab.items.items[2] && pncProfileUpdateTab.items.items[2].setDisabled(true);
		                																						 pncProfileUpdateTab.items && pncProfileUpdateTab.items.items[3] && pncProfileUpdateTab.items.items[3].setDisabled(true)
		                                                                                                     }

		                																				 }
		                																			 }
		                																		 });
		                																	 }
		                																	 else {
		                																		 isRenderInit = false;
		                																	 }
		                																 }
		                															 }
		                															 else {
		                																 var tabPanel =contentpanel.down('#stcPncStudentRegistration');

		                																 if(tabPanel){
		                																	 var cerpController = me,//.getController('menu.CoreERPNavigationController'),
		                																	 pncProfileUpdateTabTitle = getCommonTranslation('PNC_PROFILE_UPDATE'),
		                																	 pncRegistrationTabTitle = getCommonTranslation('PNC_REGISTRATION_DOCUMENTS'),
		                																	 pncProfileUpdateTab = cerpController.getInnerTab(tabPanel,pncProfileUpdateTabTitle);
		                																	 pncProfileUpdateTab.setDisabled(true);
		                																 }
		                															 }

		                															 if(isDocumentApplicable === true){ //TODO: Enable on Next Click and Validation of Profile Update Tab
		                																 // var me = $this;
		                																 /*var tabPanel = contentpanel.down('#stcPncStudentRegistration');
														    							 cerpController = me.getController('menu.CoreERPNavigationController');
														    							 pncRegistrationTabTitle = getCommonTranslation('PNC_REGISTRATION_DOCUMENTS');
														    							 pncRegistrationTab = cerpController.getInnerTab(tabPanel,pncRegistrationTabTitle);
														    							 pncRegistrationTab.setDisabled(false);*/
		                															 } else{
		                																 // var me = $this;
		                																 var tabPanel = contentpanel.down('#stcPncStudentRegistration');
		                																 /*var studentRegistrationTab = tabPanel.down('#pncregistrationdocumentsItemId');
														    							 studentRegistrationTab.setVisible(false);*/
		                																 if(tabPanel){
		                																	 var cerpController = me,//.getController('menu.CoreERPNavigationController');
		                																	 pncRegistrationTabTitle = getCommonTranslation('PNC_REGISTRATION_DOCUMENTS');
		                																	 pncRegistrationTab = cerpController.getInnerTab(tabPanel,pncRegistrationTabTitle);
		                																	 pncRegistrationTab.setDisabled(true);
		                																 }
		                															 }
		                															 
		                															 //-- If profile & document setup is false, redirect to period registration tab (previous functionality)
		                															 var tabPanel = contentpanel.down('#stcPncStudentRegistration');

		                															 if(tabPanel){
		                																 var studentRegistrationTab = tabPanel.down('#pncregistrationdocumentsItemId');
		                																 //studentRegistrationTab.setVisible(false);
		                																 cerpController = me;//.getController('menu.CoreERPNavigationController');

		                																 pncProfileTabTitle = getCommonTranslation('PNC_PROFILE_UPDATE');
		                																 pncProfileTab = cerpController.getInnerTab(tabPanel,pncProfileTabTitle);

		                																 pncDocumentTabTitle = getCommonTranslation('PNC_REGISTRATION_DOCUMENTS');
		                																 pncDocumentTab = cerpController.getInnerTab(tabPanel,pncDocumentTabTitle);

		                																 pncPeriodRegistrationTabTitle = getCommonTranslation('PNC_PERIOD_REGISTRATION');
		                																 pncPeriodRegistrationTab = cerpController.getInnerTab(tabPanel,pncPeriodRegistrationTabTitle);

		                																 pncCourseRegistrationTabTitle = getCommonTranslation('PNC_COURSE_REGISTRATION');
		                																 pncCourseRegistrationTab = cerpController.getInnerTab(tabPanel,pncCourseRegistrationTabTitle);

		                																 if(isRenderInit == true){
			                																 if(isProfileUpdateApplicable == false && isDocumentApplicable == false){
			                																	 pncProfileTab.setDisabled(true);
			                																	 pncDocumentTab.setDisabled(true);
			                																	 pncPeriodRegistrationTab.setDisabled(false);
			                																	 pncCourseRegistrationTab.setDisabled(false);

			                																	 tabPanel.setActiveTab(pncPeriodRegistrationTab);
			                																 }
			                																 else if(isProfileUpdateApplicable == true){
			                																	 pncProfileTab.setDisabled(false);
			                																	 pncDocumentTab.setDisabled(true);
			                																	 pncPeriodRegistrationTab.setDisabled(true);
			                																	 pncCourseRegistrationTab.setDisabled(true);

			                																	 tabPanel.setActiveTab(pncProfileTab);
			                																 }
			                																 else if(isProfileUpdateApplicable == false && isDocumentApplicable == true){
			                																	 pncProfileTab.setDisabled(true);
			                																	 pncDocumentTab.setDisabled(false);
			                																	 pncPeriodRegistrationTab.setDisabled(true);
			                																	 pncCourseRegistrationTab.setDisabled(true);

			                																	 tabPanel.setActiveTab(pncDocumentTab);
			                																 }
		                																 }
		                															 }
		                															 
		                															 if(isProfileUpdateApplicable == false && isDocumentApplicable == false ){
		                																 me.enablePaymentDetailsTabValidation();
		                															 }
		                															 
		                														 }
		                													 }	
		                												 } 
		                											 }
		                										 }	
		                									 }  
		                								 });
		                							 }
		                						 }
		                					 }
		                				 })
		                			 }
		                		 },
								 'studentperiodenrollmentsearch combo[itemId=studentAcademyLocation]':{
		                			 select :function(obj){ 
		                				 var me = this;
		                				 var form =me.getStudentperiodenrollmentsearch();
		                				 
		                				 var studentALField = form.down("#studentAcademyLocation");
		                				 var studentProgramField = form.down("#studentProgramId");
		                				 var studentBatchField = form.down("#studentBatchId");
		                				 
		                				 var studentALStore = studentALField.getStore();
		                				 var studentProgramStore = studentProgramField.getStore();
		                				 var studentBatchStore = studentBatchField.getStore();
		                				 
		                				 var portalId = me.getCurrentLoggedPortalId();
		                				 var currentALId = me.getCurrentAcademyLocation();
		                				 var academyLoc=studentALField.getValue();
									     if(portalId==7){
		                					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var admissionDetails=portalInfo.admissionDetails;
		                				 } else {
		                					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		                					 var admissionDetails=portalInfo.admissionDetails;
		                				 }
									      
									     var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

		                            	   if(portalId==7){
					    					 var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
			                					 var user = portalInfo.student;
					    				 } else {
					    					 var user=me.getCurrentlyLoggedInUser();
			                				 }

					    				 studentProgramStore.getProxy().extraParams = {
		                					 studentId:user.id,
		                					 onlyCurrentRecords: true,
					    					 academyLocationId: studentALField.getValue()
		                				 };
					    				 
					    				 studentBatchField.reset();
					    				 studentBatchField.setDisabled(true);
					    				 
					    				 studentProgramStore.load({
									    	 callback: function(records, operation, success) {
									    		 if (success) {
									    			 var admissionId = studentProgramStore.findRecord('programId',records[0].data.programId).data.admissionId;
									    			 studentBatchStore.getProxy().extraParams.admissionId = admissionId;
									    			 if(records.length > 0){
									    				 if(records.length == 1){
									    					 studentProgramField.setValue(records[0].data.programId);
									    					 studentBatchStore.getProxy().extraParams.programId = records[0].data.programId;
											    			 
											    			 studentBatchStore.load({
		                					 callback: function(records, operation, success) {
		                						 if (success) {
							                							 if(records.length == 1){
							                								 studentBatchField.setValue(records[0].data.id);
							                							 }
							                							 studentBatchField.setDisabled(false);
							                						 }
							                					 }
											    			 });
									    				 }
									    				 if(portalId==3 || portalId==7){
        													 if(!isNullOrEmpty(Ext.ComponentQuery.query('stcpncstudentregistration')[0])){
        														 var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
        														 var getstructureTabs = getstructure.down('tabpanel');
    															 getstructure.programStoreRecord = records;
    															 
    															 //--------
    															 var batchIds = null;
    															 var admissionIds = null;
    																var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
    																
    																if(getstructure && getstructure.programStoreRecord.length && getstructure.down('#stcPncStudentRegistration')){
    													    			batchIds = Ext.Array.pluck(Ext.Array.pluck(getstructure.programStoreRecord,'data'),'batchId').join();
    																	admissionIds = getstructure.programStoreRecord[0].data.admissionId;
    																}
    																allPaymentTerms=null;
    																Ext.Ajax.request({
    																	type : 'rest',
    																	url : SERVERURL.FIND_PAYMENT_TERM_BY_ADMISSION_ID_AND_PERIOD_ID,
    																	params : {
    																		admissionId:admissionIds,
    																		periodId:null,
    																		batchIds: batchIds,
    																		academyLocationId:academyLoc
    																	},
    																	method : 'GET',
    																	success : function(response) {
    																		var data = Ext.decode(response.responseText);
    																		//paymentTermComboStore.removeAll();
    																		allPaymentTerms = data;
    																		//paymentTermComboStore.loadData(data);
    																	}
    																});
        													 }
								    					 }
									    			 }
		                						 }
		                					 }
		                				 });
		                			 }
		                		 },
		                		 'studentperiodenrollmentlist' : {
		                			 render : function(grid) {
		                				 var portalId = this.getCurrentLoggedPortalId();
										 var this$=this;
		                				 if(portalId == 7){
		                					 this.doAccessControlValidation(grid,this.getPARENT_PORTAL_STUDENT_PERIOD_REGISTRATION_PERMISSIONS());
		                					 this.disableStudentPeriodEnrollmentPivileges(grid,this.getPARENT_PORTAL_STUDENT_PERIOD_REGISTRATION_PERMISSIONS());
		                				 }else{
		                					 this.doAccessControlValidation(grid,this.getSTUDENT_PERIOD_REGISTRATION_PERMISSIONS());
		                					 this.disableStudentPeriodEnrollmentPivileges(grid,this.getSTUDENT_PERIOD_REGISTRATION_PERMISSIONS());
		                				 }
										setTimeout(function() {
		                				 this$.loadStudentOptPeriodEnrollGrid();
										},3000);
		                			 },
		                			 afterrender: function(grid) {
		                				var portalId = this.getCurrentLoggedPortalId();
		             					var me = this;
		             					setTimeout(function(){
		             						if(portalId == 3){
		             							me.addDataGridConfigButton(grid,me.getSTUDENT_PERIOD_REGISTRATION_PERMISSIONS());
		             						}else {
		             							me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_STUDENT_PERIOD_REGISTRATION_PERMISSIONS());
		             						}
		             					}, 1500);
		             				},
		                			 selectionchange: function(column, selected) {
		                				 var $this=this;
		                				 var grid = this.getStudentperiodenrollmentlist();
		                				 if(selected.length>0){
		                					 var periodId=selected[0].data.periodId;
		                					 var periodName=selected[0].data.periodName;
		                					 var periodEnd=selected[0].data.periodEnd; 
		                					 var programBatchStudentId = selected[0].data.programBatchStudentId;
		                					 $this.loadStudentPeriodRegistrationSetupDetail(periodId,grid,periodName,periodEnd);
		                				 }
		                			 }
		                		 },
		                		 'studentregistrationdocumentgrid' : {
		                			 render : function(grid) {
		                				 var $this = this;
		                				 var portalId = $this.getCurrentLoggedPortalId();
		                				 if(portalId==7){
		                					 var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
		                					 var user = portalInfo.student;
		                				 } else {
		                					 var user=$this.getCurrentlyLoggedInUser();
		                				 } 
		                				 var studentId = user.id;
		                				 var gridStore = grid.getStore();
		                				 gridStore.getProxy().extraParams = {
		                					 studentId:user.id,
		                				 };
		                				 gridStore.on('load', function(store, records){
		                					 if(grid.up('#stcPncStudentRegistration')){
			                					 var cerpController = $this,//this$.getController('menu.CoreERPNavigationController'),
			                					 pncPeriodRegistrationTabTitle = getCommonTranslation('PNC_PERIOD_REGISTRATION'),
			                					 pncCourseRegistrationTabTitle = getCommonTranslation('PNC_COURSE_REGISTRATION'),
			                					 pncPaymentDetailsTabTitle = getCommonTranslation('PNC_PAYMENT_DETAILS'),
			                					 pncPeriodRegistrationTab = cerpController.getInnerTab(grid.up('#stcPncStudentRegistration'),pncPeriodRegistrationTabTitle),
			                					 pncCourseRegistrationTab = cerpController.getInnerTab(grid.up('#stcPncStudentRegistration'),pncCourseRegistrationTabTitle),
			                					 pncPaymentDetailsTab = cerpController.getInnerTab(grid.up('#stcPncStudentRegistration'),pncPaymentDetailsTabTitle);
			                					 
			                					 if(records.length){
			                						 if(records[0].data.isAllMandatoryDocSubmitted == true){
			                							 pncPeriodRegistrationTab.setDisabled(false);
			                							 pncCourseRegistrationTab.setDisabled(false);
			                							 if(pncPaymentDetailsTab){
				                							 pncPaymentDetailsTab.setDisabled(true);
			                							 }
			                							 $this.enablePaymentDetailsTabValidation();
			                						 }
			                						 else{
			                							 pncPeriodRegistrationTab.setDisabled(true);
			                							 pncCourseRegistrationTab.setDisabled(true);
			                							 if(pncPaymentDetailsTab){
				                							 pncPaymentDetailsTab.setDisabled(true);
			                							 }
			                						 }
			                					 }
			                					 else{
			                						 pncPeriodRegistrationTab.setDisabled(false);
		                							 pncCourseRegistrationTab.setDisabled(false);
		                							 if(pncPaymentDetailsTab){
		                								 pncPaymentDetailsTab.setDisabled(true);
		                							 }
		                							 $this.enablePaymentDetailsTabValidation();
			                					 }
		                					 }
		                				 });
		                				 gridStore.load();
		                				 /*gridStore.load({
		         	            			callback: function(records, operation, success) {
		        	            				if (success) {
		        	            					if(records.length > 0 && records[0].data.isAllMandatoryDocSubmitted == true){
		        	            						//grid.up().down('#btnSubmit').setDisabled(false);
		        	            					} else{
		        	            						//grid.down('#btnSubmit').setDisabled(true);
		        	            					}
		        	            				}
		        	            			}
		        	            		});*/
		                			 },
		                			 selectionchange: function(column, selected) {
		                				 var $this=this;
		                				 var grid = this.getStudentregistrationdocumentgrid();
		                				 var btnUpload = grid.down('#btnUpload');
		                				 if(selected.length>0){
		                					 btnUpload.setDisabled(false);
		                				 } else{
		                					 btnUpload.setDisabled(true);
		                				 }
		                			 },
		                			 cellclick: function(View, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		         	    				var $this = this;
		         	    				var grid = $this.getStudentregistrationdocumentgrid();
		         	    				var columnName = grid.columnManager.columns[cellIndex].dataIndex;

		         	    				if (e.target.tagName == 'A') {
		         	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
		         	    					if(dataIndex == 'fileName'){
		         	    						var documentId = record.get("documentId");
		         	    						if(!isNullOrEmpty(documentId)){
			                   						 if (e.target.tagName == 'A') {
			                   							$this.getDocumentController().downloadDocumentFile(documentId);
			                   						 }
			                   					 }
		         	    					}
		         	    				}
		         	    			},
		                		 },
		                		 'pncregistrationpaymentdetailsgrid':{
		                			 afterrender: function(grid){
		                				 var me = this;
		                				 var associatedAcadLocationIds = new Array();
		         	               		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		         	               		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_REGISTRATION_PAYMENT_DETAILS_PERMISSIONS());
		         	                 	var btnPayNowId = grid.down('#btnPayNowId');
		         	                 	btnPayNowId.setVisible(false);
		         	               		Ext.each(permissionList, function(privilege) {
		         	               			if (privilege === 'PAY_NOW') {
		         	               				if(!isNullOrEmpty(btnPayNowId)){
		         	               				btnPayNowId.setVisible(true);
		         	               				}        		
		         	               			}
		         	               		});
		                				 var userInfo = Academia.model.authentication.UserInfoModel;
		                				 var studentId = userInfo.get("userId");
		                				 var gridStore = grid.getStore();
		                				 gridStore.getProxy().extraParams = {
		                					 studentId:studentId
		                				 };
		                				 gridStore.load({
		                					 callback:function(records){
		                						 var columnModel = [];
		                						 columnModel.push({
		                						        header: getCommonTranslation('PERIOD'),
		                						        dataIndex: 'periodName',
		                						        flex: 1,
		                						        sortable: true,
		                						    }, {
		                						        header: getCommonTranslation('PAYMENT_TERM'),
		                						        dataIndex: 'paymentTerm',
		                						        flex: 1,
		                						        sortable: true
		                						    }, {
		                						        header: getCommonTranslation('COURSE_CODE_NAME'),
		                						        dataIndex: 'courseCodeName',
		                						        flex: 1,
		                						        sortable: true
		                						    });
		                						 var models = grid.getStore().getRange();
		                						 for(var i in records) {
		            				                 if(!isNullOrEmpty(records[i].data.feeHeadName)){
		                				                 var count=0;
		                				                 for(var k in records[i].data.feeHeadName){
		                				                	 if(!isNullOrEmpty(models[i])){
		                    				                 models[i].set('moduleFeeForHeads'+count,records[i].data.feeHeadName[k].moduleFee);
		                				                	 }
		                    				                 count++;
		                				                 }
		            				                 }
		        				                 }
		                						if(records.length && records[0].data.feeHeadName.length> 0){
		                							for(var i=0;i< records[0].data.feeHeadName.length;i++){
		                								 var column = Ext.create('Ext.grid.column.Column', {
			                        						 header:  records[0].data.feeHeadName[i].feeHeadName,
			                        						 dataIndex: 'moduleFeeForHeads'+i,
			                        						 sortable: true,
			                        						 flex: 1,
			                        						 summaryType: 'sum',
			                        						 renderer: function(value, summaryData, record) {
			                        							 if(!isNullOrEmpty(value) && value==0){
			                        								 return '<span></span>';
			                        							 }else{
			                        								 if(!isNullOrEmpty(value)){
			                        									 return currencyRenderer(value,record.get("currencyId"));
			                        								 }
			                        							 }
			                        						 }
			                							 });
		                								 columnModel.push(column) ;   
		                							}
		                							
		                						}
		                						 var column = Ext.create('Ext.grid.column.Column', {
		                						        header: getCommonTranslation('COURSE_FEE'),
		                						        dataIndex: 'moduleFee',
		                						        flex: 1,
		                						        sortable: true,
		                						        summaryType: 'sum',
		                						        renderer: function(value, summaryData, record) {
		                						        	if(!isNullOrEmpty(value) && value==0){
		                						        		return '<span></span>';
		                						        	}else{
		                						        		if(!isNullOrEmpty(value)){
		                						        			return currencyRenderer(value,record.get("currencyId"));
		                						        		}
		                						        	}
		                						        }
		                						    });
                								 columnModel.push(column) ;  
		                						 grid.reconfigure(null,columnModel);
		                        				 grid.getView().refresh();
		                					 }
		                				 });
		                			 },
		                			 selectionchange: function(column, selected) {
		                				 var $this=this;
		                				 var grid = column.view.up('grid');
		                				 var btnNext = grid.down('#btnNext');
		                				 if(selected.length>0){
		                					 if(!isNullOrEmpty(selected[0].data.registrationTermSetupDetailId) && !isNullOrEmpty(selected[0].data.whetherRegistrationContractApplicable) && selected[0].data.whetherRegistrationContractApplicable){
		                						 btnNext.setDisabled(false);
		                					 }
		                					 else{
		                						 btnNext.setDisabled(true);
		                					 }
		                				 } else{
		                					 btnNext.setDisabled(true);
		                				 }
		                			 },
		                		 },
		                		 'pncregistrationpaymentdetailsgrid button[itemId=btnNext]':{
		                			 click: function(btn) {
		                				 var $this=this;
		                				 var grid = btn.up('pncregistrationpaymentdetailsgrid');
		                				 var selected = grid.getSelectionModel().getSelection()[0].data;
		                				 var admissionId = selected.admissionId;
		                				 var periodId = selected.periodId;
		                				 Ext.Ajax.request({
	                						   url : SERVERURL.PATH_FIND_STUDENT_CONTRACT_DETAILS+'?admissionId='+admissionId+'&periodId='+periodId,
	                						   headers: {
	                							   'Content-Type': 'application/json'
	                						   },
	                						   method : 'GET',
	                						   success : function(response) {
	                							   Ext.getBody().unmask();
	                							   var response = Ext.decode(response.responseText);
	                							   if(response.length && response[0].id && !isNullOrEmpty(response[0].id)){
	                								   var formWin = $this.getStudentportalregistrationcontractwindow();
	                								   if (!formWin) {
	                									   Ext.widget('studentportalregistrationcontractwindow',{
	                										   itemId:'studentportalregistrationcontractwindow',
	                										   winData: response[0]
	                									   });
	                									   formWin = $this.getStudentportalregistrationcontractwindow();
	                								   }
	                								   formWin.show();
	                							   }
	                							   else{
	                								   //--not opening window here
	                								   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('REGISTRATION_CONTRACT_ERROR_MESSAGE'));
	                								   //not between the dates & already submitted
	                							   }
	                						   }
	                					   });
		                			 }
		                		 },
		                		 'studentportalregistrationcontractwindow':{
		                			 afterrender: function(win){
		                				 var me = this;
		                				 var winData = win.winData;
		                				 var registrationContractMsgContent = winData.registrationContractMsgContent;
		                				 var registrationContractTncLink = isNullOrEmpty(winData.termAndConditionLink) ? '#' : winData.termAndConditionLink;
		                				 var registrationContractMsg = registrationContractMsgContent+"<br />"+getCommonTranslation('REGISTRATION_CONTACT_MSG')+"<br /><a target='_blank' href='[LINK]'>"+getCommonTranslation('REGISTRATION_CONTACT_TNC_LINK')+"</a><br /><br />";
		                				 if(!isNullOrEmpty(winData.termAndConditionOne)){
		                					 registrationContractMsg = registrationContractMsg+"<input type='checkbox' name='check1' onchange='regContractAcceptCheck(this);'> "+winData.termAndConditionOne+" <br />";
		                				 }
		                				 if(!isNullOrEmpty(winData.termAndConditionTwo)){
		                					 registrationContractMsg = registrationContractMsg+"<input type='checkbox' name='check2' onchange='regContractAcceptCheck(this);'> "+winData.termAndConditionTwo+" <br />";
		                				 }
		                				 if(!isNullOrEmpty(winData.termAndConditionThree)){
		                					 registrationContractMsg = registrationContractMsg+"<input type='checkbox' name='check3' onchange='regContractAcceptCheck(this);'> "+winData.termAndConditionThree+" <br />";
		                				 }
		                				 registrationContractMsg = registrationContractMsg+"<br />"+getCommonTranslation('REGISTRATION_CONTACT_ACCEPT_MSG');
		                				 
		                				 var finalMessage = registrationContractMsg;

		                				 for(inc=0; inc<3;inc++){
		                					 finalMessage = finalMessage.replace("[ACADEMY_LOCATION]",winData.academyLocationName);
		                					 finalMessage = finalMessage.replace("[STUDENT_NAME]",winData.studentName);
		                					 finalMessage = finalMessage.replace("[STUDENT_ID]",winData.studentCode);
		                					 finalMessage = finalMessage.replace("[PROGRAM_NAME]",winData.programName);
		                					 finalMessage = finalMessage.replace("[PROGRAM_CODE]",winData.programCode);
		                					 finalMessage = finalMessage.replace("[SAQA_ID]", (isNullOrEmpty(winData.saqaId) ? "-" : winData.saqaId) );
		                					 finalMessage = finalMessage.replace("[LINK]",registrationContractTncLink );
		                				 }
		                				 
		                				 if(isNullOrEmpty(winData.termAndConditionOne) && isNullOrEmpty(winData.termAndConditionTwo) && isNullOrEmpty(winData.termAndConditionThree)){
		                					 win.down('#btnWinSubmit').setDisabled(false);
		                				 }
		                				 
		                				 win.down('#windowContent').body.setHTML(finalMessage);
		                			 }
		                		 },
		                		 'studentportalregistrationcontractwindow[itemId=studentportalregistrationcontractwindow] button[itemId=btnWinSubmit]':{
		                			 click: function(btn){
		                				 
		                				 var me = this;
		                				 var win = btn.up('window');
		                				 var grid = this.getPncregistrationpaymentdetailsgrid();
		                				 var winData = win.winData;
		                				 var admissionId = winData.admissionId;
		                				 var periodId = winData.periodId;
		                				 var registrationTermSetupDetailId = winData.registrationTermSetupDetailId;
		                				 
		                				 Ext.Ajax.request({
		         	            			url : SERVERURL.PATH_STUDENT_CONTRACT_ACCEPTANCE_SAVE+"?admissionId="+admissionId+"&periodId="+periodId+"&registrationTermSetupDetailId="+registrationTermSetupDetailId,
		         	            			method : 'POST',
		         	            			success : function(response) {
		         	            				Ext.getBody().unmask();
		         	            				win.close();
		         	            				grid.getStore().load();
		         	            				var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getDMSTranslation("SUCCESS")+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation("REGISTRATION_CONTRACT_SUBMIT_SUCCESS_MSG")+'</span>';
		         	       					var box2 =Ext.Msg.show({
		         	       					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
		         	   						msg	: msg,
		         	   						buttons	: Ext.MessageBox.OK,
		         	   						icon: Ext.Msg.INFO,
		         	   						cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
		         	   						fn	: function(response){
		         	   							if(response=="ok"){
		         	   							 var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
       	            						   var getstructureTabs = getstructure.down('tabpanel');
       	            						   getstructureTabs.setActiveTab(0);
		         	   							}
		         	   						}
		         	       					});	
		         	       					box2.removeCls('newClsMessageConfirmBox');
		         	       					box2.dockedItems.items[1].layout.pack = "end";
		         	       					box2.doLayout();
		         	       					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');
		         	            				
		         	            			}
		         	            		});
		                			 }
		                		 },
		                		 'studentportalregistrationcontractwindow[itemId=courseRegistrationStudentPortalContractWindow] button[itemId=btnWinSubmit]':{
		                			 click: function(btn){
		                				 
		                				 var me = this;
		                				 var win = btn.up('window');
		                				 var grid = this.getPncregistrationpaymentdetailsgrid();
		                				 var winData = win.winData;
		                				 var admissionId = winData.admissionId;
		                				 var periodIds = win.periodIds.split(',');
		                				 var registrationTermSetupDetailId = winData.registrationTermSetupDetailId;
		                				 
		                				 try{
			                				 grid.down('#btnNext').hide();
		                				 }
		                				 catch(e){
		                					 //--
		                				 }
		                				 win.close();
		                				 var callBackFn = function(){
		                					 Ext.Ajax.request({
			                					 url : SERVERURL.PATH_STUDENT_CONTRACT_ACCEPTANCE_SAVE+"?admissionId="+admissionId+"&periodIds="+periodIds+"&registrationTermSetupDetailId="+registrationTermSetupDetailId,
			                					 method : 'POST',
			                					 success : function(response) {
		                							 
		                							 grid.getStore().load();
		                							 
		                							 setTimeout(function(){
				                						 Ext.getBody().unmask();
				                						 
				                						 var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
                										 var getstructureTabs = getstructure.down('tabpanel');
                										 setTimeout(function(){
																getstructureTabs.items.items[4].setDisabled(false);
																getstructureTabs.setActiveTab(4);
                										 },500);
                										 
			                							 /*Ext.Msg.show({
			                								 title:getDMSTranslation("SUCCESS"),
			                								 msg: getCommonTranslation("REGISTRATION_CONTRACT_SUBMIT_SUCCESS_MSG"),
			                								 buttons: Ext.Msg.OK,
			                								 fn: function(btn){
			                									 if(btn=="ok"){
			                										 var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
			                										 var getstructureTabs = getstructure.down('tabpanel');
			                										 getstructureTabs.setActiveTab(4);
			                									 }
			                								 }
			                							 });*/
		                							 },1000);
			                					 }
			                				 });
		                				 }
		                				 
		                				 var isEnrolledSuccess = win.enrollmentFunctionParams.me.saveStudentPortalAllEnrollmentDetailGrid(win.enrollmentFunctionParams.btn, win.enrollmentFunctionParams.text, win.enrollmentFunctionParams.tempStore, win.enrollmentFunctionParams.whetherFuturePeriod, win.enrollmentFunctionParams.grid, win.enrollmentFunctionParams.gridRecord, false, callBackFn);
	                					 
		                				 //if(isEnrolledSuccess){
		                					 
		                				 /*}
		                				 else{
		                					 win.close();
                							 grid.getStore().load();
                							 Ext.getBody().unmask();
		                				 }*/
		                			 }
		                		 },
		                		 'studentregistrationdocumentgrid button[itemId=btnUpload]': {
		                     	    click: function() {
		                     	        var formWin = this.getStudentregistrationdocumentuploadwindow();
		                     	        if (!formWin) {
		                     	            Ext.widget('studentregistrationdocumentuploadwindow');
		                     	            formWin = this.getStudentregistrationdocumentuploadwindow();
		                     	        }
		                     	        this.showStudentRegistrationDocumentUploadWindow(formWin);
		                     	        //formWin.show();
		                     	    }
		                     	},
		                     	'studentregistrationdocumentuploadwindow button[itemId=documentFormSubmitButtonId]': {
		                        	click: function() {
		                        		this.saveStudentRegistrationDocumentFormData();
		                        	}
		                        },
		                        'studentregistrationdocumentuploadwindow button[itemId=documentCancelButtonId]': {
		                        	click : function() {
		        						var $this=this;
		                				var form=$this.getStudentregistrationdocumentuploadwindow();
		                				form.close();
		        					}
		                        },
		                        'stcpncstudentregistration addressdisplaypanel':{
		                        	resize: function(pnl){
		                        		var me = this;
		                        		var addressTab = pnl.up('tabpanel').getActiveTab();
		                        		me.changeAllButtonsStates(addressTab);
		                        	}
		                        }
	                	   });
	                	   }
	                   ,
	                   openPeriodEnrollToWindow:function(){
	                	   var contentPanel = this.getContentPanel();
	                	   var formWindow = this.getEnrolltoperiodenrollmentwin();
	                	   if (!formWindow) {
	                		   Ext.widget('enrolltoperiodenrollmentwin');
	                		   formWindow = this.getEnrolltoperiodenrollmentwin();
	                	   }
	                	   formWindow.show();
	                	   /* var win = this.getEnrolltoperiodenrollmentwin();
                    	   var AL = win.down('#academyLocation');
                    	   AL.getStore().getProxy().extraParams={
                    		   purpose:'COURSE_EXECUTION',
                    		   placementCampusId : placementCampusId
                    	   };
                    	   var AL = win.down('#programId');
                    	   AL.getStore().getProxy().extraParams={
                    		   purpose:'COURSE_EXECUTION'
                    	   };

                    	   AL.getStore().load();*/
	                   },
	                   openStudentPeriodEnrollTab:function(){
	                	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                	   var structure = Ext.widget('managestudentenrollmentstructure');
	                	   var tabName = getCommonTranslation('PERIOD_ENROLLMENT');
	                	   /**
	                	    * This is to remove tab from content panel and open same tab again
	                	    */
	                	   var getcontroller=this;//.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentPanel.remove(getTab, true);
	                	   }
	                	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);		
	                   },
	                 //Disable  Privileges button 
	                   disableStudentPeriodEnrollmentPivileges: function(gridReference,permissionsMap) {

	               		var associatedAcadLocationIds = new Array();
	               		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	               		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	               		buttonsToolBar = gridReference.query('toolbar')[0];
	               		buttonsToolBar.setVisible(false);
	               		var saveBtn = buttonsToolBar.query('#save')[0];
//	               		saveBtn.setVisible(false);
	               		Ext.each(permissionList, function(privilege) {
	               			if (privilege === 'ENROLL') {
	               				if(!isNullOrEmpty(saveBtn)){
	               					saveBtn.setVisible(true);
	               				}        		
	               			}
	               		});
	               		buttonsToolBar.setVisible(true);
	               	},
	               	studentRequestOptionalPeriodEnroll : function(grid) {
	            		var $this = this;
	            		var records=grid.getSelectionModel().getSelection();
	            		var record = records[0].data;
	            		var optionalFormData = new Academia.model.AbstractDataModel;
	            		// optionalFormData.set("requestDate", new Date());
	            		optionalFormData.set("optionPeriodId", record.periodId);
	            		var students = [];
	            		students.push({
	            			"admissionId" : record.admissionId,
	            			"programBatchStudentId" : record.programBatchStudentId
	            		});
	            		optionalFormData.set("students", students);
	            		$this.studentPostDataToEnroll(optionalFormData, false);
	            	},
	            	studentPostDataToEnroll : function(formData, window) {
	            		var submitData = Ext.encode(formData.data);
	            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	            		Ext.Ajax.request({
	            			url : SERVERURL.SAVE_OPTIONAL_PERIOD,
	            			jsonData : submitData,
	            			method : 'POST',
	            			success : function(response) {
	            				Ext.getBody().unmask();
	            				var mssg = response.responseText;
	            				if (mssg == 'SUCCESS') {
	            					showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('OPTIONAL_PERIOD_REQUEST_SAVED'));
	            				}
	            			}
	            		});
	            	},
	            	loadStudentOptPeriodEnrollGrid : function(){
	            		var form = this.getStudentperiodenrollmentsearch();
				//		var studentAcademyLocationId = form.down("#studentAcademyLocation");
	            		var studentProgramId = form.down("#studentProgramId");
	            		var studentBatchId = form.down("#studentBatchId");
	            		var grid =this.getStudentperiodenrollmentlist();
	            		var showEnrollmentMessageId=grid.down('#showEnrollmentMessageId');
	            		showEnrollmentMessageId.setVisible(false);
	            		var store=grid.getStore();
	            		var portalId = this.getCurrentLoggedPortalId();
	            		if(portalId==7){
	            			var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	            			var user = portalInfo.student;
	            		}else
	            		{
	            			var user=this.getCurrentlyLoggedInUser();
	            		}
	            		store.getProxy().extraParams={
	            			studentId:user.id,
	            			programId:studentProgramId.value,
	            			batchId:studentBatchId.value,
	            			portalId:portalId
					//		academyLocationId:studentAcademyLocationId.value
	            		}
	            		store.load({
	            			callback: function(records, operation, success) {
	            				if (success) {
	            					for(i in records){
	            						if(records[i].data.whetherOptional && records[i].data.enrollmentLastDate >= new Date()
	            						&& records[i].data.status=="Pending"){
	            							grid.getSelectionModel().select(records[i],true);
	            						}
	            						if(records[i].data.status!="Pending" || !records[i].data.whetherOptional){
	            							grid.getSelectionModel().setDisabled=true;
	            						}
	            					}
	            				}
	            			}
	            		});
	            	},
	            	loadStudentPeriodRegistrationSetupDetail:function(periodId,grid,periodName,periodEndDate){
	            		var $this=this;
	            		var records = grid.getSelectionModel().getSelection();
	            		var admissionId=null;
	            		if(records.length>0){
	            			admissionId = records[0].data.admissionId;
	            		}
	            		
	            		var academicTermId = academicTermId = records[0].data.academicTermId;
	            		var isYearlySetup = records[0].data.isYearlySetup;
	            		
	            		var today = Ext.Date.format(new Date(), 'Y-m-d'); 
	            		Ext.Ajax.request({
	            			type: 'rest',
	            			url: SERVERURL.PATH_FIND_COURSE_REGISTRATION_SETUP_DETAIL_FOR_STUDENT_BY_PERIODID,
	            			method: 'GET',
	            			params:{
	            				periodId:periodId,
	            				admissionId:admissionId,
	            				academicTermId: academicTermId,
	            				isYearlySetup : isYearlySetup
	            				
	            			},
	            			success: function(f, action) {
	            				var showEnrollmentMessageId=grid.down('#showEnrollmentMessageId');
	            				var enrollTo=grid.down('#save');
	            				enrollTo.setDisabled(true);
	            				if (!isNullOrEmpty(f.responseText)) {
	            					var data = f.responseText;
	            					var jData=Ext.JSON.decode(data);
	            					if(jData.whetherRegistration==true){
	            						showEnrollmentMessageId.setValue("<font color='green'>" +getProgramandcourseTranslation('REGISTRATION_ENDS_ON')+" "
	            								+ dateTimeRender(jData.studentPeriodEndDate)+"</font>");
	            						showEnrollmentMessageId.show();
	            						enrollTo.setDisabled(false);
	            						if(jData.holdErrorMsg=="COURSE_ENROLLMENT_HOLD"){
		            						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
		            						showEnrollmentMessageId.setValue("<font color='red'>" + showEnrollmentMessageId.getValue()+ "</br> " +getCommonTranslation('HOLD_IS_APPLIED')+"</font>");
		            						showEnrollmentMessageId.show();
		            						enrollTo.setDisabled(true);
		            					}
	            						if(jData.holdErrorMsg=="FINANCE_HOLD"){
	                						//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOLD_IS_APPLIED'));
	            							showEnrollmentMessageId.setValue("<font color='red'>" +showEnrollmentMessageId.getValue()+ "</br> " +getCommonTranslation('FINANCE_HOLD_IS_APPLIED')+"</font>");
	    									//showStudentEnrollmentMessageId.show();
	            							enrollTo.setDisabled(true);
	                					}
	            					}else{
	            						if(jData.currentDate<jData.studentPeriodStartDate){
	            							showEnrollmentMessageId.setValue("<font color='#808080'>" +getProgramandcourseTranslation('REGISTRATION_START')+" "+getProgramandcourseTranslation('FROM')
	            									+" "+  dateTimeRender(jData.studentPeriodStartDate)+" "+getProgramandcourseTranslation('TO')+" "+dateTimeRender(jData.endDate)+"</font>");
	            						}else if(jData.currentDate>jData.studentPeriodEndDate){
	            							showEnrollmentMessageId.setValue("<font color='red'>" +getProgramandcourseTranslation('REGISTRATION_END')+" "
	            									+ dateTimeRender(jData.studentPeriodEndDate)+"</font>");
	            						}
	            						showEnrollmentMessageId.show();
	            					}
	            				}else{
	            					showEnrollmentMessageId.setValue("<font color='#808080'>" +getProgramandcourseTranslation('THE_REGISTRATION_IS_NOT_REQUIRED_FOR')+" "+periodName+"</font>");
	            					showEnrollmentMessageId.show();
	            				}
	            				//var rc=grid.getSelectionModel().getSelection();
	            				/*if(isNullOrEmpty(rc[0].data.programBatchStudentId)){
	            					enrollTo.setDisabled(true);
	            				}*/
	            				var periodStatus = grid.getSelectionModel().getSelection()[0].data.status;
	            				if(today > periodEndDate || periodStatus != 'Pending'){
	            					enrollTo.setDisabled(true);
	            				}
	            			},
	            			failure: function(result, request) {
	            				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
	            				return false;
	            			}
	            		});
	            	},
	            	
	            	innerTabBackButtonHandler: function(button){
	            		var me = this,
	            			tabPanel = button.up('tabpanel'),
	            			currentActiveTab = tabPanel.getActiveTab(),
	            			currentActiveTabIndex = currentActiveTab.tabIndexNumber,
	            			studentPersonalController = me,//this$.getController('personinfo.student.StudentPersonalController'),
	            			button;
	            		
	            		if(!isNullOrEmpty(currentActiveTab.down('personalinformationform'))){
	            			//save info
	            			button = currentActiveTab.down('#personalInfoSaveButtonId');
	            			studentPersonalController.saveStudentPersonalInformation(button);
	            		}
	            		
	            		tabPanel.setActiveTab(currentActiveTabIndex-1);
	            	},
	            	
	            	innerTabNextButtonHandler: function(button){
	            		var me = this,
	            		tabPanel = button.up('tabpanel'),
            			currentActiveTab = tabPanel.getActiveTab(),
            			currentActiveTabIndex = currentActiveTab.tabIndexNumber,
            			studentPersonalController = me, //this$.getController('personinfo.student.StudentPersonalController'),
            			button;
	            		
	            		if(!isNullOrEmpty(currentActiveTab.down('personalinformationform'))){
	            			//saveInfo
	            			button = currentActiveTab.down('#personalInfoSaveButtonId');
	            			me.getController('personinfo.student.StudentPersonalController').saveStudentPersonalInformation(button);
	            		}
            		
	            		tabPanel.setActiveTab(currentActiveTabIndex+1);
	            	},
	            	
	            	innerTabSubmitButtonHandler: function(button){
	            		//--working on callback to close tab TODO
	            		if(button.up('#stcPncStudentRegistration')){
	            			var me = this,
	            			personCommonController = this$.getController('personinfo.common.PersonCommonController'),
	            			contentPanelActiveTab = this$.getActiveTabfromContentPanel(),
	            			tabPanel = button.up('tabpanel'),
	            			cerpController = me,//this$.getController('menu.CoreERPNavigationController'),
	            			studentPersonalController = me, //this$.getController('personinfo.student.StudentPersonalController'),
	            			pncRegistrationTabTitle = getCommonTranslation('PNC_REGISTRATION_DOCUMENTS'),
	            			pncProfileUpdateTabTitle = getCommonTranslation('PNC_PROFILE_UPDATE'),
	            			pncPeriodRegistrationTabTitle = getCommonTranslation('PNC_PERIOD_REGISTRATION'),
	            			pncCourseRegistrationTabTitle = getCommonTranslation('PNC_COURSE_REGISTRATION'),
	            			pncPaymentDetailsTabTitle = getCommonTranslation('PNC_PAYMENT_DETAILS'),
	            			pncProfileUpdateTab = cerpController.getInnerTab(button.up('#stcPncStudentRegistration'),pncProfileUpdateTabTitle),
	            			pncRegistrationTab = cerpController.getInnerTab(button.up('#stcPncStudentRegistration'),pncRegistrationTabTitle),
	            			pncPeriodRegistrationTab = cerpController.getInnerTab(button.up('#stcPncStudentRegistration'),pncPeriodRegistrationTabTitle),
	            			pncCourseRegistrationTab = cerpController.getInnerTab(button.up('#stcPncStudentRegistration'),pncCourseRegistrationTabTitle),
	            			pncPaymentDetailsTab = cerpController.getInnerTab(button.up('#stcPncStudentRegistration'),pncPaymentDetailsTabTitle),
	            			personalTabTitle = getCommonTranslation('TAB_PERSONAL'),
	            			addressTabTitle = getCommonTranslation('TAB_ADDRESS'),
	            			feePayerTabTitle = getCommonTranslation('TAB_FEE_PAYER_DETAILS'),
	            			personalTab = cerpController.getInnerTab(pncProfileUpdateTab,personalTabTitle),
	            			addressTab = cerpController.getInnerTab(pncProfileUpdateTab,addressTabTitle),
	            			feePayerTab = cerpController.getInnerTab(pncProfileUpdateTab,feePayerTabTitle),
	            			callBackFn = function(isDataValid){
	            				if(isDataValid){
	            					var stcpncstudentregistration = pncRegistrationTab.up('stcpncstudentregistration');
	            					if(stcpncstudentregistration.isDocumentApplicable){
	            						pncRegistrationTab.setDisabled(false);
	            						//pncPeriodRegistrationTab.setDisabled(true);
	            						//pncCourseRegistrationTab.setDisabled(true);
	            						//pncPaymentDetailsTab.setDisabled(true);
	            						button.up('#stcPncStudentRegistration').setActiveTab(pncRegistrationTab); //setting document tab active
	            						pncRegistrationTab.down('studentregistrationdocumentgrid').setVisible(true);
	            					}
	            					else{
	            						pncRegistrationTab.setDisabled(true);
	            						pncPeriodRegistrationTab.setDisabled(false);
	            						pncCourseRegistrationTab.setDisabled(false);
	            						if(pncPaymentDetailsTab){
	            							pncPaymentDetailsTab.setDisabled(true);
	            						}
	            						button.up('#stcPncStudentRegistration').setActiveTab(pncPeriodRegistrationTab); //setting period registration tab active
	            						me.enablePaymentDetailsTabValidation();
	            					}
	            				}
	            				else{
	            					pncRegistrationTab.setDisabled(true);
	            					pncPeriodRegistrationTab.setDisabled(true);
	            					pncCourseRegistrationTab.setDisabled(true);
	            					if(pncPaymentDetailsTab){
	            						pncPaymentDetailsTab.setDisabled(true);
	            					}
	            				}
	            			};

	            			//--Check if Address & FeePayer Inner Tabs are available and validate
	            			var personObj = personCommonController.getPersonObj();
	            			var personId = personObj["id"];
	            			if(addressTab && feePayerTab){
	            				var addressGetURL = SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS;

	            				Ext.Ajax.request({
	            					url : addressGetURL+'?personId='+personId,
	            					headers: {
	            						'Content-Type': 'application/json'
	            					},
	            					method : 'GET',
	            					success : function(response) {
	            						var responseText = Ext.decode(response.responseText);
	            						var isAddressValid = me.isAddressValid(responseText, addressTab);
	            						if(isAddressValid){
	            							//--- check fee-payer tab
	            							var feepayerStore = feePayerTab.down('grid').store;
	            							if(portalId==3){
	            								feepayerStore.getProxy().api.read = SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID;
	            							}
	            							feepayerStore.getProxy().extraParams.personId = personId;
	            							feepayerStore.load({
	            								callback: function(records, operation, success){
	            									if(records.length){
	            										callBackFn(true);
	            									}
	            								}
	            							});
	            						}
	            						else{
	            							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EMPTY_ADDRESS_MSG'));
	            						}
	            					}
	            				});
	            			}
	            			else if(addressTab && !feePayerTab){
	            				var addressGetURL = SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS;
	            				
	            				Ext.Ajax.request({
	            					url : addressGetURL+'?personId='+personId,
	            					headers: {
	            						'Content-Type': 'application/json'
	            					},
	            					method : 'GET',
	            					success : function(response) {
	            						var responseText = Ext.decode(response.responseText);
	            						var isAddressValid = me.isAddressValid(responseText, addressTab);
	            						if(isAddressValid){
	            							callBackFn(true);
	            						}
	            						else{
	            							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EMPTY_ADDRESS_MSG'));
	            						}
	            					}
	            				});
	            			}
	            			else if(!addressTab && feePayerTab){
	            				//--- check fee-payer tab
	            				var feepayerStore = feePayerTab.down('grid').store;
	            				feepayerStore.getProxy().extraParams.personId = personId;
	            				feepayerStore.load({
	            					callback: function(records, operation, success){
	            						if(records.length){
	            							callBackFn(true);
	            						}
	            					}
	            				});
	            			}else{
	            				callBackFn(true);
	            			}
	            		}
	            		
	            		
	            		/*if(personalTab) {
	            			//saveInfo
	            			button = personalTab.down('#personalInfoSaveButtonId');
	            			studentPersonalController.saveStudentPersonalInformation(button, callBackFn);
	            		}
	            		else {
	            			callBackFn();
	            		}*/
	            	},
	            	
	            	enablePaymentDetailsTabValidation: function(){
	            		var me = this;
	            		var currentALId = me.getCurrentAcademyLocation();
	            		var batchIds = null;
	            		var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
	            		
	            		if(getstructure && getstructure.programStoreRecord.length && getstructure.down('#stcPncStudentRegistration')){
	            			batchIds = Ext.Array.pluck(Ext.Array.pluck(getstructure.programStoreRecord,'data'),'batchId').join();
	            			
	            			var cerpController = me,//this$.getController('menu.CoreERPNavigationController'),
		            		pncPaymentDetailsTabTitle = getCommonTranslation('PNC_PAYMENT_DETAILS'),
		            		pncPaymentDetailsTab = cerpController.getInnerTab(getstructure.down('#stcPncStudentRegistration'),pncPaymentDetailsTabTitle);
		            		
		            		if(portalId==7){
		            			var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		            			var user = portalInfo.student;
		            		}else
		            		{
		            			var user=this.getCurrentlyLoggedInUser();
		            		}
		            		if(pncPaymentDetailsTab){
		            			Ext.Ajax.request({
		            				url : SERVERURL.PATH_GET_WHETHER_STUDENT_PAYMENT_TERM_MAPPED,
		            				headers: {
		            					'Content-Type': 'application/json'
		            				},
		            				params:{
		            					studentId: user.id,
		            					batchIds : batchIds,
		            					academyLocationId: currentALId
		            				},
		            				method : 'GET',
		            				success : function(response) {
		            					var responseText = Ext.decode(response.responseText);
		            					if(responseText){
		            						pncPaymentDetailsTab.setDisabled(false);
		            						//getstructure.down('#stcPncStudentRegistration').setActiveTab(pncPaymentDetailsTab);
		            					}
		            					else{
		            						pncPaymentDetailsTab.setDisabled(true);
		            					}
		            				}
		            			});
		            		}
	            		}
	            	},
	            	
	            	showStudentRegistrationDocumentUploadWindow : function(formWin){
	            		var $this = this;
	            		var grid = $this.getStudentregistrationdocumentgrid();
	            		var records =grid.getSelectionModel().getSelection()[0];
	            		var documentId = records.get("studentDocumentTypeId");
						var isPreDefined = true;
						var documentTypeId = records.get("documentTypeId");
						
						formWin.down('#documentTypeCombo').setValue(documentTypeId);
						formWin.down('#document_hidden_field').setValue(documentId);
						formWin.down('#isPreDefined').setValue(isPreDefined);
						formWin.down('#isInspectionDone').setValue(false);
						formWin.down('#documentStatus').setValue('SUBMITTED');
						formWin.down('#submissionDate').setValue(new Date());
	            		formWin.show();
	            	},
	            	getDocumentController : function(){
	                	var this$ = this;
	                	return this$.getController('Academia.controller.document.DocumentController');
	                },
	            	saveStudentRegistrationDocumentFormData : function(){
	    			    var $this = this;
	    		    	var successMsg, submitUrl;
	    		    	var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal()
	    		    	var admissionId = portalInfo.admissionDetails[0].id;
	    		    	var portalId = $this.getCurrentLoggedPortalId();
	    		    	if(portalId==7){
	       					 var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	       					 var user = portalInfo.student;
	       				 } else {
	       					 var user=$this.getCurrentlyLoggedInUser();
	       				 }
	    		    	var studentId = user.id;
	                    var grid = $this.getStudentregistrationdocumentgrid();
	    		    	//var grid = $this.getStudentOnlineDocumentGrid();
	    		    	var isTransient = false;
	    		    	var module = 'student';
	    		    	var entityId = studentId;
	    		    	var entityType = 'student';
	    		    	var formWin = $this.getStudentregistrationdocumentuploadwindow();
	    		    	var form = formWin.down('#onlineDocumentFormItemId');
	    		    	var uploadBtn=formWin.down('#uploadFileField');
	    		    	var records =grid.getSelectionModel().getSelection()[0];
	    		    	if(!isNullOrEmpty(records)){
	    		    		var formData = null;
	    	    			var editedPath=form.down('#uploadFileField');
	    	    			var path=null;
	    	    			var fileField = form.down('#fileDisplayField');
	    	    			formData = form.getValues();    
	    	    			if(!isNullOrEmpty(editedPath.getValue())){
	    	    				//edit document with file
	    	    				/*if(!isNullOrEmpty(records.data.documentType.id))
	        					{
	        					var otherDocTypeId = records.data.documentType.id;
	        					}*/
	    	    				$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'STUDENT_REGISTRATION_DOC_FORM', function(success, response, isCallBackTransient){

	    	    					if(success){
	    	    						var documentJson = new Object();
	    	    						if(isCallBackTransient == false){
	    	    							var formWin = $this.getStudentregistrationdocumentuploadwindow();
	    	    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
	    	    			    	    	var id = form.down('#document_hidden_field');
	    	    							if (isNullOrEmpty(id.getSubmitValue())) {
	    	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
	    	    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	    	    							}else{
	    	    								submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
	    	    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
	    	    								if (grid.getSelectionModel().getCount() > 0) {
	    	    									var records = grid.getSelectionModel().getSelection()[0];
	    	    									documentJson.id = records.get("studentDocumentId");
	    	    								}

	    	    							}
	    	    							var documentId = Ext.JSON.decode(response.responseText);
	    	    							var student = new Object();
	    	    							var document = new Object();
	    	    							var admission = new Object();

	    	    							student.id = studentId;
	    			    					admission.id = admissionId;
	    			    					document.id = documentId;
	    			    					documentJson.student = student;
	    			    					documentJson.document = document;
	    			    					documentJson.isElectronic = true;
	    			    					documentJson.admission = admission;
	    	    							
	    	    							var docType = form.down('#documentTypeCombo').getValue();
	    	    							var documentStatus = form.down('#documentStatus').getValue();
	    	    							if(!isNullOrEmpty(docType)){
	    	    								documentJson.documentType = {
	    	        									id: docType
	    	        							};
	    	    							}
	    	    							/*if(!isNullOrEmpty(documentStatus)){
	    	    							documentJson.documentStatusCSM = {
	    	    									id: documentStatus
	    	    							};
	    	    						}*/
	    	    							documentJson.status = documentStatus;
	    	    							Ext.Ajax.request({
	    	    								type: 'rest',
	    	    								url: submitUrl,
	    	    								jsonData: documentJson,
	    	    								method: 'POST',
	    	    								success : function(){
	    	    									$this.getStudentregistrationdocumentuploadwindow().close();
	    	    									grid.getStore().reload();
	    	    									grid.getSelectionModel().deselectAll();
	    	    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	    	    								}
	    	    							});
	    	    						}
	    	    					}
	    	    				}, isTransient/*,otherDocTypeId*/);
	    	    			
	    	    			}
	    		    	}
	    		 
	            	},
	            	
	            	//V2D-399739-A : Function to check and enable Other tabs automatically if all details are already filled under Registration->Profile
	            	checkAllDetailsFilled: function(profileTabs){
	            		var firstProfileTab = profileTabs[0];
	            		var innerTabNextButton = firstProfileTab.down('#innerTabNextButton');
	            		this.innerTabSubmitButtonHandler(firstProfileTab);
	            	},
	            	
	            	changeAllButtonsStates: function(tab){
	            		var pncprofileupdate = Ext.ComponentQuery.query('#pncprofileupdateItemId')[0];
	            		var personCommonController = this$.getController('personinfo.common.PersonCommonController');
	            		var cerpController = this;//this$.getController('menu.CoreERPNavigationController');

	            		if(Ext.isDefined(pncprofileupdate)){
	            			var profileTabs = pncprofileupdate.items.items;
	            			setTimeout(function(){
	            				if(typeof firstCallCompleted == "undefined"){
	            					cerpController.checkAllDetailsFilled(profileTabs);
	            				}
	            				firstCallCompleted = true;
	            			},1000);
	            			if (this$.getContentpanel().getActiveTab().down("personalinformationform") && !this$.getContentpanel().getActiveTab().down("personalinformationform").isValid()) {
	                            Ext.app.profileUpdateButtonsDisable = true
	                        } else {
	                            Ext.app.profileUpdateButtonsDisable = false
	                        }
	            			Ext.each(profileTabs, function(currentProfileTab){
	            				if(!isNullOrEmpty(currentProfileTab)){
	            					var innerTabBackButton = currentProfileTab.down('#innerTabBackButton');
	            					var innerTabNextButton = currentProfileTab.down('#innerTabNextButton');
	            					var innerTabSubmitButton = currentProfileTab.down('#innerTabSubmitButton');
	            					var errorMsgShow2 = currentProfileTab.down("#errorMsgShow2");
	                                var errorMsgShow1 = currentProfileTab.down("#errorMsgShow1");

	            					if(!isNullOrEmpty(innerTabBackButton)){
	            						innerTabBackButton.setDisabled(Ext.app.profileUpdateButtonsDisable);
	            						innerTabBackButton.isVisible() && errorMsgShow1.setVisible(Ext.app.profileUpdateButtonsDisable)
	            					}
	            					if(!isNullOrEmpty(innerTabNextButton)){
	            						innerTabNextButton.setDisabled(Ext.app.profileUpdateButtonsDisable);
	            					}
	            					if(!isNullOrEmpty(innerTabSubmitButton)){
	            						innerTabSubmitButton.setDisabled(Ext.app.profileUpdateButtonsDisable);
	            					}

	            					if(!isNullOrEmpty(tab)){
	            						if(currentProfileTab.title==getCommonTranslation('TAB_PARENTS') && currentProfileTab == tab){
	            							var personObj = personCommonController.getPersonObj();
	            							var personId = personObj["id"];
	            							var parentsGetUrl = SERVERURL.PARENT_AND_GUARDIAN_DETAILS;
	            							Ext.Ajax.request({
	            								url : parentsGetUrl+'?personId='+personId,
	            								headers: {
	            									'Content-Type': 'application/json'
	            								},
	            								method : 'GET',
	            								success : function(response) {
	            									var responseText = Ext.decode(response.responseText);
	            									//if(responseText.length){
	            										if(currentProfileTab.registrationSetupParentDetails && currentProfileTab.registrationSetupParentDetails.length){
	            											if(Ext.Array.pluck(currentProfileTab.registrationSetupParentDetails,'whetherMandatory').indexOf(true) == -1){
	            												currentProfileTab.registrationSetupParentDetails = [{
	            													parentCode: "LG", /*LOCAL_GUARDIAN*/
	            													whetherMandatory: false
	            												},{
	            													parentCode: "PG1", /*FATHER*/
	            													whetherMandatory: false
	            												},{
	            													parentCode: "G", /*GUARDIAN*/
	            													whetherMandatory: false
	            												},{
	            													parentCode: "PG2", /*MOTHER*/
	            													whetherMandatory: false
	            												}]
	            											}
	            											
	            											if(Ext.Array.pluck(currentProfileTab.registrationSetupParentDetails,'whetherMandatory').indexOf(true) == -1){ //Default functionality if all are false
	            												if(!isNullOrEmpty(innerTabNextButton)){
			            											innerTabNextButton.setDisabled(false);
			            										}
			            										if(!isNullOrEmpty(innerTabSubmitButton)){
			            											innerTabSubmitButton.setDisabled(false);
			            										}
	            											}
	            											else{
	            												var enableBtn = true;
	            												var filledRelationshipArray = Ext.Array.pluck(responseText,'relationship');
	            											
	            												for (var i = 0; i < filledRelationshipArray.length; i++) {
	            												    switch (filledRelationshipArray[i]) {
	            												        case "FATHER":
	            												        	filledRelationshipArray[i] = "PG1";
	            												            break;
	            												        case "MOTHER":
	            												        	filledRelationshipArray[i] = "PG2";
	            												            break;
	            												        case "LOCAL_GUARDIAN":
	            												        	filledRelationshipArray[i] = "LG";
	            												            break;
	            												        case "GUARDIAN":
	            												        	filledRelationshipArray[i] = "G";
	            												            break;
	            												    }
	            												}
	            												
	            												Ext.each(currentProfileTab.registrationSetupParentDetails, function(currentRegistrationSetupParent){
	            													if(currentRegistrationSetupParent.whetherMandatory == true){
	            														var fIndex = filledRelationshipArray.indexOf(currentRegistrationSetupParent.parentCode);
	            														if(fIndex == -1){
	            															enableBtn = false;
	            														}
	            													}
	            												});
	            												if(enableBtn == true){
	            													if(!isNullOrEmpty(innerTabNextButton)){
	    		            											innerTabNextButton.setDisabled(false);
	    		            										}
	    		            										if(!isNullOrEmpty(innerTabSubmitButton)){
	    		            											innerTabSubmitButton.setDisabled(false);
	    		            										}
	            												}
	            												else{
	            													if(!isNullOrEmpty(innerTabNextButton)){
	        	            											innerTabNextButton.setDisabled(true);
	        	            										}
	        	            										if(!isNullOrEmpty(innerTabSubmitButton)){
	        	            											innerTabSubmitButton.setDisabled(true);
	        	            										}
	            												}
	            											}
	            										}
	            										else{ //Default functionality if all are false
	            											if(!isNullOrEmpty(innerTabNextButton)){
		            											innerTabNextButton.setDisabled(false);
		            										}
		            										if(!isNullOrEmpty(innerTabSubmitButton)){
		            											innerTabSubmitButton.setDisabled(false);
		            										}
	            										}
	            									/*}
	            									else{
	            										if(!isNullOrEmpty(innerTabNextButton)){
	            											innerTabNextButton.setDisabled(true);
	            										}
	            										if(!isNullOrEmpty(innerTabSubmitButton)){
	            											innerTabSubmitButton.setDisabled(true);
	            										}
	            									}*/
	            								}
	            							});
	            						}
	            						else if(currentProfileTab.title==getCommonTranslation("TAB_ADDRESS") && currentProfileTab == tab){
	            							var personObj = personCommonController.getPersonObj();
	            							var personId = personObj["id"];
	            							var addressGetURL = SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS;
	            							Ext.Ajax.request({
	            								url : addressGetURL+'?personId='+personId,
	            								headers: {
	            									'Content-Type': 'application/json'
	            								},
	            								method : 'GET',
	            								success : function(response) {
	            									var responseText = Ext.decode(response.responseText);
	            									if(responseText.length){
	            										if(currentProfileTab.registrationSetupAddress && currentProfileTab.registrationSetupAddress.length){
	            											
	            											if(Ext.Array.pluck(currentProfileTab.registrationSetupAddress,'whetherMandatory').indexOf(true) == -1){
	            												currentProfileTab.registrationSetupAddress = [{
	            													addressCode: "PRMNT",
	            													whetherMandatory: false
	            												},{
	            													addressCode: "OFC",
	            													whetherMandatory: false
	            												},{
	            													addressCode: "CRNT",
	            													whetherMandatory: true
	            												},{
	            													addressCode: "CRSPDNC",
	            													whetherMandatory: false
	            												},{
	            													addressCode: "GOOGLE",
	            													whetherMandatory: false
	            												}]
	            											}
	            											
	            											if(Ext.Array.pluck(currentProfileTab.registrationSetupAddress,'whetherMandatory').indexOf(true) == -1){ //Default functionality if all are false
	            												if(!isNullOrEmpty(innerTabNextButton)){
			            											innerTabNextButton.setDisabled(false);
			            										}
			            										if(!isNullOrEmpty(innerTabSubmitButton)){
			            											innerTabSubmitButton.setDisabled(false);
			            										}
	            											}
	            											else{
	            												var enableBtn = true;
	            												var filledAddressCodeArray = Ext.Array.pluck(Ext.Array.pluck(responseText,'addressType'),'code');
	            												Ext.each(currentProfileTab.registrationSetupAddress, function(currentRegistrationSetupAddress){
	            													if(currentRegistrationSetupAddress.whetherMandatory == true){
	            														var fIndex = filledAddressCodeArray.indexOf(currentRegistrationSetupAddress.addressCode);
	            														if(fIndex == -1){
	            															enableBtn = false;
	            														}
	            													}
	            												});
	            												if(enableBtn == true){
	            													if(!isNullOrEmpty(innerTabNextButton)){
	    		            											innerTabNextButton.setDisabled(false);
	    		            										}
	    		            										if(!isNullOrEmpty(innerTabSubmitButton)){
	    		            											innerTabSubmitButton.setDisabled(false);
	    		            										}
	            												}
	            												else{
	            													if(!isNullOrEmpty(innerTabNextButton)){
	        	            											innerTabNextButton.setDisabled(true);
	        	            										}
	        	            										if(!isNullOrEmpty(innerTabSubmitButton)){
	        	            											innerTabSubmitButton.setDisabled(true);
	        	            										}
	            												}
	            											}
	            										}
	            										else{ //Default functionality if all are false
	            											if(!isNullOrEmpty(innerTabNextButton)){
		            											innerTabNextButton.setDisabled(false);
		            										}
		            										if(!isNullOrEmpty(innerTabSubmitButton)){
		            											innerTabSubmitButton.setDisabled(false);
		            										}
	            										}
	            									}
	            									else{
	            										if(!isNullOrEmpty(innerTabNextButton)){
	            											innerTabNextButton.setDisabled(true);
	            										}
	            										if(!isNullOrEmpty(innerTabSubmitButton)){
	            											innerTabSubmitButton.setDisabled(true);
	            										}
	            									}
	            								}
	            							});
	            						}
	            						else if(currentProfileTab.title==getCommonTranslation("TAB_FEE_PAYER_DETAILS") && currentProfileTab == tab && tab.up('#stcPncStudentRegistration')){
	            							//--- check fee-payer tab
	            							var pncProfileUpdateTab = cerpController.getInnerTab(tab.up('#stcPncStudentRegistration'),getCommonTranslation('PNC_PROFILE_UPDATE'));
	            							var feePayerTab = cerpController.getInnerTab(pncProfileUpdateTab,'Fee Payer Details');
	            							var feepayerStore = feePayerTab.down('grid').store;
	            							if(feepayerStore.getCount()){
	            								if(!isNullOrEmpty(innerTabNextButton)){
	            									innerTabNextButton.setDisabled(false);
	            								}
	            								if(!isNullOrEmpty(innerTabSubmitButton)){
	            									innerTabSubmitButton.setDisabled(false);
	            								}
	            							}
	            							else{
	            								if(!isNullOrEmpty(innerTabNextButton)){
	            									innerTabNextButton.setDisabled(true);
	            								}
	            								if(!isNullOrEmpty(innerTabSubmitButton)){
	            									innerTabSubmitButton.setDisabled(true);
	            								}
	            							}
	            						}
	            					}
	            				}
	            			});
	            		}
	            	},
	            	
	            	onPeriodRegistrationGridEnrollBtnClick: function(grid, whetherAutoApproved, whetherOptionalPeriod, id, records, portalId, user, paymentTermId){
	            		var $this = this;

	            		var promotionStatus="ENROLLED";
	            		if(!whetherAutoApproved || whetherOptionalPeriod){
	            			promotionStatus="REQUEST_RECEIVED";
	            		}
	            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	            		var programBatchStudentIds = id;

	            		if(!isNullOrEmpty(programBatchStudentIds)){
	            			Ext.Ajax.request({
	            				url : SERVERURL.PATH_APPROVE_OR_ENROLL_PROGRAM_BATCH_STUDENT+'?programBatchStudentIds='+programBatchStudentIds+'&promotionStatus='+promotionStatus
	            				+"&whetherOptionalPeriod="+whetherOptionalPeriod+"&admissionId="+records[0].data.admissionId+"&portalId="+portalId+
	            				'&periodId='+records[0].data.periodId+'&studentId='+user.id+'&paymentTermId='+paymentTermId,
	            				headers: {
	            					'Content-Type': 'application/json'
	            				},
	            				method : 'GET',
	            				success : function(response) {
	            					Ext.getBody().unmask();
	            					var mssg = response.responseText;
	            					if (mssg == 'SUCCESS') {
	            						if(whetherAutoApproved){
	            							showSuccessMessage(getCommonTranslation('STUDENT_REGISTRATION'), getCommonTranslation('PERIOD_REGISTRATION_IS_COMPLETED'));
	            						}else{
	            							showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('THE_STUDENT_PERIOD_REGISTRATION_IS_PENDING_FOR_THE_APPROVAL'));
	            						}
	            						grid.getStore().reload();
	            						grid.getSelectionModel().deselectAll(true);
	            						grid.down('#save').setDisabled(true);
	            						$this.enablePaymentDetailsTabValidation();
	            						/*if(!isNullOrEmpty(registrationProcessReq) && registrationProcessReq == true){
                  						   if(!isNullOrEmpty(Ext.ComponentQuery.query('stcpncstudentregistration')[0])){
                  							   var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
                  							   var getstructureTabs = getstructure.down('tabpanel');
                  							   getstructureTabs.setActiveTab(1);
                  							   courseRegistrationController.loadCourseRegistrationTab();
                  							}
                  					   }*/
	            					}
	            				}
	            			});
	            		} else{
	            			promotionStatus="IN_PROGRESS";
	            			if(!whetherAutoApproved || whetherOptionalPeriod){
	            				promotionStatus="REQUEST_RECEIVED";
	            			}
	            			Ext.Ajax.request({
	            				url : SERVERURL.PATH_STUDENT_PERIOD_ENROLLMENT_CREATE+'?periodId='+records[0].data.periodId+'&studentId='+user.id+'&status='+promotionStatus+
	            				"&whetherOptionalPeriod="+whetherOptionalPeriod+"&admissionId="+records[0].data.admissionId+'&paymentTermId='+paymentTermId,
	            				headers: {
	            					'Content-Type': 'application/json'
	            				},
	            				method : 'POST',
	            				success : function(response) {
	            					Ext.getBody().unmask();
	            					var mssg = response.responseText;
	            					if (mssg == 'SUCCESS') {
	            						if(whetherAutoApproved){
	            							showSuccessMessage(getCommonTranslation('STUDENT_REGISTRATION'), getCommonTranslation('PERIOD_REGISTRATION_IS_COMPLETED'));
	            						}else{
	            							showSuccessMessage(getCommonTranslation('PERIOD_ENROLLMENT'), getProgramandcourseTranslation('THE_STUDENT_PERIOD_REGISTRATION_IS_PENDING_FOR_THE_APPROVAL'));
	            						}
	            						grid.getStore().reload();
	            						grid.getSelectionModel().deselectAll(true);
	            						grid.down('#save').setDisabled(true);
	            						$this.enablePaymentDetailsTabValidation();
	            						/*if(!isNullOrEmpty(registrationProcessReq) && registrationProcessReq == true){
                  						   if(!isNullOrEmpty(Ext.ComponentQuery.query('stcpncstudentregistration')[0])){
                  							   var getstructure = Ext.ComponentQuery.query('stcpncstudentregistration')[0];
                  							   var getstructureTabs = getstructure.down('tabpanel');
                  							   getstructureTabs.setActiveTab(1);
                  							   courseRegistrationController.loadCourseRegistrationTab();
                  							}
                  					   }*/
	            					}
	            				}
	            			});
	            		}
	            	},
	            	
	            	isAddressValid: function(responseText, currentProfileTab){
	            		var isAddressValid = true;
						if(responseText.length){
							if(currentProfileTab.registrationSetupAddress && currentProfileTab.registrationSetupAddress.length){
								
								if(Ext.Array.pluck(currentProfileTab.registrationSetupAddress,'whetherMandatory').indexOf(true) == -1){
									currentProfileTab.registrationSetupAddress = [{
										addressCode: "PRMNT",
										whetherMandatory: false
									},{
										addressCode: "OFC",
										whetherMandatory: false
									},{
										addressCode: "CRNT",
										whetherMandatory: true
									},{
										addressCode: "CRSPDNC",
										whetherMandatory: false
									},{
										addressCode: "GOOGLE",
										whetherMandatory: false
									}]
								}
								
								
								if(Ext.Array.pluck(currentProfileTab.registrationSetupAddress,'whetherMandatory').indexOf(true) == -1){ //Default functionality if all are false
									isAddressValid = true;
								}
								else{
									var enableBtn = true;
									var filledAddressCodeArray = Ext.Array.pluck(Ext.Array.pluck(responseText,'addressType'),'code');
									Ext.each(currentProfileTab.registrationSetupAddress, function(currentRegistrationSetupAddress){
										if(currentRegistrationSetupAddress.whetherMandatory == true){
											var fIndex = filledAddressCodeArray.indexOf(currentRegistrationSetupAddress.addressCode);
											if(fIndex == -1){
												enableBtn = false;
											}
										}
									});
									if(enableBtn == true){
										isAddressValid = true;
									}
									else{
										isAddressValid = false;
									}
								}
							}
							else{ //Default functionality if all are false
								isAddressValid = true;
							}
						}
						else{
							isAddressValid = false;
						}
						return isAddressValid;
	            	}
});
